/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower.calls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.backend.js.JsIntrinsics;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.lower.calls.CallsLoweringUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.lower.calls.CallsTransformer;
import org.jetbrains.kotlin.ir.backend.js.lower.calls.EqualityAndComparisonCallsTransformer;
import org.jetbrains.kotlin.ir.backend.js.lower.calls.PrimitiveType;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.descriptors.IrBuiltIns;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrDynamicType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.KotlinTypeKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\rH\u0002J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\rH\u0016J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\rH\u0002J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\rH\u0002J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\rH\u0002J\f\u0010\u0016\u001a\u00020\u0017*\u00020\rH\u0002J\u000e\u0010\u0018\u001a\u0004\u0018\u00010\u0019*\u00020\u001aH\u0002J\f\u0010\u001b\u001a\u00020\u0017*\u00020\u001cH\u0002J\f\u0010\u001d\u001a\u00020\u0017*\u00020\u001cH\u0002J\f\u0010\u001e\u001a\u00020\u0017*\u00020\u001cH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f0\nj\u0002`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/calls/EqualityAndComparisonCallsTransformer;", "Lorg/jetbrains/kotlin/ir/backend/js/lower/calls/CallsTransformer;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "intrinsics", "Lorg/jetbrains/kotlin/ir/backend/js/JsIntrinsics;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;", "symbolToTransformer", "", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "Lorg/jetbrains/kotlin/ir/backend/js/lower/calls/SymbolToTransformer;", "chooseEqualityOperatorForPrimitiveTypes", "call", "transformCall", "transformCompareToMethodCall", "transformEqeqOperator", "transformEqualsMethodCall", "allValueArgumentsAreNullable", "", "findEqualsMethod", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "Lorg/jetbrains/kotlin/ir/types/IrType;", "isEqualsInheritedFromAny", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "isMethodOfPotentiallyPrimitiveJSType", "isMethodOfPrimitiveJSType", "backend.js"})
public final class EqualityAndComparisonCallsTransformer
implements CallsTransformer {
    private final JsIntrinsics intrinsics;
    private final IrBuiltIns irBuiltIns;
    private final Map<IrFunctionSymbol, Function1<IrCall, IrExpression>> symbolToTransformer;

    @Override
    @NotNull
    public IrExpression transformCall(@NotNull IrCall call2) {
        Intrinsics.checkParameterIsNotNull((Object)call2, (String)"call");
        IrFunctionSymbol symbol2 = call2.getSymbol();
        Function1<IrCall, IrExpression> function1 = this.symbolToTransformer.get(symbol2);
        if (function1 != null) {
            Function1<IrCall, IrExpression> function12;
            Function1<IrCall, IrExpression> it = function12 = function1;
            return (IrExpression)it.invoke((Object)call2);
        }
        Name name = symbol2.getOwner().getName();
        return Intrinsics.areEqual((Object)name, (Object)Name.identifier("compareTo")) ? this.transformCompareToMethodCall(call2) : (Intrinsics.areEqual((Object)name, (Object)Name.identifier("equals")) ? this.transformEqualsMethodCall(call2) : (IrExpression)call2);
    }

    private final IrExpression transformEqeqOperator(IrCall call2) {
        boolean isLhsPrimitive;
        IrExpression irExpression = call2.getValueArgument(0);
        if (irExpression == null) {
            Intrinsics.throwNpe();
        }
        IrExpression lhs = irExpression;
        IrExpression irExpression2 = call2.getValueArgument(1);
        if (irExpression2 == null) {
            Intrinsics.throwNpe();
        }
        IrExpression rhs = irExpression2;
        PrimitiveType lhsJsType = CallsLoweringUtilsKt.getPrimitiveType(lhs.getType());
        PrimitiveType rhsJsType = CallsLoweringUtilsKt.getPrimitiveType(rhs.getType());
        IrSimpleFunction equalsMethod = this.findEqualsMethod(lhs.getType());
        boolean bl = isLhsPrimitive = lhsJsType != PrimitiveType.OTHER;
        return lhs.getType() instanceof IrDynamicType ? (IrExpression)IrUtilsKt.irCall$default((IrMemberAccessExpression)call2, this.intrinsics.getJsEqeq().getSymbol(), false, false, 12, null) : (IrUtilsKt.isNullConst(lhs) || IrUtilsKt.isNullConst(rhs) ? (IrExpression)IrUtilsKt.irCall$default((IrMemberAccessExpression)call2, this.intrinsics.getJsEqeq().getSymbol(), false, false, 12, null) : (isLhsPrimitive && lhsJsType == rhsJsType && lhsJsType != PrimitiveType.FLOATING_POINT_NUMBER ? this.chooseEqualityOperatorForPrimitiveTypes(call2) : (!isLhsPrimitive && !KotlinTypeKt.isNullable(IrTypesKt.toKotlinType(lhs.getType())) && equalsMethod != null ? (IrExpression)IrUtilsKt.irCall$default((IrMemberAccessExpression)call2, equalsMethod.getSymbol(), false, true, 4, null) : (IrExpression)IrUtilsKt.irCall$default((IrMemberAccessExpression)call2, this.intrinsics.getJsEquals(), false, false, 12, null))));
    }

    private final IrExpression chooseEqualityOperatorForPrimitiveTypes(IrCall call2) {
        return this.allValueArgumentsAreNullable(call2) ? IrUtilsKt.irCall$default((IrMemberAccessExpression)call2, this.intrinsics.getJsEqeq().getSymbol(), false, false, 12, null) : IrUtilsKt.irCall$default((IrMemberAccessExpression)call2, this.intrinsics.getJsEqeqeq().getSymbol(), false, false, 12, null);
    }

    private final boolean allValueArgumentsAreNullable(@NotNull IrCall $receiver) {
        boolean bl;
        block4: {
            Iterable $receiver$iv = (Iterable)RangesKt.until((int)0, (int)$receiver.getValueArgumentsCount());
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator2 = $receiver$iv.iterator();
                while (iterator2.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator2).nextInt();
                    IrExpression irExpression = $receiver.getValueArgument(it);
                    if (irExpression == null) {
                        Intrinsics.throwNpe();
                    }
                    if (IrTypeUtilsKt.isNullable(irExpression.getType())) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final IrExpression transformCompareToMethodCall(IrCall call2) {
        IrFunction irFunction = call2.getSymbol().getOwner();
        if (irFunction == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrSimpleFunction");
        }
        IrSimpleFunction function2 = (IrSimpleFunction)irFunction;
        if (!(function2.getParent() instanceof IrClass)) {
            return call2;
        }
        transformCompareToMethodCall.1 isFakeOverriddenFromComparable$ = transformCompareToMethodCall.1.INSTANCE;
        return this.isMethodOfPrimitiveJSType(function2) || isFakeOverriddenFromComparable$.invoke(function2) ? IrUtilsKt.irCall$default((IrMemberAccessExpression)call2, this.intrinsics.getJsCompareTo(), true, false, 8, null) : call2;
    }

    private final IrExpression transformEqualsMethodCall(IrCall call2) {
        IrFunction function2 = call2.getSymbol().getOwner();
        return !this.isEqualsInheritedFromAny(function2) ? call2 : (IrUtilsKt.isSuperToAny(call2) ? IrUtilsKt.irCall$default((IrMemberAccessExpression)call2, this.intrinsics.getJsEqeqeq().getSymbol(), true, false, 8, null) : (this.isMethodOfPotentiallyPrimitiveJSType(function2) ? IrUtilsKt.irCall$default((IrMemberAccessExpression)call2, this.intrinsics.getJsEquals(), true, false, 8, null) : call2));
    }

    private final IrSimpleFunction findEqualsMethod(@NotNull IrType $receiver) {
        boolean bl;
        Iterable $receiver$iv$iv;
        IrClass irClass = IrTypesKt.getClass($receiver);
        if (irClass == null) {
            return null;
        }
        IrClass klass2 = irClass;
        if (IrUtilsKt.isEnumClass(klass2) && klass2.isExternal()) {
            return null;
        }
        Iterable $receiver$iv = klass2.getDeclarations();
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            if (!(element$iv$iv instanceof IrSimpleFunction)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            IrSimpleFunction it = (IrSimpleFunction)element$iv$iv;
            if (!(this.isEqualsInheritedFromAny(it) && !IrUtilsKt.isFakeOverriddenFromAny(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        List it = list2;
        boolean bl2 = bl = it.size() <= 1;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return (IrSimpleFunction)CollectionsKt.singleOrNull((List)list2);
    }

    private final boolean isMethodOfPrimitiveJSType(@NotNull IrFunction $receiver) {
        IrValueParameter irValueParameter;
        IrValueParameter it;
        IrValueParameter irValueParameter2 = $receiver.getDispatchReceiverParameter();
        return irValueParameter2 != null ? CallsLoweringUtilsKt.getPrimitiveType((it = (irValueParameter = irValueParameter2)).getType()) != PrimitiveType.OTHER : false;
    }

    private final boolean isMethodOfPotentiallyPrimitiveJSType(@NotNull IrFunction $receiver) {
        return this.isMethodOfPrimitiveJSType($receiver) || IrUtilsKt.isFakeOverriddenFromAny($receiver);
    }

    private final boolean isEqualsInheritedFromAny(@NotNull IrFunction $receiver) {
        return Intrinsics.areEqual((Object)$receiver.getName(), (Object)Name.identifier("equals")) && $receiver.getDispatchReceiverParameter() != null && $receiver.getValueParameters().size() == 1 && IrTypePredicatesKt.isNullableAny($receiver.getValueParameters().get(0).getType());
    }

    public EqualityAndComparisonCallsTransformer(@NotNull JsIrBackendContext context) {
        Map<IrFunctionSymbol, Function1<IrCall, IrExpression>> map2;
        Map map3;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.intrinsics = context.getIntrinsics();
        this.irBuiltIns = context.getIrBuiltIns();
        EqualityAndComparisonCallsTransformer equalityAndComparisonCallsTransformer = this;
        equalityAndComparisonCallsTransformer.symbolToTransformer = map3 = (Map)new LinkedHashMap();
        Map<IrFunctionSymbol, Function1<IrCall, IrExpression>> $receiver = map2 = this.symbolToTransformer;
        CallsLoweringUtilsKt.add$default($receiver, this.irBuiltIns.getEqeqeqSymbol(), this.intrinsics.getJsEqeqeq(), false, 4, null);
        CallsLoweringUtilsKt.add($receiver, this.irBuiltIns.getEqeqSymbol(), (Function1<? super IrCall, ? extends IrExpression>)((Function1)new Function1<IrCall, IrExpression>(this){

            @NotNull
            public final IrExpression invoke(@NotNull IrCall p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return EqualityAndComparisonCallsTransformer.access$transformEqeqOperator((EqualityAndComparisonCallsTransformer)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(EqualityAndComparisonCallsTransformer.class);
            }

            public final String getName() {
                return "transformEqeqOperator";
            }

            public final String getSignature() {
                return "transformEqeqOperator(Lorg/jetbrains/kotlin/ir/expressions/IrCall;)Lorg/jetbrains/kotlin/ir/expressions/IrExpression;";
            }
        }));
        CallsLoweringUtilsKt.add($receiver, this.irBuiltIns.getIeee754equalsFunByOperandType(), (Function1<? super IrCall, ? extends IrExpression>)((Function1)new Function1<IrCall, IrExpression>(this){

            @NotNull
            public final IrExpression invoke(@NotNull IrCall p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return EqualityAndComparisonCallsTransformer.access$chooseEqualityOperatorForPrimitiveTypes((EqualityAndComparisonCallsTransformer)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(EqualityAndComparisonCallsTransformer.class);
            }

            public final String getName() {
                return "chooseEqualityOperatorForPrimitiveTypes";
            }

            public final String getSignature() {
                return "chooseEqualityOperatorForPrimitiveTypes(Lorg/jetbrains/kotlin/ir/expressions/IrCall;)Lorg/jetbrains/kotlin/ir/expressions/IrExpression;";
            }
        }));
        CallsLoweringUtilsKt.add$default($receiver, this.irBuiltIns.getBooleanNotSymbol(), this.intrinsics.getJsNot(), false, 4, null);
        CallsLoweringUtilsKt.add($receiver, this.irBuiltIns.getLessFunByOperandType(), this.intrinsics.getJsLt());
        CallsLoweringUtilsKt.add($receiver, this.irBuiltIns.getLessOrEqualFunByOperandType(), this.intrinsics.getJsLtEq());
        CallsLoweringUtilsKt.add($receiver, this.irBuiltIns.getGreaterFunByOperandType(), this.intrinsics.getJsGt());
        CallsLoweringUtilsKt.add($receiver, this.irBuiltIns.getGreaterOrEqualFunByOperandType(), this.intrinsics.getJsGtEq());
    }

    public static final /* synthetic */ IrExpression access$transformEqeqOperator(EqualityAndComparisonCallsTransformer $this, IrCall call2) {
        return $this.transformEqeqOperator(call2);
    }

    public static final /* synthetic */ IrExpression access$chooseEqualityOperatorForPrimitiveTypes(EqualityAndComparisonCallsTransformer $this, IrCall call2) {
        return $this.chooseEqualityOperatorForPrimitiveTypes(call2);
    }
}

