/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.prefs;

import java.util.ArrayList;
import java.util.List;
import java.util.prefs.BackingStoreException;
import org.protege.editor.core.prefs.Preferences;

public class JavaBackedPreferencesImpl
implements Preferences {
    public static final String PROTEGE_PREFS_KEY = "PROTEGE_PREFERENCES";
    private java.util.prefs.Preferences preferences;
    private final String setID;
    private final String prefsID;

    public JavaBackedPreferencesImpl(String setID, String prefsID) {
        this.setID = setID;
        this.prefsID = prefsID;
        this.init();
    }

    private void init() {
        this.preferences = java.util.prefs.Preferences.userRoot().node(PROTEGE_PREFS_KEY).node(this.setID).node(this.prefsID);
    }

    @Override
    public void clear() {
        try {
            this.preferences.removeNode();
            this.init();
        }
        catch (BackingStoreException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getString(String key, String def) {
        return this.preferences.get(key, def);
    }

    @Override
    public void putString(String key, String val) {
        if (val == null) {
            this.preferences.remove(key);
        } else {
            this.preferences.put(key, val);
        }
    }

    private java.util.prefs.Preferences getList(String listKey, boolean create) {
        try {
            if (create || this.preferences.nodeExists(listKey)) {
                return this.preferences.node(listKey);
            }
        }
        catch (BackingStoreException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    @Override
    public List<String> getStringList(String key, List<String> def) {
        java.util.prefs.Preferences listPrefs = this.getList(key, false);
        if (listPrefs == null) {
            return def;
        }
        int size = listPrefs.getInt("listSize", 0);
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            list.add(listPrefs.get(Integer.toString(i), ""));
        }
        return list;
    }

    @Override
    public void putStringList(String key, List<String> val) {
        java.util.prefs.Preferences listPrefs = this.getList(key, true);
        listPrefs.putInt("listSize", val.size());
        for (int i = 0; i < val.size(); ++i) {
            listPrefs.put(Integer.toString(i), val.get(i));
        }
    }

    @Override
    public int getInt(String key, int def) {
        return this.preferences.getInt(key, def);
    }

    @Override
    public void putInt(String key, int val) {
        this.preferences.putInt(key, val);
    }

    @Override
    public float getFloat(String key, float def) {
        return this.preferences.getFloat(key, def);
    }

    @Override
    public void putFloat(String key, float val) {
        this.preferences.putFloat(key, val);
    }

    @Override
    public long getLong(String key, long def) {
        return this.preferences.getLong(key, def);
    }

    @Override
    public void putLong(String key, long val) {
        this.preferences.putLong(key, val);
    }

    @Override
    public double getDouble(String key, double def) {
        return this.preferences.getDouble(key, def);
    }

    @Override
    public void putDouble(String key, double val) {
        this.preferences.putDouble(key, val);
    }

    @Override
    public boolean getBoolean(String key, boolean def) {
        return this.preferences.getBoolean(key, def);
    }

    @Override
    public void putBoolean(String key, boolean val) {
        this.preferences.putBoolean(key, val);
    }

    @Override
    public byte[] getByteArray(String key, byte[] def) {
        return this.preferences.getByteArray(key, def);
    }

    @Override
    public void putByteArray(String key, byte[] val) {
        this.preferences.putByteArray(key, val);
    }

    @Override
    public List<byte[]> getByteArrayList(String key, List<byte[]> def) {
        java.util.prefs.Preferences listPrefs = this.getList(key, false);
        if (listPrefs == null) {
            return def;
        }
        int size = listPrefs.getInt("listSize", 0);
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        for (int i = 0; i < size; ++i) {
            list.add(listPrefs.getByteArray(Integer.toString(i), new byte[]{0}));
        }
        return list;
    }

    @Override
    public void putByteArrayList(String key, List<byte[]> val) {
        java.util.prefs.Preferences listPrefs = this.getList(key, true);
        listPrefs.putInt("listSize", val.size());
        for (int i = 0; i < val.size(); ++i) {
            listPrefs.putByteArray(Integer.toString(i), val.get(i));
        }
    }
}

