/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.library.folder;

import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import org.protege.editor.core.log.LogBanner;
import org.protege.editor.owl.model.library.CatalogEntryManager;
import org.protege.editor.owl.model.library.LibraryUtilities;
import org.protege.editor.owl.model.library.folder.Algorithm;
import org.protege.editor.owl.model.library.folder.XmlBaseAlgorithm;
import org.protege.editor.owl.ui.UIHelper;
import org.protege.editor.owl.ui.library.NewEntryPanel;
import org.protege.editor.owl.ui.library.plugins.FolderGroupPanel;
import org.protege.xmlcatalog.CatalogUtilities;
import org.protege.xmlcatalog.Prefer;
import org.protege.xmlcatalog.XMLCatalog;
import org.protege.xmlcatalog.XmlBaseContext;
import org.protege.xmlcatalog.entry.Entry;
import org.protege.xmlcatalog.entry.GroupEntry;
import org.protege.xmlcatalog.entry.UriEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FolderGroupManager
extends CatalogEntryManager {
    public static final int FOLDER_BY_URI_VERSION = 1;
    public static final int CURRENT_VERSION = 2;
    public static final String ID_PREFIX = "Folder Repository";
    public static final String DIR_PROP = "directory";
    public static final String RECURSIVE_PROP = "recursive";
    public static final String FILE_KEY = "FILE";
    private static final int NON_ONTOLOGY_DOCUMENT_TERMINATION_LIMIT = 1000;
    private final Logger logger = LoggerFactory.getLogger(FolderGroupManager.class);
    private Set<Algorithm> algorithms;
    private boolean autoUpdate = true;
    private boolean warnedUserOfBadRepositoryDeclaration = false;
    private GroupEntry ge;
    private File folder;
    private boolean recursive = true;
    private long timeOfCurrentUpdate;
    private boolean modified = false;
    private Map<File, Collection<URI>> retainedFileToWebLocationMap = new TreeMap<File, Collection<URI>>();
    private Map<URI, Collection<URI>> webLocationToFileLocationMap = new TreeMap<URI, Collection<URI>>();

    public FolderGroupManager() {
        this.algorithms = new HashSet<Algorithm>();
        this.algorithms.add(new XmlBaseAlgorithm());
    }

    public static GroupEntry createGroupEntry(URI folder, boolean recursive, boolean autoUpdate, XmlBaseContext context) throws IOException {
        return new GroupEntry(FolderGroupManager.getIdString(ID_PREFIX, folder, recursive, autoUpdate), context, Prefer.PUBLIC, folder);
    }

    protected static String getIdString(String idPrefix, URI folderUri, boolean recursive, boolean autoUpdate) {
        return FolderGroupManager.getIdString(idPrefix, folderUri.toString(), recursive, autoUpdate);
    }

    protected static String getIdString(String idPrefix, String folderUri, boolean recursive, boolean autoUpdate) {
        StringBuffer sb = new StringBuffer(idPrefix);
        LibraryUtilities.addPropertyValue(sb, DIR_PROP, folderUri);
        LibraryUtilities.addPropertyValue(sb, RECURSIVE_PROP, recursive);
        LibraryUtilities.addPropertyValue(sb, "Auto-Update", autoUpdate ? "true" : "false");
        LibraryUtilities.addPropertyValue(sb, "version", 2);
        return sb.toString();
    }

    protected static boolean isValidOWLFile(File physicalLocation) {
        if (physicalLocation.getName().startsWith(".")) {
            return false;
        }
        String path = physicalLocation.getPath();
        for (String extension : UIHelper.OWL_EXTENSIONS) {
            if (!path.endsWith(extension)) continue;
            return true;
        }
        return false;
    }

    private static URI appendScheme(URI u, String scheme) {
        String uString = u.toString();
        return URI.create(scheme + uString);
    }

    private static URI removeIgnoredSchemes(URI u) {
        String uString = u.toString();
        for (String iScheme : CatalogEntryManager.IGNORED_SCHEMES) {
            if (!uString.startsWith(iScheme)) continue;
            return URI.create(uString.substring(iScheme.length()));
        }
        return u;
    }

    private static boolean isIgnored(URI u) {
        String uString = u.toString();
        for (String iScheme : CatalogEntryManager.IGNORED_SCHEMES) {
            if (!uString.startsWith(iScheme)) continue;
            return true;
        }
        return false;
    }

    public void setAlgorithms(Algorithm ... algorithms) {
        this.algorithms.clear();
        Collections.addAll(this.algorithms, algorithms);
    }

    @Override
    public boolean isSuitable(Entry entry) {
        boolean hasRightType;
        if (!(entry instanceof GroupEntry)) {
            return false;
        }
        GroupEntry ge = (GroupEntry)entry;
        File dir = FolderGroupManager.getDirectory(ge);
        boolean enabled = LibraryUtilities.getBooleanProperty(ge, "Auto-Update", false);
        boolean bl = hasRightType = ge.getId() != null && ge.getId().startsWith(this.getIdPrefix()) && enabled && dir != null;
        if (!(!hasRightType || dir.exists() && dir.isDirectory())) {
            this.logger.warn("Folder repository probably came from another system");
            this.logger.warn("Could not be updated because directory " + dir + " does not exist");
            if (!this.warnedUserOfBadRepositoryDeclaration) {
                this.logger.error("Bad ontology library declaration - check logs. Warnings now disabled for this session.");
                this.warnedUserOfBadRepositoryDeclaration = true;
            }
            return false;
        }
        return hasRightType;
    }

    private static File getDirectory(GroupEntry ge) {
        File folder;
        String dirName = LibraryUtilities.getStringProperty(ge, DIR_PROP);
        if (dirName == null) {
            return null;
        }
        if (LibraryUtilities.getVersion(ge) < 1) {
            folder = new File(dirName);
        } else {
            URI dirURI = CatalogUtilities.resolveXmlBase(ge).resolve(dirName);
            folder = new File(dirURI);
        }
        return folder;
    }

    protected String getIdPrefix() {
        return ID_PREFIX;
    }

    @Override
    public boolean update(Entry entry) {
        this.ge = (GroupEntry)entry;
        this.reset();
        this.ensureLatestVersion();
        try {
            this.logger.info(LogBanner.start((String)"Starting Catalog Update"));
            this.logger.info("Update of group entry {} started at {}.", (Object)this.ge.getId(), (Object)new Date(this.timeOfCurrentUpdate));
            this.retainEntries();
            if (this.folder != null) {
                HashSet<File> nonOwlFiles = new HashSet<File>();
                this.examineDirectoryContents(this.folder, new HashSet<URI>(), nonOwlFiles, 0);
                if (nonOwlFiles.size() > 1000) {
                    this.logger.warn("Search for ontology documents in {} and sub-folders has been terminated as over {} non-ontology documents have been found.", (Object)this.folder.getAbsolutePath(), (Object)1000);
                }
            }
            if (this.modified) {
                this.clearEntries();
                this.writeEntries();
            }
            this.logger.info("Catalog Update Complete");
            this.logger.info(LogBanner.end());
            boolean bl = this.modified;
            return bl;
        }
        finally {
            this.ge = null;
            this.reset();
        }
    }

    @Override
    public boolean initializeCatalog(File folder, XMLCatalog catalog) throws IOException {
        URI relativeFolderUri = CatalogUtilities.relativize(folder.toURI(), catalog);
        this.ge = FolderGroupManager.createGroupEntry(relativeFolderUri, true, this.autoUpdate, catalog);
        catalog.addEntry(this.ge);
        this.update(this.ge);
        return true;
    }

    @Override
    public NewEntryPanel newEntryPanel(XMLCatalog catalog) {
        return new FolderGroupPanel(catalog);
    }

    @Override
    public String getDescription() {
        return "Folder";
    }

    @Override
    public String getDescription(Entry ge) {
        StringBuilder sb = new StringBuilder("<html><body><b>Folder ");
        sb.append(FolderGroupManager.getDirectory((GroupEntry)ge));
        sb.append("</b>");
        if (LibraryUtilities.getBooleanProperty(ge, RECURSIVE_PROP, true)) {
            sb.append(" <font color=\"gray\">(includes sub-folders)</font>");
        }
        sb.append("</body></html>");
        return sb.toString();
    }

    private void reset() {
        this.modified = false;
        this.timeOfCurrentUpdate = System.currentTimeMillis();
        this.retainedFileToWebLocationMap.clear();
        this.webLocationToFileLocationMap.clear();
        if (this.ge != null) {
            this.folder = FolderGroupManager.getDirectory(this.ge);
            this.recursive = LibraryUtilities.getBooleanProperty(this.ge, RECURSIVE_PROP, true);
        } else {
            this.folder = null;
        }
    }

    private void ensureLatestVersion() {
        int version = LibraryUtilities.getVersion(this.ge);
        if (version < 2) {
            boolean autoUpdate = LibraryUtilities.getBooleanProperty(this.ge, "Auto-Update", this.autoUpdate);
            this.ge.setId(FolderGroupManager.getIdString(this.getIdPrefix(), this.folder.toURI(), this.recursive, autoUpdate));
            this.clearEntries();
        }
    }

    private void retainEntries() {
        for (Entry e : new ArrayList<Entry>(this.ge.getEntries())) {
            if (!(e instanceof UriEntry)) continue;
            UriEntry ue = (UriEntry)e;
            try {
                long lastUpdated = -1L;
                String updatedString = LibraryUtilities.getStringProperty(ue, "Timestamp");
                try {
                    if (updatedString != null) {
                        lastUpdated = Long.parseLong(updatedString);
                    }
                }
                catch (NumberFormatException nfe) {
                    this.logger.info("Could not parse timestamps in catalog file " + nfe);
                }
                File f = new File(ue.getAbsoluteURI());
                if (!f.exists() || f.lastModified() >= lastUpdated) {
                    this.modified = true;
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug("Map for file " + f + " is stale and has been removed");
                    continue;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Map for file " + f + " is still good and will be kept");
                }
                this.recordRetainedEntry(URI.create(ue.getName()), f.getCanonicalFile());
            }
            catch (Throwable t) {
                this.logger.error("Exception caught updating catalog entry.", t);
            }
        }
    }

    private void examineDirectoryContents(@Nonnull File directory, Set<URI> webLocationsFoundInParentDirectory, Set<File> nonOwlFiles, int depth) {
        if (nonOwlFiles.size() > 1000) {
            return;
        }
        this.logger.info("{} Examining: {}", (Object)FolderGroupManager.pad(depth), (Object)directory.getAbsolutePath());
        HashSet<URI> newWebLocations = new HashSet<URI>();
        if (this.algorithms == null || this.algorithms.isEmpty()) {
            return;
        }
        HashSet<File> subFolders = new HashSet<File>();
        File[] directoryEntries = directory.listFiles();
        if (directoryEntries == null) {
            return;
        }
        for (File physicalLocation : directoryEntries) {
            if (physicalLocation.isHidden() || !physicalLocation.exists()) continue;
            if (physicalLocation.isDirectory()) {
                if (!this.recursive) continue;
                subFolders.add(physicalLocation);
                continue;
            }
            if (!physicalLocation.isFile()) continue;
            if (FolderGroupManager.isValidOWLFile(physicalLocation)) {
                this.examineSingleFile(physicalLocation, webLocationsFoundInParentDirectory, newWebLocations);
                continue;
            }
            nonOwlFiles.add(physicalLocation);
        }
        webLocationsFoundInParentDirectory.addAll(newWebLocations);
        for (File physicalLocation : subFolders) {
            this.examineDirectoryContents(physicalLocation, webLocationsFoundInParentDirectory, nonOwlFiles, depth + 1);
        }
    }

    private static String pad(int depth) {
        return Strings.repeat((String)" ", (int)(depth * 4));
    }

    private void examineSingleFile(File physicalLocation, Set<URI> webLocationsFoundInParentDirectory, Set<URI> newWebLocations) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Applying algorithms to " + physicalLocation);
        }
        URI shortLocation = this.folder.toURI().relativize(physicalLocation.toURI());
        Collection<URI> retainedSuggestions = null;
        try {
            retainedSuggestions = this.retainedFileToWebLocationMap.get(physicalLocation.getCanonicalFile());
        }
        catch (IOException e) {
            this.logger.warn("IO Exception caught processing file " + physicalLocation + " for repository library update", (Throwable)e);
        }
        if (retainedSuggestions != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Adding mappings retained from previous version of the catalog");
            }
            this.recordEntries(retainedSuggestions, shortLocation, webLocationsFoundInParentDirectory, newWebLocations);
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Adding new mappings not found in the previous version of the catalog");
            }
            for (Algorithm algorithm : this.algorithms) {
                Set<URI> webLocations = algorithm.getSuggestions(physicalLocation);
                this.modified = this.modified || !webLocations.isEmpty();
                this.recordEntries(webLocations, shortLocation, webLocationsFoundInParentDirectory, newWebLocations);
            }
        }
    }

    private void recordEntries(Collection<URI> webLocations, URI physicalLocation, Set<URI> webLocationsFoundInParentDirectory, Set<URI> newWebLocations) {
        for (URI webLocation : webLocations) {
            if (!webLocationsFoundInParentDirectory.contains(webLocation)) {
                newWebLocations.add(webLocation);
                this.recordEntry(webLocation, physicalLocation);
                continue;
            }
            this.recordEntry(FolderGroupManager.appendScheme(webLocation, "shadowed:"), physicalLocation);
        }
    }

    private void recordEntry(URI webLocation, URI physicalLocation) {
        Collection<URI> possibleFileLocations;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Found mapping from import location " + webLocation + " to physical file " + physicalLocation);
        }
        if ((possibleFileLocations = this.webLocationToFileLocationMap.get(webLocation)) == null) {
            possibleFileLocations = new ArrayList<URI>();
            this.webLocationToFileLocationMap.put(webLocation, possibleFileLocations);
        }
        possibleFileLocations.add(physicalLocation);
    }

    private void recordRetainedEntry(URI webLocation, File f) {
        Collection<URI> possibleWebLocations = this.retainedFileToWebLocationMap.get(f);
        if (possibleWebLocations == null) {
            possibleWebLocations = new ArrayList<URI>();
            this.retainedFileToWebLocationMap.put(f, possibleWebLocations);
        }
        possibleWebLocations.add(FolderGroupManager.removeIgnoredSchemes(webLocation));
    }

    private void clearEntries() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Catalog must be modified - clearing out existing data");
        }
        for (Entry e : this.ge.getEntries()) {
            this.ge.removeEntry(e);
        }
    }

    private void writeEntries() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Catalog must be modified - writing new data");
        }
        for (URI webLocation : this.webLocationToFileLocationMap.keySet()) {
            Collection<URI> physicalLocations = this.webLocationToFileLocationMap.get(webLocation);
            if (physicalLocations.size() > 1 && !FolderGroupManager.isIgnored(webLocation)) {
                this.writeEntries(FolderGroupManager.appendScheme(webLocation, "duplicate:"), physicalLocations);
                continue;
            }
            this.writeEntries(webLocation, physicalLocations);
        }
    }

    private void writeEntries(URI webLocation, Collection<URI> physicalLocations) {
        for (URI physicalLocation : physicalLocations) {
            String entryId = "Automatically generated entry, Timestamp=" + this.timeOfCurrentUpdate;
            UriEntry u = new UriEntry(entryId, this.ge, webLocation.toString(), physicalLocation, null);
            this.ge.addEntry(u);
            this.modified = true;
        }
    }
}

