/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLClassExpressionVisitorAdapter;

public class NamedConjunctChecker {
    @Nullable
    OWLClass conjunct;
    boolean found;
    boolean collect;
    @Nonnull
    final Set<OWLClass> conjuncts = new HashSet<OWLClass>();
    @Nonnull
    private final NamedConjunctCheckerVisitor visitor = new NamedConjunctCheckerVisitor();

    public boolean isNamedConjunct(@Nonnull OWLClass conj, @Nonnull OWLClassExpression classExpression) {
        OWLAPIPreconditions.checkNotNull(conj, "conj cannot be null");
        OWLAPIPreconditions.checkNotNull(classExpression, "classExpression cannot be null");
        this.reset();
        this.conjunct = conj;
        classExpression.accept(this.visitor);
        return this.found;
    }

    public boolean hasNamedConjunct(@Nonnull OWLClassExpression classExpression) {
        OWLAPIPreconditions.checkNotNull(classExpression, "classExpression cannot be null");
        this.reset();
        this.conjunct = null;
        classExpression.accept(this.visitor);
        return this.found;
    }

    private void reset() {
        this.found = false;
        this.collect = false;
    }

    @Nonnull
    public Set<OWLClass> getNamedConjuncts(@Nonnull OWLClassExpression classExpression) {
        OWLAPIPreconditions.checkNotNull(classExpression, "classExpression cannot be null");
        this.conjuncts.clear();
        this.reset();
        this.collect = true;
        classExpression.accept(this.visitor);
        return this.conjuncts;
    }

    private class NamedConjunctCheckerVisitor
    extends OWLClassExpressionVisitorAdapter {
        NamedConjunctCheckerVisitor() {
        }

        @Override
        public void visit(OWLClass ce) {
            if (NamedConjunctChecker.this.conjunct == null) {
                NamedConjunctChecker.this.found = true;
                if (NamedConjunctChecker.this.collect) {
                    NamedConjunctChecker.this.conjuncts.add(ce);
                }
            } else if (ce.equals(NamedConjunctChecker.this.conjunct)) {
                NamedConjunctChecker.this.found = true;
                if (NamedConjunctChecker.this.collect) {
                    NamedConjunctChecker.this.conjuncts.add(ce);
                }
            }
        }

        @Override
        public void visit(OWLObjectIntersectionOf ce) {
            for (OWLClassExpression op : ce.getOperands()) {
                op.accept(this);
                if (!NamedConjunctChecker.this.found || NamedConjunctChecker.this.collect) continue;
                break;
            }
        }
    }
}

