/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.elasticsearch.painless.CompilerSettings;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.node.AStatement;
import org.elasticsearch.painless.node.SBlock;
import org.elasticsearch.painless.node.SCatch;
import org.objectweb.asm.Label;

public final class STry
extends AStatement {
    private final SBlock block;
    private final List<SCatch> catches;

    public STry(Location location, SBlock block, List<SCatch> catches) {
        super(location);
        this.block = block;
        this.catches = Collections.unmodifiableList(catches);
    }

    @Override
    void storeSettings(CompilerSettings settings) {
        if (this.block != null) {
            this.block.storeSettings(settings);
        }
        for (SCatch ctch : this.catches) {
            ctch.storeSettings(settings);
        }
    }

    @Override
    void extractVariables(Set<String> variables) {
        if (this.block != null) {
            this.block.extractVariables(variables);
        }
        for (SCatch expr : this.catches) {
            expr.extractVariables(variables);
        }
    }

    @Override
    void analyze(Locals locals) {
        if (this.block == null) {
            throw this.createError(new IllegalArgumentException("Extraneous try statement."));
        }
        this.block.lastSource = this.lastSource;
        this.block.inLoop = this.inLoop;
        this.block.lastLoop = this.lastLoop;
        this.block.analyze(Locals.newLocalScope(locals));
        this.methodEscape = this.block.methodEscape;
        this.loopEscape = this.block.loopEscape;
        this.allEscape = this.block.allEscape;
        this.anyContinue = this.block.anyContinue;
        this.anyBreak = this.block.anyBreak;
        int statementCount = 0;
        for (SCatch catc : this.catches) {
            catc.lastSource = this.lastSource;
            catc.inLoop = this.inLoop;
            catc.lastLoop = this.lastLoop;
            catc.analyze(Locals.newLocalScope(locals));
            this.methodEscape &= catc.methodEscape;
            this.loopEscape &= catc.loopEscape;
            this.allEscape &= catc.allEscape;
            this.anyContinue |= catc.anyContinue;
            this.anyBreak |= catc.anyBreak;
            statementCount = Math.max(statementCount, catc.statementCount);
        }
        this.statementCount = this.block.statementCount + statementCount;
    }

    @Override
    void write(MethodWriter writer, Globals globals) {
        writer.writeStatementOffset(this.location);
        Label begin = new Label();
        Label end = new Label();
        Label exception = new Label();
        writer.mark(begin);
        this.block.continu = this.continu;
        this.block.brake = this.brake;
        this.block.write(writer, globals);
        if (!this.block.allEscape) {
            writer.goTo(exception);
        }
        writer.mark(end);
        for (SCatch catc : this.catches) {
            catc.begin = begin;
            catc.end = end;
            catc.exception = this.catches.size() > 1 ? exception : null;
            catc.write(writer, globals);
        }
        if (!this.block.allEscape || this.catches.size() > 1) {
            writer.mark(exception);
        }
    }

    @Override
    public String toString() {
        return this.multilineToString(Collections.singleton(this.block), this.catches);
    }
}

