/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.webserver;

import fi.iki.elonen.NanoHTTPD;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.fibs.geotag.table.ImagesTableModel;
import org.fibs.geotag.webserver.ContextHandler;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class WebServer
extends NanoHTTPD {
    private static final I18n i18n = I18nFactory.getI18n(WebServer.class);
    public static final String XML_MIME_TYPE = "application/xml";
    public static final String FILE_NOT_FOUND = i18n.tr("Error 404, file not found.");
    private List<String> contexts = new ArrayList<String>();
    private Map<String, ContextHandler> contextHandlers = new HashMap<String, ContextHandler>();

    public WebServer(int port, ImagesTableModel imagesTableModel) throws IOException {
        super(port);
    }

    public void createContext(String path, ContextHandler contextHandler) {
        if (path.charAt(0) == '/') {
            String pathToAdd = path;
            if (pathToAdd.length() > 1 && pathToAdd.charAt(pathToAdd.length() - 1) == '/') {
                pathToAdd = pathToAdd.substring(0, pathToAdd.length() - 1);
            }
            if (this.contextHandlers.get(pathToAdd) == null) {
                this.contexts.add(pathToAdd);
                this.contextHandlers.put(pathToAdd, contextHandler);
            }
        }
    }

    @Override
    public NanoHTTPD.Response serve(String uri, String method, Properties header, Properties parameters) {
        String context = "";
        for (String candidate : this.contexts) {
            if (!uri.startsWith(candidate) || candidate.length() <= context.length()) continue;
            context = candidate;
        }
        if (context.length() > 0) {
            String contextUri = uri;
            if (context.length() > 1) {
                contextUri = uri.substring(context.length());
            }
            return this.contextHandlers.get(context).serve(this, contextUri, method, header, parameters);
        }
        return (NanoHTTPD)this.new NanoHTTPD.Response("404 Not Found", "text/plain", FILE_NOT_FOUND);
    }

    public String mimeType(String filename) {
        String type = null;
        int lastDot = filename.lastIndexOf(46);
        if (lastDot >= 0) {
            type = (String)theMimeTypes.get(filename.substring(lastDot + 1).toLowerCase());
        }
        if (type == null) {
            type = "application/octet-stream";
        }
        return type;
    }

    public NanoHTTPD.Response xmlResponse(String xml) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(xml.getBytes());
            return this.xmlResponse(byteArrayOutputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public NanoHTTPD.Response xmlResponse(ByteArrayOutputStream byteArrayOutputStream) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        return (NanoHTTPD)this.new NanoHTTPD.Response("200 OK", XML_MIME_TYPE, byteArrayInputStream);
    }
}

