/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import javajs.util.BS;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.V3;
import org.jmol.c.STR;
import org.jmol.modelsetbio.AlphaMonomer;
import org.jmol.modelsetbio.BioPolymer;
import org.jmol.modelsetbio.Helix;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.ProteinStructure;
import org.jmol.modelsetbio.Sheet;
import org.jmol.modelsetbio.Turn;
import org.jmol.util.Logger;

public class AlphaPolymer
extends BioPolymer {
    public int pt0;
    private static final String[] dsspTypes = new String[]{"H", null, "H", "S", "H", null, "T"};

    AlphaPolymer(Monomer[] monomers, int pt0) {
        this.pt0 = pt0;
        this.set(monomers);
        this.hasStructure = true;
    }

    @Override
    public ProteinStructure getProteinStructure(int monomerIndex) {
        return (ProteinStructure)this.monomers[monomerIndex].getStructure();
    }

    @Override
    protected P3 getControlPoint(int i, V3 v) {
        if (!this.monomers[i].isSheet()) {
            return this.leadPoints[i];
        }
        v.sub2(this.leadMidpoints[i], this.leadPoints[i]);
        v.scale(this.sheetSmoothing);
        P3 pt = P3.newP(this.leadPoints[i]);
        pt.add(v);
        return pt;
    }

    public void addStructure(STR type, String structureID, int serialID, int strandCount, int startChainID, int startSeqcode, int endChainID, int endSeqcode, int istart, int iend, BS bsAssigned) {
        int pt;
        int indexEnd;
        int indexStart;
        int i0 = -1;
        int i1 = -1;
        if (istart < iend) {
            if (this.monomers[0].firstAtomIndex > iend || this.monomers[this.monomerCount - 1].lastAtomIndex < istart) {
                return;
            }
            i0 = istart;
            i1 = iend;
        }
        if ((indexStart = this.getIndex(startChainID, startSeqcode, i0, i1)) == -1 || (indexEnd = this.getIndex(endChainID, endSeqcode, i0, i1)) == -1) {
            return;
        }
        if (istart >= 0 && bsAssigned != null && (pt = bsAssigned.nextSetBit(this.monomers[indexStart].firstAtomIndex)) >= 0 && pt < this.monomers[indexEnd].lastAtomIndex) {
            return;
        }
        if (this.addStructureProtected(type, structureID, serialID, strandCount, indexStart, indexEnd) && istart >= 0) {
            bsAssigned.setBits(istart, iend + 1);
        }
    }

    public boolean addStructureProtected(STR type, String structureID, int serialID, int strandCount, int indexStart, int indexEnd) {
        if (indexEnd < indexStart) {
            Logger.error("AlphaPolymer:addSecondaryStructure error:  indexStart:" + indexStart + " indexEnd:" + indexEnd);
            return false;
        }
        int structureCount = indexEnd - indexStart + 1;
        ProteinStructure ps = null;
        switch (type) {
            case HELIX: 
            case HELIXALPHA: 
            case HELIX310: 
            case HELIXPI: {
                ps = new Helix(this, indexStart, structureCount, type);
                break;
            }
            case SHEET: {
                ps = new Sheet(this, indexStart, structureCount, type);
                break;
            }
            case TURN: {
                ps = new Turn(this, indexStart, structureCount);
                break;
            }
            default: {
                Logger.error("unrecognized secondary structure type");
                return false;
            }
        }
        ps.structureID = structureID;
        ps.serialID = serialID;
        ps.strandCount = strandCount;
        for (int i = indexStart; i <= indexEnd; ++i) {
            ((AlphaMonomer)this.monomers[i]).setStructure(ps);
        }
        return true;
    }

    @Override
    public void clearStructures() {
        for (int i = 0; i < this.monomerCount; ++i) {
            ((AlphaMonomer)this.monomers[i]).setStructure(null);
        }
    }

    public void calculateStructures(boolean alphaOnly) {
        if (this.monomerCount < 4) {
            return;
        }
        float[] angles = this.calculateAnglesInDegrees();
        Code[] codes = this.calculateCodes(angles);
        this.checkBetaSheetAlphaHelixOverlap(codes, angles);
        STR[] tags = this.calculateRunsFourOrMore(codes);
        this.extendRuns(tags);
        this.searchForTurns(codes, angles, tags);
        this.addStructuresFromTags(tags);
    }

    private float[] calculateAnglesInDegrees() {
        float[] angles = new float[this.monomerCount];
        int i = this.monomerCount - 1;
        while (--i >= 2) {
            angles[i] = Measure.computeTorsion(this.monomers[i - 2].getLeadAtom(), this.monomers[i - 1].getLeadAtom(), this.monomers[i].getLeadAtom(), this.monomers[i + 1].getLeadAtom(), true);
        }
        return angles;
    }

    private Code[] calculateCodes(float[] angles) {
        Code[] codes = new Code[this.monomerCount];
        int i = this.monomerCount - 1;
        while (--i >= 2) {
            float degrees = angles[i];
            codes[i] = degrees >= 10.0f && degrees < 120.0f ? Code.RIGHT_HELIX : (degrees >= 120.0f || degrees < -90.0f ? Code.BETA_SHEET : (degrees >= -90.0f && degrees < 0.0f ? Code.LEFT_HELIX : Code.NADA));
        }
        return codes;
    }

    private void checkBetaSheetAlphaHelixOverlap(Code[] codes, float[] angles) {
        int i = this.monomerCount - 2;
        while (--i >= 2) {
            if (codes[i] != Code.BETA_SHEET || !(angles[i] <= 140.0f) || codes[i - 2] != Code.RIGHT_HELIX || codes[i - 1] != Code.RIGHT_HELIX || codes[i + 1] != Code.RIGHT_HELIX || codes[i + 2] != Code.RIGHT_HELIX) continue;
            codes[i] = Code.RIGHT_HELIX;
        }
    }

    private STR[] calculateRunsFourOrMore(Code[] codes) {
        STR[] tags = new STR[this.monomerCount];
        STR tag = STR.NONE;
        Code code = Code.NADA;
        int runLength = 0;
        for (int i = 0; i < this.monomerCount; ++i) {
            if (codes[i] == code && code != Code.NADA && code != Code.BETA_SHEET) {
                if (++runLength == 4) {
                    tag = code == Code.BETA_SHEET ? STR.SHEET : STR.HELIX;
                    int j = 4;
                    while (--j >= 0) {
                        tags[i - j] = tag;
                    }
                    continue;
                }
                if (runLength <= 4) continue;
                tags[i] = tag;
                continue;
            }
            runLength = 1;
            code = codes[i];
        }
        return tags;
    }

    private void extendRuns(STR[] tags) {
        for (int i = 1; i < this.monomerCount - 4; ++i) {
            if (tags[i] != STR.NONE || tags[i + 1] == STR.NONE) continue;
            tags[i] = tags[i + 1];
        }
        tags[0] = tags[1];
        tags[this.monomerCount - 1] = tags[this.monomerCount - 2];
    }

    private void searchForTurns(Code[] codes, float[] angles, STR[] tags) {
        int i = this.monomerCount - 1;
        while (--i >= 2) {
            codes[i] = Code.NADA;
            if (tags[i] != null && tags[i] != STR.NONE) continue;
            float angle = angles[i];
            if (angle >= -90.0f && angle < 0.0f) {
                codes[i] = Code.LEFT_TURN;
                continue;
            }
            if (!(angle >= 0.0f) || !(angle < 90.0f)) continue;
            codes[i] = Code.RIGHT_TURN;
        }
        i = this.monomerCount - 1;
        while (--i >= 0) {
            if (codes[i] == Code.NADA || codes[i + 1] != codes[i] || tags[i] != STR.NONE) continue;
            tags[i] = STR.TURN;
        }
    }

    private void addStructuresFromTags(STR[] tags) {
        int i = 0;
        while (i < this.monomerCount) {
            int iMax;
            STR tag = tags[i];
            if (tag == null || tag == STR.NONE) {
                ++i;
                continue;
            }
            for (iMax = i + 1; iMax < this.monomerCount && tags[iMax] == tag; ++iMax) {
            }
            this.addStructureProtected(tag, null, 0, 0, i, iMax - 1);
            i = iMax;
        }
    }

    public int setStructureBS(int count, int dsspType, STR type, BS bs, boolean doOffset) {
        int offset = doOffset ? this.pt0 : 0;
        int pt = 0;
        int i = bs.nextSetBit(offset);
        int i2 = 0;
        int n = this.monomerCount + offset;
        while (i >= 0 && i < n) {
            i2 = bs.nextClearBit(i);
            if (i2 < 0 || i2 > n) {
                i2 = n;
            }
            this.addStructureProtected(type, dsspTypes[dsspType] + ++pt, count++, dsspType == 3 ? 1 : 0, i - offset, i2 - 1 - offset);
            i = bs.nextSetBit(i2 + 1);
        }
        return count;
    }

    private static enum Code {
        NADA,
        RIGHT_HELIX,
        BETA_SHEET,
        LEFT_HELIX,
        LEFT_TURN,
        RIGHT_TURN;

    }
}

