/*
 * Decompiled with CFR 0.152.
 */
package jspecview.source;

import javajs.util.Lst;
import jspecview.common.Spectrum;
import jspecview.source.JDXHeader;

public class JDXSource
extends JDXHeader {
    public static final int TYPE_VIEW = -2;
    public static final int TYPE_UNKNOWN = -1;
    public static final int TYPE_SIMPLE = 0;
    public static final int TYPE_BLOCK = 1;
    public static final int TYPE_NTUPLE = 2;
    public int type = 0;
    public boolean isCompoundSource = false;
    private Lst<Spectrum> jdxSpectra;
    private String errors = "";
    private String filePath;
    public int peakCount;
    public boolean isView;
    private String inlineData;

    public void dispose() {
        this.headerTable = null;
        this.jdxSpectra = null;
    }

    public JDXSource(int n, String string) {
        this.type = n;
        this.setFilePath(string);
        this.headerTable = new Lst();
        this.jdxSpectra = new Lst();
        this.isCompoundSource = n != 0;
    }

    public Spectrum getJDXSpectrum(int n) {
        return this.jdxSpectra.size() <= n ? null : (Spectrum)this.jdxSpectra.get(n);
    }

    public void addJDXSpectrum(String string, Spectrum spectrum, boolean bl) {
        int n;
        if (string == null) {
            string = this.filePath;
        }
        spectrum.setFilePath(string);
        if (this.inlineData != null) {
            spectrum.setInlineData(this.inlineData);
        }
        if ((n = this.jdxSpectra.size()) == 0 || !((Spectrum)this.jdxSpectra.get(n - 1)).addSubSpectrum(spectrum, bl)) {
            this.jdxSpectra.addLast(spectrum);
        }
    }

    public int getNumberOfSpectra() {
        return this.jdxSpectra.size();
    }

    public Lst<Spectrum> getSpectra() {
        return this.jdxSpectra;
    }

    public Spectrum[] getSpectraAsArray() {
        return (Spectrum[])(this.jdxSpectra == null ? null : this.jdxSpectra.toArray());
    }

    public String getErrorLog() {
        return this.errors;
    }

    public void setErrorLog(String string) {
        this.errors = string;
    }

    public void setFilePath(String string) {
        this.filePath = string;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public static JDXSource createView(Lst<Spectrum> lst) {
        JDXSource jDXSource = new JDXSource(-2, "view");
        jDXSource.isView = true;
        int n = 0;
        while (n < lst.size()) {
            jDXSource.addJDXSpectrum(((Spectrum)lst.get(n)).getFilePath(), (Spectrum)lst.get(n), false);
            ++n;
        }
        return jDXSource;
    }

    public String[][] getHeaderRowDataAsArray(boolean bl, String[][] stringArray) {
        if (stringArray == null) {
            stringArray = new String[0][0];
        }
        String[][] stringArray2 = this.getHeaderRowDataAsArray(bl, stringArray.length);
        int n = stringArray.length;
        while (--n >= 0) {
            stringArray2[stringArray2.length - stringArray.length + n] = stringArray[n];
        }
        return stringArray2;
    }

    public void setID(String string) {
        ((Spectrum)this.jdxSpectra.get((int)0)).sourceID = string;
    }

    public boolean matchesFilePath(String string) {
        return this.filePath.equals(string) || this.filePath.replace('\\', '/').equals(string);
    }

    public void setInlineData(String string) {
        this.inlineData = string;
        if (this.jdxSpectra != null) {
            int n = this.jdxSpectra.size();
            while (--n >= 0) {
                ((Spectrum)this.jdxSpectra.get(n)).setInlineData(string);
            }
        }
    }
}

