/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.builtins.jvm;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.CompanionObjectMapping;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PlatformToKotlinClassMap;
import org.jetbrains.kotlin.builtins.functions.FunctionClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.JvmPrimitiveType;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001KB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004H\u0002J\u0018\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004H\u0002J\u0018\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u0004H\u0002J\u0010\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u0015H\u0002J\u001c\u0010#\u001a\u00020\u001b2\n\u0010$\u001a\u0006\u0012\u0002\b\u00030%2\u0006\u0010&\u001a\u00020\u0006H\u0002J\u001c\u0010#\u001a\u00020\u001b2\n\u0010$\u001a\u0006\u0012\u0002\b\u00030%2\u0006\u0010&\u001a\u00020\u0011H\u0002J\u0014\u0010'\u001a\u00020\u00042\n\u0010(\u001a\u0006\u0012\u0002\b\u00030%H\u0002J\u000e\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*J\u000e\u0010,\u001a\u00020*2\u0006\u0010-\u001a\u00020*J,\u0010.\u001a\u00020*2\u0006\u0010/\u001a\u00020*2\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0006012\u0006\u00102\u001a\u00020\u000bH\u0002J\u000e\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u0006J\u0018\u00106\u001a\u0002042\u0006\u0010&\u001a\u00020\u00112\u0006\u00107\u001a\u00020\u000bH\u0002J\u000e\u00108\u001a\u0002042\u0006\u0010+\u001a\u00020*J\u0010\u00108\u001a\u0002042\b\u00109\u001a\u0004\u0018\u00010\u0011J\u000e\u00108\u001a\u0002042\u0006\u0010:\u001a\u00020;J\u000e\u0010<\u001a\u0002042\u0006\u0010-\u001a\u00020*J\u0010\u0010<\u001a\u0002042\b\u00109\u001a\u0004\u0018\u00010\u0011J\u000e\u0010<\u001a\u0002042\u0006\u0010:\u001a\u00020;J\u0010\u0010=\u001a\u0004\u0018\u00010\u00042\u0006\u00105\u001a\u00020\u0006J)\u0010=\u001a\u0004\u0018\u00010*2\u0006\u00105\u001a\u00020\u00062\u0006\u0010>\u001a\u00020?2\n\b\u0002\u0010@\u001a\u0004\u0018\u00010A\u00a2\u0006\u0002\u0010BJ\u0010\u0010C\u001a\u0004\u0018\u00010\u00042\u0006\u0010&\u001a\u00020\u0011J\u0016\u0010D\u001a\b\u0012\u0004\u0012\u00020*0E2\u0006\u0010F\u001a\u00020*H\u0016J\u001c\u0010D\u001a\b\u0012\u0004\u0012\u00020*0E2\u0006\u00105\u001a\u00020\u00062\u0006\u0010>\u001a\u00020?J!\u0010G\u001a\u00020\u0015\"\u0006\b\u0000\u0010H\u0018\u00012\u0006\u0010I\u001a\u00020\u00042\u0006\u0010J\u001a\u00020\u0006H\u0082\bJ\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00062\b\u00109\u001a\u0004\u0018\u00010\u0011J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00062\b\u00109\u001a\u0004\u0018\u00010\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00040\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00040\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00060\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00060\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006L"}, d2={"Lorg/jetbrains/kotlin/builtins/jvm/JavaToKotlinClassMap;", "Lorg/jetbrains/kotlin/builtins/PlatformToKotlinClassMap;", "()V", "FUNCTION_N_CLASS_ID", "Lorg/jetbrains/kotlin/name/ClassId;", "FUNCTION_N_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "getFUNCTION_N_FQ_NAME", "()Lorg/jetbrains/kotlin/name/FqName;", "K_FUNCTION_CLASS_ID", "NUMBERED_FUNCTION_PREFIX", "", "NUMBERED_K_FUNCTION_PREFIX", "NUMBERED_K_SUSPEND_FUNCTION_PREFIX", "NUMBERED_SUSPEND_FUNCTION_PREFIX", "javaToKotlin", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "kotlinToJava", "mutabilityMappings", "", "Lorg/jetbrains/kotlin/builtins/jvm/JavaToKotlinClassMap$PlatformMutabilityMapping;", "getMutabilityMappings", "()Ljava/util/List;", "mutableToReadOnly", "readOnlyToMutable", "add", "", "javaClassId", "kotlinClassId", "addJavaToKotlin", "addKotlinToJava", "kotlinFqNameUnsafe", "addMapping", "platformMutabilityMapping", "addTopLevel", "javaClass", "Ljava/lang/Class;", "kotlinFqName", "classId", "clazz", "convertMutableToReadOnly", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "mutable", "convertReadOnlyToMutable", "readOnly", "convertToOppositeMutability", "descriptor", "map", "", "mutabilityKindName", "isJavaPlatformClass", "", "fqName", "isKotlinFunctionWithBigArity", "prefix", "isMutable", "fqNameUnsafe", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "isReadOnly", "mapJavaToKotlin", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "functionTypeArity", "", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;Ljava/lang/Integer;)Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "mapKotlinToJava", "mapPlatformClass", "", "classDescriptor", "mutabilityMapping", "T", "kotlinReadOnly", "kotlinMutable", "PlatformMutabilityMapping", "descriptors.jvm"})
public final class JavaToKotlinClassMap
implements PlatformToKotlinClassMap {
    private static final String NUMBERED_FUNCTION_PREFIX;
    private static final String NUMBERED_K_FUNCTION_PREFIX;
    private static final String NUMBERED_SUSPEND_FUNCTION_PREFIX;
    private static final String NUMBERED_K_SUSPEND_FUNCTION_PREFIX;
    private static final ClassId FUNCTION_N_CLASS_ID;
    @NotNull
    private static final FqName FUNCTION_N_FQ_NAME;
    private static final ClassId K_FUNCTION_CLASS_ID;
    private static final HashMap<FqNameUnsafe, ClassId> javaToKotlin;
    private static final HashMap<FqNameUnsafe, ClassId> kotlinToJava;
    private static final HashMap<FqNameUnsafe, FqName> mutableToReadOnly;
    private static final HashMap<FqNameUnsafe, FqName> readOnlyToMutable;
    @NotNull
    private static final List<PlatformMutabilityMapping> mutabilityMappings;
    public static final JavaToKotlinClassMap INSTANCE;

    @NotNull
    public final FqName getFUNCTION_N_FQ_NAME() {
        return FUNCTION_N_FQ_NAME;
    }

    @NotNull
    public final List<PlatformMutabilityMapping> getMutabilityMappings() {
        return mutabilityMappings;
    }

    @Nullable
    public final ClassId mapJavaToKotlin(@NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        return javaToKotlin.get(fqName2.toUnsafe());
    }

    @Nullable
    public final ClassDescriptor mapJavaToKotlin(@NotNull FqName fqName2, @NotNull KotlinBuiltIns builtIns, @Nullable Integer functionTypeArity) {
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        Intrinsics.checkParameterIsNotNull(builtIns, "builtIns");
        ClassId kotlinClassId = functionTypeArity != null && Intrinsics.areEqual(fqName2, FUNCTION_N_FQ_NAME) ? KotlinBuiltIns.getFunctionClassId(functionTypeArity) : this.mapJavaToKotlin(fqName2);
        return kotlinClassId != null ? builtIns.getBuiltInClassByFqName(kotlinClassId.asSingleFqName()) : null;
    }

    public static /* synthetic */ ClassDescriptor mapJavaToKotlin$default(JavaToKotlinClassMap javaToKotlinClassMap, FqName fqName2, KotlinBuiltIns kotlinBuiltIns, Integer n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = null;
        }
        return javaToKotlinClassMap.mapJavaToKotlin(fqName2, kotlinBuiltIns, n);
    }

    @Nullable
    public final ClassId mapKotlinToJava(@NotNull FqNameUnsafe kotlinFqName) {
        Intrinsics.checkParameterIsNotNull(kotlinFqName, "kotlinFqName");
        return this.isKotlinFunctionWithBigArity(kotlinFqName, NUMBERED_FUNCTION_PREFIX) ? FUNCTION_N_CLASS_ID : (this.isKotlinFunctionWithBigArity(kotlinFqName, NUMBERED_SUSPEND_FUNCTION_PREFIX) ? FUNCTION_N_CLASS_ID : (this.isKotlinFunctionWithBigArity(kotlinFqName, NUMBERED_K_FUNCTION_PREFIX) ? K_FUNCTION_CLASS_ID : (this.isKotlinFunctionWithBigArity(kotlinFqName, NUMBERED_K_SUSPEND_FUNCTION_PREFIX) ? K_FUNCTION_CLASS_ID : kotlinToJava.get(kotlinFqName))));
    }

    private final boolean isKotlinFunctionWithBigArity(FqNameUnsafe kotlinFqName, String prefix) {
        String string2 = kotlinFqName.asString();
        Intrinsics.checkExpressionValueIsNotNull(string2, "kotlinFqName.asString()");
        String arityString = StringsKt.substringAfter(string2, prefix, "");
        CharSequence charSequence = arityString;
        boolean bl = false;
        if (charSequence.length() > 0 && !StringsKt.startsWith$default((CharSequence)arityString, '0', false, 2, null)) {
            Integer arity = StringsKt.toIntOrNull(arityString);
            return arity != null && arity >= 23;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final void addMapping(PlatformMutabilityMapping platformMutabilityMapping) {
        void readOnlyClassId;
        void javaClassId;
        PlatformMutabilityMapping platformMutabilityMapping2 = platformMutabilityMapping;
        ClassId classId = platformMutabilityMapping2.component1();
        ClassId classId2 = platformMutabilityMapping2.component2();
        ClassId mutableClassId = platformMutabilityMapping2.component3();
        this.add((ClassId)javaClassId, (ClassId)readOnlyClassId);
        FqName fqName2 = mutableClassId.asSingleFqName();
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "mutableClassId.asSingleFqName()");
        this.addKotlinToJava(fqName2, (ClassId)javaClassId);
        FqName fqName3 = readOnlyClassId.asSingleFqName();
        Intrinsics.checkExpressionValueIsNotNull(fqName3, "readOnlyClassId.asSingleFqName()");
        FqName readOnlyFqName = fqName3;
        FqName fqName4 = mutableClassId.asSingleFqName();
        Intrinsics.checkExpressionValueIsNotNull(fqName4, "mutableClassId.asSingleFqName()");
        FqName mutableFqName = fqName4;
        Map map2 = mutableToReadOnly;
        FqNameUnsafe fqNameUnsafe = mutableClassId.asSingleFqName().toUnsafe();
        Intrinsics.checkExpressionValueIsNotNull(fqNameUnsafe, "mutableClassId.asSingleFqName().toUnsafe()");
        map2.put(fqNameUnsafe, readOnlyFqName);
        Map map3 = readOnlyToMutable;
        FqNameUnsafe fqNameUnsafe2 = readOnlyFqName.toUnsafe();
        Intrinsics.checkExpressionValueIsNotNull(fqNameUnsafe2, "readOnlyFqName.toUnsafe()");
        map3.put(fqNameUnsafe2, mutableFqName);
    }

    private final void add(ClassId javaClassId, ClassId kotlinClassId) {
        this.addJavaToKotlin(javaClassId, kotlinClassId);
        FqName fqName2 = kotlinClassId.asSingleFqName();
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "kotlinClassId.asSingleFqName()");
        this.addKotlinToJava(fqName2, javaClassId);
    }

    private final void addTopLevel(Class<?> javaClass, FqNameUnsafe kotlinFqName) {
        FqName fqName2 = kotlinFqName.toSafe();
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "kotlinFqName.toSafe()");
        this.addTopLevel(javaClass, fqName2);
    }

    private final void addTopLevel(Class<?> javaClass, FqName kotlinFqName) {
        ClassId classId = this.classId(javaClass);
        ClassId classId2 = ClassId.topLevel(kotlinFqName);
        Intrinsics.checkExpressionValueIsNotNull(classId2, "ClassId.topLevel(kotlinFqName)");
        this.add(classId, classId2);
    }

    private final void addJavaToKotlin(ClassId javaClassId, ClassId kotlinClassId) {
        Map map2 = javaToKotlin;
        FqNameUnsafe fqNameUnsafe = javaClassId.asSingleFqName().toUnsafe();
        Intrinsics.checkExpressionValueIsNotNull(fqNameUnsafe, "javaClassId.asSingleFqName().toUnsafe()");
        map2.put(fqNameUnsafe, kotlinClassId);
    }

    private final void addKotlinToJava(FqName kotlinFqNameUnsafe, ClassId javaClassId) {
        Map map2 = kotlinToJava;
        FqNameUnsafe fqNameUnsafe = kotlinFqNameUnsafe.toUnsafe();
        Intrinsics.checkExpressionValueIsNotNull(fqNameUnsafe, "kotlinFqNameUnsafe.toUnsafe()");
        map2.put(fqNameUnsafe, javaClassId);
    }

    public final boolean isJavaPlatformClass(@NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        return this.mapJavaToKotlin(fqName2) != null;
    }

    @NotNull
    public final Collection<ClassDescriptor> mapPlatformClass(@NotNull FqName fqName2, @NotNull KotlinBuiltIns builtIns) {
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        Intrinsics.checkParameterIsNotNull(builtIns, "builtIns");
        ClassDescriptor classDescriptor2 = JavaToKotlinClassMap.mapJavaToKotlin$default(this, fqName2, builtIns, null, 4, null);
        if (classDescriptor2 == null) {
            return SetsKt.emptySet();
        }
        ClassDescriptor kotlinAnalog = classDescriptor2;
        FqName fqName3 = readOnlyToMutable.get(DescriptorUtilsKt.getFqNameUnsafe(kotlinAnalog));
        if (fqName3 == null) {
            return SetsKt.setOf(kotlinAnalog);
        }
        Intrinsics.checkExpressionValueIsNotNull(fqName3, "readOnlyToMutable[kotlin\u2026eturn setOf(kotlinAnalog)");
        FqName kotlinMutableAnalogFqName = fqName3;
        ClassDescriptor[] classDescriptorArray = new ClassDescriptor[2];
        classDescriptorArray[0] = kotlinAnalog;
        ClassDescriptor classDescriptor3 = builtIns.getBuiltInClassByFqName(kotlinMutableAnalogFqName);
        Intrinsics.checkExpressionValueIsNotNull(classDescriptor3, "builtIns.getBuiltInClass\u2026otlinMutableAnalogFqName)");
        classDescriptorArray[1] = classDescriptor3;
        return CollectionsKt.listOf(classDescriptorArray);
    }

    @Override
    @NotNull
    public Collection<ClassDescriptor> mapPlatformClass(@NotNull ClassDescriptor classDescriptor2) {
        Collection<ClassDescriptor> collection;
        Intrinsics.checkParameterIsNotNull(classDescriptor2, "classDescriptor");
        FqNameUnsafe fqNameUnsafe = DescriptorUtils.getFqName(classDescriptor2);
        Intrinsics.checkExpressionValueIsNotNull(fqNameUnsafe, "DescriptorUtils.getFqName(classDescriptor)");
        FqNameUnsafe className2 = fqNameUnsafe;
        if (className2.isSafe()) {
            FqName fqName2 = className2.toSafe();
            Intrinsics.checkExpressionValueIsNotNull(fqName2, "className.toSafe()");
            collection = this.mapPlatformClass(fqName2, DescriptorUtilsKt.getBuiltIns(classDescriptor2));
        } else {
            collection = SetsKt.emptySet();
        }
        return collection;
    }

    @Nullable
    public final FqName mutableToReadOnly(@Nullable FqNameUnsafe fqNameUnsafe) {
        Map map2 = mutableToReadOnly;
        boolean bl = false;
        return (FqName)map2.get(fqNameUnsafe);
    }

    @Nullable
    public final FqName readOnlyToMutable(@Nullable FqNameUnsafe fqNameUnsafe) {
        Map map2 = readOnlyToMutable;
        boolean bl = false;
        return (FqName)map2.get(fqNameUnsafe);
    }

    public final boolean isMutable(@Nullable FqNameUnsafe fqNameUnsafe) {
        Map map2 = mutableToReadOnly;
        boolean bl = false;
        Map map3 = map2;
        if (map3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
        }
        return map3.containsKey(fqNameUnsafe);
    }

    public final boolean isMutable(@NotNull ClassDescriptor mutable) {
        Intrinsics.checkParameterIsNotNull(mutable, "mutable");
        return this.isMutable(DescriptorUtils.getFqName(mutable));
    }

    public final boolean isMutable(@NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        ClassDescriptor classDescriptor2 = TypeUtils.getClassDescriptor(type2);
        return classDescriptor2 != null && this.isMutable(classDescriptor2);
    }

    public final boolean isReadOnly(@Nullable FqNameUnsafe fqNameUnsafe) {
        Map map2 = readOnlyToMutable;
        boolean bl = false;
        Map map3 = map2;
        if (map3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
        }
        return map3.containsKey(fqNameUnsafe);
    }

    public final boolean isReadOnly(@NotNull ClassDescriptor readOnly) {
        Intrinsics.checkParameterIsNotNull(readOnly, "readOnly");
        return this.isReadOnly(DescriptorUtils.getFqName(readOnly));
    }

    public final boolean isReadOnly(@NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        ClassDescriptor classDescriptor2 = TypeUtils.getClassDescriptor(type2);
        return classDescriptor2 != null && this.isReadOnly(classDescriptor2);
    }

    @NotNull
    public final ClassDescriptor convertMutableToReadOnly(@NotNull ClassDescriptor mutable) {
        Intrinsics.checkParameterIsNotNull(mutable, "mutable");
        return this.convertToOppositeMutability(mutable, (Map<FqNameUnsafe, FqName>)mutableToReadOnly, "mutable");
    }

    @NotNull
    public final ClassDescriptor convertReadOnlyToMutable(@NotNull ClassDescriptor readOnly) {
        Intrinsics.checkParameterIsNotNull(readOnly, "readOnly");
        return this.convertToOppositeMutability(readOnly, (Map<FqNameUnsafe, FqName>)readOnlyToMutable, "read-only");
    }

    private final ClassId classId(Class<?> clazz) {
        ClassId classId;
        boolean bl = !clazz.isPrimitive() && !clazz.isArray();
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Invalid class: " + clazz;
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        Class<?> outer = clazz.getDeclaringClass();
        if (outer == null) {
            ClassId classId2 = ClassId.topLevel(new FqName(clazz.getCanonicalName()));
            classId = classId2;
            Intrinsics.checkExpressionValueIsNotNull(classId2, "ClassId.topLevel(FqName(clazz.canonicalName))");
        } else {
            ClassId classId3 = this.classId(outer).createNestedClassId(Name.identifier(clazz.getSimpleName()));
            classId = classId3;
            Intrinsics.checkExpressionValueIsNotNull(classId3, "classId(outer).createNes\u2026tifier(clazz.simpleName))");
        }
        return classId;
    }

    private final ClassDescriptor convertToOppositeMutability(ClassDescriptor descriptor2, Map<FqNameUnsafe, FqName> map2, String mutabilityKindName) {
        FqName fqName2 = map2.get(DescriptorUtils.getFqName(descriptor2));
        if (fqName2 == null) {
            throw (Throwable)new IllegalArgumentException("Given class " + descriptor2 + " is not a " + mutabilityKindName + " collection");
        }
        FqName oppositeClassFqName = fqName2;
        ClassDescriptor classDescriptor2 = DescriptorUtilsKt.getBuiltIns(descriptor2).getBuiltInClassByFqName(oppositeClassFqName);
        Intrinsics.checkExpressionValueIsNotNull(classDescriptor2, "descriptor.builtIns.getB\u2026Name(oppositeClassFqName)");
        return classDescriptor2;
    }

    private JavaToKotlinClassMap() {
    }

    static {
        int i;
        JavaToKotlinClassMap this_$iv;
        PlatformMutabilityMapping platformMutabilityMapping;
        JvmPrimitiveType[] kotlinMutable$iv;
        ClassId kotlinReadOnly$iv;
        JavaToKotlinClassMap javaToKotlinClassMap;
        INSTANCE = javaToKotlinClassMap = new JavaToKotlinClassMap();
        NUMBERED_FUNCTION_PREFIX = FunctionClassDescriptor.Kind.Function.getPackageFqName().toString() + "." + FunctionClassDescriptor.Kind.Function.getClassNamePrefix();
        NUMBERED_K_FUNCTION_PREFIX = FunctionClassDescriptor.Kind.KFunction.getPackageFqName().toString() + "." + FunctionClassDescriptor.Kind.KFunction.getClassNamePrefix();
        NUMBERED_SUSPEND_FUNCTION_PREFIX = FunctionClassDescriptor.Kind.SuspendFunction.getPackageFqName().toString() + "." + FunctionClassDescriptor.Kind.SuspendFunction.getClassNamePrefix();
        NUMBERED_K_SUSPEND_FUNCTION_PREFIX = FunctionClassDescriptor.Kind.KSuspendFunction.getPackageFqName().toString() + "." + FunctionClassDescriptor.Kind.KSuspendFunction.getClassNamePrefix();
        ClassId classId = ClassId.topLevel(new FqName("kotlin.jvm.functions.FunctionN"));
        Intrinsics.checkExpressionValueIsNotNull(classId, "ClassId.topLevel(FqName(\u2026vm.functions.FunctionN\"))");
        FUNCTION_N_CLASS_ID = classId;
        FqName fqName2 = FUNCTION_N_CLASS_ID.asSingleFqName();
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "FUNCTION_N_CLASS_ID.asSingleFqName()");
        FUNCTION_N_FQ_NAME = fqName2;
        ClassId classId2 = ClassId.topLevel(new FqName("kotlin.reflect.KFunction"));
        Intrinsics.checkExpressionValueIsNotNull(classId2, "ClassId.topLevel(FqName(\u2026tlin.reflect.KFunction\"))");
        K_FUNCTION_CLASS_ID = classId2;
        javaToKotlin = new HashMap();
        kotlinToJava = new HashMap();
        mutableToReadOnly = new HashMap();
        readOnlyToMutable = new HashMap();
        PlatformMutabilityMapping[] platformMutabilityMappingArray = new PlatformMutabilityMapping[8];
        JavaToKotlinClassMap javaToKotlinClassMap2 = javaToKotlinClassMap;
        ClassId classId3 = ClassId.topLevel(KotlinBuiltIns.FQ_NAMES.iterable);
        Intrinsics.checkExpressionValueIsNotNull(classId3, "ClassId.topLevel(FQ_NAMES.iterable)");
        ClassId classId4 = classId3;
        FqName fqName3 = KotlinBuiltIns.FQ_NAMES.mutableIterable;
        Intrinsics.checkExpressionValueIsNotNull(fqName3, "FQ_NAMES.mutableIterable");
        FqName fqName4 = fqName3;
        int n = 0;
        PlatformMutabilityMapping[] platformMutabilityMappingArray2 = platformMutabilityMappingArray;
        PlatformMutabilityMapping[] platformMutabilityMappingArray3 = platformMutabilityMappingArray;
        int $i$f$mutabilityMapping = 0;
        FqName fqName5 = kotlinReadOnly$iv.getPackageFqName();
        FqName fqName6 = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull(fqName6, "kotlinReadOnly.packageFqName");
        ClassId mutableClassId$iv = new ClassId(fqName5, FqNamesUtilKt.tail((FqName)kotlinMutable$iv, fqName6), false);
        platformMutabilityMappingArray2[n] = platformMutabilityMapping = new PlatformMutabilityMapping(this_$iv.classId(Iterable.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = javaToKotlinClassMap;
        ClassId classId5 = ClassId.topLevel(KotlinBuiltIns.FQ_NAMES.iterator);
        Intrinsics.checkExpressionValueIsNotNull(classId5, "ClassId.topLevel(FQ_NAMES.iterator)");
        kotlinReadOnly$iv = classId5;
        Intrinsics.checkExpressionValueIsNotNull(KotlinBuiltIns.FQ_NAMES.mutableIterator, "FQ_NAMES.mutableIterator");
        kotlinMutable$iv = KotlinBuiltIns.FQ_NAMES.mutableIterator;
        n = 1;
        platformMutabilityMappingArray2 = platformMutabilityMappingArray3;
        $i$f$mutabilityMapping = 0;
        FqName fqName7 = kotlinReadOnly$iv.getPackageFqName();
        FqName fqName8 = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull(fqName8, "kotlinReadOnly.packageFqName");
        mutableClassId$iv = new ClassId(fqName7, FqNamesUtilKt.tail((FqName)kotlinMutable$iv, fqName8), false);
        platformMutabilityMappingArray2[n] = platformMutabilityMapping = new PlatformMutabilityMapping(this_$iv.classId(Iterator.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = javaToKotlinClassMap;
        ClassId classId6 = ClassId.topLevel(KotlinBuiltIns.FQ_NAMES.collection);
        Intrinsics.checkExpressionValueIsNotNull(classId6, "ClassId.topLevel(FQ_NAMES.collection)");
        kotlinReadOnly$iv = classId6;
        FqName fqName9 = KotlinBuiltIns.FQ_NAMES.mutableCollection;
        Intrinsics.checkExpressionValueIsNotNull(fqName9, "FQ_NAMES.mutableCollection");
        kotlinMutable$iv = fqName9;
        n = 2;
        platformMutabilityMappingArray2 = platformMutabilityMappingArray3;
        $i$f$mutabilityMapping = 0;
        FqName fqName10 = kotlinReadOnly$iv.getPackageFqName();
        FqName fqName11 = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull(fqName11, "kotlinReadOnly.packageFqName");
        mutableClassId$iv = new ClassId(fqName10, FqNamesUtilKt.tail((FqName)kotlinMutable$iv, fqName11), false);
        platformMutabilityMappingArray2[n] = platformMutabilityMapping = new PlatformMutabilityMapping(this_$iv.classId(Collection.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = javaToKotlinClassMap;
        ClassId classId7 = ClassId.topLevel(KotlinBuiltIns.FQ_NAMES.list);
        Intrinsics.checkExpressionValueIsNotNull(classId7, "ClassId.topLevel(FQ_NAMES.list)");
        kotlinReadOnly$iv = classId7;
        FqName fqName12 = KotlinBuiltIns.FQ_NAMES.mutableList;
        Intrinsics.checkExpressionValueIsNotNull(fqName12, "FQ_NAMES.mutableList");
        kotlinMutable$iv = fqName12;
        n = 3;
        platformMutabilityMappingArray2 = platformMutabilityMappingArray3;
        $i$f$mutabilityMapping = 0;
        FqName fqName13 = kotlinReadOnly$iv.getPackageFqName();
        FqName fqName14 = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull(fqName14, "kotlinReadOnly.packageFqName");
        mutableClassId$iv = new ClassId(fqName13, FqNamesUtilKt.tail((FqName)kotlinMutable$iv, fqName14), false);
        platformMutabilityMappingArray2[n] = platformMutabilityMapping = new PlatformMutabilityMapping(this_$iv.classId(List.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = javaToKotlinClassMap;
        ClassId classId8 = ClassId.topLevel(KotlinBuiltIns.FQ_NAMES.set);
        Intrinsics.checkExpressionValueIsNotNull(classId8, "ClassId.topLevel(FQ_NAMES.set)");
        kotlinReadOnly$iv = classId8;
        FqName fqName15 = KotlinBuiltIns.FQ_NAMES.mutableSet;
        Intrinsics.checkExpressionValueIsNotNull(fqName15, "FQ_NAMES.mutableSet");
        kotlinMutable$iv = fqName15;
        n = 4;
        platformMutabilityMappingArray2 = platformMutabilityMappingArray3;
        $i$f$mutabilityMapping = 0;
        FqName fqName16 = kotlinReadOnly$iv.getPackageFqName();
        FqName fqName17 = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull(fqName17, "kotlinReadOnly.packageFqName");
        mutableClassId$iv = new ClassId(fqName16, FqNamesUtilKt.tail((FqName)kotlinMutable$iv, fqName17), false);
        platformMutabilityMappingArray2[n] = platformMutabilityMapping = new PlatformMutabilityMapping(this_$iv.classId(Set.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = javaToKotlinClassMap;
        ClassId classId9 = ClassId.topLevel(KotlinBuiltIns.FQ_NAMES.listIterator);
        Intrinsics.checkExpressionValueIsNotNull(classId9, "ClassId.topLevel(FQ_NAMES.listIterator)");
        kotlinReadOnly$iv = classId9;
        FqName fqName18 = KotlinBuiltIns.FQ_NAMES.mutableListIterator;
        Intrinsics.checkExpressionValueIsNotNull(fqName18, "FQ_NAMES.mutableListIterator");
        kotlinMutable$iv = fqName18;
        n = 5;
        platformMutabilityMappingArray2 = platformMutabilityMappingArray3;
        $i$f$mutabilityMapping = 0;
        FqName fqName19 = kotlinReadOnly$iv.getPackageFqName();
        FqName fqName20 = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull(fqName20, "kotlinReadOnly.packageFqName");
        mutableClassId$iv = new ClassId(fqName19, FqNamesUtilKt.tail((FqName)kotlinMutable$iv, fqName20), false);
        platformMutabilityMappingArray2[n] = platformMutabilityMapping = new PlatformMutabilityMapping(this_$iv.classId(ListIterator.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = javaToKotlinClassMap;
        ClassId classId10 = ClassId.topLevel(KotlinBuiltIns.FQ_NAMES.map);
        Intrinsics.checkExpressionValueIsNotNull(classId10, "ClassId.topLevel(FQ_NAMES.map)");
        kotlinReadOnly$iv = classId10;
        FqName fqName21 = KotlinBuiltIns.FQ_NAMES.mutableMap;
        Intrinsics.checkExpressionValueIsNotNull(fqName21, "FQ_NAMES.mutableMap");
        kotlinMutable$iv = fqName21;
        n = 6;
        platformMutabilityMappingArray2 = platformMutabilityMappingArray3;
        $i$f$mutabilityMapping = 0;
        FqName fqName22 = kotlinReadOnly$iv.getPackageFqName();
        FqName fqName23 = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull(fqName23, "kotlinReadOnly.packageFqName");
        mutableClassId$iv = new ClassId(fqName22, FqNamesUtilKt.tail((FqName)kotlinMutable$iv, fqName23), false);
        platformMutabilityMappingArray2[n] = platformMutabilityMapping = new PlatformMutabilityMapping(this_$iv.classId(Map.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = javaToKotlinClassMap;
        ClassId classId11 = ClassId.topLevel(KotlinBuiltIns.FQ_NAMES.map).createNestedClassId(KotlinBuiltIns.FQ_NAMES.mapEntry.shortName());
        Intrinsics.checkExpressionValueIsNotNull(classId11, "ClassId.topLevel(FQ_NAME\u2026MES.mapEntry.shortName())");
        kotlinReadOnly$iv = classId11;
        FqName fqName24 = KotlinBuiltIns.FQ_NAMES.mutableMapEntry;
        Intrinsics.checkExpressionValueIsNotNull(fqName24, "FQ_NAMES.mutableMapEntry");
        kotlinMutable$iv = fqName24;
        n = 7;
        platformMutabilityMappingArray2 = platformMutabilityMappingArray3;
        $i$f$mutabilityMapping = 0;
        FqName fqName25 = kotlinReadOnly$iv.getPackageFqName();
        FqName fqName26 = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull(fqName26, "kotlinReadOnly.packageFqName");
        mutableClassId$iv = new ClassId(fqName25, FqNamesUtilKt.tail((FqName)kotlinMutable$iv, fqName26), false);
        platformMutabilityMappingArray2[n] = platformMutabilityMapping = new PlatformMutabilityMapping(this_$iv.classId(Map.Entry.class), kotlinReadOnly$iv, mutableClassId$iv);
        mutabilityMappings = CollectionsKt.listOf(platformMutabilityMappingArray3);
        FqNameUnsafe fqNameUnsafe = KotlinBuiltIns.FQ_NAMES.any;
        Intrinsics.checkExpressionValueIsNotNull(fqNameUnsafe, "FQ_NAMES.any");
        javaToKotlinClassMap.addTopLevel(Object.class, fqNameUnsafe);
        FqNameUnsafe fqNameUnsafe2 = KotlinBuiltIns.FQ_NAMES.string;
        Intrinsics.checkExpressionValueIsNotNull(fqNameUnsafe2, "FQ_NAMES.string");
        javaToKotlinClassMap.addTopLevel(String.class, fqNameUnsafe2);
        FqNameUnsafe fqNameUnsafe3 = KotlinBuiltIns.FQ_NAMES.charSequence;
        Intrinsics.checkExpressionValueIsNotNull(fqNameUnsafe3, "FQ_NAMES.charSequence");
        javaToKotlinClassMap.addTopLevel(CharSequence.class, fqNameUnsafe3);
        FqName fqName27 = KotlinBuiltIns.FQ_NAMES.throwable;
        Intrinsics.checkExpressionValueIsNotNull(fqName27, "FQ_NAMES.throwable");
        javaToKotlinClassMap.addTopLevel(Throwable.class, fqName27);
        FqNameUnsafe fqNameUnsafe4 = KotlinBuiltIns.FQ_NAMES.cloneable;
        Intrinsics.checkExpressionValueIsNotNull(fqNameUnsafe4, "FQ_NAMES.cloneable");
        javaToKotlinClassMap.addTopLevel(Cloneable.class, fqNameUnsafe4);
        FqNameUnsafe fqNameUnsafe5 = KotlinBuiltIns.FQ_NAMES.number;
        Intrinsics.checkExpressionValueIsNotNull(fqNameUnsafe5, "FQ_NAMES.number");
        javaToKotlinClassMap.addTopLevel(Number.class, fqNameUnsafe5);
        FqName fqName28 = KotlinBuiltIns.FQ_NAMES.comparable;
        Intrinsics.checkExpressionValueIsNotNull(fqName28, "FQ_NAMES.comparable");
        javaToKotlinClassMap.addTopLevel(Comparable.class, fqName28);
        FqNameUnsafe fqNameUnsafe6 = KotlinBuiltIns.FQ_NAMES._enum;
        Intrinsics.checkExpressionValueIsNotNull(fqNameUnsafe6, "FQ_NAMES._enum");
        javaToKotlinClassMap.addTopLevel(Enum.class, fqNameUnsafe6);
        FqName fqName29 = KotlinBuiltIns.FQ_NAMES.annotation;
        Intrinsics.checkExpressionValueIsNotNull(fqName29, "FQ_NAMES.annotation");
        javaToKotlinClassMap.addTopLevel(Annotation.class, fqName29);
        for (PlatformMutabilityMapping platformCollection : mutabilityMappings) {
            javaToKotlinClassMap.addMapping(platformCollection);
        }
        for (JvmPrimitiveType jvmType : JvmPrimitiveType.values()) {
            ClassId classId12 = ClassId.topLevel(jvmType.getWrapperFqName());
            Intrinsics.checkExpressionValueIsNotNull(classId12, "ClassId.topLevel(jvmType.wrapperFqName)");
            ClassId classId13 = ClassId.topLevel(KotlinBuiltIns.getPrimitiveFqName(jvmType.getPrimitiveType()));
            Intrinsics.checkExpressionValueIsNotNull(classId13, "ClassId.topLevel(KotlinB\u2026e(jvmType.primitiveType))");
            javaToKotlinClassMap.add(classId12, classId13);
        }
        for (ClassId classId14 : CompanionObjectMapping.INSTANCE.allClassesWithIntrinsicCompanions()) {
            ClassId classId15 = ClassId.topLevel(new FqName("kotlin.jvm.internal." + classId14.getShortClassName().asString() + "CompanionObject"));
            Intrinsics.checkExpressionValueIsNotNull(classId15, "ClassId.topLevel(FqName(\u2026g() + \"CompanionObject\"))");
            ClassId classId16 = classId14.createNestedClassId(SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT);
            Intrinsics.checkExpressionValueIsNotNull(classId16, "classId.createNestedClas\u2026AME_FOR_COMPANION_OBJECT)");
            javaToKotlinClassMap.add(classId15, classId16);
        }
        int classId14 = 0;
        int n2 = 23;
        while (classId14 < n2) {
            ClassId classId17 = ClassId.topLevel(new FqName("kotlin.jvm.functions.Function" + i));
            Intrinsics.checkExpressionValueIsNotNull(classId17, "ClassId.topLevel(FqName(\u2026m.functions.Function$i\"))");
            ClassId classId18 = KotlinBuiltIns.getFunctionClassId(i);
            Intrinsics.checkExpressionValueIsNotNull(classId18, "KotlinBuiltIns.getFunctionClassId(i)");
            javaToKotlinClassMap.add(classId17, classId18);
            javaToKotlinClassMap.addKotlinToJava(new FqName(NUMBERED_K_FUNCTION_PREFIX + i), K_FUNCTION_CLASS_ID);
            ++i;
        }
        n2 = 22;
        for (i = 0; i < n2; ++i) {
            FunctionClassDescriptor.Kind kSuspendFunction = FunctionClassDescriptor.Kind.KSuspendFunction;
            String kSuspendFun = kSuspendFunction.getPackageFqName().toString() + "." + kSuspendFunction.getClassNamePrefix();
            javaToKotlinClassMap.addKotlinToJava(new FqName(kSuspendFun + i), K_FUNCTION_CLASS_ID);
        }
        FqName fqName30 = KotlinBuiltIns.FQ_NAMES.nothing.toSafe();
        Intrinsics.checkExpressionValueIsNotNull(fqName30, "FQ_NAMES.nothing.toSafe()");
        javaToKotlinClassMap.addKotlinToJava(fqName30, javaToKotlinClassMap.classId(Void.class));
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/builtins/jvm/JavaToKotlinClassMap$PlatformMutabilityMapping;", "", "javaClass", "Lorg/jetbrains/kotlin/name/ClassId;", "kotlinReadOnly", "kotlinMutable", "(Lorg/jetbrains/kotlin/name/ClassId;Lorg/jetbrains/kotlin/name/ClassId;Lorg/jetbrains/kotlin/name/ClassId;)V", "getJavaClass", "()Lorg/jetbrains/kotlin/name/ClassId;", "getKotlinMutable", "getKotlinReadOnly", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "descriptors.jvm"})
    public static final class PlatformMutabilityMapping {
        @NotNull
        private final ClassId javaClass;
        @NotNull
        private final ClassId kotlinReadOnly;
        @NotNull
        private final ClassId kotlinMutable;

        @NotNull
        public final ClassId getJavaClass() {
            return this.javaClass;
        }

        @NotNull
        public final ClassId getKotlinReadOnly() {
            return this.kotlinReadOnly;
        }

        @NotNull
        public final ClassId getKotlinMutable() {
            return this.kotlinMutable;
        }

        public PlatformMutabilityMapping(@NotNull ClassId javaClass, @NotNull ClassId kotlinReadOnly, @NotNull ClassId kotlinMutable) {
            Intrinsics.checkParameterIsNotNull(javaClass, "javaClass");
            Intrinsics.checkParameterIsNotNull(kotlinReadOnly, "kotlinReadOnly");
            Intrinsics.checkParameterIsNotNull(kotlinMutable, "kotlinMutable");
            this.javaClass = javaClass;
            this.kotlinReadOnly = kotlinReadOnly;
            this.kotlinMutable = kotlinMutable;
        }

        @NotNull
        public final ClassId component1() {
            return this.javaClass;
        }

        @NotNull
        public final ClassId component2() {
            return this.kotlinReadOnly;
        }

        @NotNull
        public final ClassId component3() {
            return this.kotlinMutable;
        }

        @NotNull
        public final PlatformMutabilityMapping copy(@NotNull ClassId javaClass, @NotNull ClassId kotlinReadOnly, @NotNull ClassId kotlinMutable) {
            Intrinsics.checkParameterIsNotNull(javaClass, "javaClass");
            Intrinsics.checkParameterIsNotNull(kotlinReadOnly, "kotlinReadOnly");
            Intrinsics.checkParameterIsNotNull(kotlinMutable, "kotlinMutable");
            return new PlatformMutabilityMapping(javaClass, kotlinReadOnly, kotlinMutable);
        }

        public static /* synthetic */ PlatformMutabilityMapping copy$default(PlatformMutabilityMapping platformMutabilityMapping, ClassId classId, ClassId classId2, ClassId classId3, int n, Object object) {
            if ((n & 1) != 0) {
                classId = platformMutabilityMapping.javaClass;
            }
            if ((n & 2) != 0) {
                classId2 = platformMutabilityMapping.kotlinReadOnly;
            }
            if ((n & 4) != 0) {
                classId3 = platformMutabilityMapping.kotlinMutable;
            }
            return platformMutabilityMapping.copy(classId, classId2, classId3);
        }

        @NotNull
        public String toString() {
            return "PlatformMutabilityMapping(javaClass=" + this.javaClass + ", kotlinReadOnly=" + this.kotlinReadOnly + ", kotlinMutable=" + this.kotlinMutable + ")";
        }

        public int hashCode() {
            ClassId classId = this.javaClass;
            ClassId classId2 = this.kotlinReadOnly;
            ClassId classId3 = this.kotlinMutable;
            return ((classId != null ? ((Object)classId).hashCode() : 0) * 31 + (classId2 != null ? ((Object)classId2).hashCode() : 0)) * 31 + (classId3 != null ? ((Object)classId3).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof PlatformMutabilityMapping)) break block3;
                    PlatformMutabilityMapping platformMutabilityMapping = (PlatformMutabilityMapping)object;
                    if (!Intrinsics.areEqual(this.javaClass, platformMutabilityMapping.javaClass) || !Intrinsics.areEqual(this.kotlinReadOnly, platformMutabilityMapping.kotlinReadOnly) || !Intrinsics.areEqual(this.kotlinMutable, platformMutabilityMapping.kotlinMutable)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

