""" This module provides the functions for node classification problem.

The functions in this module are not imported
into the top level `networkx` namespace.
You can access these functions by importing
the `networkx.algorithms.node_classification` modules,
then accessing the functions as attributes of `node_classification`.
For example:

  >>> import networkx as nx
  >>> from networkx.algorithms import node_classification
  >>> G = nx.path_graph(4)
  >>> G.edges()
  EdgeView([(0, 1), (1, 2), (2, 3)])
  >>> G.nodes[0]['label'] = 'A'
  >>> G.nodes[3]['label'] = 'B'
  >>> node_classification.harmonic_function(G)  # doctest: +SKIP
  ['A', 'A', 'B', 'B']

"""

from networkx.algorithms.node_classification.hmn import *
from networkx.algorithms.node_classification.lgc import *
