/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.view;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.control.MenuFileControl;
import org.parosproxy.paros.control.MenuToolsControl;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.view.AboutDialog;
import org.zaproxy.zap.view.ZapMenuItem;
import org.zaproxy.zap.view.ZapSupportDialog;

public class MainMenuBar
extends JMenuBar {
    private static final long serialVersionUID = 8580116506279095244L;
    private static final Logger logger = Logger.getLogger(MainMenuBar.class);
    private JMenu menuEdit = null;
    private JMenu menuTools = null;
    private JMenu menuView = null;
    private JMenu menuImport = null;
    private ZapMenuItem menuToolsOptions = null;
    private JMenu menuFile = null;
    private ZapMenuItem menuFileNewSession = null;
    private ZapMenuItem menuFileOpen = null;
    private ZapMenuItem menuFileSaveAs = null;
    private ZapMenuItem menuFileSnapshot = null;
    private ZapMenuItem menuFileContextExport = null;
    private ZapMenuItem menuFileContextImport = null;
    private ZapMenuItem menuFileExit = null;
    private ZapMenuItem menuFileExitAndDelete = null;
    private ZapMenuItem menuFileProperties = null;
    private JMenu menuHelp = null;
    private ZapMenuItem menuHelpAbout = null;
    private ZapMenuItem menuHelpSupport = null;
    private JMenu menuAnalyse = null;
    private JMenu menuZapMode = null;
    private ButtonGroup menuZapModeGroup = null;
    private Map<Control.Mode, JRadioButtonMenuItem> menuZapModeMap = null;
    private JMenu menuReport = null;
    private JMenu menuOnline = null;

    public MainMenuBar() {
        this.initialize();
    }

    private void initialize() {
        this.add(this.getMenuFile());
        this.add(this.getMenuEdit());
        this.add(this.getMenuView());
        this.add(this.getMenuAnalyse());
        this.add(this.getMenuReport());
        this.add(this.getMenuTools());
        this.add(this.getMenuImport());
        this.add(this.getMenuOnline());
        this.add(this.getMenuHelp());
    }

    public JMenu getMenuEdit() {
        if (this.menuEdit == null) {
            this.menuEdit = new JMenu();
            this.menuEdit.setText(Constant.messages.getString("menu.edit"));
            this.menuEdit.setMnemonic(Constant.messages.getChar("menu.edit.mnemonic"));
            this.menuEdit.add(this.getMenuEditZAPMode());
            this.menuEdit.addSeparator();
        }
        return this.menuEdit;
    }

    private JMenuItem getMenuEditZAPMode() {
        if (this.menuZapMode == null) {
            this.menuZapMode = new JMenu(Constant.messages.getString("menu.edit.zapmode"));
            this.menuZapModeGroup = new ButtonGroup();
            this.menuZapModeMap = new HashMap<Control.Mode, JRadioButtonMenuItem>();
            for (Control.Mode modeType : Control.Mode.values()) {
                JRadioButtonMenuItem newButton = this.addZAPModeMenuItem(modeType);
                this.menuZapModeGroup.add(newButton);
                this.menuZapMode.add(newButton);
                this.menuZapModeMap.put(modeType, newButton);
            }
            Control.Mode mode = Control.Mode.valueOf(Model.getSingleton().getOptionsParam().getViewParam().getMode());
            this.setMode(mode);
        }
        return this.menuZapMode;
    }

    private JRadioButtonMenuItem addZAPModeMenuItem(final Control.Mode modeType) {
        JRadioButtonMenuItem modeItem = new JRadioButtonMenuItem(Constant.messages.getString("view.toolbar.mode." + modeType.name() + ".select"));
        modeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Control.getSingleton().setMode(modeType);
                View.getSingleton().getMainFrame().getMainToolbarPanel().setMode(modeType);
            }
        });
        return modeItem;
    }

    public void setMode(final Control.Mode mode) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((JRadioButtonMenuItem)MainMenuBar.this.menuZapModeMap.get((Object)mode)).setSelected(true);
            }
        });
    }

    public JMenu getMenuTools() {
        if (this.menuTools == null) {
            this.menuTools = new JMenu();
            this.menuTools.setText(Constant.messages.getString("menu.tools"));
            this.menuTools.setMnemonic(Constant.messages.getChar("menu.tools.mnemonic"));
            this.menuTools.addSeparator();
            this.menuTools.add(this.getMenuToolsOptions());
        }
        return this.menuTools;
    }

    public JMenu getMenuView() {
        if (this.menuView == null) {
            this.menuView = new JMenu();
            this.menuView.setText(Constant.messages.getString("menu.view"));
            this.menuView.setMnemonic(Constant.messages.getChar("menu.view.mnemonic"));
        }
        return this.menuView;
    }

    public JMenu getMenuImport() {
        if (this.menuImport == null) {
            this.menuImport = new JMenu();
            this.menuImport.setText(Constant.messages.getString("menu.import"));
            this.menuImport.setMnemonic(Constant.messages.getChar("menu.import.mnemonic"));
        }
        return this.menuImport;
    }

    private ZapMenuItem getMenuToolsOptions() {
        if (this.menuToolsOptions == null) {
            this.menuToolsOptions = new ZapMenuItem("menu.tools.options", View.getSingleton().getMenuShortcutKeyStroke(79, 512, false));
            this.menuToolsOptions.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainMenuBar.this.getMenuToolsControl().options();
                }
            });
        }
        return this.menuToolsOptions;
    }

    public JMenu getMenuFile() {
        if (this.menuFile == null) {
            this.menuFile = new JMenu();
            this.menuFile.setText(Constant.messages.getString("menu.file"));
            this.menuFile.setMnemonic(Constant.messages.getChar("menu.file.mnemonic"));
            this.menuFile.add(this.getMenuFileNewSession());
            this.menuFile.add(this.getMenuFileOpen());
            this.menuFile.addSeparator();
            this.menuFile.add(this.getMenuFileSaveAs());
            this.menuFile.add(this.getMenuFileSnapshot());
            this.menuFile.addSeparator();
            this.menuFile.add(this.getMenuFileProperties());
            this.menuFile.addSeparator();
            this.menuFile.add(this.getMenuContextImport());
            this.menuFile.add(this.getMenuContextExport());
            this.menuFile.addSeparator();
            this.menuFile.add(this.getMenuFileExitAndDelete());
            this.menuFile.add(this.getMenuFileExit());
        }
        return this.menuFile;
    }

    private JMenuItem getMenuFileNewSession() {
        if (this.menuFileNewSession == null) {
            this.menuFileNewSession = new ZapMenuItem("menu.file.newSession", View.getSingleton().getMenuShortcutKeyStroke(78, 0, false));
            this.menuFileNewSession.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        MainMenuBar.this.getMenuFileControl().newSession(true);
                    }
                    catch (Exception e1) {
                        View.getSingleton().showWarningDialog(Constant.messages.getString("menu.file.newSession.error"));
                        logger.error((Object)e1.getMessage(), (Throwable)e1);
                    }
                }
            });
        }
        return this.menuFileNewSession;
    }

    private JMenuItem getMenuFileOpen() {
        if (this.menuFileOpen == null) {
            this.menuFileOpen = new ZapMenuItem("menu.file.openSession", View.getSingleton().getMenuShortcutKeyStroke(79, 0, false));
            this.menuFileOpen.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainMenuBar.this.getMenuFileControl().openSession();
                }
            });
        }
        return this.menuFileOpen;
    }

    private JMenuItem getMenuFileSaveAs() {
        if (this.menuFileSaveAs == null) {
            this.menuFileSaveAs = new ZapMenuItem("menu.file.persistSession");
            this.menuFileSaveAs.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (Model.getSingleton().getSession().isNewState()) {
                        MainMenuBar.this.getMenuFileControl().saveAsSession();
                    } else {
                        View.getSingleton().showWarningDialog(Constant.messages.getString("menu.file.sessionExists.error"));
                    }
                }
            });
        }
        return this.menuFileSaveAs;
    }

    private JMenuItem getMenuFileSnapshot() {
        if (this.menuFileSnapshot == null) {
            this.menuFileSnapshot = new ZapMenuItem("menu.file.snapshotSession");
            this.menuFileSnapshot.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!Model.getSingleton().getSession().isNewState()) {
                        MainMenuBar.this.getMenuFileControl().saveSnapshot();
                    } else {
                        View.getSingleton().showWarningDialog(Constant.messages.getString("menu.file.snapshotSession.error"));
                    }
                }
            });
        }
        return this.menuFileSnapshot;
    }

    private JMenuItem getMenuFileExit() {
        if (this.menuFileExit == null) {
            this.menuFileExit = new ZapMenuItem("menu.file.exit");
            this.menuFileExit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainMenuBar.this.getMenuFileControl().exit();
                }
            });
        }
        return this.menuFileExit;
    }

    private JMenuItem getMenuFileExitAndDelete() {
        if (this.menuFileExitAndDelete == null) {
            this.menuFileExitAndDelete = new ZapMenuItem("menu.file.exit.delete");
            this.menuFileExitAndDelete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int ans = View.getSingleton().showConfirmDialog(Constant.messages.getString("menu.file.exit.delete.warning"));
                    if (ans == 0) {
                        Control.getSingleton().exitAndDeleteSession(Model.getSingleton().getSession().getFileName());
                    }
                }
            });
        }
        return this.menuFileExitAndDelete;
    }

    public MenuFileControl getMenuFileControl() {
        return Control.getSingleton().getMenuFileControl();
    }

    private MenuToolsControl getMenuToolsControl() {
        return Control.getSingleton().getMenuToolsControl();
    }

    private ZapMenuItem getMenuFileProperties() {
        if (this.menuFileProperties == null) {
            this.menuFileProperties = new ZapMenuItem("menu.file.properties", View.getSingleton().getMenuShortcutKeyStroke(80, 512, false));
            this.menuFileProperties.setText(Constant.messages.getString("menu.file.properties"));
            this.menuFileProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainMenuBar.this.getMenuFileControl().properties();
                }
            });
        }
        return this.menuFileProperties;
    }

    private ZapMenuItem getMenuContextImport() {
        if (this.menuFileContextImport == null) {
            this.menuFileContextImport = new ZapMenuItem("menu.file.context.import");
            this.menuFileContextImport.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainMenuBar.this.getMenuFileControl().importContext();
                }
            });
        }
        return this.menuFileContextImport;
    }

    private ZapMenuItem getMenuContextExport() {
        if (this.menuFileContextExport == null) {
            this.menuFileContextExport = new ZapMenuItem("menu.file.context.export");
            this.menuFileContextExport.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainMenuBar.this.getMenuFileControl().exportContext();
                }
            });
        }
        return this.menuFileContextExport;
    }

    public JMenu getMenuHelp() {
        if (this.menuHelp == null) {
            this.menuHelp = new JMenu();
            this.menuHelp.setText(Constant.messages.getString("menu.help"));
            this.menuHelp.setMnemonic(Constant.messages.getChar("menu.help.mnemonic"));
            this.menuHelp.add(this.getMenuHelpAbout());
            this.menuHelp.add(this.getMenuHelpSupport());
        }
        return this.menuHelp;
    }

    public JMenu getMenuOnline() {
        if (this.menuOnline == null) {
            this.menuOnline = new JMenu();
            this.menuOnline.setText(Constant.messages.getString("menu.online"));
            this.menuOnline.setMnemonic(Constant.messages.getChar("menu.online.mnemonic"));
        }
        return this.menuOnline;
    }

    public JMenu getMenuReport() {
        if (this.menuReport == null) {
            this.menuReport = new JMenu();
            this.menuReport.setText(Constant.messages.getString("menu.report"));
            this.menuReport.setMnemonic(Constant.messages.getChar("menu.report.mnemonic"));
        }
        return this.menuReport;
    }

    private ZapMenuItem getMenuHelpAbout() {
        if (this.menuHelpAbout == null) {
            this.menuHelpAbout = new ZapMenuItem("menu.help.about");
            this.menuHelpAbout.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AboutDialog dialog = new AboutDialog((Frame)View.getSingleton().getMainFrame(), true);
                    dialog.setVisible(true);
                }
            });
        }
        return this.menuHelpAbout;
    }

    private ZapMenuItem getMenuHelpSupport() {
        if (this.menuHelpSupport == null) {
            this.menuHelpSupport = new ZapMenuItem("menu.help.zap.support");
            this.menuHelpSupport.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ZapSupportDialog zsd = new ZapSupportDialog((Frame)View.getSingleton().getMainFrame(), true);
                    zsd.setVisible(true);
                }
            });
        }
        return this.menuHelpSupport;
    }

    public JMenu getMenuAnalyse() {
        if (this.menuAnalyse == null) {
            this.menuAnalyse = new JMenu();
            this.menuAnalyse.setText(Constant.messages.getString("menu.analyse"));
            this.menuAnalyse.setMnemonic(Constant.messages.getChar("menu.analyse.mnemonic"));
        }
        return this.menuAnalyse;
    }

    public void sessionChanged(Session session) {
        if (session != null) {
            this.getMenuFileSaveAs().setEnabled(session.isNewState());
            this.getMenuFileSnapshot().setEnabled(!session.isNewState());
        }
    }
}

