/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import org.elasticsearch.common.geo.GeoJson;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.geometry.Circle;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.GeometryCollection;
import org.elasticsearch.geometry.GeometryVisitor;
import org.elasticsearch.geometry.Line;
import org.elasticsearch.geometry.LinearRing;
import org.elasticsearch.geometry.MultiLine;
import org.elasticsearch.geometry.MultiPoint;
import org.elasticsearch.geometry.MultiPolygon;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.geometry.Polygon;
import org.elasticsearch.geometry.Rectangle;

public final class GeometryIO {
    public static void writeGeometry(final StreamOutput out, Geometry geometry) throws IOException {
        out.writeString(GeoJson.getGeoJsonName(geometry).toLowerCase(Locale.ROOT));
        geometry.visit((GeometryVisitor)new GeometryVisitor<Void, IOException>(){

            public Void visit(Circle circle) throws IOException {
                throw new UnsupportedOperationException("circle is not supported");
            }

            public Void visit(GeometryCollection<?> collection) throws IOException {
                out.writeVInt(collection.size());
                for (Geometry shape : collection) {
                    GeometryIO.writeGeometry(out, shape);
                }
                return null;
            }

            public Void visit(Line line) throws IOException {
                this.writeCoordinates(line);
                return null;
            }

            public Void visit(LinearRing ring) {
                throw new UnsupportedOperationException("linear ring is not supported");
            }

            public Void visit(MultiLine multiLine) throws IOException {
                out.writeVInt(multiLine.size());
                for (Line line : multiLine) {
                    this.visit(line);
                }
                return null;
            }

            public Void visit(MultiPoint multiPoint) throws IOException {
                out.writeVInt(multiPoint.size());
                for (int i = 0; i < multiPoint.size(); ++i) {
                    Point point = (Point)multiPoint.get(i);
                    this.writeCoordinate(point.getY(), point.getX(), point.getZ());
                }
                return null;
            }

            public Void visit(MultiPolygon multiPolygon) throws IOException {
                out.writeBoolean(true);
                out.writeVInt(multiPolygon.size());
                for (int i = 0; i < multiPolygon.size(); ++i) {
                    this.visit((Polygon)multiPolygon.get(i));
                }
                return null;
            }

            public Void visit(Point point) throws IOException {
                out.writeVInt(1);
                this.writeCoordinate(point.getY(), point.getX(), point.getZ());
                return null;
            }

            public Void visit(Polygon polygon) throws IOException {
                this.writeCoordinates((Line)polygon.getPolygon());
                out.writeBoolean(true);
                out.writeVInt(polygon.getNumberOfHoles());
                for (int i = 0; i < polygon.getNumberOfHoles(); ++i) {
                    this.writeCoordinates((Line)polygon.getHole(i));
                }
                return null;
            }

            public Void visit(Rectangle rectangle) throws IOException {
                this.writeCoordinate(rectangle.getMaxY(), rectangle.getMinX(), rectangle.getMinZ());
                this.writeCoordinate(rectangle.getMinY(), rectangle.getMaxX(), rectangle.getMaxZ());
                return null;
            }

            private void writeCoordinate(double lat, double lon, double alt) throws IOException {
                out.writeDouble(lon);
                out.writeDouble(lat);
                out.writeOptionalDouble(Double.isNaN(alt) ? null : Double.valueOf(alt));
            }

            private void writeCoordinates(Line line) throws IOException {
                out.writeVInt(line.length());
                for (int i = 0; i < line.length(); ++i) {
                    this.writeCoordinate(line.getY(i), line.getX(i), line.getZ(i));
                }
            }
        });
    }

    public static Geometry readGeometry(StreamInput in) throws IOException {
        String type;
        switch (type = in.readString()) {
            case "geometrycollection": {
                return GeometryIO.readGeometryCollection(in);
            }
            case "polygon": {
                return GeometryIO.readPolygon(in);
            }
            case "point": {
                return GeometryIO.readPoint(in);
            }
            case "linestring": {
                return GeometryIO.readLine(in);
            }
            case "multilinestring": {
                return GeometryIO.readMultiLine(in);
            }
            case "multipoint": {
                return GeometryIO.readMultiPoint(in);
            }
            case "multipolygon": {
                return GeometryIO.readMultiPolygon(in);
            }
            case "envelope": {
                return GeometryIO.readRectangle(in);
            }
        }
        throw new UnsupportedOperationException("unsupported shape type " + type);
    }

    private static GeometryCollection<Geometry> readGeometryCollection(StreamInput in) throws IOException {
        int size = in.readVInt();
        ArrayList<Geometry> shapes = new ArrayList<Geometry>(size);
        for (int i = 0; i < size; ++i) {
            shapes.add(GeometryIO.readGeometry(in));
        }
        return new GeometryCollection(shapes);
    }

    private static Polygon readPolygon(StreamInput in) throws IOException {
        double[][] shellComponents = GeometryIO.readLineComponents(in);
        boolean orientation = in.readBoolean();
        LinearRing shell = GeometryIO.buildLinearRing(shellComponents, orientation);
        int numberOfHoles = in.readVInt();
        if (numberOfHoles > 0) {
            ArrayList<LinearRing> holes = new ArrayList<LinearRing>(numberOfHoles);
            for (int i = 0; i < numberOfHoles; ++i) {
                holes.add(GeometryIO.buildLinearRing(GeometryIO.readLineComponents(in), orientation));
            }
            return new Polygon(shell, holes);
        }
        return new Polygon(shell);
    }

    private static double[][] readLineComponents(StreamInput in) throws IOException {
        int len = in.readVInt();
        double[] lat = new double[len];
        double[] lon = new double[len];
        double[] alt = new double[len];
        for (int i = 0; i < len; ++i) {
            lon[i] = in.readDouble();
            lat[i] = in.readDouble();
            alt[i] = GeometryIO.readAlt(in);
        }
        if (Double.isNaN(alt[0])) {
            return new double[][]{lat, lon};
        }
        return new double[][]{lat, lon, alt};
    }

    private static void reverse(double[][] arr) {
        for (double[] carr : arr) {
            int len = carr.length;
            for (int j = 0; j < len / 2; ++j) {
                double temp = carr[j];
                carr[j] = carr[len - j - 1];
                carr[len - j - 1] = temp;
            }
        }
    }

    private static LinearRing buildLinearRing(double[][] arr, boolean orientation) {
        if (!orientation) {
            GeometryIO.reverse(arr);
        }
        if (arr.length == 3) {
            return new LinearRing(arr[1], arr[0], arr[2]);
        }
        return new LinearRing(arr[1], arr[0]);
    }

    private static Point readPoint(StreamInput in) throws IOException {
        int size = in.readVInt();
        if (size != 1) {
            throw new IOException("Unexpected point count " + size);
        }
        double lon = in.readDouble();
        double lat = in.readDouble();
        double alt = GeometryIO.readAlt(in);
        return new Point(lon, lat, alt);
    }

    private static Line readLine(StreamInput in) throws IOException {
        double[][] coords = GeometryIO.readLineComponents(in);
        if (coords.length == 3) {
            return new Line(coords[1], coords[0], coords[2]);
        }
        return new Line(coords[1], coords[0]);
    }

    private static MultiLine readMultiLine(StreamInput in) throws IOException {
        int size = in.readVInt();
        ArrayList<Line> lines = new ArrayList<Line>(size);
        for (int i = 0; i < size; ++i) {
            lines.add(GeometryIO.readLine(in));
        }
        return new MultiLine(lines);
    }

    private static MultiPoint readMultiPoint(StreamInput in) throws IOException {
        int size = in.readVInt();
        ArrayList<Point> points = new ArrayList<Point>(size);
        for (int i = 0; i < size; ++i) {
            double lon = in.readDouble();
            double lat = in.readDouble();
            double alt = GeometryIO.readAlt(in);
            points.add(new Point(lon, lat, alt));
        }
        return new MultiPoint(points);
    }

    private static MultiPolygon readMultiPolygon(StreamInput in) throws IOException {
        in.readBoolean();
        int size = in.readVInt();
        ArrayList<Polygon> polygons = new ArrayList<Polygon>(size);
        for (int i = 0; i < size; ++i) {
            polygons.add(GeometryIO.readPolygon(in));
        }
        return new MultiPolygon(polygons);
    }

    private static Rectangle readRectangle(StreamInput in) throws IOException {
        double minLon = in.readDouble();
        double maxLat = in.readDouble();
        double minAlt = GeometryIO.readAlt(in);
        double maxLon = in.readDouble();
        double minLat = in.readDouble();
        double maxAlt = GeometryIO.readAlt(in);
        return new Rectangle(minLon, maxLon, maxLat, minLat, minAlt, maxAlt);
    }

    private static double readAlt(StreamInput in) throws IOException {
        Double alt = in.readOptionalDouble();
        if (alt == null) {
            return Double.NaN;
        }
        return alt;
    }
}

