/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.useragent;

import java.util.Objects;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.ingest.useragent.UserAgentParser;

class UserAgentCache {
    private final Cache<CompositeCacheKey, UserAgentParser.Details> cache;

    UserAgentCache(long cacheSize) {
        this.cache = CacheBuilder.builder().setMaximumWeight(cacheSize).build();
    }

    public UserAgentParser.Details get(String parserName, String userAgent) {
        return (UserAgentParser.Details)this.cache.get((Object)new CompositeCacheKey(parserName, userAgent));
    }

    public void put(String parserName, String userAgent, UserAgentParser.Details details) {
        this.cache.put((Object)new CompositeCacheKey(parserName, userAgent), (Object)details);
    }

    private static final class CompositeCacheKey {
        private final String parserName;
        private final String userAgent;

        CompositeCacheKey(String parserName, String userAgent) {
            this.parserName = parserName;
            this.userAgent = userAgent;
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof CompositeCacheKey) {
                CompositeCacheKey s = (CompositeCacheKey)obj;
                return this.parserName.equals(s.parserName) && this.userAgent.equals(s.userAgent);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.parserName, this.userAgent);
        }
    }
}

