/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.FindClassInModuleKt;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationArgumentVisitor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.resolve.constants.ClassLiteralValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0019\u001aB\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0017\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u000bJ=\u0010\f\u001a\n \u000e*\u0004\u0018\u0001H\rH\r\"\u0004\b\u0000\u0010\r\"\u0004\b\u0001\u0010\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u0002H\u000f0\u00112\u0006\u0010\u0012\u001a\u0002H\u000fH\u0016\u00a2\u0006\u0002\u0010\u0013J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/KClassValue;", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "Lorg/jetbrains/kotlin/resolve/constants/KClassValue$Value;", "value", "Lorg/jetbrains/kotlin/resolve/constants/ClassLiteralValue;", "(Lorg/jetbrains/kotlin/resolve/constants/ClassLiteralValue;)V", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "arrayDimensions", "", "(Lorg/jetbrains/kotlin/name/ClassId;I)V", "(Lorg/jetbrains/kotlin/resolve/constants/KClassValue$Value;)V", "accept", "R", "kotlin.jvm.PlatformType", "D", "visitor", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationArgumentVisitor;", "data", "(Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationArgumentVisitor;Ljava/lang/Object;)Ljava/lang/Object;", "getArgumentType", "Lorg/jetbrains/kotlin/types/KotlinType;", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "getType", "Companion", "Value", "descriptors"})
public final class KClassValue
extends ConstantValue<Value> {
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public KotlinType getType(@NotNull ModuleDescriptor module2) {
        Intrinsics.checkParameterIsNotNull(module2, "module");
        Annotations annotations2 = Annotations.Companion.getEMPTY();
        ClassDescriptor classDescriptor2 = module2.getBuiltIns().getKClass();
        Intrinsics.checkExpressionValueIsNotNull(classDescriptor2, "module.builtIns.kClass");
        return KotlinTypeFactory.simpleNotNullType(annotations2, classDescriptor2, CollectionsKt.listOf(new TypeProjectionImpl(this.getArgumentType(module2))));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final KotlinType getArgumentType(@NotNull ModuleDescriptor module2) {
        Intrinsics.checkParameterIsNotNull(module2, "module");
        Value value2 = (Value)this.getValue();
        if (value2 instanceof Value.LocalClass) {
            return ((Value.LocalClass)this.getValue()).getType();
        }
        if (value2 instanceof Value.NormalClass) {
            void classId;
            ClassLiteralValue classLiteralValue = ((Value.NormalClass)this.getValue()).getValue();
            ClassId classId2 = classLiteralValue.component1();
            int arrayDimensions = classLiteralValue.component2();
            ClassDescriptor classDescriptor2 = FindClassInModuleKt.findClassAcrossModuleDependencies(module2, (ClassId)classId);
            if (classDescriptor2 == null) {
                SimpleType simpleType2 = ErrorUtils.createErrorType("Unresolved type: " + classId + " (arrayDimensions=" + arrayDimensions + ')');
                Intrinsics.checkExpressionValueIsNotNull(simpleType2, "ErrorUtils.createErrorTy\u2026sions=$arrayDimensions)\")");
                return simpleType2;
            }
            ClassDescriptor descriptor2 = classDescriptor2;
            SimpleType simpleType3 = descriptor2.getDefaultType();
            Intrinsics.checkExpressionValueIsNotNull(simpleType3, "descriptor.defaultType");
            KotlinType type2 = TypeUtilsKt.replaceArgumentsWithStarProjections(simpleType3);
            boolean bl = false;
            int n = 0;
            n = 0;
            int n2 = arrayDimensions;
            while (n < n2) {
                int it = n++;
                boolean bl2 = false;
                SimpleType simpleType4 = module2.getBuiltIns().getArrayType(Variance.INVARIANT, type2);
                Intrinsics.checkExpressionValueIsNotNull(simpleType4, "module.builtIns.getArray\u2026Variance.INVARIANT, type)");
                type2 = simpleType4;
            }
            return type2;
        }
        throw new NoWhenBranchMatchedException();
    }

    @Override
    public <R, D> R accept(@NotNull AnnotationArgumentVisitor<R, D> visitor2, D data) {
        Intrinsics.checkParameterIsNotNull(visitor2, "visitor");
        return visitor2.visitKClassValue(this, data);
    }

    public KClassValue(@NotNull Value value2) {
        Intrinsics.checkParameterIsNotNull(value2, "value");
        super(value2);
    }

    public KClassValue(@NotNull ClassLiteralValue value2) {
        Intrinsics.checkParameterIsNotNull(value2, "value");
        this(new Value.NormalClass(value2));
    }

    public KClassValue(@NotNull ClassId classId, int arrayDimensions) {
        Intrinsics.checkParameterIsNotNull(classId, "classId");
        this(new ClassLiteralValue(classId, arrayDimensions));
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/KClassValue$Value;", "", "()V", "LocalClass", "NormalClass", "Lorg/jetbrains/kotlin/resolve/constants/KClassValue$Value$NormalClass;", "Lorg/jetbrains/kotlin/resolve/constants/KClassValue$Value$LocalClass;", "descriptors"})
    public static abstract class Value {
        private Value() {
        }

        public /* synthetic */ Value(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/KClassValue$Value$NormalClass;", "Lorg/jetbrains/kotlin/resolve/constants/KClassValue$Value;", "value", "Lorg/jetbrains/kotlin/resolve/constants/ClassLiteralValue;", "(Lorg/jetbrains/kotlin/resolve/constants/ClassLiteralValue;)V", "arrayDimensions", "", "getArrayDimensions", "()I", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "getClassId", "()Lorg/jetbrains/kotlin/name/ClassId;", "getValue", "()Lorg/jetbrains/kotlin/resolve/constants/ClassLiteralValue;", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "", "descriptors"})
        public static final class NormalClass
        extends Value {
            @NotNull
            private final ClassLiteralValue value;

            @NotNull
            public final ClassId getClassId() {
                return this.value.getClassId();
            }

            public final int getArrayDimensions() {
                return this.value.getArrayNestedness();
            }

            @NotNull
            public final ClassLiteralValue getValue() {
                return this.value;
            }

            public NormalClass(@NotNull ClassLiteralValue value2) {
                Intrinsics.checkParameterIsNotNull(value2, "value");
                super(null);
                this.value = value2;
            }

            @NotNull
            public final ClassLiteralValue component1() {
                return this.value;
            }

            @NotNull
            public final NormalClass copy(@NotNull ClassLiteralValue value2) {
                Intrinsics.checkParameterIsNotNull(value2, "value");
                return new NormalClass(value2);
            }

            public static /* synthetic */ NormalClass copy$default(NormalClass normalClass, ClassLiteralValue classLiteralValue, int n, Object object) {
                if ((n & 1) != 0) {
                    classLiteralValue = normalClass.value;
                }
                return normalClass.copy(classLiteralValue);
            }

            @NotNull
            public String toString() {
                return "NormalClass(value=" + this.value + ")";
            }

            public int hashCode() {
                ClassLiteralValue classLiteralValue = this.value;
                return classLiteralValue != null ? ((Object)classLiteralValue).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof NormalClass)) break block3;
                        NormalClass normalClass = (NormalClass)object;
                        if (!Intrinsics.areEqual(this.value, normalClass.value)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/KClassValue$Value$LocalClass;", "Lorg/jetbrains/kotlin/resolve/constants/KClassValue$Value;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/types/KotlinType;)V", "getType", "()Lorg/jetbrains/kotlin/types/KotlinType;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "descriptors"})
        public static final class LocalClass
        extends Value {
            @NotNull
            private final KotlinType type;

            @NotNull
            public final KotlinType getType() {
                return this.type;
            }

            public LocalClass(@NotNull KotlinType type2) {
                Intrinsics.checkParameterIsNotNull(type2, "type");
                super(null);
                this.type = type2;
            }

            @NotNull
            public final KotlinType component1() {
                return this.type;
            }

            @NotNull
            public final LocalClass copy(@NotNull KotlinType type2) {
                Intrinsics.checkParameterIsNotNull(type2, "type");
                return new LocalClass(type2);
            }

            public static /* synthetic */ LocalClass copy$default(LocalClass localClass, KotlinType kotlinType2, int n, Object object) {
                if ((n & 1) != 0) {
                    kotlinType2 = localClass.type;
                }
                return localClass.copy(kotlinType2);
            }

            @NotNull
            public String toString() {
                return "LocalClass(type=" + this.type + ")";
            }

            public int hashCode() {
                KotlinType kotlinType2 = this.type;
                return kotlinType2 != null ? ((Object)kotlinType2).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof LocalClass)) break block3;
                        LocalClass localClass = (LocalClass)object;
                        if (!Intrinsics.areEqual(this.type, localClass.type)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/KClassValue$Companion;", "", "()V", "create", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "argumentType", "Lorg/jetbrains/kotlin/types/KotlinType;", "descriptors"})
    public static final class Companion {
        @Nullable
        public final ConstantValue<?> create(@NotNull KotlinType argumentType) {
            ConstantValue constantValue;
            Intrinsics.checkParameterIsNotNull(argumentType, "argumentType");
            if (KotlinTypeKt.isError(argumentType)) {
                return null;
            }
            KotlinType type2 = argumentType;
            int arrayDimensions = 0;
            while (KotlinBuiltIns.isArray(type2)) {
                Intrinsics.checkExpressionValueIsNotNull(CollectionsKt.single(type2.getArguments()).getType(), "type.arguments.single().type");
                ++arrayDimensions;
            }
            ClassifierDescriptor descriptor2 = type2.getConstructor().getDeclarationDescriptor();
            if (descriptor2 instanceof ClassDescriptor) {
                ClassId classId = DescriptorUtilsKt.getClassId(descriptor2);
                if (classId == null) {
                    return new KClassValue(new Value.LocalClass(argumentType));
                }
                ClassId classId2 = classId;
                constantValue = new KClassValue(classId2, arrayDimensions);
            } else if (descriptor2 instanceof TypeParameterDescriptor) {
                ClassId classId = ClassId.topLevel(KotlinBuiltIns.FQ_NAMES.any.toSafe());
                Intrinsics.checkExpressionValueIsNotNull(classId, "ClassId.topLevel(KotlinB\u2026ns.FQ_NAMES.any.toSafe())");
                constantValue = new KClassValue(classId, 0);
            } else {
                constantValue = null;
            }
            return constantValue;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

