/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.db.paros;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.DbUtils;
import org.parosproxy.paros.db.RecordStructure;
import org.parosproxy.paros.db.TableStructure;
import org.parosproxy.paros.db.paros.ParosAbstractTable;

public class ParosTableStructure
extends ParosAbstractTable
implements TableStructure {
    private static final String TABLE_NAME = "STRUCTURE";
    private static final String STRUCTUREID = "STRUCTUREID";
    private static final String SESSIONID = "SESSIONID";
    private static final String PARENTID = "PARENTID";
    private static final String HISTORYID = "HISTORYID";
    private static final String NAME = "NAME";
    private static final String NAMEHASH = "NAMEHASH";
    private static final String URL = "URL";
    private static final String METHOD = "METHOD";
    private PreparedStatement psRead = null;
    private PreparedStatement psFind = null;
    private PreparedStatement psInsert = null;
    private CallableStatement psGetIdLastInsert = null;
    private PreparedStatement psGetChildren = null;
    private PreparedStatement psGetChildCount = null;

    @Override
    protected void reconnect(Connection conn) throws DatabaseException {
        try {
            if (!DbUtils.hasTable(conn, TABLE_NAME)) {
                DbUtils.execute(conn, "CREATE cached TABLE STRUCTURE (STRUCTUREID bigint generated by default as identity (start with 1), SESSIONID bigint not null, PARENTID bigint not null, HISTORYID int, NAME varchar(8192) not null, NAMEHASH bigint not null, URL varchar(8192) not null, METHOD varchar(10) not null)");
            }
            this.psRead = conn.prepareStatement("SELECT * FROM STRUCTURE WHERE SESSIONID = ? AND STRUCTUREID = ?");
            this.psFind = conn.prepareStatement("SELECT * FROM STRUCTURE WHERE SESSIONID = ? AND NAMEHASH = ? AND METHOD = ?");
            this.psInsert = conn.prepareStatement("INSERT INTO STRUCTURE (SESSIONID, PARENTID, HISTORYID, NAME, NAMEHASH, URL, METHOD) VALUES (?, ?, ?, ?, ?, ?, ?)");
            this.psGetIdLastInsert = conn.prepareCall("CALL IDENTITY();");
            this.psGetChildren = conn.prepareStatement("SELECT * FROM STRUCTURE WHERE SESSIONID = ? AND PARENTID = ?");
            this.psGetChildCount = conn.prepareStatement("SELECT COUNT(*) FROM STRUCTURE WHERE SESSIONID = ? AND PARENTID = ?");
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized RecordStructure read(long sessionId, long urlId) throws DatabaseException {
        try {
            this.psRead.setLong(1, sessionId);
            this.psRead.setLong(2, urlId);
            try (ResultSet rs = this.psRead.executeQuery();){
                RecordStructure result;
                RecordStructure recordStructure = result = this.build(rs);
                return recordStructure;
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public RecordStructure insert(long sessionId, long parentId, int historyId, String name, String url, String method) throws DatabaseException {
        try {
            long id;
            this.psInsert.setLong(1, sessionId);
            this.psInsert.setLong(2, parentId);
            this.psInsert.setInt(3, historyId);
            this.psInsert.setString(4, name);
            this.psInsert.setInt(5, name.hashCode());
            this.psInsert.setString(6, url);
            this.psInsert.setString(7, method);
            this.psInsert.executeUpdate();
            try (ResultSet rs = this.psGetIdLastInsert.executeQuery();){
                rs.next();
                id = rs.getLong(1);
            }
            return this.read(sessionId, id);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RecordStructure find(long sessionId, String name, String method) throws DatabaseException {
        try {
            this.psFind.setLong(1, sessionId);
            this.psFind.setInt(2, name.hashCode());
            this.psFind.setString(3, method);
            try (ResultSet rs = this.psFind.executeQuery();){
                do {
                    if (!rs.next()) return null;
                } while (!name.equals(rs.getString(NAME)));
                RecordStructure recordStructure = this.build(rs);
                return recordStructure;
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public List<RecordStructure> getChildren(long sessionId, long parentId) throws DatabaseException {
        try {
            this.psGetChildren.setLong(1, sessionId);
            this.psGetChildren.setLong(2, parentId);
            ArrayList<RecordStructure> result = new ArrayList<RecordStructure>();
            try (ResultSet rs = this.psGetChildren.executeQuery();){
                while (rs.next()) {
                    result.add(this.build(rs));
                }
            }
            return result;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getChildCount(long sessionId, long parentId) throws DatabaseException {
        try {
            this.psGetChildCount.setLong(1, sessionId);
            this.psGetChildCount.setLong(2, parentId);
            try (ResultSet rs = this.psGetChildCount.executeQuery();){
                if (!rs.next()) return 0L;
                long l = rs.getLong(1);
                return l;
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public void deleteLeaf(long sessionId, long structureId) throws DatabaseException {
    }

    @Override
    public void deleteSubtree(long sessionId, long structureId) throws DatabaseException {
    }

    private RecordStructure build(ResultSet rs) throws DatabaseException {
        try {
            RecordStructure rt = null;
            if (rs.next()) {
                rt = new RecordStructure(rs.getLong(SESSIONID), rs.getLong(STRUCTUREID), rs.getLong(PARENTID), rs.getInt(HISTORYID), rs.getString(NAME), rs.getString(URL), rs.getString(METHOD));
            }
            return rt;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }
}

