/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.util;

import io.ktor.util.InternalAPI;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlinx.io.pool.ObjectPool;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u0007\u001a$\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u00052\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u0007\u001a\u0016\u0010\u0006\u001a\u00020\u0007*\u00020\u00012\b\b\u0002\u0010\b\u001a\u00020\tH\u0007\u001a\u001e\u0010\n\u001a\u00020\u0003*\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00012\b\b\u0002\u0010\f\u001a\u00020\u0003H\u0007\u001a\f\u0010\r\u001a\u00020\u000e*\u00020\u0001H\u0007\u00a8\u0006\u000f"}, d2={"copy", "Ljava/nio/ByteBuffer;", "size", "", "pool", "Lkotlinx/io/pool/ObjectPool;", "decodeString", "", "charset", "Ljava/nio/charset/Charset;", "moveTo", "destination", "limit", "moveToByteArray", "", "ktor-utils-jvm"})
public final class NIOKt {
    @InternalAPI
    public static final int moveTo(@NotNull ByteBuffer $receiver, @NotNull ByteBuffer destination, int limit) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        int n = $receiver.remaining();
        int n2 = destination.remaining();
        int n3 = Math.min(n, n2);
        int size = Math.min(limit, n3);
        if (size == $receiver.remaining()) {
            destination.put($receiver);
        } else {
            int l = $receiver.limit();
            $receiver.limit($receiver.position() + size);
            destination.put($receiver);
            $receiver.limit(l);
        }
        return size;
    }

    @InternalAPI
    public static /* synthetic */ int moveTo$default(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = Integer.MAX_VALUE;
        }
        return NIOKt.moveTo(byteBuffer, byteBuffer2, n);
    }

    @InternalAPI
    @NotNull
    public static final byte[] moveToByteArray(@NotNull ByteBuffer $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        byte[] array = new byte[$receiver.remaining()];
        $receiver.get(array);
        return array;
    }

    @InternalAPI
    @NotNull
    public static final String decodeString(@NotNull ByteBuffer $receiver, @NotNull Charset charset) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)charset, (String)"charset");
        String string = charset.decode($receiver).toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"charset.decode(this).toString()");
        return string;
    }

    @InternalAPI
    @NotNull
    public static /* synthetic */ String decodeString$default(ByteBuffer byteBuffer, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        return NIOKt.decodeString(byteBuffer, charset);
    }

    @InternalAPI
    @NotNull
    public static final ByteBuffer copy(@NotNull ByteBuffer $receiver, int size) {
        ByteBuffer byteBuffer;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        ByteBuffer $receiver2 = byteBuffer = ByteBuffer.allocate(size);
        ByteBuffer byteBuffer2 = $receiver.slice();
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer2, (String)"this@copy.slice()");
        ByteBuffer byteBuffer3 = $receiver2;
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer3, (String)"this@apply");
        NIOKt.moveTo$default(byteBuffer2, byteBuffer3, 0, 2, null);
        $receiver2.clear();
        ByteBuffer byteBuffer4 = byteBuffer;
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer4, (String)"ByteBuffer.allocate(size\u2026ly)\n        clear()\n    }");
        return byteBuffer4;
    }

    @InternalAPI
    @NotNull
    public static /* synthetic */ ByteBuffer copy$default(ByteBuffer byteBuffer, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = byteBuffer.remaining();
        }
        return NIOKt.copy(byteBuffer, n);
    }

    @InternalAPI
    @NotNull
    public static final ByteBuffer copy(@NotNull ByteBuffer $receiver, @NotNull ObjectPool<ByteBuffer> pool, int size) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull(pool, (String)"pool");
        Object object = pool.borrow();
        ByteBuffer $receiver2 = (ByteBuffer)object;
        $receiver2.limit(size);
        ByteBuffer byteBuffer = $receiver.slice();
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"this@copy.slice()");
        NIOKt.moveTo$default(byteBuffer, $receiver2, 0, 2, null);
        $receiver2.flip();
        return (ByteBuffer)object;
    }

    @InternalAPI
    @NotNull
    public static /* synthetic */ ByteBuffer copy$default(ByteBuffer byteBuffer, ObjectPool objectPool, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = byteBuffer.remaining();
        }
        return NIOKt.copy(byteBuffer, (ObjectPool<ByteBuffer>)objectPool, n);
    }
}

