/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.core;

import com.intellij.codeInsight.folding.CodeFoldingSettings;
import com.intellij.concurrency.JobLauncher;
import com.intellij.core.CoreASTFactory;
import com.intellij.core.CoreEncodingRegistry;
import com.intellij.core.CoreFileTypeRegistry;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.lang.DefaultASTFactory;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lang.impl.PsiBuilderFactoryImpl;
import com.intellij.mock.MockApplication;
import com.intellij.mock.MockApplicationEx;
import com.intellij.mock.MockFileDocumentManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.impl.CoreCommandProcessor;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.extensions.BaseExtensionPointName;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeExtension;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.util.ClassExtension;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.StaticGetter;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.impl.CoreVirtualFilePointerManager;
import com.intellij.openapi.vfs.impl.VirtualFileManagerImpl;
import com.intellij.openapi.vfs.impl.jar.CoreJarFileSystem;
import com.intellij.openapi.vfs.local.CoreLocalFileSystem;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.PsiReferenceServiceImpl;
import com.intellij.psi.impl.meta.MetaRegistry;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistryImpl;
import com.intellij.psi.meta.MetaDataRegistrar;
import com.intellij.psi.stubs.CoreStubTreeLoader;
import com.intellij.psi.stubs.StubTreeLoader;
import com.intellij.util.KeyedLazyInstanceEP;
import com.intellij.util.graph.GraphAlgorithms;
import com.intellij.util.graph.impl.GraphAlgorithmsImpl;
import java.io.File;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.MutablePicoContainer;

public class CoreApplicationEnvironment {
    private final CoreFileTypeRegistry myFileTypeRegistry;
    protected final MockApplication myApplication;
    private final CoreLocalFileSystem myLocalFileSystem;
    protected final VirtualFileSystem myJarFileSystem;
    private final VirtualFileSystem myJrtFileSystem;
    @NotNull
    private final Disposable myParentDisposable;
    private final boolean myUnitTestMode;

    public CoreApplicationEnvironment(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(0);
        }
        this(parentDisposable, true);
    }

    public CoreApplicationEnvironment(@NotNull Disposable parentDisposable, boolean unitTestMode) {
        if (parentDisposable == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(1);
        }
        this.myParentDisposable = parentDisposable;
        this.myUnitTestMode = unitTestMode;
        PluginManagerCore.dontLoadDisabledPlugins();
        this.myFileTypeRegistry = new CoreFileTypeRegistry();
        this.myApplication = this.createApplication(this.myParentDisposable);
        ApplicationManager.setApplication(this.myApplication, new StaticGetter<FileTypeRegistry>(this.myFileTypeRegistry), this.myParentDisposable);
        this.myLocalFileSystem = this.createLocalFileSystem();
        this.myJarFileSystem = this.createJarFileSystem();
        this.myJrtFileSystem = this.createJrtFileSystem();
        Extensions.registerAreaClass("IDEA_PROJECT", null);
        MutablePicoContainer appContainer = this.myApplication.getPicoContainer();
        CoreApplicationEnvironment.registerComponentInstance(appContainer, FileDocumentManager.class, new MockFileDocumentManagerImpl(charSequence -> new DocumentImpl((CharSequence)charSequence), null));
        List<VirtualFileSystem> fs = this.myJrtFileSystem != null ? Arrays.asList(this.myLocalFileSystem, this.myJarFileSystem, this.myJrtFileSystem) : Arrays.asList(this.myLocalFileSystem, this.myJarFileSystem);
        VirtualFileManagerImpl virtualFileManager = new VirtualFileManagerImpl(fs);
        this.registerApplicationComponent(VirtualFileManager.class, virtualFileManager);
        CoreApplicationEnvironment.registerApplicationExtensionPoint(new ExtensionPointName("com.intellij.virtualFileSystem"), KeyedLazyInstanceEP.class);
        this.registerApplicationService(EncodingManager.class, new CoreEncodingRegistry());
        this.registerApplicationService(VirtualFilePointerManager.class, this.createVirtualFilePointerManager());
        this.registerApplicationService(DefaultASTFactory.class, new CoreASTFactory());
        this.registerApplicationService(PsiBuilderFactory.class, new PsiBuilderFactoryImpl());
        this.registerApplicationService(ReferenceProvidersRegistry.class, new ReferenceProvidersRegistryImpl());
        this.registerApplicationService(StubTreeLoader.class, new CoreStubTreeLoader());
        this.registerApplicationService(PsiReferenceService.class, new PsiReferenceServiceImpl());
        this.registerApplicationService(MetaDataRegistrar.class, new MetaRegistry());
        this.registerApplicationService(ProgressManager.class, this.createProgressIndicatorProvider());
        this.registerApplicationService(JobLauncher.class, this.createJobLauncher());
        this.registerApplicationService(CodeFoldingSettings.class, new CodeFoldingSettings());
        this.registerApplicationService(CommandProcessor.class, new CoreCommandProcessor());
        this.registerApplicationService(GraphAlgorithms.class, new GraphAlgorithmsImpl());
        this.myApplication.registerService(ApplicationInfo.class, ApplicationInfoImpl.class);
    }

    public <T> void registerApplicationService(@NotNull Class<T> serviceInterface, @NotNull T serviceImplementation) {
        if (serviceInterface == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(2);
        }
        if (serviceImplementation == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(3);
        }
        this.myApplication.registerService(serviceInterface, serviceImplementation);
    }

    @NotNull
    protected VirtualFilePointerManager createVirtualFilePointerManager() {
        CoreVirtualFilePointerManager coreVirtualFilePointerManager = new CoreVirtualFilePointerManager();
        if (coreVirtualFilePointerManager == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(4);
        }
        return coreVirtualFilePointerManager;
    }

    @NotNull
    protected MockApplication createApplication(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(5);
        }
        MockApplicationEx mockApplicationEx = new MockApplicationEx(parentDisposable){

            @Override
            public boolean isUnitTestMode() {
                return CoreApplicationEnvironment.this.myUnitTestMode;
            }
        };
        if (mockApplicationEx == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(6);
        }
        return mockApplicationEx;
    }

    @NotNull
    protected JobLauncher createJobLauncher() {
        JobLauncher jobLauncher = new JobLauncher(){};
        if (jobLauncher == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(7);
        }
        return jobLauncher;
    }

    @NotNull
    protected ProgressManager createProgressIndicatorProvider() {
        CoreProgressManager coreProgressManager = new CoreProgressManager();
        if (coreProgressManager == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(8);
        }
        return coreProgressManager;
    }

    @NotNull
    protected VirtualFileSystem createJarFileSystem() {
        CoreJarFileSystem coreJarFileSystem = new CoreJarFileSystem();
        if (coreJarFileSystem == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(9);
        }
        return coreJarFileSystem;
    }

    @NotNull
    protected CoreLocalFileSystem createLocalFileSystem() {
        CoreLocalFileSystem coreLocalFileSystem = new CoreLocalFileSystem();
        if (coreLocalFileSystem == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(10);
        }
        return coreLocalFileSystem;
    }

    @Nullable
    protected VirtualFileSystem createJrtFileSystem() {
        return null;
    }

    @NotNull
    public MockApplication getApplication() {
        MockApplication mockApplication = this.myApplication;
        if (mockApplication == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(11);
        }
        return mockApplication;
    }

    @NotNull
    public Disposable getParentDisposable() {
        Disposable disposable = this.myParentDisposable;
        if (disposable == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(12);
        }
        return disposable;
    }

    public <T> void registerApplicationComponent(@NotNull Class<T> interfaceClass, @NotNull T implementation) {
        if (interfaceClass == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(13);
        }
        if (implementation == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(14);
        }
        CoreApplicationEnvironment.registerComponentInstance(this.myApplication.getPicoContainer(), interfaceClass, implementation);
        if (implementation instanceof Disposable) {
            Disposer.register(this.myApplication, (Disposable)implementation);
        }
    }

    public void registerFileType(@NotNull FileType fileType, @NotNull String extension2) {
        if (fileType == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(15);
        }
        if (extension2 == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(16);
        }
        this.myFileTypeRegistry.registerFileType(fileType, extension2);
    }

    public void registerParserDefinition(@NotNull ParserDefinition definition) {
        if (definition == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(17);
        }
        this.addExplicitExtension(LanguageParserDefinitions.INSTANCE, definition.getFileNodeType().getLanguage(), definition);
    }

    public static <T> void registerComponentInstance(@NotNull MutablePicoContainer container, @NotNull Class<T> key, @NotNull T implementation) {
        if (container == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(18);
        }
        if (key == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(19);
        }
        if (implementation == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(20);
        }
        container.unregisterComponent(key);
        container.registerComponentInstance(key, implementation);
    }

    public <T> void addExplicitExtension(@NotNull LanguageExtension<T> instance, @NotNull Language language, @NotNull T object) {
        if (instance == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(21);
        }
        if (language == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(22);
        }
        if (object == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(23);
        }
        instance.addExplicitExtension(language, object, this.myParentDisposable);
    }

    public void registerParserDefinition(@NotNull Language language, @NotNull ParserDefinition parserDefinition) {
        if (language == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(24);
        }
        if (parserDefinition == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(25);
        }
        this.addExplicitExtension(LanguageParserDefinitions.INSTANCE, language, parserDefinition);
    }

    public <T> void addExplicitExtension(@NotNull FileTypeExtension<T> instance, @NotNull FileType fileType, @NotNull T object) {
        if (instance == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(26);
        }
        if (fileType == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(27);
        }
        if (object == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(28);
        }
        instance.addExplicitExtension(fileType, object, this.myParentDisposable);
    }

    public <T> void addExplicitExtension(@NotNull ClassExtension<T> instance, @NotNull Class aClass2, @NotNull T object) {
        if (instance == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(29);
        }
        if (aClass2 == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(30);
        }
        if (object == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(31);
        }
        instance.addExplicitExtension(aClass2, object, this.myParentDisposable);
    }

    public <T> void addExtension(@NotNull ExtensionPointName<T> name, @NotNull T extension2) {
        if (name == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(32);
        }
        if (extension2 == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(33);
        }
        ExtensionPoint<T> extensionPoint = Extensions.getRootArea().getExtensionPoint(name);
        extensionPoint.registerExtension(extension2, this.myParentDisposable);
    }

    public static <T> void registerExtensionPoint(@NotNull ExtensionsArea area, @NotNull ExtensionPointName<T> extensionPointName, @NotNull Class<? extends T> aClass2) {
        if (area == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(34);
        }
        if (extensionPointName == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(35);
        }
        if (aClass2 == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(36);
        }
        CoreApplicationEnvironment.registerExtensionPoint(area, extensionPointName.getName(), aClass2);
    }

    public static <T> void registerExtensionPoint(@NotNull ExtensionsArea area, @NotNull BaseExtensionPointName extensionPointName, @NotNull Class<? extends T> aClass2) {
        if (area == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(37);
        }
        if (extensionPointName == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(38);
        }
        if (aClass2 == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(39);
        }
        CoreApplicationEnvironment.registerExtensionPoint(area, extensionPointName.getName(), aClass2);
    }

    public static <T> void registerExtensionPoint(@NotNull ExtensionsArea area, @NotNull String name, @NotNull Class<? extends T> aClass2) {
        if (area == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(40);
        }
        if (name == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(41);
        }
        if (aClass2 == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(42);
        }
        if (!area.hasExtensionPoint(name)) {
            ExtensionPoint.Kind kind = aClass2.isInterface() || Modifier.isAbstract(aClass2.getModifiers()) ? ExtensionPoint.Kind.INTERFACE : ExtensionPoint.Kind.BEAN_CLASS;
            area.registerExtensionPoint(name, aClass2.getName(), kind);
        }
    }

    public static <T> void registerApplicationExtensionPoint(@NotNull ExtensionPointName<T> extensionPointName, @NotNull Class<? extends T> aClass2) {
        if (extensionPointName == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(43);
        }
        if (aClass2 == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(44);
        }
        CoreApplicationEnvironment.registerExtensionPoint(Extensions.getRootArea(), extensionPointName, aClass2);
    }

    public static void registerExtensionPointAndExtensions(@NotNull File pluginRoot2, @NotNull String fileName, @NotNull ExtensionsArea area) {
        if (pluginRoot2 == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(45);
        }
        if (fileName == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(46);
        }
        if (area == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(47);
        }
        PluginManagerCore.registerExtensionPointAndExtensions(pluginRoot2, fileName, area);
    }

    @NotNull
    public CoreLocalFileSystem getLocalFileSystem() {
        CoreLocalFileSystem coreLocalFileSystem = this.myLocalFileSystem;
        if (coreLocalFileSystem == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(48);
        }
        return coreLocalFileSystem;
    }

    @NotNull
    public VirtualFileSystem getJarFileSystem() {
        VirtualFileSystem virtualFileSystem = this.myJarFileSystem;
        if (virtualFileSystem == null) {
            CoreApplicationEnvironment.$$$reportNull$$$0(49);
        }
        return virtualFileSystem;
    }

    @Nullable
    public VirtualFileSystem getJrtFileSystem() {
        return this.myJrtFileSystem;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 48: 
            case 49: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 48: 
            case 49: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceInterface";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceImplementation";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 48: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/core/CoreApplicationEnvironment";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaceClass";
                break;
            }
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implementation";
                break;
            }
            case 15: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 16: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 21: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instance";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 23: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parserDefinition";
                break;
            }
            case 30: 
            case 36: 
            case 39: 
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 32: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 34: 
            case 37: 
            case 40: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "area";
                break;
            }
            case 35: 
            case 38: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPointName";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginRoot";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/core/CoreApplicationEnvironment";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createVirtualFilePointerManager";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createApplication";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createJobLauncher";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createProgressIndicatorProvider";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createJarFileSystem";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createLocalFileSystem";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplication";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentDisposable";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalFileSystem";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getJarFileSystem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerApplicationService";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 48: 
            case 49: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createApplication";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "registerApplicationComponent";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "registerFileType";
                break;
            }
            case 17: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "registerParserDefinition";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "registerComponentInstance";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "addExplicitExtension";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "addExtension";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensionPoint";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "registerApplicationExtensionPoint";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensionPointAndExtensions";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 48: 
            case 49: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

