/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.inline;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.inline.CapturedParamInfo;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtilsKt;
import org.jetbrains.kotlin.codegen.inline.ParameterInfo;
import org.jetbrains.kotlin.codegen.inline.Parameters;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002!\"B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J\u000e\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015J@\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\b\u0010\u001a\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015J\u001e\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020 R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/codegen/inline/LocalVarRemapper;", "", "params", "Lorg/jetbrains/kotlin/codegen/inline/Parameters;", "additionalShift", "", "(Lorg/jetbrains/kotlin/codegen/inline/Parameters;I)V", "actualParamsSize", "remapValues", "", "Lorg/jetbrains/kotlin/codegen/StackValue;", "[Lorg/jetbrains/kotlin/codegen/StackValue;", "doRemap", "Lorg/jetbrains/kotlin/codegen/inline/LocalVarRemapper$RemapInfo;", "index", "remap", "visitIincInsn", "", "var", "increment", "mv", "Lorg/jetbrains/org/objectweb/asm/MethodVisitor;", "visitLocalVariable", "name", "", "desc", "signature", "start", "Lorg/jetbrains/org/objectweb/asm/Label;", "end", "visitVarInsn", "opcode", "Lorg/jetbrains/org/objectweb/asm/commons/InstructionAdapter;", "RemapInfo", "RemapStatus", "backend"})
public final class LocalVarRemapper {
    private final int actualParamsSize;
    private final StackValue[] remapValues;
    private final Parameters params;
    private final int additionalShift;

    private final RemapInfo doRemap(int index2) {
        int remappedIndex = 0;
        if (index2 < this.params.getArgsSizeOnStack()) {
            ParameterInfo info2 = this.params.getParameterByDeclarationSlot(index2);
            StackValue remapped = this.remapValues[index2];
            if (info2.isSkipped() || remapped == null) {
                return new RemapInfo(info2, null, null, 6, null);
            }
            if (info2.isRemapped()) {
                return new RemapInfo(info2, remapped, RemapStatus.REMAPPED);
            }
            remappedIndex = ((StackValue.Local)remapped).index;
        } else {
            remappedIndex = this.actualParamsSize - this.params.getArgsSizeOnStack() + index2;
        }
        return new RemapInfo(null, StackValue.local(remappedIndex + this.additionalShift, AsmTypes.OBJECT_TYPE), RemapStatus.SHIFT);
    }

    @NotNull
    public final RemapInfo remap(int index2) {
        RemapInfo info2 = this.doRemap(index2);
        if (RemapStatus.FAIL == info2.status) {
            boolean bl = info2.parameterInfo != null;
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string2 = "Parameter info for " + index2 + " variable should be not null";
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            StringBuilder stringBuilder = new StringBuilder().append("Trying to access skipped parameter: ");
            ParameterInfo parameterInfo = info2.parameterInfo;
            if (parameterInfo == null) {
                Intrinsics.throwNpe();
            }
            throw (Throwable)new RuntimeException(stringBuilder.append(parameterInfo.getType()).append(" at ").append(index2).toString());
        }
        return info2;
    }

    public final void visitIincInsn(int var, int increment, @NotNull MethodVisitor mv) {
        Intrinsics.checkParameterIsNotNull(mv, "mv");
        RemapInfo remap = this.remap(var);
        if (!(remap.value instanceof StackValue.Local)) {
            throw (Throwable)((Object)new AssertionError((Object)("Remapped value should be a local: " + remap.value)));
        }
        mv.visitIincInsn(((StackValue.Local)remap.value).index, increment);
    }

    public final void visitLocalVariable(@NotNull String name, @NotNull String desc, @Nullable String signature, @NotNull Label start, @NotNull Label end, int index2, @NotNull MethodVisitor mv) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(desc, "desc");
        Intrinsics.checkParameterIsNotNull(start, "start");
        Intrinsics.checkParameterIsNotNull(end, "end");
        Intrinsics.checkParameterIsNotNull(mv, "mv");
        RemapInfo info2 = this.doRemap(index2);
        if (RemapStatus.SHIFT == info2.status) {
            StackValue stackValue = info2.value;
            if (stackValue == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.codegen.StackValue.Local");
            }
            mv.visitLocalVariable(name, desc, signature, start, end, ((StackValue.Local)stackValue).index);
        }
    }

    public final void visitVarInsn(int opcode, int var, @NotNull InstructionAdapter mv) {
        Intrinsics.checkParameterIsNotNull(mv, "mv");
        RemapInfo remapInfo = this.remap(var);
        StackValue value2 = remapInfo.value;
        if (value2 instanceof StackValue.Local) {
            boolean isStore = InlineCodegenUtilsKt.isStoreInstruction(opcode);
            int localOpcode = remapInfo.parameterInfo != null ? value2.type.getOpcode(isStore ? 54 : 21) : opcode;
            mv.visitVarInsn(localOpcode, ((StackValue.Local)value2).index);
            if (remapInfo.parameterInfo != null && !isStore) {
                StackValue.coerce(value2.type, remapInfo.parameterInfo.getType(), mv);
            }
        } else {
            boolean bl = remapInfo.parameterInfo != null;
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string2 = "Non local value should have parameter info";
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            StackValue stackValue = value2;
            if (stackValue == null) {
                Intrinsics.throwNpe();
            }
            ParameterInfo parameterInfo = remapInfo.parameterInfo;
            if (parameterInfo == null) {
                Intrinsics.throwNpe();
            }
            stackValue.put(parameterInfo.getType(), mv);
        }
    }

    public LocalVarRemapper(@NotNull Parameters params, int additionalShift) {
        Intrinsics.checkParameterIsNotNull(params, "params");
        this.params = params;
        this.additionalShift = additionalShift;
        this.remapValues = new StackValue[this.params.getArgsSizeOnStack()];
        int realSize = 0;
        for (ParameterInfo info2 : this.params) {
            int shift = this.params.getDeclarationSlot(info2);
            if (!info2.isSkippedOrRemapped()) {
                this.remapValues[shift] = StackValue.local(realSize, AsmTypes.OBJECT_TYPE);
                realSize += info2.getType().getSize();
                continue;
            }
            StackValue stackValue = this.remapValues[shift] = info2.isRemapped() ? info2.getRemapValue() : null;
            if (!CapturedParamInfo.Companion.isSynthetic(info2)) continue;
            realSize += info2.getType().getSize();
        }
        this.actualParamsSize = realSize;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/codegen/inline/LocalVarRemapper$RemapStatus;", "", "(Ljava/lang/String;I)V", "SHIFT", "REMAPPED", "FAIL", "backend"})
    public static final class RemapStatus
    extends Enum<RemapStatus> {
        public static final /* enum */ RemapStatus SHIFT;
        public static final /* enum */ RemapStatus REMAPPED;
        public static final /* enum */ RemapStatus FAIL;
        private static final /* synthetic */ RemapStatus[] $VALUES;

        static {
            RemapStatus[] remapStatusArray = new RemapStatus[3];
            RemapStatus[] remapStatusArray2 = remapStatusArray;
            remapStatusArray[0] = SHIFT = new RemapStatus();
            remapStatusArray[1] = REMAPPED = new RemapStatus();
            remapStatusArray[2] = FAIL = new RemapStatus();
            $VALUES = remapStatusArray;
        }

        public static RemapStatus[] values() {
            return (RemapStatus[])$VALUES.clone();
        }

        public static RemapStatus valueOf(String string2) {
            return Enum.valueOf(RemapStatus.class, string2);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/codegen/inline/LocalVarRemapper$RemapInfo;", "", "parameterInfo", "Lorg/jetbrains/kotlin/codegen/inline/ParameterInfo;", "value", "Lorg/jetbrains/kotlin/codegen/StackValue;", "status", "Lorg/jetbrains/kotlin/codegen/inline/LocalVarRemapper$RemapStatus;", "(Lorg/jetbrains/kotlin/codegen/inline/ParameterInfo;Lorg/jetbrains/kotlin/codegen/StackValue;Lorg/jetbrains/kotlin/codegen/inline/LocalVarRemapper$RemapStatus;)V", "backend"})
    public static final class RemapInfo {
        @JvmField
        @Nullable
        public final ParameterInfo parameterInfo;
        @JvmField
        @Nullable
        public final StackValue value;
        @JvmField
        @NotNull
        public final RemapStatus status;

        public RemapInfo(@Nullable ParameterInfo parameterInfo, @Nullable StackValue value2, @NotNull RemapStatus status2) {
            Intrinsics.checkParameterIsNotNull((Object)status2, "status");
            this.parameterInfo = parameterInfo;
            this.value = value2;
            this.status = status2;
        }

        public /* synthetic */ RemapInfo(ParameterInfo parameterInfo, StackValue stackValue, RemapStatus remapStatus, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                stackValue = null;
            }
            if ((n & 4) != 0) {
                remapStatus = RemapStatus.FAIL;
            }
            this(parameterInfo, stackValue, remapStatus);
        }
    }
}

