/*
 * Decompiled with CFR 0.152.
 */
package gnu.mail.handler;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import javax.activation.ActivationDataFlavor;
import javax.activation.DataContentHandler;
import javax.activation.DataSource;
import javax.activation.UnsupportedDataTypeException;
import javax.mail.MessageAware;
import javax.mail.MessageContext;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;

public abstract class Message
implements DataContentHandler {
    protected DataFlavor flavor;

    protected Message(String mimeType, String description) {
        this.flavor = new ActivationDataFlavor(javax.mail.Message.class, mimeType, description);
    }

    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] flavors = new DataFlavor[]{this.flavor};
        return flavors;
    }

    public Object getTransferData(DataFlavor flavor, DataSource source) throws UnsupportedFlavorException, IOException {
        if (this.flavor.equals(flavor)) {
            return this.getContent(source);
        }
        return null;
    }

    public Object getContent(DataSource source) throws IOException {
        try {
            Session session = null;
            if (source instanceof MessageAware) {
                MessageAware ma = (MessageAware)source;
                MessageContext context = ma.getMessageContext();
                session = context.getSession();
            } else {
                Properties props = null;
                session = Session.getDefaultInstance(props, null);
            }
            InputStream in = source.getInputStream();
            return new MimeMessage(session, in);
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void writeTo(Object object, String mimeType, OutputStream out) throws IOException {
        if (object instanceof javax.mail.Message) {
            try {
                ((javax.mail.Message)object).writeTo(out);
            }
            catch (MessagingException e) {
                throw new IOException(e.getMessage());
            }
        } else {
            throw new UnsupportedDataTypeException();
        }
    }
}

