/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.servlet;

import org.directwebremoting.util.LocalUtil;

public class BaseModule {
    private final String contextPath;
    private final String servletPath;
    private final String separator;
    protected final StringBuilder contentBuf = new StringBuilder();

    public BaseModule(String contextPath, String servletPath, String separator) {
        this.contextPath = contextPath.replace("/", separator);
        this.servletPath = servletPath.replace("/", separator);
        this.separator = separator;
    }

    public void addContent(String content) {
        this.contentBuf.append(content);
    }

    public String expandModulePath(String baseModulePath) {
        String expandedBaseModulePath = baseModulePath.replace("${contextPath}", this.contextPath).replace("${servletPath}", this.servletPath);
        while (expandedBaseModulePath.indexOf(this.separator + this.separator) > 0) {
            expandedBaseModulePath.replaceAll(this.separator + this.separator, this.separator);
        }
        if (!baseModulePath.startsWith(this.separator) && expandedBaseModulePath.startsWith(this.separator)) {
            expandedBaseModulePath = expandedBaseModulePath.substring(this.separator.length());
        }
        if (expandedBaseModulePath.endsWith(this.separator) && expandedBaseModulePath.length() > this.separator.length()) {
            expandedBaseModulePath = expandedBaseModulePath.substring(0, expandedBaseModulePath.length() - this.separator.length());
        }
        return expandedBaseModulePath;
    }

    public String expandModulePath(String baseModulePath, String moduleName) {
        String expandedModulePath = this.expandModulePath(baseModulePath);
        String expandedModuleName = moduleName.replaceAll("\\.", this.separator);
        String sep = "";
        if (LocalUtil.hasLength(expandedModulePath) && LocalUtil.hasLength(expandedModuleName)) {
            sep = this.separator;
        }
        return expandedModulePath + sep + expandedModuleName;
    }
}

