/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.DocIdSetBuilder;

abstract class RangeFieldQuery
extends Query {
    final String field;
    final QueryType queryType;
    final int numDims;
    final byte[] ranges;
    final int bytesPerDim;

    RangeFieldQuery(String field, byte[] ranges, int numDims, QueryType queryType) {
        RangeFieldQuery.checkArgs(field, ranges, numDims);
        if (queryType == null) {
            throw new IllegalArgumentException("Query type cannot be null");
        }
        this.field = field;
        this.queryType = queryType;
        this.numDims = numDims;
        this.ranges = ranges;
        this.bytesPerDim = ranges.length / (2 * numDims);
    }

    private static void checkArgs(String field, byte[] ranges, int numDims) {
        if (field == null) {
            throw new IllegalArgumentException("field must not be null");
        }
        if (numDims > 4) {
            throw new IllegalArgumentException("dimension size cannot be greater than 4");
        }
        if (ranges == null || ranges.length == 0) {
            throw new IllegalArgumentException("encoded ranges cannot be null or empty");
        }
    }

    private void checkFieldInfo(FieldInfo fieldInfo) {
        if (fieldInfo.getPointDataDimensionCount() / 2 != this.numDims) {
            throw new IllegalArgumentException("field=\"" + this.field + "\" was indexed with numDims=" + fieldInfo.getPointDataDimensionCount() / 2 + " but this query has numDims=" + this.numDims);
        }
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf(this);
        }
    }

    @Override
    public final Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        return new ConstantScoreWeight(this, boost){

            private PointValues.IntersectVisitor getIntersectVisitor(final DocIdSetBuilder result) {
                return new PointValues.IntersectVisitor(){
                    DocIdSetBuilder.BulkAdder adder;

                    @Override
                    public void grow(int count) {
                        this.adder = result.grow(count);
                    }

                    @Override
                    public void visit(int docID) throws IOException {
                        this.adder.add(docID);
                    }

                    @Override
                    public void visit(int docID, byte[] leaf) throws IOException {
                        if (RangeFieldQuery.this.queryType.matches(RangeFieldQuery.this.ranges, leaf, RangeFieldQuery.this.numDims, RangeFieldQuery.this.bytesPerDim)) {
                            this.visit(docID);
                        }
                    }

                    @Override
                    public void visit(DocIdSetIterator iterator, byte[] leaf) throws IOException {
                        if (RangeFieldQuery.this.queryType.matches(RangeFieldQuery.this.ranges, leaf, RangeFieldQuery.this.numDims, RangeFieldQuery.this.bytesPerDim)) {
                            int docID;
                            while ((docID = iterator.nextDoc()) != Integer.MAX_VALUE) {
                                this.visit(docID);
                            }
                        }
                    }

                    @Override
                    public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                        return RangeFieldQuery.this.queryType.compare(RangeFieldQuery.this.ranges, minPackedValue, maxPackedValue, RangeFieldQuery.this.numDims, RangeFieldQuery.this.bytesPerDim);
                    }
                };
            }

            @Override
            public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                final LeafReader reader = context.reader();
                final PointValues values = reader.getPointValues(RangeFieldQuery.this.field);
                if (values == null) {
                    return null;
                }
                FieldInfo fieldInfo = reader.getFieldInfos().fieldInfo(RangeFieldQuery.this.field);
                if (fieldInfo == null) {
                    return null;
                }
                RangeFieldQuery.this.checkFieldInfo(fieldInfo);
                boolean allDocsMatch = false;
                if (values.getDocCount() == reader.maxDoc() && RangeFieldQuery.this.queryType.compare(RangeFieldQuery.this.ranges, values.getMinPackedValue(), values.getMaxPackedValue(), RangeFieldQuery.this.numDims, RangeFieldQuery.this.bytesPerDim) == PointValues.Relation.CELL_INSIDE_QUERY) {
                    allDocsMatch = true;
                }
                final 1 weight = this;
                if (allDocsMatch) {
                    return new ScorerSupplier(){

                        @Override
                        public Scorer get(long leadCost) {
                            return new ConstantScoreScorer(weight, this.score(), scoreMode, DocIdSetIterator.all(reader.maxDoc()));
                        }

                        @Override
                        public long cost() {
                            return reader.maxDoc();
                        }
                    };
                }
                return new ScorerSupplier(){
                    final DocIdSetBuilder result;
                    final PointValues.IntersectVisitor visitor;
                    long cost;
                    {
                        this.result = new DocIdSetBuilder(reader.maxDoc(), values, RangeFieldQuery.this.field);
                        this.visitor = this.getIntersectVisitor(this.result);
                        this.cost = -1L;
                    }

                    @Override
                    public Scorer get(long leadCost) throws IOException {
                        values.intersect(this.visitor);
                        DocIdSetIterator iterator = this.result.build().iterator();
                        return new ConstantScoreScorer(weight, this.score(), scoreMode, iterator);
                    }

                    @Override
                    public long cost() {
                        if (this.cost == -1L) {
                            this.cost = values.estimatePointCount(this.visitor);
                            assert (this.cost >= 0L);
                        }
                        return this.cost;
                    }
                };
            }

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                ScorerSupplier scorerSupplier = this.scorerSupplier(context);
                if (scorerSupplier == null) {
                    return null;
                }
                return scorerSupplier.get(Long.MAX_VALUE);
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return true;
            }
        };
    }

    @Override
    public int hashCode() {
        int hash = this.classHash();
        hash = 31 * hash + this.field.hashCode();
        hash = 31 * hash + this.numDims;
        hash = 31 * hash + this.queryType.hashCode();
        hash = 31 * hash + Arrays.hashCode(this.ranges);
        return hash;
    }

    @Override
    public final boolean equals(Object o) {
        return this.sameClassAs(o) && this.equalsTo((RangeFieldQuery)this.getClass().cast(o));
    }

    protected boolean equalsTo(RangeFieldQuery other) {
        return Objects.equals(this.field, other.field) && this.numDims == other.numDims && Arrays.equals(this.ranges, other.ranges) && other.queryType == this.queryType;
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        if (!this.field.equals(field)) {
            sb.append(this.field);
            sb.append(':');
        }
        sb.append("<ranges:");
        sb.append(this.toString(this.ranges, 0));
        for (int d = 1; d < this.numDims; ++d) {
            sb.append(' ');
            sb.append(this.toString(this.ranges, d));
        }
        sb.append('>');
        return sb.toString();
    }

    protected abstract String toString(byte[] var1, int var2);

    static enum QueryType {
        INTERSECTS{

            @Override
            PointValues.Relation compare(byte[] queryPackedValue, byte[] minPackedValue, byte[] maxPackedValue, int numDims, int bytesPerDim, int dim) {
                int minOffset = dim * bytesPerDim;
                int maxOffset = minOffset + bytesPerDim * numDims;
                if (Arrays.compareUnsigned(queryPackedValue, maxOffset, maxOffset + bytesPerDim, minPackedValue, minOffset, minOffset + bytesPerDim) < 0 || Arrays.compareUnsigned(queryPackedValue, minOffset, minOffset + bytesPerDim, maxPackedValue, maxOffset, maxOffset + bytesPerDim) > 0) {
                    return PointValues.Relation.CELL_OUTSIDE_QUERY;
                }
                if (Arrays.compareUnsigned(queryPackedValue, maxOffset, maxOffset + bytesPerDim, maxPackedValue, minOffset, minOffset + bytesPerDim) >= 0 && Arrays.compareUnsigned(queryPackedValue, minOffset, minOffset + bytesPerDim, minPackedValue, maxOffset, maxOffset + bytesPerDim) <= 0) {
                    return PointValues.Relation.CELL_INSIDE_QUERY;
                }
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }

            @Override
            boolean matches(byte[] queryPackedValue, byte[] packedValue, int numDims, int bytesPerDim, int dim) {
                int minOffset = dim * bytesPerDim;
                int maxOffset = minOffset + bytesPerDim * numDims;
                return Arrays.compareUnsigned(queryPackedValue, maxOffset, maxOffset + bytesPerDim, packedValue, minOffset, minOffset + bytesPerDim) >= 0 && Arrays.compareUnsigned(queryPackedValue, minOffset, minOffset + bytesPerDim, packedValue, maxOffset, maxOffset + bytesPerDim) <= 0;
            }
        }
        ,
        WITHIN{

            @Override
            PointValues.Relation compare(byte[] queryPackedValue, byte[] minPackedValue, byte[] maxPackedValue, int numDims, int bytesPerDim, int dim) {
                int minOffset = dim * bytesPerDim;
                int maxOffset = minOffset + bytesPerDim * numDims;
                if (Arrays.compareUnsigned(queryPackedValue, maxOffset, maxOffset + bytesPerDim, minPackedValue, maxOffset, maxOffset + bytesPerDim) < 0 || Arrays.compareUnsigned(queryPackedValue, minOffset, minOffset + bytesPerDim, maxPackedValue, minOffset, minOffset + bytesPerDim) > 0) {
                    return PointValues.Relation.CELL_OUTSIDE_QUERY;
                }
                if (Arrays.compareUnsigned(queryPackedValue, maxOffset, maxOffset + bytesPerDim, maxPackedValue, maxOffset, maxOffset + bytesPerDim) >= 0 && Arrays.compareUnsigned(queryPackedValue, minOffset, minOffset + bytesPerDim, minPackedValue, minOffset, minOffset + bytesPerDim) <= 0) {
                    return PointValues.Relation.CELL_INSIDE_QUERY;
                }
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }

            @Override
            boolean matches(byte[] queryPackedValue, byte[] packedValue, int numDims, int bytesPerDim, int dim) {
                int minOffset = dim * bytesPerDim;
                int maxOffset = minOffset + bytesPerDim * numDims;
                return Arrays.compareUnsigned(queryPackedValue, minOffset, minOffset + bytesPerDim, packedValue, minOffset, minOffset + bytesPerDim) <= 0 && Arrays.compareUnsigned(queryPackedValue, maxOffset, maxOffset + bytesPerDim, packedValue, maxOffset, maxOffset + bytesPerDim) >= 0;
            }
        }
        ,
        CONTAINS{

            @Override
            PointValues.Relation compare(byte[] queryPackedValue, byte[] minPackedValue, byte[] maxPackedValue, int numDims, int bytesPerDim, int dim) {
                int minOffset = dim * bytesPerDim;
                int maxOffset = minOffset + bytesPerDim * numDims;
                if (Arrays.compareUnsigned(queryPackedValue, maxOffset, maxOffset + bytesPerDim, maxPackedValue, maxOffset, maxOffset + bytesPerDim) > 0 || Arrays.compareUnsigned(queryPackedValue, minOffset, minOffset + bytesPerDim, minPackedValue, minOffset, minOffset + bytesPerDim) < 0) {
                    return PointValues.Relation.CELL_OUTSIDE_QUERY;
                }
                if (Arrays.compareUnsigned(queryPackedValue, maxOffset, maxOffset + bytesPerDim, minPackedValue, maxOffset, maxOffset + bytesPerDim) <= 0 && Arrays.compareUnsigned(queryPackedValue, minOffset, minOffset + bytesPerDim, maxPackedValue, minOffset, minOffset + bytesPerDim) >= 0) {
                    return PointValues.Relation.CELL_INSIDE_QUERY;
                }
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }

            @Override
            boolean matches(byte[] queryPackedValue, byte[] packedValue, int numDims, int bytesPerDim, int dim) {
                int minOffset = dim * bytesPerDim;
                int maxOffset = minOffset + bytesPerDim * numDims;
                return Arrays.compareUnsigned(queryPackedValue, minOffset, minOffset + bytesPerDim, packedValue, minOffset, minOffset + bytesPerDim) >= 0 && Arrays.compareUnsigned(queryPackedValue, maxOffset, maxOffset + bytesPerDim, packedValue, maxOffset, maxOffset + bytesPerDim) <= 0;
            }
        }
        ,
        CROSSES{

            @Override
            PointValues.Relation compare(byte[] queryPackedValue, byte[] minPackedValue, byte[] maxPackedValue, int numDims, int bytesPerDim, int dim) {
                throw new UnsupportedOperationException();
            }

            @Override
            boolean matches(byte[] queryPackedValue, byte[] packedValue, int numDims, int bytesPerDim, int dim) {
                throw new UnsupportedOperationException();
            }

            @Override
            PointValues.Relation compare(byte[] queryPackedValue, byte[] minPackedValue, byte[] maxPackedValue, int numDims, int bytesPerDim) {
                PointValues.Relation intersectRelation = INTERSECTS.compare(queryPackedValue, minPackedValue, maxPackedValue, numDims, bytesPerDim);
                if (intersectRelation == PointValues.Relation.CELL_OUTSIDE_QUERY) {
                    return PointValues.Relation.CELL_OUTSIDE_QUERY;
                }
                PointValues.Relation withinRelation = WITHIN.compare(queryPackedValue, minPackedValue, maxPackedValue, numDims, bytesPerDim);
                if (withinRelation == PointValues.Relation.CELL_INSIDE_QUERY) {
                    return PointValues.Relation.CELL_OUTSIDE_QUERY;
                }
                if (intersectRelation == PointValues.Relation.CELL_INSIDE_QUERY && withinRelation == PointValues.Relation.CELL_OUTSIDE_QUERY) {
                    return PointValues.Relation.CELL_INSIDE_QUERY;
                }
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }

            @Override
            boolean matches(byte[] queryPackedValue, byte[] packedValue, int numDims, int bytesPerDim) {
                return INTERSECTS.matches(queryPackedValue, packedValue, numDims, bytesPerDim) && !WITHIN.matches(queryPackedValue, packedValue, numDims, bytesPerDim);
            }
        };


        abstract PointValues.Relation compare(byte[] var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

        PointValues.Relation compare(byte[] queryPackedValue, byte[] minPackedValue, byte[] maxPackedValue, int numDims, int bytesPerDim) {
            boolean inside = true;
            for (int dim = 0; dim < numDims; ++dim) {
                PointValues.Relation relation = this.compare(queryPackedValue, minPackedValue, maxPackedValue, numDims, bytesPerDim, dim);
                if (relation == PointValues.Relation.CELL_OUTSIDE_QUERY) {
                    return PointValues.Relation.CELL_OUTSIDE_QUERY;
                }
                if (relation == PointValues.Relation.CELL_INSIDE_QUERY) continue;
                inside = false;
            }
            return inside ? PointValues.Relation.CELL_INSIDE_QUERY : PointValues.Relation.CELL_CROSSES_QUERY;
        }

        abstract boolean matches(byte[] var1, byte[] var2, int var3, int var4, int var5);

        boolean matches(byte[] queryPackedValue, byte[] packedValue, int numDims, int bytesPerDim) {
            for (int dim = 0; dim < numDims; ++dim) {
                if (this.matches(queryPackedValue, packedValue, numDims, bytesPerDim, dim)) continue;
                return false;
            }
            return true;
        }
    }
}

