/***********************************************************************
*                                                                      *
* This file is part of CARAT.                                          *
* Copyright (C) 2015  Tilman Schulz                                    *
*                                                                      *
* CARAT is free software: you can redistribute it and/or modify        *
* it under the terms of the GNU General Public License as published by *
* the Free Software Foundation, either version 3 of the License, or    *
* (at your option) any later version.                                  *
*                                                                      *
* This program is distributed in the hope that it will be useful,      *
* but WITHOUT ANY WARRANTY; without even the implied warranty of       *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
* GNU General Public License for more details.                         *
*                                                                      *
* You should have received a copy of the GNU General Public License    *
* along with this program.  If not, see <http://www.gnu.org/licenses/> *
*                                                                      *
***********************************************************************/
#include"typedef.h"
#include"getput.h"
#include"bravais.h"
#include"matrix.h"


int SFLAG;

main (int argc, char *argv[])
{
  int anz,
      i;

  matrix_TYP **F,
              *tmp;

  read_header(argc, argv);
  if(FILEANZ != 1)
  {
    printf("usage: Inv file\n");
    printf(" where file contains a matrix_TYP.\n");
    printf("\n");
    printf(" Inverts the matrices given in file.\n");
    printf("\n");
    printf("\n");
    if (is_option('h')){
       exit(0);
    }
    else{
       exit(31);
    }
  }

  if (is_option('h') && optionnumber('h')==12){
     SFLAG = 1;
  }

  F = mget_mat(FILENAMES[0],&anz);

  printf("#%d\n",anz);

  for (i=0;i<anz;i++){
     Check_mat(F[i]);
     tmp = mat_inv(F[i]);
     rat2kgv(tmp);
     Check_mat(tmp);
     put_mat(tmp,NULL,NULL,2);
     free_mat(tmp);
     free_mat(F[i]);
  }

  free(F);
  if (is_option('h') && optionnumber('h')==12){
     pointer_statistics(0,0);
  }

  exit(0);
}

