/***********************************************************************
*                                                                      *
* This file is part of CARAT.                                          *
* Copyright (C) 2015  Tilman Schulz                                    *
*                                                                      *
* CARAT is free software: you can redistribute it and/or modify        *
* it under the terms of the GNU General Public License as published by *
* the Free Software Foundation, either version 3 of the License, or    *
* (at your option) any later version.                                  *
*                                                                      *
* This program is distributed in the hope that it will be useful,      *
* but WITHOUT ANY WARRANTY; without even the implied warranty of       *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
* GNU General Public License for more details.                         *
*                                                                      *
* You should have received a copy of the GNU General Public License    *
* along with this program.  If not, see <http://www.gnu.org/licenses/> *
*                                                                      *
***********************************************************************/
#ifdef __cplusplus
extern "C" {
#endif


#ifndef _BRAVAIS_H_
#define _BRAVAIS_H_

#ifndef _CARAT_TYPEDEF_H_
#include"typedef.h"
#endif

#ifdef __STDC__

/*-------------------------------------------------------------*\
| FILE: bravais_tools.c
\*-------------------------------------------------------------*/
bravais_TYP *bravais_group(bravais_TYP *H,int FLAG);
bravais_TYP *copy_bravais(bravais_TYP *H);

/*-------------------------------------------------------------*\
| FILE: formspace.c 
\*-------------------------------------------------------------*/
extern matrix_TYP **formspace(matrix_TYP **B, int Banz, int sym_opt, int *fdim);

/*-------------------------------------------------------------*\
| FILE: init_bravais.c 
\*-------------------------------------------------------------*/
extern bravais_TYP *init_bravais(int dim);

/*-------------------------------------------------------------*\
| FILE: invar_space.c 
\*-------------------------------------------------------------*/
extern matrix_TYP **invar_space(matrix_TYP **B, int Banz, int fodim,
     int symm_opt, int epsilon, int *anz);

/*-------------------------------------------------------------*\
| FILE: konj_bravais.c 
\*-------------------------------------------------------------*/
extern bravais_TYP *konj_bravais(bravais_TYP *B, matrix_TYP *T);

/*-------------------------------------------------------------*\
| FILE: lincomb.c 
\*-------------------------------------------------------------*/
extern matrix_TYP *vec_to_form(int *v, matrix_TYP **F, int Fanz);
extern void form_to_vec(int *erg, matrix_TYP *A, matrix_TYP **F,
     int Fanz, int *denominator);
extern vertex_TYP *form_to_vertex(matrix_TYP *A, matrix_TYP **F,
     int Fanz, int *denominator);
extern void form_to_vec_modular(int *erg, matrix_TYP *A, matrix_TYP **F,
     int Fanz);

/*-------------------------------------------------------------*\
| FILE: normlin.c 
\*-------------------------------------------------------------*/
extern matrix_TYP *normlin(matrix_TYP **Fo, matrix_TYP *N, int fdim);

/*-------------------------------------------------------------*\
| FILE: p_formspace.c 
\*-------------------------------------------------------------*/
extern matrix_TYP **p_formspace(matrix_TYP **B, int Banz, int prime,
      int sym_opt, int *fdim);

/*-------------------------------------------------------------*\
| FILE: rform.c 
\*-------------------------------------------------------------*/
extern matrix_TYP *rform(matrix_TYP **B, int Banz, matrix_TYP *Fo, int epsilon);

/*-------------------------------------------------------------*\
| FILE: trace_bifo.c 
\*-------------------------------------------------------------*/
extern matrix_TYP *trace_bifo(matrix_TYP **F1, matrix_TYP **F2, int anz);

/*-------------------------------------------------------------*\
| FILE: tr_bravais.c 
\*-------------------------------------------------------------*/
extern bravais_TYP *tr_bravais(bravais_TYP *B, int calcforms, int invert);

/*-------------------------------------------------------------*\
| FILE: normalisator.c
\*-------------------------------------------------------------*/
void normalisator(bravais_TYP *H,
                  bravais_TYP *Gtr,
                  matrix_TYP *A,
                  int prime,
                  boolean b_option,
                  boolean o_option);


#else

/*-------------------------------------------------------------*\
| FILE: bravais_tools.c
\*-------------------------------------------------------------*/
bravais_TYP *bravais_group();
bravais_TYP *copy_bravais();

/*-------------------------------------------------------------*\
| FILE: formspace.c 
\*-------------------------------------------------------------*/
extern matrix_TYP **formspace();

/*-------------------------------------------------------------*\
| FILE: init_bravais.c 
\*-------------------------------------------------------------*/
extern bravais_TYP *init_bravais();

/*-------------------------------------------------------------*\
| FILE: invar_space.c 
\*-------------------------------------------------------------*/
extern matrix_TYP **invar_space();

/*-------------------------------------------------------------*\
| FILE: konj_bravais.c 
\*-------------------------------------------------------------*/
extern bravais_TYP *konj_bravais();

/*-------------------------------------------------------------*\
| FILE: lincomb.c 
\*-------------------------------------------------------------*/
extern matrix_TYP *vec_to_form();
extern void form_to_vec();
extern vertex_TYP *form_to_vertex();
extern void form_to_vec_modular();

/*-------------------------------------------------------------*\
| FILE: normlin.c 
\*-------------------------------------------------------------*/
extern matrix_TYP *normlin();

/*-------------------------------------------------------------*\
| FILE: p_formspace.c 
\*-------------------------------------------------------------*/
extern matrix_TYP **p_formspace();

/*-------------------------------------------------------------*\
| FILE: rform.c 
\*-------------------------------------------------------------*/
extern matrix_TYP *rform();

/*-------------------------------------------------------------*\
| FILE: trace_bifo.c 
\*-------------------------------------------------------------*/
extern matrix_TYP *trace_bifo();

/*-------------------------------------------------------------*\
| FILE: tr_bravais.c 
\*-------------------------------------------------------------*/
extern bravais_TYP *tr_bravais();

/*-------------------------------------------------------------*\
| FILE: normalisator.c
\*-------------------------------------------------------------*/
void normalisator();


#endif
#endif


#ifdef __cplusplus
}
#endif


