/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data;

import java.text.NumberFormat;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openstreetmap.josm.data.preferences.StringProperty;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;

public class SystemOfMeasurement {
    public static final SystemOfMeasurement METRIC = new SystemOfMeasurement(I18n.marktr("Metric"), 1.0, "m", 1000.0, "km", "km/h", 3.6, 10000.0, "ha");
    public static final SystemOfMeasurement CHINESE = new SystemOfMeasurement(I18n.marktr("Chinese"), 0.3333333333333333, "\u5e02\u5c3a", 500.0, "\u5e02\u91cc", "km/h", 3.6, 666.6666666666666, "\u4ea9");
    public static final SystemOfMeasurement IMPERIAL = new SystemOfMeasurement(I18n.marktr("Imperial"), 0.3048, "ft", 1609.344, "mi", "mph", 2.23694, 4046.86, "ac");
    public static final SystemOfMeasurement NAUTICAL_MILE = new SystemOfMeasurement(I18n.marktr("Nautical Mile"), 185.2, "kbl", 1852.0, "NM", "kn", 1.94384);
    public static final Map<String, SystemOfMeasurement> ALL_SYSTEMS = Collections.unmodifiableMap(Stream.of(METRIC, CHINESE, IMPERIAL, NAUTICAL_MILE).collect(Collectors.toMap(SystemOfMeasurement::getName, Function.identity())));
    public static final StringProperty PROP_SYSTEM_OF_MEASUREMENT = new StringProperty("system_of_measurement", SystemOfMeasurement.getDefault().getName());
    private static final CopyOnWriteArrayList<SoMChangeListener> somChangeListeners = new CopyOnWriteArrayList();
    private final String name;
    public final double aValue;
    public final double bValue;
    public final String aName;
    public final String bName;
    public final double speedValue;
    public final String speedName;
    public final double areaCustomValue;
    public final String areaCustomName;

    public static void removeSoMChangeListener(SoMChangeListener listener) {
        somChangeListeners.remove(listener);
    }

    public static void addSoMChangeListener(SoMChangeListener listener) {
        if (listener != null) {
            somChangeListeners.addIfAbsent(listener);
        }
    }

    protected static void fireSoMChanged(String oldSoM, String newSoM) {
        for (SoMChangeListener l : somChangeListeners) {
            l.systemOfMeasurementChanged(oldSoM, newSoM);
        }
    }

    public static SystemOfMeasurement getSystemOfMeasurement() {
        return Optional.ofNullable(ALL_SYSTEMS.get(PROP_SYSTEM_OF_MEASUREMENT.get())).orElse(METRIC);
    }

    public static void setSystemOfMeasurement(String somKey) {
        if (!ALL_SYSTEMS.containsKey(somKey)) {
            throw new IllegalArgumentException("Invalid system of measurement: " + somKey);
        }
        String oldKey = PROP_SYSTEM_OF_MEASUREMENT.get();
        if (PROP_SYSTEM_OF_MEASUREMENT.put(somKey)) {
            SystemOfMeasurement.fireSoMChanged(oldKey, somKey);
        }
    }

    public SystemOfMeasurement(String name, double aValue, String aName, double bValue, String bName, String speedName, double speedValue) {
        this(name, aValue, aName, bValue, bName, speedName, speedValue, -1.0, null);
    }

    public SystemOfMeasurement(String name, double aValue, String aName, double bValue, String bName, String speedName, double speedValue, double areaCustomValue, String areaCustomName) {
        this.name = name;
        this.aValue = aValue;
        this.aName = aName;
        this.bValue = bValue;
        this.bName = bName;
        this.speedValue = speedValue;
        this.speedName = speedName;
        this.areaCustomValue = areaCustomValue;
        this.areaCustomName = areaCustomName;
    }

    public String getDistText(double dist) {
        return this.getDistText(dist, null, 0.01);
    }

    public String getDistText(double dist, NumberFormat format, double threshold) {
        double a = dist / this.aValue;
        if (a > this.bValue / this.aValue && !Config.getPref().getBoolean("system_of_measurement.use_only_lower_unit", false)) {
            return SystemOfMeasurement.formatText(dist / this.bValue, this.bName, format);
        }
        if (a < threshold) {
            return "< " + SystemOfMeasurement.formatText(threshold, this.aName, format);
        }
        return SystemOfMeasurement.formatText(a, this.aName, format);
    }

    public String getAreaText(double area) {
        return this.getAreaText(area, null, 0.01);
    }

    public String getAreaText(double area, NumberFormat format, double threshold) {
        double a = area / (this.aValue * this.aValue);
        boolean lowerOnly = Config.getPref().getBoolean("system_of_measurement.use_only_lower_unit", false);
        boolean customAreaOnly = Config.getPref().getBoolean("system_of_measurement.use_only_custom_area_unit", false);
        if (!lowerOnly && this.areaCustomValue > 0.0 && a > this.areaCustomValue / (this.aValue * this.aValue) && a < this.bValue * this.bValue / (this.aValue * this.aValue) || customAreaOnly) {
            return SystemOfMeasurement.formatText(area / this.areaCustomValue, this.areaCustomName, format);
        }
        if (!lowerOnly && a >= this.bValue * this.bValue / (this.aValue * this.aValue)) {
            return SystemOfMeasurement.formatText(area / (this.bValue * this.bValue), this.bName + '\u00b2', format);
        }
        if (a < threshold) {
            return "< " + SystemOfMeasurement.formatText(threshold, this.aName + '\u00b2', format);
        }
        return SystemOfMeasurement.formatText(a, this.aName + '\u00b2', format);
    }

    public String getName() {
        return this.name;
    }

    public static SystemOfMeasurement getDefault() {
        switch (Locale.getDefault().getCountry()) {
            case "US": {
                return IMPERIAL;
            }
        }
        return METRIC;
    }

    private static String formatText(double v, String unit, NumberFormat format) {
        if (format != null) {
            return format.format(v) + ' ' + unit;
        }
        return String.format(Locale.US, v < 9.999999 ? "%.2f %s" : "%.1f %s", v, unit);
    }

    @FunctionalInterface
    public static interface SoMChangeListener {
        public void systemOfMeasurementChanged(String var1, String var2);
    }
}

