/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.plus.routing;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;
import net.osmand.Location;
import net.osmand.PlatformUtil;
import net.osmand.ValueHolder;
import net.osmand.data.LatLon;
import net.osmand.plus.ApplicationMode;
import net.osmand.plus.GPXUtilities;
import net.osmand.plus.OsmAndFormatter;
import net.osmand.plus.OsmandSettings;
import net.osmand.plus.TargetPointsHelper;
import net.osmand.plus.routing.RouteCalculationParams;
import net.osmand.plus.routing.RouteCalculationResult;
import net.osmand.plus.routing.RouteDirectionInfo;
import net.osmand.plus.routing.RouteProvider;
import net.osmand.router.RouteCalculationProgress;
import net.osmand.router.RouteSegmentResult;
import net.osmand.router.TurnType;
import net.osmand.util.MapUtils;
import net.sourceforge.offroad.OsmWindow;
import org.apache.commons.logging.Log;

public class RoutingHelper {
    private static final Log log = PlatformUtil.getLog(RoutingHelper.class);
    private static final float POSITION_TOLERANCE = 60.0f;
    private List<WeakReference<IRouteInformationListener>> listeners = new LinkedList<WeakReference<IRouteInformationListener>>();
    private OsmWindow app;
    private boolean isFollowingMode = false;
    private boolean isRoutePlanningMode = false;
    private boolean isPauseNavigation = false;
    private RouteProvider.GPXRouteParamsBuilder currentGPXRoute = null;
    private RouteCalculationResult route = new RouteCalculationResult("");
    private LatLon finalLocation;
    private List<LatLon> intermediatePoints;
    private Location lastProjection;
    private Location lastFixedLocation;
    private static final int RECALCULATE_THRESHOLD_COUNT_CAUSING_FULL_RECALCULATE = 3;
    private static final int RECALCULATE_THRESHOLD_CAUSING_FULL_RECALCULATE_INTERVAL = 120000;
    private Thread currentRunningJob;
    private long lastTimeEvaluatedRoute = 0L;
    private long recalculateCountInInterval = 0L;
    private int evalWaitInterval = 0;
    private ApplicationMode mode;
    private OsmandSettings settings;
    private RouteProvider provider;
    private boolean isDeviatedFromRoute = false;
    private long deviateFromRouteDetected = 0L;
    private RouteCalculationProgressCallback progressRoute;
    private boolean announceBackOnRoute = false;

    public boolean isDeviatedFromRoute() {
        return this.isDeviatedFromRoute;
    }

    public RoutingHelper(OsmWindow context) {
        this.app = context;
        this.settings = context.getSettings();
        this.provider = new RouteProvider();
        this.setAppMode(this.settings.APPLICATION_MODE.get());
    }

    public boolean isFollowingMode() {
        return this.isFollowingMode;
    }

    public OsmWindow getApplication() {
        return this.app;
    }

    public boolean isPauseNavigation() {
        return this.isPauseNavigation;
    }

    public void setFollowingMode(boolean follow) {
        this.isFollowingMode = follow;
        this.isPauseNavigation = false;
    }

    public boolean isRoutePlanningMode() {
        return this.isRoutePlanningMode;
    }

    public void setRoutePlanningMode(boolean isRoutePlanningMode) {
        this.isRoutePlanningMode = isRoutePlanningMode;
    }

    public synchronized void setFinalAndCurrentLocation(LatLon finalLocation, List<LatLon> intermediatePoints, Location currentLocation) {
        RouteCalculationResult previousRoute = this.route;
        this.clearCurrentRoute(finalLocation, intermediatePoints);
        this.setCurrentLocation(currentLocation, false, previousRoute, true);
    }

    public synchronized void clearCurrentRoute(LatLon newFinalLocation, List<LatLon> newIntermediatePoints) {
        this.route = new RouteCalculationResult("");
        this.isDeviatedFromRoute = false;
        this.evalWaitInterval = 0;
        this.app.runInUIThread(new Runnable(){

            @Override
            public void run() {
                Iterator it = RoutingHelper.this.listeners.iterator();
                while (it.hasNext()) {
                    WeakReference ref = (WeakReference)it.next();
                    IRouteInformationListener l = (IRouteInformationListener)ref.get();
                    if (l == null) {
                        it.remove();
                        continue;
                    }
                    l.routeWasCancelled();
                }
            }
        });
        this.finalLocation = newFinalLocation;
        this.intermediatePoints = newIntermediatePoints;
        if (this.currentRunningJob instanceof RouteRecalculationThread) {
            ((RouteRecalculationThread)this.currentRunningJob).stopCalculation();
        }
        if (newFinalLocation == null) {
            this.settings.FOLLOW_THE_ROUTE.set(false);
            this.settings.FOLLOW_THE_GPX_ROUTE.set(null);
            this.lastProjection = null;
            this.setFollowingMode(false);
        }
    }

    public RouteProvider.GPXRouteParamsBuilder getCurrentGPXRoute() {
        return this.currentGPXRoute;
    }

    public void setGpxParams(RouteProvider.GPXRouteParamsBuilder params) {
        this.currentGPXRoute = params;
    }

    public List<Location> getCurrentCalculatedRoute() {
        return this.route.getImmutableAllLocations();
    }

    public void setAppMode(ApplicationMode mode) {
        this.mode = mode;
    }

    public ApplicationMode getAppMode() {
        return this.mode;
    }

    public LatLon getFinalLocation() {
        return this.finalLocation;
    }

    public List<LatLon> getIntermediatePoints() {
        return this.intermediatePoints;
    }

    public boolean isRouteCalculated() {
        return this.route.isCalculated();
    }

    public Location getLastProjection() {
        return this.lastProjection;
    }

    public void addListener(IRouteInformationListener l) {
        this.listeners.add(new WeakReference<IRouteInformationListener>(l));
    }

    public boolean removeListener(IRouteInformationListener lt) {
        Iterator<WeakReference<IRouteInformationListener>> it = this.listeners.iterator();
        while (it.hasNext()) {
            WeakReference<IRouteInformationListener> ref = it.next();
            IRouteInformationListener l = (IRouteInformationListener)ref.get();
            if (l != null && lt != l) continue;
            it.remove();
            return true;
        }
        return false;
    }

    public Location setCurrentLocation(Location currentLocation, boolean returnUpdatedLocation) {
        return this.setCurrentLocation(currentLocation, returnUpdatedLocation, this.route, false);
    }

    public double getRouteDeviation() {
        if (this.route == null || this.route.getImmutableAllDirections().size() < 2 || this.route.currentRoute == 0) {
            return 0.0;
        }
        List<Location> routeNodes = this.route.getImmutableAllLocations();
        return RoutingHelper.getOrthogonalDistance(this.lastFixedLocation, routeNodes.get(this.route.currentRoute - 1), routeNodes.get(this.route.currentRoute));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Location setCurrentLocation(Location currentLocation, boolean returnUpdatedLocation, RouteCalculationResult previousRoute, boolean targetPointsChanged) {
        double projectDist;
        Location locationProjection = currentLocation;
        if (this.finalLocation == null || currentLocation == null) {
            this.isDeviatedFromRoute = false;
            return locationProjection;
        }
        float posTolerance = 60.0f;
        if (currentLocation.hasAccuracy()) {
            posTolerance = 30.0f + currentLocation.getAccuracy();
        }
        boolean calculateRoute = false;
        RoutingHelper routingHelper = this;
        synchronized (routingHelper) {
            if (this.route.isEmpty()) {
                calculateRoute = true;
            } else {
                Location next;
                boolean wrongMovementDirection;
                boolean finished = this.updateCurrentRouteStatus(currentLocation, posTolerance);
                if (finished) {
                    return null;
                }
                List<Location> routeNodes = this.route.getImmutableAllLocations();
                int currentRoute = this.route.currentRoute;
                if (currentRoute > 0) {
                    double dist = RoutingHelper.getOrthogonalDistance(currentLocation, routeNodes.get(currentRoute - 1), routeNodes.get(currentRoute));
                    if (dist > 1.7 * (double)posTolerance) {
                        log.info((Object)("Recalculate route, because correlation  : " + dist));
                        calculateRoute = true;
                    }
                    if (dist > 350.0 && this.isFollowingMode) {
                        this.announceBackOnRoute = true;
                    }
                }
                if ((wrongMovementDirection = this.checkWrongMovementDirection(currentLocation, next = this.route.getNextRouteLocation())) && currentLocation.distanceTo(routeNodes.get(currentRoute)) > 2.0f * posTolerance) {
                    log.info((Object)("Recalculate route, because wrong movement direction: " + currentLocation.distanceTo(routeNodes.get(currentRoute))));
                    calculateRoute = true;
                }
                boolean uTurnIsNeeded = this.identifyUTurnIsNeeded(currentLocation, posTolerance);
                if (this.isFollowingMode) {
                    boolean inRecalc;
                    boolean bl = inRecalc = calculateRoute || this.isRouteBeingCalculated();
                    if (!inRecalc && !wrongMovementDirection || this.isDeviatedFromRoute) {
                        // empty if block
                    }
                }
                if (currentRoute > 0) {
                    locationProjection = new Location(currentLocation);
                    Location nextLocation = routeNodes.get(currentRoute);
                    LatLon project = RoutingHelper.getProject(currentLocation, routeNodes.get(currentRoute - 1), routeNodes.get(currentRoute));
                    locationProjection.setLatitude(project.getLatitude());
                    locationProjection.setLongitude(project.getLongitude());
                    float bearingTo = locationProjection.bearingTo(nextLocation);
                    locationProjection.setBearing(bearingTo);
                }
            }
            this.lastFixedLocation = currentLocation;
            this.lastProjection = locationProjection;
        }
        if (calculateRoute) {
            this.recalculateRouteInBackground(currentLocation, this.finalLocation, this.intermediatePoints, this.currentGPXRoute, previousRoute.isCalculated() ? previousRoute : null, false, !targetPointsChanged);
        } else {
            Thread job = this.currentRunningJob;
            if (job instanceof RouteRecalculationThread) {
                RouteRecalculationThread thread = (RouteRecalculationThread)job;
                if (!thread.isParamsChanged()) {
                    thread.stopCalculation();
                }
                if (this.announceBackOnRoute && this.isFollowingMode) {
                    this.announceBackOnRoute = false;
                }
            }
        }
        double d = projectDist = this.mode != null && this.mode.hasFastSpeed() ? (double)posTolerance : (double)(posTolerance / 2.0f);
        if (returnUpdatedLocation && locationProjection != null && (double)currentLocation.distanceTo(locationProjection) < projectDist) {
            return locationProjection;
        }
        return currentLocation;
    }

    private static double getOrthogonalDistance(Location loc, Location from, Location to) {
        return MapUtils.getOrthogonalDistance(loc.getLatitude(), loc.getLongitude(), from.getLatitude(), from.getLongitude(), to.getLatitude(), to.getLongitude());
    }

    private static LatLon getProject(Location loc, Location from, Location to) {
        return MapUtils.getProjection(loc.getLatitude(), loc.getLongitude(), from.getLatitude(), from.getLongitude(), to.getLatitude(), to.getLongitude());
    }

    private static int lookAheadFindMinOrthogonalDistance(Location currentLocation, List<Location> routeNodes, int currentRoute, int iterations) {
        double dist = Double.POSITIVE_INFINITY;
        int index = currentRoute;
        while (iterations > 0 && currentRoute + 1 < routeNodes.size()) {
            double newDist = RoutingHelper.getOrthogonalDistance(currentLocation, routeNodes.get(currentRoute), routeNodes.get(currentRoute + 1));
            if (newDist < dist) {
                index = currentRoute;
                dist = newDist;
            }
            ++currentRoute;
            --iterations;
        }
        return index;
    }

    private boolean updateCurrentRouteStatus(Location currentLocation, float posTolerance) {
        List<Location> routeNodes = this.route.getImmutableAllLocations();
        int currentRoute = this.route.currentRoute;
        while (currentRoute + 1 < routeNodes.size()) {
            double dist = currentLocation.distanceTo(routeNodes.get(currentRoute));
            if (currentRoute > 0) {
                dist = RoutingHelper.getOrthogonalDistance(currentLocation, routeNodes.get(currentRoute - 1), routeNodes.get(currentRoute));
            }
            boolean processed = false;
            boolean longDistance = dist >= 250.0;
            int newCurrentRoute = RoutingHelper.lookAheadFindMinOrthogonalDistance(currentLocation, routeNodes, currentRoute, longDistance ? 15 : 8);
            double newDist = RoutingHelper.getOrthogonalDistance(currentLocation, routeNodes.get(newCurrentRoute), routeNodes.get(newCurrentRoute + 1));
            if (longDistance) {
                if (newDist < dist) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Processed by distance : (new) " + newDist + " (old) " + dist));
                    }
                    processed = true;
                }
            } else if (newDist < dist || newDist < 10.0) {
                if (dist > (double)posTolerance) {
                    processed = true;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Processed by distance : " + newDist + " " + dist));
                    }
                } else if (currentLocation.hasBearing() || this.lastFixedLocation != null) {
                    double diffToNext;
                    float bearingToRoute = currentLocation.bearingTo(routeNodes.get(currentRoute));
                    float bearingRouteNext = routeNodes.get(newCurrentRoute).bearingTo(routeNodes.get(newCurrentRoute + 1));
                    float bearingMotion = currentLocation.hasBearing() ? currentLocation.getBearing() : this.lastFixedLocation.bearingTo(currentLocation);
                    double diff = Math.abs(MapUtils.degreesDiff(bearingMotion, bearingToRoute));
                    if (diff > (diffToNext = Math.abs(MapUtils.degreesDiff(bearingMotion, bearingRouteNext)))) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Processed point bearing deltas : " + diff + " " + diffToNext));
                        }
                        processed = true;
                    }
                }
            }
            if (!processed) break;
            this.route.updateCurrentRoute(newCurrentRoute + 1);
            currentRoute = newCurrentRoute + 1;
        }
        if (this.route.getIntermediatePointsToPass() > 0 && (float)this.route.getDistanceToNextIntermediate(this.lastFixedLocation) < 120.0f && !this.isRoutePlanningMode) {
            this.showMessage(this.app.getString(1031));
            this.route.passIntermediatePoint();
            TargetPointsHelper targets = this.app.getTargetPointsHelper();
            String name = "";
            if (this.intermediatePoints != null) {
                LatLon rm = this.intermediatePoints.remove(0);
                List<TargetPointsHelper.TargetPoint> ll = targets.getIntermediatePointsNavigation();
                int ind = -1;
                for (int i = 0; i < ll.size(); ++i) {
                    if (ll.get((int)i).point == null || !(MapUtils.getDistance(ll.get((int)i).point, rm) < 5.0)) continue;
                    name = ll.get(i).getOnlyName();
                    ind = i;
                    break;
                }
                if (ind >= 0) {
                    targets.removeWayPoint(false, ind);
                }
            }
            if (this.isFollowingMode) {
                // empty if block
            }
            while (this.intermediatePoints != null && this.route.getIntermediatePointsToPass() < this.intermediatePoints.size()) {
                this.intermediatePoints.remove(0);
            }
        }
        Location lastPoint = routeNodes.get(routeNodes.size() - 1);
        if (currentRoute > routeNodes.size() - 3 && currentLocation.distanceTo(lastPoint) < (float)this.settings.getApplicationMode().getArrivalDistance() * this.settings.ARRIVAL_DISTANCE_FACTOR.get().floatValue() && !this.isRoutePlanningMode) {
            String description;
            this.showMessage(this.app.getString(790));
            TargetPointsHelper targets = this.app.getTargetPointsHelper();
            TargetPointsHelper.TargetPoint tp = targets.getPointToNavigate();
            String string2 = description = tp == null ? "" : tp.getOnlyName();
            if (this.isFollowingMode) {
                // empty if block
            }
        }
        return false;
    }

    public boolean identifyUTurnIsNeeded(Location currentLocation, float posTolerance) {
        if (this.finalLocation == null || currentLocation == null || !this.route.isCalculated()) {
            this.isDeviatedFromRoute = false;
            return this.isDeviatedFromRoute;
        }
        boolean isOffRoute = false;
        if (currentLocation.hasBearing()) {
            Location nextRoutePosition;
            float bearingToRoute;
            float bearingMotion = currentLocation.getBearing();
            double diff = MapUtils.degreesDiff(bearingMotion, bearingToRoute = currentLocation.bearingTo(nextRoutePosition = this.route.getNextRouteLocation()));
            if (Math.abs(diff) > 135.0) {
                float d = currentLocation.distanceTo(nextRoutePosition);
                if (d > posTolerance) {
                    if (this.deviateFromRouteDetected == 0L) {
                        this.deviateFromRouteDetected = System.currentTimeMillis();
                    } else if (System.currentTimeMillis() - this.deviateFromRouteDetected > 10000L) {
                        isOffRoute = true;
                    }
                }
            } else {
                this.deviateFromRouteDetected = 0L;
            }
        }
        this.isDeviatedFromRoute = isOffRoute;
        return isOffRoute;
    }

    public boolean checkWrongMovementDirection(Location currentLocation, Location nextRouteLocation) {
        if (currentLocation.hasBearing() && nextRouteLocation != null) {
            float bearingToRoute;
            float bearingMotion = currentLocation.getBearing();
            double diff = MapUtils.degreesDiff(bearingMotion, bearingToRoute = currentLocation.bearingTo(nextRouteLocation));
            return Math.abs(diff) > 60.0;
        }
        return false;
    }

    private void setNewRoute(RouteCalculationResult prevRoute, final RouteCalculationResult res, Location start) {
        boolean newRoute;
        boolean bl = newRoute = !prevRoute.isCalculated();
        if (this.isFollowingMode) {
            int newCurrentRoute;
            if (this.lastFixedLocation != null) {
                start = this.lastFixedLocation;
            }
            boolean wrongMovementDirection = false;
            List<Location> routeNodes = res.getImmutableAllLocations();
            if (routeNodes != null && !routeNodes.isEmpty() && (newCurrentRoute = RoutingHelper.lookAheadFindMinOrthogonalDistance(start, routeNodes, res.currentRoute, 15)) + 1 < routeNodes.size()) {
                wrongMovementDirection = this.checkWrongMovementDirection(start, routeNodes.get(newCurrentRoute + 1));
                if (wrongMovementDirection) {
                    this.evalWaitInterval = 3000;
                } else {
                    this.evalWaitInterval = Math.max(3000, this.evalWaitInterval * 3 / 2);
                    this.evalWaitInterval = Math.min(this.evalWaitInterval, 120000);
                }
            }
            if (!wrongMovementDirection || newRoute) {
                // empty if block
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ValueHolder<Boolean> showToast = new ValueHolder<Boolean>();
                showToast.value = true;
                Iterator it = RoutingHelper.this.listeners.iterator();
                while (it.hasNext()) {
                    WeakReference ref = (WeakReference)it.next();
                    IRouteInformationListener l = (IRouteInformationListener)ref.get();
                    if (l == null) {
                        it.remove();
                        continue;
                    }
                    l.newRouteIsCalculated(newRoute, showToast);
                }
                if (((Boolean)showToast.value).booleanValue()) {
                    String msg = RoutingHelper.this.app.getString(789) + ": " + OsmAndFormatter.getFormattedDistance(res.getWholeDistance(), RoutingHelper.this.app);
                    RoutingHelper.this.app.showToastMessage(msg);
                }
            }
        });
    }

    public int getLeftDistance() {
        return this.route.getDistanceToFinish(this.lastFixedLocation);
    }

    public int getLeftDistanceNextIntermediate() {
        return this.route.getDistanceToNextIntermediate(this.lastFixedLocation);
    }

    public int getLeftTime() {
        return this.route.getLeftTime(this.lastFixedLocation);
    }

    public OsmandSettings getSettings() {
        return this.settings;
    }

    public String getGeneralRouteInformation() {
        int dist = this.getLeftDistance();
        int hours = this.getLeftTime() / 3600;
        int minutes = this.getLeftTime() / 60 % 60;
        return this.app.getString(749, OsmAndFormatter.getFormattedDistance(dist, this.app), hours, minutes);
    }

    public Location getLocationFromRouteDirection(RouteDirectionInfo i) {
        return this.route.getLocationFromRouteDirection(i);
    }

    public synchronized RouteCalculationResult.NextDirectionInfo getNextRouteDirectionInfo(RouteCalculationResult.NextDirectionInfo info, boolean toSpeak) {
        RouteCalculationResult.NextDirectionInfo i = this.route.getNextRouteDirectionInfo(info, this.lastProjection, toSpeak);
        if (i != null) {
            // empty if block
        }
        return i;
    }

    public synchronized float getCurrentMaxSpeed() {
        return this.route.getCurrentMaxSpeed();
    }

    public static String formatStreetName(String name, String ref, String destination) {
        if (destination != null && destination.length() > 0) {
            if (ref != null && ref.length() > 0) {
                destination = ref + " " + destination;
            }
            return destination;
        }
        if (name != null && name.length() > 0) {
            if (ref != null && ref.length() > 0) {
                name = ref + " " + name;
            }
            return name;
        }
        if (ref == null) {
            return "";
        }
        return ref;
    }

    public synchronized String getCurrentName(TurnType[] next) {
        RouteCalculationResult.NextDirectionInfo n = this.getNextRouteDirectionInfo(new RouteCalculationResult.NextDirectionInfo(), false);
        Location l = this.lastFixedLocation;
        float speed = 0.0f;
        if (l != null && l.hasSpeed()) {
            speed = l.getSpeed();
        }
        if (n.distanceTo > 0 && n.directionInfo != null && !n.directionInfo.getTurnType().isSkipToSpeak()) {
            String nm = n.directionInfo.getStreetName();
            String rf = n.directionInfo.getRef();
            String dn = n.directionInfo.getDestinationName();
            if (next != null) {
                next[0] = n.directionInfo.getTurnType();
            }
            return RoutingHelper.formatStreetName(nm, rf, dn);
        }
        RouteSegmentResult rs = this.getCurrentSegmentResult();
        if (rs != null) {
            String nm = rs.getObject().getName(this.settings.MAP_PREFERRED_LOCALE.get());
            String rf = rs.getObject().getRef();
            String dn = rs.getObject().getDestinationName(this.settings.MAP_PREFERRED_LOCALE.get());
            return RoutingHelper.formatStreetName(nm, rf, dn);
        }
        return null;
    }

    public RouteSegmentResult getCurrentSegmentResult() {
        return this.route.getCurrentSegmentResult();
    }

    public List<RouteSegmentResult> getUpcomingTunnel(float distToStart) {
        return this.route.getUpcomingTunnel(distToStart);
    }

    public synchronized RouteCalculationResult.NextDirectionInfo getNextRouteDirectionInfoAfter(RouteCalculationResult.NextDirectionInfo previous, RouteCalculationResult.NextDirectionInfo to, boolean toSpeak) {
        RouteCalculationResult.NextDirectionInfo i = this.route.getNextRouteDirectionInfoAfter(previous, to, toSpeak);
        if (i != null) {
            // empty if block
        }
        return i;
    }

    public List<RouteDirectionInfo> getRouteDirections() {
        return this.route.getRouteDirections();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recalculateRouteInBackground(Location start, LatLon end, List<LatLon> intermediates, RouteProvider.GPXRouteParamsBuilder gpxRoute, RouteCalculationResult previousRoute, boolean paramsChanged, boolean onlyStartPointChanged) {
        if (start == null || end == null) {
            return;
        }
        if (this.currentRunningJob == null && System.currentTimeMillis() - this.lastTimeEvaluatedRoute > (long)this.evalWaitInterval || paramsChanged || !onlyStartPointChanged) {
            if (System.currentTimeMillis() - this.lastTimeEvaluatedRoute < 120000L) {
                ++this.recalculateCountInInterval;
            }
            RouteCalculationParams params = new RouteCalculationParams();
            params.start = start;
            params.end = end;
            params.intermediates = intermediates;
            params.gpxRoute = gpxRoute == null ? null : gpxRoute.build(start, this.settings);
            params.onlyStartPointChanged = onlyStartPointChanged;
            if (this.recalculateCountInInterval < 3L) {
                params.previousToRecalculate = previousRoute;
            } else {
                this.recalculateCountInInterval = 0L;
            }
            params.leftSide = this.settings.DRIVING_REGION.get().leftHandDriving;
            params.fast = this.settings.FAST_ROUTE_MODE.getModeValue(this.mode);
            params.type = this.settings.ROUTER_SERVICE.getModeValue(this.mode);
            params.mode = this.mode;
            params.ctx = this.app;
            if (params.type == RouteProvider.RouteService.OSMAND) {
                params.calculationProgress = new RouteCalculationProgress();
                this.updateProgress(params);
            }
            RoutingHelper routingHelper = this;
            synchronized (routingHelper) {
                Thread prevRunningJob = this.currentRunningJob;
                RouteRecalculationThread newThread = new RouteRecalculationThread("Calculating route", params, paramsChanged);
                this.currentRunningJob = newThread;
                if (prevRunningJob != null) {
                    newThread.setWaitPrevJob(prevRunningJob);
                }
                this.currentRunningJob.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startTaskInRouteThreadIfPossible(final Runnable r) {
        if (this.currentRunningJob == null) {
            RoutingHelper routingHelper = this;
            synchronized (routingHelper) {
                this.currentRunningJob = new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        RoutingHelper routingHelper = RoutingHelper.this;
                        synchronized (routingHelper) {
                            try {
                                r.run();
                            }
                            finally {
                                RoutingHelper.this.currentRunningJob = null;
                            }
                        }
                    }
                }, "Calculating position");
                this.currentRunningJob.start();
                return true;
            }
        }
        return false;
    }

    private void updateProgress(final RouteCalculationParams params) {
        if (this.progressRoute != null) {
            this.app.runInUIThread(new Runnable(){

                @Override
                public void run() {
                    RouteCalculationProgress calculationProgress = params.calculationProgress;
                    if (RoutingHelper.this.isRouteBeingCalculated()) {
                        Thread t;
                        float p = Math.max(calculationProgress.distanceFromBegin, calculationProgress.distanceFromEnd);
                        float all = calculationProgress.totalEstimatedDistance * 1.25f;
                        if (all > 0.0f) {
                            int t2 = (int)Math.min(p * p / (all * all) * 100.0f, 99.0f);
                            RoutingHelper.this.progressRoute.updateProgress(t2);
                        }
                        if ((t = RoutingHelper.this.currentRunningJob) instanceof RouteRecalculationThread && ((RouteRecalculationThread)t).params != params) {
                            return;
                        }
                        RoutingHelper.this.updateProgress(params);
                    } else {
                        RoutingHelper.this.progressRoute.finish();
                    }
                }
            }, 300);
        }
    }

    public void setProgressBar(RouteCalculationProgressCallback progressRoute) {
        this.progressRoute = progressRoute;
    }

    public boolean isRouteBeingCalculated() {
        return this.currentRunningJob instanceof RouteRecalculationThread;
    }

    private void showMessage(final String msg) {
        System.err.println(msg);
        if (this.progressRoute != null) {
            this.app.runInUIThread(new Runnable(){

                @Override
                public void run() {
                    RoutingHelper.this.progressRoute.showError(msg);
                }
            });
        }
    }

    public RouteCalculationResult getRoute() {
        return this.route;
    }

    public GPXUtilities.GPXFile generateGPXFileWithRoute() {
        return this.provider.createOsmandRouterGPX(this.route, this.app);
    }

    public void notifyIfRouteIsCalculated() {
        if (this.route.isCalculated()) {
            // empty if block
        }
    }

    public static interface RouteCalculationProgressCallback {
        public void updateProgress(int var1);

        public void finish();

        public void showError(String var1);
    }

    private class RouteRecalculationThread
    extends Thread {
        private final RouteCalculationParams params;
        private boolean paramsChanged;
        private Thread prevRunningJob;

        public RouteRecalculationThread(String name, RouteCalculationParams params, boolean paramsChanged) {
            super(name);
            this.params = params;
            this.paramsChanged = paramsChanged;
            if (params.calculationProgress == null) {
                params.calculationProgress = new RouteCalculationProgress();
            }
        }

        public boolean isParamsChanged() {
            return this.paramsChanged;
        }

        public void stopCalculation() {
            this.params.calculationProgress.isCancelled = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean onlineSourceWithoutInternet;
            RoutingHelper routingHelper = RoutingHelper.this;
            synchronized (routingHelper) {
                RoutingHelper.this.currentRunningJob = this;
            }
            if (this.prevRunningJob != null) {
                while (this.prevRunningJob.isAlive()) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                RoutingHelper e = RoutingHelper.this;
                synchronized (e) {
                    RoutingHelper.this.currentRunningJob = this;
                }
            }
            RouteCalculationResult res = RoutingHelper.this.provider.calculateRouteImpl(this.params);
            if (this.params.calculationProgress.isCancelled) {
                RoutingHelper routingHelper2 = RoutingHelper.this;
                synchronized (routingHelper2) {
                    RoutingHelper.this.currentRunningJob = null;
                }
                return;
            }
            boolean bl = onlineSourceWithoutInternet = !res.isCalculated() && this.params.type.isOnline() && !RoutingHelper.this.settings.isInternetConnectionAvailable();
            if (onlineSourceWithoutInternet && ((RoutingHelper)RoutingHelper.this).settings.GPX_ROUTE_CALC_OSMAND_PARTS.get().booleanValue() && this.params.previousToRecalculate != null && this.params.previousToRecalculate.isCalculated()) {
                res = RoutingHelper.this.provider.recalculatePartOfflineRoute(res, this.params);
            }
            RouteCalculationResult prev = RoutingHelper.this.route;
            RoutingHelper routingHelper3 = RoutingHelper.this;
            synchronized (routingHelper3) {
                if (res.isCalculated()) {
                    RoutingHelper.this.route = res;
                } else {
                    RoutingHelper.this.evalWaitInterval = RoutingHelper.this.evalWaitInterval * 3 / 2;
                    RoutingHelper.this.evalWaitInterval = Math.min(RoutingHelper.this.evalWaitInterval, 120000);
                }
                RoutingHelper.this.currentRunningJob = null;
            }
            if (res.isCalculated()) {
                RoutingHelper.this.setNewRoute(prev, res, this.params.start);
            } else if (onlineSourceWithoutInternet) {
                RoutingHelper.this.showMessage(RoutingHelper.this.app.getString(786) + ":\n" + RoutingHelper.this.app.getString(456));
            } else if (res.getErrorMessage() != null) {
                RoutingHelper.this.showMessage(RoutingHelper.this.app.getString(786) + ":\n" + res.getErrorMessage());
            } else {
                RoutingHelper.this.showMessage(RoutingHelper.this.app.getString(788));
            }
            RoutingHelper.this.lastTimeEvaluatedRoute = System.currentTimeMillis();
        }

        public void setWaitPrevJob(Thread prevRunningJob) {
            this.prevRunningJob = prevRunningJob;
        }
    }

    public static interface IRouteInformationListener {
        public void newRouteIsCalculated(boolean var1, ValueHolder<Boolean> var2);

        public void routeWasCancelled();

        public void routeWasFinished();
    }
}

