#ifndef _EFL_PACK_EO_H_
#define _EFL_PACK_EO_H_

#ifndef _EFL_PACK_EO_CLASS_TYPE
#define _EFL_PACK_EO_CLASS_TYPE

typedef Eo Efl_Pack;

#endif

#ifndef _EFL_PACK_EO_TYPES
#define _EFL_PACK_EO_TYPES


#endif
#ifdef EFL_BETA_API_SUPPORT
/** Common interface for objects (containers) with multiple contents
 * (sub-objects) which can be added and removed at runtime.
 *
 * @ingroup Efl_Pack
 */
#define EFL_PACK_INTERFACE efl_pack_interface_get()

EWAPI const Efl_Class *efl_pack_interface_get(void);

/**
 * @brief Removes all packed sub-objects and unreferences them.
 *
 * @param[in] obj The object.
 *
 * @return @c true on success, @c false otherwise.
 *
 * @ingroup Efl_Pack
 */
EOAPI Eina_Bool efl_pack_clear(Eo *obj);

/**
 * @brief Removes all packed sub-objects without unreferencing them.
 *
 * Use with caution.
 *
 * @param[in] obj The object.
 *
 * @return @c true on success, @c false otherwise.
 *
 * @ingroup Efl_Pack
 */
EOAPI Eina_Bool efl_pack_unpack_all(Eo *obj);

/**
 * @brief Removes an existing sub-object from the container without deleting
 * it.
 *
 * @param[in] obj The object.
 * @param[in] subobj The sub-object to unpack.
 *
 * @return @c false if @c subobj wasn't in the container or couldn't be
 * removed.
 *
 * @ingroup Efl_Pack
 */
EOAPI Eina_Bool efl_pack_unpack(Eo *obj, Efl_Gfx_Entity *subobj);

/**
 * @brief Adds a sub-object to this container.
 *
 * Depending on the container this will either fill in the default spot,
 * replacing any already existing element or append to the end of the container
 * if there is no default part.
 *
 * When this container is deleted, it will request deletion of the given
 * @c subobj. Use @ref efl_pack_unpack to remove @c subobj from this container
 * without deleting it.
 *
 * @param[in] obj The object.
 * @param[in] subobj The object to pack.
 *
 * @return @c false if @c subobj could not be packed.
 *
 * @ingroup Efl_Pack
 */
EOAPI Eina_Bool efl_pack(Eo *obj, Efl_Gfx_Entity *subobj);

/**
 * @brief Alignment of the container within its bounds
 *
 * @param[in] obj The object.
 * @param[in] align_horiz Horizontal alignment
 * @param[in] align_vert Vertical alignment
 *
 * @ingroup Efl_Pack
 */
EOAPI void efl_pack_align_set(Eo *obj, double align_horiz, double align_vert);

/**
 * @brief Alignment of the container within its bounds
 *
 * @param[in] obj The object.
 * @param[out] align_horiz Horizontal alignment
 * @param[out] align_vert Vertical alignment
 *
 * @ingroup Efl_Pack
 */
EOAPI void efl_pack_align_get(const Eo *obj, double *align_horiz, double *align_vert);

/**
 * @brief Padding between items contained in this object.
 *
 * @param[in] obj The object.
 * @param[in] pad_horiz Horizontal padding
 * @param[in] pad_vert Vertical padding
 * @param[in] scalable @c true if scalable, @c false otherwise
 *
 * @ingroup Efl_Pack
 */
EOAPI void efl_pack_padding_set(Eo *obj, double pad_horiz, double pad_vert, Eina_Bool scalable);

/**
 * @brief Padding between items contained in this object.
 *
 * @param[in] obj The object.
 * @param[out] pad_horiz Horizontal padding
 * @param[out] pad_vert Vertical padding
 * @param[out] scalable @c true if scalable, @c false otherwise
 *
 * @ingroup Efl_Pack
 */
EOAPI void efl_pack_padding_get(const Eo *obj, double *pad_horiz, double *pad_vert, Eina_Bool *scalable);
#endif /* EFL_BETA_API_SUPPORT */

#endif
