#ifndef _EFL_UI_POPUP_PART_BACKWALL_EO_H_
#define _EFL_UI_POPUP_PART_BACKWALL_EO_H_

#ifndef _EFL_UI_POPUP_PART_BACKWALL_EO_CLASS_TYPE
#define _EFL_UI_POPUP_PART_BACKWALL_EO_CLASS_TYPE

typedef Eo Efl_Ui_Popup_Part_Backwall;

#endif

#ifndef _EFL_UI_POPUP_PART_BACKWALL_EO_TYPES
#define _EFL_UI_POPUP_PART_BACKWALL_EO_TYPES


#endif
#ifdef EFL_BETA_API_SUPPORT
/** Efl UI Popup internal part backwall class
 *
 * @ingroup Efl_Ui_Popup_Part_Backwall
 */
#define EFL_UI_POPUP_PART_BACKWALL_CLASS efl_ui_popup_part_backwall_class_get()

EWAPI const Efl_Class *efl_ui_popup_part_backwall_class_get(void);

/**
 * @brief Set whether backwall is to repeat events.
 *
 * If @c repeat is @c true, it will make events on @c obj to also be repeated
 * for the next lower object in the objects' stack (see
 * @ref efl_gfx_stack_below_get).
 *
 * If @c repeat is @c false, events occurring on @c obj will be processed only
 * on it.
 *
 * @param[in] obj The object.
 * @param[in] repeat Whether @c obj is to repeat events ($true) or not
 * ($false).
 *
 * @ingroup Efl_Ui_Popup_Part_Backwall
 */
EOAPI void efl_ui_popup_part_backwall_repeat_events_set(Eo *obj, Eina_Bool repeat);

/**
 * @brief Determine whether backwall is set to repeat events.
 *
 * @param[in] obj The object.
 *
 * @return Whether @c obj is to repeat events ($true) or not ($false).
 *
 * @ingroup Efl_Ui_Popup_Part_Backwall
 */
EOAPI Eina_Bool efl_ui_popup_part_backwall_repeat_events_get(const Eo *obj);
#endif /* EFL_BETA_API_SUPPORT */

#endif
