#ifndef _EFL_CANVAS_ANIMATION_TRANSLATE_EO_H_
#define _EFL_CANVAS_ANIMATION_TRANSLATE_EO_H_

#ifndef _EFL_CANVAS_ANIMATION_TRANSLATE_EO_CLASS_TYPE
#define _EFL_CANVAS_ANIMATION_TRANSLATE_EO_CLASS_TYPE

typedef Eo Efl_Canvas_Animation_Translate;

#endif

#ifndef _EFL_CANVAS_ANIMATION_TRANSLATE_EO_TYPES
#define _EFL_CANVAS_ANIMATION_TRANSLATE_EO_TYPES


#endif
#ifdef EFL_BETA_API_SUPPORT
/** Efl translate animation class
 *
 * @ingroup Efl_Canvas_Animation_Translate
 */
#define EFL_CANVAS_ANIMATION_TRANSLATE_CLASS efl_canvas_animation_translate_class_get()

EWAPI const Efl_Class *efl_canvas_animation_translate_class_get(void);

/**
 * @brief Translate property
 *
 * @param[in] obj The object.
 * @param[in] from_x Distance moved along x axis when animation starts
 * @param[in] from_y Distance moved along y axis when animation starts
 * @param[in] to_x Distance moved along x axis when animation ends
 * @param[in] to_y Distance moved along y axis when animation ends
 *
 * @ingroup Efl_Canvas_Animation_Translate
 */
EOAPI void efl_animation_translate_set(Eo *obj, int from_x, int from_y, int to_x, int to_y);

/**
 * @brief Translate property
 *
 * @param[in] obj The object.
 * @param[out] from_x Distance moved along x axis when animation starts
 * @param[out] from_y Distance moved along y axis when animation starts
 * @param[out] to_x Distance moved along x axis when animation ends
 * @param[out] to_y Distance moved along y axis when animation ends
 *
 * @ingroup Efl_Canvas_Animation_Translate
 */
EOAPI void efl_animation_translate_get(const Eo *obj, int *from_x, int *from_y, int *to_x, int *to_y);

/**
 * @brief Translate absolute property
 *
 * @param[in] obj The object.
 * @param[in] from_x X coordinate when animation starts
 * @param[in] from_y Y coordinate when animation starts
 * @param[in] to_x X coordinate when animation ends
 * @param[in] to_y Y coordinate when animation ends
 *
 * @ingroup Efl_Canvas_Animation_Translate
 */
EOAPI void efl_animation_translate_absolute_set(Eo *obj, int from_x, int from_y, int to_x, int to_y);

/**
 * @brief Translate absolute property
 *
 * @param[in] obj The object.
 * @param[out] from_x X coordinate when animation starts
 * @param[out] from_y Y coordinate when animation starts
 * @param[out] to_x X coordinate when animation ends
 * @param[out] to_y Y coordinate when animation ends
 *
 * @ingroup Efl_Canvas_Animation_Translate
 */
EOAPI void efl_animation_translate_absolute_get(const Eo *obj, int *from_x, int *from_y, int *to_x, int *to_y);
#endif /* EFL_BETA_API_SUPPORT */

#endif
