#ifndef _EFL_CANVAS_GESTURE_EO_H_
#define _EFL_CANVAS_GESTURE_EO_H_

#ifndef _EFL_CANVAS_GESTURE_EO_CLASS_TYPE
#define _EFL_CANVAS_GESTURE_EO_CLASS_TYPE

typedef Eo Efl_Canvas_Gesture;

#endif

#ifndef _EFL_CANVAS_GESTURE_EO_TYPES
#define _EFL_CANVAS_GESTURE_EO_TYPES


#endif
#ifdef EFL_BETA_API_SUPPORT
/** EFL Gesture abstract class
 *
 * @ingroup Efl_Canvas_Gesture
 */
#define EFL_CANVAS_GESTURE_CLASS efl_canvas_gesture_class_get()

EWAPI const Efl_Class *efl_canvas_gesture_class_get(void);

/**
 * @brief This property holds the type of the gesture.
 *
 * @param[in] obj The object.
 *
 * @return gesture type
 *
 * @ingroup Efl_Canvas_Gesture
 */
EOAPI const Efl_Event_Description *efl_gesture_type_get(const Eo *obj);

/**
 * @brief This property holds the current state of the gesture.
 *
 * @param[in] obj The object.
 * @param[in] state gesture state
 *
 * @ingroup Efl_Canvas_Gesture
 */
EOAPI void efl_gesture_state_set(Eo *obj, Efl_Canvas_Gesture_State state);

/**
 * @brief This property holds the current state of the gesture.
 *
 * @param[in] obj The object.
 *
 * @return gesture state
 *
 * @ingroup Efl_Canvas_Gesture
 */
EOAPI Efl_Canvas_Gesture_State efl_gesture_state_get(const Eo *obj);

/**
 * @brief This property holds the hotspot of the current gesture.
 *
 * @param[in] obj The object.
 * @param[in] hotspot hotspot co-ordinate
 *
 * @ingroup Efl_Canvas_Gesture
 */
EOAPI void efl_gesture_hotspot_set(Eo *obj, Eina_Vector2 hotspot);

/**
 * @brief This property holds the hotspot of the current gesture.
 *
 * @param[in] obj The object.
 *
 * @return hotspot co-ordinate
 *
 * @ingroup Efl_Canvas_Gesture
 */
EOAPI Eina_Vector2 efl_gesture_hotspot_get(const Eo *obj);
#endif /* EFL_BETA_API_SUPPORT */

#endif
