#ifndef _EFL_UI_RANGE_INTERACTIVE_EO_H_
#define _EFL_UI_RANGE_INTERACTIVE_EO_H_

#ifndef _EFL_UI_RANGE_INTERACTIVE_EO_CLASS_TYPE
#define _EFL_UI_RANGE_INTERACTIVE_EO_CLASS_TYPE

typedef Eo Efl_Ui_Range_Interactive;

#endif

#ifndef _EFL_UI_RANGE_INTERACTIVE_EO_TYPES
#define _EFL_UI_RANGE_INTERACTIVE_EO_TYPES


#endif
#ifdef EFL_BETA_API_SUPPORT
/**
 * @brief Interface that extends the normal displaying properties with usage
 * properties.
 *
 * The properties defined here are used to manipulate the way a user interacts
 * with a displayed range.
 *
 * @ingroup Efl_Ui_Range_Interactive
 */
#define EFL_UI_RANGE_INTERACTIVE_INTERFACE efl_ui_range_interactive_interface_get()

EWAPI const Efl_Class *efl_ui_range_interactive_interface_get(void);

/**
 * @brief Control the step used to increment or decrement values for given
 * widget.
 *
 * This value will be incremented or decremented to the displayed value.
 *
 * By default step value is equal to 1.
 *
 * @warning The step value should be bigger than 0.
 *
 * @param[in] obj The object.
 * @param[in] step The step value.
 *
 * @ingroup Efl_Ui_Range_Interactive
 */
EOAPI void efl_ui_range_step_set(Eo *obj, double step);

/**
 * @brief Control the step used to increment or decrement values for given
 * widget.
 *
 * This value will be incremented or decremented to the displayed value.
 *
 * By default step value is equal to 1.
 *
 * @warning The step value should be bigger than 0.
 *
 * @param[in] obj The object.
 *
 * @return The step value.
 *
 * @ingroup Efl_Ui_Range_Interactive
 */
EOAPI double efl_ui_range_step_get(const Eo *obj);
#endif /* EFL_BETA_API_SUPPORT */

#endif
