/*
 * Copyright (c) 2012, 2019, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.sl;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_sl extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "Centralnoafri\u0161ki \u010das",
               "CAT",
               "Central Africa Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "Moskovski standardni \u010das",
               "MST",
               "Moskovski poletni \u010das",
               "MST",
               "Moskovski \u010das",
               "MT",
            };
        final String[] Japan = new String[] {
               "Japonski standardni \u010das",
               "JST",
               "Japonski poletni \u010das",
               "JDT",
               "Japonski \u010das",
               "JT",
            };
        final String[] Argentina = new String[] {
               "Argentinski standardni \u010das",
               "AST",
               "Argentinski poletni \u010das",
               "AST",
               "Argentinski \u010das",
               "AT",
            };
        final String[] Hovd = new String[] {
               "Hovdski standardni \u010das",
               "HST",
               "Hovdski poletni \u010das",
               "HST",
               "Hovdski \u010das",
               "HT",
            };
        final String[] Magadan = new String[] {
               "Magadanski standardni \u010das",
               "MST",
               "Magadanski poletni \u010das",
               "MST",
               "Magadanski \u010das",
               "MT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Avstralski centralni zahodni standardni \u010das",
               "ACWST",
               "Avstralski centralni zahodni poletni \u010das",
               "ACWDT",
               "Avstralski centralni zahodni \u010das",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "Srednjeevropski standardni \u010das",
               "CEST",
               "Srednjeevropski poletni \u010das",
               "CEST",
               "Srednjeevropski \u010das",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "Sahalinski standardni \u010das",
               "SST",
               "Sahalinski poletni \u010das",
               "SST",
               "Sahalinski \u010das",
               "ST",
            };
        final String[] Macquarie = new String[] {
               "Macquarieski \u010das",
               "MIT",
               "Macquarie Island Summer Time",
               "MIST",
               "Macquarie Island Time",
               "MIT",
            };
        final String[] America_Eastern = new String[] {
               "Vzhodni standardni \u010das",
               "EST",
               "Vzhodni poletni \u010das",
               "EDT",
               "Vzhodni \u010das",
               "ET",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Havajski aleutski standardni \u010das",
               "HAST",
               "Havajski aleutski poletni \u010das",
               "HADT",
               "Havajski aleutski \u010das",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "Avstralski centralni standardni \u010das",
               "ACST",
               "Avstralski centralni poletni \u010das",
               "ACDT",
               "Avstralski centralni \u010das",
               "CAT",
            };
        final String[] Lord_Howe = new String[] {
               "Standardni \u010das otoka Lord Howe",
               "LHST",
               "Poletni \u010das otoka Lord Howe",
               "LHDT",
               "\u010cas otoka Lord Howe",
               "LHT",
            };
        final String[] Yakutsk = new String[] {
               "Jakutski standardni \u010das",
               "YST",
               "Jakutski poletni \u010das",
               "YST",
               "Jakutski \u010das",
               "YT",
            };
        final String[] America_Pacific = new String[] {
               "Pacifi\u0161ki standardni \u010das",
               "PST",
               "Pacifi\u0161ki poletni \u010das",
               "PDT",
               "Pacifi\u0161ki \u010das",
               "PT",
            };
        final String[] Africa_Eastern = new String[] {
               "Vzhodnoafri\u0161ki \u010das",
               "EAT",
               "East Africa Summer Time",
               "EAST",
               "East Africa Time",
               "EAT",
            };
        final String[] Europe_Western = new String[] {
               "Zahodnoevropski standardni \u010das",
               "WEST",
               "Zahodnoevropski poletni \u010das",
               "WEST",
               "Zahodnoevropski \u010das",
               "WET",
            };
        final String[] Cape_Verde = new String[] {
               "Kapverdski standardni \u010das",
               "CVST",
               "Kapverdski poletni \u010das",
               "CVST",
               "Kapverdski \u010das",
               "CVT",
            };
        final String[] Europe_Eastern = new String[] {
               "Vzhodnoevropski standardni \u010das",
               "EEST",
               "Vzhodnoevropski poletni \u010das",
               "EEST",
               "Vzhodnoevropski \u010das",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "Novofundlandski standardni \u010das",
               "NST",
               "Novofundlandski poletni \u010das",
               "NDT",
               "Novofundlandski \u010das",
               "NT",
            };
        final String[] Argentina_Western = new String[] {
               "Argentinski zahodni standardni \u010das",
               "WAST",
               "Argentinski zahodni poletni \u010das",
               "WAST",
               "Argentinski zahodni \u010das",
               "WAT",
            };
        final String[] Atlantic = new String[] {
               "Atlantski standardni \u010das",
               "AST",
               "Atlantski poletni \u010das",
               "ADT",
               "Atlantski \u010das",
               "AT",
            };
        final String[] Cuba = new String[] {
               "Kubanski standardni \u010das",
               "CST",
               "Kubanski poletni \u010das",
               "CDT",
               "Kubanski \u010das",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "Zahodnoafri\u0161ki standardni \u010das",
               "WAST",
               "Zahodnoafri\u0161ki poletni \u010das",
               "WAST",
               "Zahodnoafri\u0161ki \u010das",
               "WAT",
            };
        final String[] GMT = new String[] {
               "Greenwi\u0161ki srednji \u010das",
               "GMT",
               "Greenwich Summer Time",
               "GST",
               "Greenwich Time",
               "GT",
            };
        final String[] Yekaterinburg = new String[] {
               "Jekaterinbur\u0161ki standardni \u010das",
               "YST",
               "Jekaterinbur\u0161ki poletni \u010das",
               "YST",
               "Jekaterinbur\u0161ki \u010das",
               "YT",
            };
        final String[] Volgograd = new String[] {
               "Volgograjski standardni \u010das",
               "VST",
               "Volgograjski poletni \u010das",
               "VST",
               "Volgograjski \u010das",
               "VT",
            };
        final String[] Israel = new String[] {
               "Izraelski standardni \u010das",
               "IST",
               "Izraelski poletni \u010das",
               "IDT",
               "Izraelski \u010das",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "Indonezijski osrednji \u010das",
               "CIT",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "CIT",
            };
        final String[] Africa_Southern = new String[] {
               "Ju\u017enoafri\u0161ki \u010das",
               "SAST",
               "South Africa Daylight Time",
               "SADT",
               "South Africa Time",
               "SAT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Indonezijski vzhodni \u010das",
               "EIT",
               "Eastern Indonesia Summer Time",
               "EIST",
               "Eastern Indonesia Time",
               "EIT",
            };
        final String[] Korea = new String[] {
               "Korejski standardni \u010das",
               "KST",
               "Korejski poletni \u010das",
               "KDT",
               "Korejski \u010das",
               "KT",
            };
        final String[] Omsk = new String[] {
               "Om\u0161ki standardni \u010das",
               "OST",
               "Om\u0161ki poletni \u010das",
               "OST",
               "Om\u0161ki \u010das",
               "OT",
            };
        final String[] Australia_Western = new String[] {
               "Avstralski zahodni standardni \u010das",
               "AWST",
               "Avstralski zahodni poletni \u010das",
               "AWDT",
               "Avstralski zahodni \u010das",
               "WAT",
            };
        final String[] Indonesia_Western = new String[] {
               "Indonezijski zahodni \u010das",
               "WIT",
               "Western Indonesia Summer Time",
               "WIST",
               "Western Indonesia Time",
               "WIT",
            };
        final String[] Mongolia = new String[] {
               "Ulanbatorski standardni \u010das",
               "UBST",
               "Ulanbatorski poletni \u010das",
               "UBST",
               "Ulanbatorski \u010das",
               "UBT",
            };
        final String[] America_Central = new String[] {
               "Centralni standardni \u010das",
               "CST",
               "Centralni poletni \u010das",
               "CDT",
               "Centralni \u010das",
               "CT",
            };
        final String[] Australia_Eastern = new String[] {
               "Avstralski vzhodni standardni \u010das",
               "AEST",
               "Avstralski vzhodni poletni \u010das",
               "AEDT",
               "Avstralski vzhodni \u010das",
               "EAT",
            };
        final String[] Colombia = new String[] {
               "Kolumbijski standardni \u010das",
               "CST",
               "Kolumbijski poletni \u010das",
               "CST",
               "Kolumbijski \u010das",
               "CT",
            };
        final String[] Chile = new String[] {
               "\u010cilski standardni \u010das",
               "CST",
               "\u010cilski poletni \u010das",
               "CST",
               "\u010cilski \u010das",
               "CT",
            };
        final String[] America_Mountain = new String[] {
               "Gorski standardni \u010das",
               "MST",
               "Gorski poletni \u010das",
               "MDT",
               "Gorski \u010das",
               "MT",
            };
        final String[] Arabian = new String[] {
               "Arabski standardni \u010das",
               "AST",
               "Arabski poletni \u010das",
               "ADT",
               "Arabski \u010das",
               "AT",
            };
        final String[] Alaska = new String[] {
               "Alja\u0161ki standardni \u010das",
               "AKST",
               "Alja\u0161ki poletni \u010das",
               "AKDT",
               "Alja\u0161ki \u010das",
               "AKT",
            };
        final String[] Novosibirsk = new String[] {
               "Novosibir\u0161ki standardni \u010das",
               "NST",
               "Novosibir\u0161ki poletni \u010das",
               "NST",
               "Novosibir\u0161ki \u010das",
               "NT",
            };
        final String[] Vladivostok = new String[] {
               "Vladivosto\u0161ki standardni \u010das",
               "VST",
               "Vladivosto\u0161ki poletni \u010das",
               "VST",
               "Vladivosto\u0161ki \u010das",
               "VT",
            };
        final String[] Irkutsk = new String[] {
               "Irkut\u0161ki standardni \u010das",
               "IST",
               "Irkut\u0161ki poletni \u010das",
               "IST",
               "Irkut\u0161ki \u010das",
               "IT",
            };
        final String[] Noronha = new String[] {
               "Fernando de Noron\u0161ki standardni \u010das",
               "FNST",
               "Fernando de Noron\u0161ki poletni \u010das",
               "FNST",
               "Fernando de Noron\u0161ki \u010das",
               "FNT",
            };
        final String[] Azores = new String[] {
               "Azorski standardni \u010das",
               "AST",
               "Azorski poletni \u010das",
               "AST",
               "Azorski \u010das",
               "AT",
            };
        final String[] Choibalsan = new String[] {
               "\u010cojbalsanski standardni \u010das",
               "CST",
               "\u010cojbalsanski poletni \u010das",
               "CST",
               "\u010cojbalsanski \u010das",
               "CT",
            };
        final String[] Brasilia = new String[] {
               "Brasilski standardni \u010das",
               "BST",
               "Brasilski poletni \u010das",
               "BST",
               "Brasilski \u010das",
               "BT",
            };
        final String[] China = new String[] {
               "Kitajski standardni \u010das",
               "CST",
               "Kitajski poletni \u010das",
               "CDT",
               "Kitajski \u010das",
               "CT",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnojar\u0161ki standardni \u010das",
               "KST",
               "Krasnojar\u0161ki poletni \u010das",
               "KST",
               "Krasnojar\u0161ki \u010das",
               "KT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Zahodni kazahstanski \u010das",
               "WKT",
               "West Kazakhstan Summer Time",
               "WKST",
               "West Kazakhstan Time",
               "WKT",
            };
        final String[] India = new String[] {
               "Indijski standardni \u010das",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Amazon = new String[] {
               "Amazonski standardni \u010das",
               "AST",
               "Amazonski poletni \u010das",
               "AST",
               "Amazonski \u010das",
               "AT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Vzhodni kazahstanski \u010das",
               "EKT",
               "East Kazakhstan Summer Time",
               "EKST",
               "East Kazakhstan Time",
               "EKT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Libreville", Africa_Western },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/El_Salvador", America_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London", GMT },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Europe/Brussels", Europe_Central },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", America_Mountain },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Europe/Warsaw", Europe_Central },
            { "Asia/Kashgar", China },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Eirunepe", Amazon },
            { "Europe/Luxembourg", Europe_Central },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "Atlantic/St_Helena", GMT },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Europe/Guernsey", GMT },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Grand_Turk", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "America/Creston", America_Mountain },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "America/Mexico_City", America_Central },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Europe/Andorra", Europe_Central },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Europe/Kaliningrad", GMT },
            { "Asia/Riyadh", Arabian },
            { "Africa/Windhoek", Africa_Western },
            { "Europe/Lisbon", Europe_Western },
            { "Asia/Harbin", China },
            { "Europe/Oslo", Europe_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Asia/Novokuznetsk", Novosibirsk },
            { "Australia/Perth", Australia_Western },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "America/Manaus", Amazon },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "America/Resolute", America_Central },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "America/Catamarca", Argentina },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Eastern },
            { "America/Glace_Bay", Atlantic },
            { "Africa/Lagos", Africa_Western },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "Africa/Bamako", GMT },
            { "America/Hermosillo", America_Mountain },
            { "America/Cancun", America_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "America/Havana", Cuba },
            { "America/Santa_Isabel", America_Pacific },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Colombo", India },
            { "Asia/Omsk", Omsk },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "America/Barbados", Atlantic },
            { "Asia/Urumqi", China },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Europe/Volgograd", Volgograd },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Rio_Branco", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Thule", Atlantic },
            { "America/Curacao", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "America/Argentina/La_Rioja", Argentina },
            { "Europe/Stockholm", Europe_Central },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Kamchatka", Magadan },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Africa/Sao_Tome", GMT },
            { "Asia/Yakutsk", Yakutsk },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Ndjamena", Africa_Western },
            { "America/Rainy_River", America_Central },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Africa/Ceuta", Europe_Central },
            { "America/Jujuy", Argentina },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", America_Pacific },
            { "America/Pangnirtung", America_Eastern },
            { "Africa/Djibouti", Africa_Eastern },
            { "Europe/Simferopol", Europe_Eastern },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Africa/Niamey", Africa_Western },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "America/Whitehorse", America_Pacific },
            { "America/Kralendijk", Atlantic },
            { "Europe/Samara", Moscow },
            { "America/Antigua", Atlantic },
            { "America/Montreal", America_Eastern },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Antarctica/Macquarie", Macquarie },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "America/Indiana/Winamac", America_Eastern },
            { "Asia/Pyongyang", Korea },
            { "America/Boa_Vista", Amazon },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "Europe/Bratislava", Europe_Central },
            { "America/Yakutat", Alaska },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "America/Merida", America_Central },
            { "America/Mazatlan", America_Mountain },
            { "Europe/Tirane", Europe_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "Africa/Monrovia", GMT },
            { "America/Santarem", Brasilia },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "America/Shiprock", America_Mountain },
            { "America/Winnipeg", America_Central },
            { "Asia/Chongqing", China },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Africa/Accra", GMT },
            { "Asia/Amman", Europe_Eastern },
            { "America/Maceio", Brasilia },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin", GMT },
            { "America/Toronto", America_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
