#ifndef _EFL_UI_GRID_EO_H_
#define _EFL_UI_GRID_EO_H_

#ifndef _EFL_UI_GRID_EO_CLASS_TYPE
#define _EFL_UI_GRID_EO_CLASS_TYPE

typedef Eo Efl_Ui_Grid;

#endif

#ifndef _EFL_UI_GRID_EO_TYPES
#define _EFL_UI_GRID_EO_TYPES


#endif
#ifdef EFL_BETA_API_SUPPORT
/** Simple grid widget with Pack interface.
 *
 * @ingroup Efl_Ui_Grid
 */
#define EFL_UI_GRID_CLASS efl_ui_grid_class_get()

EWAPI const Efl_Class *efl_ui_grid_class_get(void);

/**
 * @brief Property data of item size.
 *
 * @param[in] obj The object.
 * @param[in] size last selected item of grid.
 *
 * @ingroup Efl_Ui_Grid
 */
EOAPI void efl_ui_grid_item_size_set(Eo *obj, Eina_Size2D size);

/**
 * @brief Property data of item size.
 *
 * @param[in] obj The object.
 *
 * @return last selected item of grid.
 *
 * @ingroup Efl_Ui_Grid
 */
EOAPI Eina_Size2D efl_ui_grid_item_size_get(const Eo *obj);

/**
 * @brief scroll move the item to show in the viewport.
 *
 * @param[in] obj The object.
 * @param[in] item Target item.
 * @param[in] animation Boolean value for animation of scroll move.
 *
 * @ingroup Efl_Ui_Grid
 */
EOAPI void efl_ui_grid_item_scroll(Eo *obj, Efl_Ui_Grid_Item *item, Eina_Bool animation);

/**
 * @brief scroll move the item to show at the align position of the viewport.
 *
 * @param[in] obj The object.
 * @param[in] item Target item.
 * @param[in] align align value in Viewport.
 * @param[in] animation Boolean value for animation of scroll move.
 *
 * @ingroup Efl_Ui_Grid
 */
EOAPI void efl_ui_grid_item_scroll_align(Eo *obj, Efl_Ui_Grid_Item *item, double align, Eina_Bool animation);

/**
 * @brief Property data of last selected item.
 *
 * @param[in] obj The object.
 *
 * @return last selected item of grid.
 *
 * @ingroup Efl_Ui_Grid
 */
EOAPI Efl_Ui_Grid_Item *efl_ui_grid_last_selected_item_get(const Eo *obj);

/**
 * @brief Get the selected items iterator. The iterator sequence will be
 * decided by selection.
 *
 * @param[in] obj The object.
 *
 * @return Iterator covered by selected items list. user have to free the
 * iterator after used.
 *
 * @ingroup Efl_Ui_Grid
 */
EOAPI Eina_Iterator *efl_ui_grid_selected_items_get(Eo *obj) EINA_WARN_UNUSED_RESULT;
#endif /* EFL_BETA_API_SUPPORT */

#endif
