/*
 * Copyright (c) 2012, 2019, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class CurrencyNames_ca extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final Object[][] data = new Object[][] {
            { "AUD", "AU$" },
            { "BRL", "BRL" },
            { "CAD", "CAD" },
            { "CNH", "CNH" },
            { "CNY", "CNY" },
            { "ESP", "\u20a7" },
            { "MXN", "MXN" },
            { "STN", "STN" },
            { "THB", "\u0e3f" },
            { "USD", "USD" },
            { "VES", "VES" },
            { "XCD", "XCD" },
            { "XXX", "XXX" },
            { "adp", "pesseta andorrana" },
            { "aed", "d\u00edrham de la UEA" },
            { "afa", "afgani afgan\u00e8s (1927\u20132002)" },
            { "afn", "afgani afgan\u00e8s" },
            { "alk", "lek alban\u00e8s (1946\u20131965)" },
            { "all", "lek alban\u00e8s" },
            { "amd", "dram armeni" },
            { "ang", "flor\u00ed de les Antilles Neerlandeses" },
            { "aoa", "kwanza angol\u00e8s" },
            { "aok", "kwanza angol\u00e8s (1977\u20131991)" },
            { "aon", "nou kwanza angol\u00e8s (1990\u20132000)" },
            { "aor", "kwanza angol\u00e8s reajustat (1995\u20131999)" },
            { "ara", "austral argent\u00ed" },
            { "arl", "peso ley argent\u00ed (1970\u20131983)" },
            { "arm", "peso argent\u00ed (1981\u20131970)" },
            { "arp", "peso argent\u00ed (1983\u20131985)" },
            { "ars", "peso argent\u00ed" },
            { "ats", "x\u00edling austr\u00edac" },
            { "aud", "d\u00f2lar australi\u00e0" },
            { "awg", "flor\u00ed d\u2019Aruba" },
            { "azm", "manat azerbaidjan\u00e8s (1993\u20132006)" },
            { "azn", "manat azerbaidjan\u00e8s" },
            { "bad", "dinar de B\u00f2snia i Hercegovina (1992\u20131994)" },
            { "bam", "marc convertible de B\u00f2snia i Hercegovina" },
            { "ban", "nou dinar de B\u00f2snia i Hercegovina (1994\u20131997)" },
            { "bbd", "d\u00f2lar de Barbados" },
            { "bdt", "taka de Bangla Desh" },
            { "bec", "franc belga (convertible)" },
            { "bef", "franc belga" },
            { "bel", "franc belga (financer)" },
            { "bgl", "lev fort b\u00falgar" },
            { "bgm", "lev socialista b\u00falgar" },
            { "bgn", "lev b\u00falgar" },
            { "bgo", "lev b\u00falgar (1879\u20131952)" },
            { "bhd", "dinar de Bahrain" },
            { "bif", "franc de Burundi" },
            { "bmd", "d\u00f2lar de les Bermudes" },
            { "bnd", "d\u00f2lar de Brunei" },
            { "bob", "bolivi\u00e0" },
            { "bol", "boliviano bolivi\u00e0 (1863\u20131963)" },
            { "bop", "peso bolivi\u00e0" },
            { "bov", "MVDOL bolivi\u00e0" },
            { "brb", "cruzeiro novo brasiler (1967\u20131986)" },
            { "brc", "cruzado brasiler" },
            { "bre", "cruzeiro brasiler (1990\u20131993)" },
            { "brl", "real brasiler" },
            { "brn", "cruzado novo brasiler" },
            { "brr", "cruzeiro brasiler" },
            { "brz", "antic cruzeiro brasiler" },
            { "bsd", "d\u00f2lar de les Bahames" },
            { "btn", "ngultrum de Bhutan" },
            { "buk", "kyat birm\u00e0" },
            { "bwp", "pula de Botswana" },
            { "byb", "nou ruble bielor\u00fas (1994\u20131999)" },
            { "byn", "ruble bielor\u00fas" },
            { "byr", "ruble bielor\u00fas (2000\u20132016)" },
            { "bzd", "d\u00f2lar de Belize" },
            { "cad", "d\u00f2lar canadenc" },
            { "cdf", "franc congol\u00e8s" },
            { "che", "euro WIR" },
            { "chf", "franc su\u00eds" },
            { "chw", "franc WIR" },
            { "cle", "escut xil\u00e8" },
            { "clf", "unidad de fomento xilena" },
            { "clp", "peso xil\u00e8" },
            { "cnh", "iuan xin\u00e8s extracontinental" },
            { "cny", "iuan xin\u00e8s" },
            { "cop", "peso colombi\u00e0" },
            { "cou", "unidad de valor real colombiana" },
            { "crc", "colon costa-riqueny" },
            { "csd", "dinar serbi antic" },
            { "csk", "corona forta txecoslovaca" },
            { "cuc", "peso convertible cub\u00e0" },
            { "cup", "peso cub\u00e0" },
            { "cve", "escut de Cap Verd" },
            { "cyp", "lliura xipriota" },
            { "czk", "corona txeca" },
            { "ddm", "marc de l\u2019Alemanya Oriental" },
            { "dem", "marc alemany" },
            { "djf", "franc de Djibouti" },
            { "dkk", "corona danesa" },
            { "dop", "peso dominic\u00e0" },
            { "dzd", "dinar algeri\u00e0" },
            { "ecs", "sucre equatori\u00e0" },
            { "ecv", "unidad de valor constante (UVC) equatoriana" },
            { "eek", "corona estoniana" },
            { "egp", "lliura eg\u00edpcia" },
            { "ern", "nakfa eritreu" },
            { "esa", "pesseta espanyola (compte A)" },
            { "esb", "pesseta espanyola (compte convertible)" },
            { "esp", "pesseta espanyola" },
            { "etb", "birr et\u00edop" },
            { "eur", "euro" },
            { "fim", "marc finland\u00e8s" },
            { "fjd", "d\u00f2lar fiji\u00e0" },
            { "fkp", "lliura de les illes Malvines" },
            { "frf", "franc franc\u00e8s" },
            { "gbp", "lliura esterlina brit\u00e0nica" },
            { "gek", "cup\u00f3 de lari georgi\u00e0" },
            { "gel", "lari georgi\u00e0" },
            { "ghc", "cedi ghan\u00e8s (1979\u20132007)" },
            { "ghs", "cedi ghan\u00e8s" },
            { "gip", "lliura de Gibraltar" },
            { "gmd", "dalasi gambi\u00e0" },
            { "gnf", "franc guine\u00e0" },
            { "gns", "syli guine\u00e0" },
            { "gqe", "ekwele de Guinea Equatorial" },
            { "grd", "dracma grega" },
            { "gtq", "quetzal guatemalenc" },
            { "gwe", "escut de la Guinea Portuguesa" },
            { "gwp", "peso de Guinea Bissau" },
            { "gyd", "d\u00f2lar de Guyana" },
            { "hkd", "d\u00f2lar de Hong Kong" },
            { "hnl", "lempira hondurenya" },
            { "hrd", "dinar croat" },
            { "hrk", "kuna croata" },
            { "htg", "gourde haiti\u00e0" },
            { "huf", "f\u00f2rint hongar\u00e8s" },
            { "idr", "rupia indon\u00e8sia" },
            { "iep", "lliura irlandesa" },
            { "ilp", "lliura israeliana" },
            { "ilr", "x\u00e9quel israeli\u00e0" },
            { "ils", "nou x\u00e9quel israeli\u00e0" },
            { "inr", "rupia \u00edndia" },
            { "iqd", "dinar iraqui\u00e0" },
            { "irr", "rial irani\u00e0" },
            { "isj", "corona islandesa antiga" },
            { "isk", "corona islandesa" },
            { "itl", "lira italiana" },
            { "jmd", "d\u00f2lar jamaic\u00e0" },
            { "jod", "dinar jord\u00e0" },
            { "jpy", "ien japon\u00e8s" },
            { "kes", "x\u00edling keny\u00e0" },
            { "kgs", "som kirgu\u00eds" },
            { "khr", "riel cambodj\u00e0" },
            { "kmf", "franc de les Comores" },
            { "kpw", "won nord-core\u00e0" },
            { "krh", "hwan sud-core\u00e0 (1953\u20131962)" },
            { "kro", "antic won sud-core\u00e0" },
            { "krw", "won sud-core\u00e0" },
            { "kwd", "dinar kuwaiti\u00e0" },
            { "kyd", "d\u00f2lar de les illes Caiman" },
            { "kzt", "tenge kazakh" },
            { "lak", "kip laosi\u00e0" },
            { "lbp", "lliura libanesa" },
            { "lkr", "rupia de Sri Lanka" },
            { "lrd", "d\u00f2lar liberi\u00e0" },
            { "lsl", "loti de Lesotho" },
            { "ltl", "litas litu\u00e0" },
            { "ltt", "talonas litu\u00e0" },
            { "luc", "franc convertible luxemburgu\u00e8s" },
            { "luf", "franc luxemburgu\u00e8s" },
            { "lul", "franc financer luxemburgu\u00e8s" },
            { "lvl", "lats let\u00f3" },
            { "lvr", "ruble let\u00f3" },
            { "lyd", "dinar libi" },
            { "mad", "d\u00edrham marroqu\u00ed" },
            { "maf", "franc marroqu\u00ed" },
            { "mcf", "franc monegasc" },
            { "mdc", "cup\u00f3 moldau" },
            { "mdl", "leu moldau" },
            { "mga", "ariary malgaix" },
            { "mgf", "franc malgaix" },
            { "mkd", "denar macedoni" },
            { "mkn", "denar macedoni (1992\u20131993)" },
            { "mlf", "franc mali\u00e0" },
            { "mmk", "kyat de Myanmar" },
            { "mnt", "t\u00f6gr\u00f6g mongol" },
            { "mop", "pataca de Macau" },
            { "mro", "ouguiya maurit\u00e0 (1973\u20132017)" },
            { "mru", "ouguiya maurit\u00e0" },
            { "mtl", "lira maltesa" },
            { "mtp", "lliura maltesa" },
            { "mur", "rupia mauriciana" },
            { "mvr", "rupia de les Maldives" },
            { "mwk", "kwacha malawi\u00e0" },
            { "mxn", "peso mexic\u00e0" },
            { "mxp", "peso de plata mexic\u00e0 (1861\u20131992)" },
            { "mxv", "unidad de inversi\u00f3n (UDI) mexicana" },
            { "myr", "ringgit de Mal\u00e0isia" },
            { "mze", "escut mo\u00e7ambiqu\u00e8s" },
            { "mzm", "antic metical mo\u00e7ambiqu\u00e8s" },
            { "mzn", "metical mo\u00e7ambiqu\u00e8s" },
            { "nad", "d\u00f2lar namibi\u00e0" },
            { "ngn", "naira nigeri\u00e0" },
            { "nic", "c\u00f3rdoba nicarag\u00fcenca" },
            { "nio", "c\u00f3rdoba nicarag\u00fcenc" },
            { "nlg", "flor\u00ed neerland\u00e8s" },
            { "nok", "corona noruega" },
            { "npr", "rupia nepalesa" },
            { "nzd", "d\u00f2lar neozeland\u00e8s" },
            { "omr", "rial omanita" },
            { "pab", "balboa panameny" },
            { "pei", "inti peru\u00e0" },
            { "pen", "sol peru\u00e0" },
            { "pes", "sol peru\u00e0 (1863\u20131965)" },
            { "pgk", "kina de Papua Nova Guinea" },
            { "php", "peso filip\u00ed" },
            { "pkr", "rupia pakistanesa" },
            { "pln", "zloty polon\u00e8s" },
            { "plz", "zloty polon\u00e8s (1950\u20131995)" },
            { "pte", "escut portugu\u00e8s" },
            { "pyg", "guaran\u00ed paraguai\u00e0" },
            { "qar", "rial de Qatar" },
            { "rhd", "d\u00f2lar rhodesi\u00e0" },
            { "rol", "antic leu roman\u00e8s" },
            { "ron", "leu roman\u00e8s" },
            { "rsd", "dinar serbi" },
            { "rub", "ruble rus" },
            { "rur", "ruble rus (1991\u20131998)" },
            { "rwf", "franc de Ruanda" },
            { "sar", "rial saudita" },
            { "sbd", "d\u00f2lar de les illes Salom\u00f3" },
            { "scr", "rupia de les Seychelles" },
            { "sdd", "dinar sudan\u00e8s" },
            { "sdg", "lliura sudanesa" },
            { "sdp", "antiga lliura sudanesa" },
            { "sek", "corona sueca" },
            { "sgd", "d\u00f2lar de Singapur" },
            { "shp", "lliura de Santa Helena" },
            { "sit", "tolar eslov\u00e8" },
            { "skk", "corona eslovaca" },
            { "sll", "leone de Sierra Leone" },
            { "sos", "x\u00edling somali" },
            { "srd", "d\u00f2lar de Surinam" },
            { "srg", "flor\u00ed de Surinam" },
            { "ssp", "lliura del Sudan del Sud" },
            { "std", "dobra de S\u00e3o Tom\u00e9 i Pr\u00edncipe (1977\u20132017)" },
            { "stn", "dobra de S\u00e3o Tom\u00e9 i Pr\u00edncipe" },
            { "sur", "ruble sovi\u00e8tic" },
            { "svc", "colon salvadorenc" },
            { "syp", "lliura s\u00edria" },
            { "szl", "lilangeni swazi" },
            { "thb", "baht tailand\u00e8s" },
            { "tjr", "ruble tadjik" },
            { "tjs", "somoni tadjik" },
            { "tmm", "manat turcman (1993\u20132009)" },
            { "tmt", "manat turcman" },
            { "tnd", "dinar tunisi\u00e0" },
            { "top", "pa\u2018anga tong\u00e0" },
            { "tpe", "escut de Timor" },
            { "trl", "lira turca (1922\u20132005)" },
            { "try", "lira turca" },
            { "ttd", "d\u00f2lar de Trinitat i Tobago" },
            { "twd", "nou d\u00f2lar de Taiwan" },
            { "tzs", "x\u00edling tanz\u00e0" },
            { "uah", "hr\u00edvnia ucra\u00efnesa" },
            { "uak", "karb\u00f3vanets ucra\u00efn\u00e8s" },
            { "ugs", "x\u00edling ugand\u00e8s (1966\u20131987)" },
            { "ugx", "x\u00edling ugand\u00e8s" },
            { "usd", "d\u00f2lar dels Estats Units" },
            { "usn", "d\u00f2lar dels Estats Units (dia seg\u00fcent)" },
            { "uss", "d\u00f2lar dels Estats Units (mateix dia)" },
            { "uyi", "peso uruguai\u00e0 en unitats indexades" },
            { "uyp", "peso uruguai\u00e0 (1975\u20131993)" },
            { "uyu", "peso uruguai\u00e0" },
            { "uzs", "som uzbek" },
            { "veb", "bol\u00edvar vene\u00e7ol\u00e0 (1871\u20132008)" },
            { "vef", "bol\u00edvar vene\u00e7ol\u00e0 (2008\u20132018)" },
            { "ves", "bol\u00edvar vene\u00e7ol\u00e0" },
            { "vnd", "dong vietnamita" },
            { "vnn", "dong vietnamita (1978\u20131985)" },
            { "vuv", "vatu de Vanuatu" },
            { "wst", "tala samo\u00e0" },
            { "xaf", "franc CFA BEAC" },
            { "xag", "plata" },
            { "xau", "or" },
            { "xba", "unitat compensat\u00f2ria europea" },
            { "xbb", "unitat monet\u00e0ria europea" },
            { "xbc", "unitat de compte europea (XBC)" },
            { "xbd", "unitat de compte europea (XBD)" },
            { "xcd", "d\u00f2lar del Carib Oriental" },
            { "xdr", "drets especials de gir" },
            { "xeu", "unitat de moneda europea" },
            { "xfo", "franc or franc\u00e8s" },
            { "xfu", "franc UIC franc\u00e8s" },
            { "xof", "franc CFA BCEAO" },
            { "xpd", "pal\u00b7ladi" },
            { "xpf", "franc CFP" },
            { "xpt", "plat\u00ed" },
            { "xre", "fons RINET" },
            { "xts", "codi reservat per a proves" },
            { "xxx", "moneda desconeguda" },
            { "ydd", "dinar iemenita" },
            { "yer", "rial iemenita" },
            { "yud", "dinar fort iugoslau" },
            { "yum", "nou dinar iugoslau" },
            { "yun", "dinar convertible iugoslau" },
            { "yur", "dinar iugoslau reformat (1992\u20131993)" },
            { "zal", "rand sud-afric\u00e0 (financer)" },
            { "zar", "rand sud-afric\u00e0" },
            { "zmk", "kwacha zambi\u00e0 (1968\u20132012)" },
            { "zmw", "kwacha zambi\u00e0" },
            { "zrn", "nou zaire zair\u00e8s" },
            { "zrz", "zaire zair\u00e8s" },
            { "zwd", "d\u00f2lar zimbabu\u00e8s (1980\u20132008)" },
            { "zwl", "d\u00f2lar zimbabu\u00e8s (2009)" },
            { "zwr", "d\u00f2lar zimbabu\u00e8s (2008)" },
        };
        return data;
    }
}
