/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.swing;

import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

class HeaderComponent
extends JComponent {
    private boolean isPressed;
    private boolean isSelected;
    private static CellRendererPane PAINTER;
    private static JTable REF_TABLE;

    HeaderComponent(final ActionListener actionListener) {
        if (actionListener != null) {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    HeaderComponent.this.isPressed = true;
                    HeaderComponent.this.isSelected = true;
                    HeaderComponent.this.repaint();
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    HeaderComponent.this.isPressed = false;
                    if (HeaderComponent.this.isSelected) {
                        HeaderComponent.this.repaint();
                        this.fireActionEvent(mouseEvent);
                    }
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    if (HeaderComponent.this.isPressed || !this.isButtonDown(mouseEvent)) {
                        HeaderComponent.this.isSelected = true;
                        HeaderComponent.this.repaint();
                    }
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    if (HeaderComponent.this.isSelected) {
                        HeaderComponent.this.isSelected = false;
                        HeaderComponent.this.repaint();
                    }
                }

                private void fireActionEvent(MouseEvent mouseEvent) {
                    ActionEvent actionEvent = new ActionEvent(mouseEvent.getSource(), mouseEvent.getID(), mouseEvent.paramString(), mouseEvent.getWhen(), mouseEvent.getModifiers());
                    actionListener.actionPerformed(actionEvent);
                }

                private boolean isButtonDown(MouseEvent mouseEvent) {
                    return SwingUtilities.isLeftMouseButton(mouseEvent) || SwingUtilities.isMiddleMouseButton(mouseEvent) || SwingUtilities.isRightMouseButton(mouseEvent);
                }
            });
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        JTableHeader jTableHeader = HeaderComponent.getHeader();
        this.setupHeader(jTableHeader);
        TableCellRenderer tableCellRenderer = jTableHeader.getDefaultRenderer();
        JComponent jComponent = (JComponent)tableCellRenderer.getTableCellRendererComponent(HeaderComponent.getTable(), "", this.isSelected && this.isPressed, this.isFocusOwner(), -1, 0);
        int n = jTableHeader.getPreferredSize().height;
        jComponent.setBounds(0, 0, this.getWidth(), n);
        jComponent.setOpaque(false);
        HeaderComponent.getPainter().paintComponent(graphics, jComponent, null, 0, 0, this.getWidth(), n, false);
    }

    private void setupHeader(JTableHeader jTableHeader) {
        jTableHeader.setDraggedColumn(this.isSelected && this.isPressed ? HeaderComponent.getColumn() : null);
        MouseEvent mouseEvent = this.isSelected && !this.isPressed ? new MouseEvent(jTableHeader, 504, 1L, 0, 1, 1, 0, false) : new MouseEvent(jTableHeader, 505, 1L, 0, 0, 0, 0, false);
        jTableHeader.dispatchEvent(mouseEvent);
    }

    private static CellRendererPane getPainter() {
        if (PAINTER == null) {
            PAINTER = new CellRendererPane();
        }
        return PAINTER;
    }

    private static JTable getTable() {
        if (REF_TABLE == null) {
            REF_TABLE = new JTable(new Object[][]{new Object[0]}, new Object[]{" "}){

                @Override
                protected JTableHeader createDefaultTableHeader() {
                    return new JTableHeader(this.columnModel){

                        @Override
                        public boolean contains(int n, int n2) {
                            return n == 1 && n2 == 1;
                        }
                    };
                }
            };
        }
        return REF_TABLE;
    }

    private static JTableHeader getHeader() {
        return HeaderComponent.getTable().getTableHeader();
    }

    private static TableColumn getColumn() {
        return HeaderComponent.getHeader().getColumnModel().getColumn(0);
    }
}

