#ifndef _EFL_UI_SCROLL_ALERT_POPUP_EO_H_
#define _EFL_UI_SCROLL_ALERT_POPUP_EO_H_

#ifndef _EFL_UI_SCROLL_ALERT_POPUP_EO_CLASS_TYPE
#define _EFL_UI_SCROLL_ALERT_POPUP_EO_CLASS_TYPE

typedef Eo Efl_Ui_Scroll_Alert_Popup;

#endif

#ifndef _EFL_UI_SCROLL_ALERT_POPUP_EO_TYPES
#define _EFL_UI_SCROLL_ALERT_POPUP_EO_TYPES


#endif
#ifdef EFL_BETA_API_SUPPORT
/** EFL UI Scroll Alert Popup class
 *
 * @ingroup Efl_Ui_Scroll_Alert_Popup
 */
#define EFL_UI_SCROLL_ALERT_POPUP_CLASS efl_ui_scroll_alert_popup_class_get()

EWAPI const Efl_Class *efl_ui_scroll_alert_popup_class_get(void);

#ifdef EFL_BETA_API_SUPPORT
/**
 * @brief Set the expandable max size of popup.
 *
 * If the given max_size is -1, then a popup appears with its size. However, if
 * the given max_size is bigger than 0 the popup size is up to the given
 * max_size. If popup content's min size is bigger than the given max_size the
 * scroller appears in the popup content area.
 *
 * @param[in] obj The object.
 * @param[in] max_size A 2D max size in pixel units.
 *
 * @ingroup Efl_Ui_Scroll_Alert_Popup
 */
EOAPI void efl_ui_scroll_alert_popup_expandable_set(Eo *obj, Eina_Size2D max_size);
#endif /* EFL_BETA_API_SUPPORT */

#ifdef EFL_BETA_API_SUPPORT
/**
 * @brief Get the expandable max size of popup.
 *
 * If the given max_size is -1, then popup appears with its size. However, if
 * the given max_size is bigger than 0 the popup size is up to the given
 * max_size. If popup content's min size is bigger than the given max_size the
 * scroller appears in the popup content area.
 *
 * @param[in] obj The object.
 *
 * @return A 2D max size in pixel units.
 *
 * @ingroup Efl_Ui_Scroll_Alert_Popup
 */
EOAPI Eina_Size2D efl_ui_scroll_alert_popup_expandable_get(const Eo *obj);
#endif /* EFL_BETA_API_SUPPORT */
#endif /* EFL_BETA_API_SUPPORT */

#endif
