#ifndef _EFL_CANVAS_GESTURE_MANAGER_EO_H_
#define _EFL_CANVAS_GESTURE_MANAGER_EO_H_

#ifndef _EFL_CANVAS_GESTURE_MANAGER_EO_CLASS_TYPE
#define _EFL_CANVAS_GESTURE_MANAGER_EO_CLASS_TYPE

typedef Eo Efl_Canvas_Gesture_Manager;

#endif

#ifndef _EFL_CANVAS_GESTURE_MANAGER_EO_TYPES
#define _EFL_CANVAS_GESTURE_MANAGER_EO_TYPES


#endif
#ifdef EFL_BETA_API_SUPPORT
/** EFL Gesture Manager class
 *
 * @ingroup Efl_Canvas_Gesture_Manager
 */
#define EFL_CANVAS_GESTURE_MANAGER_CLASS efl_canvas_gesture_manager_class_get()

EWAPI const Efl_Class *efl_canvas_gesture_manager_class_get(void);

/**
 * @brief This function is called to register a new
 * Efl.Canvas.Gesture_Recognizer
 *
 * @param[in] obj The object.
 * @param[in] recognizer The gesture recognizer object
 *
 * @return Returns the Efl.Event_Description type the recognizer supports
 *
 * @ingroup Efl_Canvas_Gesture_Manager
 */
EOAPI const Efl_Event_Description *efl_gesture_manager_recognizer_register(Eo *obj, Efl_Canvas_Gesture_Recognizer *recognizer);

/**
 * @brief This function is called to unregister a Efl.Canvas.Gesture_Recognizer
 *
 * @param[in] obj The object.
 * @param[in] recognizer The gesture recognizer object
 *
 * @ingroup Efl_Canvas_Gesture_Manager
 */
EOAPI void efl_gesture_manager_recognizer_unregister(Eo *obj, Efl_Canvas_Gesture_Recognizer *recognizer);

/**
 * @brief This property holds the config value for the recognizer
 *
 * @param[in] obj The object.
 * @param[in] name propery name
 * @param[in] value value of the property
 *
 * @ingroup Efl_Canvas_Gesture_Manager
 */
EOAPI void efl_gesture_manager_config_set(Eo *obj, const char *name, Eina_Value *value);

/**
 * @brief This property holds the config value for the recognizer
 *
 * @param[in] obj The object.
 * @param[in] name propery name
 *
 * @return value of the property
 *
 * @ingroup Efl_Canvas_Gesture_Manager
 */
EOAPI Eina_Value *efl_gesture_manager_config_get(const Eo *obj, const char *name);
#endif /* EFL_BETA_API_SUPPORT */

#endif
