/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui.wizards;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.modules.autoupdate.ui.Utilities;
import org.netbeans.modules.autoupdate.ui.wizards.InstallUnitWizardModel;
import org.netbeans.modules.autoupdate.ui.wizards.OperationWizardModel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class LicenseApprovalPanel
extends JPanel {
    public static final String LICENSE_APPROVED = "license-approved";
    private List<UpdateElement> license4plugins;
    private JCheckBox cbAccept;
    private JComboBox cbPlugins;
    private JLabel lbPlugins;
    private JScrollPane spLicense;
    private JTextArea taLicense;
    private JTextPane tpTitle;

    public LicenseApprovalPanel(InstallUnitWizardModel model, boolean isApproved) {
        this.initComponents();
        this.cbAccept.setSelected(isApproved);
        if (model != null) {
            this.writeLicenses(model);
        } else {
            this.cbAccept.setEnabled(false);
            this.taLicense.setEnabled(false);
        }
    }

    Collection<String> getLicenses() {
        assert (this.license4plugins != null) : "Licenses must found.";
        if (this.license4plugins == null && this.license4plugins.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<String> licenses = new HashSet<String>();
        for (UpdateElement el : this.license4plugins) {
            licenses.add(el.getLicence());
        }
        return licenses;
    }

    Collection<String> getLicenseIds() {
        assert (this.license4plugins != null) : "Licenses must found.";
        if (this.license4plugins == null && this.license4plugins.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<String> licenseIds = new HashSet<String>();
        for (UpdateElement el : this.license4plugins) {
            licenseIds.add(el.getLicenseId());
        }
        return licenseIds;
    }

    private void goOverLicenses(InstallUnitWizardModel model) {
        for (UpdateElement el : model.getAllUpdateElements()) {
            if (el.getLicence() == null) continue;
            if (this.license4plugins == null) {
                this.license4plugins = new ArrayList<UpdateElement>();
            }
            if (OperationWizardModel.OperationType.UPDATE.equals((Object)model.getOperation()) && Utilities.isLicenseIdApproved(el.getLicenseId())) continue;
            Logger.getLogger(LicenseApprovalPanel.class.getName()).log(Level.FINE, "{0}[{1}] hasn''t been accepted yet.", new Object[]{el, el.getLicenseId()});
            this.license4plugins.add(el);
        }
    }

    public boolean isApproved() {
        return this.cbAccept.isSelected();
    }

    private void initComponents() {
        this.cbAccept = new JCheckBox();
        this.cbPlugins = new JComboBox();
        this.spLicense = new JScrollPane();
        this.taLicense = new JTextArea();
        this.lbPlugins = new JLabel();
        this.tpTitle = new JTextPane();
        Mnemonics.setLocalizedText((AbstractButton)this.cbAccept, (String)NbBundle.getMessage(LicenseApprovalPanel.class, (String)"LicenseApprovalPanel.cbAccept.text"));
        this.cbAccept.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LicenseApprovalPanel.this.cbAcceptActionPerformed(evt);
            }
        });
        this.cbPlugins.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LicenseApprovalPanel.this.cbPluginsActionPerformed(evt);
            }
        });
        this.taLicense.setEditable(false);
        this.taLicense.setColumns(20);
        this.taLicense.setLineWrap(true);
        this.taLicense.setRows(5);
        this.taLicense.setWrapStyleWord(true);
        this.taLicense.setMargin(new Insets(0, 4, 0, 4));
        this.spLicense.setViewportView(this.taLicense);
        this.taLicense.getAccessibleContext().setAccessibleName(NbBundle.getMessage(LicenseApprovalPanel.class, (String)"LicenseApprovalPanel_taLicenses_ACN"));
        this.taLicense.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(LicenseApprovalPanel.class, (String)"LicenseApprovalPanel_taLicenses_ACD"));
        this.lbPlugins.setLabelFor(this.cbPlugins);
        Mnemonics.setLocalizedText((JLabel)this.lbPlugins, (String)NbBundle.getMessage(LicenseApprovalPanel.class, (String)"LicenseApprovalPanel.lbPlugins.text"));
        this.tpTitle.setEditable(false);
        this.tpTitle.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.tpTitle.setText(NbBundle.getMessage(LicenseApprovalPanel.class, (String)"LicenseApprovalPanel_taTitle_Text"));
        this.tpTitle.setOpaque(false);
        this.tpTitle.setRequestFocusEnabled(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tpTitle, -2, 0, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.lbPlugins).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbPlugins, 0, -1, Short.MAX_VALUE)).addComponent(this.spLicense).addComponent(this.cbAccept, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.tpTitle, -2, 53, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.cbPlugins).addComponent(this.lbPlugins, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spLicense, -1, 141, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbAccept).addContainerGap()));
        this.cbAccept.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(LicenseApprovalPanel.class, (String)"LicenseApprovalPanel_cbAccept_ACN"));
    }

    private void cbAcceptActionPerformed(ActionEvent evt) {
        this.firePropertyChange(LICENSE_APPROVED, null, (Object)this.cbAccept.isSelected());
    }

    private void cbPluginsActionPerformed(ActionEvent evt) {
        this.taLicense.setText("");
        int delay = 100;
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        UpdateElement el = (UpdateElement)LicenseApprovalPanel.this.license4plugins.get(LicenseApprovalPanel.this.cbPlugins.getSelectedIndex());
                        LicenseApprovalPanel.this.taLicense.setText(el.getLicence());
                        LicenseApprovalPanel.this.taLicense.setCaretPosition(0);
                    }
                });
            }
        }, 100);
    }

    private void writeLicenses(InstallUnitWizardModel model) {
        this.goOverLicenses(model);
        ArrayList<String> pluginsModel = new ArrayList<String>();
        String fmt = NbBundle.getMessage(LicenseApprovalPanel.class, (String)"LicenseApprovalPanel_cbPlugins_ItemFormat");
        for (UpdateElement el : this.license4plugins) {
            String formatted = MessageFormat.format(fmt, el.getDisplayName(), el.getSpecificationVersion());
            pluginsModel.add(formatted);
        }
        this.cbPlugins.setModel(new DefaultComboBoxModel<Object>(pluginsModel.toArray()));
        if (!pluginsModel.isEmpty()) {
            this.cbPlugins.setSelectedIndex(0);
        }
    }
}

