/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.ActionConfiguration;
import org.gradle.api.internal.DefaultActionConfiguration;
import org.gradle.process.JavaForkOptions;
import org.gradle.process.internal.JavaForkOptionsFactory;
import org.gradle.util.GUtil;
import org.gradle.workers.ClassLoaderWorkerSpec;
import org.gradle.workers.ForkMode;
import org.gradle.workers.IsolationMode;
import org.gradle.workers.ProcessWorkerSpec;
import org.gradle.workers.WorkerConfiguration;
import org.gradle.workers.WorkerSpec;

public class DefaultWorkerConfiguration
extends DefaultActionConfiguration
implements WorkerConfiguration {
    private final ActionConfiguration actionConfiguration = new DefaultActionConfiguration();
    private final JavaForkOptions forkOptions;
    private IsolationMode isolationMode = IsolationMode.AUTO;
    private String displayName;
    private List<File> classpath = Lists.newArrayList();

    public DefaultWorkerConfiguration(JavaForkOptionsFactory forkOptionsFactory) {
        this.forkOptions = forkOptionsFactory.newJavaForkOptions();
    }

    @Override
    public IsolationMode getIsolationMode() {
        return this.isolationMode;
    }

    @Override
    public void setIsolationMode(IsolationMode isolationMode) {
        this.isolationMode = isolationMode == null ? IsolationMode.AUTO : isolationMode;
    }

    @Override
    public void forkOptions(Action<? super JavaForkOptions> forkOptionsAction) {
        forkOptionsAction.execute((Object)this.forkOptions);
    }

    @Override
    public JavaForkOptions getForkOptions() {
        return this.forkOptions;
    }

    @Override
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public Iterable<File> getClasspath() {
        return this.classpath;
    }

    @Override
    public void setClasspath(Iterable<File> classpath) {
        this.classpath = Lists.newArrayList(classpath);
    }

    @Override
    public void classpath(Iterable<File> files) {
        GUtil.addToCollection(this.classpath, (Iterable[])new Iterable[]{files});
    }

    public void params(Object ... params) {
        this.actionConfiguration.params(params);
    }

    public void setParams(Object ... params) {
        this.actionConfiguration.setParams(params);
    }

    public Object[] getParams() {
        return this.actionConfiguration.getParams();
    }

    @Override
    public ForkMode getForkMode() {
        switch (this.getIsolationMode()) {
            case AUTO: {
                return ForkMode.AUTO;
            }
            case NONE: 
            case CLASSLOADER: {
                return ForkMode.NEVER;
            }
            case PROCESS: {
                return ForkMode.ALWAYS;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public void setForkMode(ForkMode forkMode) {
        switch (forkMode) {
            case AUTO: {
                this.setIsolationMode(IsolationMode.AUTO);
                break;
            }
            case NEVER: {
                this.setIsolationMode(IsolationMode.CLASSLOADER);
                break;
            }
            case ALWAYS: {
                this.setIsolationMode(IsolationMode.PROCESS);
            }
        }
    }

    void adaptTo(WorkerSpec workerSpec) {
        if (workerSpec instanceof ClassLoaderWorkerSpec) {
            ClassLoaderWorkerSpec classLoaderWorkerSpec = (ClassLoaderWorkerSpec)workerSpec;
            classLoaderWorkerSpec.getClasspath().from(new Object[]{this.getClasspath()});
        }
        if (workerSpec instanceof ProcessWorkerSpec) {
            ProcessWorkerSpec processWorkerSpec = (ProcessWorkerSpec)workerSpec;
            processWorkerSpec.getClasspath().from(new Object[]{this.getClasspath()});
            this.getForkOptions().copyTo(processWorkerSpec.getForkOptions());
        }
    }
}

