/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.intellij.util.cls.ClsFormatException;
import com.intellij.util.containers.ContainerUtil;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SignatureParsing {
    private SignatureParsing() {
    }

    @NotNull
    public static List<Pair<String, String[]>> parseTypeParametersDeclaration(CharacterIterator signature, Function<String, String> mapping2) throws ClsFormatException {
        if (signature.current() != '<') {
            List<Pair<String, String[]>> list2 = Collections.emptyList();
            if (list2 == null) {
                SignatureParsing.$$$reportNull$$$0(0);
            }
            return list2;
        }
        ArrayList<Pair<String, String[]>> typeParameters2 = new ArrayList<Pair<String, String[]>>();
        signature.next();
        while (signature.current() != '>') {
            typeParameters2.add(SignatureParsing.parseTypeParameter(signature, mapping2));
        }
        signature.next();
        ArrayList<Pair<String, String[]>> arrayList = typeParameters2;
        if (arrayList == null) {
            SignatureParsing.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private static Pair<String, String[]> parseTypeParameter(CharacterIterator signature, Function<String, String> mapping2) throws ClsFormatException {
        StringBuilder name = new StringBuilder();
        while (signature.current() != ':' && signature.current() != '\uffff') {
            name.append(signature.current());
            signature.next();
        }
        if (signature.current() == '\uffff') {
            throw new ClsFormatException();
        }
        String parameterName = mapping2.fun(name.toString());
        List bounds = null;
        boolean jlo = false;
        while (signature.current() == ':') {
            signature.next();
            String bound = SignatureParsing.parseTopLevelClassRefSignature(signature, mapping2);
            if (bound == null) continue;
            if (bounds == null) {
                if ("java.lang.Object".equals(bound)) {
                    jlo = true;
                    continue;
                }
                bounds = ContainerUtil.newSmartList();
                if (jlo) {
                    bounds.add("java.lang.Object");
                }
            }
            bounds.add(bound);
        }
        return Pair.pair(parameterName, ArrayUtilRt.toStringArray(bounds));
    }

    @Nullable
    public static String parseTopLevelClassRefSignature(CharacterIterator signature, Function<String, String> mapping2) throws ClsFormatException {
        switch (signature.current()) {
            case 'L': {
                return SignatureParsing.parseParameterizedClassRefSignature(signature, mapping2);
            }
            case 'T': {
                return SignatureParsing.parseTypeVariableRefSignature(signature);
            }
        }
        return null;
    }

    private static String parseTypeVariableRefSignature(CharacterIterator signature) throws ClsFormatException {
        StringBuilder id = new StringBuilder();
        signature.next();
        while (signature.current() != ';' && signature.current() != '>' && signature.current() != '\uffff') {
            id.append(signature.current());
            signature.next();
        }
        if (signature.current() == '\uffff') {
            throw new ClsFormatException();
        }
        if (signature.current() == ';') {
            signature.next();
        }
        return id.toString();
    }

    private static String parseParameterizedClassRefSignature(CharacterIterator signature, Function<String, String> mapping2) throws ClsFormatException {
        StringBuilder canonicalText = new StringBuilder();
        boolean mapped = false;
        signature.next();
        while (signature.current() != ';' && signature.current() != '\uffff') {
            char c = signature.current();
            if (c == '<') {
                canonicalText = new StringBuilder(mapping2.fun(canonicalText.toString()));
                mapped = true;
                boolean firstArg = true;
                signature.next();
                do {
                    canonicalText.append(firstArg ? (char)'<' : ',').append(SignatureParsing.parseClassOrTypeVariableElement(signature, mapping2));
                    firstArg = false;
                } while (signature.current() != '>');
                canonicalText.append('>');
            } else if (c != ' ') {
                canonicalText.append(c);
            }
            signature.next();
        }
        if (signature.current() == '\uffff') {
            throw new ClsFormatException();
        }
        signature.next();
        String text2 = canonicalText.toString();
        if (!mapped) {
            text2 = mapping2.fun(text2);
        }
        return text2;
    }

    private static String parseClassOrTypeVariableElement(CharacterIterator signature, Function<String, String> mapping2) throws ClsFormatException {
        char variance = SignatureParsing.parseVariance(signature);
        if (variance == '*') {
            return SignatureParsing.decorateTypeText(null, variance);
        }
        int dimensions = SignatureParsing.parseDimensions(signature);
        String text2 = SignatureParsing.parseTypeWithoutVariance(signature, mapping2);
        if (text2 == null) {
            throw new ClsFormatException();
        }
        if (dimensions > 0) {
            text2 = text2 + StringUtil.repeat("[]", dimensions);
        }
        return SignatureParsing.decorateTypeText(text2, variance);
    }

    private static String decorateTypeText(String canonical, char variance) {
        switch (variance) {
            case '\u0000': {
                return canonical;
            }
            case '+': {
                return "? extends " + canonical;
            }
            case '-': {
                return "? super " + canonical;
            }
            case '*': {
                return "?";
            }
        }
        assert (false) : "unknown variance";
        return null;
    }

    private static char parseVariance(CharacterIterator signature) {
        char variance;
        switch (signature.current()) {
            case '*': 
            case '+': 
            case '-': {
                variance = signature.current();
                signature.next();
                break;
            }
            case '.': 
            case '=': {
                signature.next();
            }
            default: {
                variance = '\u0000';
            }
        }
        return variance;
    }

    private static int parseDimensions(CharacterIterator signature) {
        int dimensions = 0;
        while (signature.current() == '[') {
            ++dimensions;
            signature.next();
        }
        return dimensions;
    }

    @NotNull
    public static String parseTypeString(CharacterIterator signature, Function<String, String> mapping2) throws ClsFormatException {
        int dimensions = SignatureParsing.parseDimensions(signature);
        String text2 = SignatureParsing.parseTypeWithoutVariance(signature, mapping2);
        if (text2 == null) {
            throw new ClsFormatException();
        }
        if (dimensions > 0) {
            text2 = text2 + StringUtil.repeat("[]", dimensions);
        }
        String string2 = text2;
        if (string2 == null) {
            SignatureParsing.$$$reportNull$$$0(2);
        }
        return string2;
    }

    @Nullable
    private static String parseTypeWithoutVariance(CharacterIterator signature, Function<String, String> mapping2) throws ClsFormatException {
        String text2 = null;
        switch (signature.current()) {
            case 'L': {
                text2 = SignatureParsing.parseParameterizedClassRefSignature(signature, mapping2);
                break;
            }
            case 'T': {
                text2 = SignatureParsing.parseTypeVariableRefSignature(signature);
                break;
            }
            case 'B': {
                text2 = "byte";
                signature.next();
                break;
            }
            case 'C': {
                text2 = "char";
                signature.next();
                break;
            }
            case 'D': {
                text2 = "double";
                signature.next();
                break;
            }
            case 'F': {
                text2 = "float";
                signature.next();
                break;
            }
            case 'I': {
                text2 = "int";
                signature.next();
                break;
            }
            case 'J': {
                text2 = "long";
                signature.next();
                break;
            }
            case 'S': {
                text2 = "short";
                signature.next();
                break;
            }
            case 'Z': {
                text2 = "boolean";
                signature.next();
                break;
            }
            case 'V': {
                text2 = "void";
                signature.next();
            }
        }
        return text2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/psi/impl/compiled/SignatureParsing";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "parseTypeParametersDeclaration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parseTypeString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

