/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.undo;

import tim.prune.I18nManager;
import tim.prune.data.AudioClip;
import tim.prune.data.DataPoint;
import tim.prune.data.MediaObject;
import tim.prune.data.TrackInfo;
import tim.prune.undo.UndoException;
import tim.prune.undo.UndoOperation;

public class UndoCorrelateAudios
implements UndoOperation {
    private DataPoint[] _contents = null;
    private DataPoint[] _audioPoints = null;
    private int _numCorrelated = -1;

    public UndoCorrelateAudios(TrackInfo trackInfo) {
        this._contents = trackInfo.getTrack().cloneContents();
        int n = trackInfo.getAudioList().getNumAudios();
        this._audioPoints = new DataPoint[n];
        int n2 = 0;
        while (n2 < n) {
            this._audioPoints[n2] = trackInfo.getAudioList().getAudio(n2).getDataPoint();
            ++n2;
        }
    }

    public void setNumAudiosCorrelated(int n) {
        this._numCorrelated = n;
    }

    public String getDescription() {
        return String.valueOf(I18nManager.getText("undo.correlateaudios")) + " (" + this._numCorrelated + ")";
    }

    public void performUndo(TrackInfo trackInfo) throws UndoException {
        trackInfo.getTrack().replaceContents(this._contents);
        int n = 0;
        while (n < this._audioPoints.length) {
            AudioClip audioClip = trackInfo.getAudioList().getAudio(n);
            if (audioClip.getCurrentStatus() == MediaObject.Status.CONNECTED) {
                DataPoint dataPoint = this._audioPoints[n];
                DataPoint dataPoint2 = audioClip.getDataPoint();
                audioClip.setDataPoint(dataPoint);
                if (dataPoint2 != null) {
                    dataPoint2.setAudio(null);
                }
                if (dataPoint != null) {
                    dataPoint.setAudio(audioClip);
                }
            }
            ++n;
        }
        trackInfo.getSelection().clearAll();
    }
}

