/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.internal;

import net.rubygrapefruit.platform.NativeException;
import net.rubygrapefruit.platform.internal.AbstractTerminal;
import net.rubygrapefruit.platform.internal.AbstractTerminals;
import net.rubygrapefruit.platform.internal.AnsiTerminal;
import net.rubygrapefruit.platform.internal.FunctionResult;
import net.rubygrapefruit.platform.internal.WindowsTerminal;
import net.rubygrapefruit.platform.internal.WindowsTerminalInput;
import net.rubygrapefruit.platform.internal.jni.NativeLibraryFunctions;
import net.rubygrapefruit.platform.internal.jni.WindowsConsoleFunctions;
import net.rubygrapefruit.platform.terminal.TerminalInput;
import net.rubygrapefruit.platform.terminal.Terminals;

public class WindowsTerminals
extends AbstractTerminals {
    public boolean isTerminal(Terminals.Output output) {
        int console = this.getTypeForOutput(output);
        return console != 0;
    }

    public boolean isTerminalInput() throws NativeException {
        return this.getTypeForInput() == 1;
    }

    protected TerminalInput createInput() {
        return new WindowsTerminalInput();
    }

    protected AbstractTerminal createTerminal(Terminals.Output output) {
        if (this.getTypeForOutput(output) == 2) {
            return new AnsiTerminal(output);
        }
        return new WindowsTerminal(output);
    }

    private int getTypeForInput() {
        FunctionResult result2 = new FunctionResult();
        int console = WindowsConsoleFunctions.isConsole(NativeLibraryFunctions.STDIN, result2);
        if (result2.isFailed()) {
            throw new NativeException(String.format("Could not determine if stdin is a console: %s", result2.getMessage()));
        }
        return console;
    }

    private int getTypeForOutput(Terminals.Output output) {
        int ordinal = output == Terminals.Output.Stdout ? NativeLibraryFunctions.STDOUT : NativeLibraryFunctions.STDERR;
        FunctionResult result2 = new FunctionResult();
        int console = WindowsConsoleFunctions.isConsole(ordinal, result2);
        if (result2.isFailed()) {
            throw new NativeException(String.format("Could not determine if %s is a console: %s", new Object[]{output, result2.getMessage()}));
        }
        return console;
    }
}

