<?php
/**
 * Aliases for OATHAuth's special pages
 *
 * @file
 * @ingroup Extensions
 */

$specialPageAliases = [];

/** English (English) */
$specialPageAliases['en'] = [
	'OATH' => [ 'Two-factor authentication', 'OATH', 'OATHAuth' ],
	'DisableOATHForUser' => [ 'DisableOATHForUser' ],
];

/** Arabic (العربية) */
$specialPageAliases['ar'] = [
	'OATH' => [ 'أواث', 'أواث_أوث' ],
];

/** Egyptian Arabic (مصرى) */
$specialPageAliases['arz'] = [
	'OATH' => [ 'اواث', 'اواث_اوث' ],
];

/** Czech (čeština) */
$specialPageAliases['cs'] = [
	'OATH' => [ 'Dvoufaktorové_ověření' ],
];

/** Northern Luri (لۊری شومالی) */
$specialPageAliases['lrc'] = [
	'OATH' => [ 'قأسأم' ],
];

/** Serbian Cyrillic (српски (ћирилица)) */
$specialPageAliases['sr-ec'] = [
	'OATH' => [ 'Двофакторска_потврда_идентитета' ],
];

/** Serbian Latin (srpski (latinica)) */
$specialPageAliases['sr-el'] = [
	'OATH' => [ 'Dvofaktorska_potvrda_identiteta' ],
];

/** Urdu (اردو) */
$specialPageAliases['ur'] = [
	'OATH' => [ 'حلف_نامہ' ],
];

/** Simplified Chinese (中文（简体）‎) */
$specialPageAliases['zh-hans'] = [
	'OATH' => [ 'OATH验证' ],
];

/** Traditional Chinese (中文（繁體）‎) */
$specialPageAliases['zh-hant'] = [
	'OATH' => [ 'OATH_認證' ],
];
