/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim;

import java.util.List;
import net.sourceforge.plantuml.DefinitionsContainer;
import net.sourceforge.plantuml.StringLocated;
import net.sourceforge.plantuml.preproc.Defines;
import net.sourceforge.plantuml.preproc.ImportedFiles;
import net.sourceforge.plantuml.tim.EaterException;
import net.sourceforge.plantuml.tim.TContext;
import net.sourceforge.plantuml.tim.TLineType;
import net.sourceforge.plantuml.tim.TMemory;
import net.sourceforge.plantuml.tim.TMemoryGlobal;

public class TimLoader {
    private final TContext context;
    private final TMemory global = new TMemoryGlobal();
    private boolean preprocessorError;
    private List<StringLocated> resultList;

    public TimLoader(ImportedFiles importedFiles, Defines defines, String charset, DefinitionsContainer definitionsContainer) {
        this.context = new TContext(importedFiles, defines, charset, definitionsContainer);
    }

    public void load(List<StringLocated> input) {
        for (StringLocated s : input) {
            TLineType type = TLineType.getFromLine(s.getTrimmed().getString());
            try {
                this.context.executeOneLine(this.global, type, s, null);
            }
            catch (EaterException e) {
                this.context.getResultList().add(s.withErrorPreprocessor(e.getMessage()));
                this.resultList = this.context.getResultList();
                this.changeLastLine(this.context.getDebug(), e.getMessage());
                this.preprocessorError = true;
                return;
            }
        }
        this.resultList = this.context.getResultList();
    }

    private void changeLastLine(List<StringLocated> list, String message) {
        int num = list.size() - 1;
        StringLocated last = list.get(num);
        list.set(num, last.withErrorPreprocessor(message));
    }

    public final List<StringLocated> getResultList() {
        return this.resultList;
    }

    public final List<StringLocated> getDebug() {
        return this.context.getDebug();
    }

    public final boolean isPreprocessorError() {
        return this.preprocessorError;
    }
}

