/*
 * Decompiled with CFR 0.152.
 */
package java.nio.file;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.file.AccessMode;
import java.nio.file.CopyMoveHelper;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileTreeWalker;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.TempFileHelper;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.spi.FileSystemProvider;
import java.nio.file.spi.FileTypeDetector;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import sun.nio.fs.DefaultFileTypeDetector;

public final class Files {
    private static final int BUFFER_SIZE = 8192;
    private static final int MAX_BUFFER_SIZE = 0x7FFFFFF7;

    private Files() {
    }

    private static FileSystemProvider provider(Path path) {
        return path.getFileSystem().provider();
    }

    public static InputStream newInputStream(Path path, OpenOption ... options) throws IOException {
        return Files.provider(path).newInputStream(path, options);
    }

    public static OutputStream newOutputStream(Path path, OpenOption ... options) throws IOException {
        return Files.provider(path).newOutputStream(path, options);
    }

    public static SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        return Files.provider(path).newByteChannel(path, options, attrs);
    }

    public static SeekableByteChannel newByteChannel(Path path, OpenOption ... options) throws IOException {
        HashSet set = new HashSet(options.length);
        Collections.addAll(set, options);
        return Files.newByteChannel(path, set, new FileAttribute[0]);
    }

    public static DirectoryStream<Path> newDirectoryStream(Path dir) throws IOException {
        return Files.provider(dir).newDirectoryStream(dir, AcceptAllFilter.FILTER);
    }

    public static DirectoryStream<Path> newDirectoryStream(Path dir, String glob) throws IOException {
        if (glob.equals("*")) {
            return Files.newDirectoryStream(dir);
        }
        FileSystem fs = dir.getFileSystem();
        final PathMatcher matcher = fs.getPathMatcher("glob:" + glob);
        DirectoryStream.Filter<Path> filter = new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path entry) {
                return matcher.matches(entry.getFileName());
            }
        };
        return fs.provider().newDirectoryStream(dir, (DirectoryStream.Filter<? super Path>)filter);
    }

    public static DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        return Files.provider(dir).newDirectoryStream(dir, filter);
    }

    public static Path createFile(Path path, FileAttribute<?> ... attrs) throws IOException {
        EnumSet<StandardOpenOption> options = EnumSet.of(StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
        Files.newByteChannel(path, options, attrs).close();
        return path;
    }

    public static Path createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        Files.provider(dir).createDirectory(dir, attrs);
        return dir;
    }

    public static Path createDirectories(Path dir, FileAttribute<?> ... attrs) throws IOException {
        try {
            Files.createAndCheckIsDirectory(dir, attrs);
            return dir;
        }
        catch (FileAlreadyExistsException x) {
            throw x;
        }
        catch (IOException x) {
            Path parent;
            SecurityException se = null;
            try {
                dir = dir.toAbsolutePath();
            }
            catch (SecurityException x2) {
                se = x2;
            }
            for (parent = dir.getParent(); parent != null; parent = parent.getParent()) {
                try {
                    Files.provider(parent).checkAccess(parent, new AccessMode[0]);
                    break;
                }
                catch (NoSuchFileException noSuchFileException) {
                    continue;
                }
            }
            if (parent == null) {
                if (se != null) {
                    throw se;
                }
                throw new IOException("Root directory does not exist");
            }
            Path child = parent;
            for (Path name : parent.relativize(dir)) {
                child = child.resolve(name);
                Files.createAndCheckIsDirectory(child, attrs);
            }
            return dir;
        }
    }

    private static void createAndCheckIsDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        block2: {
            try {
                Files.createDirectory(dir, attrs);
            }
            catch (FileAlreadyExistsException x) {
                if (Files.isDirectory(dir, LinkOption.NOFOLLOW_LINKS)) break block2;
                throw x;
            }
        }
    }

    public static Path createTempFile(Path dir, String prefix, String suffix, FileAttribute<?> ... attrs) throws IOException {
        return TempFileHelper.createTempFile(Objects.requireNonNull(dir), prefix, suffix, attrs);
    }

    public static Path createTempFile(String prefix, String suffix, FileAttribute<?> ... attrs) throws IOException {
        return TempFileHelper.createTempFile(null, prefix, suffix, attrs);
    }

    public static Path createTempDirectory(Path dir, String prefix, FileAttribute<?> ... attrs) throws IOException {
        return TempFileHelper.createTempDirectory(Objects.requireNonNull(dir), prefix, attrs);
    }

    public static Path createTempDirectory(String prefix, FileAttribute<?> ... attrs) throws IOException {
        return TempFileHelper.createTempDirectory(null, prefix, attrs);
    }

    public static Path createSymbolicLink(Path link, Path target, FileAttribute<?> ... attrs) throws IOException {
        Files.provider(link).createSymbolicLink(link, target, attrs);
        return link;
    }

    public static Path createLink(Path link, Path existing) throws IOException {
        Files.provider(link).createLink(link, existing);
        return link;
    }

    public static void delete(Path path) throws IOException {
        Files.provider(path).delete(path);
    }

    public static boolean deleteIfExists(Path path) throws IOException {
        return Files.provider(path).deleteIfExists(path);
    }

    public static Path copy(Path source, Path target, CopyOption ... options) throws IOException {
        FileSystemProvider provider = Files.provider(source);
        if (Files.provider(target) == provider) {
            provider.copy(source, target, options);
        } else {
            CopyMoveHelper.copyToForeignTarget(source, target, options);
        }
        return target;
    }

    public static Path move(Path source, Path target, CopyOption ... options) throws IOException {
        FileSystemProvider provider = Files.provider(source);
        if (Files.provider(target) == provider) {
            provider.move(source, target, options);
        } else {
            CopyMoveHelper.moveToForeignTarget(source, target, options);
        }
        return target;
    }

    public static Path readSymbolicLink(Path link) throws IOException {
        return Files.provider(link).readSymbolicLink(link);
    }

    public static FileStore getFileStore(Path path) throws IOException {
        return Files.provider(path).getFileStore(path);
    }

    public static boolean isSameFile(Path path, Path path2) throws IOException {
        return Files.provider(path).isSameFile(path, path2);
    }

    public static boolean isHidden(Path path) throws IOException {
        return Files.provider(path).isHidden(path);
    }

    public static String probeContentType(Path path) throws IOException {
        for (FileTypeDetector detector : FileTypeDetectors.installeDetectors) {
            String result = detector.probeContentType(path);
            if (result == null) continue;
            return result;
        }
        return FileTypeDetectors.defaultFileTypeDetector.probeContentType(path);
    }

    public static <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        return Files.provider(path).getFileAttributeView(path, type, options);
    }

    public static <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
        return Files.provider(path).readAttributes(path, type, options);
    }

    public static Path setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
        Files.provider(path).setAttribute(path, attribute, value, options);
        return path;
    }

    public static Object getAttribute(Path path, String attribute, LinkOption ... options) throws IOException {
        if (attribute.indexOf(42) >= 0 || attribute.indexOf(44) >= 0) {
            throw new IllegalArgumentException(attribute);
        }
        Map<String, Object> map = Files.readAttributes(path, attribute, options);
        assert (map.size() == 1);
        int pos = attribute.indexOf(58);
        String name = pos == -1 ? attribute : (pos == attribute.length() ? "" : attribute.substring(pos + 1));
        return map.get(name);
    }

    public static Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        return Files.provider(path).readAttributes(path, attributes, options);
    }

    public static Set<PosixFilePermission> getPosixFilePermissions(Path path, LinkOption ... options) throws IOException {
        return Files.readAttributes(path, PosixFileAttributes.class, options).permissions();
    }

    public static Path setPosixFilePermissions(Path path, Set<PosixFilePermission> perms) throws IOException {
        PosixFileAttributeView view = Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0]);
        if (view == null) {
            throw new UnsupportedOperationException();
        }
        view.setPermissions(perms);
        return path;
    }

    public static UserPrincipal getOwner(Path path, LinkOption ... options) throws IOException {
        FileOwnerAttributeView view = Files.getFileAttributeView(path, FileOwnerAttributeView.class, options);
        if (view == null) {
            throw new UnsupportedOperationException();
        }
        return view.getOwner();
    }

    public static Path setOwner(Path path, UserPrincipal owner) throws IOException {
        FileOwnerAttributeView view = Files.getFileAttributeView(path, FileOwnerAttributeView.class, new LinkOption[0]);
        if (view == null) {
            throw new UnsupportedOperationException();
        }
        view.setOwner(owner);
        return path;
    }

    public static boolean isSymbolicLink(Path path) {
        try {
            return Files.readAttributes(path, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS).isSymbolicLink();
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public static boolean isDirectory(Path path, LinkOption ... options) {
        try {
            return Files.readAttributes(path, BasicFileAttributes.class, options).isDirectory();
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public static boolean isRegularFile(Path path, LinkOption ... options) {
        try {
            return Files.readAttributes(path, BasicFileAttributes.class, options).isRegularFile();
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public static FileTime getLastModifiedTime(Path path, LinkOption ... options) throws IOException {
        return Files.readAttributes(path, BasicFileAttributes.class, options).lastModifiedTime();
    }

    public static Path setLastModifiedTime(Path path, FileTime time) throws IOException {
        Files.getFileAttributeView(path, BasicFileAttributeView.class, new LinkOption[0]).setTimes(time, null, null);
        return path;
    }

    public static long size(Path path) throws IOException {
        return Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]).size();
    }

    private static boolean followLinks(LinkOption ... options) {
        boolean followLinks = true;
        for (LinkOption opt : options) {
            if (opt != LinkOption.NOFOLLOW_LINKS) {
                if (opt == null) {
                    throw new NullPointerException();
                }
                throw new AssertionError((Object)"Should not get here");
            }
            followLinks = false;
        }
        return followLinks;
    }

    public static boolean exists(Path path, LinkOption ... options) {
        try {
            if (Files.followLinks(options)) {
                Files.provider(path).checkAccess(path, new AccessMode[0]);
            } else {
                Files.readAttributes(path, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
            }
            return true;
        }
        catch (IOException x) {
            return false;
        }
    }

    public static boolean notExists(Path path, LinkOption ... options) {
        try {
            if (Files.followLinks(options)) {
                Files.provider(path).checkAccess(path, new AccessMode[0]);
            } else {
                Files.readAttributes(path, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
            }
            return false;
        }
        catch (NoSuchFileException x) {
            return true;
        }
        catch (IOException x) {
            return false;
        }
    }

    private static boolean isAccessible(Path path, AccessMode ... modes) {
        try {
            Files.provider(path).checkAccess(path, modes);
            return true;
        }
        catch (IOException x) {
            return false;
        }
    }

    public static boolean isReadable(Path path) {
        return Files.isAccessible(path, AccessMode.READ);
    }

    public static boolean isWritable(Path path) {
        return Files.isAccessible(path, AccessMode.WRITE);
    }

    public static boolean isExecutable(Path path) {
        return Files.isAccessible(path, AccessMode.EXECUTE);
    }

    public static Path walkFileTree(Path start, Set<FileVisitOption> options, int maxDepth, FileVisitor<? super Path> visitor) throws IOException {
        if (maxDepth < 0) {
            throw new IllegalArgumentException("'maxDepth' is negative");
        }
        try (FileTreeWalker walker = new FileTreeWalker(options, maxDepth);){
            FileTreeWalker.Event ev = walker.walk(start);
            do {
                FileVisitResult result;
                switch (ev.type()) {
                    case ENTRY: {
                        IOException ioe = ev.ioeException();
                        if (ioe == null) {
                            assert (ev.attributes() != null);
                            result = visitor.visitFile(ev.file(), ev.attributes());
                            break;
                        }
                        result = visitor.visitFileFailed(ev.file(), ioe);
                        break;
                    }
                    case START_DIRECTORY: {
                        result = visitor.preVisitDirectory(ev.file(), ev.attributes());
                        if (result != FileVisitResult.SKIP_SUBTREE && result != FileVisitResult.SKIP_SIBLINGS) break;
                        walker.pop();
                        break;
                    }
                    case END_DIRECTORY: {
                        result = visitor.postVisitDirectory(ev.file(), ev.ioeException());
                        if (result != FileVisitResult.SKIP_SIBLINGS) break;
                        result = FileVisitResult.CONTINUE;
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)"Should not get here");
                    }
                }
                if (Objects.requireNonNull(result) == FileVisitResult.CONTINUE) continue;
                if (result == FileVisitResult.TERMINATE) {
                    break;
                }
                if (result != FileVisitResult.SKIP_SIBLINGS) continue;
                walker.skipRemainingSiblings();
            } while ((ev = walker.next()) != null);
        }
        return start;
    }

    public static Path walkFileTree(Path start, FileVisitor<? super Path> visitor) throws IOException {
        return Files.walkFileTree(start, EnumSet.noneOf(FileVisitOption.class), Integer.MAX_VALUE, visitor);
    }

    public static BufferedReader newBufferedReader(Path path, Charset cs) throws IOException {
        CharsetDecoder decoder = cs.newDecoder();
        InputStreamReader reader = new InputStreamReader(Files.newInputStream(path, new OpenOption[0]), decoder);
        return new BufferedReader(reader);
    }

    public static BufferedWriter newBufferedWriter(Path path, Charset cs, OpenOption ... options) throws IOException {
        CharsetEncoder encoder = cs.newEncoder();
        OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(path, options), encoder);
        return new BufferedWriter(writer);
    }

    private static long copy(InputStream source, OutputStream sink) throws IOException {
        int n;
        long nread = 0L;
        byte[] buf = new byte[8192];
        while ((n = source.read(buf)) > 0) {
            sink.write(buf, 0, n);
            nread += (long)n;
        }
        return nread;
    }

    public static long copy(InputStream in, Path target, CopyOption ... options) throws IOException {
        OutputStream ostream;
        Objects.requireNonNull(in);
        boolean replaceExisting = false;
        for (CopyOption opt : options) {
            if (opt != StandardCopyOption.REPLACE_EXISTING) {
                if (opt == null) {
                    throw new NullPointerException("options contains 'null'");
                }
                throw new UnsupportedOperationException(opt + " not supported");
            }
            replaceExisting = true;
        }
        SecurityException se = null;
        if (replaceExisting) {
            try {
                Files.deleteIfExists(target);
            }
            catch (SecurityException x) {
                se = x;
            }
        }
        try {
            ostream = Files.newOutputStream(target, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
        }
        catch (FileAlreadyExistsException x) {
            if (se != null) {
                throw se;
            }
            throw x;
        }
        try (OutputStream out = ostream;){
            long l = Files.copy(in, out);
            return l;
        }
    }

    public static long copy(Path source, OutputStream out) throws IOException {
        Objects.requireNonNull(out);
        try (InputStream in = Files.newInputStream(source, new OpenOption[0]);){
            long l = Files.copy(in, out);
            return l;
        }
    }

    private static byte[] read(InputStream source, int initialSize) throws IOException {
        int capacity = initialSize;
        byte[] buf = new byte[capacity];
        int nread = 0;
        while (true) {
            int n;
            if ((n = source.read(buf, nread, capacity - nread)) > 0) {
                nread += n;
                continue;
            }
            if (n < 0 || (n = source.read()) < 0) break;
            if (capacity <= 0x7FFFFFF7 - capacity) {
                capacity = Math.max(capacity << 1, 8192);
            } else {
                if (capacity == 0x7FFFFFF7) {
                    throw new OutOfMemoryError("Required array size too large");
                }
                capacity = 0x7FFFFFF7;
            }
            buf = Arrays.copyOf(buf, capacity);
            buf[nread++] = (byte)n;
        }
        return capacity == nread ? buf : Arrays.copyOf(buf, nread);
    }

    /*
     * Exception decompiling
     */
    public static byte[] readAllBytes(Path path) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static List<String> readAllLines(Path path, Charset cs) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(path, cs);){
            String line;
            ArrayList<String> result = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                result.add(line);
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
    }

    public static Path write(Path path, byte[] bytes, OpenOption ... options) throws IOException {
        Objects.requireNonNull(bytes);
        try (OutputStream out = Files.newOutputStream(path, options);){
            int len;
            int n;
            for (int rem = len = bytes.length; rem > 0; rem -= n) {
                n = Math.min(rem, 8192);
                out.write(bytes, len - rem, n);
            }
        }
        return path;
    }

    public static Path write(Path path, Iterable<? extends CharSequence> lines, Charset cs, OpenOption ... options) throws IOException {
        Objects.requireNonNull(lines);
        CharsetEncoder encoder = cs.newEncoder();
        OutputStream out = Files.newOutputStream(path, options);
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, encoder));){
            for (CharSequence charSequence : lines) {
                writer.append(charSequence);
                writer.newLine();
            }
        }
        return path;
    }

    private static class FileTypeDetectors {
        static final FileTypeDetector defaultFileTypeDetector = FileTypeDetectors.createDefaultFileTypeDetector();
        static final List<FileTypeDetector> installeDetectors = FileTypeDetectors.loadInstalledDetectors();

        private FileTypeDetectors() {
        }

        private static FileTypeDetector createDefaultFileTypeDetector() {
            return AccessController.doPrivileged(new PrivilegedAction<FileTypeDetector>(){

                @Override
                public FileTypeDetector run() {
                    return DefaultFileTypeDetector.create();
                }
            });
        }

        private static List<FileTypeDetector> loadInstalledDetectors() {
            return AccessController.doPrivileged(new PrivilegedAction<List<FileTypeDetector>>(){

                @Override
                public List<FileTypeDetector> run() {
                    ArrayList<FileTypeDetector> list = new ArrayList<FileTypeDetector>();
                    ServiceLoader<FileTypeDetector> loader = ServiceLoader.load(FileTypeDetector.class, ClassLoader.getSystemClassLoader());
                    for (FileTypeDetector detector : loader) {
                        list.add(detector);
                    }
                    return list;
                }
            });
        }
    }

    private static class AcceptAllFilter
    implements DirectoryStream.Filter<Path> {
        static final AcceptAllFilter FILTER = new AcceptAllFilter();

        private AcceptAllFilter() {
        }

        @Override
        public boolean accept(Path entry) {
            return true;
        }
    }
}

