/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.SunJCE;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.Security;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SealedObject;
import sun.misc.ObjectInputFilter;
import sun.misc.SharedSecrets;

final class SealedObjectForKeyProtector
extends SealedObject {
    static final long serialVersionUID = -3650226485480866989L;
    private static final String KEY_SERIAL_FILTER = "jceks.key.serialFilter";

    SealedObjectForKeyProtector(Serializable object, Cipher c) throws IOException, IllegalBlockSizeException {
        super(object, c);
    }

    SealedObjectForKeyProtector(SealedObject so) {
        super(so);
    }

    AlgorithmParameters getParameters() {
        AlgorithmParameters params = null;
        if (this.encodedParams != null) {
            try {
                params = AlgorithmParameters.getInstance("PBE", SunJCE.getInstance());
                params.init(this.encodedParams);
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new RuntimeException("SunJCE provider is not configured properly");
            }
            catch (IOException io) {
                throw new RuntimeException("Parameter failure: " + io.getMessage());
            }
        }
        return params;
    }

    final Key getKey(Cipher c) throws IOException, ClassNotFoundException, IllegalBlockSizeException, BadPaddingException {
        Throwable throwable = null;
        try (final ObjectInputStream ois = SharedSecrets.getJavaxCryptoSealedObjectAccess().getExtObjectInputStream((SealedObject)this, c);){
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    ObjectInputFilter.Config.setObjectInputFilter((ObjectInputStream)ois, (ObjectInputFilter)DeserializationChecker.ONE_FILTER);
                    return null;
                }
            });
            try {
                Key t;
                Key key = t = (Key)ois.readObject();
                return key;
            }
            catch (InvalidClassException ice) {
                try {
                    String msg = ice.getMessage();
                    if (msg.contains("REJECTED")) {
                        throw new IOException("Rejected by the jceks.key.serialFilter or jdk.serialFilter property", ice);
                    }
                    throw ice;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    private static class DeserializationChecker
    implements ObjectInputFilter {
        private static final ObjectInputFilter ONE_FILTER;
        private final ObjectInputFilter base;

        private DeserializationChecker(ObjectInputFilter base) {
            this.base = base;
        }

        public ObjectInputFilter.Status checkInput(ObjectInputFilter.FilterInfo info) {
            ObjectInputFilter.Status result;
            if (info.serialClass() == Object.class) {
                return ObjectInputFilter.Status.UNDECIDED;
            }
            if (this.base != null && (result = this.base.checkInput(info)) != ObjectInputFilter.Status.UNDECIDED) {
                return result;
            }
            ObjectInputFilter defaultFilter = ObjectInputFilter.Config.getSerialFilter();
            if (defaultFilter != null) {
                return defaultFilter.checkInput(info);
            }
            return ObjectInputFilter.Status.UNDECIDED;
        }

        static {
            String prop = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    String tmp = System.getProperty(SealedObjectForKeyProtector.KEY_SERIAL_FILTER);
                    if (tmp != null) {
                        return tmp;
                    }
                    return Security.getProperty(SealedObjectForKeyProtector.KEY_SERIAL_FILTER);
                }
            });
            ONE_FILTER = new DeserializationChecker(prop == null ? null : ObjectInputFilter.Config.createFilter((String)prop));
        }
    }
}

