<?php
// @codingStandardsIgnoreFile
/**
 * @file
 * A database agnostic dump for testing purposes.
 *
 * This file was generated by the Drupal 8.0 db-tools.php script.
 */

use Drupal\Core\Database\Database;

$connection = Database::getConnection();

$connection->schema()->createTable('access', array(
  'fields' => array(
    'aid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'mask' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'aid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('accesslog', array(
  'fields' => array(
    'aid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'sid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'title' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
    'path' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
    'url' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'hostname' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '128',
    ),
    'uid' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'timer' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'aid',
  ),
  'indexes' => array(
    'accesslog_timestamp' => array(
      'timestamp',
    ),
    'uid' => array(
      'uid',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('actions', array(
  'fields' => array(
    'aid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '0',
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'callback' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'parameters' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'description' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'aid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('actions')
->fields(array(
  'aid',
  'type',
  'callback',
  'parameters',
  'description',
))
->values(array(
  'aid' => '1',
  'type' => 'comment',
  'callback' => 'comment_unpublish_by_keyword_action',
  'parameters' => 'a:1:{s:8:"keywords";a:1:{i:0;s:6:"drupal";}}',
  'description' => 'Unpublish comment containing keyword(s)',
))
->values(array(
  'aid' => '2',
  'type' => 'node',
  'callback' => 'node_assign_owner_action',
  'parameters' => 'a:1:{s:9:"owner_uid";s:1:"2";}',
  'description' => 'Change the author of a post',
))
->values(array(
  'aid' => '3',
  'type' => 'node',
  'callback' => 'node_unpublish_by_keyword_action',
  'parameters' => 'a:1:{s:8:"keywords";a:1:{i:0;s:6:"drupal";}}',
  'description' => 'Unpublish post containing keyword(s)',
))
->values(array(
  'aid' => '4',
  'type' => 'system',
  'callback' => 'system_message_action',
  'parameters' => 'a:1:{s:7:"message";s:21:"Drupal migration test";}',
  'description' => 'Display a message to the user',
))
->values(array(
  'aid' => '5',
  'type' => 'system',
  'callback' => 'system_send_email_action',
  'parameters' => 'a:3:{s:9:"recipient";s:16:"test@example.com";s:7:"subject";s:21:"Drupal migration test";s:7:"message";s:21:"Drupal migration test";}',
  'description' => 'Send e-mail',
))
->values(array(
  'aid' => '6',
  'type' => 'system',
  'callback' => 'system_goto_action',
  'parameters' => 'a:1:{s:3:"url";s:22:"https://www.drupal.org";}',
  'description' => 'Redirect to URL',
))
->values(array(
  'aid' => 'comment_publish_action',
  'type' => 'comment',
  'callback' => 'comment_publish_action',
  'parameters' => '',
  'description' => 'Publish comment',
))
->values(array(
  'aid' => 'comment_unpublish_action',
  'type' => 'comment',
  'callback' => 'comment_unpublish_action',
  'parameters' => '',
  'description' => 'Unpublish comment',
))
->values(array(
  'aid' => 'imagecache_flush_action',
  'type' => 'node',
  'callback' => 'imagecache_flush_action',
  'parameters' => '',
  'description' => "ImageCache: Flush ALL presets for this node's filefield images",
))
->values(array(
  'aid' => 'imagecache_generate_all_action',
  'type' => 'node',
  'callback' => 'imagecache_generate_all_action',
  'parameters' => '',
  'description' => "ImageCache: Generate ALL presets for this node's filefield images",
))
->values(array(
  'aid' => 'node_make_sticky_action',
  'type' => 'node',
  'callback' => 'node_make_sticky_action',
  'parameters' => '',
  'description' => 'Make post sticky',
))
->values(array(
  'aid' => 'node_make_unsticky_action',
  'type' => 'node',
  'callback' => 'node_make_unsticky_action',
  'parameters' => '',
  'description' => 'Make post unsticky',
))
->values(array(
  'aid' => 'node_promote_action',
  'type' => 'node',
  'callback' => 'node_promote_action',
  'parameters' => '',
  'description' => 'Promote post to front page',
))
->values(array(
  'aid' => 'node_publish_action',
  'type' => 'node',
  'callback' => 'node_publish_action',
  'parameters' => '',
  'description' => 'Publish post',
))
->values(array(
  'aid' => 'node_save_action',
  'type' => 'node',
  'callback' => 'node_save_action',
  'parameters' => '',
  'description' => 'Save post',
))
->values(array(
  'aid' => 'node_unpromote_action',
  'type' => 'node',
  'callback' => 'node_unpromote_action',
  'parameters' => '',
  'description' => 'Remove post from front page',
))
->values(array(
  'aid' => 'node_unpublish_action',
  'type' => 'node',
  'callback' => 'node_unpublish_action',
  'parameters' => '',
  'description' => 'Unpublish post',
))
->values(array(
  'aid' => 'user_block_ip_action',
  'type' => 'user',
  'callback' => 'user_block_ip_action',
  'parameters' => '',
  'description' => 'Ban IP address of current user',
))
->values(array(
  'aid' => 'user_block_user_action',
  'type' => 'user',
  'callback' => 'user_block_user_action',
  'parameters' => '',
  'description' => 'Block current user',
))
->execute();
$connection->schema()->createTable('actions_aid', array(
  'fields' => array(
    'aid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'aid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('actions_aid')
->fields(array(
  'aid',
))
->values(array(
  'aid' => '1',
))
->values(array(
  'aid' => '2',
))
->values(array(
  'aid' => '3',
))
->values(array(
  'aid' => '4',
))
->values(array(
  'aid' => '5',
))
->values(array(
  'aid' => '6',
))
->execute();
$connection->schema()->createTable('aggregator_category', array(
  'fields' => array(
    'cid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'title' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'description' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'block' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('aggregator_feed', array(
  'fields' => array(
    'fid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'title' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'url' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'refresh' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'checked' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'link' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'description' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'image' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'etag' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'modified' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'block' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'fid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('aggregator_feed')
->fields(array(
  'fid',
  'title',
  'url',
  'refresh',
  'checked',
  'link',
  'description',
  'image',
  'etag',
  'modified',
  'block',
))
->values(array(
  'fid' => '5',
  'title' => 'Know Your Meme',
  'url' => 'http://knowyourmeme.com/newsfeed.rss',
  'refresh' => '900',
  'checked' => '1387659487',
  'link' => 'http://knowyourmeme.com',
  'description' => 'New items added to the News Feed',
  'image' => 'http://b.thumbs.redditmedia.com/harEHsUUZVajabtC.png',
  'etag' => '"213cc1365b96c310e92053c5551f0504"',
  'modified' => '0',
  'block' => '7',
))
->execute();
$connection->schema()->createTable('aggregator_item', array(
  'fields' => array(
    'iid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'fid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'title' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'link' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'author' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'description' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'guid' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'iid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('aggregator_item')
->fields(array(
  'iid',
  'fid',
  'title',
  'link',
  'author',
  'description',
  'timestamp',
  'guid',
))
->values(array(
  'iid' => '1',
  'fid' => '5',
  'title' => 'This (three) weeks in Drupal Core - January 10th 2014',
  'link' => 'https://groups.drupal.org/node/395218',
  'author' => 'larowlan',
  'description' => "<h2 id='new'>What's new with Drupal 8?</h2>",
  'timestamp' => '1389297196',
  'guid' => '395218 at https://groups.drupal.org',
))
->execute();
$connection->schema()->createTable('authmap', array(
  'fields' => array(
    'aid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'authname' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
  ),
  'primary key' => array(
    'aid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('batch', array(
  'fields' => array(
    'bid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'token' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'batch' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'bid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('batch')
->fields(array(
  'bid',
  'token',
  'timestamp',
  'batch',
))
->values(array(
  'bid' => '1',
  'token' => '',
  'timestamp' => '1494966324',
  'batch' => NULL,
))
->execute();
$connection->schema()->createTable('blocks', array(
  'fields' => array(
    'bid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '0',
    ),
    'theme' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'region' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'custom' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'throttle' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'visibility' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'pages' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'title' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'cache' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '1',
    ),
  ),
  'primary key' => array(
    'bid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('blocks')
->fields(array(
  'bid',
  'module',
  'delta',
  'theme',
  'status',
  'weight',
  'region',
  'custom',
  'throttle',
  'visibility',
  'pages',
  'title',
  'cache',
))
->values(array(
  'bid' => '1',
  'module' => 'user',
  'delta' => '0',
  'theme' => 'garland',
  'status' => '1',
  'weight' => '-10',
  'region' => 'left',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => "<front>\r\nnode/1\nblog/*",
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '2',
  'module' => 'user',
  'delta' => '1',
  'theme' => 'garland',
  'status' => '1',
  'weight' => '-11',
  'region' => 'left',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => 'zu - Navigation',
  'cache' => '-1',
))
->values(array(
  'bid' => '3',
  'module' => 'system',
  'delta' => '0',
  'theme' => 'garland',
  'status' => '1',
  'weight' => '-5',
  'region' => 'footer',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => 'node/1',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '4',
  'module' => 'comment',
  'delta' => '0',
  'theme' => 'garland',
  'status' => '0',
  'weight' => '-9',
  'region' => '',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '1',
))
->values(array(
  'bid' => '5',
  'module' => 'menu',
  'delta' => 'primary-links',
  'theme' => 'garland',
  'status' => '1',
  'weight' => '-5',
  'region' => 'header',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '6',
  'module' => 'menu',
  'delta' => 'secondary-links',
  'theme' => 'garland',
  'status' => '0',
  'weight' => '-8',
  'region' => '',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '7',
  'module' => 'node',
  'delta' => '0',
  'theme' => 'garland',
  'status' => '0',
  'weight' => '-7',
  'region' => '',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '8',
  'module' => 'user',
  'delta' => '2',
  'theme' => 'garland',
  'status' => '1',
  'weight' => '-11',
  'region' => 'right',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '1',
))
->values(array(
  'bid' => '9',
  'module' => 'user',
  'delta' => '3',
  'theme' => 'garland',
  'status' => '1',
  'weight' => '-10',
  'region' => 'right',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '10',
  'module' => 'block',
  'delta' => '1',
  'theme' => 'garland',
  'status' => '1',
  'weight' => '0',
  'region' => 'content',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '1',
  'pages' => '<front>',
  'title' => 'Static Block',
  'cache' => '-1',
))
->values(array(
  'bid' => '11',
  'module' => 'block',
  'delta' => '2',
  'theme' => 'bluemarine',
  'status' => '1',
  'weight' => '-4',
  'region' => 'right',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '1',
  'pages' => 'node',
  'title' => 'Another Static Block',
  'cache' => '-1',
))
->values(array(
  'bid' => '12',
  'module' => 'block',
  'delta' => '1',
  'theme' => 'test_theme',
  'status' => '1',
  'weight' => '-7',
  'region' => 'right',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '13',
  'module' => 'block',
  'delta' => '2',
  'theme' => 'test_theme',
  'status' => '1',
  'weight' => '-2',
  'region' => 'left',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '2',
  'pages' => "<?php\nreturn TRUE;",
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '14',
  'module' => 'aggregator',
  'delta' => 'feed-5',
  'theme' => 'garland',
  'status' => '1',
  'weight' => '-2',
  'region' => 'right',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '1',
))
->values(array(
  'bid' => '15',
  'module' => 'block',
  'delta' => '2',
  'theme' => 'garland',
  'status' => '0',
  'weight' => '1',
  'region' => '',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '16',
  'module' => 'profile',
  'delta' => '0',
  'theme' => 'garland',
  'status' => '0',
  'weight' => '-5',
  'region' => '',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '5',
))
->values(array(
  'bid' => '17',
  'module' => 'event',
  'delta' => '0',
  'theme' => 'garland',
  'status' => '0',
  'weight' => '-3',
  'region' => '',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '1',
))
->values(array(
  'bid' => '18',
  'module' => 'event',
  'delta' => '1',
  'theme' => 'garland',
  'status' => '0',
  'weight' => '0',
  'region' => '',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '1',
))
->values(array(
  'bid' => '19',
  'module' => 'event',
  'delta' => 'event-upcoming-event',
  'theme' => 'garland',
  'status' => '0',
  'weight' => '-1',
  'region' => '',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '1',
))
->values(array(
  'bid' => '20',
  'module' => 'book',
  'delta' => '0',
  'theme' => 'garland',
  'status' => '1',
  'weight' => '-4',
  'region' => 'right',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '5',
))
->values(array(
  'bid' => '21',
  'module' => 'locale',
  'delta' => '0',
  'theme' => 'garland',
  'status' => '0',
  'weight' => '0',
  'region' => '',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->values(array(
  'bid' => '22',
  'module' => 'forum',
  'delta' => '0',
  'theme' => 'garland',
  'status' => '1',
  'weight' => '-8',
  'region' => 'left',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '1',
))
->values(array(
  'bid' => '23',
  'module' => 'forum',
  'delta' => '1',
  'theme' => 'garland',
  'status' => '1',
  'weight' => '-9',
  'region' => 'left',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '1',
))
->values(array(
  'bid' => '24',
  'module' => 'statistics',
  'delta' => '0',
  'theme' => 'garland',
  'status' => '1',
  'weight' => '0',
  'region' => 'right',
  'custom' => '0',
  'throttle' => '0',
  'visibility' => '0',
  'pages' => '',
  'title' => '',
  'cache' => '-1',
))
->execute();
$connection->schema()->createTable('blocks_roles', array(
  'fields' => array(
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
    ),
    'delta' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
    ),
    'rid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'module',
    'delta',
    'rid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('blocks_roles')
->fields(array(
  'module',
  'delta',
  'rid',
))
->values(array(
  'module' => 'user',
  'delta' => '2',
  'rid' => '2',
))
->values(array(
  'module' => 'user',
  'delta' => '3',
  'rid' => '3',
))
->execute();
$connection->schema()->createTable('book', array(
  'fields' => array(
    'mlid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'bid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'mlid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('book')
->fields(array(
  'mlid',
  'nid',
  'bid',
))
->values(array(
  'mlid' => '1',
  'nid' => '4',
  'bid' => '4',
))
->values(array(
  'mlid' => '2',
  'nid' => '5',
  'bid' => '4',
))
->values(array(
  'mlid' => '3',
  'nid' => '6',
  'bid' => '4',
))
->values(array(
  'mlid' => '4',
  'nid' => '7',
  'bid' => '4',
))
->values(array(
  'mlid' => '5',
  'nid' => '8',
  'bid' => '8',
))
->execute();
$connection->schema()->createTable('boxes', array(
  'fields' => array(
    'bid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'body' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'info' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'format' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'bid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('boxes')
->fields(array(
  'bid',
  'body',
  'info',
  'format',
))
->values(array(
  'bid' => '1',
  'body' => '<h3>My first custom block body</h3>',
  'info' => 'My block 1',
  'format' => '2',
))
->values(array(
  'bid' => '2',
  'body' => '<h3>My second custom block body</h3>',
  'info' => 'My block 2',
  'format' => '2',
))
->execute();
$connection->schema()->createTable('cache', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'headers' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_block', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'headers' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_bootstrap', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'numeric',
      'not null' => TRUE,
      'precision' => '14',
      'scale' => '3',
      'default' => '0.000',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'tags' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'checksum_invalidations' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'checksum_deletions' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_config', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'numeric',
      'not null' => TRUE,
      'precision' => '14',
      'scale' => '3',
      'default' => '0.000',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'tags' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'checksum_invalidations' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'checksum_deletions' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_content', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'headers' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_discovery', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'numeric',
      'not null' => TRUE,
      'precision' => '14',
      'scale' => '3',
      'default' => '0.000',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'tags' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'checksum_invalidations' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'checksum_deletions' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_filter', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'headers' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_form', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'headers' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_menu', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'headers' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_page', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'headers' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cache_update', array(
  'fields' => array(
    'cid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'expire' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'created' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'headers' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'serialized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('cachetags', array(
  'fields' => array(
    'tag' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'invalidations' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'deletions' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'tag',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('comments', array(
  'fields' => array(
    'cid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'pid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'subject' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'comment' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'hostname' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'format' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'thread' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '60',
    ),
    'mail' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '64',
    ),
    'homepage' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'indexes' => array(
    'pid' => array(
      'pid',
    ),
    'comment_uid' => array(
      'uid',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('comments')
->fields(array(
  'cid',
  'pid',
  'nid',
  'uid',
  'subject',
  'comment',
  'hostname',
  'timestamp',
  'status',
  'format',
  'thread',
  'name',
  'mail',
  'homepage',
))
->values(array(
  'cid' => '1',
  'pid' => '0',
  'nid' => '1',
  'uid' => '0',
  'subject' => 'The first comment.',
  'comment' => 'The first comment body.',
  'hostname' => '203.0.113.1',
  'timestamp' => '1390264918',
  'status' => '0',
  'format' => '1',
  'thread' => '01/',
  'name' => '1st comment author name',
  'mail' => 'comment1@example.com',
  'homepage' => 'https://www.drupal.org',
))
->values(array(
  'cid' => '2',
  'pid' => '3',
  'nid' => '1',
  'uid' => '0',
  'subject' => 'The response to the second comment.',
  'comment' => 'The second comment response body.',
  'hostname' => '203.0.113.2',
  'timestamp' => '1390264938',
  'status' => '0',
  'format' => '1',
  'thread' => '02/01',
  'name' => '3rd comment author name',
  'mail' => 'comment3@example.com',
  'homepage' => 'https://www.drupal.org',
))
->values(array(
  'cid' => '3',
  'pid' => '0',
  'nid' => '1',
  'uid' => '0',
  'subject' => 'The second comment.',
  'comment' => 'The second comment body.',
  'hostname' => '203.0.113.3',
  'timestamp' => '1390264948',
  'status' => '1',
  'format' => '1',
  'thread' => '02/',
  'name' => '3rd comment author name',
  'mail' => 'comment3@example.com',
  'homepage' => 'https://www.drupal.org',
))
->values(array(
  'cid' => '4',
  'pid' => '0',
  'nid' => '19',
  'uid' => '1',
  'subject' => 'Subject 1',
  'comment' => 'Comment 1',
  'hostname' => '127.0.0.1',
  'timestamp' => '1501955780',
  'status' => '0',
  'format' => '1',
  'thread' => '01/',
  'name' => 'root',
  'mail' => '',
  'homepage' => '',
))
->values(array(
  'cid' => '5',
  'pid' => '4',
  'nid' => '19',
  'uid' => '1',
  'subject' => 'Subject 2',
  'comment' => 'Comment 2',
  'hostname' => '127.0.0.1',
  'timestamp' => '1501955792',
  'status' => '0',
  'format' => '1',
  'thread' => '01.00/',
  'name' => 'root',
  'mail' => '',
  'homepage' => '',
))
->values(array(
  'cid' => '6',
  'pid' => '5',
  'nid' => '19',
  'uid' => '1',
  'subject' => 'Subject 3',
  'comment' => 'Comment 3',
  'hostname' => '127.0.0.1',
  'timestamp' => '1501955803',
  'status' => '0',
  'format' => '1',
  'thread' => '01.00.00/',
  'name' => 'root',
  'mail' => '',
  'homepage' => '',
))
->values(array(
  'cid' => '7',
  'pid' => '0',
  'nid' => '21',
  'uid' => '1',
  'subject' => 'Comment to John Smith - EN',
  'comment' => 'This is an English comment.',
  'hostname' => '2001:14ba:13f8:300:d9d0:363c:9fe4:66e1',
  'timestamp' => '1534014729',
  'status' => '0',
  'format' => '1',
  'thread' => '01/',
  'name' => 'root',
  'mail' => '',
  'homepage' => '',
))
->values(array(
  'cid' => '8',
  'pid' => '0',
  'nid' => '22',
  'uid' => '1',
  'subject' => 'Comment to John Smith - FR',
  'comment' => 'This is a French comment.',
  'hostname' => '2001:14ba:13f8:300:d9d0:363c:9fe4:66e1',
  'timestamp' => '1534014763',
  'status' => '0',
  'format' => '1',
  'thread' => '01/',
  'name' => 'root',
  'mail' => '',
  'homepage' => '',
))
->execute();
$connection->schema()->createTable('config', array(
  'fields' => array(
    'collection' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'data' => array(
      'type' => 'blob',
      'not null' => FALSE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'collection',
    'name',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('config')
->fields(array(
  'collection',
  'name',
  'data',
))
->values(array(
  'collection' => '',
  'name' => 'system.file',
  'data' => 'a:1:{s:4:"path";a:1:{s:9:"temporary";s:4:"/tmp";}}',
))
->execute();
$connection->schema()->createTable('contact', array(
  'fields' => array(
    'cid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'category' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'recipients' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'reply' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'selected' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'cid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('contact')
->fields(array(
  'cid',
  'category',
  'recipients',
  'reply',
  'weight',
  'selected',
))
->values(array(
  'cid' => '1',
  'category' => 'Website feedback',
  'recipients' => 'admin@example.com',
  'reply' => '',
  'weight' => '0',
  'selected' => '0',
))
->values(array(
  'cid' => '2',
  'category' => 'Some other category',
  'recipients' => 'test@example.com',
  'reply' => 'Thanks for contacting us, we will reply ASAP!',
  'weight' => '1',
  'selected' => '1',
))
->values(array(
  'cid' => '3',
  'category' => 'A category much longer than thirty two characters',
  'recipients' => 'fortyninechars@example.com',
  'reply' => '',
  'weight' => '2',
  'selected' => '0',
))
->execute();
$connection->schema()->createTable('content_field_company', array(
  'fields' => array(
    'vid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'field_company_nid' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'vid',
    'delta',
  ),
  'indexes' => array(
    'nid' => array(
      'nid',
    ),
    'field_company_nid' => array(
      'field_company_nid',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('content_field_company')
->fields(array(
  'vid',
  'nid',
  'delta',
  'field_company_nid',
))
->values(array(
  'vid' => '21',
  'nid' => '18',
  'delta' => '0',
  'field_company_nid' => '15',
))
->values(array(
  'vid' => '2002',
  'nid' => '21',
  'delta' => '0',
  'field_company_nid' => NULL,
))
->values(array(
  'vid' => '2003',
  'nid' => '22',
  'delta' => '0',
  'field_company_nid' => NULL,
))
->values(array(
  'vid' => '21',
  'nid' => '18',
  'delta' => '1',
  'field_company_nid' => '16',
))
->execute();
$connection->schema()->createTable('content_field_image', array(
  'fields' => array(
    'vid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'field_image_fid' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'field_image_list' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'field_image_data' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'vid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('content_field_image')
->fields(array(
  'vid',
  'nid',
  'field_image_fid',
  'field_image_list',
  'field_image_data',
))
->values(array(
  'vid' => '1',
  'nid' => '1',
  'field_image_fid' => '2',
  'field_image_list' => '1',
  'field_image_data' => 'a:2:{s:3:"alt";s:0:"";s:5:"title";s:0:"";}',
))
->values(array(
  'vid' => '2',
  'nid' => '2',
  'field_image_fid' => NULL,
  'field_image_list' => NULL,
  'field_image_data' => NULL,
))
->values(array(
  'vid' => '3',
  'nid' => '1',
  'field_image_fid' => '2',
  'field_image_list' => '1',
  'field_image_data' => 'a:2:{s:3:"alt";s:0:"";s:5:"title";s:0:"";}',
))
->execute();
$connection->schema()->createTable('content_field_multivalue', array(
  'fields' => array(
    'vid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'field_multivalue_value' => array(
      'type' => 'numeric',
      'not null' => FALSE,
      'precision' => '10',
      'scale' => '2',
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'vid',
    'delta',
  ),
  'indexes' => array(
    'nid' => array(
      'nid',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('content_field_multivalue')
->fields(array(
  'vid',
  'nid',
  'field_multivalue_value',
  'delta',
))
->values(array(
  'vid' => '4',
  'nid' => '3',
  'field_multivalue_value' => '33.00',
  'delta' => '0',
))
->values(array(
  'vid' => '4',
  'nid' => '3',
  'field_multivalue_value' => '44.00',
  'delta' => '1',
))
->execute();
$connection->schema()->createTable('content_field_test', array(
  'fields' => array(
    'vid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'field_test_value' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'field_test_format' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'vid',
  ),
  'indexes' => array(
    'nid' => array(
      'nid',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('content_field_test')
->fields(array(
  'vid',
  'nid',
  'field_test_value',
  'field_test_format',
))
->values(array(
  'vid' => '1',
  'nid' => '1',
  'field_test_value' => 'This is a shared text field',
  'field_test_format' => '1',
))
->values(array(
  'vid' => '2',
  'nid' => '1',
  'field_test_value' => 'This is a shared text field',
  'field_test_format' => '1',
))
->values(array(
  'vid' => '3',
  'nid' => '2',
  'field_test_value' => NULL,
  'field_test_format' => NULL,
))
->values(array(
  'vid' => '5',
  'nid' => '2',
  'field_test_value' => NULL,
  'field_test_format' => NULL,
))
->values(array(
  'vid' => '12',
  'nid' => '9',
  'field_test_value' => 'text for default value',
  'field_test_format' => '1',
))
->execute();
$connection->schema()->createTable('content_field_test_text_single_checkbox', array(
  'fields' => array(
    'vid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'field_test_text_single_checkbox_value' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'vid',
  ),
  'indexes' => array(
    'nid' => array(
      'nid',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('content_field_test_text_single_checkbox')
->fields(array(
  'vid',
  'nid',
  'field_test_text_single_checkbox_value',
))
->values(array(
  'vid' => '1',
  'nid' => '1',
  'field_test_text_single_checkbox_value' => '0',
))
->values(array(
  'vid' => '2',
  'nid' => '1',
  'field_test_text_single_checkbox_value' => NULL,
))
->values(array(
  'vid' => '3',
  'nid' => '2',
  'field_test_text_single_checkbox_value' => NULL,
))
->values(array(
  'vid' => '5',
  'nid' => '2',
  'field_test_text_single_checkbox_value' => NULL,
))
->values(array(
  'vid' => '12',
  'nid' => '9',
  'field_test_text_single_checkbox_value' => '0',
))
->execute();
$connection->schema()->createTable('content_field_test_two', array(
  'fields' => array(
    'vid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'field_test_two_value' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'vid',
    'delta',
  ),
  'indexes' => array(
    'nid' => array(
      'nid',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('content_field_test_two')
->fields(array(
  'vid',
  'nid',
  'delta',
  'field_test_two_value',
))
->values(array(
  'vid' => '1',
  'nid' => '1',
  'delta' => '0',
  'field_test_two_value' => '10',
))
->values(array(
  'vid' => '2',
  'nid' => '1',
  'delta' => '0',
  'field_test_two_value' => NULL,
))
->values(array(
  'vid' => '3',
  'nid' => '2',
  'delta' => '0',
  'field_test_two_value' => NULL,
))
->values(array(
  'vid' => '5',
  'nid' => '2',
  'delta' => '0',
  'field_test_two_value' => NULL,
))
->values(array(
  'vid' => '12',
  'nid' => '9',
  'delta' => '0',
  'field_test_two_value' => NULL,
))
->values(array(
  'vid' => '1',
  'nid' => '1',
  'delta' => '1',
  'field_test_two_value' => '20',
))
->execute();
$connection->schema()->createTable('content_group', array(
  'fields' => array(
    'group_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => 'standard',
    ),
    'type_name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'group_name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'label' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'settings' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'type_name',
    'group_name',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('content_group_fields', array(
  'fields' => array(
    'type_name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'group_name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'field_name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
  ),
  'primary key' => array(
    'type_name',
    'group_name',
    'field_name',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('content_node_field', array(
  'fields' => array(
    'field_name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '127',
      'default' => '',
    ),
    'global_settings' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'required' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'multiple' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'db_storage' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '1',
    ),
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '127',
      'default' => '',
    ),
    'db_columns' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'active' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'locked' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'field_name',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('content_node_field')
->fields(array(
  'field_name',
  'type',
  'global_settings',
  'required',
  'multiple',
  'db_storage',
  'module',
  'db_columns',
  'active',
  'locked',
))
->values(array(
  'field_name' => 'field_commander',
  'type' => 'userreference',
  'global_settings' => 'a:2:{s:19:"referenceable_roles";a:4:{i:2;i:2;i:3;i:0;i:4;i:0;i:5;i:0;}s:20:"referenceable_status";s:0:"";}',
  'required' => '0',
  'multiple' => '0',
  'db_storage' => '1',
  'module' => 'userreference',
  'db_columns' => 'a:1:{s:3:"uid";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:0;s:5:"index";b:1;}}',
  'active' => '1',
  'locked' => '0',
))
->values(array(
  'field_name' => 'field_company',
  'type' => 'nodereference',
  'global_settings' => 'a:1:{s:19:"referenceable_types";a:10:{s:7:"company";s:7:"company";s:7:"article";i:0;s:8:"employee";i:0;s:5:"forum";i:0;s:10:"test_event";i:0;s:9:"test_page";i:0;s:11:"test_planet";i:0;s:10:"test_story";i:0;s:7:"sponsor";i:0;s:5:"story";i:0;}}',
  'required' => '0',
  'multiple' => '1',
  'db_storage' => '0',
  'module' => 'nodereference',
  'db_columns' => 'a:1:{s:3:"nid";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:0;s:5:"index";b:1;}}',
  'active' => '1',
  'locked' => '0',
))
->values(array(
  'field_name' => 'field_company_2',
  'type' => 'nodereference',
  'global_settings' => 'a:1:{s:19:"referenceable_types";a:10:{s:7:"company";s:7:"company";s:7:"article";i:0;s:8:"employee";i:0;s:5:"forum";i:0;s:10:"test_event";i:0;s:9:"test_page";i:0;s:11:"test_planet";i:0;s:10:"test_story";i:0;s:7:"sponsor";i:0;s:5:"story";i:0;}}',
  'required' => '0',
  'multiple' => '0',
  'db_storage' => '1',
  'module' => 'nodereference',
  'db_columns' => 'a:1:{s:3:"nid";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:0;s:5:"index";b:1;}}',
  'active' => '1',
  'locked' => '0',
))
->values(array(
  'field_name' => 'field_company_3',
  'type' => 'nodereference',
  'global_settings' => 'a:1:{s:19:"referenceable_types";a:10:{s:7:"company";s:7:"company";s:7:"article";i:0;s:8:"employee";i:0;s:5:"forum";i:0;s:10:"test_event";i:0;s:9:"test_page";i:0;s:11:"test_planet";i:0;s:10:"test_story";i:0;s:7:"sponsor";i:0;s:5:"story";i:0;}}',
  'required' => '0',
  'multiple' => '0',
  'db_storage' => '1',
  'module' => 'nodereference',
  'db_columns' => 'a:1:{s:3:"nid";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:0;s:5:"index";b:1;}}',
  'active' => '1',
  'locked' => '0',
))
->values(array(
  'field_name' => 'field_multivalue',
  'type' => 'number_decimal',
  'global_settings' => 'a:9:{s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:3:"min";s:0:"";s:3:"max";s:0:"";s:14:"allowed_values";s:0:"";s:18:"allowed_values_php";s:0:"";s:9:"precision";s:2:"10";s:5:"scale";s:1:"2";s:7:"decimal";s:1:".";}',
  'required' => '0',
  'multiple' => '1',
  'db_storage' => '0',
  'module' => 'number',
  'db_columns' => 'a:1:{s:5:"value";a:5:{s:4:"type";s:7:"numeric";s:9:"precision";s:2:"10";s:5:"scale";s:1:"2";s:8:"not null";b:0;s:8:"sortable";b:1;}}',
  'active' => '1',
  'locked' => '0',
))
->values(array(
  'field_name' => 'field_reference',
  'type' => 'nodereference',
  'global_settings' => 'a:1:{s:19:"referenceable_types";a:11:{s:4:"page";s:4:"page";s:7:"article";i:0;s:7:"company";i:0;s:8:"employee";i:0;s:5:"forum";i:0;s:10:"test_event";i:0;s:9:"test_page";i:0;s:11:"test_planet";i:0;s:10:"test_story";i:0;s:7:"sponsor";i:0;s:5:"story";i:0;}}',
  'required' => '0',
  'multiple' => '0',
  'db_storage' => '1',
  'module' => 'nodereference',
  'db_columns' => 'a:1:{s:3:"nid";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:0;s:5:"index";b:1;}}',
  'active' => '1',
  'locked' => '0',
))
->values(array(
  'field_name' => 'field_reference_2',
  'type' => 'nodereference',
  'global_settings' => 'a:1:{s:19:"referenceable_types";a:11:{s:4:"page";s:4:"page";s:7:"article";i:0;s:7:"company";i:0;s:8:"employee";i:0;s:5:"forum";i:0;s:10:"test_event";i:0;s:9:"test_page";i:0;s:11:"test_planet";i:0;s:10:"test_story";i:0;s:7:"sponsor";i:0;s:5:"story";i:0;}}',
  'required' => '0',
  'multiple' => '0',
  'db_storage' => '1',
  'module' => 'nodereference',
  'db_columns' => 'a:1:{s:3:"nid";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:0;s:5:"index";b:1;}}',
  'active' => '1',
  'locked' => '0',
))
->values(array(
  'field_name' => 'field_sync',
  'type' => 'email',
  'global_settings' => 'a:0:{}',
  'required' => '0',
  'multiple' => '0',
  'db_storage' => '1',
  'module' => 'email',
  'db_columns' => 'a:1:{s:5:"email";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:0;s:8:"sortable";b:1;}}',
  'active' => '1',
  'locked' => '0',
))
->values(array(
  'field_name' => 'field_test',
  'type' => 'text',
  'global_settings' => 'a:4:{s:15:"text_processing";s:1:"1";s:10:"max_length";s:0:"";s:14:"allowed_values";s:0:"";s:18:"allowed_values_php";s:0:"";}',
  'required' => '0',
  'multiple' => '0',
  'db_storage' => '0',
  'module' => 'text',
  'db_columns' => 'a:2:{s:5:"value";a:5:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";s:8:"not null";b:0;s:8:"sortable";b:1;s:5:"views";b:1;}s:6:"format";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:0;s:5:"views";b:0;}}',
  'active' => '1',
  'locked' => '0',
))
->values(array(
  'field_name' => 'field_test_date',
  'type' => 'date',
  'global_settings' => 'a:7:{s:11:"granularity";a:5:{s:4:"year";s:4:"year";s:5:"month";s:5:"month";s:3:"day";s:3:"day";s:4:"hour";s:4:"hour";s:6:"minute";s:6:"minute";}s:11:"timezone_db";s:3:"UTC";s:11:"tz_handling";s:4:"site";s:6:"todate";s:0:"";s:6:"repeat";i:0;s:16:"repeat_collapsed";s:0:"";s:14:"default_format";s:6:"medium";}',
  'required' => '0',
  'multiple' => '0',
  'db_storage' => '1',
  'module' => 'date',
  'db_columns' => 'a:1:{s:5:"value";a:5:{s:4:"type";s:7:"varchar";s:6:"length";i:20;s:8:"not null";b:0;s:8:"sortable";b:1;s:5:"views";b:1;}}',
  'active' => '1',
  'locked' => '0',
))
->values(array(
  'field_name' => 'field_test_datestamp',
  'type' => 'datestamp',
  'global_settings' => 'a:13:{s:11:"granularity";a:6:{s:4:"year";s:4:"year";s:5:"month";s:5:"month";s:3:"day";s:3:"day";s:4:"hour";s:4:"hour";s:6:"minute";s:6:"minute";s:6:"second";i:0;}s:11:"timezone_db";s:3:"UTC";s:11:"tz_handling";s:4:"site";s:6:"todate";s:0:"";s:6:"repeat";i:0;s:18:"output_format_date";s:5:"m/d/Y";s:20:"output_format_custom";s:0:"";s:23:"output_format_date_long";s:5:"m/d/Y";s:25:"output_format_custom_long";s:0:"";s:25:"output_format_date_medium";s:5:"m/d/Y";s:27:"output_format_custom_medium";s:0:"";s:24:"output_format_date_short";s:5:"m/d/Y";s:26:"output_format_custom_short";s:0:"";}',
  'required' => '0',
  'multiple' => '0',
  'db_storage' => '1',
  'module' => 'date',
  'db_columns' => 'a:2:{s:5:"value";a:4:{s:4:"type";s:3:"int";s:6:"length";i:11;s:8:"not null";b:0;s:8:"sortable";b:1;}s:6:"value2";a:4:{s:4:"type";s:3:"int";s:6:"length";i:11;s:8:"not null";b:0;s:8:"sortable";b:1;}}',
  'active' => '1',
  'locked' => '0',
))
->values(array(
  'field_name' => 'field_test_datetime',
  'type' => 'datetime',
  'global_settings' => 'a:13:{s:11:"granularity";a:6:{s:4:"year";s:4:"year";s:5:"month";s:5:"month";s:3:"day";s:3:"day";s:4:"hour";s:4:"hour";s:6:"minute";s:6:"minute";s:6:"second";i:0;}s:11:"timezone_db";s:3:"UTC";s:11:"tz_handling";s:4:"site";s:6:"todate";s:0:"";s:6:"repeat";i:0;s:18:"output_format_date";s:5:"m/d/Y";s:20:"output_format_custom";s:0:"";s:23:"output_format_date_long";s:5:"m/d/Y";s:25:"output_format_custom_long";s:0:"";s:25:"output_format_date_medium";s:5:"m/d/Y";s:27:"output_format_custom_medium";s:0:"";s:24:"output_format_date_short";s:5:"m/d/Y";s:26:"output_format_custom_short";s:0:"";}',
  'required' => '0',
  'multiple' => '0',
  'db_storage' => '1',
  'module' => 'date',
  'db_columns' => 'a:2:{s:5:"value";a:3:{s:4:"type";s:8:"datetime";s:8:"not null";b:0;s:8:"sortable";b:1;}s:6:"value2";a:3:{s:4:"type";s:8:"datetime";s:8:"not null";b:0;s:8:"sortable";b:1;}}',
  'active' => '1',
  'locked' => '0',
))
->values(array(
  'field_name' => 'field_test_decimal_radio_buttons',
  'type' => 'number_decimal',
  'global_settings' => "a:9:{s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:3:\"min\";s:0:\"\";s:3:\"max\";s:0:\"\";s:14:\"allowed_values\";s:8:\"1.2\r\n2.1\";s:18:\"allowed_values_php\";s:0:\"\";s:9:\"precision\";s:2:\"10\";s:5:\"scale\";s:1:\"2\";s:7:\"decimal\";s:1:\".\";}",
  'required' => '0',
  'multiple' => '0',
  'db_storage' => '1',
  'module' => 'number',
  'db_columns' => 'a:1:{s:5:"value";a:5:{s:4:"type";s:7:"numeric";s:9:"precision";s:2:"10";s:5:"scale";s:1:"2";s:8:"not null";b:0;s:8:"sortable";b:1;}}',
  'active' => '1',
  'locked' => '0',
))
->values(array(
  'field_name' => 'field_test_email',
  'type' => 'email',
  'global_settings' => 'a:0:{}',
  'required' => '0',
  'multiple' => '0',
  'db_storage' => '1',
  'module' => 'email',
  'db_columns' => 'a:1:{s:5:"email";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:0;s:8:"sortable";b:1;}}',
  'active' => '1',
  'locked' => '0',
))
->values(array(
  'field_name' => 'field_test_exclude_unset',
  'type' => 'text',
  'global_settings' => 'a:4:{s:15:"text_processing";s:1:"1";s:10:"max_length";s:0:"";s:14:"allowed_values";s:0:"";s:18:"allowed_values_php";s:0:"";}',
  'required' => '0',
  'multiple' => '0',
  'db_storage' => '1',
  'module' => 'text',
  'db_columns' => 'a:2:{s:5:"value";a:5:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";s:8:"not null";b:0;s:8:"sortable";b:1;s:5:"views";b:1;}s:6:"format";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:0;s:5:"views";b:0;}}',
  'active' => '1',
  'locked' => '0',
))
->values(array(
  'field_name' => 'field_test_filefield',
  'type' => 'filefield',
  'global_settings' => 'a:3:{s:10:"list_field";s:1:"0";s:12:"list_default";i:1;s:17:"description_field";s:1:"1";}',
  'required' => '0',
  'multiple' => '0',
  'db_storage' => '1',
  'module' => 'filefield',
  'db_columns' => 'a:3:{s:3:"fid";a:3:{s:4:"type";s:3:"int";s:8:"not null";b:0;s:5:"views";b:1;}s:4:"list";a:4:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;s:5:"views";b:1;}s:4:"data";a:3:{s:4:"type";s:4:"text";s:9:"serialize";b:1;s:5:"views";b:1;}}',
  'active' => '1',
  'locked' => '0',
))
->values(array(
  'field_name' => 'field_test_float_single_checkbox',
  'type' => 'number_float',
  'global_settings' => "a:6:{s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:3:\"min\";s:0:\"\";s:3:\"max\";s:0:\"\";s:14:\"allowed_values\";s:12:\"3.142\r\n1.234\";s:18:\"allowed_values_php\";s:0:\"\";}",
  'required' => '0',
  'multiple' => '0',
  'db_storage' => '1',
  'module' => 'number',
  'db_columns' => 'a:1:{s:5:"value";a:3:{s:4:"type";s:5:"float";s:8:"not null";b:0;s:8:"sortable";b:1;}}',
  'active' => '1',
  'locked' => '0',
))
->values(array(
  'field_name' => 'field_test_four',
  'type' => 'number_float',
  'global_settings' => 'a:6:{s:6:"prefix";s:3:"id-";s:6:"suffix";s:0:"";s:3:"min";s:3:"100";s:3:"max";s:3:"200";s:14:"allowed_values";s:0:"";s:18:"allowed_values_php";s:0:"";}',
  'required' => '0',
  'multiple' => '0',
  'db_storage' => '1',
  'module' => 'number',
  'db_columns' => 'a:1:{s:5:"value";a:3:{s:4:"type";s:5:"float";s:8:"not null";b:0;s:8:"sortable";b:1;}}',
  'active' => '1',
  'locked' => '0',
))
->values(array(
  'field_name' => 'field_test_identical1',
  'type' => 'number_integer',
  'global_settings' => 'a:6:{s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:3:"min";s:0:"";s:3:"max";s:0:"";s:14:"allowed_values";s:0:"";s:18:"allowed_values_php";s:0:"";}',
  'required' => '0',
  'multiple' => '0',
  'db_storage' => '1',
  'module' => 'number',
  'db_columns' => 'a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"not null";b:0;s:8:"sortable";b:1;}}',
  'active' => '1',
  'locked' => '0',
))
->values(array(
  'field_name' => 'field_test_identical2',
  'type' => 'number_integer',
  'global_settings' => 'a:6:{s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:3:"min";s:0:"";s:3:"max";s:0:"";s:14:"allowed_values";s:0:"";s:18:"allowed_values_php";s:0:"";}',
  'required' => '0',
  'multiple' => '0',
  'db_storage' => '1',
  'module' => 'number',
  'db_columns' => 'a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"not null";b:0;s:8:"sortable";b:1;}}',
  'active' => '1',
  'locked' => '0',
))
->values(array(
  'field_name' => 'field_test_imagefield',
  'type' => 'filefield',
  'global_settings' => 'a:3:{s:10:"list_field";s:1:"0";s:12:"list_default";i:1;s:17:"description_field";s:1:"0";}',
  'required' => '0',
  'multiple' => '0',
  'db_storage' => '1',
  'module' => 'filefield',
  'db_columns' => 'a:3:{s:3:"fid";a:3:{s:4:"type";s:3:"int";s:8:"not null";b:0;s:5:"views";b:1;}s:4:"list";a:4:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;s:5:"views";b:1;}s:4:"data";a:3:{s:4:"type";s:4:"text";s:9:"serialize";b:1;s:5:"views";b:1;}}',
  'active' => '1',
  'locked' => '0',
))
->values(array(
  'field_name' => 'field_test_integer_selectlist',
  'type' => 'number_integer',
  'global_settings' => "a:6:{s:6:\"prefix\";s:0:\"\";s:6:\"suffix\";s:0:\"\";s:3:\"min\";s:0:\"\";s:3:\"max\";s:0:\"\";s:14:\"allowed_values\";s:22:\"1234\r\n2341\r\n3412\r\n4123\";s:18:\"allowed_values_php\";s:0:\"\";}",
  'required' => '0',
  'multiple' => '0',
  'db_storage' => '1',
  'module' => 'number',
  'db_columns' => 'a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"not null";b:0;s:8:"sortable";b:1;}}',
  'active' => '1',
  'locked' => '0',
))
->values(array(
  'field_name' => 'field_test_link',
  'type' => 'link',
  'global_settings' => 'a:7:{s:10:"attributes";a:4:{s:6:"target";s:4:"user";s:3:"rel";s:8:"nofollow";s:5:"class";s:0:"";s:5:"title";s:10:"Link Title";}s:7:"display";a:1:{s:10:"url_cutoff";s:2:"80";}s:3:"url";i:0;s:5:"title";s:8:"required";s:11:"title_value";s:0:"";s:13:"enable_tokens";s:0:"";s:12:"validate_url";i:1;}',
  'required' => '0',
  'multiple' => '0',
  'db_storage' => '1',
  'module' => 'link',
  'db_columns' => 'a:3:{s:3:"url";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:2048;s:8:"not null";b:0;s:8:"sortable";b:1;}s:5:"title";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:0;s:8:"sortable";b:1;}s:10:"attributes";a:3:{s:4:"type";s:4:"text";s:4:"size";s:6:"medium";s:8:"not null";b:0;}}',
  'active' => '1',
  'locked' => '0',
))
->values(array(
  'field_name' => 'field_test_phone',
  'type' => 'au_phone',
  'global_settings' => 'a:1:{s:18:"phone_country_code";i:0;}',
  'required' => '0',
  'multiple' => '0',
  'db_storage' => '1',
  'module' => 'phone',
  'db_columns' => 'a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:0;}}',
  'active' => '1',
  'locked' => '0',
))
->values(array(
  'field_name' => 'field_test_string_selectlist',
  'type' => 'text',
  'global_settings' => "a:4:{s:15:\"text_processing\";s:1:\"0\";s:10:\"max_length\";s:0:\"\";s:14:\"allowed_values\";s:18:\"A|Black\r\nB|White\r\n\";s:18:\"allowed_values_php\";s:0:\"\";}",
  'required' => '0',
  'multiple' => '0',
  'db_storage' => '1',
  'module' => 'text',
  'db_columns' => 'a:1:{s:5:"value";a:5:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";s:8:"not null";b:0;s:8:"sortable";b:1;s:5:"views";b:1;}}',
  'active' => '1',
  'locked' => '0',
))
->values(array(
  'field_name' => 'field_test_text_single_checkbox',
  'type' => 'text',
  'global_settings' => "a:4:{s:15:\"text_processing\";s:1:\"0\";s:10:\"max_length\";s:0:\"\";s:14:\"allowed_values\";s:18:\"0|Hello\r\n1|Goodbye\";s:18:\"allowed_values_php\";s:0:\"\";}",
  'required' => '0',
  'multiple' => '0',
  'db_storage' => '0',
  'module' => 'text',
  'db_columns' => 'a:1:{s:5:"value";a:5:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";s:8:"not null";b:0;s:8:"sortable";b:1;s:5:"views";b:1;}}',
  'active' => '1',
  'locked' => '0',
))
->values(array(
  'field_name' => 'field_test_text_single_checkbox2',
  'type' => 'text',
  'global_settings' => "a:4:{s:15:\"text_processing\";s:1:\"0\";s:10:\"max_length\";s:0:\"\";s:14:\"allowed_values\";s:10:\"Off\r\nHello\";s:18:\"allowed_values_php\";s:0:\"\";}",
  'required' => '0',
  'multiple' => '0',
  'db_storage' => '1',
  'module' => 'text',
  'db_columns' => 'a:1:{s:5:"value";a:5:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";s:8:"not null";b:0;s:8:"sortable";b:1;s:5:"views";b:1;}}',
  'active' => '1',
  'locked' => '0',
))
->values(array(
  'field_name' => 'field_test_three',
  'type' => 'number_decimal',
  'global_settings' => 'a:9:{s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:3:"min";s:0:"";s:3:"max";s:3:"600";s:14:"allowed_values";s:0:"";s:18:"allowed_values_php";s:0:"";s:9:"precision";s:2:"10";s:5:"scale";s:1:"2";s:7:"decimal";s:1:".";}',
  'required' => '0',
  'multiple' => '0',
  'db_storage' => '1',
  'module' => 'number',
  'db_columns' => 'a:1:{s:5:"value";a:5:{s:4:"type";s:7:"numeric";s:9:"precision";s:2:"10";s:5:"scale";s:1:"2";s:8:"not null";b:0;s:8:"sortable";b:1;}}',
  'active' => '1',
  'locked' => '0',
))
->values(array(
  'field_name' => 'field_test_two',
  'type' => 'number_integer',
  'global_settings' => 'a:6:{s:6:"prefix";s:4:"pref";s:6:"suffix";s:3:"suf";s:3:"min";s:2:"10";s:3:"max";s:3:"100";s:14:"allowed_values";s:0:"";s:18:"allowed_values_php";s:0:"";}',
  'required' => '0',
  'multiple' => '1',
  'db_storage' => '0',
  'module' => 'number',
  'db_columns' => 'a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"not null";b:0;s:8:"sortable";b:1;}}',
  'active' => '1',
  'locked' => '0',
))
->execute();
$connection->schema()->createTable('content_node_field_instance', array(
  'fields' => array(
    'field_name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'type_name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'label' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'widget_type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'widget_settings' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'display_settings' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'description' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'widget_module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '127',
      'default' => '',
    ),
    'widget_active' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'field_name',
    'type_name',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('content_node_field_instance')
->fields(array(
  'field_name',
  'type_name',
  'weight',
  'label',
  'widget_type',
  'widget_settings',
  'display_settings',
  'description',
  'widget_module',
  'widget_active',
))
->values(array(
  'field_name' => 'field_commander',
  'type_name' => 'employee',
  'weight' => '32',
  'label' => 'Commanding Officer',
  'widget_type' => 'userreference_select',
  'widget_settings' => 'a:5:{s:18:"autocomplete_match";s:8:"contains";s:4:"size";i:60;s:12:"reverse_link";i:0;s:13:"default_value";a:1:{i:0;a:1:{s:3:"uid";s:0:"";}}s:17:"default_value_php";N;}',
  'display_settings' => 'a:5:{s:5:"label";a:2:{s:6:"format";s:5:"above";s:7:"exclude";i:0;}i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:6:"teaser";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}}',
  'description' => '',
  'widget_module' => 'userreference',
  'widget_active' => '1',
))
->values(array(
  'field_name' => 'field_company',
  'type_name' => 'employee',
  'weight' => '31',
  'label' => 'Company',
  'widget_type' => 'nodereference_select',
  'widget_settings' => 'a:4:{s:18:"autocomplete_match";s:8:"contains";s:4:"size";i:60;s:13:"default_value";a:1:{i:0;a:1:{s:3:"nid";s:0:"";}}s:17:"default_value_php";N;}',
  'display_settings' => 'a:5:{s:5:"label";a:2:{s:6:"format";s:5:"above";s:7:"exclude";i:0;}i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:6:"teaser";a:2:{s:6:"format";s:5:"plain";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}}',
  'description' => '',
  'widget_module' => 'nodereference',
  'widget_active' => '1',
))
->values(array(
  'field_name' => 'field_company_2',
  'type_name' => 'employee',
  'weight' => '33',
  'label' => 'Company 2',
  'widget_type' => 'nodereference_buttons',
  'widget_settings' => 'a:4:{s:18:"autocomplete_match";s:8:"contains";s:4:"size";i:60;s:13:"default_value";a:1:{i:0;a:1:{s:3:"nid";s:0:"";}}s:17:"default_value_php";N;}',
  'display_settings' => 'a:5:{s:5:"label";a:2:{s:6:"format";s:5:"above";s:7:"exclude";i:0;}i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:6:"teaser";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}}',
  'description' => '',
  'widget_module' => 'nodereference',
  'widget_active' => '1',
))
->values(array(
  'field_name' => 'field_company_3',
  'type_name' => 'employee',
  'weight' => '34',
  'label' => 'Company 3',
  'widget_type' => 'nodereference_autocomplete',
  'widget_settings' => 'a:4:{s:18:"autocomplete_match";s:8:"contains";s:4:"size";s:2:"60";s:13:"default_value";a:1:{i:0;a:2:{s:3:"nid";N;s:14:"_error_element";s:50:"default_value_widget][field_company_3][0][nid][nid";}}s:17:"default_value_php";N;}',
  'display_settings' => 'a:5:{s:5:"label";a:2:{s:6:"format";s:5:"above";s:7:"exclude";i:0;}i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:6:"teaser";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}}',
  'description' => '',
  'widget_module' => 'nodereference',
  'widget_active' => '1',
))
->values(array(
  'field_name' => 'field_multivalue',
  'type_name' => 'test_planet',
  'weight' => '2',
  'label' => 'Decimal Field',
  'widget_type' => 'number',
  'widget_settings' => 'a:2:{s:13:"default_value";a:1:{i:0;a:2:{s:5:"value";s:0:"";s:14:"_error_element";s:48:"default_value_widget][field_multivalue][0][value";}}s:17:"default_value_php";N;}',
  'display_settings' => 'a:6:{s:6:"weight";i:2;s:6:"parent";s:0:"";s:5:"label";a:1:{s:6:"format";s:5:"above";}s:6:"teaser";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}}',
  'description' => 'An example multi-valued decimal field.',
  'widget_module' => 'number',
  'widget_active' => '1',
))
->values(array(
  'field_name' => 'field_reference',
  'type_name' => 'page',
  'weight' => '31',
  'label' => 'Reference',
  'widget_type' => 'nodereference_select',
  'widget_settings' => 'a:4:{s:18:"autocomplete_match";s:8:"contains";s:4:"size";i:60;s:13:"default_value";a:1:{i:0;a:1:{s:3:"nid";s:0:"";}}s:17:"default_value_php";N;}',
  'display_settings' => 'a:5:{s:5:"label";a:2:{s:6:"format";s:5:"above";s:7:"exclude";i:0;}i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:6:"teaser";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}}',
  'description' => '',
  'widget_module' => 'nodereference',
  'widget_active' => '1',
))
->values(array(
  'field_name' => 'field_reference_2',
  'type_name' => 'page',
  'weight' => '32',
  'label' => 'Reference',
  'widget_type' => 'nodereference_select',
  'widget_settings' => 'a:4:{s:18:"autocomplete_match";s:8:"contains";s:4:"size";i:60;s:13:"default_value";a:1:{i:0;a:1:{s:3:"nid";s:0:"";}}s:17:"default_value_php";N;}',
  'display_settings' => 'a:5:{s:5:"label";a:2:{s:6:"format";s:5:"above";s:7:"exclude";i:0;}i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:6:"teaser";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}}',
  'description' => '',
  'widget_module' => 'nodereference',
  'widget_active' => '1',
))
->values(array(
  'field_name' => 'field_sync',
  'type_name' => 'employee',
  'weight' => '35',
  'label' => 'email_sync',
  'widget_type' => 'email_textfield',
  'widget_settings' => 'a:3:{s:4:"size";s:2:"60";s:13:"default_value";a:1:{i:0;a:1:{s:5:"email";s:0:"";}}s:17:"default_value_php";N;}',
  'display_settings' => 'a:7:{s:5:"label";a:2:{s:6:"format";s:5:"above";s:7:"exclude";i:0;}i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:6:"teaser";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:2;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:3;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}}',
  'description' => '',
  'widget_module' => 'email',
  'widget_active' => '1',
))
->values(array(
  'field_name' => 'field_test',
  'type_name' => 'story',
  'weight' => '1',
  'label' => 'Text Field',
  'widget_type' => 'text_textfield',
  'widget_settings' => 'a:4:{s:4:"rows";i:5;s:4:"size";s:2:"60";s:13:"default_value";a:1:{i:0;a:2:{s:5:"value";s:22:"text for default value";s:14:"_error_element";s:42:"default_value_widget][field_test][0][value";}}s:17:"default_value_php";N;}',
  'display_settings' => 'a:7:{s:6:"weight";s:1:"1";s:6:"parent";s:0:"";i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:5:"label";a:1:{s:6:"format";s:5:"above";}s:6:"teaser";a:2:{s:6:"format";s:7:"trimmed";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:7:"trimmed";s:7:"exclude";i:0;}}',
  'description' => 'An example text field.',
  'widget_module' => 'text',
  'widget_active' => '1',
))
->values(array(
  'field_name' => 'field_test',
  'type_name' => 'test_page',
  'weight' => '35',
  'label' => 'Text Field',
  'widget_type' => 'text_textfield',
  'widget_settings' => 'a:4:{s:4:"rows";i:5;s:4:"size";s:2:"60";s:13:"default_value";a:1:{i:0;a:3:{s:5:"value";s:22:"text for default value";s:6:"format";s:1:"1";s:14:"_error_element";s:42:"default_value_widget][field_test][0][value";}}s:17:"default_value_php";N;}',
  'display_settings' => 'a:6:{s:6:"weight";s:2:"35";s:6:"parent";s:0:"";s:5:"label";a:1:{s:6:"format";s:5:"above";}s:6:"teaser";a:2:{s:6:"format";s:7:"trimmed";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}}',
  'description' => 'An example text field.',
  'widget_module' => 'text',
  'widget_active' => '1',
))
->values(array(
  'field_name' => 'field_test_date',
  'type_name' => 'story',
  'weight' => '10',
  'label' => 'Date Field',
  'widget_type' => 'date_select',
  'widget_settings' => 'a:10:{s:13:"default_value";s:5:"blank";s:18:"default_value_code";s:0:"";s:14:"default_value2";s:4:"same";s:19:"default_value_code2";s:0:"";s:12:"input_format";s:13:"m/d/Y - H:i:s";s:19:"input_format_custom";s:0:"";s:9:"increment";s:1:"1";s:10:"text_parts";a:0:{}s:10:"year_range";s:5:"-3:+3";s:14:"label_position";s:5:"above";}',
  'display_settings' => 'a:7:{s:6:"weight";s:2:"10";s:6:"parent";s:0:"";i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:5:"label";a:1:{s:6:"format";s:5:"above";}s:6:"teaser";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:4:"long";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}}',
  'description' => 'An example date field.',
  'widget_module' => 'date',
  'widget_active' => '1',
))
->values(array(
  'field_name' => 'field_test_datestamp',
  'type_name' => 'story',
  'weight' => '11',
  'label' => 'Date Stamp Field',
  'widget_type' => 'date_text',
  'widget_settings' => 'a:10:{s:13:"default_value";s:5:"blank";s:18:"default_value_code";s:0:"";s:14:"default_value2";s:4:"same";s:19:"default_value_code2";s:0:"";s:12:"input_format";s:13:"m/d/Y - H:i:s";s:19:"input_format_custom";s:0:"";s:9:"increment";s:1:"1";s:10:"text_parts";a:0:{}s:10:"year_range";s:5:"-3:+3";s:14:"label_position";s:5:"above";}',
  'display_settings' => 'a:7:{s:6:"weight";s:2:"11";s:6:"parent";s:0:"";i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:5:"label";a:1:{s:6:"format";s:5:"above";}s:6:"teaser";a:2:{s:6:"format";s:6:"medium";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}}',
  'description' => 'An example date stamp field.',
  'widget_module' => 'date',
  'widget_active' => '1',
))
->values(array(
  'field_name' => 'field_test_datetime',
  'type_name' => 'story',
  'weight' => '12',
  'label' => 'Datetime Field',
  'widget_type' => 'date_popup',
  'widget_settings' => 'a:10:{s:13:"default_value";s:5:"blank";s:18:"default_value_code";s:0:"";s:14:"default_value2";s:4:"same";s:19:"default_value_code2";s:0:"";s:12:"input_format";s:11:"d/m/Y H:i:s";s:19:"input_format_custom";s:0:"";s:9:"increment";s:1:"1";s:10:"text_parts";a:0:{}s:10:"year_range";s:5:"-3:+3";s:14:"label_position";s:5:"above";}',
  'display_settings' => 'a:7:{s:6:"weight";s:2:"12";s:6:"parent";s:0:"";i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:5:"label";a:1:{s:6:"format";s:5:"above";}s:6:"teaser";a:2:{s:6:"format";s:5:"short";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}}',
  'description' => 'An example datetime field.',
  'widget_module' => 'date',
  'widget_active' => '1',
))
->values(array(
  'field_name' => 'field_test_decimal_radio_buttons',
  'type_name' => 'story',
  'weight' => '14',
  'label' => 'Decimal Radio Buttons Field',
  'widget_type' => 'optionwidgets_buttons',
  'widget_settings' => 'a:2:{s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";s:0:"";}}s:17:"default_value_php";N;}',
  'display_settings' => 'a:7:{s:6:"weight";s:2:"14";s:6:"parent";s:0:"";i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:5:"label";a:1:{s:6:"format";s:5:"above";}s:6:"teaser";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}}',
  'description' => 'An example decimal field using radio buttons.',
  'widget_module' => 'optionwidgets',
  'widget_active' => '1',
))
->values(array(
  'field_name' => 'field_test_email',
  'type_name' => 'story',
  'weight' => '6',
  'label' => 'Email Field',
  'widget_type' => 'email_textfield',
  'widget_settings' => 'a:3:{s:4:"size";s:2:"60";s:13:"default_value";a:1:{i:0;a:1:{s:5:"email";s:17:"benjy@example.com";}}s:17:"default_value_php";N;}',
  'display_settings' => 'a:7:{s:6:"weight";s:1:"6";s:6:"parent";s:0:"";i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:5:"label";a:1:{s:6:"format";s:5:"above";}s:6:"teaser";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}}',
  'description' => 'An example email field.',
  'widget_module' => 'email',
  'widget_active' => '1',
))
->values(array(
  'field_name' => 'field_test_exclude_unset',
  'type_name' => 'story',
  'weight' => '0',
  'label' => 'Text Field',
  'widget_type' => 'text_textfield',
  'widget_settings' => 'a:4:{s:4:"rows";i:5;s:4:"size";s:2:"60";s:13:"default_value";a:1:{i:0;a:2:{s:5:"value";s:22:"text for default value";s:14:"_error_element";s:42:"default_value_widget][field_test][0][value";}}s:17:"default_value_php";N;}',
  'display_settings' => 'a:8:{s:6:"weight";i:0;s:6:"parent";s:0:"";i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:5:"label";a:1:{s:6:"format";s:5:"above";}s:6:"teaser";a:2:{s:6:"format";s:7:"trimmed";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:7:"trimmed";s:7:"exclude";i:0;}i:1;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}}',
  'description' => 'An example text field without exclude.',
  'widget_module' => 'text',
  'widget_active' => '1',
))
->values(array(
  'field_name' => 'field_test_filefield',
  'type_name' => 'story',
  'weight' => '8',
  'label' => 'File Field',
  'widget_type' => 'filefield_widget',
  'widget_settings' => 'a:5:{s:15:"file_extensions";s:11:"txt pdf doc";s:9:"file_path";s:6:"images";s:18:"progress_indicator";s:3:"bar";s:21:"max_filesize_per_file";s:4:"200K";s:21:"max_filesize_per_node";s:3:"20M";}',
  'display_settings' => 'a:7:{s:6:"weight";s:1:"8";s:6:"parent";s:0:"";i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:5:"label";a:1:{s:6:"format";s:5:"above";}s:6:"teaser";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:10:"path_plain";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}}',
  'description' => 'An example image field.',
  'widget_module' => 'filefield',
  'widget_active' => '1',
))
->values(array(
  'field_name' => 'field_test_float_single_checkbox',
  'type_name' => 'story',
  'weight' => '15',
  'label' => 'Float Single Checkbox Field',
  'widget_type' => 'optionwidgets_onoff',
  'widget_settings' => 'a:2:{s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";N;}}s:17:"default_value_php";N;}',
  'display_settings' => 'a:7:{s:6:"weight";s:2:"15";s:6:"parent";s:0:"";i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:5:"label";a:1:{s:6:"format";s:5:"above";}s:6:"teaser";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}}',
  'description' => 'An example float field using a single on/off checkbox.',
  'widget_module' => 'optionwidgets',
  'widget_active' => '1',
))
->values(array(
  'field_name' => 'field_test_four',
  'type_name' => 'story',
  'weight' => '3',
  'label' => 'Float Field',
  'widget_type' => 'number',
  'widget_settings' => 'a:2:{s:13:"default_value";a:1:{i:0;a:2:{s:5:"value";s:3:"101";s:14:"_error_element";s:47:"default_value_widget][field_test_four][0][value";}}s:17:"default_value_php";N;}',
  'display_settings' => 'a:7:{s:6:"weight";s:1:"3";s:6:"parent";s:0:"";i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:5:"label";a:1:{s:6:"format";s:5:"above";}s:6:"teaser";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}}',
  'description' => 'An example float field.',
  'widget_module' => 'number',
  'widget_active' => '1',
))
->values(array(
  'field_name' => 'field_test_identical1',
  'type_name' => 'story',
  'weight' => '4',
  'label' => 'Integer Field',
  'widget_type' => 'number',
  'widget_settings' => 'a:2:{s:13:"default_value";a:1:{i:0;a:2:{s:5:"value";s:0:"";s:14:"_error_element";s:41:"default_value_widget][field_int][0][value";}}s:17:"default_value_php";N;}',
  'display_settings' => 'a:7:{s:6:"weight";s:1:"4";s:6:"parent";s:0:"";i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:5:"label";a:1:{s:6:"format";s:5:"above";}s:6:"teaser";a:2:{s:6:"format";s:11:"unformatted";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:11:"unformatted";s:7:"exclude";i:0;}}',
  'description' => 'An example integer field.',
  'widget_module' => 'number',
  'widget_active' => '1',
))
->values(array(
  'field_name' => 'field_test_identical2',
  'type_name' => 'story',
  'weight' => '5',
  'label' => 'Integer Field',
  'widget_type' => 'number',
  'widget_settings' => 'a:2:{s:13:"default_value";a:1:{i:0;a:2:{s:5:"value";s:0:"";s:14:"_error_element";s:41:"default_value_widget][field_int][0][value";}}s:17:"default_value_php";N;}',
  'display_settings' => 'a:7:{s:6:"weight";s:1:"5";s:6:"parent";s:0:"";i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:5:"label";a:1:{s:6:"format";s:5:"above";}s:6:"teaser";a:2:{s:6:"format";s:11:"unformatted";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:11:"unformatted";s:7:"exclude";i:0;}}',
  'description' => 'An example integer field.',
  'widget_module' => 'number',
  'widget_active' => '1',
))
->values(array(
  'field_name' => 'field_test_imagefield',
  'type_name' => 'story',
  'weight' => '9',
  'label' => 'Image Field',
  'widget_type' => 'imagefield_widget',
  'widget_settings' => 'a:14:{s:15:"file_extensions";s:16:"png gif jpg jpeg";s:9:"file_path";s:0:"";s:18:"progress_indicator";s:3:"bar";s:21:"max_filesize_per_file";s:0:"";s:21:"max_filesize_per_node";s:0:"";s:14:"max_resolution";s:1:"0";s:14:"min_resolution";s:1:"0";s:3:"alt";s:8:"Test alt";s:10:"custom_alt";i:0;s:5:"title";s:10:"Test title";s:12:"custom_title";i:0;s:10:"title_type";s:9:"textfield";s:13:"default_image";N;s:17:"use_default_image";i:0;}',
  'display_settings' => 'a:7:{s:6:"weight";s:1:"9";s:6:"parent";s:0:"";i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:5:"label";a:1:{s:6:"format";s:5:"above";}s:6:"teaser";a:2:{s:6:"format";s:15:"image_imagelink";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:11:"image_plain";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}}',
  'description' => 'An example image field.',
  'widget_module' => 'imagefield',
  'widget_active' => '1',
))
->values(array(
  'field_name' => 'field_test_integer_selectlist',
  'type_name' => 'story',
  'weight' => '16',
  'label' => 'Integer Select List Field',
  'widget_type' => 'optionwidgets_select',
  'widget_settings' => 'a:2:{s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";s:0:"";}}s:17:"default_value_php";N;}',
  'display_settings' => 'a:7:{s:6:"weight";s:2:"16";s:6:"parent";s:0:"";i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:5:"label";a:1:{s:6:"format";s:5:"above";}s:6:"teaser";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}}',
  'description' => 'An example integer field using a select list.',
  'widget_module' => 'optionwidgets',
  'widget_active' => '1',
))
->values(array(
  'field_name' => 'field_test_link',
  'type_name' => 'story',
  'weight' => '7',
  'label' => 'Link Field',
  'widget_type' => 'link',
  'widget_settings' => 'a:2:{s:13:"default_value";a:1:{i:0;a:2:{s:5:"title";s:18:"default link title";s:3:"url";s:22:"https://www.drupal.org";}}s:17:"default_value_php";N;}',
  'display_settings' => 'a:7:{s:6:"weight";s:1:"7";s:6:"parent";s:0:"";i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:5:"label";a:1:{s:6:"format";s:5:"above";}s:6:"teaser";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:8:"absolute";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}}',
  'description' => 'An example link field.',
  'widget_module' => 'link',
  'widget_active' => '1',
))
->values(array(
  'field_name' => 'field_test_phone',
  'type_name' => 'story',
  'weight' => '13',
  'label' => 'Phone Field',
  'widget_type' => 'phone_textfield',
  'widget_settings' => 'a:3:{s:4:"size";s:2:"60";s:13:"default_value";a:1:{i:0;a:2:{s:5:"value";s:0:"";s:14:"_error_element";s:48:"default_value_widget][field_test_phone][0][value";}}s:17:"default_value_php";N;}',
  'display_settings' => 'a:7:{s:6:"weight";s:2:"13";s:6:"parent";s:0:"";i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:5:"label";a:1:{s:6:"format";s:5:"above";}s:6:"teaser";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}}',
  'description' => 'An example phone field.',
  'widget_module' => 'phone',
  'widget_active' => '1',
))
->values(array(
  'field_name' => 'field_test_string_selectlist',
  'type_name' => 'story',
  'weight' => '31',
  'label' => 'String Select List Field',
  'widget_type' => 'optionwidgets_select',
  'widget_settings' => 'a:2:{s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";s:0:"";}}s:17:"default_value_php";N;}',
  'display_settings' => 'a:5:{s:5:"label";a:2:{s:6:"format";s:5:"above";s:7:"exclude";i:0;}i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:6:"teaser";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}}',
  'description' => '',
  'widget_module' => 'optionwidgets',
  'widget_active' => '1',
))
->values(array(
  'field_name' => 'field_test_text_single_checkbox',
  'type_name' => 'story',
  'weight' => '17',
  'label' => 'Text Single Checkbox Field',
  'widget_type' => 'optionwidgets_onoff',
  'widget_settings' => 'a:2:{s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";s:1:"a";}}s:17:"default_value_php";N;}',
  'display_settings' => 'a:7:{s:6:"weight";s:2:"17";s:6:"parent";s:0:"";i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:5:"label";a:1:{s:6:"format";s:5:"above";}s:6:"teaser";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}}',
  'description' => 'An example text field using a single on/off checkbox.',
  'widget_module' => 'optionwidgets',
  'widget_active' => '1',
))
->values(array(
  'field_name' => 'field_test_text_single_checkbox',
  'type_name' => 'test_planet',
  'weight' => '32',
  'label' => 'Text Single Checkbox Field',
  'widget_type' => 'text_textfield',
  'widget_settings' => 'a:4:{s:13:"default_value";a:1:{i:0;a:2:{s:5:"value";s:1:"0";s:14:"_error_element";s:63:"default_value_widget][field_test_text_single_checkbox][0][value";}}s:17:"default_value_php";N;s:4:"rows";i:5;s:4:"size";s:3:"255";}',
  'display_settings' => 'a:7:{s:6:"weight";s:2:"32";s:6:"parent";s:0:"";s:5:"label";a:1:{s:6:"format";s:5:"above";}s:6:"teaser";a:2:{s:6:"format";s:6:"hidden";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}}',
  'description' => 'An example text field using a single on/off checkbox.',
  'widget_module' => 'text',
  'widget_active' => '1',
))
->values(array(
  'field_name' => 'field_test_text_single_checkbox2',
  'type_name' => 'story',
  'weight' => '19',
  'label' => 'Text Single Checkbox Field 2',
  'widget_type' => 'optionwidgets_onoff',
  'widget_settings' => 'a:2:{s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";N;}}s:17:"default_value_php";N;}',
  'display_settings' => 'a:5:{s:5:"label";a:2:{s:6:"format";s:5:"above";s:7:"exclude";i:0;}i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:6:"teaser";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}}',
  'description' => 'Checkbox that uses keys only and no label.',
  'widget_module' => 'optionwidgets',
  'widget_active' => '1',
))
->values(array(
  'field_name' => 'field_test_three',
  'type_name' => 'story',
  'weight' => '2',
  'label' => 'Decimal Field',
  'widget_type' => 'number',
  'widget_settings' => 'a:2:{s:13:"default_value";a:1:{i:0;a:2:{s:5:"value";d:101;s:14:"_error_element";s:48:"default_value_widget][field_test_three][0][value";}}s:17:"default_value_php";N;}',
  'display_settings' => 'a:7:{s:6:"weight";s:1:"2";s:6:"parent";s:0:"";i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:5:"label";a:1:{s:6:"format";s:5:"above";}s:6:"teaser";a:2:{s:6:"format";s:11:"unformatted";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:4:"us_2";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:11:"unformatted";s:7:"exclude";i:0;}}',
  'description' => 'An example decimal field.',
  'widget_module' => 'number',
  'widget_active' => '1',
))
->values(array(
  'field_name' => 'field_test_two',
  'type_name' => 'story',
  'weight' => '1',
  'label' => 'Integer Field',
  'widget_type' => 'number',
  'widget_settings' => 'a:2:{s:13:"default_value";a:1:{i:0;a:2:{s:5:"value";s:0:"";s:14:"_error_element";s:46:"default_value_widget][field_test_two][0][value";}}s:17:"default_value_php";N;}',
  'display_settings' => 'a:7:{s:6:"weight";s:1:"1";s:6:"parent";s:0:"";i:5;a:2:{s:6:"format";s:7:"default";s:7:"exclude";i:0;}s:5:"label";a:1:{s:6:"format";s:5:"above";}s:6:"teaser";a:2:{s:6:"format";s:4:"us_0";s:7:"exclude";i:0;}s:4:"full";a:2:{s:6:"format";s:4:"us_0";s:7:"exclude";i:0;}i:4;a:2:{s:6:"format";s:11:"unformatted";s:7:"exclude";i:0;}}',
  'description' => 'An example integer field.',
  'widget_module' => 'number',
  'widget_active' => '1',
))
->execute();
$connection->schema()->createTable('content_type_employee', array(
  'fields' => array(
    'vid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'field_commander_uid' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'field_company_2_nid' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'field_company_3_nid' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'field_sync_email' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'vid',
  ),
  'indexes' => array(
    'nid' => array(
      'nid',
    ),
    'field_commander_uid' => array(
      'field_commander_uid',
    ),
    'field_company_2_nid' => array(
      'field_company_2_nid',
    ),
    'field_company_3_nid' => array(
      'field_company_3_nid',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('content_type_employee')
->fields(array(
  'vid',
  'nid',
  'field_commander_uid',
  'field_company_2_nid',
  'field_company_3_nid',
  'field_sync_email',
))
->values(array(
  'vid' => '21',
  'nid' => '18',
  'field_commander_uid' => '8',
  'field_company_2_nid' => '15',
  'field_company_3_nid' => '16',
  'field_sync_email' => NULL,
))
->values(array(
  'vid' => '2002',
  'nid' => '21',
  'field_commander_uid' => NULL,
  'field_company_2_nid' => NULL,
  'field_company_3_nid' => NULL,
  'field_sync_email' => 'jsmith@example.com',
))
->values(array(
  'vid' => '2003',
  'nid' => '22',
  'field_commander_uid' => NULL,
  'field_company_2_nid' => NULL,
  'field_company_3_nid' => NULL,
  'field_sync_email' => 'jsmith@example.com',
))
->execute();
$connection->schema()->createTable('content_type_page', array(
  'fields' => array(
    'vid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'field_text_field_value' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'field_reference_nid' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'field_reference_2_nid' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'vid',
  ),
  'indexes' => array(
    'field_reference_nid' => array(
      'field_reference_nid',
    ),
    'field_reference_2_nid' => array(
      'field_reference_2_nid',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('content_type_page')
->fields(array(
  'vid',
  'nid',
  'field_text_field_value',
  'field_reference_nid',
  'field_reference_2_nid',
))
->values(array(
  'vid' => '13',
  'nid' => '10',
  'field_text_field_value' => NULL,
  'field_reference_nid' => '13',
  'field_reference_2_nid' => '13',
))
->values(array(
  'vid' => '14',
  'nid' => '11',
  'field_text_field_value' => NULL,
  'field_reference_nid' => '20',
  'field_reference_2_nid' => '20',
))
->values(array(
  'vid' => '16',
  'nid' => '13',
  'field_text_field_value' => NULL,
  'field_reference_nid' => '10',
  'field_reference_2_nid' => '10',
))
->values(array(
  'vid' => '23',
  'nid' => '20',
  'field_text_field_value' => NULL,
  'field_reference_nid' => '11',
  'field_reference_2_nid' => '11',
))
->execute();
$connection->schema()->createTable('content_type_story', array(
  'fields' => array(
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'vid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'field_test_three_value' => array(
      'type' => 'numeric',
      'not null' => FALSE,
      'precision' => '10',
      'scale' => '2',
    ),
    'field_test_identical1_value' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'field_test_identical2_value' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'field_test_link_url' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '2048',
    ),
    'field_test_link_title' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
    'field_test_link_attributes' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'field_test_date_value' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '20',
    ),
    'field_test_datestamp_value' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'field_test_datetime_value' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '100',
    ),
    'field_test_email_email' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
    'field_test_filefield_fid' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'field_test_filefield_list' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'field_test_filefield_data' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'field_test_four_value' => array(
      'type' => 'numeric',
      'not null' => FALSE,
      'precision' => '10',
      'scale' => '0',
    ),
    'field_test_integer_selectlist_value' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'field_test_float_single_checkbox_value' => array(
      'type' => 'numeric',
      'not null' => FALSE,
      'precision' => '10',
      'scale' => '0',
    ),
    'field_test_decimal_radio_buttons_value' => array(
      'type' => 'numeric',
      'not null' => FALSE,
      'precision' => '10',
      'scale' => '2',
    ),
    'field_test_phone_value' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '255',
    ),
    'field_test_exclude_unset_value' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'field_test_exclude_unset_format' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'field_test_imagefield_fid' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'field_test_imagefield_list' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'field_test_imagefield_data' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'field_test_text_single_checkbox2_value' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
    'field_test_datestamp_value2' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'field_test_datetime_value2' => array(
      'type' => 'varchar',
      'not null' => FALSE,
      'length' => '100',
    ),
    'field_test_string_selectlist_value' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'big',
    ),
  ),
  'primary key' => array(
    'vid',
  ),
  'indexes' => array(
    'nid' => array(
      'nid',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('content_type_story')
->fields(array(
  'nid',
  'vid',
  'uid',
  'field_test_three_value',
  'field_test_identical1_value',
  'field_test_identical2_value',
  'field_test_link_url',
  'field_test_link_title',
  'field_test_link_attributes',
  'field_test_date_value',
  'field_test_datestamp_value',
  'field_test_datetime_value',
  'field_test_email_email',
  'field_test_filefield_fid',
  'field_test_filefield_list',
  'field_test_filefield_data',
  'field_test_four_value',
  'field_test_integer_selectlist_value',
  'field_test_float_single_checkbox_value',
  'field_test_decimal_radio_buttons_value',
  'field_test_phone_value',
  'field_test_exclude_unset_value',
  'field_test_exclude_unset_format',
  'field_test_imagefield_fid',
  'field_test_imagefield_list',
  'field_test_imagefield_data',
  'field_test_text_single_checkbox2_value',
  'field_test_datestamp_value2',
  'field_test_datetime_value2',
  'field_test_string_selectlist_value',
))
->values(array(
  'nid' => '1',
  'vid' => '1',
  'uid' => '1',
  'field_test_three_value' => '42.42',
  'field_test_identical1_value' => '1',
  'field_test_identical2_value' => '1',
  'field_test_link_url' => 'https://www.drupal.org/project/drupal',
  'field_test_link_title' => 'Drupal project page',
  'field_test_link_attributes' => 's:32:"a:1:{s:6:"target";s:6:"_blank";}";',
  'field_test_date_value' => '2013-01-02T04:05:00',
  'field_test_datestamp_value' => '1391357160',
  'field_test_datetime_value' => '2015-03-04 06:07:00',
  'field_test_email_email' => 'PrincessRuwenne@example.com',
  'field_test_filefield_fid' => '5',
  'field_test_filefield_list' => '1',
  'field_test_filefield_data' => 'a:1:{s:11:"description";s:4:"desc";}',
  'field_test_four_value' => NULL,
  'field_test_integer_selectlist_value' => '3412',
  'field_test_float_single_checkbox_value' => '3',
  'field_test_decimal_radio_buttons_value' => NULL,
  'field_test_phone_value' => NULL,
  'field_test_exclude_unset_value' => 'This is a field with exclude unset.',
  'field_test_exclude_unset_format' => '1',
  'field_test_imagefield_fid' => NULL,
  'field_test_imagefield_list' => NULL,
  'field_test_imagefield_data' => NULL,
  'field_test_text_single_checkbox2_value' => 'Hello',
  'field_test_datestamp_value2' => NULL,
  'field_test_datetime_value2' => NULL,
  'field_test_string_selectlist_value' => NULL,
))
->values(array(
  'nid' => '1',
  'vid' => '2',
  'uid' => '1',
  'field_test_three_value' => '42.42',
  'field_test_identical1_value' => '1',
  'field_test_identical2_value' => '1',
  'field_test_link_url' => 'https://www.drupal.org/project/drupal',
  'field_test_link_title' => 'Drupal project page',
  'field_test_link_attributes' => 's:32:"a:1:{s:6:"target";s:6:"_blank";}";',
  'field_test_date_value' => '2013-01-02T04:05:00',
  'field_test_datestamp_value' => '1391357160',
  'field_test_datetime_value' => '2015-03-04 06:07:00',
  'field_test_email_email' => 'PrincessRuwenne@example.com',
  'field_test_filefield_fid' => NULL,
  'field_test_filefield_list' => NULL,
  'field_test_filefield_data' => NULL,
  'field_test_four_value' => NULL,
  'field_test_integer_selectlist_value' => NULL,
  'field_test_float_single_checkbox_value' => NULL,
  'field_test_decimal_radio_buttons_value' => NULL,
  'field_test_phone_value' => NULL,
  'field_test_exclude_unset_value' => NULL,
  'field_test_exclude_unset_format' => NULL,
  'field_test_imagefield_fid' => NULL,
  'field_test_imagefield_list' => NULL,
  'field_test_imagefield_data' => NULL,
  'field_test_text_single_checkbox2_value' => NULL,
  'field_test_datestamp_value2' => NULL,
  'field_test_datetime_value2' => NULL,
  'field_test_string_selectlist_value' => NULL,
))
->values(array(
  'nid' => '2',
  'vid' => '3',
  'uid' => '1',
  'field_test_three_value' => '23.20',
  'field_test_identical1_value' => '1',
  'field_test_identical2_value' => '1',
  'field_test_link_url' => 'http://groups.drupal.org/',
  'field_test_link_title' => 'Drupal Groups',
  'field_test_link_attributes' => 's:6:"a:0:{}";',
  'field_test_date_value' => NULL,
  'field_test_datestamp_value' => NULL,
  'field_test_datetime_value' => NULL,
  'field_test_email_email' => NULL,
  'field_test_filefield_fid' => NULL,
  'field_test_filefield_list' => NULL,
  'field_test_filefield_data' => NULL,
  'field_test_four_value' => NULL,
  'field_test_integer_selectlist_value' => NULL,
  'field_test_float_single_checkbox_value' => NULL,
  'field_test_decimal_radio_buttons_value' => NULL,
  'field_test_phone_value' => NULL,
  'field_test_exclude_unset_value' => NULL,
  'field_test_exclude_unset_format' => NULL,
  'field_test_imagefield_fid' => NULL,
  'field_test_imagefield_list' => NULL,
  'field_test_imagefield_data' => NULL,
  'field_test_text_single_checkbox2_value' => NULL,
  'field_test_datestamp_value2' => NULL,
  'field_test_datetime_value2' => NULL,
  'field_test_string_selectlist_value' => NULL,
))
->values(array(
  'nid' => '2',
  'vid' => '5',
  'uid' => '1',
  'field_test_three_value' => '23.20',
  'field_test_identical1_value' => '1',
  'field_test_identical2_value' => '1',
  'field_test_link_url' => 'http://groups.drupal.org/',
  'field_test_link_title' => 'Drupal Groups',
  'field_test_link_attributes' => 's:6:"a:0:{}";',
  'field_test_date_value' => NULL,
  'field_test_datestamp_value' => NULL,
  'field_test_datetime_value' => NULL,
  'field_test_email_email' => NULL,
  'field_test_filefield_fid' => NULL,
  'field_test_filefield_list' => NULL,
  'field_test_filefield_data' => NULL,
  'field_test_four_value' => NULL,
  'field_test_integer_selectlist_value' => NULL,
  'field_test_float_single_checkbox_value' => NULL,
  'field_test_decimal_radio_buttons_value' => NULL,
  'field_test_phone_value' => NULL,
  'field_test_exclude_unset_value' => NULL,
  'field_test_exclude_unset_format' => NULL,
  'field_test_imagefield_fid' => NULL,
  'field_test_imagefield_list' => NULL,
  'field_test_imagefield_data' => NULL,
  'field_test_text_single_checkbox2_value' => NULL,
  'field_test_datestamp_value2' => NULL,
  'field_test_datetime_value2' => NULL,
  'field_test_string_selectlist_value' => NULL,
))
->values(array(
  'nid' => '9',
  'vid' => '12',
  'uid' => '0',
  'field_test_three_value' => '101.00',
  'field_test_identical1_value' => NULL,
  'field_test_identical2_value' => NULL,
  'field_test_link_url' => 'node/10',
  'field_test_link_title' => 'Buy it now',
  'field_test_link_attributes' => 's:32:"a:1:{s:6:"target";s:6:"_blank";}";',
  'field_test_date_value' => NULL,
  'field_test_datestamp_value' => NULL,
  'field_test_datetime_value' => NULL,
  'field_test_email_email' => NULL,
  'field_test_filefield_fid' => NULL,
  'field_test_filefield_list' => NULL,
  'field_test_filefield_data' => NULL,
  'field_test_four_value' => '101',
  'field_test_integer_selectlist_value' => NULL,
  'field_test_float_single_checkbox_value' => '3',
  'field_test_decimal_radio_buttons_value' => NULL,
  'field_test_phone_value' => NULL,
  'field_test_exclude_unset_value' => 'text for default value',
  'field_test_exclude_unset_format' => '1',
  'field_test_imagefield_fid' => '2',
  'field_test_imagefield_list' => '1',
  'field_test_imagefield_data' => 'a:2:{s:3:"alt";s:8:"Test alt";s:5:"title";s:10:"Test title";}',
  'field_test_text_single_checkbox2_value' => 'Off',
  'field_test_datestamp_value2' => '1391357160',
  'field_test_datetime_value2' => '2015-03-04 06:07:00',
  'field_test_string_selectlist_value' => NULL,
))
->execute();
$connection->schema()->createTable('content_type_test_page', array(
  'fields' => array(
    'vid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'field_test_value' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'field_test_format' => array(
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'vid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('content_type_test_planet', array(
  'fields' => array(
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'vid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'vid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('content_type_test_planet')
->fields(array(
  'nid',
  'vid',
))
->values(array(
  'nid' => '3',
  'vid' => '4',
))
->values(array(
  'nid' => '4',
  'vid' => '6',
))
->values(array(
  'nid' => '5',
  'vid' => '7',
))
->values(array(
  'nid' => '6',
  'vid' => '8',
))
->values(array(
  'nid' => '7',
  'vid' => '9',
))
->values(array(
  'nid' => '8',
  'vid' => '10',
))
->values(array(
  'nid' => '9',
  'vid' => '11',
))
->execute();
$connection->schema()->createTable('date_format_locale', array(
  'fields' => array(
    'format' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '100',
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '200',
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
    ),
  ),
  'primary key' => array(
    'type',
    'language',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('date_format_types', array(
  'fields' => array(
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '200',
    ),
    'title' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ),
    'locked' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'type',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('date_format_types')
->fields(array(
  'type',
  'title',
  'locked',
))
->values(array(
  'type' => 'long',
  'title' => 'Long',
  'locked' => '1',
))
->values(array(
  'type' => 'medium',
  'title' => 'Medium',
  'locked' => '1',
))
->values(array(
  'type' => 'short',
  'title' => 'Short',
  'locked' => '1',
))
->execute();
$connection->schema()->createTable('date_formats', array(
  'fields' => array(
    'dfid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'format' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '100',
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '200',
    ),
    'locked' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'dfid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('date_formats')
->fields(array(
  'dfid',
  'format',
  'type',
  'locked',
))
->values(array(
  'dfid' => '1',
  'format' => 'Y-m-d H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '2',
  'format' => 'm/d/Y - H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '3',
  'format' => 'd/m/Y - H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '4',
  'format' => 'Y/m/d - H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '5',
  'format' => 'd.m.Y - H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '6',
  'format' => 'm/d/Y - g:ia',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '7',
  'format' => 'd/m/Y - g:ia',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '8',
  'format' => 'Y/m/d - g:ia',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '9',
  'format' => 'M j Y - H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '10',
  'format' => 'j M Y - H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '11',
  'format' => 'Y M j - H:i',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '12',
  'format' => 'M j Y - g:ia',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '13',
  'format' => 'j M Y - g:ia',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '14',
  'format' => 'Y M j - g:ia',
  'type' => 'short',
  'locked' => '1',
))
->values(array(
  'dfid' => '15',
  'format' => 'D, Y-m-d H:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '16',
  'format' => 'D, m/d/Y - H:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '17',
  'format' => 'D, d/m/Y - H:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '18',
  'format' => 'D, Y/m/d - H:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '19',
  'format' => 'F j, Y - H:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '20',
  'format' => 'j F, Y - H:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '21',
  'format' => 'Y, F j - H:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '22',
  'format' => 'D, m/d/Y - g:ia',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '23',
  'format' => 'D, d/m/Y - g:ia',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '24',
  'format' => 'D, Y/m/d - g:ia',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '25',
  'format' => 'F j, Y - g:ia',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '26',
  'format' => 'j F Y - g:ia',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '27',
  'format' => 'Y, F j - g:ia',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '28',
  'format' => 'j. F Y - G:i',
  'type' => 'medium',
  'locked' => '1',
))
->values(array(
  'dfid' => '29',
  'format' => 'l, F j, Y - H:i',
  'type' => 'long',
  'locked' => '1',
))
->values(array(
  'dfid' => '30',
  'format' => 'l, j F, Y - H:i',
  'type' => 'long',
  'locked' => '1',
))
->values(array(
  'dfid' => '31',
  'format' => 'l, Y,  F j - H:i',
  'type' => 'long',
  'locked' => '1',
))
->values(array(
  'dfid' => '32',
  'format' => 'l, F j, Y - g:ia',
  'type' => 'long',
  'locked' => '1',
))
->values(array(
  'dfid' => '33',
  'format' => 'l, j F Y - g:ia',
  'type' => 'long',
  'locked' => '1',
))
->values(array(
  'dfid' => '34',
  'format' => 'l, Y,  F j - g:ia',
  'type' => 'long',
  'locked' => '1',
))
->values(array(
  'dfid' => '35',
  'format' => 'l, j. F Y - G:i',
  'type' => 'long',
  'locked' => '1',
))
->execute();
$connection->schema()->createTable('event', array(
  'fields' => array(
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'event_start' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '100',
    ),
    'event_end' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '100',
    ),
    'timezone' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'start_in_dst' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'end_in_dst' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'has_time' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '1',
    ),
    'has_end_date' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '1',
    ),
  ),
  'primary key' => array(
    'nid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('event_timezones', array(
  'fields' => array(
    'timezone' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'offset' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '100',
      'default' => '00:00:00',
    ),
    'offset_dst' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '100',
      'default' => '00:00:00',
    ),
    'dst_region' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'is_dst' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'timezone',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('event_timezones')
->fields(array(
  'timezone',
  'name',
  'offset',
  'offset_dst',
  'dst_region',
  'is_dst',
))
->values(array(
  'timezone' => '1',
  'name' => 'Africa/Addis Ababa',
  'offset' => '03:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '2',
  'name' => 'Africa/Algiers',
  'offset' => '01:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '3',
  'name' => 'Africa/Asmera',
  'offset' => '03:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '4',
  'name' => 'Africa/Bangui',
  'offset' => '01:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '5',
  'name' => 'Africa/Blantyre',
  'offset' => '02:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '6',
  'name' => 'Africa/Brazzaville',
  'offset' => '01:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '7',
  'name' => 'Africa/Bujumbura',
  'offset' => '02:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '8',
  'name' => 'Africa/Cairo',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '1',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '9',
  'name' => 'Africa/Ceuta',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '1',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '10',
  'name' => 'Africa/Dar es Salaam',
  'offset' => '03:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '11',
  'name' => 'Africa/Djibouti',
  'offset' => '03:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '12',
  'name' => 'Africa/Douala',
  'offset' => '01:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '13',
  'name' => 'Africa/Gaborone',
  'offset' => '02:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '14',
  'name' => 'Africa/Harare',
  'offset' => '02:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '15',
  'name' => 'Africa/Johannesburg',
  'offset' => '02:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '16',
  'name' => 'Africa/Kampala',
  'offset' => '03:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '17',
  'name' => 'Africa/Khartoum',
  'offset' => '03:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '18',
  'name' => 'Africa/Kigali',
  'offset' => '02:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '19',
  'name' => 'Africa/Kinshasa',
  'offset' => '01:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '20',
  'name' => 'Africa/Lagos',
  'offset' => '01:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '21',
  'name' => 'Africa/Libreville',
  'offset' => '01:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '22',
  'name' => 'Africa/Luanda',
  'offset' => '01:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '23',
  'name' => 'Africa/Lubumbashi',
  'offset' => '02:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '24',
  'name' => 'Africa/Lusaka',
  'offset' => '02:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '25',
  'name' => 'Africa/Malabo',
  'offset' => '01:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '26',
  'name' => 'Africa/Maputo',
  'offset' => '02:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '27',
  'name' => 'Africa/Maseru',
  'offset' => '02:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '28',
  'name' => 'Africa/Mbabane',
  'offset' => '02:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '29',
  'name' => 'Africa/Mogadishu',
  'offset' => '03:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '30',
  'name' => 'Africa/Nairobi',
  'offset' => '03:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '31',
  'name' => 'Africa/Ndjamena',
  'offset' => '01:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '32',
  'name' => 'Africa/Niamey',
  'offset' => '01:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '33',
  'name' => 'Africa/Porto-Novo',
  'offset' => '01:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '34',
  'name' => 'Africa/Tripoli',
  'offset' => '02:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '35',
  'name' => 'Africa/Tunis',
  'offset' => '01:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '36',
  'name' => 'Africa/Windhoek',
  'offset' => '02:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '2',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '37',
  'name' => 'America/Adak',
  'offset' => '-10:00:00',
  'offset_dst' => '-09:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '38',
  'name' => 'America/Anchorage',
  'offset' => '-09:00:00',
  'offset_dst' => '-08:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '39',
  'name' => 'America/Anguilla',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '40',
  'name' => 'America/Antigua',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '41',
  'name' => 'America/Araguaina',
  'offset' => '-02:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '17',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '42',
  'name' => 'America/Aruba',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '43',
  'name' => 'America/Asuncion',
  'offset' => '-03:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '20',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '44',
  'name' => 'America/Atka',
  'offset' => '-10:00:00',
  'offset_dst' => '-09:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '45',
  'name' => 'America/Barbados',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '46',
  'name' => 'America/Belem',
  'offset' => '-03:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '47',
  'name' => 'America/Belize',
  'offset' => '-06:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '48',
  'name' => 'America/Boa Vista',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '49',
  'name' => 'America/Bogota',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '50',
  'name' => 'America/Boise',
  'offset' => '-07:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '51',
  'name' => 'America/Buenos Aires',
  'offset' => '-03:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '52',
  'name' => 'America/Cambridge Bay',
  'offset' => '-07:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '53',
  'name' => 'America/Cancun',
  'offset' => '-06:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '54',
  'name' => 'America/Caracas',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '55',
  'name' => 'America/Catamarca',
  'offset' => '-03:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '56',
  'name' => 'America/Cayenne',
  'offset' => '-03:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '57',
  'name' => 'America/Cayman',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '58',
  'name' => 'America/Chicago',
  'offset' => '-06:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '59',
  'name' => 'America/Chihuahua',
  'offset' => '-07:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '60',
  'name' => 'America/Cordoba',
  'offset' => '-03:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '61',
  'name' => 'America/Costa Rica',
  'offset' => '-06:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '62',
  'name' => 'America/Cuiaba',
  'offset' => '-03:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '17',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '63',
  'name' => 'America/Curacao',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '64',
  'name' => 'America/Dawson',
  'offset' => '-08:00:00',
  'offset_dst' => '-07:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '65',
  'name' => 'America/Dawson Creek',
  'offset' => '-07:00:00',
  'offset_dst' => '-07:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '66',
  'name' => 'America/Denver',
  'offset' => '-07:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '67',
  'name' => 'America/Detroit',
  'offset' => '-05:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '68',
  'name' => 'America/Dominica',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '69',
  'name' => 'America/Edmonton',
  'offset' => '-07:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '70',
  'name' => 'America/Eirunepe',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '71',
  'name' => 'America/El Salvador',
  'offset' => '-06:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '72',
  'name' => 'America/Ensenada',
  'offset' => '-08:00:00',
  'offset_dst' => '-07:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '73',
  'name' => 'America/Fort Wayne',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '74',
  'name' => 'America/Fortaleza',
  'offset' => '-03:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '75',
  'name' => 'America/Glace Bay',
  'offset' => '-04:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '76',
  'name' => 'America/Godthab',
  'offset' => '-03:00:00',
  'offset_dst' => '-02:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '77',
  'name' => 'America/Goose Bay',
  'offset' => '-04:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '78',
  'name' => 'America/Grand Turk',
  'offset' => '-05:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '16',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '79',
  'name' => 'America/Grenada',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '80',
  'name' => 'America/Guadeloupe',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '81',
  'name' => 'America/Guatemala',
  'offset' => '-06:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '82',
  'name' => 'America/Guayaquil',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '83',
  'name' => 'America/Guyana',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '84',
  'name' => 'America/Halifax',
  'offset' => '-04:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '85',
  'name' => 'America/Havana',
  'offset' => '-05:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '16',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '86',
  'name' => 'America/Hermosillo',
  'offset' => '-07:00:00',
  'offset_dst' => '-07:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '87',
  'name' => 'America/Indiana/Indianapolis',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '88',
  'name' => 'America/Indiana/Knox',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '89',
  'name' => 'America/Indiana/Marengo',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '90',
  'name' => 'America/Indiana/Vevay',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '91',
  'name' => 'America/Indianapolis',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '92',
  'name' => 'America/Inuvik',
  'offset' => '-07:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '93',
  'name' => 'America/Iqaluit',
  'offset' => '-05:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '94',
  'name' => 'America/Jamaica',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '95',
  'name' => 'America/Jujuy',
  'offset' => '-03:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '96',
  'name' => 'America/Juneau',
  'offset' => '-09:00:00',
  'offset_dst' => '-08:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '97',
  'name' => 'America/Kentucky/Louisville',
  'offset' => '-05:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '98',
  'name' => 'America/Kentucky/Monticello',
  'offset' => '-05:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '99',
  'name' => 'America/Knox IN',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '100',
  'name' => 'America/La Paz',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '101',
  'name' => 'America/Lima',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '102',
  'name' => 'America/Los Angeles',
  'offset' => '-08:00:00',
  'offset_dst' => '-07:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '103',
  'name' => 'America/Louisville',
  'offset' => '-05:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '104',
  'name' => 'America/Maceio',
  'offset' => '-03:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '105',
  'name' => 'America/Managua',
  'offset' => '-06:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '106',
  'name' => 'America/Manaus',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '107',
  'name' => 'America/Martinique',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '108',
  'name' => 'America/Mazatlan',
  'offset' => '-07:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '109',
  'name' => 'America/Mendoza',
  'offset' => '-03:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '110',
  'name' => 'America/Menominee',
  'offset' => '-06:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '111',
  'name' => 'America/Merida',
  'offset' => '-06:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '112',
  'name' => 'America/Mexico City',
  'offset' => '-06:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '113',
  'name' => 'America/Miquelon',
  'offset' => '-03:00:00',
  'offset_dst' => '-02:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '114',
  'name' => 'America/Monterrey',
  'offset' => '-06:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '115',
  'name' => 'America/Montevideo',
  'offset' => '-03:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '116',
  'name' => 'America/Montreal',
  'offset' => '-05:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '117',
  'name' => 'America/Montserrat',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '118',
  'name' => 'America/Nassau',
  'offset' => '-05:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '119',
  'name' => 'America/New York',
  'offset' => '-05:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '120',
  'name' => 'America/Nipigon',
  'offset' => '-05:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '121',
  'name' => 'America/Nome',
  'offset' => '-09:00:00',
  'offset_dst' => '-08:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '122',
  'name' => 'America/Noronha',
  'offset' => '-02:00:00',
  'offset_dst' => '-02:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '123',
  'name' => 'America/Panama',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '124',
  'name' => 'America/Pangnirtung',
  'offset' => '-05:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '125',
  'name' => 'America/Paramaribo',
  'offset' => '-03:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '126',
  'name' => 'America/Phoenix',
  'offset' => '-07:00:00',
  'offset_dst' => '-07:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '127',
  'name' => 'America/Port-au-Prince',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '128',
  'name' => 'America/Port of Spain',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '129',
  'name' => 'America/Porto Acre',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '130',
  'name' => 'America/Porto Velho',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '131',
  'name' => 'America/Puerto Rico',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '132',
  'name' => 'America/Rainy River',
  'offset' => '-06:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '133',
  'name' => 'America/Rankin Inlet',
  'offset' => '-06:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '134',
  'name' => 'America/Recife',
  'offset' => '-03:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '135',
  'name' => 'America/Regina',
  'offset' => '-06:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '136',
  'name' => 'America/Rio Branco',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '137',
  'name' => 'America/Rosario',
  'offset' => '-03:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '138',
  'name' => 'America/Santiago',
  'offset' => '-03:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '139',
  'name' => 'America/Santo Domingo',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '140',
  'name' => 'America/Sao Paulo',
  'offset' => '-02:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '141',
  'name' => 'America/Scoresbysund',
  'offset' => '-01:00:00',
  'offset_dst' => '00:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '142',
  'name' => 'America/Shiprock',
  'offset' => '-07:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '143',
  'name' => 'America/St Johns',
  'offset' => '-03:30:00',
  'offset_dst' => '-02:30:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '144',
  'name' => 'America/St Kitts',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '145',
  'name' => 'America/St Lucia',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '146',
  'name' => 'America/St Thomas',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '147',
  'name' => 'America/St Vincent',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '148',
  'name' => 'America/Swift Current',
  'offset' => '-06:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '149',
  'name' => 'America/Tegucigalpa',
  'offset' => '-06:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '150',
  'name' => 'America/Thule',
  'offset' => '-04:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '151',
  'name' => 'America/Thunder Bay',
  'offset' => '-05:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '152',
  'name' => 'America/Tijuana',
  'offset' => '-08:00:00',
  'offset_dst' => '-07:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '153',
  'name' => 'America/Tortola',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '154',
  'name' => 'America/Vancouver',
  'offset' => '-08:00:00',
  'offset_dst' => '-07:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '155',
  'name' => 'America/Virgin',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '156',
  'name' => 'America/Whitehorse',
  'offset' => '-08:00:00',
  'offset_dst' => '-07:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '157',
  'name' => 'America/Winnipeg',
  'offset' => '-06:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '158',
  'name' => 'America/Yakutat',
  'offset' => '-09:00:00',
  'offset_dst' => '-08:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '159',
  'name' => 'America/Yellowknife',
  'offset' => '-07:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '160',
  'name' => 'Antarctica/Casey',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '161',
  'name' => 'Antarctica/Davis',
  'offset' => '07:00:00',
  'offset_dst' => '07:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '162',
  'name' => 'Antarctica/DumontDUrville',
  'offset' => '10:00:00',
  'offset_dst' => '10:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '163',
  'name' => 'Antarctica/Mawson',
  'offset' => '06:00:00',
  'offset_dst' => '06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '164',
  'name' => 'Antarctica/McMurdo',
  'offset' => '13:00:00',
  'offset_dst' => '12:00:00',
  'dst_region' => '11',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '165',
  'name' => 'Antarctica/Palmer',
  'offset' => '-03:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '18',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '166',
  'name' => 'Antarctica/South Pole',
  'offset' => '13:00:00',
  'offset_dst' => '12:00:00',
  'dst_region' => '11',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '167',
  'name' => 'Antarctica/Syowa',
  'offset' => '03:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '168',
  'name' => 'Antarctica/Vostok',
  'offset' => '06:00:00',
  'offset_dst' => '06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '169',
  'name' => 'Arctic/Longyearbyen',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '14',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '170',
  'name' => 'Asia/Aden',
  'offset' => '03:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '171',
  'name' => 'Asia/Almaty',
  'offset' => '06:00:00',
  'offset_dst' => '06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '172',
  'name' => 'Asia/Amman',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '8',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '173',
  'name' => 'Asia/Anadyr',
  'offset' => '12:00:00',
  'offset_dst' => '13:00:00',
  'dst_region' => '3',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '174',
  'name' => 'Asia/Aqtau',
  'offset' => '04:00:00',
  'offset_dst' => '05:00:00',
  'dst_region' => '3',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '175',
  'name' => 'Asia/Aqtobe',
  'offset' => '05:00:00',
  'offset_dst' => '06:00:00',
  'dst_region' => '3',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '176',
  'name' => 'Asia/Ashgabat',
  'offset' => '05:00:00',
  'offset_dst' => '05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '177',
  'name' => 'Asia/Ashkhabad',
  'offset' => '05:00:00',
  'offset_dst' => '05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '178',
  'name' => 'Asia/Baghdad',
  'offset' => '03:00:00',
  'offset_dst' => '04:00:00',
  'dst_region' => '4',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '179',
  'name' => 'Asia/Bahrain',
  'offset' => '03:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '180',
  'name' => 'Asia/Baku',
  'offset' => '04:00:00',
  'offset_dst' => '05:00:00',
  'dst_region' => '3',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '181',
  'name' => 'Asia/Bangkok',
  'offset' => '07:00:00',
  'offset_dst' => '07:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '182',
  'name' => 'Asia/Beirut',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '6',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '183',
  'name' => 'Asia/Bishkek',
  'offset' => '05:00:00',
  'offset_dst' => '06:00:00',
  'dst_region' => '6',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '184',
  'name' => 'Asia/Brunei',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '185',
  'name' => 'Asia/Calcutta',
  'offset' => '05:30:00',
  'offset_dst' => '05:30:30',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '186',
  'name' => 'Asia/Chungking',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '187',
  'name' => 'Asia/Colombo',
  'offset' => '06:00:00',
  'offset_dst' => '06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '188',
  'name' => 'Asia/Dacca',
  'offset' => '06:00:00',
  'offset_dst' => '06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '189',
  'name' => 'Asia/Damascus',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '4',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '190',
  'name' => 'Asia/Dhaka',
  'offset' => '06:00:00',
  'offset_dst' => '06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '191',
  'name' => 'Asia/Dili',
  'offset' => '09:00:00',
  'offset_dst' => '09:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '192',
  'name' => 'Asia/Dubai',
  'offset' => '04:00:00',
  'offset_dst' => '04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '193',
  'name' => 'Asia/Dushanbe',
  'offset' => '05:00:00',
  'offset_dst' => '05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '194',
  'name' => 'Asia/Gaza',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '7',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '195',
  'name' => 'Asia/Harbin',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '196',
  'name' => 'Asia/Hong Kong',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '197',
  'name' => 'Asia/Hovd',
  'offset' => '07:00:00',
  'offset_dst' => '07:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '198',
  'name' => 'Asia/Irkutsk',
  'offset' => '08:00:00',
  'offset_dst' => '09:00:00',
  'dst_region' => '3',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '199',
  'name' => 'Asia/Istanbul',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '3',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '200',
  'name' => 'Asia/Jakarta',
  'offset' => '07:00:00',
  'offset_dst' => '07:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '201',
  'name' => 'Asia/Jayapura',
  'offset' => '09:00:00',
  'offset_dst' => '09:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '202',
  'name' => 'Asia/Jerusalem',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '5',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '203',
  'name' => 'Asia/Kabul',
  'offset' => '04:30:00',
  'offset_dst' => '04:30:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '204',
  'name' => 'Asia/Kamchatka',
  'offset' => '12:00:00',
  'offset_dst' => '13:00:00',
  'dst_region' => '3',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '205',
  'name' => 'Asia/Karachi',
  'offset' => '05:00:00',
  'offset_dst' => '05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '206',
  'name' => 'Asia/Kashgar',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '207',
  'name' => 'Asia/Katmandu',
  'offset' => '05:45:00',
  'offset_dst' => '05:45:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '208',
  'name' => 'Asia/Krasnoyarsk',
  'offset' => '07:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '3',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '209',
  'name' => 'Asia/Kuala Lumpur',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '210',
  'name' => 'Asia/Kuching',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '211',
  'name' => 'Asia/Kuwait',
  'offset' => '03:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '212',
  'name' => 'Asia/Macao',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '213',
  'name' => 'Asia/Magadan',
  'offset' => '11:00:00',
  'offset_dst' => '12:00:00',
  'dst_region' => '3',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '214',
  'name' => 'Asia/Manila',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '215',
  'name' => 'Asia/Muscat',
  'offset' => '04:00:00',
  'offset_dst' => '04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '216',
  'name' => 'Asia/Nicosia',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '3',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '217',
  'name' => 'Asia/Novosibirsk',
  'offset' => '06:00:00',
  'offset_dst' => '07:00:00',
  'dst_region' => '3',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '218',
  'name' => 'Asia/Omsk',
  'offset' => '06:00:00',
  'offset_dst' => '07:00:00',
  'dst_region' => '3',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '219',
  'name' => 'Asia/Phnom Penh',
  'offset' => '07:00:00',
  'offset_dst' => '07:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '220',
  'name' => 'Asia/Pyongyang',
  'offset' => '09:00:00',
  'offset_dst' => '09:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '221',
  'name' => 'Asia/Qatar',
  'offset' => '03:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '222',
  'name' => 'Asia/Rangoon',
  'offset' => '06:30:00',
  'offset_dst' => '06:30:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '223',
  'name' => 'Asia/Riyadh',
  'offset' => '03:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '224',
  'name' => 'Asia/Riyadh87',
  'offset' => '03:07:04',
  'offset_dst' => '03:07:04',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '225',
  'name' => 'Asia/Riyadh88',
  'offset' => '03:07:04',
  'offset_dst' => '03:07:04',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '226',
  'name' => 'Asia/Riyadh89',
  'offset' => '03:07:04',
  'offset_dst' => '03:07:04',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '227',
  'name' => 'Asia/Saigon',
  'offset' => '07:00:00',
  'offset_dst' => '07:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '228',
  'name' => 'Asia/Samarkand',
  'offset' => '05:00:00',
  'offset_dst' => '05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '229',
  'name' => 'Asia/Seoul',
  'offset' => '09:00:00',
  'offset_dst' => '09:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '230',
  'name' => 'Asia/Shanghai',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '231',
  'name' => 'Asia/Singapore',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '232',
  'name' => 'Asia/Taipei',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '233',
  'name' => 'Asia/Tashkent',
  'offset' => '05:00:00',
  'offset_dst' => '05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '234',
  'name' => 'Asia/Tbilisi',
  'offset' => '04:00:00',
  'offset_dst' => '05:00:00',
  'dst_region' => '3',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '235',
  'name' => 'Asia/Tehran',
  'offset' => '03:30:00',
  'offset_dst' => '04:30:00',
  'dst_region' => '8',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '236',
  'name' => 'Asia/Tel Aviv',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '5',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '237',
  'name' => 'Asia/Thimbu',
  'offset' => '06:00:00',
  'offset_dst' => '06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '238',
  'name' => 'Asia/Thimphu',
  'offset' => '06:00:00',
  'offset_dst' => '06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '239',
  'name' => 'Asia/Tokyo',
  'offset' => '09:00:00',
  'offset_dst' => '09:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '240',
  'name' => 'Asia/Ujung Pandang',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '241',
  'name' => 'Asia/Ulaanbaatar',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '242',
  'name' => 'Asia/Ulan Bator',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '243',
  'name' => 'Asia/Urumqi',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '244',
  'name' => 'Asia/Vientiane',
  'offset' => '07:00:00',
  'offset_dst' => '07:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '245',
  'name' => 'Asia/Vladivostok',
  'offset' => '10:00:00',
  'offset_dst' => '11:00:00',
  'dst_region' => '3',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '246',
  'name' => 'Asia/Yakutsk',
  'offset' => '09:00:00',
  'offset_dst' => '10:00:00',
  'dst_region' => '3',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '247',
  'name' => 'Asia/Yekaterinburg',
  'offset' => '05:00:00',
  'offset_dst' => '06:00:00',
  'dst_region' => '3',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '248',
  'name' => 'Asia/Yerevan',
  'offset' => '04:00:00',
  'offset_dst' => '05:00:00',
  'dst_region' => '3',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '249',
  'name' => 'Atlantic/Azores',
  'offset' => '-01:00:00',
  'offset_dst' => '00:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '250',
  'name' => 'Atlantic/Bermuda',
  'offset' => '-04:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '251',
  'name' => 'Atlantic/Canary',
  'offset' => '00:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '252',
  'name' => 'Atlantic/Cape Verde',
  'offset' => '-01:00:00',
  'offset_dst' => '-01:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '253',
  'name' => 'Atlantic/Faeroe',
  'offset' => '00:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '254',
  'name' => 'Atlantic/Jan Mayen',
  'offset' => '-01:00:00',
  'offset_dst' => '-01:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '255',
  'name' => 'Atlantic/Madeira',
  'offset' => '00:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '256',
  'name' => 'Atlantic/South Georgia',
  'offset' => '-02:00:00',
  'offset_dst' => '-02:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '257',
  'name' => 'Atlantic/Stanley',
  'offset' => '-03:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '19',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '258',
  'name' => 'Australia/ACT',
  'offset' => '10:00:00',
  'offset_dst' => '11:00:00',
  'dst_region' => '9',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '259',
  'name' => 'Australia/Adelaide',
  'offset' => '10:30:00',
  'offset_dst' => '09:30:00',
  'dst_region' => '9',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '260',
  'name' => 'Australia/Brisbane',
  'offset' => '10:00:00',
  'offset_dst' => '10:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '261',
  'name' => 'Australia/Broken Hill',
  'offset' => '10:30:00',
  'offset_dst' => '09:30:00',
  'dst_region' => '9',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '262',
  'name' => 'Australia/Canberra',
  'offset' => '11:00:00',
  'offset_dst' => '10:00:00',
  'dst_region' => '9',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '263',
  'name' => 'Australia/Darwin',
  'offset' => '09:30:00',
  'offset_dst' => '09:30:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '264',
  'name' => 'Australia/Hobart',
  'offset' => '11:00:00',
  'offset_dst' => '10:00:00',
  'dst_region' => '10',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '265',
  'name' => 'Australia/LHI',
  'offset' => '11:00:00',
  'offset_dst' => '10:30:00',
  'dst_region' => '9',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '266',
  'name' => 'Australia/Lindeman',
  'offset' => '10:00:00',
  'offset_dst' => '10:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '267',
  'name' => 'Australia/Lord Howe',
  'offset' => '11:00:00',
  'offset_dst' => '10:30:00',
  'dst_region' => '9',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '268',
  'name' => 'Australia/Melbourne',
  'offset' => '10:00:00',
  'offset_dst' => '11:00:00',
  'dst_region' => '10',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '269',
  'name' => 'Australia/NSW',
  'offset' => '10:00:00',
  'offset_dst' => '11:00:00',
  'dst_region' => '9',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '270',
  'name' => 'Australia/North',
  'offset' => '09:30:00',
  'offset_dst' => '09:30:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '271',
  'name' => 'Australia/Perth',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '272',
  'name' => 'Australia/Queensland',
  'offset' => '10:00:00',
  'offset_dst' => '10:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '273',
  'name' => 'Australia/South',
  'offset' => '10:30:00',
  'offset_dst' => '09:30:00',
  'dst_region' => '9',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '274',
  'name' => 'Australia/Sydney',
  'offset' => '10:00:00',
  'offset_dst' => '11:00:00',
  'dst_region' => '10',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '275',
  'name' => 'Australia/Tasmania',
  'offset' => '10:00:00',
  'offset_dst' => '11:00:00',
  'dst_region' => '9',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '276',
  'name' => 'Australia/Victoria',
  'offset' => '10:00:00',
  'offset_dst' => '11:00:00',
  'dst_region' => '9',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '277',
  'name' => 'Australia/West',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '278',
  'name' => 'Australia/Yancowinna',
  'offset' => '10:30:00',
  'offset_dst' => '09:30:00',
  'dst_region' => '10',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '279',
  'name' => 'Brazil/Acre',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '280',
  'name' => 'Brazil/DeNoronha',
  'offset' => '-02:00:00',
  'offset_dst' => '-02:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '281',
  'name' => 'Brazil/East',
  'offset' => '-02:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '17',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '282',
  'name' => 'Brazil/West',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '285',
  'name' => 'Canada/Atlantic',
  'offset' => '-04:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '286',
  'name' => 'Canada/Central',
  'offset' => '-06:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '287',
  'name' => 'Canada/Central-Saskatchewan',
  'offset' => '-06:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '288',
  'name' => 'Canada/Eastern',
  'offset' => '-05:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '289',
  'name' => 'Canada/Mountain',
  'offset' => '-07:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '290',
  'name' => 'Canada/Newfoundland',
  'offset' => '-03:30:00',
  'offset_dst' => '-02:30:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '291',
  'name' => 'Canada/Pacific',
  'offset' => '-08:00:00',
  'offset_dst' => '-07:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '292',
  'name' => 'Canada/Saskatchewan',
  'offset' => '-06:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '293',
  'name' => 'Canada/Yukon',
  'offset' => '-08:00:00',
  'offset_dst' => '-07:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '294',
  'name' => 'Chile/Continental',
  'offset' => '-03:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '18',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '295',
  'name' => 'Chile/EasterIsland',
  'offset' => '-05:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '18',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '296',
  'name' => 'Cuba',
  'offset' => '-05:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '16',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '298',
  'name' => 'EST',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '300',
  'name' => 'Egypt',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '1',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '301',
  'name' => 'Eire',
  'offset' => '00:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '302',
  'name' => 'Etc/GMT-1',
  'offset' => '-01:00:00',
  'offset_dst' => '-01:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '303',
  'name' => 'Etc/GMT-10',
  'offset' => '-10:00:00',
  'offset_dst' => '-10:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '304',
  'name' => 'Etc/GMT-11',
  'offset' => '-11:00:00',
  'offset_dst' => '-11:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '305',
  'name' => 'Etc/GMT-12',
  'offset' => '-12:00:00',
  'offset_dst' => '-12:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '306',
  'name' => 'Etc/GMT-2',
  'offset' => '-02:00:00',
  'offset_dst' => '-02:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '307',
  'name' => 'Etc/GMT-3',
  'offset' => '-03:00:00',
  'offset_dst' => '-03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '308',
  'name' => 'Etc/GMT-4',
  'offset' => '-04:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '309',
  'name' => 'Etc/GMT-5',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '310',
  'name' => 'Etc/GMT-6',
  'offset' => '-06:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '311',
  'name' => 'Etc/GMT-7',
  'offset' => '-07:00:00',
  'offset_dst' => '-07:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '312',
  'name' => 'Etc/GMT-8',
  'offset' => '-08:00:00',
  'offset_dst' => '-08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '313',
  'name' => 'Etc/GMT-9',
  'offset' => '-09:00:00',
  'offset_dst' => '-09:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '314',
  'name' => 'Etc/GMT+1',
  'offset' => '01:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '315',
  'name' => 'Etc/GMT+10',
  'offset' => '10:00:00',
  'offset_dst' => '10:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '316',
  'name' => 'Etc/GMT+11',
  'offset' => '11:00:00',
  'offset_dst' => '11:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '317',
  'name' => 'Etc/GMT+12',
  'offset' => '12:00:00',
  'offset_dst' => '12:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '318',
  'name' => 'Etc/GMT+13',
  'offset' => '13:00:00',
  'offset_dst' => '13:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '319',
  'name' => 'Etc/GMT+14',
  'offset' => '14:00:00',
  'offset_dst' => '14:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '320',
  'name' => 'Etc/GMT+2',
  'offset' => '02:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '321',
  'name' => 'Etc/GMT+3',
  'offset' => '03:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '322',
  'name' => 'Etc/GMT+4',
  'offset' => '04:00:00',
  'offset_dst' => '04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '323',
  'name' => 'Etc/GMT+5',
  'offset' => '05:00:00',
  'offset_dst' => '05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '324',
  'name' => 'Etc/GMT+6',
  'offset' => '06:00:00',
  'offset_dst' => '06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '325',
  'name' => 'Etc/GMT+7',
  'offset' => '07:00:00',
  'offset_dst' => '07:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '326',
  'name' => 'Etc/GMT+8',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '327',
  'name' => 'Etc/GMT+9',
  'offset' => '09:00:00',
  'offset_dst' => '09:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '328',
  'name' => 'Europe/Amsterdam',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '329',
  'name' => 'Europe/Andorra',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '330',
  'name' => 'Europe/Athens',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '331',
  'name' => 'Europe/Belfast',
  'offset' => '00:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '332',
  'name' => 'Europe/Belgrade',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '333',
  'name' => 'Europe/Berlin',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '334',
  'name' => 'Europe/Bratislava',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '335',
  'name' => 'Europe/Brussels',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '336',
  'name' => 'Europe/Bucharest',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '337',
  'name' => 'Europe/Budapest',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '338',
  'name' => 'Europe/Chisinau',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '339',
  'name' => 'Europe/Copenhagen',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '340',
  'name' => 'Europe/Dublin',
  'offset' => '00:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '341',
  'name' => 'Europe/Gibraltar',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '342',
  'name' => 'Europe/Helsinki',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '343',
  'name' => 'Europe/Istanbul',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '344',
  'name' => 'Europe/Kaliningrad',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '345',
  'name' => 'Europe/Kiev',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '346',
  'name' => 'Europe/Lisbon',
  'offset' => '00:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '347',
  'name' => 'Europe/Ljubljana',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '348',
  'name' => 'Europe/London',
  'offset' => '00:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '349',
  'name' => 'Europe/Luxembourg',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '350',
  'name' => 'Europe/Madrid',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '351',
  'name' => 'Europe/Malta',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '352',
  'name' => 'Europe/Minsk',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '353',
  'name' => 'Europe/Monaco',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '354',
  'name' => 'Europe/Moscow',
  'offset' => '03:00:00',
  'offset_dst' => '04:00:00',
  'dst_region' => '14',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '355',
  'name' => 'Europe/Nicosia',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '356',
  'name' => 'Europe/Oslo',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '357',
  'name' => 'Europe/Paris',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '358',
  'name' => 'Europe/Prague',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '359',
  'name' => 'Europe/Riga',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '360',
  'name' => 'Europe/Rome',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '361',
  'name' => 'Europe/Samara',
  'offset' => '04:00:00',
  'offset_dst' => '05:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '362',
  'name' => 'Europe/San Marino',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '363',
  'name' => 'Europe/Sarajevo',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '364',
  'name' => 'Europe/Simferopol',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '365',
  'name' => 'Europe/Skopje',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '366',
  'name' => 'Europe/Sofia',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '367',
  'name' => 'Europe/Stockholm',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '368',
  'name' => 'Europe/Tallinn',
  'offset' => '02:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '369',
  'name' => 'Europe/Tirane',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '370',
  'name' => 'Europe/Tiraspol',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '371',
  'name' => 'Europe/Uzhgorod',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '372',
  'name' => 'Europe/Vaduz',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '373',
  'name' => 'Europe/Vatican',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '374',
  'name' => 'Europe/Vienna',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '375',
  'name' => 'Europe/Vilnius',
  'offset' => '02:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '376',
  'name' => 'Europe/Warsaw',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '377',
  'name' => 'Europe/Zagreb',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '378',
  'name' => 'Europe/Zaporozhye',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '379',
  'name' => 'Europe/Zurich',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '380',
  'name' => 'GB',
  'offset' => '00:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '381',
  'name' => 'GB-Eire',
  'offset' => '00:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '383',
  'name' => 'Hongkong',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '384',
  'name' => 'Indian/Antananarivo',
  'offset' => '03:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '385',
  'name' => 'Indian/Chagos',
  'offset' => '05:00:00',
  'offset_dst' => '05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '386',
  'name' => 'Indian/Christmas',
  'offset' => '07:00:00',
  'offset_dst' => '07:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '387',
  'name' => 'Indian/Cocos',
  'offset' => '06:30:00',
  'offset_dst' => '06:30:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '388',
  'name' => 'Indian/Comoro',
  'offset' => '03:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '389',
  'name' => 'Indian/Kerguelen',
  'offset' => '05:00:00',
  'offset_dst' => '05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '390',
  'name' => 'Indian/Mahe',
  'offset' => '04:00:00',
  'offset_dst' => '04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '391',
  'name' => 'Indian/Maldives',
  'offset' => '05:00:00',
  'offset_dst' => '05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '392',
  'name' => 'Indian/Mauritius',
  'offset' => '04:00:00',
  'offset_dst' => '04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '393',
  'name' => 'Indian/Mayotte',
  'offset' => '03:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '394',
  'name' => 'Indian/Reunion',
  'offset' => '04:00:00',
  'offset_dst' => '04:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '395',
  'name' => 'Iran',
  'offset' => '03:30:00',
  'offset_dst' => '04:30:00',
  'dst_region' => '8',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '396',
  'name' => 'Israel',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '5',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '397',
  'name' => 'Jamaica',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '398',
  'name' => 'Japan',
  'offset' => '09:00:00',
  'offset_dst' => '09:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '399',
  'name' => 'Kwajalein',
  'offset' => '12:00:00',
  'offset_dst' => '12:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '400',
  'name' => 'Libya',
  'offset' => '02:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '404',
  'name' => 'Mexico/BajaNorte',
  'offset' => '-08:00:00',
  'offset_dst' => '-07:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '405',
  'name' => 'Mexico/BajaSur',
  'offset' => '-07:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '406',
  'name' => 'Mexico/General',
  'offset' => '-06:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '407',
  'name' => 'Mideast/Riyadh87',
  'offset' => '03:07:04',
  'offset_dst' => '03:07:04',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '408',
  'name' => 'Mideast/Riyadh88',
  'offset' => '03:07:04',
  'offset_dst' => '03:07:04',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '409',
  'name' => 'Mideast/Riyadh89',
  'offset' => '03:07:04',
  'offset_dst' => '03:07:04',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '410',
  'name' => 'NZ',
  'offset' => '13:00:00',
  'offset_dst' => '12:00:00',
  'dst_region' => '11',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '412',
  'name' => 'Navajo',
  'offset' => '-07:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '415',
  'name' => 'Pacific/Apia',
  'offset' => '-11:00:00',
  'offset_dst' => '-11:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '416',
  'name' => 'Pacific/Auckland',
  'offset' => '13:00:00',
  'offset_dst' => '12:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '417',
  'name' => 'Pacific/Chatham',
  'offset' => '13:45:00',
  'offset_dst' => '12:45:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '418',
  'name' => 'Pacific/Easter',
  'offset' => '-05:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '419',
  'name' => 'Pacific/Efate',
  'offset' => '11:00:00',
  'offset_dst' => '11:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '420',
  'name' => 'Pacific/Enderbury',
  'offset' => '13:00:00',
  'offset_dst' => '13:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '421',
  'name' => 'Pacific/Fakaofo',
  'offset' => '-10:00:00',
  'offset_dst' => '-10:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '422',
  'name' => 'Pacific/Fiji',
  'offset' => '12:00:00',
  'offset_dst' => '12:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '423',
  'name' => 'Pacific/Funafuti',
  'offset' => '12:00:00',
  'offset_dst' => '12:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '424',
  'name' => 'Pacific/Galapagos',
  'offset' => '-06:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '425',
  'name' => 'Pacific/Gambier',
  'offset' => '-09:00:00',
  'offset_dst' => '-09:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '426',
  'name' => 'Pacific/Guadalcanal',
  'offset' => '11:00:00',
  'offset_dst' => '11:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '427',
  'name' => 'Pacific/Guam',
  'offset' => '10:00:00',
  'offset_dst' => '10:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '428',
  'name' => 'Pacific/Honolulu',
  'offset' => '-10:00:00',
  'offset_dst' => '-10:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '429',
  'name' => 'Pacific/Johnston',
  'offset' => '-10:00:00',
  'offset_dst' => '-10:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '430',
  'name' => 'Pacific/Kiritimati',
  'offset' => '14:00:00',
  'offset_dst' => '14:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '431',
  'name' => 'Pacific/Kosrae',
  'offset' => '11:00:00',
  'offset_dst' => '11:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '432',
  'name' => 'Pacific/Kwajalein',
  'offset' => '12:00:00',
  'offset_dst' => '12:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '433',
  'name' => 'Pacific/Majuro',
  'offset' => '12:00:00',
  'offset_dst' => '12:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '434',
  'name' => 'Pacific/Marquesas',
  'offset' => '-09:30:00',
  'offset_dst' => '-09:30:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '435',
  'name' => 'Pacific/Midway',
  'offset' => '-11:00:00',
  'offset_dst' => '-11:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '436',
  'name' => 'Pacific/Nauru',
  'offset' => '12:00:00',
  'offset_dst' => '12:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '437',
  'name' => 'Pacific/Niue',
  'offset' => '-11:00:00',
  'offset_dst' => '-11:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '438',
  'name' => 'Pacific/Norfolk',
  'offset' => '11:30:00',
  'offset_dst' => '11:30:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '439',
  'name' => 'Pacific/Noumea',
  'offset' => '11:00:00',
  'offset_dst' => '11:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '440',
  'name' => 'Pacific/Pago Pago',
  'offset' => '-11:00:00',
  'offset_dst' => '-11:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '441',
  'name' => 'Pacific/Palau',
  'offset' => '09:00:00',
  'offset_dst' => '09:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '442',
  'name' => 'Pacific/Pitcairn',
  'offset' => '-08:00:00',
  'offset_dst' => '-08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '443',
  'name' => 'Pacific/Ponape',
  'offset' => '11:00:00',
  'offset_dst' => '11:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '444',
  'name' => 'Pacific/Port Moresby',
  'offset' => '10:00:00',
  'offset_dst' => '10:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '445',
  'name' => 'Pacific/Rarotonga',
  'offset' => '-10:00:00',
  'offset_dst' => '-10:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '446',
  'name' => 'Pacific/Saipan',
  'offset' => '10:00:00',
  'offset_dst' => '10:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '447',
  'name' => 'Pacific/Samoa',
  'offset' => '-11:00:00',
  'offset_dst' => '-11:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '448',
  'name' => 'Pacific/Tahiti',
  'offset' => '-10:00:00',
  'offset_dst' => '-10:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '449',
  'name' => 'Pacific/Tarawa',
  'offset' => '12:00:00',
  'offset_dst' => '12:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '450',
  'name' => 'Pacific/Tongatapu',
  'offset' => '13:00:00',
  'offset_dst' => '13:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '451',
  'name' => 'Pacific/Truk',
  'offset' => '10:00:00',
  'offset_dst' => '10:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '452',
  'name' => 'Pacific/Wake',
  'offset' => '12:00:00',
  'offset_dst' => '12:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '453',
  'name' => 'Pacific/Wallis',
  'offset' => '12:00:00',
  'offset_dst' => '12:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '454',
  'name' => 'Pacific/Yap',
  'offset' => '10:00:00',
  'offset_dst' => '10:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '455',
  'name' => 'Poland',
  'offset' => '01:00:00',
  'offset_dst' => '02:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '456',
  'name' => 'Portugal',
  'offset' => '00:00:00',
  'offset_dst' => '01:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '459',
  'name' => 'Singapore',
  'offset' => '08:00:00',
  'offset_dst' => '08:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '473',
  'name' => 'Turkey',
  'offset' => '02:00:00',
  'offset_dst' => '03:00:00',
  'dst_region' => '13',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '474',
  'name' => 'US/Alaska',
  'offset' => '-09:00:00',
  'offset_dst' => '-08:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '475',
  'name' => 'US/Aleutian',
  'offset' => '-10:00:00',
  'offset_dst' => '-09:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '476',
  'name' => 'US/Arizona',
  'offset' => '-07:00:00',
  'offset_dst' => '-07:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '477',
  'name' => 'US/Central',
  'offset' => '-06:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '478',
  'name' => 'US/East-Indiana',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '479',
  'name' => 'US/Eastern',
  'offset' => '-05:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '480',
  'name' => 'US/Hawaii',
  'offset' => '-10:00:00',
  'offset_dst' => '-10:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '481',
  'name' => 'US/Indiana-Starke',
  'offset' => '-05:00:00',
  'offset_dst' => '-05:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '482',
  'name' => 'US/Michigan',
  'offset' => '-05:00:00',
  'offset_dst' => '-04:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '483',
  'name' => 'US/Mountain',
  'offset' => '-07:00:00',
  'offset_dst' => '-06:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '484',
  'name' => 'US/Pacific',
  'offset' => '-08:00:00',
  'offset_dst' => '-07:00:00',
  'dst_region' => '15',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '485',
  'name' => 'US/Samoa',
  'offset' => '-11:00:00',
  'offset_dst' => '-11:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '486',
  'name' => 'Pacific/French Polynesia-Marquesas Islands',
  'offset' => '-09:30:00',
  'offset_dst' => '-09:30:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->values(array(
  'timezone' => '487',
  'name' => 'Etc/GMT',
  'offset' => '00:00:00',
  'offset_dst' => '00:00:00',
  'dst_region' => '0',
  'is_dst' => '0',
))
->execute();
$connection->schema()->createTable('files', array(
  'fields' => array(
    'fid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'filename' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'filepath' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'filemime' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'filesize' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'fid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('files')
->fields(array(
  'fid',
  'uid',
  'filename',
  'filepath',
  'filemime',
  'filesize',
  'status',
  'timestamp',
))
->values(array(
  'fid' => '1',
  'uid' => '1',
  'filename' => 'Image1.png',
  'filepath' => 'core/tests/fixtures/files/image-1.png',
  'filemime' => 'image/png',
  'filesize' => '39325',
  'status' => '1',
  'timestamp' => '1388880660',
))
->values(array(
  'fid' => '2',
  'uid' => '1',
  'filename' => 'Image2.jpg',
  'filepath' => 'core/tests/fixtures/files/image-2.jpg',
  'filemime' => 'image/jpeg',
  'filesize' => '1831',
  'status' => '1',
  'timestamp' => '1388880664',
))
->values(array(
  'fid' => '3',
  'uid' => '1',
  'filename' => 'Image-test.gif',
  'filepath' => 'core/tests/fixtures/files/image-test.gif',
  'filemime' => 'image/jpeg',
  'filesize' => '183',
  'status' => '1',
  'timestamp' => '1388880668',
))
->values(array(
  'fid' => '5',
  'uid' => '1',
  'filename' => 'html-1.txt',
  'filepath' => 'core/tests/fixtures/files/html-1.txt',
  'filemime' => 'text/plain',
  'filesize' => '24',
  'status' => '1',
  'timestamp' => '1420858106',
))
->values(array(
  'fid' => '6',
  'uid' => '1',
  'filename' => 'some-temp-file.jpg',
  'filepath' => '/tmp/some-temp-file.jpg',
  'filemime' => 'image/jpeg',
  'filesize' => '24',
  'status' => '0',
  'timestamp' => '1420858106',
))
->execute();
$connection->schema()->createTable('filter_formats', array(
  'fields' => array(
    'format' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'roles' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'cache' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'format',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('filter_formats')
->fields(array(
  'format',
  'name',
  'roles',
  'cache',
))
->values(array(
  'format' => '1',
  'name' => 'Filtered HTML',
  'roles' => ',1,2,',
  'cache' => '1',
))
->values(array(
  'format' => '2',
  'name' => 'Full HTML',
  'roles' => '3',
  'cache' => '1',
))
->values(array(
  'format' => '3',
  'name' => 'Escape HTML Filter',
  'roles' => '',
  'cache' => '1',
))
->values(array(
  'format' => '4',
  'name' => 'PHP Code',
  'roles' => ',3,4,5,',
  'cache' => '0',
))
->execute();
$connection->schema()->createTable('filters', array(
  'fields' => array(
    'fid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'format' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'delta' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'fid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('filters')
->fields(array(
  'fid',
  'format',
  'module',
  'delta',
  'weight',
))
->values(array(
  'fid' => '1',
  'format' => '1',
  'module' => 'filter',
  'delta' => '2',
  'weight' => '0',
))
->values(array(
  'fid' => '2',
  'format' => '1',
  'module' => 'filter',
  'delta' => '0',
  'weight' => '1',
))
->values(array(
  'fid' => '3',
  'format' => '1',
  'module' => 'filter',
  'delta' => '1',
  'weight' => '2',
))
->values(array(
  'fid' => '4',
  'format' => '1',
  'module' => 'filter',
  'delta' => '3',
  'weight' => '10',
))
->values(array(
  'fid' => '5',
  'format' => '2',
  'module' => 'filter',
  'delta' => '2',
  'weight' => '0',
))
->values(array(
  'fid' => '6',
  'format' => '2',
  'module' => 'filter',
  'delta' => '1',
  'weight' => '1',
))
->values(array(
  'fid' => '7',
  'format' => '2',
  'module' => 'filter',
  'delta' => '3',
  'weight' => '10',
))
->values(array(
  'fid' => '8',
  'format' => '6',
  'module' => 'filter',
  'delta' => '2',
  'weight' => '0',
))
->values(array(
  'fid' => '9',
  'format' => '6',
  'module' => 'filter',
  'delta' => '0',
  'weight' => '1',
))
->values(array(
  'fid' => '10',
  'format' => '6',
  'module' => 'filter',
  'delta' => '1',
  'weight' => '2',
))
->values(array(
  'fid' => '11',
  'format' => '6',
  'module' => 'filter',
  'delta' => '3',
  'weight' => '10',
))
->values(array(
  'fid' => '16',
  'format' => '4',
  'module' => 'php',
  'delta' => '0',
  'weight' => '10',
))
->execute();
$connection->schema()->createTable('flood', array(
  'fields' => array(
    'fid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'event' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'hostname' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'fid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->schema()->createTable('forum', array(
  'fields' => array(
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'vid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'tid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
  ),
  'primary key' => array(
    'vid',
  ),
  'indexes' => array(
    'nid' => array(
      'nid',
    ),
    'tid' => array(
      'tid',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('forum')
->fields(array(
  'nid',
  'vid',
  'tid',
))
->values(array(
  'nid' => '19',
  'vid' => '22',
  'tid' => '8',
))
->execute();
$connection->schema()->createTable('history', array(
  'fields' => array(
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'nid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'uid',
    'nid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('history')
->fields(array(
  'uid',
  'nid',
  'timestamp',
))
->values(array(
  'uid' => '1',
  'nid' => '1',
  'timestamp' => '1549874910',
))
->values(array(
  'uid' => '1',
  'nid' => '2',
  'timestamp' => '1549874910',
))
->values(array(
  'uid' => '1',
  'nid' => '3',
  'timestamp' => '1457654737',
))
->values(array(
  'uid' => '1',
  'nid' => '9',
  'timestamp' => '1468384961',
))
->values(array(
  'uid' => '1',
  'nid' => '12',
  'timestamp' => '1468384823',
))
->values(array(
  'uid' => '1',
  'nid' => '13',
  'timestamp' => '1468384931',
))
->values(array(
  'uid' => '1',
  'nid' => '14',
  'timestamp' => '1493066668',
))
->values(array(
  'uid' => '1',
  'nid' => '15',
  'timestamp' => '1493066677',
))
->values(array(
  'uid' => '1',
  'nid' => '16',
  'timestamp' => '1493066685',
))
->values(array(
  'uid' => '1',
  'nid' => '17',
  'timestamp' => '1493066693',
))
->values(array(
  'uid' => '1',
  'nid' => '18',
  'timestamp' => '1493066711',
))
->values(array(
  'uid' => '1',
  'nid' => '19',
  'timestamp' => '1501955803',
))
->values(array(
  'uid' => '1',
  'nid' => '21',
  'timestamp' => '1534014729',
))
->values(array(
  'uid' => '1',
  'nid' => '22',
  'timestamp' => '1534014763',
))
->execute();
$connection->schema()->createTable('i18n_blocks', array(
  'fields' => array(
    'ibid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
    ),
    'delta' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '0',
    ),
    'type' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
      'default' => '',
    ),
  ),
  'primary key' => array(
    'ibid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('i18n_blocks')
->fields(array(
  'ibid',
  'module',
  'delta',
  'type',
  'language',
))
->values(array(
  'ibid' => '1',
  'module' => 'user',
  'delta' => '1',
  'type' => '0',
  'language' => 'zu',
))
->values(array(
  'ibid' => '2',
  'module' => 'menu',
  'delta' => 'menu-translation-test',
  'type' => '0',
  'language' => 'zu',
))
->execute();
$connection->schema()->createTable('i18n_strings', array(
  'fields' => array(
    'lid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'objectid' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'property' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'objectindex' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'format' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'lid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('i18n_strings')
->fields(array(
  'lid',
  'objectid',
  'type',
  'property',
  'objectindex',
  'format',
))
->values(array(
  'lid' => '504',
  'objectid' => 'profile_color',
  'type' => 'field',
  'property' => 'title',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '505',
  'objectid' => 'profile_color',
  'type' => 'field',
  'property' => 'explanation',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '506',
  'objectid' => '',
  'type' => 'category',
  'property' => '',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '507',
  'objectid' => 'profile_biography',
  'type' => 'field',
  'property' => 'title',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '508',
  'objectid' => 'profile_biography',
  'type' => 'field',
  'property' => 'explanation',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '509',
  'objectid' => 'profile_sell_Address',
  'type' => 'field',
  'property' => 'title',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '510',
  'objectid' => 'profile_sell_Address',
  'type' => 'field',
  'property' => 'explanation',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '511',
  'objectid' => '',
  'type' => 'category',
  'property' => '',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '512',
  'objectid' => 'profile_sold_to',
  'type' => 'field',
  'property' => 'title',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '513',
  'objectid' => 'profile_sold_to',
  'type' => 'field',
  'property' => 'explanation',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '514',
  'objectid' => 'profile_sold_to',
  'type' => 'field',
  'property' => 'options',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '515',
  'objectid' => '',
  'type' => 'category',
  'property' => '',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '516',
  'objectid' => 'profile_bands',
  'type' => 'field',
  'property' => 'title',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '517',
  'objectid' => 'profile_bands',
  'type' => 'field',
  'property' => 'explanation',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '518',
  'objectid' => 'profile_birthdate',
  'type' => 'field',
  'property' => 'title',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '519',
  'objectid' => 'profile_birthdate',
  'type' => 'field',
  'property' => 'explanation',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '520',
  'objectid' => 'profile_really_really_love_migrations',
  'type' => 'field',
  'property' => 'title',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '521',
  'objectid' => 'profile_really_really_love_migrations',
  'type' => 'field',
  'property' => 'explanation',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '522',
  'objectid' => 'profile_blog',
  'type' => 'field',
  'property' => 'title',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '523',
  'objectid' => 'profile_blog',
  'type' => 'field',
  'property' => 'explanation',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '524',
  'objectid' => '1',
  'type' => 'block',
  'property' => 'title',
  'objectindex' => '1',
  'format' => '0',
))
->values(array(
  'lid' => '525',
  'objectid' => '1',
  'type' => 'block',
  'property' => 'body',
  'objectindex' => '1',
  'format' => '2',
))
->values(array(
  'lid' => '526',
  'objectid' => '2',
  'type' => 'block',
  'property' => 'title',
  'objectindex' => '2',
  'format' => '0',
))
->values(array(
  'lid' => '527',
  'objectid' => '2',
  'type' => 'block',
  'property' => 'body',
  'objectindex' => '2',
  'format' => '2',
))
->values(array(
  'lid' => '528',
  'objectid' => '4',
  'type' => 'vocabulary',
  'property' => 'name',
  'objectindex' => '4',
  'format' => '0',
))
->values(array(
  'lid' => '529',
  'objectid' => '1',
  'type' => 'vocabulary',
  'property' => 'name',
  'objectindex' => '1',
  'format' => '0',
))
->values(array(
  'lid' => '530',
  'objectid' => '2',
  'type' => 'vocabulary',
  'property' => 'name',
  'objectindex' => '2',
  'format' => '0',
))
->values(array(
  'lid' => '531',
  'objectid' => '3',
  'type' => 'vocabulary',
  'property' => 'name',
  'objectindex' => '3',
  'format' => '0',
))
->values(array(
  'lid' => '532',
  'objectid' => '5',
  'type' => 'vocabulary',
  'property' => 'name',
  'objectindex' => '5',
  'format' => '0',
))
->values(array(
  'lid' => '533',
  'objectid' => 'article',
  'type' => 'type',
  'property' => 'name',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '534',
  'objectid' => 'article',
  'type' => 'type',
  'property' => 'title',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '535',
  'objectid' => 'article',
  'type' => 'type',
  'property' => 'body',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '536',
  'objectid' => 'article',
  'type' => 'type',
  'property' => 'description',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '537',
  'objectid' => 'company',
  'type' => 'type',
  'property' => 'name',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '538',
  'objectid' => 'company',
  'type' => 'type',
  'property' => 'title',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '539',
  'objectid' => 'company',
  'type' => 'type',
  'property' => 'body',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '540',
  'objectid' => 'company',
  'type' => 'type',
  'property' => 'description',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '541',
  'objectid' => 'employee',
  'type' => 'type',
  'property' => 'name',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '542',
  'objectid' => 'employee',
  'type' => 'type',
  'property' => 'title',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '543',
  'objectid' => 'employee',
  'type' => 'type',
  'property' => 'body',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '544',
  'objectid' => 'employee',
  'type' => 'type',
  'property' => 'description',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '545',
  'objectid' => 'sponsor',
  'type' => 'type',
  'property' => 'name',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '546',
  'objectid' => 'sponsor',
  'type' => 'type',
  'property' => 'title',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '547',
  'objectid' => 'sponsor',
  'type' => 'type',
  'property' => 'body',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '548',
  'objectid' => 'sponsor',
  'type' => 'type',
  'property' => 'description',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '549',
  'objectid' => 'story',
  'type' => 'type',
  'property' => 'name',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '550',
  'objectid' => 'story',
  'type' => 'type',
  'property' => 'title',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '551',
  'objectid' => 'story',
  'type' => 'type',
  'property' => 'body',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '552',
  'objectid' => 'story',
  'type' => 'type',
  'property' => 'description',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '553',
  'objectid' => 'test_event',
  'type' => 'type',
  'property' => 'name',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '554',
  'objectid' => 'test_event',
  'type' => 'type',
  'property' => 'title',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '555',
  'objectid' => 'test_event',
  'type' => 'type',
  'property' => 'body',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '556',
  'objectid' => 'test_event',
  'type' => 'type',
  'property' => 'description',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '558',
  'objectid' => 'test_page',
  'type' => 'type',
  'property' => 'name',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '559',
  'objectid' => 'test_page',
  'type' => 'type',
  'property' => 'title',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '560',
  'objectid' => 'test_page',
  'type' => 'type',
  'property' => 'body',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '561',
  'objectid' => 'test_page',
  'type' => 'type',
  'property' => 'description',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '562',
  'objectid' => 'test_planet',
  'type' => 'type',
  'property' => 'name',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '563',
  'objectid' => 'test_planet',
  'type' => 'type',
  'property' => 'title',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '564',
  'objectid' => 'test_planet',
  'type' => 'type',
  'property' => 'body',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '565',
  'objectid' => 'test_planet',
  'type' => 'type',
  'property' => 'description',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '566',
  'objectid' => 'test_story',
  'type' => 'type',
  'property' => 'name',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '567',
  'objectid' => 'test_story',
  'type' => 'type',
  'property' => 'title',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '568',
  'objectid' => 'test_story',
  'type' => 'type',
  'property' => 'body',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '569',
  'objectid' => 'test_story',
  'type' => 'type',
  'property' => 'description',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '570',
  'objectid' => 'story-field_test_exclude_unset',
  'type' => 'field',
  'property' => 'widget_label',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '571',
  'objectid' => 'story-field_test_exclude_unset',
  'type' => 'field',
  'property' => 'widget_description',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '572',
  'objectid' => 'story-field_test_two',
  'type' => 'field',
  'property' => 'widget_label',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '573',
  'objectid' => 'story-field_test_two',
  'type' => 'field',
  'property' => 'widget_description',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '574',
  'objectid' => 'story-field_test',
  'type' => 'field',
  'property' => 'widget_label',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '575',
  'objectid' => 'story-field_test',
  'type' => 'field',
  'property' => 'widget_description',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '576',
  'objectid' => 'story-field_test_three',
  'type' => 'field',
  'property' => 'widget_label',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '577',
  'objectid' => 'story-field_test_three',
  'type' => 'field',
  'property' => 'widget_description',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '578',
  'objectid' => 'story-field_test_four',
  'type' => 'field',
  'property' => 'widget_label',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '579',
  'objectid' => 'story-field_test_four',
  'type' => 'field',
  'property' => 'widget_description',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '580',
  'objectid' => 'story-field_test_identical1',
  'type' => 'field',
  'property' => 'widget_label',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '581',
  'objectid' => 'story-field_test_identical1',
  'type' => 'field',
  'property' => 'widget_description',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '582',
  'objectid' => 'story-field_test_identical2',
  'type' => 'field',
  'property' => 'widget_label',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '583',
  'objectid' => 'story-field_test_identical2',
  'type' => 'field',
  'property' => 'widget_description',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '584',
  'objectid' => 'story-field_test_email',
  'type' => 'field',
  'property' => 'widget_label',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '585',
  'objectid' => 'story-field_test_email',
  'type' => 'field',
  'property' => 'widget_description',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '586',
  'objectid' => 'story-field_test_link',
  'type' => 'field',
  'property' => 'widget_label',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '587',
  'objectid' => 'story-field_test_link',
  'type' => 'field',
  'property' => 'widget_description',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '588',
  'objectid' => 'story-field_test_filefield',
  'type' => 'field',
  'property' => 'widget_label',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '589',
  'objectid' => 'story-field_test_filefield',
  'type' => 'field',
  'property' => 'widget_description',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '590',
  'objectid' => 'story-field_test_imagefield',
  'type' => 'field',
  'property' => 'widget_label',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '591',
  'objectid' => 'story-field_test_imagefield',
  'type' => 'field',
  'property' => 'widget_description',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '592',
  'objectid' => 'story-field_test_date',
  'type' => 'field',
  'property' => 'widget_label',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '593',
  'objectid' => 'story-field_test_date',
  'type' => 'field',
  'property' => 'widget_description',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '594',
  'objectid' => 'story-field_test_datestamp',
  'type' => 'field',
  'property' => 'widget_label',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '595',
  'objectid' => 'story-field_test_datestamp',
  'type' => 'field',
  'property' => 'widget_description',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '596',
  'objectid' => 'story-field_test_datetime',
  'type' => 'field',
  'property' => 'widget_label',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '597',
  'objectid' => 'story-field_test_datetime',
  'type' => 'field',
  'property' => 'widget_description',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '598',
  'objectid' => 'story-field_test_phone',
  'type' => 'field',
  'property' => 'widget_label',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '599',
  'objectid' => 'story-field_test_phone',
  'type' => 'field',
  'property' => 'widget_description',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '600',
  'objectid' => 'story-field_test_decimal_radio_buttons',
  'type' => 'field',
  'property' => 'widget_label',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '601',
  'objectid' => 'story-field_test_decimal_radio_buttons',
  'type' => 'field',
  'property' => 'widget_description',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '602',
  'objectid' => 'field_test_decimal_radio_buttons',
  'type' => 'field',
  'property' => 'option_1.2',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '603',
  'objectid' => 'field_test_decimal_radio_buttons',
  'type' => 'field',
  'property' => 'option_2.1',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '604',
  'objectid' => 'story-field_test_float_single_checkbox',
  'type' => 'field',
  'property' => 'widget_label',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '605',
  'objectid' => 'story-field_test_float_single_checkbox',
  'type' => 'field',
  'property' => 'widget_description',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '606',
  'objectid' => 'field_test_float_single_checkbox',
  'type' => 'field',
  'property' => 'option_3.142',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '607',
  'objectid' => 'field_test_float_single_checkbox',
  'type' => 'field',
  'property' => 'option_1.234',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '608',
  'objectid' => 'story-field_test_integer_selectlist',
  'type' => 'field',
  'property' => 'widget_label',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '609',
  'objectid' => 'story-field_test_integer_selectlist',
  'type' => 'field',
  'property' => 'widget_description',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '610',
  'objectid' => 'field_test_integer_selectlist',
  'type' => 'field',
  'property' => 'option_1234',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '611',
  'objectid' => 'field_test_integer_selectlist',
  'type' => 'field',
  'property' => 'option_2341',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '612',
  'objectid' => 'field_test_integer_selectlist',
  'type' => 'field',
  'property' => 'option_3412',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '613',
  'objectid' => 'field_test_integer_selectlist',
  'type' => 'field',
  'property' => 'option_4123',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '614',
  'objectid' => 'story-field_test_text_single_checkbox',
  'type' => 'field',
  'property' => 'widget_label',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '615',
  'objectid' => 'story-field_test_text_single_checkbox',
  'type' => 'field',
  'property' => 'widget_description',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '616',
  'objectid' => 'field_test_text_single_checkbox',
  'type' => 'field',
  'property' => 'option_0',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '617',
  'objectid' => 'field_test_text_single_checkbox',
  'type' => 'field',
  'property' => 'option_1',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '618',
  'objectid' => 'story-field_test_text_single_checkbox2',
  'type' => 'field',
  'property' => 'widget_label',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '619',
  'objectid' => 'story-field_test_text_single_checkbox2',
  'type' => 'field',
  'property' => 'widget_description',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '620',
  'objectid' => 'field_test_text_single_checkbox2',
  'type' => 'field',
  'property' => 'option_Off',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '621',
  'objectid' => 'field_test_text_single_checkbox2',
  'type' => 'field',
  'property' => 'option_Hello',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '622',
  'objectid' => 'test_page-field_test',
  'type' => 'field',
  'property' => 'widget_label',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '623',
  'objectid' => 'test_page-field_test',
  'type' => 'field',
  'property' => 'widget_description',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '624',
  'objectid' => 'test_planet-field_multivalue',
  'type' => 'field',
  'property' => 'widget_label',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '625',
  'objectid' => 'test_planet-field_multivalue',
  'type' => 'field',
  'property' => 'widget_description',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '626',
  'objectid' => 'test_planet-field_test_text_single_checkbox',
  'type' => 'field',
  'property' => 'widget_label',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '627',
  'objectid' => 'test_planet-field_test_text_single_checkbox',
  'type' => 'field',
  'property' => 'widget_description',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '633',
  'objectid' => '140',
  'type' => 'item',
  'property' => 'title',
  'objectindex' => '140',
  'format' => '0',
))
->values(array(
  'lid' => '634',
  'objectid' => '139',
  'type' => 'item',
  'property' => 'title',
  'objectindex' => '139',
  'format' => '0',
))
->values(array(
  'lid' => '635',
  'objectid' => '139',
  'type' => 'item',
  'property' => 'description',
  'objectindex' => '139',
  'format' => '0',
))
->values(array(
  'lid' => '1664',
  'objectid' => 'forum',
  'type' => 'type',
  'property' => 'name',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '1665',
  'objectid' => 'forum',
  'type' => 'type',
  'property' => 'title',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '1666',
  'objectid' => 'forum',
  'type' => 'type',
  'property' => 'body',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '1667',
  'objectid' => 'forum',
  'type' => 'type',
  'property' => 'description',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '1672',
  'objectid' => '6',
  'type' => 'vocabulary',
  'property' => 'name',
  'objectindex' => '6',
  'format' => '0',
))
->values(array(
  'lid' => '1673',
  'objectid' => '7',
  'type' => 'vocabulary',
  'property' => 'name',
  'objectindex' => '7',
  'format' => '0',
))
->values(array(
  'lid' => '1674',
  'objectid' => '463',
  'type' => 'item',
  'property' => 'title',
  'objectindex' => '463',
  'format' => '0',
))
->values(array(
  'lid' => '1675',
  'objectid' => '463',
  'type' => 'item',
  'property' => 'description',
  'objectindex' => '463',
  'format' => '0',
))
->values(array(
  'lid' => '1676',
  'objectid' => '138',
  'type' => 'item',
  'property' => 'title',
  'objectindex' => '138',
  'format' => '0',
))
->values(array(
  'lid' => '1677',
  'objectid' => '138',
  'type' => 'item',
  'property' => 'description',
  'objectindex' => '138',
  'format' => '0',
))
->values(array(
  'lid' => '1678',
  'objectid' => 'profile_really_really_love_migrating',
  'type' => 'field',
  'property' => 'title',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '1679',
  'objectid' => 'menu-translation-test',
  'type' => 'menu',
  'property' => 'title',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '1680',
  'objectid' => 'employee-field_company',
  'type' => 'field',
  'property' => 'widget_label',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '1681',
  'objectid' => 'employee-field_commander',
  'type' => 'field',
  'property' => 'widget_label',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '1682',
  'objectid' => 'employee-field_company_2',
  'type' => 'field',
  'property' => 'widget_label',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '1683',
  'objectid' => 'employee-field_company_3',
  'type' => 'field',
  'property' => 'widget_label',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '1684',
  'objectid' => 'page-field_reference',
  'type' => 'field',
  'property' => 'widget_label',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '1685',
  'objectid' => 'page-field_reference_2',
  'type' => 'field',
  'property' => 'widget_label',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '1686',
  'objectid' => 'story-field_test_string_selectlist',
  'type' => 'field',
  'property' => 'widget_label',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '1689',
  'objectid' => 'test_planet-field_test_text_single_checkbox',
  'type' => 'field',
  'property' => 'widget_label',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '1690',
  'objectid' => 'field_test_string_selectlist',
  'type' => 'field',
  'property' => 'option_A',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '1691',
  'objectid' => 'field_test_string_selectlist',
  'type' => 'field',
  'property' => 'option_B',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '1692',
  'objectid' => '14',
  'type' => 'term',
  'property' => 'name',
  'objectindex' => '14',
  'format' => '0',
))
->values(array(
  'lid' => '1693',
  'objectid' => '15',
  'type' => 'term',
  'property' => 'name',
  'objectindex' => '15',
  'format' => '0',
))
->values(array(
  'lid' => '1694',
  'objectid' => '14',
  'type' => 'term',
  'property' => 'description',
  'objectindex' => '14',
  'format' => '0',
))
->values(array(
  'lid' => '1695',
  'objectid' => 'profile_count_trees',
  'type' => 'field',
  'property' => 'title',
  'objectindex' => '0',
  'format' => '0',
))
->values(array(
  'lid' => '1696',
  'objectid' => 'profile_count_trees',
  'type' => 'field',
  'property' => 'options',
  'objectindex' => '0',
  'format' => '0',
))
->execute();
$connection->schema()->createTable('i18n_variable', array(
  'fields' => array(
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
      'default' => '',
    ),
    'value' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'big',
    ),
  ),
  'primary key' => array(
    'name',
    'language',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('i18n_variable')
->fields(array(
  'name',
  'language',
  'value',
))
->values(array(
  'name' => 'array_filter',
  'language' => 'en',
  'value' => 'b:1;',
))
->values(array(
  'name' => 'i18nstrings_allowed_formats',
  'language' => 'en',
  'value' => 'a:2:{i:0;i:1;i:1;i:2;}',
))
->values(array(
  'name' => 'statistics_count_content_views',
  'language' => 'en',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'statistics_enable_access_log',
  'language' => 'en',
  'value' => 's:1:"0";',
))
->values(array(
  'name' => 'statistics_flush_accesslog_timer',
  'language' => 'en',
  'value' => 's:6:"259200";',
))
->values(array(
  'name' => 'anonymous',
  'language' => 'fr',
  'value' => 's:8:"fr Guest";',
))
->values(array(
  'name' => 'error_level',
  'language' => 'fr',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'site_403',
  'language' => 'fr',
  'value' => 's:7:"fr-user";',
))
->values(array(
  'name' => 'site_404',
  'language' => 'fr',
  'value' => 's:17:"fr-page-not-found";',
))
->values(array(
  'name' => 'site_footer',
  'language' => 'fr',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'site_frontpage',
  'language' => 'fr',
  'value' => 's:4:"node";',
))
->values(array(
  'name' => 'site_mail',
  'language' => 'fr',
  'value' => 's:24:"fr_site_mail@example.com";',
))
->values(array(
  'name' => 'site_mission',
  'language' => 'fr',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'site_name',
  'language' => 'fr',
  'value' => 's:12:"fr site name";',
))
->values(array(
  'name' => 'site_offline',
  'language' => 'fr',
  'value' => 's:1:"0";',
))
->values(array(
  'name' => 'site_offline_message',
  'language' => 'fr',
  'value' => 's:99:"fr - Drupal is currently under maintenance. We should be back shortly. Thank you for your patience.";',
))
->values(array(
  'name' => 'site_slogan',
  'language' => 'fr',
  'value' => 's:16:"fr Migrate rocks";',
))
->values(array(
  'name' => 'user_email_verification',
  'language' => 'fr',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'user_mail_password_reset_body',
  'language' => 'fr',
  'value' => "s:424:\"fr - !username,\r\n\r\nA request to reset the password for your account has been made at !site.\r\n\r\nYou may now log in to !uri_brief by clicking on this link or copying and pasting it in your browser:\r\n\r\n!login_url\r\n\r\nThis is a one-time login, so it can be used only once. It expires after one day and nothing will happen if it's not used.\r\n\r\nAfter logging in, you will be redirected to !edit_uri so you can change your password.\";",
))
->values(array(
  'name' => 'user_mail_password_reset_subject',
  'language' => 'fr',
  'value' => 's:57:"fr - Replacement login information for !username at !site";',
))
->values(array(
  'name' => 'user_mail_register_admin_created_body',
  'language' => 'fr',
  'value' => "s:473:\"fr - !username,\r\n\r\nA site administrator at !site has created an account for you. You may now log in to !login_uri using the following username and password:\r\n\r\nusername: !username\r\npassword: !password\r\n\r\nYou may also log in by clicking on this link or copying and pasting it in your browser:\r\n\r\n!login_url\r\n\r\nThis is a one-time login, so it can be used only once.\r\n\r\nAfter logging in, you will be redirected to !edit_uri so you can change your password.\r\n\r\n\r\n--  !site team\";",
))
->values(array(
  'name' => 'user_mail_register_admin_created_subject',
  'language' => 'fr',
  'value' => 's:57:"fr - An administrator created an account for you at !site";',
))
->values(array(
  'name' => 'user_mail_register_no_approval_required_body',
  'language' => 'fr',
  'value' => "s:447:\"fr - !username,\r\n\r\nThank you for registering at !site. You may now log in to !login_uri using the following username and password:\r\n\r\nusername: !username\r\npassword: !password\r\n\r\nYou may also log in by clicking on this link or copying and pasting it in your browser:\r\n\r\n!login_url\r\n\r\nThis is a one-time login, so it can be used only once.\r\n\r\nAfter logging in, you will be redirected to !edit_uri so you can change your password.\r\n\r\n\r\n--  !site team\";",
))
->values(array(
  'name' => 'user_mail_register_no_approval_required_subject',
  'language' => 'fr',
  'value' => 's:43:"fr - Account details for !username at !site";',
))
->values(array(
  'name' => 'user_mail_register_pending_approval_body',
  'language' => 'fr',
  'value' => "s:277:\"fr - !username,\r\n\r\nThank you for registering at !site. Your application for an account is currently pending approval. Once it has been approved, you will receive another email containing information about how to log in, set your password, and other details.\r\n\r\n\r\n--  !site team\";",
))
->values(array(
  'name' => 'user_mail_register_pending_approval_subject',
  'language' => 'fr',
  'value' => 's:68:"fr - Account details for !username at !site (pending admin approval)";',
))
->values(array(
  'name' => 'user_mail_status_activated_body',
  'language' => 'fr',
  'value' => "s:439:\"fr - !username,\r\n\r\nYour account at !site has been activated.\r\n\r\nYou may now log in by clicking on this link or copying and pasting it in your browser:\r\n\r\n!login_url\r\n\r\nThis is a one-time login, so it can be used only once.\r\n\r\nAfter logging in, you will be redirected to !edit_uri so you can change your password.\r\n\r\nOnce you have set your own password, you will be able to log in to !login_uri in the future using:\r\n\r\nusername: !username\r\n\";",
))
->values(array(
  'name' => 'user_mail_status_activated_notify',
  'language' => 'fr',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'user_mail_status_activated_subject',
  'language' => 'fr',
  'value' => 's:54:"fr - Account details for !username at !site (approved)";',
))
->values(array(
  'name' => 'user_mail_status_blocked_body',
  'language' => 'fr',
  'value' => "s:58:\"fr - !username,\r\n\r\nYour account on !site has been blocked.\";",
))
->values(array(
  'name' => 'user_mail_status_blocked_notify',
  'language' => 'fr',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'user_mail_status_blocked_subject',
  'language' => 'fr',
  'value' => 's:53:"fr - Account details for !username at !site (blocked)";',
))
->values(array(
  'name' => 'user_mail_status_deleted_body',
  'language' => 'fr',
  'value' => "s:58:\"fr - !username,\r\n\r\nYour account on !site has been deleted.\";",
))
->values(array(
  'name' => 'user_mail_status_deleted_notify',
  'language' => 'fr',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'user_mail_status_deleted_subject',
  'language' => 'fr',
  'value' => 's:53:"fr - Account details for !username at !site (deleted)";',
))
->values(array(
  'name' => 'user_pictures',
  'language' => 'fr',
  'value' => 's:1:"0";',
))
->values(array(
  'name' => 'user_picture_default',
  'language' => 'fr',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'user_picture_dimensions',
  'language' => 'fr',
  'value' => 's:5:"85x85";',
))
->values(array(
  'name' => 'user_picture_file_size',
  'language' => 'fr',
  'value' => 's:2:"30";',
))
->values(array(
  'name' => 'user_picture_guidelines',
  'language' => 'fr',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'user_picture_path',
  'language' => 'fr',
  'value' => 's:8:"pictures";',
))
->values(array(
  'name' => 'user_register',
  'language' => 'fr',
  'value' => 's:1:"0";',
))
->values(array(
  'name' => 'user_registration_help',
  'language' => 'fr',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'user_signatures',
  'language' => 'fr',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'anonymous',
  'language' => 'zu',
  'value' => 's:5:"Guest";',
))
->values(array(
  'name' => 'error_level',
  'language' => 'zu',
  'value' => 's:1:"1";',
))
->values(array(
  'name' => 'site_403',
  'language' => 'zu',
  'value' => 's:7:"zu-user";',
))
->values(array(
  'name' => 'site_404',
  'language' => 'zu',
  'value' => 's:17:"zu-page-not-found";',
))
->values(array(
  'name' => 'site_footer',
  'language' => 'zu',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'site_frontpage',
  'language' => 'zu',
  'value' => 's:4:"node";',
))
->values(array(
  'name' => 'site_mail',
  'language' => 'zu',
  'value' => 's:21:"site_mail@example.com";',
))
->values(array(
  'name' => 'site_mission',
  'language' => 'zu',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'site_name',
  'language' => 'zu',
  'value' => 's:14:"zu - site_name";',
))
->values(array(
  'name' => 'site_slogan',
  'language' => 'zu',
  'value' => 's:13:"Migrate rocks";',
))
->values(array(
  'name' => 'user_email_verification',
  'language' => 'zu',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'user_mail_password_reset_body',
  'language' => 'zu',
  'value' => "s:419:\"!username,\r\n\r\nA request to reset the password for your account has been made at !site.\r\n\r\nYou may now log in to !uri_brief by clicking on this link or copying and pasting it in your browser:\r\n\r\n!login_url\r\n\r\nThis is a one-time login, so it can be used only once. It expires after one day and nothing will happen if it's not used.\r\n\r\nAfter logging in, you will be redirected to !edit_uri so you can change your password.\";",
))
->values(array(
  'name' => 'user_mail_password_reset_subject',
  'language' => 'zu',
  'value' => 's:52:"Replacement login information for !username at !site";',
))
->values(array(
  'name' => 'user_mail_register_admin_created_body',
  'language' => 'zu',
  'value' => "s:473:\"zu - !username,\r\n\r\nA site administrator at !site has created an account for you. You may now log in to !login_uri using the following username and password:\r\n\r\nusername: !username\r\npassword: !password\r\n\r\nYou may also log in by clicking on this link or copying and pasting it in your browser:\r\n\r\n!login_url\r\n\r\nThis is a one-time login, so it can be used only once.\r\n\r\nAfter logging in, you will be redirected to !edit_uri so you can change your password.\r\n\r\n\r\n--  !site team\";",
))
->values(array(
  'name' => 'user_mail_register_admin_created_subject',
  'language' => 'zu',
  'value' => 's:57:"zu - An administrator created an account for you at !site";',
))
->values(array(
  'name' => 'user_mail_register_no_approval_required_body',
  'language' => 'zu',
  'value' => "s:442:\"!username,\r\n\r\nThank you for registering at !site. You may now log in to !login_uri using the following username and password:\r\n\r\nusername: !username\r\npassword: !password\r\n\r\nYou may also log in by clicking on this link or copying and pasting it in your browser:\r\n\r\n!login_url\r\n\r\nThis is a one-time login, so it can be used only once.\r\n\r\nAfter logging in, you will be redirected to !edit_uri so you can change your password.\r\n\r\n\r\n--  !site team\";",
))
->values(array(
  'name' => 'user_mail_register_no_approval_required_subject',
  'language' => 'zu',
  'value' => 's:38:"Account details for !username at !site";',
))
->values(array(
  'name' => 'user_mail_register_pending_approval_body',
  'language' => 'zu',
  'value' => "s:272:\"!username,\r\n\r\nThank you for registering at !site. Your application for an account is currently pending approval. Once it has been approved, you will receive another email containing information about how to log in, set your password, and other details.\r\n\r\n\r\n--  !site team\";",
))
->values(array(
  'name' => 'user_mail_register_pending_approval_subject',
  'language' => 'zu',
  'value' => 's:63:"Account details for !username at !site (pending admin approval)";',
))
->values(array(
  'name' => 'user_mail_status_activated_body',
  'language' => 'zu',
  'value' => "s:434:\"!username,\r\n\r\nYour account at !site has been activated.\r\n\r\nYou may now log in by clicking on this link or copying and pasting it in your browser:\r\n\r\n!login_url\r\n\r\nThis is a one-time login, so it can be used only once.\r\n\r\nAfter logging in, you will be redirected to !edit_uri so you can change your password.\r\n\r\nOnce you have set your own password, you will be able to log in to !login_uri in the future using:\r\n\r\nusername: !username\r\n\";",
))
->values(array(
  'name' => 'user_mail_status_activated_notify',
  'language' => 'zu',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'user_mail_status_activated_subject',
  'language' => 'zu',
  'value' => 's:49:"Account details for !username at !site (approved)";',
))
->values(array(
  'name' => 'user_mail_status_blocked_body',
  'language' => 'zu',
  'value' => "s:53:\"!username,\r\n\r\nYour account on !site has been blocked.\";",
))
->values(array(
  'name' => 'user_mail_status_blocked_notify',
  'language' => 'zu',
  'value' => 'i:1;',
))
->values(array(
  'name' => 'user_mail_status_blocked_subject',
  'language' => 'zu',
  'value' => 's:48:"Account details for !username at !site (blocked)";',
))
->values(array(
  'name' => 'user_mail_status_deleted_body',
  'language' => 'zu',
  'value' => "s:53:\"!username,\r\n\r\nYour account on !site has been deleted.\";",
))
->values(array(
  'name' => 'user_mail_status_deleted_notify',
  'language' => 'zu',
  'value' => 'i:0;',
))
->values(array(
  'name' => 'user_mail_status_deleted_subject',
  'language' => 'zu',
  'value' => 's:48:"Account details for !username at !site (deleted)";',
))
->values(array(
  'name' => 'user_pictures',
  'language' => 'zu',
  'value' => 's:1:"0";',
))
->values(array(
  'name' => 'user_picture_default',
  'language' => 'zu',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'user_picture_dimensions',
  'language' => 'zu',
  'value' => 's:5:"85x85";',
))
->values(array(
  'name' => 'user_picture_file_size',
  'language' => 'zu',
  'value' => 's:2:"30";',
))
->values(array(
  'name' => 'user_picture_guidelines',
  'language' => 'zu',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'user_picture_path',
  'language' => 'zu',
  'value' => 's:8:"pictures";',
))
->values(array(
  'name' => 'user_register',
  'language' => 'zu',
  'value' => 's:1:"0";',
))
->values(array(
  'name' => 'user_registration_help',
  'language' => 'zu',
  'value' => 's:0:"";',
))
->values(array(
  'name' => 'user_signatures',
  'language' => 'zu',
  'value' => 's:1:"1";',
))
->execute();
$connection->schema()->createTable('imagecache_action', array(
  'fields' => array(
    'actionid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'presetid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ),
    'action' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ),
    'data' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'actionid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('imagecache_action')
->fields(array(
  'actionid',
  'presetid',
  'weight',
  'module',
  'action',
  'data',
))
->values(array(
  'actionid' => '3',
  'presetid' => '1',
  'weight' => '0',
  'module' => 'imagecache',
  'action' => 'imagecache_scale_and_crop',
  'data' => 'a:2:{s:5:"width";s:4:"100%";s:6:"height";s:4:"100%";}',
))
->values(array(
  'actionid' => '4',
  'presetid' => '2',
  'weight' => '0',
  'module' => 'imagecache',
  'action' => 'imagecache_crop',
  'data' => 'a:4:{s:5:"width";s:3:"555";s:6:"height";s:4:"5555";s:7:"xoffset";s:6:"center";s:7:"yoffset";s:6:"center";}',
))
->values(array(
  'actionid' => '5',
  'presetid' => '2',
  'weight' => '0',
  'module' => 'imagecache',
  'action' => 'imagecache_resize',
  'data' => 'a:2:{s:5:"width";s:3:"55%";s:6:"height";s:3:"55%";}',
))
->values(array(
  'actionid' => '6',
  'presetid' => '2',
  'weight' => '0',
  'module' => 'imagecache',
  'action' => 'imagecache_rotate',
  'data' => 'a:3:{s:7:"degrees";s:2:"55";s:6:"random";i:0;s:7:"bgcolor";s:0:"";}',
))
  ->values(array(
  'actionid' => '7',
  'presetid' => '2',
  'weight' => '0',
  'module' => 'imagecache',
  'action' => '',
  'data' => 'a:3:{s:7:"degrees";s:2:"55";s:6:"random";i:0;s:7:"bgcolor";s:0:"";}',
  ))
->execute();
$connection->schema()->createTable('imagecache_preset', array(
  'fields' => array(
    'presetid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'presetname' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
    ),
  ),
  'primary key' => array(
    'presetid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('imagecache_preset')
->fields(array(
  'presetid',
  'presetname',
))
->values(array(
  'presetid' => '1',
  'presetname' => 'slackjaw_boys',
))
->values(array(
  'presetid' => '2',
  'presetname' => 'big_blue_cheese',
))
->execute();
$connection->schema()->createTable('languages', array(
  'fields' => array(
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
      'default' => '',
    ),
    'name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'native' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '64',
      'default' => '',
    ),
    'direction' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'enabled' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'plurals' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'formula' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'domain' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'prefix' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '128',
      'default' => '',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'javascript' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
  ),
  'primary key' => array(
    'language',
  ),
  'indexes' => array(
    'list' => array(
      'weight',
      'name',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('languages')
->fields(array(
  'language',
  'name',
  'native',
  'direction',
  'enabled',
  'plurals',
  'formula',
  'domain',
  'prefix',
  'weight',
  'javascript',
))
->values(array(
  'language' => 'en',
  'name' => 'English',
  'native' => 'English',
  'direction' => '0',
  'enabled' => '1',
  'plurals' => '0',
  'formula' => '',
  'domain' => '',
  'prefix' => '',
  'weight' => '0',
  'javascript' => '',
))
->values(array(
  'language' => 'fr',
  'name' => 'French',
  'native' => 'Français',
  'direction' => '0',
  'enabled' => '1',
  'plurals' => '2',
  'formula' => '($n>1)',
  'domain' => 'http://fr.drupal.org',
  'prefix' => 'fr',
  'weight' => '0',
  'javascript' => '047746d30d76aa44a54db9923c7c5fb0',
))
->values(array(
  'language' => 'zu',
  'name' => 'Zulu',
  'native' => 'isiZulu',
  'direction' => '0',
  'enabled' => '1',
  'plurals' => '0',
  'formula' => '',
  'domain' => 'http://zu.drupal.org',
  'prefix' => 'zu',
  'weight' => '0',
  'javascript' => '',
))
->execute();
$connection->schema()->createTable('locales_source', array(
  'fields' => array(
    'lid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'location' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'textgroup' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => 'default',
    ),
    'source' => array(
      'type' => 'blob',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'version' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '20',
      'default' => 'none',
    ),
  ),
  'primary key' => array(
    'lid',
  ),
  'indexes' => array(
    'source' => array(
      array(
        'source',
        '30',
      ),
    ),
    'textgroup_location' => array(
      array(
        'textgroup',
        '30',
      ),
      array(
        'location',
        '191',
      ),
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('locales_source')
->fields(array(
  'lid',
  'location',
  'textgroup',
  'source',
  'version',
))
->values(array(
  'lid' => '1',
  'location' => 'misc/drupal.js',
  'textgroup' => 'default',
  'source' => 'Unspecified error',
  'version' => 'none',
))
->values(array(
  'lid' => '2',
  'location' => 'misc/drupal.js',
  'textgroup' => 'default',
  'source' => 'An error occurred. \n@uri\n@text',
  'version' => 'none',
))
->values(array(
  'lid' => '3',
  'location' => 'misc/drupal.js',
  'textgroup' => 'default',
  'source' => 'An error occurred. \n@uri\n(no information available).',
  'version' => 'none',
))
->values(array(
  'lid' => '4',
  'location' => 'misc/drupal.js',
  'textgroup' => 'default',
  'source' => 'An HTTP error @status occurred. \n@uri',
  'version' => 'none',
))
->values(array(
  'lid' => '5',
  'location' => 'content.module:21',
  'textgroup' => 'default',
  'source' => 'The content module, a required component of the Content Construction Kit (CCK), allows administrators to associate custom fields with content types. In Drupal, content types are used to define the characteristics of a post, including the title and description of the fields displayed on its add and edit pages. Using the content module (and the other helper modules included in CCK), custom fields beyond the default "Title" and "Body" may be added. CCK features are accessible through tabs on the <a href="@content-types">content types administration page</a>. (See the <a href="@node-help">node module help page</a> for more information about content types.)',
  'version' => 'none',
))
->values(array(
  'lid' => '6',
  'location' => 'content.module:22',
  'textgroup' => 'default',
  'source' => 'When adding a custom field to a content type, you determine its type (whether it will contain text, numbers, or references to other objects) and how it will be displayed (either as a text field or area, a select box, checkbox, radio button, or autocompleting field). A field may have multiple values (i.e., a "person" may have multiple e-mail addresses) or a single value (i.e., an "employee" has a single employee identification number). As you add and edit fields, CCK automatically adjusts the structure of the database as necessary. CCK also provides a number of other features, including intelligent caching for your custom data, an import and export facility for content type definitions, and integration with other contributed modules.',
  'version' => 'none',
))
->values(array(
  'lid' => '7',
  'location' => 'content.module:23',
  'textgroup' => 'default',
  'source' => 'Custom field types are provided by a set of optional modules included with CCK (each module provides a different type). The <a href="@modules">modules page</a> allows you to enable or disable CCK components. A default installation of CCK includes:',
  'version' => 'none',
))
->values(array(
  'lid' => '8',
  'location' => 'content.module:25',
  'textgroup' => 'default',
  'source' => '<em>number</em>, which adds numeric field types, in integer, decimal or floating point form. You may define a set of allowed inputs, or specify an allowable range of values. A variety of common formats for displaying numeric data are available.',
  'version' => 'none',
))
->values(array(
  'lid' => '9',
  'location' => 'content.module:26',
  'textgroup' => 'default',
  'source' => "<em>text</em>, which adds text field types. A text field may contain plain text only, or optionally, may use Drupal's input format filters to securely manage rich text input. Text input fields may be either a single line (text field), multiple lines (text area), or for greater input control, a select box, checkbox, or radio buttons. If desired, CCK can validate the input to a set of allowed values.",
  'version' => 'none',
))
->values(array(
  'lid' => '10',
  'location' => 'content.module:27',
  'textgroup' => 'default',
  'source' => '<em>nodereference</em>, which creates custom references between Drupal nodes. By adding a <em>nodereference</em> field and two different content types, for instance, you can easily create complex parent/child relationships between data (multiple "employee" nodes may contain a <em>nodereference</em> field linking to an "employer" node).',
  'version' => 'none',
))
->values(array(
  'lid' => '11',
  'location' => 'content.module:28',
  'textgroup' => 'default',
  'source' => "<em>userreference</em>, which creates custom references to your sites' user accounts. By adding a <em>userreference</em> field, you can create complex relationships between your site's users and posts. To track user involvement in a post beyond Drupal's standard <em>Authored by</em> field, for instance, add a <em>userreference</em> field named \"Edited by\" to a content type to store a link to an editor's user account page.",
  'version' => 'none',
))
->values(array(
  'lid' => '12',
  'location' => 'content.module:29',
  'textgroup' => 'default',
  'source' => '<em>fieldgroup</em>, which creates collapsible fieldsets to hold a group of related fields. A fieldset may either be open or closed by default. The order of your fieldsets, and the order of fields within a fieldset, is managed via a drag-and-drop interface provided by content module.',
  'version' => 'none',
))
->values(array(
  'lid' => '13',
  'location' => 'content.module:31',
  'textgroup' => 'default',
  'source' => 'For more information, see the online handbook entry for <a href="@handbook-cck">CCK</a> or the <a href="@project-cck">CCK project page</a>.',
  'version' => 'none',
))
->values(array(
  'lid' => '14',
  'location' => 'theme/theme.inc:111',
  'textgroup' => 'default',
  'source' => "Configure how this content type's fields and field labels should be displayed when it's viewed in teaser and full-page mode.",
  'version' => 'none',
))
->values(array(
  'lid' => '15',
  'location' => 'theme/theme.inc:114',
  'textgroup' => 'default',
  'source' => "Configure how this content type's fields should be displayed when it's rendered in the following contexts.",
  'version' => 'none',
))
->values(array(
  'lid' => '16',
  'location' => 'content.module:48',
  'textgroup' => 'default',
  'source' => 'Control the order of fields in the input form.',
  'version' => 'none',
))
->values(array(
  'lid' => '17',
  'location' => 'content.module:492',
  'textgroup' => 'default',
  'source' => 'This field is required.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '18',
  'location' => 'content.module:496',
  'textgroup' => 'default',
  'source' => '!title: !required',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '19',
  'location' => 'content.module:499,  modules/content_multigroup/content_multigroup.module:903',
  'textgroup' => 'default',
  'source' => 'Order',
  'version' => 'none',
))
->values(array(
  'lid' => '20',
  'location' => 'content.module:1640',
  'textgroup' => 'default',
  'source' => 'RSS Item',
  'version' => 'none',
))
->values(array(
  'lid' => '21',
  'location' => 'content.module:1883',
  'textgroup' => 'default',
  'source' => 'Search Index',
  'version' => 'none',
))
->values(array(
  'lid' => '22',
  'location' => 'content.module:1887',
  'textgroup' => 'default',
  'source' => 'Search Result',
  'version' => 'none',
))
->values(array(
  'lid' => '23',
  'location' => 'content.module:2362',
  'textgroup' => 'default',
  'source' => 'Language',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '24',
  'location' => 'content.module:2376',
  'textgroup' => 'default',
  'source' => 'Taxonomy',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '25',
  'location' => 'content.module:2407',
  'textgroup' => 'default',
  'source' => 'File attachments',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '26',
  'location' => 'content.module:595',
  'textgroup' => 'default',
  'source' => 'Updating field type %type with module %module.',
  'version' => 'none',
))
->values(array(
  'lid' => '27',
  'location' => 'content.module:602',
  'textgroup' => 'default',
  'source' => 'Updating widget type %type with module %module.',
  'version' => 'none',
))
->values(array(
  'lid' => '28',
  'location' => 'content.module:60',
  'textgroup' => 'default',
  'source' => 'Use PHP input for field settings (dangerous - grant with care)',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '29',
  'location' => 'content.module:101',
  'textgroup' => 'default',
  'source' => 'Manage fields',
  'version' => 'none',
))
->values(array(
  'lid' => '30',
  'location' => 'content.module:110',
  'textgroup' => 'default',
  'source' => 'Display fields',
  'version' => 'none',
))
->values(array(
  'lid' => '31',
  'location' => 'content.module:143',
  'textgroup' => 'default',
  'source' => 'General',
  'version' => 'none',
))
->values(array(
  'lid' => '32',
  'location' => 'content.module:149',
  'textgroup' => 'default',
  'source' => 'Advanced',
  'version' => 'none',
))
->values(array(
  'lid' => '33',
  'location' => 'content.module:141',
  'textgroup' => 'default',
  'source' => 'Remove field',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '34',
  'location' => 'content.info:0,  includes/content.rules.inc:19;212,  includes/views/content.views.inc:180;261',
  'textgroup' => 'default',
  'source' => 'Content',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '35',
  'location' => 'content.info:0',
  'textgroup' => 'default',
  'source' => 'Allows administrators to define new content types.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '36',
  'location' => 'content.info:0,  modules/content_copy/content_copy.info:0,  modules/content_permissions/content_permissions.info:0,  modules/fieldgroup/fieldgroup.info:0',
  'textgroup' => 'default',
  'source' => 'CCK',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '37',
  'location' => 'modules/text/text.module:41,  modules/text/text.info:0',
  'textgroup' => 'default',
  'source' => 'Text',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '38',
  'location' => 'examples/example_field.php:178',
  'textgroup' => 'default',
  'source' => 'The possible values this field can contain. Enter one value per line, in the format key|label. The key is the value that will be stored in the database and it must match the field storage type, %type. The label is optional and the key will be used as the label if no label is specified.',
  'version' => 'none',
))
->values(array(
  'lid' => '39',
  'location' => 'examples/example_field.php:484',
  'textgroup' => 'default',
  'source' => 'Text area',
  'version' => 'none',
))
->values(array(
  'lid' => '40',
  'location' => 'includes/content.admin.inc:171;197;895,  modules/fieldgroup/fieldgroup.module:209',
  'textgroup' => 'default',
  'source' => 'Remove',
  'version' => 'none',
))
->values(array(
  'lid' => '41',
  'location' => 'content.module:1854',
  'textgroup' => 'default',
  'source' => 'Basic',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '42',
  'location' => 'content.module:1857,  modules/nodereference/nodereference.module:268',
  'textgroup' => 'default',
  'source' => 'Teaser',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '43',
  'location' => 'content.module:1861,  modules/nodereference/nodereference.module:263',
  'textgroup' => 'default',
  'source' => 'Full node',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '44',
  'location' => 'content.module:1867;1870',
  'textgroup' => 'default',
  'source' => 'RSS',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '45',
  'location' => 'content.module:1880',
  'textgroup' => 'default',
  'source' => 'Search',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '46',
  'location' => 'content.module:2348;2355',
  'textgroup' => 'default',
  'source' => 'Node module form.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '47',
  'location' => 'content.module:2363',
  'textgroup' => 'default',
  'source' => 'Locale module form.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '48',
  'location' => 'content.module:2369',
  'textgroup' => 'default',
  'source' => 'Menu settings',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '49',
  'location' => 'content.module:2370',
  'textgroup' => 'default',
  'source' => 'Menu module form.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '50',
  'location' => 'content.module:2377',
  'textgroup' => 'default',
  'source' => 'Taxonomy module form.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '51',
  'location' => 'content.module:2383',
  'textgroup' => 'default',
  'source' => 'Book',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '52',
  'location' => 'content.module:2384',
  'textgroup' => 'default',
  'source' => 'Book module form.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '53',
  'location' => 'content.module:2390',
  'textgroup' => 'default',
  'source' => 'Poll title',
  'version' => 'none',
))
->values(array(
  'lid' => '54',
  'location' => 'content.module:2391',
  'textgroup' => 'default',
  'source' => 'Poll module title.',
  'version' => 'none',
))
->values(array(
  'lid' => '55',
  'location' => 'content.module:2396',
  'textgroup' => 'default',
  'source' => 'Poll choices',
  'version' => 'none',
))
->values(array(
  'lid' => '56',
  'location' => 'content.module:2397',
  'textgroup' => 'default',
  'source' => 'Poll module choices.',
  'version' => 'none',
))
->values(array(
  'lid' => '57',
  'location' => 'content.module:2400',
  'textgroup' => 'default',
  'source' => 'Poll settings',
  'version' => 'none',
))
->values(array(
  'lid' => '58',
  'location' => 'content.module:2401',
  'textgroup' => 'default',
  'source' => 'Poll module settings.',
  'version' => 'none',
))
->values(array(
  'lid' => '59',
  'location' => 'content.module:2408',
  'textgroup' => 'default',
  'source' => 'Upload module form.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '60',
  'location' => 'content.module:595;602;0,  includes/content.crud.inc:589;633',
  'textgroup' => 'default',
  'source' => 'content',
  'version' => 'none',
))
->values(array(
  'lid' => '61',
  'location' => 'content.module:79',
  'textgroup' => 'default',
  'source' => 'Fields',
  'version' => 'none',
))
->values(array(
  'lid' => '62',
  'location' => 'content.install:236',
  'textgroup' => 'default',
  'source' => "Updates for CCK-related modules are not run until the modules are enabled on the <a href=\"@admin-modules-path\">administer modules page</a>. When you enable them, you'll need to return to <a href=\"@update-php\">update.php</a> and run the remaining updates.",
  'version' => 'none',
))
->values(array(
  'lid' => '63',
  'location' => 'content.install:239',
  'textgroup' => 'default',
  'source' => '!module.module has updates but cannot be updated because content.module is not enabled.<br />If and when content.module is enabled, you will need to re-run the update script. You will continue to see this message until the module is enabled and updates are run.',
  'version' => 'none',
))
->values(array(
  'lid' => '64',
  'location' => 'content.install:244',
  'textgroup' => 'default',
  'source' => '!module.module has updates and is available in the modules folder but is not enabled.<br />If and when it is enabled, you will need to re-run the update script. You will continue to see this message until the module is enabled and updates are run.',
  'version' => 'none',
))
->values(array(
  'lid' => '65',
  'location' => 'content.install:251',
  'textgroup' => 'default',
  'source' => 'Some updates are still pending. Please return to <a href="@update-php">update.php</a> and run the remaining updates.',
  'version' => 'none',
))
->values(array(
  'lid' => '66',
  'location' => '(duplicate) content.install:10',
  'textgroup' => 'default',
  'source' => 'CCK - No Views integration',
  'version' => 'none',
))
->values(array(
  'lid' => '67',
  'location' => '(duplicate) content.install:11',
  'textgroup' => 'default',
  'source' => 'CCK integration with Views module requires Views 6.x-2.0-rc2 or greater.',
  'version' => 'none',
))
->values(array(
  'lid' => '68',
  'location' => 'includes/content.admin.inc:16,  modules/content_copy/content_copy_export_form.tpl.php:11,  theme/content-admin-field-overview-form.tpl.php:12',
  'textgroup' => 'default',
  'source' => 'Name',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '69',
  'location' => 'includes/content.admin.inc:16,  modules/content_copy/content_copy_export_form.tpl.php:12,  theme/content-admin-field-overview-form.tpl.php:13',
  'textgroup' => 'default',
  'source' => 'Type',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '70',
  'location' => 'includes/content.admin.inc:16,  modules/fieldgroup/fieldgroup.module:158',
  'textgroup' => 'default',
  'source' => 'Description',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '71',
  'location' => 'includes/content.admin.inc:16,  theme/content-admin-field-overview-form.tpl.php:14',
  'textgroup' => 'default',
  'source' => 'Operations',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '72',
  'location' => 'includes/content.admin.inc:30',
  'textgroup' => 'default',
  'source' => 'edit',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '73',
  'location' => 'includes/content.admin.inc:33',
  'textgroup' => 'default',
  'source' => 'manage fields',
  'version' => 'none',
))
->values(array(
  'lid' => '74',
  'location' => 'includes/content.admin.inc:36',
  'textgroup' => 'default',
  'source' => 'delete',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '75',
  'location' => 'includes/content.admin.inc:47',
  'textgroup' => 'default',
  'source' => 'No content types available.',
  'version' => 'none',
))
->values(array(
  'lid' => '76',
  'location' => 'includes/content.admin.inc:54',
  'textgroup' => 'default',
  'source' => '» Add a new content type',
  'version' => 'none',
))
->values(array(
  'lid' => '77',
  'location' => 'includes/content.admin.inc:67;796;991',
  'textgroup' => 'default',
  'source' => 'Field name',
  'version' => 'none',
))
->values(array(
  'lid' => '78',
  'location' => 'includes/content.admin.inc:67;811;997',
  'textgroup' => 'default',
  'source' => 'Field type',
  'version' => 'none',
))
->values(array(
  'lid' => '79',
  'location' => 'includes/content.admin.inc:67',
  'textgroup' => 'default',
  'source' => 'Used in',
  'version' => 'none',
))
->values(array(
  'lid' => '80',
  'location' => 'includes/content.admin.inc:71',
  'textgroup' => 'default',
  'source' => '@field_name (Locked)',
  'version' => 'none',
))
->values(array(
  'lid' => '81',
  'location' => 'includes/content.admin.inc:90',
  'textgroup' => 'default',
  'source' => 'No fields have been defined for any content type yet.',
  'version' => 'none',
))
->values(array(
  'lid' => '82',
  'location' => 'not literally, English needs work,  includes/content.admin.inc:106,  fuzzy',
  'textgroup' => 'default',
  'source' => 'This content type has inactive fields. Inactive fields are not included in lists of available fields until their modules are enabled.',
  'version' => 'none',
))
->values(array(
  'lid' => '83',
  'location' => 'includes/content.admin.inc:108',
  'textgroup' => 'default',
  'source' => '!field (!field_name) is an inactive !field_type field that uses a !widget_type widget.',
  'version' => 'none',
))
->values(array(
  'lid' => '84',
  'location' => 'includes/content.admin.inc:170;196',
  'textgroup' => 'default',
  'source' => 'Configure',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '85',
  'location' => 'Schreibgeschützt,  includes/content.admin.inc:181',
  'textgroup' => 'default',
  'source' => 'Locked',
  'version' => 'none',
))
->values(array(
  'lid' => '86',
  'location' => 'includes/content.admin.inc:237',
  'textgroup' => 'default',
  'source' => '- Select a field type -',
  'version' => 'none',
))
->values(array(
  'lid' => '87',
  'location' => 'includes/content.admin.inc:238',
  'textgroup' => 'default',
  'source' => '- Select a widget -',
  'version' => 'none',
))
->values(array(
  'lid' => '88',
  'location' => 'includes/content.admin.inc:244;285;315;804;985,  includes/panels/content_types/content_field.inc:97,  includes/views/handlers/content_handler_field.inc:56',
  'textgroup' => 'default',
  'source' => 'Label',
  'version' => 'none',
))
->values(array(
  'lid' => '89',
  'location' => 'includes/content.admin.inc:253',
  'textgroup' => 'default',
  'source' => 'Field name (a-z, 0-9, _)',
  'version' => 'none',
))
->values(array(
  'lid' => '90',
  'location' => 'includes/content.admin.inc:258',
  'textgroup' => 'default',
  'source' => 'Type of data to store.',
  'version' => 'none',
))
->values(array(
  'lid' => '91',
  'location' => 'includes/content.admin.inc:263;295',
  'textgroup' => 'default',
  'source' => 'Form element to edit the data.',
  'version' => 'none',
))
->values(array(
  'lid' => '92',
  'location' => 'includes/content.admin.inc:279',
  'textgroup' => 'default',
  'source' => '- Select an existing field -',
  'version' => 'none',
))
->values(array(
  'lid' => '93',
  'location' => 'includes/content.admin.inc:290',
  'textgroup' => 'default',
  'source' => 'Field to share',
  'version' => 'none',
))
->values(array(
  'lid' => '94',
  'location' => 'includes/content.admin.inc:324',
  'textgroup' => 'default',
  'source' => 'Group name (a-z, 0-9, _)',
  'version' => 'none',
))
->values(array(
  'lid' => '95',
  'location' => 'includes/content.admin.inc:352;677,  modules/fieldgroup/fieldgroup.module:177;341',
  'textgroup' => 'default',
  'source' => 'Save',
  'version' => 'none',
))
->values(array(
  'lid' => '96',
  'location' => 'includes/content.admin.inc:373',
  'textgroup' => 'default',
  'source' => 'Add new field: you need to provide a label.',
  'version' => 'none',
))
->values(array(
  'lid' => '97',
  'location' => 'includes/content.admin.inc:378',
  'textgroup' => 'default',
  'source' => 'Add new field: you need to provide a field name.',
  'version' => 'none',
))
->values(array(
  'lid' => '98',
  'location' => 'includes/content.admin.inc:392',
  'textgroup' => 'default',
  'source' => 'Add new field: the field name %field_name is invalid. The name must include only lowercase unaccentuated letters, numbers, and underscores.',
  'version' => 'none',
))
->values(array(
  'lid' => '99',
  'location' => 'includes/content.admin.inc:395',
  'textgroup' => 'default',
  'source' => "Add new field: the field name %field_name is too long. The name is limited to 32 characters, including the 'field_' prefix.",
  'version' => 'none',
))
->values(array(
  'lid' => '100',
  'location' => 'includes/content.admin.inc:399',
  'textgroup' => 'default',
  'source' => "Add new field: the name 'field_instance' is a reserved name.",
  'version' => 'none',
))
->values(array(
  'lid' => '101',
  'location' => 'includes/content.admin.inc:411',
  'textgroup' => 'default',
  'source' => 'Add new field: the field name %field_name already exists.',
  'version' => 'none',
))
->values(array(
  'lid' => '102',
  'location' => 'includes/content.admin.inc:417',
  'textgroup' => 'default',
  'source' => 'Add new field: you need to select a field type.',
  'version' => 'none',
))
->values(array(
  'lid' => '103',
  'location' => 'includes/content.admin.inc:422',
  'textgroup' => 'default',
  'source' => 'Add new field: you need to select a widget.',
  'version' => 'none',
))
->values(array(
  'lid' => '104',
  'location' => 'includes/content.admin.inc:428',
  'textgroup' => 'default',
  'source' => 'Add new field: invalid widget.',
  'version' => 'none',
))
->values(array(
  'lid' => '105',
  'location' => 'includes/content.admin.inc:449',
  'textgroup' => 'default',
  'source' => 'Add existing field: you need to provide a label.',
  'version' => 'none',
))
->values(array(
  'lid' => '106',
  'location' => 'includes/content.admin.inc:454',
  'textgroup' => 'default',
  'source' => 'Add existing field: you need to select a field.',
  'version' => 'none',
))
->values(array(
  'lid' => '107',
  'location' => 'includes/content.admin.inc:459',
  'textgroup' => 'default',
  'source' => 'Add existing field: you need to select a widget.',
  'version' => 'none',
))
->values(array(
  'lid' => '108',
  'location' => 'includes/content.admin.inc:465',
  'textgroup' => 'default',
  'source' => 'Add existing field: invalid widget.',
  'version' => 'none',
))
->values(array(
  'lid' => '109',
  'location' => 'includes/content.admin.inc:514',
  'textgroup' => 'default',
  'source' => 'There was a problem creating field %label.',
  'version' => 'none',
))
->values(array(
  'lid' => '110',
  'location' => 'includes/content.admin.inc:526',
  'textgroup' => 'default',
  'source' => 'The field %label cannot be added to a content type because it is locked.',
  'version' => 'none',
))
->values(array(
  'lid' => '111',
  'location' => 'includes/content.admin.inc:536',
  'textgroup' => 'default',
  'source' => 'There was a problem adding field %label.',
  'version' => 'none',
))
->values(array(
  'lid' => '112',
  'location' => 'includes/content.admin.inc:578',
  'textgroup' => 'default',
  'source' => 'There are no fields configured for this content type. You can add new fields on the <a href="@link">Manage fields</a> page.',
  'version' => 'none',
))
->values(array(
  'lid' => '113',
  'location' => 'includes/content.admin.inc:585;633,  includes/panels/content_types/content_field.inc:101,  modules/content_multigroup/content_multigroup.module:352',
  'textgroup' => 'default',
  'source' => 'Above',
  'version' => 'none',
))
->values(array(
  'lid' => '114',
  'location' => 'includes/content.admin.inc:586,  includes/panels/content_types/content_field.inc:102',
  'textgroup' => 'default',
  'source' => 'Inline',
  'version' => 'none',
))
->values(array(
  'lid' => '115',
  'location' => 'includes/content.admin.inc:625;668',
  'textgroup' => 'default',
  'source' => 'Include',
  'version' => 'none',
))
->values(array(
  'lid' => '116',
  'location' => 'includes/content.admin.inc:625;668,  theme/content-admin-display-overview-form.tpl.php:17',
  'textgroup' => 'default',
  'source' => 'Exclude',
  'version' => 'none',
))
->values(array(
  'lid' => '117',
  'location' => 'includes/content.admin.inc:637',
  'textgroup' => 'default',
  'source' => 'no styling',
  'version' => 'none',
))
->values(array(
  'lid' => '118',
  'location' => 'includes/content.admin.inc:638',
  'textgroup' => 'default',
  'source' => 'simple',
  'version' => 'none',
))
->values(array(
  'lid' => '119',
  'location' => 'includes/content.admin.inc:639',
  'textgroup' => 'default',
  'source' => 'fieldset',
  'version' => 'none',
))
->values(array(
  'lid' => '120',
  'location' => 'includes/content.admin.inc:640',
  'textgroup' => 'default',
  'source' => 'fieldset - collapsible',
  'version' => 'none',
))
->values(array(
  'lid' => '121',
  'location' => 'includes/content.admin.inc:641',
  'textgroup' => 'default',
  'source' => 'fieldset - collapsed',
  'version' => 'none',
))
->values(array(
  'lid' => '122',
  'location' => 'includes/content.admin.inc:697',
  'textgroup' => 'default',
  'source' => 'Your settings have been saved.',
  'version' => 'none',
))
->values(array(
  'lid' => '123',
  'location' => 'includes/content.admin.inc:767',
  'textgroup' => 'default',
  'source' => '@type: @field (@label)',
  'version' => 'none',
))
->values(array(
  'lid' => '124',
  'location' => 'includes/content.admin.inc:793',
  'textgroup' => 'default',
  'source' => 'Edit basic information',
  'version' => 'none',
))
->values(array(
  'lid' => '125',
  'location' => 'includes/content.admin.inc:799',
  'textgroup' => 'default',
  'source' => 'The machine-readable name of the field. This name cannot be changed.',
  'version' => 'none',
))
->values(array(
  'lid' => '126',
  'location' => 'includes/content.admin.inc:807',
  'textgroup' => 'default',
  'source' => 'A human-readable name to be used as the label for this field in the %type content type.',
  'version' => 'none',
))
->values(array(
  'lid' => '127',
  'location' => 'includes/content.admin.inc:814',
  'textgroup' => 'default',
  'source' => 'The type of data you would like to store in the database with this field. This option cannot be changed.',
  'version' => 'none',
))
->values(array(
  'lid' => '128',
  'location' => 'includes/content.admin.inc:819;1003',
  'textgroup' => 'default',
  'source' => 'Widget type',
  'version' => 'none',
))
->values(array(
  'lid' => '129',
  'location' => 'includes/content.admin.inc:823',
  'textgroup' => 'default',
  'source' => 'The type of form element you would like to present to the user when creating this field in the %type content type.',
  'version' => 'none',
))
->values(array(
  'lid' => '130',
  'location' => 'includes/content.admin.inc:833,  includes/content.rules.inc:66',
  'textgroup' => 'default',
  'source' => 'Continue',
  'version' => 'none',
))
->values(array(
  'lid' => '131',
  'location' => 'includes/content.admin.inc:861',
  'textgroup' => 'default',
  'source' => 'Updated basic settings for field %label.',
  'version' => 'none',
))
->values(array(
  'lid' => '132',
  'location' => 'includes/content.admin.inc:865',
  'textgroup' => 'default',
  'source' => 'There was a problem updating the basic settings for field %label.',
  'version' => 'none',
))
->values(array(
  'lid' => '133',
  'location' => 'includes/content.admin.inc:892',
  'textgroup' => 'default',
  'source' => 'Are you sure you want to remove the field %field?',
  'version' => 'none',
))
->values(array(
  'lid' => '134',
  'location' => 'includes/content.admin.inc:894',
  'textgroup' => 'default',
  'source' => 'If you have any content left in this field, it will be lost. This action cannot be undone.',
  'version' => 'none',
))
->values(array(
  'lid' => '135',
  'location' => 'includes/content.admin.inc:895,  modules/fieldgroup/fieldgroup.module:209',
  'textgroup' => 'default',
  'source' => 'Cancel',
  'version' => 'none',
))
->values(array(
  'lid' => '136',
  'location' => 'includes/content.admin.inc:901',
  'textgroup' => 'default',
  'source' => 'This field is <strong>locked</strong> and cannot be removed.',
  'version' => 'none',
))
->values(array(
  'lid' => '137',
  'location' => 'includes/content.admin.inc:922',
  'textgroup' => 'default',
  'source' => 'Removed field %field from %type.',
  'version' => 'none',
))
->values(array(
  'lid' => '138',
  'location' => 'includes/content.admin.inc:927',
  'textgroup' => 'default',
  'source' => 'There was a problem deleting %field from %type.',
  'version' => 'none',
))
->values(array(
  'lid' => '139',
  'location' => 'includes/content.admin.inc:946',
  'textgroup' => 'default',
  'source' => 'The field %field is locked and cannot be edited.',
  'version' => 'none',
))
->values(array(
  'lid' => '140',
  'location' => 'includes/content.admin.inc:980',
  'textgroup' => 'default',
  'source' => '%type basic information',
  'version' => 'none',
))
->values(array(
  'lid' => '141',
  'location' => 'includes/content.admin.inc:1010;1189',
  'textgroup' => 'default',
  'source' => 'Change basic information',
  'version' => 'none',
))
->values(array(
  'lid' => '142',
  'location' => 'includes/content.admin.inc:1016',
  'textgroup' => 'default',
  'source' => '%type settings',
  'version' => 'none',
))
->values(array(
  'lid' => '143',
  'location' => 'includes/content.admin.inc:1017',
  'textgroup' => 'default',
  'source' => 'These settings apply only to the %field field as it appears in the %type content type.',
  'version' => 'none',
))
->values(array(
  'lid' => '144',
  'location' => 'includes/content.admin.inc:1031,  modules/fieldgroup/fieldgroup.module:145',
  'textgroup' => 'default',
  'source' => 'Help text',
  'version' => 'none',
))
->values(array(
  'lid' => '145',
  'location' => 'includes/content.admin.inc:1034',
  'textgroup' => 'default',
  'source' => 'Instructions to present to the user below this field on the editing form.<br />Allowed HTML tags: @tags',
  'version' => 'none',
))
->values(array(
  'lid' => '146',
  'location' => 'includes/content.admin.inc:1060',
  'textgroup' => 'default',
  'source' => 'Default value',
  'version' => 'none',
))
->values(array(
  'lid' => '147',
  'location' => 'includes/content.admin.inc:1081,  modules/number/number.module:123,  modules/text/text.module:86',
  'textgroup' => 'default',
  'source' => 'PHP code',
  'version' => 'none',
))
->values(array(
  'lid' => '148',
  'location' => 'includes/content.admin.inc:1090;1245,  includes/content.rules.inc:93',
  'textgroup' => 'default',
  'source' => "'@column' => value for @column",
  'version' => 'none',
))
->values(array(
  'lid' => '149',
  'location' => 'includes/content.admin.inc:1092;1247,  includes/content.rules.inc:95',
  'textgroup' => 'default',
  'source' => "return array(\n  0 => array(@columns),\n  // You'll usually want to stop here. Provide more values\n  // if you want your 'default value' to be multi-valued:\n  1 => array(@columns),\n  2 => ...\n);",
  'version' => 'none',
))
->values(array(
  'lid' => '150',
  'location' => 'includes/content.admin.inc:1096;1109,  includes/content.rules.inc:99,  modules/number/number.module:130;139,  modules/text/text.module:93;102',
  'textgroup' => 'default',
  'source' => 'Code',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '151',
  'location' => 'includes/content.admin.inc:1100',
  'textgroup' => 'default',
  'source' => 'Advanced usage only: PHP code that returns a default value. Should not include &lt;?php ?&gt; delimiters. If this field is filled out, the value returned by this code will override any value specified above. Expected format: <pre>!sample</pre>To figure out the expected format, you can use the <em>devel load</em> tab provided by <a href="@link_devel">devel module</a> on a %type content page.',
  'version' => 'none',
))
->values(array(
  'lid' => '152',
  'location' => 'includes/content.admin.inc:1110,  modules/number/number.module:140,  modules/text/text.module:103',
  'textgroup' => 'default',
  'source' => '&lt;none&gt;',
  'version' => 'none',
))
->values(array(
  'lid' => '153',
  'location' => 'includes/content.admin.inc:1111,  modules/number/number.module:141,  modules/text/text.module:104',
  'textgroup' => 'default',
  'source' => "You're not allowed to input PHP code.",
  'version' => 'none',
))
->values(array(
  'lid' => '154',
  'location' => 'includes/content.admin.inc:1111',
  'textgroup' => 'default',
  'source' => 'This PHP code was set by an administrator and will override any value specified above.',
  'version' => 'none',
))
->values(array(
  'lid' => '155',
  'location' => 'includes/content.admin.inc:1118',
  'textgroup' => 'default',
  'source' => 'Global settings',
  'version' => 'none',
))
->values(array(
  'lid' => '156',
  'location' => 'includes/content.admin.inc:1119',
  'textgroup' => 'default',
  'source' => 'These settings apply to the %field field in every content type in which it appears.',
  'version' => 'none',
))
->values(array(
  'lid' => '157',
  'location' => 'includes/content.admin.inc:1123',
  'textgroup' => 'default',
  'source' => 'Required',
  'version' => 'none',
))
->values(array(
  'lid' => '158',
  'location' => 'includes/content.admin.inc:1126',
  'textgroup' => 'default',
  'source' => 'Maximum number of values users can enter for this field.',
  'version' => 'none',
))
->values(array(
  'lid' => '159',
  'location' => 'includes/content.admin.inc:1128',
  'textgroup' => 'default',
  'source' => "'Unlimited' will provide an 'Add more' button so the users can add as many values as they like.",
  'version' => 'none',
))
->values(array(
  'lid' => '160',
  'location' => 'includes/content.admin.inc:1130',
  'textgroup' => 'default',
  'source' => 'Warning! Changing this setting after data has been created could result in the loss of data!',
  'version' => 'none',
))
->values(array(
  'lid' => '161',
  'location' => 'includes/content.admin.inc:1133',
  'textgroup' => 'default',
  'source' => 'Number of values',
  'version' => 'none',
))
->values(array(
  'lid' => '162',
  'location' => 'includes/content.admin.inc:1134,  modules/content_multigroup/content_multigroup.module:73',
  'textgroup' => 'default',
  'source' => 'Unlimited',
  'version' => 'none',
))
->values(array(
  'lid' => '163',
  'location' => 'includes/content.admin.inc:1151,  modules/content_copy/content_copy.module:251',
  'textgroup' => 'default',
  'source' => 'Save field settings',
  'version' => 'none',
))
->values(array(
  'lid' => '164',
  'location' => 'includes/content.admin.inc:1288',
  'textgroup' => 'default',
  'source' => "The PHP code for 'default value' returned @value, which is invalid.",
  'version' => 'none',
))
->values(array(
  'lid' => '165',
  'location' => 'includes/content.admin.inc:1292',
  'textgroup' => 'default',
  'source' => 'The default value is invalid.',
  'version' => 'none',
))
->values(array(
  'lid' => '166',
  'location' => 'includes/content.admin.inc:1316',
  'textgroup' => 'default',
  'source' => 'Added field %label.',
  'version' => 'none',
))
->values(array(
  'lid' => '167',
  'location' => 'includes/content.admin.inc:1320',
  'textgroup' => 'default',
  'source' => 'Saved field %label.',
  'version' => 'none',
))
->values(array(
  'lid' => '168',
  'location' => 'includes/content.admin.inc:1678',
  'textgroup' => 'default',
  'source' => 'Processing',
  'version' => 'none',
))
->values(array(
  'lid' => '169',
  'location' => 'includes/content.admin.inc:1679',
  'textgroup' => 'default',
  'source' => 'The update has encountered an error.',
  'version' => 'none',
))
->values(array(
  'lid' => '170',
  'location' => 'includes/content.admin.inc:1693',
  'textgroup' => 'default',
  'source' => 'The database has been altered and data has been migrated or deleted.',
  'version' => 'none',
))
->values(array(
  'lid' => '171',
  'location' => 'includes/content.admin.inc:1696',
  'textgroup' => 'default',
  'source' => 'An error occurred and database alteration did not complete.',
  'version' => 'none',
))
->values(array(
  'lid' => '172',
  'location' => 'includes/content.admin.inc:1799',
  'textgroup' => 'default',
  'source' => 'Processing %title',
  'version' => 'none',
))
->values(array(
  'lid' => '173',
  'location' => 'includes/content.admin.inc:1865',
  'textgroup' => 'default',
  'source' => '%name must be an integer.',
  'version' => 'none',
))
->values(array(
  'lid' => '174',
  'location' => 'includes/content.admin.inc:1875',
  'textgroup' => 'default',
  'source' => '%name must be a positive integer.',
  'version' => 'none',
))
->values(array(
  'lid' => '175',
  'location' => 'includes/content.admin.inc:1885',
  'textgroup' => 'default',
  'source' => '%name must be a number.',
  'version' => 'none',
))
->values(array(
  'lid' => '176',
  'location' => 'includes/content.admin.inc:1697',
  'textgroup' => 'default',
  'source' => '1 item successfully processed:',
  'version' => 'none',
))
->values(array(
  'lid' => '177',
  'location' => 'includes/content.admin.inc:1697',
  'textgroup' => 'default',
  'source' => '@count items successfully processed:',
  'version' => 'none',
))
->values(array(
  'lid' => '178',
  'location' => 'includes/content.crud.inc:589',
  'textgroup' => 'default',
  'source' => 'Content fields table %old_name has been renamed to %new_name and field instances have been updated.',
  'version' => 'none',
))
->values(array(
  'lid' => '179',
  'location' => 'includes/content.crud.inc:633',
  'textgroup' => 'default',
  'source' => 'The content fields table %name has been deleted.',
  'version' => 'none',
))
->values(array(
  'lid' => '180',
  'location' => 'includes/content.node_form.inc:223',
  'textgroup' => 'default',
  'source' => 'Add another item',
  'version' => 'none',
))
->values(array(
  'lid' => '181',
  'location' => 'includes/panels/content_types/content_field.inc:14',
  'textgroup' => 'default',
  'source' => 'Content field',
  'version' => 'none',
))
->values(array(
  'lid' => '182',
  'location' => 'includes/content.panels.inc:38',
  'textgroup' => 'default',
  'source' => 'A content field from the referenced node.',
  'version' => 'none',
))
->values(array(
  'lid' => '183',
  'location' => 'includes/panels/content_types/content_field.inc:45,  modules/fieldgroup/fieldgroup.panels.inc:31,  modules/fieldgroup/panels/content_types/content_fieldgroup.inc:43',
  'textgroup' => 'default',
  'source' => 'Node',
  'version' => 'none',
))
->values(array(
  'lid' => '184',
  'location' => 'includes/content.panels.inc:40,  modules/fieldgroup/fieldgroup.panels.inc:32',
  'textgroup' => 'default',
  'source' => 'Node context',
  'version' => 'none',
))
->values(array(
  'lid' => '185',
  'location' => 'includes/panels/content_types/content_field.inc:100',
  'textgroup' => 'default',
  'source' => 'Block title',
  'version' => 'none',
))
->values(array(
  'lid' => '186',
  'location' => 'includes/panels/content_types/content_field.inc:103',
  'textgroup' => 'default',
  'source' => 'Hidden',
  'version' => 'none',
))
->values(array(
  'lid' => '187',
  'location' => 'includes/panels/content_types/content_field.inc:105',
  'textgroup' => 'default',
  'source' => 'Configure how the label is going to be displayed.',
  'version' => 'none',
))
->values(array(
  'lid' => '188',
  'location' => 'includes/content.panels.inc:73',
  'textgroup' => 'default',
  'source' => 'Field / Formatter',
  'version' => 'none',
))
->values(array(
  'lid' => '189',
  'location' => 'includes/content.panels.inc:76',
  'textgroup' => 'default',
  'source' => 'Select a field and formatter.',
  'version' => 'none',
))
->values(array(
  'lid' => '190',
  'location' => 'includes/content.panels.inc:92',
  'textgroup' => 'default',
  'source' => '"@s" field @name',
  'version' => 'none',
))
->values(array(
  'lid' => '191',
  'location' => 'includes/content.rules.inc:15',
  'textgroup' => 'default',
  'source' => 'Populate a field',
  'version' => 'none',
))
->values(array(
  'lid' => '192',
  'location' => 'includes/content.rules.inc:23;224',
  'textgroup' => 'default',
  'source' => 'You should make sure that the used field exists in the given content type.',
  'version' => 'none',
))
->values(array(
  'lid' => '193',
  'location' => 'includes/content.rules.inc:53;276,  modules/nodereference/nodereference.rules.inc:45,  modules/userreference/userreference.rules.inc:47',
  'textgroup' => 'default',
  'source' => 'Field',
  'version' => 'none',
))
->values(array(
  'lid' => '194',
  'location' => 'includes/content.rules.inc:56',
  'textgroup' => 'default',
  'source' => 'Select the machine-name of the field.',
  'version' => 'none',
))
->values(array(
  'lid' => '195',
  'location' => 'includes/content.rules.inc:84',
  'textgroup' => 'default',
  'source' => 'Advanced: Specify the fields value with PHP code',
  'version' => 'none',
))
->values(array(
  'lid' => '196',
  'location' => 'not literally,  includes/content.rules.inc:102',
  'textgroup' => 'default',
  'source' => "Advanced usage only: PHP code that returns the value to set. Should not include &lt;?php ?&gt; delimiters. If this field is filled out, the value returned by this code will override any value specified above. Expected format: <pre>!sample</pre>Using <a href=\"@link_devel\">devel.module's</a> 'devel load' tab on a content page might help you figure out the expected format.",
  'version' => 'none',
))
->values(array(
  'lid' => '197',
  'location' => 'includes/content.rules.inc:130',
  'textgroup' => 'default',
  'source' => 'You have to return the default value in the expected format.',
  'version' => 'none',
))
->values(array(
  'lid' => '198',
  'location' => 'includes/content.rules.inc:193',
  'textgroup' => 'default',
  'source' => "Populate @node's field '@field'",
  'version' => 'none',
))
->values(array(
  'lid' => '199',
  'location' => 'includes/content.rules.inc:210',
  'textgroup' => 'default',
  'source' => 'Field has value',
  'version' => 'none',
))
->values(array(
  'lid' => '200',
  'location' => 'includes/content.rules.inc:215',
  'textgroup' => 'default',
  'source' => 'You should make sure that the used field exists in the given content type. The condition returns TRUE, if the selected field has the given value.',
  'version' => 'none',
))
->values(array(
  'lid' => '201',
  'location' => 'includes/content.rules.inc:219',
  'textgroup' => 'default',
  'source' => 'Field has changed',
  'version' => 'none',
))
->values(array(
  'lid' => '202',
  'location' => 'includes/content.rules.inc:221',
  'textgroup' => 'default',
  'source' => 'Content containing changes',
  'version' => 'none',
))
->values(array(
  'lid' => '203',
  'location' => 'includes/content.rules.inc:222',
  'textgroup' => 'default',
  'source' => 'Content not containing changes',
  'version' => 'none',
))
->values(array(
  'lid' => '204',
  'location' => 'includes/content.rules.inc:259',
  'textgroup' => 'default',
  'source' => "@node's field '@field' has value",
  'version' => 'none',
))
->values(array(
  'lid' => '205',
  'location' => 'not literally,  includes/content.rules.inc:279,  fuzzy',
  'textgroup' => 'default',
  'source' => 'Select the machine-name of the field to look at.',
  'version' => 'none',
))
->values(array(
  'lid' => '206',
  'location' => '@node?,  includes/content.rules.inc:285',
  'textgroup' => 'default',
  'source' => "@node's field '@field' has been changed",
  'version' => 'none',
))
->values(array(
  'lid' => '207',
  'location' => 'includes/content.token.inc:12;15',
  'textgroup' => 'default',
  'source' => 'Token',
  'version' => 'none',
))
->values(array(
  'lid' => '208',
  'location' => 'includes/content.token.inc:81',
  'textgroup' => 'default',
  'source' => 'Referenced node ID',
  'version' => 'none',
))
->values(array(
  'lid' => '209',
  'location' => 'includes/content.token.inc:82',
  'textgroup' => 'default',
  'source' => 'Referenced node title',
  'version' => 'none',
))
->values(array(
  'lid' => '210',
  'location' => 'includes/content.token.inc:83',
  'textgroup' => 'default',
  'source' => 'Referenced node unfiltered title. WARNING - raw user input.',
  'version' => 'none',
))
->values(array(
  'lid' => '211',
  'location' => 'includes/content.token.inc:84',
  'textgroup' => 'default',
  'source' => 'Formatted html link to the referenced node.',
  'version' => 'none',
))
->values(array(
  'lid' => '212',
  'location' => 'includes/content.token.inc:85',
  'textgroup' => 'default',
  'source' => 'Relative path alias to the referenced node.',
  'version' => 'none',
))
->values(array(
  'lid' => '213',
  'location' => 'includes/content.token.inc:86',
  'textgroup' => 'default',
  'source' => 'Absolute path alias to the referenced node.',
  'version' => 'none',
))
->values(array(
  'lid' => '214',
  'location' => 'includes/content.token.inc:114',
  'textgroup' => 'default',
  'source' => 'Raw number value',
  'version' => 'none',
))
->values(array(
  'lid' => '215',
  'location' => 'includes/content.token.inc:115',
  'textgroup' => 'default',
  'source' => 'Formatted number value',
  'version' => 'none',
))
->values(array(
  'lid' => '216',
  'location' => 'includes/content.token.inc:138',
  'textgroup' => 'default',
  'source' => 'Raw, unfiltered text',
  'version' => 'none',
))
->values(array(
  'lid' => '217',
  'location' => 'includes/content.token.inc:139',
  'textgroup' => 'default',
  'source' => 'Formatted and filtered text',
  'version' => 'none',
))
->values(array(
  'lid' => '218',
  'location' => 'includes/content.token.inc:161',
  'textgroup' => 'default',
  'source' => 'Referenced user ID',
  'version' => 'none',
))
->values(array(
  'lid' => '219',
  'location' => 'includes/content.token.inc:162',
  'textgroup' => 'default',
  'source' => 'Referenced user name',
  'version' => 'none',
))
->values(array(
  'lid' => '220',
  'location' => 'includes/content.token.inc:163',
  'textgroup' => 'default',
  'source' => 'Formatted HTML link to referenced user',
  'version' => 'none',
))
->values(array(
  'lid' => '221',
  'location' => 'includes/content.token.inc:164',
  'textgroup' => 'default',
  'source' => 'Relative path alias to the referenced user.',
  'version' => 'none',
))
->values(array(
  'lid' => '222',
  'location' => 'includes/content.token.inc:165',
  'textgroup' => 'default',
  'source' => 'Absolute path alias to the referenced user.',
  'version' => 'none',
))
->values(array(
  'lid' => '223',
  'location' => 'includes/views/content.views.inc:245;261',
  'textgroup' => 'default',
  'source' => '@label (!name)',
  'version' => 'none',
))
->values(array(
  'lid' => '224',
  'location' => 'includes/views/content.views.inc:249',
  'textgroup' => 'default',
  'source' => '@label (!name) - !column',
  'version' => 'none',
))
->values(array(
  'lid' => '225',
  'location' => 'includes/views/content.views.inc:250',
  'textgroup' => 'default',
  'source' => '@label-truncated - !column',
  'version' => 'none',
))
->values(array(
  'lid' => '226',
  'location' => 'includes/views/content.views.inc:257',
  'textgroup' => 'default',
  'source' => 'Appears in: @types',
  'version' => 'none',
))
->values(array(
  'lid' => '227',
  'location' => 'includes/views/handlers/content_handler_field.inc:56',
  'textgroup' => 'default',
  'source' => 'None',
  'version' => 'none',
))
->values(array(
  'lid' => '228',
  'location' => 'includes/views/handlers/content_handler_field.inc:57',
  'textgroup' => 'default',
  'source' => 'Widget label (@label)',
  'version' => 'none',
))
->values(array(
  'lid' => '229',
  'location' => 'includes/views/handlers/content_handler_field.inc:58',
  'textgroup' => 'default',
  'source' => 'Custom',
  'version' => 'none',
))
->values(array(
  'lid' => '230',
  'location' => 'includes/views/handlers/content_handler_field.inc:64',
  'textgroup' => 'default',
  'source' => 'Custom label',
  'version' => 'none',
))
->values(array(
  'lid' => '231',
  'location' => 'includes/views/handlers/content_handler_field.inc:80',
  'textgroup' => 'default',
  'source' => 'Format',
  'version' => 'none',
))
->values(array(
  'lid' => '232',
  'location' => 'includes/views/handlers/content_handler_field_multiple.inc:56',
  'textgroup' => 'default',
  'source' => 'Group multiple values',
  'version' => 'none',
))
->values(array(
  'lid' => '233',
  'location' => 'includes/views/handlers/content_handler_field_multiple.inc:61',
  'textgroup' => 'default',
  'source' => 'If unchecked, each item in the field will create a new row, which may appear to cause duplicates. This setting is not compatible with click-sorting in table displays.',
  'version' => 'none',
))
->values(array(
  'lid' => '234',
  'location' => 'includes/views/handlers/content_handler_field_multiple.inc:63',
  'textgroup' => 'default',
  'source' => 'Show @count value(s)',
  'version' => 'none',
))
->values(array(
  'lid' => '235',
  'location' => 'includes/views/handlers/content_handler_field_multiple.inc:74',
  'textgroup' => 'default',
  'source' => 'starting from @count',
  'version' => 'none',
))
->values(array(
  'lid' => '236',
  'location' => 'includes/views/handlers/content_handler_field_multiple.inc:85',
  'textgroup' => 'default',
  'source' => 'Reversed (start from last values)',
  'version' => 'none',
))
->values(array(
  'lid' => '237',
  'location' => 'includes/views/handlers/content_handler_relationship.inc:40,  includes/views/handlers/content_handler_sort.inc:41',
  'textgroup' => 'default',
  'source' => 'All',
  'version' => 'none',
))
->values(array(
  'lid' => '238',
  'location' => 'includes/views/handlers/content_handler_relationship.inc:48,  includes/views/handlers/content_handler_sort.inc:49',
  'textgroup' => 'default',
  'source' => 'Delta',
  'version' => 'none',
))
->values(array(
  'lid' => '239',
  'location' => 'includes/views/handlers/content_handler_relationship.inc:49',
  'textgroup' => 'default',
  'source' => 'The delta allows you to select which item in a multiple value field to key the relationship off of. Select "1" to use the first item, "2" for the second item, and so on. If you select "All", each item in the field will create a new row, which may appear to cause duplicates.',
  'version' => 'none',
))
->values(array(
  'lid' => '240',
  'location' => 'includes/views/handlers/content_handler_sort.inc:50',
  'textgroup' => 'default',
  'source' => 'The delta allows you to select which item in a multiple value field will be used for sorting. Select "1" to use the first item, "2" for the second item, and so on. If you select "All", each item in the field will create a new row, which may appear to cause duplicates.',
  'version' => 'none',
))
->values(array(
  'lid' => '241',
  'location' => 'modules/content_copy/content_copy_export_form.tpl.php:9,  modules/content_copy/content_copy.module:191;38',
  'textgroup' => 'default',
  'source' => 'Export',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '242',
  'location' => 'modules/content_copy/content_copy.module:97',
  'textgroup' => 'default',
  'source' => 'This form will process a content type and one or more fields from that type and export the settings. The export created by this process can be copied and pasted as an import into the current or any other database. The import will add the fields to into an existing content type or create a new content type that includes the selected fields.',
  'version' => 'none',
))
->values(array(
  'lid' => '243',
  'location' => 'modules/content_copy/content_copy.module:103',
  'textgroup' => 'default',
  'source' => 'Types',
  'version' => 'none',
))
->values(array(
  'lid' => '244',
  'location' => 'modules/content_copy/content_copy.module:107',
  'textgroup' => 'default',
  'source' => 'Select the content type to export.',
  'version' => 'none',
))
->values(array(
  'lid' => '245',
  'location' => 'modules/content_copy/content_copy.module:175',
  'textgroup' => 'default',
  'source' => 'Export data',
  'version' => 'none',
))
->values(array(
  'lid' => '246',
  'location' => 'modules/content_copy/content_copy.module:180',
  'textgroup' => 'default',
  'source' => 'Copy the export text and paste it into another content type using the import function.',
  'version' => 'none',
))
->values(array(
  'lid' => '247',
  'location' => 'content_admin.inc:42',
  'textgroup' => 'default',
  'source' => 'Content types',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '248',
  'location' => 'modules/content_copy/content_copy.module:308',
  'textgroup' => 'default',
  'source' => 'Content type',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '249',
  'location' => 'modules/content_copy/content_copy.module:309',
  'textgroup' => 'default',
  'source' => 'Select the content type to import these fields into.<br/>Select &lt;Create&gt; to create a new content type to contain the fields.',
  'version' => 'none',
))
->values(array(
  'lid' => '250',
  'location' => 'modules/content_copy/content_copy.module:314',
  'textgroup' => 'default',
  'source' => 'Import data',
  'version' => 'none',
))
->values(array(
  'lid' => '251',
  'location' => 'modules/content_copy/content_copy.module:316',
  'textgroup' => 'default',
  'source' => 'Paste the text created by a content export into this field.',
  'version' => 'none',
))
->values(array(
  'lid' => '252',
  'location' => 'modules/content_copy/content_copy.module:320;46',
  'textgroup' => 'default',
  'source' => 'Import',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '253',
  'location' => 'modules/content_copy/content_copy.module:328',
  'textgroup' => 'default',
  'source' => 'A file has been pre-loaded for import.',
  'version' => 'none',
))
->values(array(
  'lid' => '254',
  'location' => 'modules/content_copy/content_copy.module:354',
  'textgroup' => 'default',
  'source' => 'The import data is not valid import text.',
  'version' => 'none',
))
->values(array(
  'lid' => '255',
  'location' => 'modules/content_copy/content_copy.module:403',
  'textgroup' => 'default',
  'source' => 'The following modules must be enabled for this import to work: %modules.',
  'version' => 'none',
))
->values(array(
  'lid' => '256',
  'location' => 'modules/content_copy/content_copy.module:411',
  'textgroup' => 'default',
  'source' => 'The content type %type already exists in this database.',
  'version' => 'none',
))
->values(array(
  'lid' => '257',
  'location' => 'modules/content_copy/content_copy.module:418',
  'textgroup' => 'default',
  'source' => 'Exiting. No import performed.',
  'version' => 'none',
))
->values(array(
  'lid' => '258',
  'location' => 'modules/content_copy/content_copy.module:442',
  'textgroup' => 'default',
  'source' => 'An error has occurred adding the content type %type.<br/>Please check the errors displayed for more details.',
  'version' => 'none',
))
->values(array(
  'lid' => '259',
  'location' => 'modules/content_copy/content_copy.module:467',
  'textgroup' => 'default',
  'source' => 'The imported field %field_label (%field_name) was not added to %type because that field already exists in %type.',
  'version' => 'none',
))
->values(array(
  'lid' => '260',
  'location' => 'modules/content_copy/content_copy.module:476',
  'textgroup' => 'default',
  'source' => 'The field %field_label (%field_name) was added to the content type %type.',
  'version' => 'none',
))
->values(array(
  'lid' => '261',
  'location' => 'modules/content_copy/content_copy.module:0',
  'textgroup' => 'default',
  'source' => 'content_copy',
  'version' => 'none',
))
->values(array(
  'lid' => '262',
  'location' => 'modules/content_copy/content_copy.info:0',
  'textgroup' => 'default',
  'source' => 'Content Copy',
  'version' => 'none',
))
->values(array(
  'lid' => '263',
  'location' => 'modules/content_copy/content_copy.info:0',
  'textgroup' => 'default',
  'source' => 'Enables ability to import/export field definitions.',
  'version' => 'none',
))
->values(array(
  'lid' => '264',
  'location' => 'modules/content_multigroup/content_multigroup.module:12',
  'textgroup' => 'default',
  'source' => 'The fields in a Standard group are independent of each other and each can have either single or multiple values. The fields in a Multigroup are treated as a repeating collection of single value fields.',
  'version' => 'none',
))
->values(array(
  'lid' => '265',
  'location' => 'modules/content_multigroup/content_multigroup.module:65;135',
  'textgroup' => 'default',
  'source' => 'Multigroup',
  'version' => 'none',
))
->values(array(
  'lid' => '266',
  'location' => 'modules/content_multigroup/content_multigroup.module:134',
  'textgroup' => 'default',
  'source' => 'Standard',
  'version' => 'none',
))
->values(array(
  'lid' => '267',
  'location' => 'includes/content.admin.inc:344,  modules/content_multigroup/content_multigroup.module:126',
  'textgroup' => 'default',
  'source' => 'Type of group.',
  'version' => 'none',
))
->values(array(
  'lid' => '268',
  'location' => 'modules/content_multigroup/content_multigroup.module:215',
  'textgroup' => 'default',
  'source' => 'The field %field has been updated to use %multiple values, to match the multiple value setting of the Multigroup %group.',
  'version' => 'none',
))
->values(array(
  'lid' => '269',
  'location' => 'modules/content_multigroup/content_multigroup.module:248',
  'textgroup' => 'default',
  'source' => 'This change is not allowed. The field %field already has %multiple values in the database but the group %group only allows %group_max. Making this change would result in the loss of data.',
  'version' => 'none',
))
->values(array(
  'lid' => '270',
  'location' => 'modules/content_multigroup/content_multigroup.module:272',
  'textgroup' => 'default',
  'source' => 'This change is not allowed. The field %field handles multiple values differently than the Content module. Making this change could result in the loss of data.',
  'version' => 'none',
))
->values(array(
  'lid' => '271',
  'location' => 'modules/content_multigroup/content_multigroup.module:287',
  'textgroup' => 'default',
  'source' => 'You are moving the field %field into a Multigroup.',
  'version' => 'none',
))
->values(array(
  'lid' => '272',
  'location' => 'modules/content_multigroup/content_multigroup.module:320',
  'textgroup' => 'default',
  'source' => 'This change is not allowed. The field %field already has data created and uses a widget that stores data differently in a Standard group than in a Multigroup. Making this change could result in the loss of data.',
  'version' => 'none',
))
->values(array(
  'lid' => '273',
  'location' => 'modules/content_multigroup/content_multigroup.module:334',
  'textgroup' => 'default',
  'source' => 'You are moving the field %field out of a Multigroup.',
  'version' => 'none',
))
->values(array(
  'lid' => '274',
  'location' => 'modules/content_multigroup/content_multigroup.module:369',
  'textgroup' => 'default',
  'source' => 'Simple',
  'version' => 'none',
))
->values(array(
  'lid' => '275',
  'location' => 'modules/content_multigroup/content_multigroup.module:370',
  'textgroup' => 'default',
  'source' => 'Fieldset',
  'version' => 'none',
))
->values(array(
  'lid' => '276',
  'location' => 'modules/content_multigroup/content_multigroup.module:371',
  'textgroup' => 'default',
  'source' => 'Horizontal line',
  'version' => 'none',
))
->values(array(
  'lid' => '277',
  'location' => 'modules/content_multigroup/content_multigroup.module:372',
  'textgroup' => 'default',
  'source' => 'Table - Single column',
  'version' => 'none',
))
->values(array(
  'lid' => '278',
  'location' => 'modules/content_multigroup/content_multigroup.module:373',
  'textgroup' => 'default',
  'source' => 'Table - Multiple columns',
  'version' => 'none',
))
->values(array(
  'lid' => '279',
  'location' => 'modules/content_multigroup/content_multigroup.module:384',
  'textgroup' => 'default',
  'source' => '[Subgroup format]',
  'version' => 'none',
))
->values(array(
  'lid' => '280',
  'location' => 'modules/content_multigroup/content_multigroup.module:461',
  'textgroup' => 'default',
  'source' => 'Multigroup settings',
  'version' => 'none',
))
->values(array(
  'lid' => '281',
  'location' => 'modules/content_multigroup/content_multigroup.module:476',
  'textgroup' => 'default',
  'source' => 'Multiple columns',
  'version' => 'none',
))
->values(array(
  'lid' => '282',
  'location' => 'modules/content_multigroup/content_multigroup.module:478',
  'textgroup' => 'default',
  'source' => 'Enable this option to render each field on a separate column on the node edit form.',
  'version' => 'none',
))
->values(array(
  'lid' => '283',
  'location' => 'modules/content_multigroup/content_multigroup.module:485',
  'textgroup' => 'default',
  'source' => 'Enable this option to require a minimum of one collection of fields in this Multigroup.',
  'version' => 'none',
))
->values(array(
  'lid' => '284',
  'location' => 'modules/content_multigroup/content_multigroup.module:488',
  'textgroup' => 'default',
  'source' => 'Number of times to repeat the collection of Multigroup fields.',
  'version' => 'none',
))
->values(array(
  'lid' => '285',
  'location' => 'modules/content_multigroup/content_multigroup.module:489',
  'textgroup' => 'default',
  'source' => "'Unlimited' will provide an 'Add more' button so the users can add items as many times as they like.",
  'version' => 'none',
))
->values(array(
  'lid' => '286',
  'location' => 'modules/content_multigroup/content_multigroup.module:490',
  'textgroup' => 'default',
  'source' => 'All fields in this group will automatically be set to allow this number of values.',
  'version' => 'none',
))
->values(array(
  'lid' => '287',
  'location' => 'modules/content_multigroup/content_multigroup.module:495',
  'textgroup' => 'default',
  'source' => 'Number of repeats',
  'version' => 'none',
))
->values(array(
  'lid' => '288',
  'location' => 'modules/content_multigroup/content_multigroup.module:503',
  'textgroup' => 'default',
  'source' => 'Labels',
  'version' => 'none',
))
->values(array(
  'lid' => '289',
  'location' => 'modules/content_multigroup/content_multigroup.module:504',
  'textgroup' => 'default',
  'source' => "Labels for each subgroup of fields. Labels can be hidden or shown in various contexts using the 'Display fields' screen.",
  'version' => 'none',
))
->values(array(
  'lid' => '290',
  'location' => 'modules/content_multigroup/content_multigroup.module:512',
  'textgroup' => 'default',
  'source' => 'Subgroup %number label',
  'version' => 'none',
))
->values(array(
  'lid' => '291',
  'location' => 'modules/content_multigroup/content_multigroup.module:539',
  'textgroup' => 'default',
  'source' => 'The field %field in this group already has %multiple values in the database. To prevent the loss of data you cannot set the number of Multigroup values to less than this.',
  'version' => 'none',
))
->values(array(
  'lid' => '292',
  'location' => 'modules/content_multigroup/content_multigroup.module:932',
  'textgroup' => 'default',
  'source' => '!name field is required in group @group.',
  'version' => 'none',
))
->values(array(
  'lid' => '293',
  'location' => 'modules/content_multigroup/content_multigroup.module:946',
  'textgroup' => 'default',
  'source' => 'Group @name requires one collection of fields minimum.',
  'version' => 'none',
))
->values(array(
  'lid' => '294',
  'location' => 'modules/content_multigroup/content_multigroup.module:1145',
  'textgroup' => 'default',
  'source' => 'Add more values',
  'version' => 'none',
))
->values(array(
  'lid' => '295',
  'location' => 'modules/content_multigroup/content_multigroup.module:0',
  'textgroup' => 'default',
  'source' => 'content_multigroup',
  'version' => 'none',
))
->values(array(
  'lid' => '296',
  'location' => 'modules/content_multigroup/content_multigroup.info:0',
  'textgroup' => 'default',
  'source' => 'Content Multigroup',
  'version' => 'none',
))
->values(array(
  'lid' => '297',
  'location' => 'modules/content_multigroup/content_multigroup.info:0',
  'textgroup' => 'default',
  'source' => 'Combine multiple CCK fields into repeating field collections that work in unison.',
  'version' => 'none',
))
->values(array(
  'lid' => '298',
  'location' => 'modules/content_permissions/content_permissions.module:10',
  'textgroup' => 'default',
  'source' => 'edit',
  'version' => 'none',
))
->values(array(
  'lid' => '299',
  'location' => 'modules/content_permissions/content_permissions.module:10;11',
  'textgroup' => 'default',
  'source' => 'field_name',
  'version' => 'none',
))
->values(array(
  'lid' => '300',
  'location' => 'modules/content_permissions/content_permissions.module:11',
  'textgroup' => 'default',
  'source' => 'view',
  'version' => 'none',
))
->values(array(
  'lid' => '301',
  'location' => 'modules/content_permissions/content_permissions.module:0',
  'textgroup' => 'default',
  'source' => 'content_permissions',
  'version' => 'none',
))
->values(array(
  'lid' => '302',
  'location' => 'modules/content_permissions/content_permissions.install:9',
  'textgroup' => 'default',
  'source' => 'Please <a href="!url">configure your field permissions</a> immediately. All fields are inaccessible by default.',
  'version' => 'none',
))
->values(array(
  'lid' => '303',
  'location' => 'modules/content_permissions/content_permissions.info:0',
  'textgroup' => 'default',
  'source' => 'Content Permissions',
  'version' => 'none',
))
->values(array(
  'lid' => '304',
  'location' => 'modules/content_permissions/content_permissions.info:0',
  'textgroup' => 'default',
  'source' => 'Set field-level permissions for CCK fields.',
  'version' => 'none',
))
->values(array(
  'lid' => '305',
  'location' => 'modules/fieldgroup/fieldgroup.panels.inc:10;27,  modules/fieldgroup/panels/content_types/content_fieldgroup.inc:14',
  'textgroup' => 'default',
  'source' => 'Content fieldgroup',
  'version' => 'none',
))
->values(array(
  'lid' => '306',
  'location' => 'modules/fieldgroup/fieldgroup.panels.inc:30',
  'textgroup' => 'default',
  'source' => 'All fields from a fieldgroup on the referenced node.',
  'version' => 'none',
))
->values(array(
  'lid' => '307',
  'location' => 'modules/fieldgroup/fieldgroup.panels.inc:91',
  'textgroup' => 'default',
  'source' => '@group_label (@group_type_name)',
  'version' => 'none',
))
->values(array(
  'lid' => '308',
  'location' => 'modules/fieldgroup/fieldgroup.panels.inc:102,  modules/fieldgroup/fieldgroup.info:0',
  'textgroup' => 'default',
  'source' => 'Fieldgroup',
  'version' => 'none',
))
->values(array(
  'lid' => '309',
  'location' => 'modules/fieldgroup/fieldgroup.panels.inc:112,  modules/fieldgroup/panels/content_types/content_fieldgroup.inc:102',
  'textgroup' => 'default',
  'source' => 'Text to display if group has no data. Note that title will not display unless overridden.',
  'version' => 'none',
))
->values(array(
  'lid' => '310',
  'location' => 'modules/fieldgroup/fieldgroup.panels.inc:128',
  'textgroup' => 'default',
  'source' => '"@s" fieldgroup @name',
  'version' => 'none',
))
->values(array(
  'lid' => '311',
  'location' => 'modules/fieldgroup/fieldgroup.module:124',
  'textgroup' => 'default',
  'source' => 'Form settings',
  'version' => 'none',
))
->values(array(
  'lid' => '312',
  'location' => 'modules/fieldgroup/fieldgroup.module:125',
  'textgroup' => 'default',
  'source' => 'These settings apply to the group in the node editing form.',
  'version' => 'none',
))
->values(array(
  'lid' => '313',
  'location' => 'modules/fieldgroup/fieldgroup.module:129',
  'textgroup' => 'default',
  'source' => 'Style',
  'version' => 'none',
))
->values(array(
  'lid' => '314',
  'location' => 'modules/fieldgroup/fieldgroup.module:132',
  'textgroup' => 'default',
  'source' => 'always open',
  'version' => 'none',
))
->values(array(
  'lid' => '315',
  'location' => 'modules/fieldgroup/fieldgroup.module:133',
  'textgroup' => 'default',
  'source' => 'collapsible',
  'version' => 'none',
))
->values(array(
  'lid' => '316',
  'location' => 'modules/fieldgroup/fieldgroup.module:134',
  'textgroup' => 'default',
  'source' => 'collapsed',
  'version' => 'none',
))
->values(array(
  'lid' => '317',
  'location' => 'modules/fieldgroup/fieldgroup.module:142',
  'textgroup' => 'default',
  'source' => 'Instructions to present to the user on the editing form.',
  'version' => 'none',
))
->values(array(
  'lid' => '318',
  'location' => 'modules/fieldgroup/fieldgroup.module:147',
  'textgroup' => 'default',
  'source' => 'Display settings',
  'version' => 'none',
))
->values(array(
  'lid' => '319',
  'location' => 'modules/fieldgroup/fieldgroup.module:148',
  'textgroup' => 'default',
  'source' => 'These settings apply to the group on node display.',
  'version' => 'none',
))
->values(array(
  'lid' => '320',
  'location' => 'modules/fieldgroup/fieldgroup.module:155',
  'textgroup' => 'default',
  'source' => 'A description of the group.',
  'version' => 'none',
))
->values(array(
  'lid' => '321',
  'location' => 'modules/fieldgroup/fieldgroup.module:200',
  'textgroup' => 'default',
  'source' => 'Are you sure you want to remove the group %label?',
  'version' => 'none',
))
->values(array(
  'lid' => '322',
  'location' => 'modules/fieldgroup/fieldgroup.module:202',
  'textgroup' => 'default',
  'source' => 'This action cannot be undone.',
  'version' => 'none',
))
->values(array(
  'lid' => '323',
  'location' => 'modules/fieldgroup/fieldgroup.module:211',
  'textgroup' => 'default',
  'source' => 'The group %group_name has been removed.',
  'version' => 'none',
))
->values(array(
  'lid' => '324',
  'location' => 'modules/content_multigroup/content_multigroup.module:356,  modules/fieldgroup/fieldgroup.module:266',
  'textgroup' => 'default',
  'source' => 'none',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '325',
  'location' => 'modules/fieldgroup/fieldgroup.module:353',
  'textgroup' => 'default',
  'source' => 'You need to provide a label.',
  'version' => 'none',
))
->values(array(
  'lid' => '326',
  'location' => 'modules/fieldgroup/fieldgroup.module:358',
  'textgroup' => 'default',
  'source' => 'You need to provide a group name.',
  'version' => 'none',
))
->values(array(
  'lid' => '327',
  'location' => 'modules/fieldgroup/fieldgroup.module:372',
  'textgroup' => 'default',
  'source' => 'The group name %group_name is invalid. The name must include only lowercase unaccentuated letters, numbers, and underscores.',
  'version' => 'none',
))
->values(array(
  'lid' => '328',
  'location' => 'modules/fieldgroup/fieldgroup.module:375',
  'textgroup' => 'default',
  'source' => "The group name %group_name is too long. The name is limited to 32 characters, including the 'group_' prefix.",
  'version' => 'none',
))
->values(array(
  'lid' => '329',
  'location' => 'modules/fieldgroup/fieldgroup.module:381',
  'textgroup' => 'default',
  'source' => 'The group name %group_name already exists.',
  'version' => 'none',
))
->values(array(
  'lid' => '330',
  'location' => 'modules/fieldgroup/fieldgroup.module:400;403',
  'textgroup' => 'default',
  'source' => 'Add new group:',
  'version' => 'none',
))
->values(array(
  'lid' => '331',
  'location' => 'modules/fieldgroup/fieldgroup.module:418',
  'textgroup' => 'default',
  'source' => 'Add new group: you need to provide a label.',
  'version' => 'none',
))
->values(array(
  'lid' => '332',
  'location' => 'modules/fieldgroup/fieldgroup.module:419',
  'textgroup' => 'default',
  'source' => 'Add new group: you need to provide a group name.',
  'version' => 'none',
))
->values(array(
  'lid' => '333',
  'location' => 'modules/fieldgroup/fieldgroup.module:648',
  'textgroup' => 'default',
  'source' => 'Standard group',
  'version' => 'none',
))
->values(array(
  'lid' => '334',
  'location' => 'modules/fieldgroup/fieldgroup.module:39;46',
  'textgroup' => 'default',
  'source' => 'Edit group',
  'version' => 'none',
))
->values(array(
  'lid' => '335',
  'location' => 'modules/fieldgroup/fieldgroup.module:0',
  'textgroup' => 'default',
  'source' => 'fieldgroup',
  'version' => 'none',
))
->values(array(
  'lid' => '336',
  'location' => 'modules/fieldgroup/fieldgroup.info:0',
  'textgroup' => 'default',
  'source' => 'Create display groups for CCK fields.',
  'version' => 'none',
))
->values(array(
  'lid' => '337',
  'location' => 'modules/nodereference/nodereference.rules.inc:15',
  'textgroup' => 'default',
  'source' => 'Load a referenced node',
  'version' => 'none',
))
->values(array(
  'lid' => '338',
  'location' => 'modules/nodereference/nodereference.rules.inc:19',
  'textgroup' => 'default',
  'source' => 'Content containing the node reference field',
  'version' => 'none',
))
->values(array(
  'lid' => '339',
  'location' => 'modules/nodereference/nodereference.rules.inc:25',
  'textgroup' => 'default',
  'source' => 'Referenced content',
  'version' => 'none',
))
->values(array(
  'lid' => '340',
  'location' => 'modules/nodereference/nodereference.rules.inc:29',
  'textgroup' => 'default',
  'source' => 'Note that if the field has multiple values, only the first content node will be loaded.',
  'version' => 'none',
))
->values(array(
  'lid' => '341',
  'location' => 'modules/nodereference/nodereference.rules.inc:50',
  'textgroup' => 'default',
  'source' => 'There are no nodereference fields defined.',
  'version' => 'none',
))
->values(array(
  'lid' => '342',
  'location' => 'modules/nodereference/nodereference.module:71',
  'textgroup' => 'default',
  'source' => 'Node reference',
  'version' => 'none',
))
->values(array(
  'lid' => '343',
  'location' => 'modules/nodereference/nodereference.module:72',
  'textgroup' => 'default',
  'source' => 'Store the ID of a related node as an integer value.',
  'version' => 'none',
))
->values(array(
  'lid' => '344',
  'location' => 'modules/nodereference/nodereference.module:90',
  'textgroup' => 'default',
  'source' => 'Content types that can be referenced',
  'version' => 'none',
))
->values(array(
  'lid' => '345',
  'location' => 'modules/nodereference/nodereference.module:97,  modules/userreference/userreference.module:94',
  'textgroup' => 'default',
  'source' => 'Default Views',
  'version' => 'none',
))
->values(array(
  'lid' => '346',
  'location' => 'modules/nodereference/nodereference.module:101',
  'textgroup' => 'default',
  'source' => 'Existing Views',
  'version' => 'none',
))
->values(array(
  'lid' => '347',
  'location' => 'modules/nodereference/nodereference.module:108',
  'textgroup' => 'default',
  'source' => 'Advanced - Nodes that can be referenced (View)',
  'version' => 'none',
))
->values(array(
  'lid' => '348',
  'location' => 'modules/nodereference/nodereference.module:114',
  'textgroup' => 'default',
  'source' => 'View used to select the nodes',
  'version' => 'none',
))
->values(array(
  'lid' => '349',
  'location' => 'modules/nodereference/nodereference.module:107',
  'textgroup' => 'default',
  'source' => '<p>Choose the "Views module" view that selects the nodes that can be referenced.<br />Note:</p>',
  'version' => 'none',
))
->values(array(
  'lid' => '350',
  'location' => 'modules/nodereference/nodereference.module:108;121',
  'textgroup' => 'default',
  'source' => "<ul><li>Only views that have fields will work for this purpose.</li><li>This will discard the \"Content types\" settings above. Use the view's \"filters\" section instead.</li><li>Use the view's \"fields\" section to display additional informations about candidate nodes on node creation/edition form.</li><li>Use the view's \"sort criteria\" section to determine the order in which candidate nodes will be displayed.</li></ul>",
  'version' => 'none',
))
->values(array(
  'lid' => '351',
  'location' => 'modules/nodereference/nodereference.module:121',
  'textgroup' => 'default',
  'source' => 'View arguments',
  'version' => 'none',
))
->values(array(
  'lid' => '352',
  'location' => 'modules/nodereference/nodereference.module:124',
  'textgroup' => 'default',
  'source' => 'Provide a comma separated list of arguments to pass to the view.',
  'version' => 'none',
))
->values(array(
  'lid' => '353',
  'location' => 'modules/nodereference/nodereference.module:120',
  'textgroup' => 'default',
  'source' => '<p>The list of nodes that can be referenced can be based on a "Views module" view but no appropriate views were found. <br />Note:</p>',
  'version' => 'none',
))
->values(array(
  'lid' => '354',
  'location' => 'modules/nodereference/nodereference.module:216,  modules/userreference/userreference.module:195',
  'textgroup' => 'default',
  'source' => '%name: invalid input.',
  'version' => 'none',
))
->values(array(
  'lid' => '355',
  'location' => 'modules/nodereference/nodereference.module:217',
  'textgroup' => 'default',
  'source' => "%name: this post can't be referenced.",
  'version' => 'none',
))
->values(array(
  'lid' => '356',
  'location' => 'modules/nodereference/nodereference.module:200',
  'textgroup' => 'default',
  'source' => 'Title (link)',
  'version' => 'none',
))
->values(array(
  'lid' => '357',
  'location' => 'modules/nodereference/nodereference.module:205',
  'textgroup' => 'default',
  'source' => 'Title (no link)',
  'version' => 'none',
))
->values(array(
  'lid' => '358',
  'location' => 'modules/nodereference/nodereference.module:358,  modules/optionwidgets/optionwidgets.module:80,  modules/userreference/userreference.module:284',
  'textgroup' => 'default',
  'source' => 'Select list',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '359',
  'location' => 'modules/nodereference/nodereference.module:366,  modules/optionwidgets/optionwidgets.module:88,  modules/userreference/userreference.module:292',
  'textgroup' => 'default',
  'source' => 'Check boxes/radio buttons',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '360',
  'location' => 'modules/nodereference/nodereference.module:374,  modules/userreference/userreference.module:300',
  'textgroup' => 'default',
  'source' => 'Autocomplete text field',
  'version' => 'none',
))
->values(array(
  'lid' => '361',
  'location' => 'modules/nodereference/nodereference.module:429,  modules/userreference/userreference.module:355',
  'textgroup' => 'default',
  'source' => 'Autocomplete matching',
  'version' => 'none',
))
->values(array(
  'lid' => '362',
  'location' => 'modules/nodereference/nodereference.module:432,  modules/userreference/userreference.module:358',
  'textgroup' => 'default',
  'source' => 'Starts with',
  'version' => 'none',
))
->values(array(
  'lid' => '363',
  'location' => 'modules/nodereference/nodereference.module:433,  modules/userreference/userreference.module:359',
  'textgroup' => 'default',
  'source' => 'Contains',
  'version' => 'none',
))
->values(array(
  'lid' => '364',
  'location' => 'modules/nodereference/nodereference.module:423',
  'textgroup' => 'default',
  'source' => 'Select the method used to collect autocomplete suggestions. Note that <em>Contains</em> can cause performance issues on sites with thousands of nodes.',
  'version' => 'none',
))
->values(array(
  'lid' => '365',
  'location' => 'modules/nodereference/nodereference.module:671',
  'textgroup' => 'default',
  'source' => '%name: title mismatch. Please check your selection.',
  'version' => 'none',
))
->values(array(
  'lid' => '366',
  'location' => 'modules/nodereference/nodereference.module:678',
  'textgroup' => 'default',
  'source' => '%name: found no valid post with that title.',
  'version' => 'none',
))
->values(array(
  'lid' => '367',
  'location' => 'modules/nodereference/nodereference.module:15',
  'textgroup' => 'default',
  'source' => 'Nodereference autocomplete',
  'version' => 'none',
))
->values(array(
  'lid' => '368',
  'location' => 'modules/nodereference/nodereference.module:0',
  'textgroup' => 'default',
  'source' => 'nodereference',
  'version' => 'none',
))
->values(array(
  'lid' => '369',
  'location' => 'modules/nodereference/nodereference.info:0',
  'textgroup' => 'default',
  'source' => 'Node Reference',
  'version' => 'none',
))
->values(array(
  'lid' => '370',
  'location' => 'modules/nodereference/nodereference.info:0',
  'textgroup' => 'default',
  'source' => 'Defines a field type for referencing one node from another.',
  'version' => 'none',
))
->values(array(
  'lid' => '371',
  'location' => 'modules/number/number.module:34',
  'textgroup' => 'default',
  'source' => 'Integer',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '372',
  'location' => 'modules/number/number.module:35',
  'textgroup' => 'default',
  'source' => 'Store a number in the database as an integer.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '373',
  'location' => 'modules/number/number.module:38',
  'textgroup' => 'default',
  'source' => 'Decimal',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '374',
  'location' => 'modules/number/number.module:39',
  'textgroup' => 'default',
  'source' => 'Store a number in the database in a fixed decimal format.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '375',
  'location' => 'modules/number/number.module:42',
  'textgroup' => 'default',
  'source' => 'Float',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '376',
  'location' => 'modules/number/number.module:43',
  'textgroup' => 'default',
  'source' => 'Store a number in the database in a floating point format.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '377',
  'location' => 'modules/number/number.module:57',
  'textgroup' => 'default',
  'source' => 'Minimum',
  'version' => 'none',
))
->values(array(
  'lid' => '378',
  'location' => 'modules/number/number.module:63',
  'textgroup' => 'default',
  'source' => 'Maximum',
  'version' => 'none',
))
->values(array(
  'lid' => '379',
  'location' => 'modules/number/number.module:71',
  'textgroup' => 'default',
  'source' => 'Precision',
  'version' => 'none',
))
->values(array(
  'lid' => '380',
  'location' => 'modules/number/number.module:72',
  'textgroup' => 'default',
  'source' => 'The total number of digits to store in the database, including those to the right of the decimal.',
  'version' => 'none',
))
->values(array(
  'lid' => '381',
  'location' => 'modules/number/number.module:78',
  'textgroup' => 'default',
  'source' => 'Scale',
  'version' => 'none',
))
->values(array(
  'lid' => '382',
  'location' => 'modules/number/number.module:79',
  'textgroup' => 'default',
  'source' => 'The number of digits to the right of the decimal.',
  'version' => 'none',
))
->values(array(
  'lid' => '383',
  'location' => 'modules/number/number.module:85',
  'textgroup' => 'default',
  'source' => 'Decimal marker',
  'version' => 'none',
))
->values(array(
  'lid' => '384',
  'location' => 'modules/number/number.module:86',
  'textgroup' => 'default',
  'source' => 'The character users will input to mark the decimal point in forms.',
  'version' => 'none',
))
->values(array(
  'lid' => '385',
  'location' => 'modules/number/number.module:92',
  'textgroup' => 'default',
  'source' => 'Prefix',
  'version' => 'none',
))
->values(array(
  'lid' => '386',
  'location' => 'modules/number/number.module:95',
  'textgroup' => 'default',
  'source' => 'Define a string that should be prefixed to the value, like $ or €. Leave blank for none. Separate singular and plural values with a pipe (pound|pounds).',
  'version' => 'none',
))
->values(array(
  'lid' => '387',
  'location' => 'modules/number/number.module:99',
  'textgroup' => 'default',
  'source' => 'Suffix',
  'version' => 'none',
))
->values(array(
  'lid' => '388',
  'location' => 'modules/number/number.module:102',
  'textgroup' => 'default',
  'source' => 'Define a string that should suffixed to the value, like m², m/s², kb/s. Leave blank for none. Separate singular and plural values with a pipe (pound|pounds).',
  'version' => 'none',
))
->values(array(
  'lid' => '389',
  'location' => 'modules/number/number.module:109,  modules/text/text.module:72',
  'textgroup' => 'default',
  'source' => 'Allowed values',
  'version' => 'none',
))
->values(array(
  'lid' => '390',
  'location' => 'modules/number/number.module:115,  modules/text/text.module:78',
  'textgroup' => 'default',
  'source' => 'Allowed values list',
  'version' => 'none',
))
->values(array(
  'lid' => '391',
  'location' => 'modules/number/number.module:119,  modules/text/text.module:82',
  'textgroup' => 'default',
  'source' => 'The possible values this field can contain. Enter one value per line, in the format key|label. The key is the value that will be stored in the database, and it must match the field storage type (%type). The label is optional, and the key will be used as the label if no label is specified.<br />Allowed HTML tags: @tags',
  'version' => 'none',
))
->values(array(
  'lid' => '392',
  'location' => 'modules/number/number.module:133,  modules/text/text.module:96',
  'textgroup' => 'default',
  'source' => 'Advanced usage only: PHP code that returns a keyed array of allowed values. Should not include &lt;?php ?&gt; delimiters. If this field is filled out, the array returned by this code will override the allowed values list above.',
  'version' => 'none',
))
->values(array(
  'lid' => '393',
  'location' => 'modules/number/number.module:141,  modules/text/text.module:104',
  'textgroup' => 'default',
  'source' => 'This PHP code was set by an administrator and will override the allowed values list above.',
  'version' => 'none',
))
->values(array(
  'lid' => '394',
  'location' => 'modules/number/number.module:181,  modules/text/text.module:133',
  'textgroup' => 'default',
  'source' => '@label (!name) - Allowed values',
  'version' => 'none',
))
->values(array(
  'lid' => '395',
  'location' => 'modules/number/number.module:195',
  'textgroup' => 'default',
  'source' => '"Minimum" must be a number.',
  'version' => 'none',
))
->values(array(
  'lid' => '396',
  'location' => 'modules/number/number.module:202',
  'textgroup' => 'default',
  'source' => '"Maximum" must be a number.',
  'version' => 'none',
))
->values(array(
  'lid' => '397',
  'location' => 'modules/number/number.module:219',
  'textgroup' => 'default',
  'source' => '%name: the value may be no smaller than %min.',
  'version' => 'none',
))
->values(array(
  'lid' => '398',
  'location' => 'modules/number/number.module:222',
  'textgroup' => 'default',
  'source' => '%name: the value may be no larger than %max.',
  'version' => 'none',
))
->values(array(
  'lid' => '399',
  'location' => 'modules/number/number.module:238,  modules/text/text.module:157',
  'textgroup' => 'default',
  'source' => '%name: illegal value.',
  'version' => 'none',
))
->values(array(
  'lid' => '400',
  'location' => 'modules/number/number.module:270',
  'textgroup' => 'default',
  'source' => 'unformatted',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '401',
  'location' => 'modules/number/number.module:356,  modules/text/text.module:257',
  'textgroup' => 'default',
  'source' => 'Text field',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '402',
  'location' => 'Float validation: English needs work,  modules/number/number.module:509,  fuzzy',
  'textgroup' => 'default',
  'source' => 'Only numbers and decimals are allowed in %field.',
  'version' => 'none',
))
->values(array(
  'lid' => '403',
  'location' => 'Integer validation: English needs work,  modules/number/number.module:532,  fuzzy',
  'textgroup' => 'default',
  'source' => 'Only numbers are allowed in %field.',
  'version' => 'none',
))
->values(array(
  'lid' => '404',
  'location' => 'Decimal validation with decimal character: English needs work,  modules/number/number.module:556,  fuzzy',
  'textgroup' => 'default',
  'source' => 'Only numbers and the decimal character (%decimal) are allowed in %field.',
  'version' => 'none',
))
->values(array(
  'lid' => '405',
  'location' => 'modules/number/number.module:0',
  'textgroup' => 'default',
  'source' => 'number',
  'version' => 'none',
))
->values(array(
  'lid' => '406',
  'location' => 'modules/number/number.info:0',
  'textgroup' => 'default',
  'source' => 'Number',
  'version' => 'none',
))
->values(array(
  'lid' => '407',
  'location' => 'modules/number/number.info:0',
  'textgroup' => 'default',
  'source' => 'Defines numeric field types.',
  'version' => 'none',
))
->values(array(
  'lid' => '408',
  'location' => 'modules/optionwidgets/optionwidgets.module:19',
  'textgroup' => 'default',
  'source' => 'Create a list of options as a list in <strong>Allowed values list</strong> or as an array in PHP code. These values will be the same for %field in all content types.',
  'version' => 'none',
))
->values(array(
  'lid' => '409',
  'location' => 'modules/optionwidgets/optionwidgets.module:22',
  'textgroup' => 'default',
  'source' => "For a 'single on/off checkbox' widget, define the 'off' value first, then the 'on' value in the <strong>Allowed values</strong> section. Note that the checkbox will be labeled with the label of the 'on' value.",
  'version' => 'none',
))
->values(array(
  'lid' => '410',
  'location' => 'modules/optionwidgets/optionwidgets.module:25',
  'textgroup' => 'default',
  'source' => "The 'checkboxes/radio buttons' widget will display checkboxes if the multiple values option is selected for this field, otherwise radios will be displayed.",
  'version' => 'none',
))
->values(array(
  'lid' => '411',
  'location' => 'modules/optionwidgets/optionwidgets.module:37',
  'textgroup' => 'default',
  'source' => "You need to specify the 'allowed values' for this field.",
  'version' => 'none',
))
->values(array(
  'lid' => '412',
  'location' => 'modules/optionwidgets/optionwidgets.module:96',
  'textgroup' => 'default',
  'source' => 'Single on/off checkbox',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '413',
  'location' => 'modules/optionwidgets/optionwidgets.module:331',
  'textgroup' => 'default',
  'source' => '%name: this field cannot hold more that @count values.',
  'version' => 'none',
))
->values(array(
  'lid' => '414',
  'location' => 'modules/optionwidgets/optionwidgets.module:411',
  'textgroup' => 'default',
  'source' => 'N/A',
  'version' => 'none',
))
->values(array(
  'lid' => '415',
  'location' => 'modules/optionwidgets/optionwidgets.module:415',
  'textgroup' => 'default',
  'source' => '- None -',
  'version' => 'none',
))
->values(array(
  'lid' => '416',
  'location' => 'modules/optionwidgets/optionwidgets.module:0',
  'textgroup' => 'default',
  'source' => 'optionwidgets',
  'version' => 'none',
))
->values(array(
  'lid' => '417',
  'location' => 'modules/optionwidgets/optionwidgets.info:0',
  'textgroup' => 'default',
  'source' => 'Option Widgets',
  'version' => 'none',
))
->values(array(
  'lid' => '418',
  'location' => 'modules/optionwidgets/optionwidgets.info:0',
  'textgroup' => 'default',
  'source' => 'Defines selection, check box and radio button widgets for text and numeric fields.',
  'version' => 'none',
))
->values(array(
  'lid' => '419',
  'location' => 'modules/text/text.module:42',
  'textgroup' => 'default',
  'source' => 'Store text in the database.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '420',
  'location' => 'modules/text/text.module:55;202,  modules/userreference/userreference.module:237',
  'textgroup' => 'default',
  'source' => 'Plain text',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '421',
  'location' => 'modules/text/text.module:55',
  'textgroup' => 'default',
  'source' => 'Filtered text (user selects input format)',
  'version' => 'none',
))
->values(array(
  'lid' => '422',
  'location' => 'modules/text/text.module:58',
  'textgroup' => 'default',
  'source' => 'Text processing',
  'version' => 'none',
))
->values(array(
  'lid' => '423',
  'location' => 'modules/text/text.module:64',
  'textgroup' => 'default',
  'source' => 'Maximum length',
  'version' => 'none',
))
->values(array(
  'lid' => '424',
  'location' => 'modules/text/text.module:68',
  'textgroup' => 'default',
  'source' => 'The maximum length of the field in characters. Leave blank for an unlimited size.',
  'version' => 'none',
))
->values(array(
  'lid' => '425',
  'location' => 'modules/text/text.module:160',
  'textgroup' => 'default',
  'source' => '%name: the value may not be longer than %max characters.',
  'version' => 'none',
))
->values(array(
  'lid' => '426',
  'location' => 'modules/text/text.module:197,  modules/userreference/userreference.module:232',
  'textgroup' => 'default',
  'source' => 'Default',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '427',
  'location' => 'modules/text/text.module:207',
  'textgroup' => 'default',
  'source' => 'Trimmed',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '428',
  'location' => 'modules/text/text.module:265',
  'textgroup' => 'default',
  'source' => 'Text area (multiple rows)',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '429',
  'location' => 'modules/nodereference/nodereference.module:439,  modules/text/text.module:317,  modules/userreference/userreference.module:365',
  'textgroup' => 'default',
  'source' => 'Size of textfield',
  'version' => 'none',
))
->values(array(
  'lid' => '430',
  'location' => 'modules/text/text.module:326',
  'textgroup' => 'default',
  'source' => 'Rows',
  'version' => 'none',
))
->values(array(
  'lid' => '431',
  'location' => 'modules/text/text.module:0',
  'textgroup' => 'default',
  'source' => 'text',
  'version' => 'none',
))
->values(array(
  'lid' => '432',
  'location' => 'modules/text/text.info:0',
  'textgroup' => 'default',
  'source' => 'Defines simple text field types.',
  'version' => 'none',
))
->values(array(
  'lid' => '433',
  'location' => 'modules/userreference/userreference.rules.inc:15',
  'textgroup' => 'default',
  'source' => 'Load a referenced user',
  'version' => 'none',
))
->values(array(
  'lid' => '434',
  'location' => 'modules/userreference/userreference.rules.inc:19',
  'textgroup' => 'default',
  'source' => 'Content containing the user reference field',
  'version' => 'none',
))
->values(array(
  'lid' => '435',
  'location' => 'modules/userreference/userreference.rules.inc:25',
  'textgroup' => 'default',
  'source' => 'Referenced user',
  'version' => 'none',
))
->values(array(
  'lid' => '436',
  'location' => 'modules/userreference/userreference.rules.inc:29',
  'textgroup' => 'default',
  'source' => 'Note that if the field has multiple values, only the first user will be loaded.',
  'version' => 'none',
))
->values(array(
  'lid' => '437',
  'location' => 'modules/userreference/userreference.rules.inc:52',
  'textgroup' => 'default',
  'source' => 'There are no userreference fields defined.',
  'version' => 'none',
))
->values(array(
  'lid' => '438',
  'location' => 'modules/userreference/userreference.module:52',
  'textgroup' => 'default',
  'source' => 'User reference',
  'version' => 'none',
))
->values(array(
  'lid' => '439',
  'location' => 'modules/userreference/userreference.module:53',
  'textgroup' => 'default',
  'source' => 'Store the ID of a related user as an integer value.',
  'version' => 'none',
))
->values(array(
  'lid' => '440',
  'location' => 'modules/userreference/userreference.module:67',
  'textgroup' => 'default',
  'source' => 'User roles that can be referenced',
  'version' => 'none',
))
->values(array(
  'lid' => '441',
  'location' => 'modules/userreference/userreference.module:73',
  'textgroup' => 'default',
  'source' => 'User status that can be referenced',
  'version' => 'none',
))
->values(array(
  'lid' => '442',
  'location' => 'modules/userreference/userreference.module:75',
  'textgroup' => 'default',
  'source' => 'Active',
  'version' => 'none',
))
->values(array(
  'lid' => '443',
  'location' => 'modules/userreference/userreference.module:75',
  'textgroup' => 'default',
  'source' => 'Blocked',
  'version' => 'none',
))
->values(array(
  'lid' => '444',
  'location' => 'modules/userreference/userreference.module:94',
  'textgroup' => 'default',
  'source' => 'Advanced - Users that can be referenced (View)',
  'version' => 'none',
))
->values(array(
  'lid' => '445',
  'location' => 'modules/userreference/userreference.module:101',
  'textgroup' => 'default',
  'source' => 'View used to select the users',
  'version' => 'none',
))
->values(array(
  'lid' => '446',
  'location' => 'modules/userreference/userreference.module:104',
  'textgroup' => 'default',
  'source' => '<p>Choose the "Views module" view that selects the users that can be referenced.<br />Note:</p>',
  'version' => 'none',
))
->values(array(
  'lid' => '447',
  'location' => 'modules/userreference/userreference.module:105;118',
  'textgroup' => 'default',
  'source' => "<ul><li>Only views that have fields will work for this purpose.</li><li>This will discard the \"Referenceable Roles\" and \"Referenceable Status\" settings above. Use the view's \"filters\" section instead.</li><li>Use the view's \"fields\" section to display additional informations about candidate users on user creation/edition form.</li><li>Use the view's \"sort criteria\" section to determine the order in which candidate users will be displayed.</li></ul>",
  'version' => 'none',
))
->values(array(
  'lid' => '448',
  'location' => 'modules/userreference/userreference.module:117',
  'textgroup' => 'default',
  'source' => '<p>The list of user that can be referenced can be based on a "Views module" view but no appropriate views were found. <br />Note:</p>',
  'version' => 'none',
))
->values(array(
  'lid' => '449',
  'location' => 'modules/userreference/userreference.module:196',
  'textgroup' => 'default',
  'source' => '%name: invalid user.',
  'version' => 'none',
))
->values(array(
  'lid' => '450',
  'location' => 'modules/userreference/userreference.module:349',
  'textgroup' => 'default',
  'source' => 'Select the method used to collect autocomplete suggestions. Note that <em>Contains</em> can cause performance issues on sites with thousands of users.',
  'version' => 'none',
))
->values(array(
  'lid' => '451',
  'location' => 'modules/userreference/userreference.module:357',
  'textgroup' => 'default',
  'source' => 'Reverse link',
  'version' => 'none',
))
->values(array(
  'lid' => '452',
  'location' => 'modules/userreference/userreference.module:359',
  'textgroup' => 'default',
  'source' => 'If selected, a reverse link back to the referencing node will displayed on the referenced user record.',
  'version' => 'none',
))
->values(array(
  'lid' => '453',
  'location' => 'modules/userreference/userreference.module:594',
  'textgroup' => 'default',
  'source' => '%name: found no valid user with that name.',
  'version' => 'none',
))
->values(array(
  'lid' => '454',
  'location' => 'modules/userreference/userreference.module:887',
  'textgroup' => 'default',
  'source' => 'Related content',
  'version' => 'none',
))
->values(array(
  'lid' => '455',
  'location' => 'modules/userreference/userreference.module:15',
  'textgroup' => 'default',
  'source' => 'Userreference autocomplete',
  'version' => 'none',
))
->values(array(
  'lid' => '456',
  'location' => 'userreference.module:0',
  'textgroup' => 'default',
  'source' => 'userreference',
  'version' => 'none',
))
->values(array(
  'lid' => '457',
  'location' => 'modules/userreference/userreference.info:0',
  'textgroup' => 'default',
  'source' => 'User Reference',
  'version' => 'none',
))
->values(array(
  'lid' => '458',
  'location' => 'modules/userreference/userreference.info:0',
  'textgroup' => 'default',
  'source' => 'Defines a field type for referencing a user from a node.',
  'version' => 'none',
))
->values(array(
  'lid' => '459',
  'location' => 'theme/content-admin-field-overview-form.tpl.php:11',
  'textgroup' => 'default',
  'source' => 'Weight',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '460',
  'location' => 'theme/content-admin-field-overview-form.tpl.php:53',
  'textgroup' => 'default',
  'source' => 'Add',
  'version' => 'none',
))
->values(array(
  'lid' => '461',
  'location' => 'theme/content-admin-field-overview-form.tpl.php:59',
  'textgroup' => 'default',
  'source' => 'New field',
  'version' => 'none',
))
->values(array(
  'lid' => '462',
  'location' => 'theme/content-admin-field-overview-form.tpl.php:72',
  'textgroup' => 'default',
  'source' => 'Existing field',
  'version' => 'none',
))
->values(array(
  'lid' => '463',
  'location' => 'theme/content-admin-field-overview-form.tpl.php:84',
  'textgroup' => 'default',
  'source' => 'New group',
  'version' => 'none',
))
->values(array(
  'lid' => '464',
  'location' => 'theme/theme.inc:11',
  'textgroup' => 'default',
  'source' => 'Add fields and groups to the content type, and arrange them on content display and input forms.',
  'version' => 'none',
))
->values(array(
  'lid' => '465',
  'location' => 'theme/theme.inc:13',
  'textgroup' => 'default',
  'source' => 'You can add a field to a group by dragging it below and to the right of the group.',
  'version' => 'none',
))
->values(array(
  'lid' => '466',
  'location' => 'theme/theme.inc:16',
  'textgroup' => 'default',
  'source' => 'Note: Installing the <a href="!adv_help">Advanced help</a> module will let you access more and better help.',
  'version' => 'none',
))
->values(array(
  'lid' => '467',
  'location' => 'theme/theme.inc:116',
  'textgroup' => 'default',
  'source' => "Use the 'Exclude' checkbox to exclude an item from the !content value passed to the node template.",
  'version' => 'none',
))
->values(array(
  'lid' => '468',
  'location' => 'theme/content-edit.js:0',
  'textgroup' => 'default',
  'source' => 'Remove this item',
  'version' => 'none',
))
->values(array(
  'lid' => '469',
  'location' => 'content_admin.inc:290',
  'textgroup' => 'default',
  'source' => 'Add field',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '470',
  'location' => 'field.php:180;190,  number.module:119,  text.module:107',
  'textgroup' => 'default',
  'source' => 'Illegal value for %name.',
  'version' => 'none',
))
->values(array(
  'lid' => '471',
  'location' => 'examples/example_field.php:287 examples/simple_field.php:231,  modules/text/text.module:169',
  'textgroup' => 'default',
  'source' => '%label is longer than %max characters.',
  'version' => 'none',
))
->values(array(
  'lid' => '472',
  'location' => 'field.php:273 text.module:167',
  'textgroup' => 'default',
  'source' => '"Rows" must be a positive integer.',
  'version' => 'none',
))
->values(array(
  'lid' => '473',
  'location' => 'modules/number/number.module:133 modules/text/text.module:92',
  'textgroup' => 'default',
  'source' => 'The possible values this field can contain. Enter one value per line, in the format key|label. The key is the value that will be stored in the database and it must match the field storage type, %type. The label is optional and the key will be used as the label if no label is specified.<br />Allowed HTML tags: @tags',
  'version' => 'none',
))
->values(array(
  'lid' => '474',
  'location' => 'content.module:144',
  'textgroup' => 'default',
  'source' => 'add field',
  'version' => 'none',
))
->values(array(
  'lid' => '475',
  'location' => 'includes/content.admin.inc:112;291',
  'textgroup' => 'default',
  'source' => 'There are no fields configured for this content type. You can !link.',
  'version' => 'none',
))
->values(array(
  'lid' => '476',
  'location' => 'includes/content.admin.inc:113;292',
  'textgroup' => 'default',
  'source' => 'Add a new field',
  'version' => 'none',
))
->values(array(
  'lid' => '477',
  'location' => 'includes/content.admin.inc:137',
  'textgroup' => 'default',
  'source' => 'To change the order of a field, grab a drag-and-drop handle under the Label column and drag the field to a new location in the list. (Grab a handle by clicking and holding the mouse while hovering over a handle icon.) Remember that your changes will not be saved until you click the Save button at the bottom of the page.',
  'version' => 'none',
))
->values(array(
  'lid' => '478',
  'location' => 'includes/content.admin.inc:477',
  'textgroup' => 'default',
  'source' => 'No field modules are enabled. You need to <a href="!modules_url">enable one</a>, such as text.module, before you can add new fields.',
  'version' => 'none',
))
->values(array(
  'lid' => '479',
  'location' => 'content_admin.inc:277',
  'textgroup' => 'default',
  'source' => 'Add existing field',
  'version' => 'none',
))
->values(array(
  'lid' => '480',
  'location' => 'content_admin.inc:311',
  'textgroup' => 'default',
  'source' => 'Create new field',
  'version' => 'none',
))
->values(array(
  'lid' => '481',
  'location' => 'includes/content.admin.inc:606',
  'textgroup' => 'default',
  'source' => 'The machine-readable name of the field.',
  'version' => 'none',
))
->values(array(
  'lid' => '482',
  'location' => 'includes/content.admin.inc:610',
  'textgroup' => 'default',
  'source' => 'This name cannot be changed.',
  'version' => 'none',
))
->values(array(
  'lid' => '483',
  'location' => 'includes/content.admin.inc:618',
  'textgroup' => 'default',
  'source' => "This name cannot be changed later! The name will be prefixed with 'field_' and can include lowercase unaccented letters, numbers, and underscores. The length of the name, including the prefix, is limited to no more than 32 letters.",
  'version' => 'none',
))
->values(array(
  'lid' => '484',
  'location' => 'includes/content.admin.inc:636',
  'textgroup' => 'default',
  'source' => 'The type of data you would like to store in the database with this field.',
  'version' => 'none',
))
->values(array(
  'lid' => '485',
  'location' => 'includes/content.admin.inc:692',
  'textgroup' => 'default',
  'source' => 'The field name %field_name is invalid. The name must include only lowercase unaccentuated letters, numbers, and underscores.',
  'version' => 'none',
))
->values(array(
  'lid' => '486',
  'location' => 'includes/content.admin.inc:695',
  'textgroup' => 'default',
  'source' => "The field name %field_name is too long. The name is limited to 32 characters, including the 'field_' prefix.",
  'version' => 'none',
))
->values(array(
  'lid' => '487',
  'location' => 'includes/content.admin.inc:706',
  'textgroup' => 'default',
  'source' => 'The field name %field_name already exists.',
  'version' => 'none',
))
->values(array(
  'lid' => '488',
  'location' => 'includes/content.admin.inc:709',
  'textgroup' => 'default',
  'source' => "The name 'field_instance' is a reserved name.",
  'version' => 'none',
))
->values(array(
  'lid' => '489',
  'location' => 'content_admin.inc:432',
  'textgroup' => 'default',
  'source' => 'Created field %label.',
  'version' => 'none',
))
->values(array(
  'lid' => '490',
  'location' => 'includes/content.admin.inc:754',
  'textgroup' => 'default',
  'source' => 'Update field %label.',
  'version' => 'none',
))
->values(array(
  'lid' => '491',
  'location' => 'includes/content.admin.inc:758',
  'textgroup' => 'default',
  'source' => 'There was a problem updating field %label.',
  'version' => 'none',
))
->values(array(
  'lid' => '492',
  'location' => 'includes/content.admin.inc:955',
  'textgroup' => 'default',
  'source' => "Advanced usage only: PHP code that returns a default value. Should not include &lt;?php ?&gt; delimiters. If this field is filled out, the value returned by this code will override any value specified above. Expected format: <pre>!sample</pre>Using !link_devel's 'devel load' tab on a %type content page might help you figure out the expected format.",
  'version' => 'none',
))
->values(array(
  'lid' => '493',
  'location' => 'includes/content.admin.inc:986',
  'textgroup' => 'default',
  'source' => "Select a specific number of values for this field, or 'Unlimited' to provide an 'Add more' button so the users can add as many values as they like.",
  'version' => 'none',
))
->values(array(
  'lid' => '494',
  'location' => 'includes/content.admin.inc:1131',
  'textgroup' => 'default',
  'source' => 'The default value PHP code created @value which is invalid.',
  'version' => 'none',
))
->values(array(
  'lid' => '495',
  'location' => 'includes/content.token.inc:62',
  'textgroup' => 'default',
  'source' => 'Formatted HTML link to the node',
  'version' => 'none',
))
->values(array(
  'lid' => '496',
  'location' => 'number.module:113',
  'textgroup' => 'default',
  'source' => 'The value of %name may be no smaller than %min.',
  'version' => 'none',
))
->values(array(
  'lid' => '497',
  'location' => 'number.module:116',
  'textgroup' => 'default',
  'source' => 'The value of %name may be no larger than %max.',
  'version' => 'none',
))
->values(array(
  'lid' => '498',
  'location' => 'modules/number/number.module:476',
  'textgroup' => 'default',
  'source' => 'Only numbers and decimals are allowed in %field. %start was changed to %value.',
  'version' => 'none',
))
->values(array(
  'lid' => '499',
  'location' => 'modules/number/number.module:494',
  'textgroup' => 'default',
  'source' => 'Only numbers are allowed in %field. %start was changed to %value.',
  'version' => 'none',
))
->values(array(
  'lid' => '500',
  'location' => 'modules/number/number.module:513',
  'textgroup' => 'default',
  'source' => 'Only numbers and the decimal character (%decimal) are allowed in %field. %start was changed to %value.',
  'version' => 'none',
))
->values(array(
  'lid' => '501',
  'location' => 'modules/optionwidgets/optionwidgets.module:10',
  'textgroup' => 'default',
  'source' => 'Create a list of options as a list in <strong>Allowed values</strong> or as an array in PHP code. These values will be the same for %field in all content types.',
  'version' => 'none',
))
->values(array(
  'lid' => '502',
  'location' => 'misc/tabledrag.js',
  'textgroup' => 'default',
  'source' => 'Drag to re-order',
  'version' => 'none',
))
->values(array(
  'lid' => '503',
  'location' => 'misc/tabledrag.js',
  'textgroup' => 'default',
  'source' => 'Changes made in this table will not be saved until the form is submitted.',
  'version' => 'none',
))
->values(array(
  'lid' => '504',
  'location' => 'field:profile_color:title',
  'textgroup' => 'profile',
  'source' => 'Favorite color',
  'version' => '1',
))
->values(array(
  'lid' => '505',
  'location' => 'field:profile_color:explanation',
  'textgroup' => 'profile',
  'source' => 'List your favorite color',
  'version' => '1',
))
->values(array(
  'lid' => '506',
  'location' => 'category',
  'textgroup' => 'profile',
  'source' => 'Personal information',
  'version' => '1',
))
->values(array(
  'lid' => '507',
  'location' => 'field:profile_biography:title',
  'textgroup' => 'profile',
  'source' => 'Biography',
  'version' => '1',
))
->values(array(
  'lid' => '508',
  'location' => 'field:profile_biography:explanation',
  'textgroup' => 'profile',
  'source' => 'Tell people a little bit about yourself',
  'version' => '1',
))
->values(array(
  'lid' => '509',
  'location' => 'field:profile_sell_Address:title',
  'textgroup' => 'profile',
  'source' => 'Sell your email address?',
  'version' => '1',
))
->values(array(
  'lid' => '510',
  'location' => 'field:profile_sell_Address:explanation',
  'textgroup' => 'profile',
  'source' => "If you check this box, we'll sell your address to spammers to help line the pockets of our shareholders. Thanks!",
  'version' => '1',
))
->values(array(
  'lid' => '511',
  'location' => 'category',
  'textgroup' => 'profile',
  'source' => 'Communication preferences',
  'version' => '1',
))
->values(array(
  'lid' => '512',
  'location' => 'field:profile_sold_to:title',
  'textgroup' => 'profile',
  'source' => 'Sales Category',
  'version' => '1',
))
->values(array(
  'lid' => '513',
  'location' => 'field:profile_sold_to:explanation',
  'textgroup' => 'profile',
  'source' => "Select the sales categories to which this user's address was sold.",
  'version' => '1',
))
->values(array(
  'lid' => '514',
  'location' => 'field:profile_sold_to:options',
  'textgroup' => 'profile',
  'source' => "Pill spammers\r\nFitness spammers\r\nBack\\slash\r\nForward/slash\r\nDot.in.the.middle",
  'version' => '1',
))
->values(array(
  'lid' => '515',
  'location' => 'category',
  'textgroup' => 'profile',
  'source' => 'Administrative data',
  'version' => '1',
))
->values(array(
  'lid' => '516',
  'location' => 'field:profile_bands:title',
  'textgroup' => 'profile',
  'source' => 'Favorite bands',
  'version' => '1',
))
->values(array(
  'lid' => '517',
  'location' => 'field:profile_bands:explanation',
  'textgroup' => 'profile',
  'source' => "Enter your favorite bands. When you've saved your profile, you'll be able to find other people with the same favorites.",
  'version' => '1',
))
->values(array(
  'lid' => '518',
  'location' => 'field:profile_birthdate:title',
  'textgroup' => 'profile',
  'source' => 'Birthdate',
  'version' => '1',
))
->values(array(
  'lid' => '519',
  'location' => 'field:profile_birthdate:explanation',
  'textgroup' => 'profile',
  'source' => "Enter your birth date and we'll send you a coupon.",
  'version' => '1',
))
->values(array(
  'lid' => '520',
  'location' => 'field:profile_really_really_love_migrations:title',
  'textgroup' => 'profile',
  'source' => 'I really, really, really love migrations',
  'version' => '1',
))
->values(array(
  'lid' => '521',
  'location' => 'field:profile_really_really_love_migrations:explanation',
  'textgroup' => 'profile',
  'source' => 'If you check this box, you love migrations.',
  'version' => '1',
))
->values(array(
  'lid' => '522',
  'location' => 'field:profile_blog:title',
  'textgroup' => 'profile',
  'source' => 'Blog',
  'version' => '1',
))
->values(array(
  'lid' => '523',
  'location' => 'field:profile_blog:explanation',
  'textgroup' => 'profile',
  'source' => 'Paste the full URL, including http://, of your personal blog.',
  'version' => '1',
))
->values(array(
  'lid' => '524',
  'location' => 'block:1:title',
  'textgroup' => 'blocks',
  'source' => 'Static Block',
  'version' => '1',
))
->values(array(
  'lid' => '525',
  'location' => 'block:1:body',
  'textgroup' => 'blocks',
  'source' => '<h3>My first custom block body</h3>',
  'version' => '1',
))
->values(array(
  'lid' => '526',
  'location' => 'block:2:title',
  'textgroup' => 'blocks',
  'source' => 'Another Static Block',
  'version' => '1',
))
->values(array(
  'lid' => '527',
  'location' => 'block:2:body',
  'textgroup' => 'blocks',
  'source' => '<h3>My second custom block body</h3>',
  'version' => '1',
))
->values(array(
  'lid' => '528',
  'location' => 'vocabulary:4:name',
  'textgroup' => 'taxonomy',
  'source' => 'Tags',
  'version' => '1',
))
->values(array(
  'lid' => '529',
  'location' => 'vocabulary:1:name',
  'textgroup' => 'taxonomy',
  'source' => 'vocabulary 1 (i=0)',
  'version' => '1',
))
->values(array(
  'lid' => '530',
  'location' => 'vocabulary:2:name',
  'textgroup' => 'taxonomy',
  'source' => 'vocabulary 2 (i=1)',
  'version' => '1',
))
->values(array(
  'lid' => '531',
  'location' => 'vocabulary:3:name',
  'textgroup' => 'taxonomy',
  'source' => 'vocabulary 3 (i=2)',
  'version' => '1',
))
->values(array(
  'lid' => '532',
  'location' => 'vocabulary:5:name',
  'textgroup' => 'taxonomy',
  'source' => 'vocabulary name much longer than thirty two characters',
  'version' => '1',
))
->values(array(
  'lid' => '533',
  'location' => 'type:article:name',
  'textgroup' => 'nodetype',
  'source' => 'Article',
  'version' => '1',
))
->values(array(
  'lid' => '534',
  'location' => 'type:article:title',
  'textgroup' => 'nodetype',
  'source' => 'Title',
  'version' => '1',
))
->values(array(
  'lid' => '535',
  'location' => 'type:article:body',
  'textgroup' => 'nodetype',
  'source' => 'Body',
  'version' => '1',
))
->values(array(
  'lid' => '536',
  'location' => 'type:article:description',
  'textgroup' => 'nodetype',
  'source' => 'An <em>article</em>, content type.',
  'version' => '1',
))
->values(array(
  'lid' => '537',
  'location' => 'type:company:name',
  'textgroup' => 'nodetype',
  'source' => 'Company',
  'version' => '1',
))
->values(array(
  'lid' => '538',
  'location' => 'type:company:title',
  'textgroup' => 'nodetype',
  'source' => 'Name',
  'version' => '1',
))
->values(array(
  'lid' => '539',
  'location' => 'type:company:body',
  'textgroup' => 'nodetype',
  'source' => 'Description',
  'version' => '1',
))
->values(array(
  'lid' => '540',
  'location' => 'type:company:description',
  'textgroup' => 'nodetype',
  'source' => 'Company node type',
  'version' => '1',
))
->values(array(
  'lid' => '541',
  'location' => 'type:employee:name',
  'textgroup' => 'nodetype',
  'source' => 'Employee',
  'version' => '1',
))
->values(array(
  'lid' => '542',
  'location' => 'type:employee:title',
  'textgroup' => 'nodetype',
  'source' => 'Name',
  'version' => '1',
))
->values(array(
  'lid' => '543',
  'location' => 'type:employee:body',
  'textgroup' => 'nodetype',
  'source' => 'Bio',
  'version' => '1',
))
->values(array(
  'lid' => '544',
  'location' => 'type:employee:description',
  'textgroup' => 'nodetype',
  'source' => 'Employee node type',
  'version' => '1',
))
->values(array(
  'lid' => '545',
  'location' => 'type:sponsor:name',
  'textgroup' => 'nodetype',
  'source' => 'Sponsor',
  'version' => '1',
))
->values(array(
  'lid' => '546',
  'location' => 'type:sponsor:title',
  'textgroup' => 'nodetype',
  'source' => 'Name',
  'version' => '1',
))
->values(array(
  'lid' => '547',
  'location' => 'type:sponsor:body',
  'textgroup' => 'nodetype',
  'source' => 'Body',
  'version' => '1',
))
->values(array(
  'lid' => '548',
  'location' => 'type:sponsor:description',
  'textgroup' => 'nodetype',
  'source' => 'Sponsor node type',
  'version' => '1',
))
->values(array(
  'lid' => '549',
  'location' => 'type:story:name',
  'textgroup' => 'nodetype',
  'source' => 'Story',
  'version' => '1',
))
->values(array(
  'lid' => '550',
  'location' => 'type:story:title',
  'textgroup' => 'nodetype',
  'source' => 'Title',
  'version' => '1',
))
->values(array(
  'lid' => '551',
  'location' => 'type:story:body',
  'textgroup' => 'nodetype',
  'source' => 'Body',
  'version' => '1',
))
->values(array(
  'lid' => '552',
  'location' => 'type:story:description',
  'textgroup' => 'nodetype',
  'source' => "A <em>story</em>, similar in form to a <em>page</em>, is ideal for creating and displaying content that informs or engages website visitors. Press releases, site announcements, and informal blog-like entries may all be created with a <em>story</em> entry. By default, a <em>story</em> entry is automatically featured on the site's initial home page, and provides the ability to post comments.",
  'version' => '1',
))
->values(array(
  'lid' => '553',
  'location' => 'type:test_event:name',
  'textgroup' => 'nodetype',
  'source' => 'Migrate test event',
  'version' => '1',
))
->values(array(
  'lid' => '554',
  'location' => 'type:test_event:title',
  'textgroup' => 'nodetype',
  'source' => 'Event Name',
  'version' => '1',
))
->values(array(
  'lid' => '555',
  'location' => 'type:test_event:body',
  'textgroup' => 'nodetype',
  'source' => 'Body',
  'version' => '1',
))
->values(array(
  'lid' => '556',
  'location' => 'type:test_event:description',
  'textgroup' => 'nodetype',
  'source' => 'test event description here',
  'version' => '1',
))
->values(array(
  'lid' => '558',
  'location' => 'type:test_page:name',
  'textgroup' => 'nodetype',
  'source' => 'Migrate test page',
  'version' => '1',
))
->values(array(
  'lid' => '559',
  'location' => 'type:test_page:title',
  'textgroup' => 'nodetype',
  'source' => 'Title',
  'version' => '1',
))
->values(array(
  'lid' => '560',
  'location' => 'type:test_page:body',
  'textgroup' => 'nodetype',
  'source' => 'This is the body field label',
  'version' => '1',
))
->values(array(
  'lid' => '561',
  'location' => 'type:test_page:description',
  'textgroup' => 'nodetype',
  'source' => "A <em>page</em>, similar in form to a <em>story</em>, is a simple method for creating and displaying information that rarely changes, such as an \"About us\" section of a website. By default, a <em>page</em> entry does not allow visitor comments and is not featured on the site's initial home page.",
  'version' => '1',
))
->values(array(
  'lid' => '562',
  'location' => 'type:test_planet:name',
  'textgroup' => 'nodetype',
  'source' => 'Migrate test planet',
  'version' => '1',
))
->values(array(
  'lid' => '563',
  'location' => 'type:test_planet:title',
  'textgroup' => 'nodetype',
  'source' => 'Title',
  'version' => '1',
))
->values(array(
  'lid' => '564',
  'location' => 'type:test_planet:body',
  'textgroup' => 'nodetype',
  'source' => 'Body',
  'version' => '1',
))
->values(array(
  'lid' => '565',
  'location' => 'type:test_planet:description',
  'textgroup' => 'nodetype',
  'source' => "A <em>story</em>, similar in form to a <em>page</em>, is ideal for creating and displaying content that informs or engages website visitors. Press releases, site announcements, and informal blog-like entries may all be created with a <em>story</em> entry. By default, a <em>story</em> entry is automatically featured on the site's initial home page, and provides the ability to post comments.",
  'version' => '1',
))
->values(array(
  'lid' => '566',
  'location' => 'type:test_story:name',
  'textgroup' => 'nodetype',
  'source' => 'Migrate test story',
  'version' => '1',
))
->values(array(
  'lid' => '567',
  'location' => 'type:test_story:title',
  'textgroup' => 'nodetype',
  'source' => 'Title',
  'version' => '1',
))
->values(array(
  'lid' => '568',
  'location' => 'type:test_story:body',
  'textgroup' => 'nodetype',
  'source' => 'Body',
  'version' => '1',
))
->values(array(
  'lid' => '569',
  'location' => 'type:test_story:description',
  'textgroup' => 'nodetype',
  'source' => "A <em>story</em>, similar in form to a <em>page</em>, is ideal for creating and displaying content that informs or engages website visitors. Press releases, site announcements, and informal blog-like entries may all be created with a <em>story</em> entry. By default, a <em>story</em> entry is automatically featured on the site's initial home page, and provides the ability to post comments.",
  'version' => '1',
))
->values(array(
  'lid' => '570',
  'location' => 'field:story-field_test_exclude_unset:widget_label',
  'textgroup' => 'cck',
  'source' => 'Text Field',
  'version' => '1',
))
->values(array(
  'lid' => '571',
  'location' => 'field:story-field_test_exclude_unset:widget_description',
  'textgroup' => 'cck',
  'source' => 'An example text field without exclude.',
  'version' => '1',
))
->values(array(
  'lid' => '572',
  'location' => 'field:story-field_test_two:widget_label',
  'textgroup' => 'cck',
  'source' => 'Integer Field',
  'version' => '1',
))
->values(array(
  'lid' => '573',
  'location' => 'field:story-field_test_two:widget_description',
  'textgroup' => 'cck',
  'source' => 'An example integer field.',
  'version' => '1',
))
->values(array(
  'lid' => '574',
  'location' => 'field:story-field_test:widget_label',
  'textgroup' => 'cck',
  'source' => 'Text Field',
  'version' => '1',
))
->values(array(
  'lid' => '575',
  'location' => 'field:story-field_test:widget_description',
  'textgroup' => 'cck',
  'source' => 'An example text field.',
  'version' => '1',
))
->values(array(
  'lid' => '576',
  'location' => 'field:story-field_test_three:widget_label',
  'textgroup' => 'cck',
  'source' => 'Decimal Field',
  'version' => '1',
))
->values(array(
  'lid' => '577',
  'location' => 'field:story-field_test_three:widget_description',
  'textgroup' => 'cck',
  'source' => 'An example decimal field.',
  'version' => '1',
))
->values(array(
  'lid' => '578',
  'location' => 'field:story-field_test_four:widget_label',
  'textgroup' => 'cck',
  'source' => 'Float Field',
  'version' => '1',
))
->values(array(
  'lid' => '579',
  'location' => 'field:story-field_test_four:widget_description',
  'textgroup' => 'cck',
  'source' => 'An example float field.',
  'version' => '1',
))
->values(array(
  'lid' => '580',
  'location' => 'field:story-field_test_identical1:widget_label',
  'textgroup' => 'cck',
  'source' => 'Integer Field',
  'version' => '1',
))
->values(array(
  'lid' => '581',
  'location' => 'field:story-field_test_identical1:widget_description',
  'textgroup' => 'cck',
  'source' => 'An example integer field.',
  'version' => '1',
))
->values(array(
  'lid' => '582',
  'location' => 'field:story-field_test_identical2:widget_label',
  'textgroup' => 'cck',
  'source' => 'Integer Field',
  'version' => '1',
))
->values(array(
  'lid' => '583',
  'location' => 'field:story-field_test_identical2:widget_description',
  'textgroup' => 'cck',
  'source' => 'An example integer field.',
  'version' => '1',
))
->values(array(
  'lid' => '584',
  'location' => 'field:story-field_test_email:widget_label',
  'textgroup' => 'cck',
  'source' => 'Email Field',
  'version' => '1',
))
->values(array(
  'lid' => '585',
  'location' => 'field:story-field_test_email:widget_description',
  'textgroup' => 'cck',
  'source' => 'An example email field.',
  'version' => '1',
))
->values(array(
  'lid' => '586',
  'location' => 'field:story-field_test_link:widget_label',
  'textgroup' => 'cck',
  'source' => 'Link Field',
  'version' => '1',
))
->values(array(
  'lid' => '587',
  'location' => 'field:story-field_test_link:widget_description',
  'textgroup' => 'cck',
  'source' => 'An example link field.',
  'version' => '1',
))
->values(array(
  'lid' => '588',
  'location' => 'field:story-field_test_filefield:widget_label',
  'textgroup' => 'cck',
  'source' => 'File Field',
  'version' => '1',
))
->values(array(
  'lid' => '589',
  'location' => 'field:story-field_test_filefield:widget_description',
  'textgroup' => 'cck',
  'source' => 'An example image field.',
  'version' => '1',
))
->values(array(
  'lid' => '590',
  'location' => 'field:story-field_test_imagefield:widget_label',
  'textgroup' => 'cck',
  'source' => 'Image Field',
  'version' => '1',
))
->values(array(
  'lid' => '591',
  'location' => 'field:story-field_test_imagefield:widget_description',
  'textgroup' => 'cck',
  'source' => 'An example image field.',
  'version' => '1',
))
->values(array(
  'lid' => '592',
  'location' => 'field:story-field_test_date:widget_label',
  'textgroup' => 'cck',
  'source' => 'Date Field',
  'version' => '1',
))
->values(array(
  'lid' => '593',
  'location' => 'field:story-field_test_date:widget_description',
  'textgroup' => 'cck',
  'source' => 'An example date field.',
  'version' => '1',
))
->values(array(
  'lid' => '594',
  'location' => 'field:story-field_test_datestamp:widget_label',
  'textgroup' => 'cck',
  'source' => 'Date Stamp Field',
  'version' => '1',
))
->values(array(
  'lid' => '595',
  'location' => 'field:story-field_test_datestamp:widget_description',
  'textgroup' => 'cck',
  'source' => 'An example date stamp field.',
  'version' => '1',
))
->values(array(
  'lid' => '596',
  'location' => 'field:story-field_test_datetime:widget_label',
  'textgroup' => 'cck',
  'source' => 'Datetime Field',
  'version' => '1',
))
->values(array(
  'lid' => '597',
  'location' => 'field:story-field_test_datetime:widget_description',
  'textgroup' => 'cck',
  'source' => 'An example datetime field.',
  'version' => '1',
))
->values(array(
  'lid' => '598',
  'location' => 'field:story-field_test_phone:widget_label',
  'textgroup' => 'cck',
  'source' => 'Phone Field',
  'version' => '1',
))
->values(array(
  'lid' => '599',
  'location' => 'field:story-field_test_phone:widget_description',
  'textgroup' => 'cck',
  'source' => 'An example phone field.',
  'version' => '1',
))
->values(array(
  'lid' => '600',
  'location' => 'field:story-field_test_decimal_radio_buttons:widget_label',
  'textgroup' => 'cck',
  'source' => 'Decimal Radio Buttons Field',
  'version' => '1',
))
->values(array(
  'lid' => '601',
  'location' => 'field:story-field_test_decimal_radio_buttons:widget_description',
  'textgroup' => 'cck',
  'source' => 'An example decimal field using radio buttons.',
  'version' => '1',
))
->values(array(
  'lid' => '602',
  'location' => 'field:field_test_decimal_radio_buttons:option_1.2',
  'textgroup' => 'cck',
  'source' => '1.2',
  'version' => '1',
))
->values(array(
  'lid' => '603',
  'location' => 'field:field_test_decimal_radio_buttons:option_2.1',
  'textgroup' => 'cck',
  'source' => '2.1',
  'version' => '1',
))
->values(array(
  'lid' => '604',
  'location' => 'field:story-field_test_float_single_checkbox:widget_label',
  'textgroup' => 'cck',
  'source' => 'Float Single Checkbox Field',
  'version' => '1',
))
->values(array(
  'lid' => '605',
  'location' => 'field:story-field_test_float_single_checkbox:widget_description',
  'textgroup' => 'cck',
  'source' => 'An example float field using a single on/off checkbox.',
  'version' => '1',
))
->values(array(
  'lid' => '606',
  'location' => 'field:field_test_float_single_checkbox:option_3.142',
  'textgroup' => 'cck',
  'source' => '3.142',
  'version' => '1',
))
->values(array(
  'lid' => '607',
  'location' => 'field:field_test_float_single_checkbox:option_1.234',
  'textgroup' => 'cck',
  'source' => '1.234',
  'version' => '1',
))
->values(array(
  'lid' => '608',
  'location' => 'field:story-field_test_integer_selectlist:widget_label',
  'textgroup' => 'cck',
  'source' => 'Integer Select List Field',
  'version' => '1',
))
->values(array(
  'lid' => '609',
  'location' => 'field:story-field_test_integer_selectlist:widget_description',
  'textgroup' => 'cck',
  'source' => 'An example integer field using a select list.',
  'version' => '1',
))
->values(array(
  'lid' => '610',
  'location' => 'field:field_test_integer_selectlist:option_1234',
  'textgroup' => 'cck',
  'source' => '1234',
  'version' => '1',
))
->values(array(
  'lid' => '611',
  'location' => 'field:field_test_integer_selectlist:option_2341',
  'textgroup' => 'cck',
  'source' => '2341',
  'version' => '1',
))
->values(array(
  'lid' => '612',
  'location' => 'field:field_test_integer_selectlist:option_3412',
  'textgroup' => 'cck',
  'source' => '3412',
  'version' => '1',
))
->values(array(
  'lid' => '613',
  'location' => 'field:field_test_integer_selectlist:option_4123',
  'textgroup' => 'cck',
  'source' => '4123',
  'version' => '1',
))
->values(array(
  'lid' => '614',
  'location' => 'field:story-field_test_text_single_checkbox:widget_label',
  'textgroup' => 'cck',
  'source' => 'Text Single Checkbox Field',
  'version' => '1',
))
->values(array(
  'lid' => '615',
  'location' => 'field:story-field_test_text_single_checkbox:widget_description',
  'textgroup' => 'cck',
  'source' => 'An example text field using a single on/off checkbox.',
  'version' => '1',
))
->values(array(
  'lid' => '616',
  'location' => 'field:field_test_text_single_checkbox:option_0',
  'textgroup' => 'cck',
  'source' => 'Hello',
  'version' => '1',
))
->values(array(
  'lid' => '617',
  'location' => 'field:field_test_text_single_checkbox:option_1',
  'textgroup' => 'cck',
  'source' => 'Goodbye',
  'version' => '1',
))
->values(array(
  'lid' => '618',
  'location' => 'field:story-field_test_text_single_checkbox2:widget_label',
  'textgroup' => 'cck',
  'source' => 'Text Single Checkbox Field 2',
  'version' => '1',
))
->values(array(
  'lid' => '619',
  'location' => 'field:story-field_test_text_single_checkbox2:widget_description',
  'textgroup' => 'cck',
  'source' => 'Checkbox that uses keys only and no label.',
  'version' => '1',
))
->values(array(
  'lid' => '620',
  'location' => 'field:field_test_text_single_checkbox2:option_Off',
  'textgroup' => 'cck',
  'source' => 'Off',
  'version' => '1',
))
->values(array(
  'lid' => '621',
  'location' => 'field:field_test_text_single_checkbox2:option_Hello',
  'textgroup' => 'cck',
  'source' => 'Hello',
  'version' => '1',
))
->values(array(
  'lid' => '622',
  'location' => 'field:test_page-field_test:widget_label',
  'textgroup' => 'cck',
  'source' => 'Text Field',
  'version' => '1',
))
->values(array(
  'lid' => '623',
  'location' => 'field:test_page-field_test:widget_description',
  'textgroup' => 'cck',
  'source' => 'An example text field.',
  'version' => '1',
))
->values(array(
  'lid' => '624',
  'location' => 'field:test_planet-field_multivalue:widget_label',
  'textgroup' => 'cck',
  'source' => 'Decimal Field',
  'version' => '1',
))
->values(array(
  'lid' => '625',
  'location' => 'field:test_planet-field_multivalue:widget_description',
  'textgroup' => 'cck',
  'source' => 'An example multi-valued decimal field.',
  'version' => '1',
))
->values(array(
  'lid' => '627',
  'location' => 'field:test_planet-field_test_text_single_checkbox:widget_description',
  'textgroup' => 'cck',
  'source' => 'An example text field using a single on/off checkbox.',
  'version' => '1',
))
->values(array(
  'lid' => '628',
  'location' => 'misc/tableselect.js',
  'textgroup' => 'default',
  'source' => 'Select all rows in this table',
  'version' => 'none',
))
->values(array(
  'lid' => '629',
  'location' => 'misc/tableselect.js',
  'textgroup' => 'default',
  'source' => 'Deselect all rows in this table',
  'version' => 'none',
))
->values(array(
  'lid' => '630',
  'location' => 'sites/all/modules/filefield/filefield.js',
  'textgroup' => 'default',
  'source' => 'The selected file %filename cannot be uploaded. Only files with the following extensions are allowed: %extensions.',
  'version' => 'none',
))
->values(array(
  'lid' => '631',
  'location' => 'misc/teaser.js',
  'textgroup' => 'default',
  'source' => 'Split summary at cursor',
  'version' => 'none',
))
->values(array(
  'lid' => '632',
  'location' => 'misc/teaser.js',
  'textgroup' => 'default',
  'source' => 'Join summary',
  'version' => 'none',
))
->values(array(
  'lid' => '633',
  'location' => 'item:140:title',
  'textgroup' => 'menu',
  'source' => 'Drupal.org',
  'version' => '1',
))
->values(array(
  'lid' => '634',
  'location' => 'item:139:title',
  'textgroup' => 'menu',
  'source' => 'Test 2',
  'version' => '1',
))
->values(array(
  'lid' => '635',
  'location' => 'item:139:description',
  'textgroup' => 'menu',
  'source' => 'Test menu link 2',
  'version' => '1',
))
->values(array(
  'lid' => '636',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Site information',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '637',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Change basic site information, such as the site name, slogan, e-mail address, mission, front page and more.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '638',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'The name of this website.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '639',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'E-mail address',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '640',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => "The <em>From</em> address in automated e-mails sent during registration and new password requests, and other notifications. (Use an address ending in your site's domain to help prevent this e-mail being flagged as spam.)",
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '641',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Slogan',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '642',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => "Your site's motto, tag line, or catchphrase (often displayed alongside the title of the site).",
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '643',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Mission',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '644',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => "Your site's mission or focus statement (often prominently displayed on the front page).",
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '645',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Footer message',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '646',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'This text will be displayed at the bottom of each page. Useful for adding a copyright notice to your pages.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '647',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Anonymous user',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '648',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Anonymous',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '649',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'The name used to indicate anonymous users.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '650',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Default front page',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '651',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'The home page displays content from this relative URL. If unsure, specify "node".',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '652',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Save configuration',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '653',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Reset to defaults',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '654',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'This is a multilingual variable.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '655',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Left sidebar',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '656',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Right sidebar',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '657',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Header',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '658',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Footer',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '659',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'RSS feed',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '660',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => '',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '661',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Administer',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '662',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Compact mode',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '663',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Content management',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '664',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => "Manage your site's content.",
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '665',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Reports',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '666',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'View reports from system logs and other status information.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '667',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Site building',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '668',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Control how your site looks and feels.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '669',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Site configuration',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '670',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Adjust basic site configuration options.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '671',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Actions',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '672',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Manage the actions defined for your site.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '673',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Administration theme',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '674',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Settings for how your administrative pages should look.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '675',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Clean URLs',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '676',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Enable or disable clean URLs for your site.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '677',
  'location' => 'date.module:39',
  'textgroup' => 'default',
  'source' => 'Date and time',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '678',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => "Settings for how Drupal displays date and time, as well as the system's default timezone.",
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '679',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Error reporting',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '680',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Control how Drupal deals with errors including 403/404 errors as well as PHP error reporting.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '681',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'File system',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '682',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Tell Drupal where to store uploaded files and how they are accessed.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '683',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'File uploads',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '684',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Control how files may be attached to content.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '685',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Image toolkit',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '686',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Choose which image toolkit to use if you have installed optional toolkits.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '687',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Input formats',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '688',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Configure how content input by users is filtered, including allowed HTML tags. Also allows enabling of module-provided filters.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '689',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Logging and alerts',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '690',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => "Settings for logging and alerts modules. Various modules can route Drupal's system events to different destination, such as syslog, database, email, ...etc.",
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '691',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Performance',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '692',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Enable or disable page caching for anonymous users and set CSS and JS bandwidth optimization options.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '693',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Site maintenance',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '694',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Take the site off-line for maintenance or bring it back online.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '695',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Events',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '696',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Set up how your site handles events.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '697',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'CCK Email Contact Form Settings',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '698',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Administer flood control settings for email contact forms',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '699',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'ImageAPI',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '700',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Configure ImageAPI.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '701',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Languages',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '702',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Configure languages for content and the user interface.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '703',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Variables',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '704',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Edit and delete site variables.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '705',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'User management',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '706',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => "Manage your site's users, groups and access to site features.",
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '707',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Contact',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '708',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Log out',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '709',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'User account',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '710',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'User list',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '711',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Autocomplete taxonomy',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '712',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Compose tips',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '713',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Create content',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '714',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Delete comment',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '715',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Edit comment',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '716',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'File download',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '717',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'User autocomplete',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '718',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'User timezone',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '719',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'My account',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '720',
  'location' => 'content_admin.inc:199',
  'textgroup' => 'default',
  'source' => 'Delete',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '721',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Feed aggregator',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '722',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Books',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '723',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Save string',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '724',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Node title autocomplete',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '725',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'View user profile.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '726',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => "Who's new",
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '727',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Powered by Drupal, an open source content management system',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '728',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Home',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '729',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'The selected file %file could not be uploaded, because the destination %directory is not properly configured.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '730',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'French',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '731',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'The configuration options have been saved.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '732',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Long',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '733',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Medium',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '734',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'Short',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '735',
  'location' => '/?q=fr/admin/settings/site-information',
  'textgroup' => 'default',
  'source' => 'The e-mail address %mail is not valid.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '736',
  'location' => '/?q=fr/admin/settings/error-reporting',
  'textgroup' => 'default',
  'source' => 'Default 403 (access denied) page',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '737',
  'location' => '/?q=fr/admin/settings/error-reporting',
  'textgroup' => 'default',
  'source' => 'This page is displayed when the requested document is denied to the current user. If unsure, specify nothing.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '738',
  'location' => '/?q=fr/admin/settings/error-reporting',
  'textgroup' => 'default',
  'source' => 'Default 404 (not found) page',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '739',
  'location' => '/?q=fr/admin/settings/error-reporting',
  'textgroup' => 'default',
  'source' => 'This page is displayed when no other content matches the requested document. If unsure, specify nothing.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '740',
  'location' => '/?q=fr/admin/settings/error-reporting',
  'textgroup' => 'default',
  'source' => 'Write errors to the log',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '741',
  'location' => '/?q=fr/admin/settings/error-reporting',
  'textgroup' => 'default',
  'source' => 'Write errors to the log and to the screen',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '742',
  'location' => '/?q=fr/admin/settings/error-reporting',
  'textgroup' => 'default',
  'source' => 'Specify where Drupal, PHP and SQL errors are logged. While it is recommended that a site running in a production environment write errors to the log only, in a development or testing environment it may be helpful to write errors both to the log and to the screen.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '743',
  'location' => '/?q=fr/admin/user',
  'textgroup' => 'default',
  'source' => 'Access rules',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '744',
  'location' => '/?q=fr/admin/user',
  'textgroup' => 'default',
  'source' => 'List and create rules to disallow usernames, e-mail addresses, and IP addresses.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '745',
  'location' => '/?q=fr/admin/user',
  'textgroup' => 'default',
  'source' => 'Permissions',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '746',
  'location' => '/?q=fr/admin/user',
  'textgroup' => 'default',
  'source' => 'Determine access to features by selecting permissions for roles.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '747',
  'location' => '/?q=fr/admin/user',
  'textgroup' => 'default',
  'source' => 'Profiles',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '748',
  'location' => '/?q=fr/admin/user',
  'textgroup' => 'default',
  'source' => 'Create customizable fields for your users.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '749',
  'location' => '/?q=fr/admin/user',
  'textgroup' => 'default',
  'source' => 'Roles',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '750',
  'location' => '/?q=fr/admin/user',
  'textgroup' => 'default',
  'source' => 'List, edit, or add user roles.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '751',
  'location' => '/?q=fr/admin/user',
  'textgroup' => 'default',
  'source' => 'User settings',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '752',
  'location' => '/?q=fr/admin/user',
  'textgroup' => 'default',
  'source' => 'Configure default behavior of users, including registration requirements, e-mails, and user pictures.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '753',
  'location' => '/?q=fr/admin/user',
  'textgroup' => 'default',
  'source' => 'Users',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '754',
  'location' => '/?q=fr/admin/user',
  'textgroup' => 'default',
  'source' => 'List, add, and edit users.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '755',
  'location' => '/?q=fr/admin/user/settings',
  'textgroup' => 'default',
  'source' => 'User registration settings',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '756',
  'location' => '/?q=fr/admin/user/settings',
  'textgroup' => 'default',
  'source' => 'Public registrations',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '757',
  'location' => '/?q=fr/admin/user/settings',
  'textgroup' => 'default',
  'source' => 'Only site administrators can create new user accounts.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '758',
  'location' => '/?q=fr/admin/user/settings',
  'textgroup' => 'default',
  'source' => 'Visitors can create accounts and no administrator approval is required.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '759',
  'location' => '/?q=fr/admin/user/settings',
  'textgroup' => 'default',
  'source' => 'Visitors can create accounts but administrator approval is required.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '760',
  'location' => '/?q=fr/admin/user/settings',
  'textgroup' => 'default',
  'source' => 'Require e-mail verification when a visitor creates an account',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '761',
  'location' => '/?q=fr/admin/user/settings',
  'textgroup' => 'default',
  'source' => 'If this box is checked, new users will be required to validate their e-mail address prior to logging into the site, and will be assigned a system-generated password. With it unchecked, users will be logged in immediately upon registering, and may select their own passwords during registration.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '762',
  'location' => '/?q=fr/admin/user/settings',
  'textgroup' => 'default',
  'source' => 'User registration guidelines',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '763',
  'location' => '/?q=fr/admin/user/settings',
  'textgroup' => 'default',
  'source' => 'This text is displayed at the top of the user registration form and is useful for helping or instructing your users.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '764',
  'location' => '/?q=fr/admin/user/settings',
  'textgroup' => 'default',
  'source' => 'User e-mail settings',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '765',
  'location' => '/?q=fr/admin/user/settings',
  'textgroup' => 'default',
  'source' => 'Drupal sends emails whenever new users register on your site, and optionally, may also notify users after other account actions. Using a simple set of content templates, notification e-mails can be customized to fit the specific needs of your site.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '766',
  'location' => '/?q=fr/admin/user/settings',
  'textgroup' => 'default',
  'source' => 'Available variables are:',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '767',
  'location' => '/?q=fr/admin/user/settings',
  'textgroup' => 'default',
  'source' => 'Welcome, new user created by administrator',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '768',
  'location' => '/?q=fr/admin/user/settings',
  'textgroup' => 'default',
  'source' => 'Customize welcome e-mail messages sent to new member accounts created by an administrator.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '769',
  'location' => '/?q=fr/admin/user/settings',
  'textgroup' => 'default',
  'source' => 'Subject',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '770',
  'location' => '/?q=fr/admin/user/settings',
  'textgroup' => 'default',
  'source' => 'Body',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '771',
  'location' => '/?q=fr/admin/user/settings',
  'textgroup' => 'default',
  'source' => 'Welcome, no approval required',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '772',
  'location' => '/?q=fr/admin/user/settings',
  'textgroup' => 'default',
  'source' => 'Customize welcome e-mail messages sent to new members upon registering, when no administrator approval is required.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '773',
  'location' => '/?q=fr/admin/user/settings',
  'textgroup' => 'default',
  'source' => 'Welcome, awaiting administrator approval',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '774',
  'location' => '/?q=fr/admin/user/settings',
  'textgroup' => 'default',
  'source' => 'Customize welcome e-mail messages sent to new members upon registering, when administrative approval is required.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '775',
  'location' => '/?q=fr/admin/user/settings',
  'textgroup' => 'default',
  'source' => 'Password recovery email',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '776',
  'location' => '/?q=fr/admin/user/settings',
  'textgroup' => 'default',
  'source' => 'Customize e-mail messages sent to users who request a new password.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '777',
  'location' => '/?q=fr/admin/user/settings',
  'textgroup' => 'default',
  'source' => 'Account activation email',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '778',
  'location' => '/?q=fr/admin/user/settings',
  'textgroup' => 'default',
  'source' => 'Enable and customize e-mail messages sent to users upon account activation (when an administrator activates an account of a user who has already registered, on a site where administrative approval is required).',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '779',
  'location' => '/?q=fr/admin/user/settings',
  'textgroup' => 'default',
  'source' => 'Notify user when account is activated.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '780',
  'location' => '/?q=fr/admin/user/settings',
  'textgroup' => 'default',
  'source' => 'Account blocked email',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '781',
  'location' => '/?q=fr/admin/user/settings',
  'textgroup' => 'default',
  'source' => 'Enable and customize e-mail messages sent to users when their accounts are blocked.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '782',
  'location' => '/?q=fr/admin/user/settings',
  'textgroup' => 'default',
  'source' => 'Notify user when account is blocked.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '783',
  'location' => '/?q=fr/admin/user/settings',
  'textgroup' => 'default',
  'source' => 'Account deleted email',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '784',
  'location' => '/?q=fr/admin/user/settings',
  'textgroup' => 'default',
  'source' => 'Enable and customize e-mail messages sent to users when their accounts are deleted.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '785',
  'location' => '/?q=fr/admin/user/settings',
  'textgroup' => 'default',
  'source' => 'Notify user when account is deleted.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '786',
  'location' => '/?q=fr/admin/user/settings',
  'textgroup' => 'default',
  'source' => 'Signatures',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '787',
  'location' => '/?q=fr/admin/user/settings',
  'textgroup' => 'default',
  'source' => 'Signature support',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '788',
  'location' => '/?q=fr/admin/user/settings',
  'textgroup' => 'default',
  'source' => 'Disabled',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '789',
  'location' => '/?q=fr/admin/user/settings',
  'textgroup' => 'default',
  'source' => 'Enabled',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '790',
  'location' => '/?q=fr/admin/user/settings',
  'textgroup' => 'default',
  'source' => 'Pictures',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '791',
  'location' => '/?q=fr/admin/user/settings',
  'textgroup' => 'default',
  'source' => 'Picture support',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '792',
  'location' => '/?q=fr/admin/user/settings',
  'textgroup' => 'default',
  'source' => 'Picture image path',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '793',
  'location' => '/?q=fr/admin/user/settings',
  'textgroup' => 'default',
  'source' => 'Subdirectory in the directory %dir where pictures will be stored.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '794',
  'location' => '/?q=fr/admin/user/settings',
  'textgroup' => 'default',
  'source' => 'Default picture',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '795',
  'location' => '/?q=fr/admin/user/settings',
  'textgroup' => 'default',
  'source' => 'URL of picture to display for users with no custom picture selected. Leave blank for none.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '796',
  'location' => '/?q=fr/admin/user/settings',
  'textgroup' => 'default',
  'source' => 'Picture maximum dimensions',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '797',
  'location' => '/?q=fr/admin/user/settings',
  'textgroup' => 'default',
  'source' => 'Maximum dimensions for pictures, in pixels.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '798',
  'location' => '/?q=fr/admin/user/settings',
  'textgroup' => 'default',
  'source' => 'Picture maximum file size',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '799',
  'location' => '/?q=fr/admin/user/settings',
  'textgroup' => 'default',
  'source' => 'Maximum file size for pictures, in kB.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '800',
  'location' => '/?q=fr/admin/user/settings',
  'textgroup' => 'default',
  'source' => 'Picture guidelines',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '801',
  'location' => '/?q=fr/admin/user/settings',
  'textgroup' => 'default',
  'source' => "This text is displayed at the picture upload form in addition to the default guidelines. It's useful for helping or instructing your users.",
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '802',
  'location' => '/?q=fr/admin/settings/performance',
  'textgroup' => 'default',
  'source' => 'The normal cache mode is suitable for most sites and does not cause any side effects. The aggressive cache mode causes Drupal to skip the loading (boot) and unloading (exit) of enabled modules when serving a cached page. This results in an additional performance boost but can cause unwanted side effects.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '803',
  'location' => '/?q=fr/admin/settings/performance',
  'textgroup' => 'default',
  'source' => '<strong class="error">The following enabled modules are incompatible with aggressive mode caching and will not function properly: %modules</strong>',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '804',
  'location' => '/?q=fr/admin/settings/performance',
  'textgroup' => 'default',
  'source' => 'Page cache',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '805',
  'location' => '/?q=fr/admin/settings/performance',
  'textgroup' => 'default',
  'source' => 'Enabling the page cache will offer a significant performance boost. Drupal can store and send compressed cached pages requested by <em>anonymous</em> users. By caching a web page, Drupal does not have to construct the page each time it is viewed.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '806',
  'location' => '/?q=fr/admin/settings/performance',
  'textgroup' => 'default',
  'source' => 'Caching mode',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '807',
  'location' => '/?q=fr/admin/settings/performance',
  'textgroup' => 'default',
  'source' => 'Normal (recommended for production sites, no side effects)',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '808',
  'location' => '/?q=fr/admin/settings/performance',
  'textgroup' => 'default',
  'source' => 'Aggressive (experts only, possible side effects)',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '809',
  'location' => '/?q=fr/admin/settings/performance',
  'textgroup' => 'default',
  'source' => '0 sec',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '810',
  'location' => '/?q=fr/admin/settings/performance',
  'textgroup' => 'default',
  'source' => '1 min',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '811',
  'location' => '/?q=fr/admin/settings/performance',
  'textgroup' => 'default',
  'source' => '@count min',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '812',
  'location' => '/?q=fr/admin/settings/performance',
  'textgroup' => 'default',
  'source' => '1 hour',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '813',
  'location' => '/?q=fr/admin/settings/performance',
  'textgroup' => 'default',
  'source' => '@count hours',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '814',
  'location' => '/?q=fr/admin/settings/performance',
  'textgroup' => 'default',
  'source' => '1 day',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '815',
  'location' => '/?q=fr/admin/settings/performance',
  'textgroup' => 'default',
  'source' => 'Minimum cache lifetime',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '816',
  'location' => '/?q=fr/admin/settings/performance',
  'textgroup' => 'default',
  'source' => 'On high-traffic sites, it may be necessary to enforce a minimum cache lifetime. The minimum cache lifetime is the minimum amount of time that will elapse before the cache is emptied and recreated, and is applied to both page and block caches. A larger minimum cache lifetime offers better performance, but users will not see new content for a longer period of time.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '817',
  'location' => '/?q=fr/admin/settings/performance',
  'textgroup' => 'default',
  'source' => 'Page compression',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '818',
  'location' => '/?q=fr/admin/settings/performance',
  'textgroup' => 'default',
  'source' => 'By default, Drupal compresses the pages it caches in order to save bandwidth and improve download times. This option should be disabled when using a webserver that performs compression.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '819',
  'location' => '/?q=fr/admin/settings/performance',
  'textgroup' => 'default',
  'source' => 'Block cache',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '820',
  'location' => '/?q=fr/admin/settings/performance',
  'textgroup' => 'default',
  'source' => 'Enabling the block cache can offer a performance increase for all users by preventing blocks from being reconstructed on each page load. If the page cache is also enabled, performance increases from enabling the block cache will mainly benefit authenticated users.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '821',
  'location' => '/?q=fr/admin/settings/performance',
  'textgroup' => 'default',
  'source' => 'Enabled (recommended)',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '822',
  'location' => '/?q=fr/admin/settings/performance',
  'textgroup' => 'default',
  'source' => 'Note that block caching is inactive when modules defining content access restrictions are enabled.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '823',
  'location' => '/?q=fr/admin/settings/performance',
  'textgroup' => 'default',
  'source' => 'Bandwidth optimizations',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '824',
  'location' => '/?q=fr/admin/settings/performance',
  'textgroup' => 'default',
  'source' => '<p>Drupal can automatically optimize external resources like CSS and JavaScript, which can reduce both the size and number of requests made to your website. CSS files can be aggregated and compressed into a single file, while JavaScript files are aggregated (but not compressed). These optional optimizations may reduce server load, bandwidth requirements, and page loading times.</p><p>These options are disabled if you have not set up your files directory, or if your download method is set to private.</p>',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '825',
  'location' => '/?q=fr/admin/settings/performance',
  'textgroup' => 'default',
  'source' => 'Optimize CSS files',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '826',
  'location' => '/?q=fr/admin/settings/performance',
  'textgroup' => 'default',
  'source' => 'This option can interfere with theme development and should only be enabled in a production environment.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '827',
  'location' => '/?q=fr/admin/settings/performance',
  'textgroup' => 'default',
  'source' => 'Optimize JavaScript files',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '828',
  'location' => '/?q=fr/admin/settings/performance',
  'textgroup' => 'default',
  'source' => 'This option can interfere with module development and should only be enabled in a production environment.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '829',
  'location' => '/?q=fr/admin/settings/performance',
  'textgroup' => 'default',
  'source' => 'Clear cached data',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '830',
  'location' => '/?q=fr/admin/settings/performance',
  'textgroup' => 'default',
  'source' => 'Caching data improves performance, but may cause problems while troubleshooting new modules, themes, or translations, if outdated information has been cached. To refresh all cached data on your site, click the button below. <em>Warning: high-traffic sites will experience performance slowdowns while cached data is rebuilt.</em>',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '831',
  'location' => '/?q=fr/admin/settings/site-maintenance',
  'textgroup' => 'default',
  'source' => 'Site status',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '832',
  'location' => '/?q=fr/admin/settings/site-maintenance',
  'textgroup' => 'default',
  'source' => 'Online',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '833',
  'location' => '/?q=fr/admin/settings/site-maintenance',
  'textgroup' => 'default',
  'source' => 'Off-line',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '834',
  'location' => '/?q=fr/admin/settings/site-maintenance',
  'textgroup' => 'default',
  'source' => 'When set to "Online", all visitors will be able to browse your site normally. When set to "Off-line", only users with the "administer site configuration" permission will be able to access your site to perform maintenance; all other visitors will see the site off-line message configured below. Authorized users can log in during "Off-line" mode directly via the <a href="@user-login">user login</a> page.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '835',
  'location' => '/?q=fr/admin/settings/site-maintenance',
  'textgroup' => 'default',
  'source' => 'Site off-line message',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '836',
  'location' => '/?q=fr/admin/settings/site-maintenance',
  'textgroup' => 'default',
  'source' => '@site is currently under maintenance. We should be back shortly. Thank you for your patience.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '837',
  'location' => '/?q=fr/admin/settings/site-maintenance',
  'textgroup' => 'default',
  'source' => 'Message to show visitors when the site is in off-line mode.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '838',
  'location' => '/?q=fr/admin/settings/language',
  'textgroup' => 'default',
  'source' => 'Left to right',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '839',
  'location' => '/?q=fr/admin/settings/language',
  'textgroup' => 'default',
  'source' => 'English name',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '840',
  'location' => '/?q=fr/admin/settings/language',
  'textgroup' => 'default',
  'source' => 'Native name',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '841',
  'location' => '/?q=fr/admin/settings/language',
  'textgroup' => 'default',
  'source' => 'Direction',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '842',
  'location' => '/?q=fr/admin/settings/language',
  'textgroup' => 'default',
  'source' => 'Language negotiation',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '843',
  'location' => '/?q=fr/admin/settings/language',
  'textgroup' => 'default',
  'source' => 'List',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '844',
  'location' => '/?q=fr/admin/settings/language',
  'textgroup' => 'default',
  'source' => 'Options',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '845',
  'location' => '/?q=fr/admin/settings/language',
  'textgroup' => 'default',
  'source' => 'Configure extended options for multilingual content and translations.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '846',
  'location' => '/?q=fr/admin/settings/language',
  'textgroup' => 'default',
  'source' => 'Multilingual variables.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '847',
  'location' => '/?q=fr/admin/settings/language',
  'textgroup' => 'default',
  'source' => 'Add language',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '848',
  'location' => '/?q=fr/admin/settings/language',
  'textgroup' => 'default',
  'source' => 'Multilingual system',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '849',
  'location' => '/?q=fr/admin/settings/language',
  'textgroup' => 'default',
  'source' => 'String translation',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '850',
  'location' => '/?q=fr/admin/settings/language',
  'textgroup' => 'default',
  'source' => "This page provides an overview of your site's enabled languages. If multiple languages are available and enabled, the text on your site interface may be translated, registered users may select their preferred language on the <em>My account</em> page, and site authors may indicate a specific language when creating posts. The site's default language is used for anonymous visitors and for users who have not selected a preferred language.",
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '851',
  'location' => '/?q=fr/admin/settings/language',
  'textgroup' => 'default',
  'source' => 'For each language available on the site, use the <em>edit</em> link to configure language details, including name, an optional language-specific path or domain, and whether the language is natively presented either left-to-right or right-to-left. These languages also appear in the <em>Language</em> selection when creating a post of a content type with multilingual support.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '852',
  'location' => '/?q=fr/admin/settings/language',
  'textgroup' => 'default',
  'source' => 'Use the <a href="@add-language">add language page</a> to enable additional languages (and automatically import files from a translation package, if available), the <a href="@search">translate interface page</a> to locate strings for manual translation, or the <a href="@import">import page</a> to add translations from individual <em>.po</em> files. A number of contributed translation packages containing <em>.po</em> files are available on the <a href="@translations">Drupal.org translations page</a>.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '853',
  'location' => '/?q=fr/admin/settings/language',
  'textgroup' => 'default',
  'source' => '<strong>Warning</strong>: Changing the default language may have unwanted effects on string translations. Read more about <a href="@i18nstrings-help">String translation</a>',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '854',
  'location' => '/?q=fr/admin/settings/filters',
  'textgroup' => 'default',
  'source' => 'anonymous user',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '855',
  'location' => '/?q=fr/admin/settings/filters',
  'textgroup' => 'default',
  'source' => 'authenticated user',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '856',
  'location' => '/?q=fr/admin/settings/filters',
  'textgroup' => 'default',
  'source' => 'All roles may use default format',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '857',
  'location' => 'content_admin.inc:250',
  'textgroup' => 'default',
  'source' => 'configure',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '858',
  'location' => '/?q=fr/admin/settings/filters',
  'textgroup' => 'default',
  'source' => 'No roles may use this format',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '859',
  'location' => '/?q=fr/admin/settings/filters',
  'textgroup' => 'default',
  'source' => 'Set default format',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '860',
  'location' => '/?q=fr/admin/settings/filters',
  'textgroup' => 'default',
  'source' => 'Delete input format',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '861',
  'location' => '/?q=fr/admin/settings/filters',
  'textgroup' => 'default',
  'source' => 'Add input format',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '862',
  'location' => '/?q=fr/admin/settings/filters',
  'textgroup' => 'default',
  'source' => '<em>Input formats</em> define a way of processing user-supplied text in Drupal. Each input format uses filters to manipulate text, and most input formats apply several different filters to text, in a specific order. Each filter is designed to accomplish a specific purpose, and generally either removes elements from or adds elements to text before it is displayed. Users can choose between the available input formats when submitting content.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '863',
  'location' => '/?q=fr/admin/settings/filters',
  'textgroup' => 'default',
  'source' => 'Use the list below to configure which input formats are available to which roles, as well as choose a default input format (used for imported content, for example). The default format is always available to users. All input formats are available to users in a role with the "administer filters" permission.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '864',
  'location' => '/?q=fr/admin/settings/filters',
  'textgroup' => 'default',
  'source' => 'After updating your Input formats do not forget to review the list of formats allowed for string translations on the <a href="@configure-strings">configure translatable strings</a> page.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '865',
  'location' => '/?q=fr/admin/settings/imageapi',
  'textgroup' => 'default',
  'source' => 'There are no image toolkit modules enabled. Toolkit modules can be enabled from the <a href="!admin-build-modules">module configuration page</a>.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '866',
  'location' => '/?q=fr/admin/settings/image-toolkit',
  'textgroup' => 'default',
  'source' => 'GD2 image manipulation toolkit',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '867',
  'location' => '/?q=fr/admin/settings/image-toolkit',
  'textgroup' => 'default',
  'source' => 'The GD toolkit is installed and working properly.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '868',
  'location' => '/?q=fr/admin/settings/image-toolkit',
  'textgroup' => 'default',
  'source' => 'JPEG quality',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '869',
  'location' => '/?q=fr/admin/settings/image-toolkit',
  'textgroup' => 'default',
  'source' => 'Define the image quality for JPEG manipulations. Ranges from 0 to 100. Higher values mean better image quality but bigger files.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '870',
  'location' => '/?q=fr/admin/settings/image-toolkit',
  'textgroup' => 'default',
  'source' => '%',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '871',
  'location' => '/?q=fr/admin/settings/uploads',
  'textgroup' => 'default',
  'source' => 'General settings',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '872',
  'location' => '/?q=fr/admin/settings/uploads',
  'textgroup' => 'default',
  'source' => 'Maximum resolution for uploaded images',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '873',
  'location' => '/?q=fr/admin/settings/uploads',
  'textgroup' => 'default',
  'source' => 'The maximum allowed image size (e.g. 640x480). Set to 0 for no restriction. If an <a href="!image-toolkit-link">image toolkit</a> is installed, files exceeding this value will be scaled down to fit.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '874',
  'location' => '/?q=fr/admin/settings/uploads',
  'textgroup' => 'default',
  'source' => 'WIDTHxHEIGHT',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '875',
  'location' => '/?q=fr/admin/settings/uploads',
  'textgroup' => 'default',
  'source' => 'List files by default',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '876',
  'location' => '/?q=fr/admin/settings/uploads',
  'textgroup' => 'default',
  'source' => 'No',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '877',
  'location' => '/?q=fr/admin/settings/uploads',
  'textgroup' => 'default',
  'source' => 'Yes',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '878',
  'location' => '/?q=fr/admin/settings/uploads',
  'textgroup' => 'default',
  'source' => 'Display attached files when viewing a post.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '879',
  'location' => '/?q=fr/admin/settings/uploads',
  'textgroup' => 'default',
  'source' => 'Default permitted file extensions',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '880',
  'location' => '/?q=fr/admin/settings/uploads',
  'textgroup' => 'default',
  'source' => 'Default extensions that users can upload. Separate extensions with a space and do not include the leading dot.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '881',
  'location' => '/?q=fr/admin/settings/uploads',
  'textgroup' => 'default',
  'source' => 'Default maximum file size per upload',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '882',
  'location' => '/?q=fr/admin/settings/uploads',
  'textgroup' => 'default',
  'source' => 'The default maximum file size a user can upload. If an image is uploaded and a maximum resolution is set, the size will be checked after the file has been resized.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '883',
  'location' => '/?q=fr/admin/settings/uploads',
  'textgroup' => 'default',
  'source' => 'MB',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '884',
  'location' => '/?q=fr/admin/settings/uploads',
  'textgroup' => 'default',
  'source' => 'Default total file size per user',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '885',
  'location' => '/?q=fr/admin/settings/uploads',
  'textgroup' => 'default',
  'source' => 'The default maximum size of all files a user can have on the site.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '886',
  'location' => '/?q=fr/admin/settings/uploads',
  'textgroup' => 'default',
  'source' => 'KB',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '887',
  'location' => '/?q=fr/admin/settings/uploads',
  'textgroup' => 'default',
  'source' => '@size @suffix',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '888',
  'location' => '/?q=fr/admin/settings/uploads',
  'textgroup' => 'default',
  'source' => 'Your PHP settings limit the maximum file size per upload to %size.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '889',
  'location' => '/?q=fr/admin/settings/uploads',
  'textgroup' => 'default',
  'source' => 'Users with the <a href="@permissions">upload files permission</a> can upload attachments. Users with the <a href="@permissions">view uploaded files permission</a> can view uploaded attachments. You can choose which post types can take attachments on the <a href="@types">content types settings</a> page.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '890',
  'location' => '/?q=fr/admin/settings/file-system',
  'textgroup' => 'default',
  'source' => 'File system path',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '891',
  'location' => '/?q=fr/admin/settings/file-system',
  'textgroup' => 'default',
  'source' => 'A file system path where the files will be stored. This directory must exist and be writable by Drupal. If the download method is set to public, this directory must be relative to the Drupal installation directory and be accessible over the web. If the download method is set to private, this directory should not be accessible over the web. Changing this location will modify all download paths and may cause unexpected problems on an existing site.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '892',
  'location' => '/?q=fr/admin/settings/file-system',
  'textgroup' => 'default',
  'source' => 'Temporary directory',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '893',
  'location' => '/?q=fr/admin/settings/file-system',
  'textgroup' => 'default',
  'source' => 'A file system path where uploaded files will be stored during previews.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '894',
  'location' => '/?q=fr/admin/settings/file-system',
  'textgroup' => 'default',
  'source' => 'Download method',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '895',
  'location' => '/?q=fr/admin/settings/file-system',
  'textgroup' => 'default',
  'source' => 'Public - files are available using HTTP directly.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '896',
  'location' => '/?q=fr/admin/settings/file-system',
  'textgroup' => 'default',
  'source' => 'Private - files are transferred by Drupal.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '897',
  'location' => '/?q=fr/admin/settings/file-system',
  'textgroup' => 'default',
  'source' => 'Choose the <em>Public download</em> method unless you wish to enforce fine-grained access controls over file downloads. Changing the download method will modify all download paths and may cause unexpected problems on an existing site.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '898',
  'location' => '/?q=fr/admin/settings/file-system',
  'textgroup' => 'default',
  'source' => 'The directory %directory does not exist.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '899',
  'location' => '/?q=fr/admin/settings/event',
  'textgroup' => 'default',
  'source' => 'Event overview',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '900',
  'location' => '/?q=fr/admin/settings/event',
  'textgroup' => 'default',
  'source' => 'Change how event summary information is displayed.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '901',
  'location' => '/?q=fr/admin/settings/event',
  'textgroup' => 'default',
  'source' => 'Timezone handling',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '902',
  'location' => '/?q=fr/admin/settings/event',
  'textgroup' => 'default',
  'source' => 'Change how timezone information is saved and displayed.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '903',
  'location' => '/?q=fr/admin/settings/event/timezone',
  'textgroup' => 'default',
  'source' => 'Event time zone input',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '904',
  'location' => '/?q=fr/admin/settings/event/timezone',
  'textgroup' => 'default',
  'source' => 'Use the sitewide time zone',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '905',
  'location' => '/?q=fr/admin/settings/event/timezone',
  'textgroup' => 'default',
  'source' => 'Use the time zone of the user editing or creating the event',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '906',
  'location' => '/?q=fr/admin/settings/event/timezone',
  'textgroup' => 'default',
  'source' => 'Allow users to set event time zones',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '907',
  'location' => '/?q=fr/admin/settings/event/timezone',
  'textgroup' => 'default',
  'source' => 'date/time settings',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '908',
  'location' => '/?q=fr/admin/settings/event/timezone',
  'textgroup' => 'default',
  'source' => "Events are saved with a time zone value. This setting allows you to determine how the time zone is determined when creating or editing an event. You must have 'Configurable time zones' enabled in the !url before you can enable user's time zones for this feature.",
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '909',
  'location' => '/?q=fr/admin/settings/event/timezone',
  'textgroup' => 'default',
  'source' => 'Event time zone display',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '910',
  'location' => '/?q=fr/admin/settings/event/timezone',
  'textgroup' => 'default',
  'source' => "Use the event's time zone",
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '911',
  'location' => '/?q=fr/admin/settings/event/timezone',
  'textgroup' => 'default',
  'source' => "Events are saved with a time zone value. This setting allows you to determine if the event's time zone, the sitewide time zone, or the user's personal time zone setting is used to display the time for an event. You must have 'Configurable time zones' enabled in the !url before you can enable user's time zones for this feature.",
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '912',
  'location' => '/?q=fr/admin/settings/event/timezone',
  'textgroup' => 'default',
  'source' => 'Time notation preference',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '913',
  'location' => '/?q=fr/admin/settings/event/timezone',
  'textgroup' => 'default',
  'source' => '24h',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '914',
  'location' => '/?q=fr/admin/settings/event/timezone',
  'textgroup' => 'default',
  'source' => '12h',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '915',
  'location' => '/?q=fr/admin/settings/event/timezone',
  'textgroup' => 'default',
  'source' => 'The time notation system used for entering event times.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '916',
  'location' => '/?q=fr/admin/settings/event/overview',
  'textgroup' => 'default',
  'source' => 'Upcoming event block limit',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '917',
  'location' => '/?q=fr/admin/settings/event/overview',
  'textgroup' => 'default',
  'source' => 'Limit the amount of events displayed in the upcoming events block by this amount.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '918',
  'location' => '/?q=fr/admin/settings/event/overview',
  'textgroup' => 'default',
  'source' => 'Default overview',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '919',
  'location' => '/?q=fr/admin/settings/event/overview',
  'textgroup' => 'default',
  'source' => 'Day',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '920',
  'location' => '/?q=fr/admin/settings/event/overview',
  'textgroup' => 'default',
  'source' => 'Week',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '921',
  'location' => '/?q=fr/admin/settings/event/overview',
  'textgroup' => 'default',
  'source' => 'Month',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '922',
  'location' => '/?q=fr/admin/settings/event/overview',
  'textgroup' => 'default',
  'source' => 'Table',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '923',
  'location' => '/?q=fr/admin/settings/event/overview',
  'textgroup' => 'default',
  'source' => 'The default event view to display when no format is specifically requested. This is also the view that will be displayed from the block calendar links.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '924',
  'location' => '/?q=fr/admin/settings/event/overview',
  'textgroup' => 'default',
  'source' => 'Table view default period',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '925',
  'location' => '/?q=fr/admin/settings/event/overview',
  'textgroup' => 'default',
  'source' => 'here',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '926',
  'location' => '/?q=fr/admin/settings/event/overview',
  'textgroup' => 'default',
  'source' => 'The default number of days to display in the table view. You can specify a different number of days in the url. More info on the event url format !link',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '927',
  'location' => '/?q=fr/admin/settings/event/overview',
  'textgroup' => 'default',
  'source' => 'Taxonomy filter controls',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '928',
  'location' => '/?q=fr/admin/settings/event/overview',
  'textgroup' => 'default',
  'source' => 'Show taxonomy filter control on calendar views',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '929',
  'location' => '/?q=fr/admin/settings/event/overview',
  'textgroup' => 'default',
  'source' => 'Only show taxonomy filter control when taxonomy filter view is requested',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '930',
  'location' => '/?q=fr/admin/settings/event/overview',
  'textgroup' => 'default',
  'source' => 'Never show taxonomy filter control',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '931',
  'location' => '/?q=fr/admin/settings/event/overview',
  'textgroup' => 'default',
  'source' => 'Content type filter controls',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '932',
  'location' => '/?q=fr/admin/settings/event/overview',
  'textgroup' => 'default',
  'source' => 'Show content type filter control on calendar views',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '933',
  'location' => '/?q=fr/admin/settings/event/overview',
  'textgroup' => 'default',
  'source' => 'Only show content type filter control when content type filter view is requested',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '934',
  'location' => '/?q=fr/admin/settings/event/overview',
  'textgroup' => 'default',
  'source' => 'Never show content type filter control',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '935',
  'location' => '/?q=fr/admin/settings/email',
  'textgroup' => 'default',
  'source' => 'Hourly threshold for a CCK Email contact form',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '936',
  'location' => '/?q=fr/admin/settings/email',
  'textgroup' => 'default',
  'source' => 'The maximum number of contact form submissions a user can perform per hour.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '937',
  'location' => '/?q=fr/admin/settings/admin',
  'textgroup' => 'default',
  'source' => 'System default',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '938',
  'location' => '/?q=fr/admin/settings/admin',
  'textgroup' => 'default',
  'source' => 'Choose which theme the administration pages should display in. If you choose "System default" the administration pages will use the same theme as the rest of the site.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '939',
  'location' => '/?q=fr/admin/settings/admin',
  'textgroup' => 'default',
  'source' => 'Use administration theme for content editing',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '940',
  'location' => '/?q=fr/admin/settings/admin',
  'textgroup' => 'default',
  'source' => 'Use the administration theme when editing existing posts or creating new ones.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '941',
  'location' => '/?q=fr/admin/settings/actions',
  'textgroup' => 'default',
  'source' => 'Publish comment',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '942',
  'location' => '/?q=fr/admin/settings/actions',
  'textgroup' => 'default',
  'source' => 'Unpublish comment',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '943',
  'location' => '/?q=fr/admin/settings/actions',
  'textgroup' => 'default',
  'source' => 'Unpublish comment containing keyword(s)',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '944',
  'location' => '/?q=fr/admin/settings/actions',
  'textgroup' => 'default',
  'source' => 'Publish post',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '945',
  'location' => '/?q=fr/admin/settings/actions',
  'textgroup' => 'default',
  'source' => 'Unpublish post',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '946',
  'location' => '/?q=fr/admin/settings/actions',
  'textgroup' => 'default',
  'source' => 'Make post sticky',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '947',
  'location' => '/?q=fr/admin/settings/actions',
  'textgroup' => 'default',
  'source' => 'Make post unsticky',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '948',
  'location' => '/?q=fr/admin/settings/actions',
  'textgroup' => 'default',
  'source' => 'Promote post to front page',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '949',
  'location' => '/?q=fr/admin/settings/actions',
  'textgroup' => 'default',
  'source' => 'Remove post from front page',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '950',
  'location' => '/?q=fr/admin/settings/actions',
  'textgroup' => 'default',
  'source' => 'Change the author of a post',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '951',
  'location' => '/?q=fr/admin/settings/actions',
  'textgroup' => 'default',
  'source' => 'Save post',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '952',
  'location' => '/?q=fr/admin/settings/actions',
  'textgroup' => 'default',
  'source' => 'Unpublish post containing keyword(s)',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '953',
  'location' => '/?q=fr/admin/settings/actions',
  'textgroup' => 'default',
  'source' => 'Display a message to the user',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '954',
  'location' => '/?q=fr/admin/settings/actions',
  'textgroup' => 'default',
  'source' => 'Send e-mail',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '955',
  'location' => '/?q=fr/admin/settings/actions',
  'textgroup' => 'default',
  'source' => 'Redirect to URL',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '956',
  'location' => '/?q=fr/admin/settings/actions',
  'textgroup' => 'default',
  'source' => 'Block current user',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '957',
  'location' => '/?q=fr/admin/settings/actions',
  'textgroup' => 'default',
  'source' => 'Ban IP address of current user',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '958',
  'location' => '/?q=fr/admin/settings/actions',
  'textgroup' => 'default',
  'source' => "ImageCache: Flush ALL presets for this node's filefield images",
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '959',
  'location' => '/?q=fr/admin/settings/actions',
  'textgroup' => 'default',
  'source' => "ImageCache: Generate ALL presets for this node's filefield images",
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '960',
  'location' => '/?q=fr/admin/settings/actions',
  'textgroup' => 'default',
  'source' => "ImageCache: Generate configured preset(s) for this node's filefield images",
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '961',
  'location' => '/?q=fr/admin/settings/actions',
  'textgroup' => 'default',
  'source' => 'Choose an advanced action',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '962',
  'location' => '/?q=fr/admin/settings/actions',
  'textgroup' => 'default',
  'source' => 'Action type',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '963',
  'location' => '/?q=fr/admin/settings/actions',
  'textgroup' => 'default',
  'source' => '« first',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '964',
  'location' => '/?q=fr/admin/settings/actions',
  'textgroup' => 'default',
  'source' => '‹ previous',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '965',
  'location' => '/?q=fr/admin/settings/actions',
  'textgroup' => 'default',
  'source' => 'next ›',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '966',
  'location' => '/?q=fr/admin/settings/actions',
  'textgroup' => 'default',
  'source' => 'last »',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '967',
  'location' => '/?q=fr/admin/settings/actions',
  'textgroup' => 'default',
  'source' => 'Actions available to Drupal:',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '968',
  'location' => '/?q=fr/admin/settings/actions',
  'textgroup' => 'default',
  'source' => 'sort by @s',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '969',
  'location' => '/?q=fr/admin/settings/actions',
  'textgroup' => 'default',
  'source' => 'sort icon',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '970',
  'location' => '/?q=fr/admin/settings/actions',
  'textgroup' => 'default',
  'source' => 'sort descending',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '971',
  'location' => '/?q=fr/admin/settings/actions',
  'textgroup' => 'default',
  'source' => 'Make a new advanced action available',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '972',
  'location' => '/?q=fr/admin/settings/actions',
  'textgroup' => 'default',
  'source' => 'Create',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '973',
  'location' => '/?q=fr/admin/settings/actions',
  'textgroup' => 'default',
  'source' => 'Configure an advanced action',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '974',
  'location' => '/?q=fr/admin/settings/actions',
  'textgroup' => 'default',
  'source' => 'Remove orphans',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '975',
  'location' => '/?q=fr/admin/settings/actions',
  'textgroup' => 'default',
  'source' => 'Manage actions',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '976',
  'location' => '/?q=fr/admin/settings/actions',
  'textgroup' => 'default',
  'source' => 'Actions are individual tasks that the system can do, such as unpublishing a piece of content or banning a user. Modules, such as the trigger module, can fire these actions when certain system events happen; for example, when a new post is added or when a user logs in. Modules may also provide additional actions.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '977',
  'location' => '/?q=fr/admin/settings/actions',
  'textgroup' => 'default',
  'source' => 'There are two types of actions: simple and advanced. Simple actions do not require any additional configuration, and are listed here automatically. Advanced actions can do more than simple actions; for example, send an e-mail to a specified address, or check for certain words within a piece of content. These actions need to be created and configured first before they may be used. To create an advanced action, select the action from the drop-down below and click the <em>Create</em> button.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '978',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'Create new account',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '979',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'role',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '980',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => '@module module',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '981',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'access news feeds',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '982',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'administer news feeds',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '983',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'administer blocks',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '984',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'use PHP for block visibility',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '985',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'access printer-friendly version',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '986',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'add content to books',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '987',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'administer book outlines',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '988',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'create new books',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '989',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'access comments',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '990',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'administer comments',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '991',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'post comments',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '992',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'post comments without approval',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '993',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'access site-wide contact form',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '994',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'administer site-wide contact form',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '995',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'administer filters',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '996',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'administer languages',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '997',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'translate interface',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '998',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'administer menu',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '999',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'access content',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1000',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'administer content types',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1001',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'administer nodes',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1002',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'create article content',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1003',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'create company content',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1004',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'create employee content',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1005',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'create sponsor content',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1006',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'create story content',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1007',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'create test_event content',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1008',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'create test_page content',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1009',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'create test_planet content',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1010',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'create test_story content',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1011',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'delete any article content',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1012',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'delete any company content',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1013',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'delete any employee content',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1014',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'delete any sponsor content',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1015',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'delete any story content',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1016',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'delete any test_event content',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1017',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'delete any test_page content',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1018',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'delete any test_planet content',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1019',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'delete any test_story content',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1020',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'delete own article content',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1021',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'delete own company content',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1022',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'delete own employee content',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1023',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'delete own sponsor content',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1024',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'delete own story content',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1025',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'delete own test_event content',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1026',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'delete own test_page content',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1027',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'delete own test_planet content',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1028',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'delete own test_story content',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1029',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'delete revisions',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1030',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'edit any article content',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1031',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'edit any company content',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1032',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'edit any employee content',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1033',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'edit any sponsor content',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1034',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'edit any story content',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1035',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'edit any test_event content',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1036',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'edit any test_page content',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1037',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'edit any test_planet content',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1038',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'edit any test_story content',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1039',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'edit own article content',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1040',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'edit own company content',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1041',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'edit own employee content',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1042',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'edit own sponsor content',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1043',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'edit own story content',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1044',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'edit own test_event content',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1045',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'edit own test_page content',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1046',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'edit own test_planet content',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1047',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'edit own test_story content',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1048',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'revert revisions',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1049',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'view revisions',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1050',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'administer url aliases',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1051',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'create url aliases',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1052',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'access administration pages',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1053',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'access site reports',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1054',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'administer actions',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1055',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'administer files',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1056',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'administer site configuration',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1057',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'select different theme',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1058',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'administer taxonomy',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1059',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'translate content',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1060',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'upload files',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1061',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'view uploaded files',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1062',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'access user profiles',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1063',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'administer permissions',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1064',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'administer users',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1065',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'change own username',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1066',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'view date repeats',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1067',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'administer imageapi',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1068',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'administer imagecache',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1069',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'flush imagecache',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1070',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'view imagecache big_blue_cheese',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1071',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'view imagecache slackjaw_boys',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1072',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'administer all languages',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1073',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'administer translations',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1074',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'permission',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1075',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'status',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1076',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'active',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1077',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'blocked',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1078',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'Show only users where',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1079',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'Filter',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1080',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'is',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1081',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'Username',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1082',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'Status',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1083',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'Member for',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1084',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'Last access',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1085',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'Update options',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1086',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'Unblock the selected users',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1087',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'Block the selected users',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1088',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'Delete the selected users',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1089',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'Add a role to the selected users',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1090',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'Remove a role from the selected users',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1091',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'Update',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1092',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => '@count years',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1093',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => '@count weeks',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1094',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => '@time ago',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1095',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => '@count sec',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1096',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'sort ascending',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1097',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'Add user',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1098',
  'location' => '/?q=fr/admin/user/user',
  'textgroup' => 'default',
  'source' => 'Drupal allows users to register, login, log out, maintain user profiles, etc. Users of the site may not use their own names to post content until they have signed up for a user account.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1099',
  'location' => '/?q=fr/admin/user/roles',
  'textgroup' => 'default',
  'source' => 'Add role',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1100',
  'location' => '/?q=fr/admin/user/roles',
  'textgroup' => 'default',
  'source' => 'edit permissions',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1101',
  'location' => '/?q=fr/admin/user/roles',
  'textgroup' => 'default',
  'source' => 'locked',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1102',
  'location' => '/?q=fr/admin/user/roles',
  'textgroup' => 'default',
  'source' => 'edit role',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1103',
  'location' => '/?q=fr/admin/user/roles',
  'textgroup' => 'default',
  'source' => 'Edit role',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1104',
  'location' => '/?q=fr/admin/user/roles',
  'textgroup' => 'default',
  'source' => "<p>Roles allow you to fine tune the security and administration of Drupal. A role defines a group of users that have certain privileges as defined in <a href=\"@permissions\">user permissions</a>. Examples of roles include: anonymous user, authenticated user, moderator, administrator and so on. In this area you will define the <em>role names</em> of the various roles. To delete a role choose \"edit\".</p><p>By default, Drupal comes with two user roles:</p>\n      <ul>\n      <li>Anonymous user: this role is used for users that don't have a user account or that are not authenticated.</li>\n      <li>Authenticated user: this role is automatically granted to all logged in users.</li>\n      </ul>",
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1105',
  'location' => '/?q=fr/admin/user/profile',
  'textgroup' => 'default',
  'source' => 'Add new field',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1106',
  'location' => '/?q=fr/admin/user/profile',
  'textgroup' => 'default',
  'source' => 'single-line textfield',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1107',
  'location' => '/?q=fr/admin/user/profile',
  'textgroup' => 'default',
  'source' => 'multi-line textfield',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1108',
  'location' => '/?q=fr/admin/user/profile',
  'textgroup' => 'default',
  'source' => 'checkbox',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1109',
  'location' => '/?q=fr/admin/user/profile',
  'textgroup' => 'default',
  'source' => 'list selection',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1110',
  'location' => '/?q=fr/admin/user/profile',
  'textgroup' => 'default',
  'source' => 'freeform list',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1111',
  'location' => '/?q=fr/admin/user/profile',
  'textgroup' => 'default',
  'source' => 'URL',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1112',
  'location' => '/?q=fr/admin/user/profile',
  'textgroup' => 'default',
  'source' => 'date',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1113',
  'location' => '/?q=fr/admin/user/profile',
  'textgroup' => 'default',
  'source' => 'No fields in this category. If this category remains empty when saved, it will be removed.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1114',
  'location' => '/?q=fr/admin/user/profile',
  'textgroup' => 'default',
  'source' => 'Title',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1115',
  'location' => '/?q=fr/admin/user/profile',
  'textgroup' => 'default',
  'source' => 'Category',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1116',
  'location' => '/?q=fr/admin/user/profile',
  'textgroup' => 'default',
  'source' => 'Delete field',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1117',
  'location' => '/?q=fr/admin/user/profile',
  'textgroup' => 'default',
  'source' => 'Edit field',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1118',
  'location' => '/?q=fr/admin/user/profile',
  'textgroup' => 'default',
  'source' => 'Profile category autocomplete',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1119',
  'location' => '/?q=fr/admin/user/profile',
  'textgroup' => 'default',
  'source' => "This page displays a list of the existing custom profile fields to be displayed on a user's <em>My Account</em> page. To provide structure, similar or related fields may be placed inside a category. To add a new category (or edit an existing one), edit a profile field and provide a new category name. To change the category of a field or the order of fields within a category, grab a drag-and-drop handle under the Title column and drag the field to a new location in the list. (Grab a handle by clicking and holding the mouse while hovering over a handle icon.) Remember that your changes will not be saved until you click the <em>Save configuration</em> button at the bottom of the page.",
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1120',
  'location' => '/?q=fr/admin/user/permissions',
  'textgroup' => 'default',
  'source' => 'Save permissions',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1121',
  'location' => '/?q=fr/admin/user/permissions',
  'textgroup' => 'default',
  'source' => 'Permission',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1122',
  'location' => '/?q=fr/admin/user/permissions',
  'textgroup' => 'default',
  'source' => 'Permissions let you control what users can do on your site. Each user role (defined on the <a href="@role">user roles page</a>) has its own set of permissions. For example, you could give users classified as "Administrators" permission to "administer nodes" but deny this power to ordinary, "authenticated" users. You can use permissions to reveal new features to privileged users (those with subscriptions, for example). Permissions also allow trusted users to share the administrative burden of running a busy site.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1123',
  'location' => '/?q=fr/admin/user/rules',
  'textgroup' => 'default',
  'source' => 'Access type',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1124',
  'location' => '/?q=fr/admin/user/rules',
  'textgroup' => 'default',
  'source' => 'Rule type',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1125',
  'location' => '/?q=fr/admin/user/rules',
  'textgroup' => 'default',
  'source' => 'Mask',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1126',
  'location' => '/?q=fr/admin/user/rules',
  'textgroup' => 'default',
  'source' => 'username',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1127',
  'location' => '/?q=fr/admin/user/rules',
  'textgroup' => 'default',
  'source' => 'e-mail',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1128',
  'location' => '/?q=fr/admin/user/rules',
  'textgroup' => 'default',
  'source' => 'host',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1129',
  'location' => '/?q=fr/admin/user/rules',
  'textgroup' => 'default',
  'source' => 'There are currently no access rules.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1130',
  'location' => '/?q=fr/admin/user/rules',
  'textgroup' => 'default',
  'source' => 'Delete rule',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1131',
  'location' => '/?q=fr/admin/user/rules',
  'textgroup' => 'default',
  'source' => 'Edit rule',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1132',
  'location' => '/?q=fr/admin/user/rules',
  'textgroup' => 'default',
  'source' => 'Add rule',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1133',
  'location' => '/?q=fr/admin/user/rules',
  'textgroup' => 'default',
  'source' => 'Check rules',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1134',
  'location' => '/?q=fr/admin/user/rules',
  'textgroup' => 'default',
  'source' => 'Set up username and e-mail address access rules for new <em>and</em> existing accounts (currently logged in accounts will not be logged out). If a username or e-mail address for an account matches any deny rule, but not an allow rule, then the account will not be allowed to be created or to log in. A host rule is effective for every page view, not just registrations.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1135',
  'location' => '/?q=fr/admin/user/profile/edit/11',
  'textgroup' => 'default',
  'source' => 'edit %title',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1136',
  'location' => '/?q=fr/admin/user/profile/edit/11',
  'textgroup' => 'default',
  'source' => 'Field settings',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1137',
  'location' => '/?q=fr/admin/user/profile/edit/11',
  'textgroup' => 'default',
  'source' => 'The category the new field should be part of. Categories are used to group fields logically. An example category is "Personal information".',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1138',
  'location' => '/?q=fr/admin/user/profile/edit/11',
  'textgroup' => 'default',
  'source' => 'The title of the new field. The title will be shown to the user. An example title is "Favorite color".',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1139',
  'location' => '/?q=fr/admin/user/profile/edit/11',
  'textgroup' => 'default',
  'source' => 'Form name',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1140',
  'location' => '/?q=fr/admin/user/profile/edit/11',
  'textgroup' => 'default',
  'source' => "The name of the field. The form name is not shown to the user but used internally in the HTML code and URLs.\nUnless you know what you are doing, it is highly recommended that you prefix the form name with <code>profile_</code> to avoid name clashes with other fields. Spaces or any other special characters except dash (-) and underscore (_) are not allowed. An example name is \"profile_favorite_color\" or perhaps just \"profile_color\".",
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1141',
  'location' => '/?q=fr/admin/user/profile/edit/11',
  'textgroup' => 'default',
  'source' => 'Explanation',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1142',
  'location' => '/?q=fr/admin/user/profile/edit/11',
  'textgroup' => 'default',
  'source' => 'An optional explanation to go with the new field. The explanation will be shown to the user.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1143',
  'location' => '/?q=fr/admin/user/profile/edit/11',
  'textgroup' => 'default',
  'source' => 'Selection options',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1144',
  'location' => '/?q=fr/admin/user/profile/edit/11',
  'textgroup' => 'default',
  'source' => 'A list of all options. Put each option on a separate line. Example options are "red", "blue", "green", etc.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1145',
  'location' => '/?q=fr/admin/user/profile/edit/11',
  'textgroup' => 'default',
  'source' => 'Visibility',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1146',
  'location' => '/?q=fr/admin/user/profile/edit/11',
  'textgroup' => 'default',
  'source' => 'Hidden profile field, only accessible by administrators, modules and themes.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1147',
  'location' => '/?q=fr/admin/user/profile/edit/11',
  'textgroup' => 'default',
  'source' => 'Private field, content only available to privileged users.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1148',
  'location' => '/?q=fr/admin/user/profile/edit/11',
  'textgroup' => 'default',
  'source' => 'Public field, content shown on profile page but not used on member list pages.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1149',
  'location' => '/?q=fr/admin/user/profile/edit/11',
  'textgroup' => 'default',
  'source' => 'Public field, content shown on profile page and on member list pages.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1150',
  'location' => '/?q=fr/admin/user/profile/edit/11',
  'textgroup' => 'default',
  'source' => 'Page title',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1151',
  'location' => '/?q=fr/admin/user/profile/edit/11',
  'textgroup' => 'default',
  'source' => 'To enable browsing this field by value, enter a title for the resulting page. The word <code>%value</code> will be substituted with the corresponding value. An example page title is "People whose favorite color is %value". This is only applicable for a public field.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1152',
  'location' => '/?q=fr/admin/user/profile/edit/11',
  'textgroup' => 'default',
  'source' => 'The weights define the order in which the form fields are shown. Lighter fields "float up" towards the top of the category.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1153',
  'location' => '/?q=fr/admin/user/profile/edit/11',
  'textgroup' => 'default',
  'source' => 'Form will auto-complete while user is typing.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1154',
  'location' => '/?q=fr/admin/user/profile/edit/11',
  'textgroup' => 'default',
  'source' => 'For security, auto-complete will be disabled if the user does not have access to user profiles.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1155',
  'location' => '/?q=fr/admin/user/profile/edit/11',
  'textgroup' => 'default',
  'source' => 'The user must enter a value.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1156',
  'location' => '/?q=fr/admin/user/profile/edit/11',
  'textgroup' => 'default',
  'source' => 'Visible in user registration form.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1157',
  'location' => '/?q=fr/admin/user/profile/edit/11',
  'textgroup' => 'default',
  'source' => 'Save field',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1158',
  'location' => '/?q=fr/admin/user/profile/edit/11',
  'textgroup' => 'default',
  'source' => 'The specified form name contains one or more illegal characters. Spaces or any other special characters except dash (-) and underscore (_) are not allowed.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1159',
  'location' => '/?q=fr/admin/settings/language/configure',
  'textgroup' => 'default',
  'source' => 'None.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1160',
  'location' => '/?q=fr/admin/settings/language/configure',
  'textgroup' => 'default',
  'source' => 'Path prefix only.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1161',
  'location' => '/?q=fr/admin/settings/language/configure',
  'textgroup' => 'default',
  'source' => 'Path prefix with language fallback.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1162',
  'location' => '/?q=fr/admin/settings/language/configure',
  'textgroup' => 'default',
  'source' => 'Domain name only.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1163',
  'location' => '/?q=fr/admin/settings/language/configure',
  'textgroup' => 'default',
  'source' => "Select the mechanism used to determine your site's presentation language. <strong>Modifying this setting may break all incoming URLs and should be used with caution in a production environment.</strong>",
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1164',
  'location' => '/?q=fr/admin/settings/language/configure',
  'textgroup' => 'default',
  'source' => 'Save settings',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1165',
  'location' => '/?q=fr/admin/settings/language/configure',
  'textgroup' => 'default',
  'source' => "Language negotiation settings determine the site's presentation language. Available options include:",
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1166',
  'location' => '/?q=fr/admin/settings/language/configure',
  'textgroup' => 'default',
  'source' => '<strong>None.</strong> The default language is used for site presentation, though users may (optionally) select a preferred language on the <em>My Account</em> page. (User language preferences will be used for site e-mails, if available.)',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1167',
  'location' => '/?q=fr/admin/settings/language/configure',
  'textgroup' => 'default',
  'source' => '<strong>Path prefix only.</strong> The presentation language is determined by examining the path for a language code or other custom string that matches the path prefix (if any) specified for each language. If a suitable prefix is not identified, the default language is used. <em>Example: "example.com/de/contact" sets presentation language to German based on the use of "de" within the path.</em>',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1168',
  'location' => '/?q=fr/admin/settings/language/configure',
  'textgroup' => 'default',
  'source' => "<strong>Path prefix with language fallback.</strong> The presentation language is determined by examining the path for a language code or other custom string that matches the path prefix (if any) specified for each language. If a suitable prefix is not identified, the display language is determined by the user's language preferences from the <em>My Account</em> page, or by the browser's language settings. If a presentation language cannot be determined, the default language is used.",
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1169',
  'location' => '/?q=fr/admin/settings/language/configure',
  'textgroup' => 'default',
  'source' => '<strong>Domain name only.</strong> The presentation language is determined by examining the domain used to access the site, and comparing it to the language domain (if any) specified for each language. If a match is not identified, the default language is used. <em>Example: "http://de.example.com/contact" sets presentation language to German based on the use of "http://de.example.com" in the domain.</em>',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1170',
  'location' => '/?q=fr/admin/settings/language/configure',
  'textgroup' => 'default',
  'source' => 'The path prefix or domain name for a language may be set by editing the <a href="@languages">available languages</a>. In the absence of an appropriate match, the site is displayed in the <a href="@languages">default language</a>.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1171',
  'location' => '/?q=fr/admin/settings/language/configure/strings',
  'textgroup' => 'default',
  'source' => 'Translatable input formats',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1172',
  'location' => '/?q=fr/admin/settings/language/configure/strings',
  'textgroup' => 'default',
  'source' => 'Only the strings that have the input formats selected will be allowed by the translation system. All the others will be deleted next time the strings are refreshed.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1173',
  'location' => '/?q=fr/admin/settings/language/configure/strings',
  'textgroup' => 'default',
  'source' => 'Built-in interface',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1174',
  'location' => '/?q=fr/admin/settings/language/configure/strings',
  'textgroup' => 'default',
  'source' => 'Blocks',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1175',
  'location' => '/?q=fr/admin/settings/language/configure/strings',
  'textgroup' => 'default',
  'source' => 'Menu',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1176',
  'location' => '/?q=fr/admin/settings/language/configure/strings',
  'textgroup' => 'default',
  'source' => 'Profile',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1177',
  'location' => '/?q=fr/admin/settings/language/configure/strings',
  'textgroup' => 'default',
  'source' => 'When translating user defined strings that have an Input format associated, translators will be able to edit the text before it is filtered which may be a security risk for some filters. An obvious example is when using the PHP filter but other filters may also be dangerous.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1178',
  'location' => '/?q=fr/admin/settings/language/configure/strings',
  'textgroup' => 'default',
  'source' => "As a general rule <strong>do not allow any filtered text to be translated unless the translators already have access to that Input format</strong>. However if you are doing all your translations through this site's translation UI or the Localization client, and never importing translations for other textgroups than <i>default</i>, filter access will be checked for translators on every translation page.",
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1179',
  'location' => '/?q=fr/admin/settings/language/configure/strings',
  'textgroup' => 'default',
  'source' => '<strong>Important:</strong> After disallowing some Input format, use the <a href="@refresh-strings">refresh strings</a> page so forbidden strings are deleted and not allowed anymore for translators.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1180',
  'location' => '/?q=fr/admin/settings/language/i18n',
  'textgroup' => 'default',
  'source' => 'Content selection',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1181',
  'location' => '/?q=fr/admin/settings/language/i18n',
  'textgroup' => 'default',
  'source' => 'Content selection mode',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1182',
  'location' => '/?q=fr/admin/settings/language/i18n',
  'textgroup' => 'default',
  'source' => 'Current language and language neutral.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1183',
  'location' => '/?q=fr/admin/settings/language/i18n',
  'textgroup' => 'default',
  'source' => 'Mixed current language (if available) or default language (if not) and language neutral.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1184',
  'location' => '/?q=fr/admin/settings/language/i18n',
  'textgroup' => 'default',
  'source' => 'Only default language and language neutral.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1185',
  'location' => '/?q=fr/admin/settings/language/i18n',
  'textgroup' => 'default',
  'source' => 'Only current language.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1186',
  'location' => '/?q=fr/admin/settings/language/i18n',
  'textgroup' => 'default',
  'source' => 'All content. No language conditions apply.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1187',
  'location' => '/?q=fr/admin/settings/language/i18n',
  'textgroup' => 'default',
  'source' => 'Determines which content to show depending on the current page language and the default language of the site.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1188',
  'location' => '/?q=fr/admin/settings/language/i18n',
  'textgroup' => 'default',
  'source' => 'Content translation links',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1189',
  'location' => '/?q=fr/admin/settings/language/i18n',
  'textgroup' => 'default',
  'source' => 'Hide content translation links',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1190',
  'location' => '/?q=fr/admin/settings/language/i18n',
  'textgroup' => 'default',
  'source' => 'Hide the links to translations in content body and teasers. If you choose this option, switching language will only be available from the language switcher block.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1191',
  'location' => '/?q=fr/admin/settings/language/i18n',
  'textgroup' => 'default',
  'source' => 'Switch interface for translating',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1192',
  'location' => '/?q=fr/admin/settings/language/i18n',
  'textgroup' => 'default',
  'source' => 'Switch interface language to fit node language when creating or editing a translation. If not checked the interface language will be independent from node language.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1193',
  'location' => '/?q=fr/admin/settings/language/i18n',
  'textgroup' => 'default',
  'source' => 'To set up multilingual options for vocabularies go to <a href="@configure_taxonomy">Taxonomy configuration page</a>.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1194',
  'location' => '/?q=fr/admin/settings/language/i18n',
  'textgroup' => 'default',
  'source' => 'To enable multilingual support for specific content types go to <a href="@configure_content_types">configure content types</a>.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1195',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => 'Drupal',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1196',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => 'Web server',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1197',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => 'PHP',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1198',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => 'PHP register globals',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1199',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => 'PHP memory limit',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1200',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => 'MySQL database',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1201',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => 'Protected',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1202',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => 'Configuration file',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1203',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => 'Files directory',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1204',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => 'Temporary files directory',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1205',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => 'Not fully protected',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1206',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => 'See <a href="@url">@url</a> for information about the recommended .htaccess file which should be added to the %directory directory to help protect against arbitrary code execution.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1207',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => 'For more information, see the online handbook entry for <a href="@cron-handbook">configuring cron jobs</a>.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1208',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => 'Never run',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1209',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => 'Cron has not run.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1210',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => 'Cron maintenance tasks',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1211',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => 'You can <a href="@cron">run cron manually</a>.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1212',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => 'Not writable',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1213',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => "You may need to set the correct directory at the <a href=\"@admin-file-system\">file system settings page</a> or change the current directory's permissions so that it is writable.",
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1214',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => 'Database updates',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1215',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => 'Up to date',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1216',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => 'Access to update.php',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1217',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => 'Standard PHP',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1218',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => 'PHP Mbstring Extension',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1219',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => 'Error',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1220',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => 'Unicode library',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1221',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => 'Not enabled',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1222',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => 'Update notifications are not enabled. It is <strong>highly recommended</strong> that you enable the update status module from the <a href="@module">module administration page</a> in order to stay up-to-date on new releases. For more information please read the <a href="@update">Update status handbook page</a>.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1223',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => 'Update notifications',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1224',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => 'set the site timezone name',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1225',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => 'The Date Timezone module requires you to !link.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1226',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => 'Date Timezone requirements',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1227',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => 'MySQL database for event module',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1228',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => 'Your server is capable of displaying file upload progress, but does not have the required libraries. It is recommended to install the <a href="http://pecl.php.net/package/uploadprogress">PECL uploadprogress library</a> (preferred) or to install <a href="http://us2.php.net/apc">APC</a>.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1229',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => 'Upload progress',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1230',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => 'ImageAPI Toolkit',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1231',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => 'No ImageAPI toolkits available',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1232',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => 'ImageAPI requires a Toolkit such as ImageAPI GD or ImageAPI ImageMagick to function. Go to !modules and enable one of them.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1233',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => 'ImageCache Directory',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1234',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => '%p is not a directory or is not readable by the webserver.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1235',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => 'One or more problems were detected with your Drupal installation. Check the <a href="@status">status report</a> for more information.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1236',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => 'Comments',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1237',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => 'List and edit site comments and the comment moderation queue.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1238',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => "View, edit, and delete your site's content.",
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1239',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => 'Manage posts by content type, including default status, front page promotion, etc.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1240',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => 'Post settings',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1241',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => 'Control posting behavior, such as teaser length, requiring previews before posting, and the number of posts on the front page.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1242',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => 'RSS publishing',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1243',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => 'Configure the number of items per feed and whether feeds should be titles/teasers/full-text.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1244',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => 'Manage tagging, categorization, and classification of your content.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1245',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => "Configure which content your site aggregates from other sites, how often it polls them, and how they're categorized.",
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1246',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => "Manage your site's book outlines.",
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1247',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => 'Status report',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1248',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => "Get a status report about your site's operation and any detected problems.",
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1249',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => "Configure what block content appears in your site's sidebars and other regions.",
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1250',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => 'Contact form',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1251',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => 'Create a system contact form and set up categories for the form to use.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1252',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => 'Menus',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1253',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => "Control your site's navigation menu, primary links and secondary links, as well as rename and reorganize menu items.",
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1254',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => 'Modules',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1255',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => 'Enable or disable add-on modules for your site.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1256',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => 'Themes',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1257',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => 'Change which theme your site uses or allows users to set.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1258',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => 'URL aliases',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1259',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => "Change your site's URL paths by aliasing them.",
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1260',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => 'Translate interface',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1261',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => 'Translate the built in interface and optionally other text.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1262',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => 'Hide descriptions',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1263',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => 'Compress layout by hiding descriptions.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1264',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => 'By task',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1265',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => 'By module',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1266',
  'location' => '/?q=fr/admin',
  'textgroup' => 'default',
  'source' => 'Welcome to the administration section. Here you may control how your site functions.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1267',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Configure permissions',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1268',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Store a date in the database as an ISO date, recommended for historical or partial dates.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1269',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Store a date in the database as a timestamp, deprecated format to suppport legacy data.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1270',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Store a date in the database as a datetime field, recommended for complete dates and times that may need timezone conversion.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1271',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'File',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1272',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Store an arbitrary file.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1273',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Link',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1274',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Store a title, href, and attributes in the database to assemble a link.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1275',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Phone Numbers - France',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1276',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Phone Numbers - Belgium',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1277',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Phone Numbers - Italy',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1278',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Phone Numbers - Greece',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1279',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Phone Numbers - Switzerland',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1280',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Phone Numbers - US & Canada',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1281',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Phone Numbers - Costa Rica',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1282',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Phone Numbers - Panama',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1283',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Phone Numbers - Great Britain - United Kingdom',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1284',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Phone Numbers - Russia',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1285',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Phone Numbers - Ukraine - in Kiev',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1286',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Phone Numbers - Spain',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1287',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Phone Numbers - Australia',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1288',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Phone Numbers - Czech Republic',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1289',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Phone Numbers - Hungary',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1290',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Phone Numbers - Poland - mobiles only',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1291',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Phone Numbers - Netherland',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1292',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Phone Numbers - Sweden',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1293',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Phone Numbers - South Africa',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1294',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Phone Numbers - Israel',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1295',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Phone Numbers - New Zealand',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1296',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Phone Numbers - Brazil',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1297',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Phone Numbers - Chile',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1298',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Phone Numbers - China',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1299',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Phone Numbers - Hong-Kong',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1300',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Phone Numbers - Macao',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1301',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Phone Numbers - The Philippines',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1302',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Phone Numbers - Singapore',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1303',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Phone Numbers - Jordan',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1304',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Phone Numbers - Egypt',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1305',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Phone Numbers - Pakistan',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1306',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Phone Numbers - International Phone Numbers per E.123',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1307',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Select List',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1308',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Select List with Repeat options',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1309',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Text Field with custom input format',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1310',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Text Field with Repeat options',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1311',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'As Time Ago',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1312',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Default email link',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1313',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Email contact form',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1314',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Email plain text',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1315',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'File Upload',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1316',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'A plain file upload widget.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1317',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Generic files',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1318',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Displays all kinds of files with an icon and a linked file description.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1319',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Path to file',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1320',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Displays the file system path to the file.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1321',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'URL to file',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1322',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Displays a full URL to the file.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1323',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => '@preset image',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1324',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => '@preset image linked to node',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1325',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => '@preset image linked to image',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1326',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => '@preset file path',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1327',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => '@preset URL',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1328',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Image',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1329',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'An edit widget for image files, including a preview of the image.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1330',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Displays image files in their original size.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1331',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Image linked to node',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1332',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Image linked to file',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1333',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Title, as link (default)',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1334',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Title, as plain text',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1335',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'URL, as link',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1336',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'URL, as plain text',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1337',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'URL, as absolute URL',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1338',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Short, as link with title "Link"',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1339',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Label, as link with label as title',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1340',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Separate title and URL',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1341',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Textfield',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1342',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Revision information',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1343',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Authoring information',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1344',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Publishing options',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1345',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Comment settings',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1346',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Comment module form.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1347',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Translation settings',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1348',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Translation module form.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1349',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Path settings',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1350',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Path module form.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1351',
  'location' => 'content.module:1897;1900,  fuzzy',
  'textgroup' => 'default',
  'source' => 'Print',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1352',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Account settings',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1353',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Aggregates syndicated content (RSS, RDF, and Atom feeds).',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1354',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Controls the boxes that are displayed around the main content.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1355',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Allows users to structure site pages in a hierarchy or outline.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1356',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Allows users to comment on and discuss published content.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1357',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Enables the use of both personal and site-wide contact forms.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1358',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Defines CCK date/time fields and widgets.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1359',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Defines an email field type for cck',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1360',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Calendaring API, calendar display and export',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1361',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Handles the filtering of content in preparation for display.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1362',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Extends Drupal support for multilingual features.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1363',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'ImageAPI supporting multiple toolkits.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1364',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Dynamic image manipulator and cache.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1365',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Adds language handling functionality and enables the translation of the user interface to languages other than English.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1366',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Allows administrators to customize the site navigation menu.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1367',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Allows content to be submitted to the site and displayed on pages.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1368',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Allows users to rename URLs.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1369',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Supports configurable user profiles.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1370',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Handles general site configuration for administrators.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1371',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Enables the categorization of content.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1372',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Allows content to be translated into different languages.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1373',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Allows users to upload and attach files to content.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1374',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Manages the user registration and login system.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1375',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'Variable API - Admin UI',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1376',
  'location' => '/?q=fr/admin/by-module',
  'textgroup' => 'default',
  'source' => 'This page shows you all available administration tasks for each module.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1377',
  'location' => 'field.php:102 number.module:82 text.module:80',
  'textgroup' => 'default',
  'source' => 'is equal to',
  'version' => 'none',
))
->values(array(
  'lid' => '1378',
  'location' => 'field.php:103 number.module:83 text.module:81',
  'textgroup' => 'default',
  'source' => 'is not equal to',
  'version' => 'none',
))
->values(array(
  'lid' => '1379',
  'location' => 'field.php:104 text.module:82',
  'textgroup' => 'default',
  'source' => 'matches the pattern',
  'version' => 'none',
))
->values(array(
  'lid' => '1380',
  'location' => 'content_admin.inc:25 content.module:119',
  'textgroup' => 'default',
  'source' => 'duplicate',
  'version' => 'none',
))
->values(array(
  'lid' => '1381',
  'location' => 'number.module:52,  text.module:55',
  'textgroup' => 'default',
  'source' => 'The possible values this field can contain. Any other values will result in an error. Enter one value per line.',
  'version' => 'none',
))
->values(array(
  'lid' => '1382',
  'location' => 'content.module:73',
  'textgroup' => 'default',
  'source' => 'add content type',
  'version' => 'none',
))
->values(array(
  'lid' => '1383',
  'location' => 'content.module:80',
  'textgroup' => 'default',
  'source' => 'fields',
  'version' => 'none',
))
->values(array(
  'lid' => '1384',
  'location' => 'content.module:164',
  'textgroup' => 'default',
  'source' => 'remove field',
  'version' => 'none',
))
->values(array(
  'lid' => '1385',
  'location' => 'nodereference.module:15',
  'textgroup' => 'default',
  'source' => 'Defines a field type for referencing one node from another. <em>Note: Requires content.module.</em>',
  'version' => 'none',
))
->values(array(
  'lid' => '1386',
  'location' => 'nodereference.module:26',
  'textgroup' => 'default',
  'source' => 'node reference autocomplete',
  'version' => 'none',
))
->values(array(
  'lid' => '1387',
  'location' => 'nodereference.module:204',
  'textgroup' => 'default',
  'source' => 'No post with that title exists.',
  'version' => 'none',
))
->values(array(
  'lid' => '1388',
  'location' => 'number.module:15',
  'textgroup' => 'default',
  'source' => 'Defines numeric field types. <em>Note: Requires content.module.</em>',
  'version' => 'none',
))
->values(array(
  'lid' => '1389',
  'location' => 'optionwidgets.module:15',
  'textgroup' => 'default',
  'source' => 'Defines selection, check box and radio button widgets for text and numeric fields. <em>Note: Requires content.module, text.module and number.module.</em>',
  'version' => 'none',
))
->values(array(
  'lid' => '1390',
  'location' => 'text.module:15',
  'textgroup' => 'default',
  'source' => 'Defines simple text field types. <em>Note: Requires content.module.</em>',
  'version' => 'none',
))
->values(array(
  'lid' => '1391',
  'location' => 'userreference.module:15',
  'textgroup' => 'default',
  'source' => 'Defines a field type for referencing a user from a node. <em>Note: Requires content.module.</em>',
  'version' => 'none',
))
->values(array(
  'lid' => '1392',
  'location' => 'userreference.module:176',
  'textgroup' => 'default',
  'source' => 'Invalid user name.',
  'version' => 'none',
))
->values(array(
  'lid' => '1393',
  'location' => 'weburl.module:15',
  'textgroup' => 'default',
  'source' => 'Defines simple weburl field types. <em>Note: Requires content.module.</em>',
  'version' => 'none',
))
->values(array(
  'lid' => '1394',
  'location' => 'weburl.module:164;172',
  'textgroup' => 'default',
  'source' => 'Not a valid Web URL.',
  'version' => 'none',
))
->values(array(
  'lid' => '1395',
  'location' => 'weburl.module:0',
  'textgroup' => 'default',
  'source' => 'weburl',
  'version' => 'none',
))
->values(array(
  'lid' => '1396',
  'location' => 'content_admin.inc:90',
  'textgroup' => 'default',
  'source' => 'The human-readable name of this content type.',
  'version' => 'none',
))
->values(array(
  'lid' => '1397',
  'location' => 'content_admin.inc:98',
  'textgroup' => 'default',
  'source' => 'A brief description of the content type.',
  'version' => 'none',
))
->values(array(
  'lid' => '1398',
  'location' => 'content_admin.inc:106',
  'textgroup' => 'default',
  'source' => 'Instructions to present to the user when adding new content of this type.',
  'version' => 'none',
))
->values(array(
  'lid' => '1399',
  'location' => 'content_admin.inc:110',
  'textgroup' => 'default',
  'source' => 'Title field label',
  'version' => 'none',
))
->values(array(
  'lid' => '1400',
  'location' => 'content_admin.inc:113',
  'textgroup' => 'default',
  'source' => 'The label for the title field.',
  'version' => 'none',
))
->values(array(
  'lid' => '1401',
  'location' => 'content_admin.inc:118',
  'textgroup' => 'default',
  'source' => 'Save content type',
  'version' => 'none',
))
->values(array(
  'lid' => '1402',
  'location' => 'content_admin.inc:182',
  'textgroup' => 'default',
  'source' => 'Saved content type %type.',
  'version' => 'none',
))
->values(array(
  'lid' => '1403',
  'location' => 'content_admin.inc:198',
  'textgroup' => 'default',
  'source' => 'Are you sure you want to delete the content type %type?',
  'version' => 'none',
))
->values(array(
  'lid' => '1404',
  'location' => 'content_admin.inc:198',
  'textgroup' => 'default',
  'source' => 'If you have any content left in this content type, it will be permanently deleted. This action cannot be undone.',
  'version' => 'none',
))
->values(array(
  'lid' => '1405',
  'location' => 'content_admin.inc:220',
  'textgroup' => 'default',
  'source' => 'Deleted content type %type.',
  'version' => 'none',
))
->values(array(
  'lid' => '1406',
  'location' => 'content_admin.inc:251',
  'textgroup' => 'default',
  'source' => 'remove',
  'version' => 'none',
))
->values(array(
  'lid' => '1407',
  'location' => 'content_admin.inc:313',
  'textgroup' => 'default',
  'source' => 'The human-readable name of this field.',
  'version' => 'none',
))
->values(array(
  'lid' => '1408',
  'location' => 'content_admin.inc:326',
  'textgroup' => 'default',
  'source' => 'Create field',
  'version' => 'none',
))
->values(array(
  'lid' => '1409',
  'location' => 'content_admin.inc:335',
  'textgroup' => 'default',
  'source' => 'No field modules are enabled. You need to <a href="%modules_url">enable one</a>, such as text.module, before you can add new fields.',
  'version' => 'none',
))
->values(array(
  'lid' => '1410',
  'location' => 'content_admin.inc:487',
  'textgroup' => 'default',
  'source' => 'The field %field no longer exists in any content type, so it was deleted.',
  'version' => 'none',
))
->values(array(
  'lid' => '1411',
  'location' => 'content_admin.inc:522',
  'textgroup' => 'default',
  'source' => 'Widget settings',
  'version' => 'none',
))
->values(array(
  'lid' => '1412',
  'location' => 'content_admin.inc:526',
  'textgroup' => 'default',
  'source' => 'Widget',
  'version' => 'none',
))
->values(array(
  'lid' => '1413',
  'location' => 'content_admin.inc:541',
  'textgroup' => 'default',
  'source' => 'In the node editing form, the heavier fields will sink and the lighter fields will be positioned nearer the top.',
  'version' => 'none',
))
->values(array(
  'lid' => '1414',
  'location' => 'content_admin.inc:552',
  'textgroup' => 'default',
  'source' => 'Instructions to present to the user below this field on the editing form.',
  'version' => 'none',
))
->values(array(
  'lid' => '1415',
  'location' => 'content_admin.inc:569',
  'textgroup' => 'default',
  'source' => 'Data settings',
  'version' => 'none',
))
->values(array(
  'lid' => '1416',
  'location' => 'content_admin.inc:579',
  'textgroup' => 'default',
  'source' => 'Multiple values',
  'version' => 'none',
))
->values(array(
  'lid' => '1417',
  'location' => 'content_admin.inc:652',
  'textgroup' => 'default',
  'source' => 'Saved field %field.',
  'version' => 'none',
))
->values(array(
  'lid' => '1418',
  'location' => 'content_admin.inc:882;971',
  'textgroup' => 'default',
  'source' => 'No PostgreSQL mapping found for %type data type.',
  'version' => 'none',
))
->values(array(
  'lid' => '1419',
  'location' => 'content_admin.inc:896;985',
  'textgroup' => 'default',
  'source' => 'database',
  'version' => 'none',
))
->values(array(
  'lid' => '1420',
  'location' => 'date.module:15',
  'textgroup' => 'default',
  'source' => 'Defines a date/time field type. <em>Note: Requires content.module.</em>',
  'version' => 'none',
))
->values(array(
  'lid' => '1421',
  'location' => 'date.module:36',
  'textgroup' => 'default',
  'source' => 'Year',
  'version' => 'none',
))
->values(array(
  'lid' => '1422',
  'location' => 'date.module:37',
  'textgroup' => 'default',
  'source' => 'Year and month',
  'version' => 'none',
))
->values(array(
  'lid' => '1423',
  'location' => 'date.module:40',
  'textgroup' => 'default',
  'source' => 'Time only',
  'version' => 'none',
))
->values(array(
  'lid' => '1424',
  'location' => 'date.module:44',
  'textgroup' => 'default',
  'source' => 'Granularity',
  'version' => 'none',
))
->values(array(
  'lid' => '1425',
  'location' => 'date.module:102',
  'textgroup' => 'default',
  'source' => "Times are entered and displayed with site's time zone",
  'version' => 'none',
))
->values(array(
  'lid' => '1426',
  'location' => 'date.module:103',
  'textgroup' => 'default',
  'source' => "Times are entered and displayed with user's time zone",
  'version' => 'none',
))
->values(array(
  'lid' => '1427',
  'location' => 'date.module:107',
  'textgroup' => 'default',
  'source' => 'Time zone handling',
  'version' => 'none',
))
->values(array(
  'lid' => '1428',
  'location' => 'date.module:153',
  'textgroup' => 'default',
  'source' => '%name must be entered in ISO 8601 format (YYYYMMDDThh:mm:ss).',
  'version' => 'none',
))
->values(array(
  'lid' => '1429',
  'location' => 'content.module:61',
  'textgroup' => 'default',
  'source' => 'content types',
  'version' => 'none',
))
->values(array(
  'lid' => '1430',
  'location' => 'content.module:67',
  'textgroup' => 'default',
  'source' => 'list',
  'version' => 'none',
))
->values(array(
  'lid' => '1431',
  'location' => 'modules/optionwidgets/optionwidgets.module:326',
  'textgroup' => 'default',
  'source' => '%name: this field cannot hold more than @count values.',
  'version' => 'none',
))
->values(array(
  'lid' => '1432',
  'location' => 'includes/panels/content_types/content_field.inc:37',
  'textgroup' => 'default',
  'source' => '@type: (@field_type) @field',
  'version' => 'none',
))
->values(array(
  'lid' => '1433',
  'location' => 'includes/panels/content_types/content_field.inc:44',
  'textgroup' => 'default',
  'source' => 'Field on the referenced node.',
  'version' => 'none',
))
->values(array(
  'lid' => '1434',
  'location' => 'includes/panels/content_types/content_field.inc:128',
  'textgroup' => 'default',
  'source' => 'Formatter',
  'version' => 'none',
))
->values(array(
  'lid' => '1435',
  'location' => 'includes/panels/content_types/content_field.inc:131',
  'textgroup' => 'default',
  'source' => 'Select a formatter.',
  'version' => 'none',
))
->values(array(
  'lid' => '1436',
  'location' => 'includes/panels/content_types/content_field.inc:147',
  'textgroup' => 'default',
  'source' => '"@s" field (@name)',
  'version' => 'none',
))
->values(array(
  'lid' => '1437',
  'location' => '/?q=zu/admin/settingsjhkjg',
  'textgroup' => 'default',
  'source' => 'Page not found',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1438',
  'location' => '/?q=zu/admin/settingsjhkjg',
  'textgroup' => 'default',
  'source' => 'The requested page could not be found.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1439',
  'location' => '/?q=zu/admin/build/translate',
  'textgroup' => 'default',
  'source' => 'English (built-in)',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1440',
  'location' => '/?q=zu/admin/build/translate',
  'textgroup' => 'default',
  'source' => 'n/a',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1441',
  'location' => '/?q=zu/admin/build/translate',
  'textgroup' => 'default',
  'source' => 'Zulu',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1442',
  'location' => '/?q=zu/admin/build/translate',
  'textgroup' => 'default',
  'source' => 'Overview',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1443',
  'location' => '/?q=zu/admin/build/translate',
  'textgroup' => 'default',
  'source' => 'Refresh',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1444',
  'location' => '/?q=zu/admin/build/translate',
  'textgroup' => 'default',
  'source' => 'This page provides an overview of available translatable strings. Drupal displays translatable strings in text groups; modules may define additional text groups containing other translatable strings. Because text groups provide a method of grouping related strings, they are often used to focus translation efforts on specific areas of the Drupal interface.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1445',
  'location' => '/?q=zu/admin/build/translate',
  'textgroup' => 'default',
  'source' => 'Review the <a href="@languages">languages page</a> for more information on adding support for additional languages.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1446',
  'location' => '/?q=zu/admin/build/translate/search',
  'textgroup' => 'default',
  'source' => 'English',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1447',
  'location' => '/?q=zu/admin/build/translate/search',
  'textgroup' => 'default',
  'source' => 'String contains',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1448',
  'location' => '/?q=zu/admin/build/translate/search',
  'textgroup' => 'default',
  'source' => 'Leave blank to show all strings. The search is case sensitive.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1449',
  'location' => '/?q=zu/admin/build/translate/search',
  'textgroup' => 'default',
  'source' => 'All languages',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1450',
  'location' => '/?q=zu/admin/build/translate/search',
  'textgroup' => 'default',
  'source' => 'English (provided by Drupal)',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1451',
  'location' => '/?q=zu/admin/build/translate/search',
  'textgroup' => 'default',
  'source' => 'Search in',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1452',
  'location' => '/?q=zu/admin/build/translate/search',
  'textgroup' => 'default',
  'source' => 'Both translated and untranslated strings',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1453',
  'location' => '/?q=zu/admin/build/translate/search',
  'textgroup' => 'default',
  'source' => 'Only translated strings',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1454',
  'location' => '/?q=zu/admin/build/translate/search',
  'textgroup' => 'default',
  'source' => 'Only untranslated strings',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1455',
  'location' => '/?q=zu/admin/build/translate/search',
  'textgroup' => 'default',
  'source' => 'Limit search to',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1456',
  'location' => '/?q=zu/admin/build/translate/search',
  'textgroup' => 'default',
  'source' => 'All text groups',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1457',
  'location' => '/?q=zu/admin/build/translate/search',
  'textgroup' => 'default',
  'source' => 'This page allows a translator to search for specific translated and untranslated strings, and is used when creating or editing translations. (Note: For translation tasks involving many strings, it may be more convenient to <a href="@export">export</a> strings for off-line editing in a desktop Gettext translation editor.) Searches may be limited to strings found within a specific text group or in a specific language.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1458',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Already added languages',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1459',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Languages not yet added',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1460',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Afar',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1461',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Abkhazian',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1462',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Avestan',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1463',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Afrikaans',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1464',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Akan',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1465',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Amharic',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1466',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Arabic',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1467',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Assamese',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1468',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Avar',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1469',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Aymara',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1470',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Azerbaijani',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1471',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Bashkir',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1472',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Belarusian',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1473',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Bulgarian',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1474',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Bihari',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1475',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Bislama',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1476',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Bambara',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1477',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Bengali',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1478',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Tibetan',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1479',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Breton',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1480',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Bosnian',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1481',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Catalan',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1482',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Chechen',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1483',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Chamorro',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1484',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Corsican',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1485',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Cree',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1486',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Czech',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1487',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Old Slavonic',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1488',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Chuvash',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1489',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Welsh',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1490',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Danish',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1491',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'German',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1492',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Maldivian',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1493',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Bhutani',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1494',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Ewe',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1495',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Greek',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1496',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Esperanto',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1497',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Spanish',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1498',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Estonian',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1499',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Basque',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1500',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Persian',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1501',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Fulah',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1502',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Finnish',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1503',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Fiji',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1504',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Faeroese',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1505',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Frisian',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1506',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Irish',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1507',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Scots Gaelic',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1508',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Galician',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1509',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Guarani',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1510',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Gujarati',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1511',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Manx',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1512',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Hausa',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1513',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Hebrew',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1514',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Hindi',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1515',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Hiri Motu',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1516',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Croatian',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1517',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Hungarian',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1518',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Armenian',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1519',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Herero',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1520',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Interlingua',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1521',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Indonesian',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1522',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Interlingue',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1523',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Igbo',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1524',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Inupiak',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1525',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Icelandic',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1526',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Italian',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1527',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Inuktitut',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1528',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Japanese',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1529',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Javanese',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1530',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Georgian',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1531',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Kongo',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1532',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Kikuyu',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1533',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Kwanyama',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1534',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Kazakh',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1535',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Greenlandic',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1536',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Cambodian',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1537',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Kannada',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1538',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Korean',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1539',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Kanuri',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1540',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Kashmiri',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1541',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Kurdish',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1542',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Komi',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1543',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Cornish',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1544',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Kirghiz',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1545',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Latin',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1546',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Luxembourgish',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1547',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Luganda',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1548',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Lingala',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1549',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Laothian',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1550',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Lithuanian',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1551',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Latvian',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1552',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Malagasy',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1553',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Marshallese',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1554',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Maori',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1555',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Macedonian',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1556',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Malayalam',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1557',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Mongolian',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1558',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Moldavian',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1559',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Marathi',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1560',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Malay',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1561',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Maltese',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1562',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Burmese',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1563',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Nauru',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1564',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'North Ndebele',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1565',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Nepali',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1566',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Ndonga',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1567',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Dutch',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1568',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Norwegian Bokmål',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1569',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Norwegian Nynorsk',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1570',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'South Ndebele',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1571',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Navajo',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1572',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Chichewa',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1573',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Occitan',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1574',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Oromo',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1575',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Oriya',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1576',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Ossetian',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1577',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Punjabi',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1578',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Pali',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1579',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Polish',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1580',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Pashto',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1581',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Portuguese, Portugal',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1582',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Portuguese, Brazil',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1583',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Quechua',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1584',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Rhaeto-Romance',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1585',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Kirundi',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1586',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Romanian',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1587',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Russian',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1588',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Kinyarwanda',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1589',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Sanskrit',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1590',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Sardinian',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1591',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Sindhi',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1592',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Northern Sami',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1593',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Sango',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1594',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Serbo-Croatian',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1595',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Sinhala',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1596',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Slovak',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1597',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Slovenian',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1598',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Samoan',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1599',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Shona',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1600',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Somali',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1601',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Albanian',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1602',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Serbian',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1603',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Siswati',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1604',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Sesotho',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1605',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Sudanese',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1606',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Swedish',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1607',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Swahili',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1608',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Tamil',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1609',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Telugu',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1610',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Tajik',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1611',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Thai',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1612',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Tigrinya',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1613',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Turkmen',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1614',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Tagalog',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1615',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Setswana',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1616',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Tonga',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1617',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Turkish',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1618',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Tsonga',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1619',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Tatar',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1620',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Twi',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1621',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Tahitian',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1622',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Uighur',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1623',
  'location' => '/?q=zu/admin/build/translate/refresh',
  'textgroup' => 'default',
  'source' => 'Select text groups',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1624',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Ukrainian',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1625',
  'location' => '/?q=zu/admin/build/translate/refresh',
  'textgroup' => 'default',
  'source' => 'If a text group is no showing up here it means this feature is not implemented for it.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1626',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Urdu',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1627',
  'location' => '/?q=zu/admin/build/translate/refresh',
  'textgroup' => 'default',
  'source' => 'Refresh strings',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1628',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Uzbek',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1629',
  'location' => '/?q=zu/admin/build/translate/refresh',
  'textgroup' => 'default',
  'source' => 'This will create all the missing strings for the selected text groups.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1630',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Venda',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1631',
  'location' => '/?q=zu/admin/build/translate/refresh',
  'textgroup' => 'default',
  'source' => 'Select languages',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1632',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Vietnamese',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1633',
  'location' => '/?q=zu/admin/build/translate/refresh',
  'textgroup' => 'default',
  'source' => 'Update translations',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1634',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Wolof',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1635',
  'location' => '/?q=zu/admin/build/translate/refresh',
  'textgroup' => 'default',
  'source' => 'This will fetch all existing translations from the localization tables for the selected text groups and languages.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1636',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Xhosa',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1637',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Yiddish',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1638',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Yoruba',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1639',
  'location' => '/?q=zu/admin/build/translate/refresh',
  'textgroup' => 'default',
  'source' => 'On this page you can refresh and update values for user defined strings.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1640',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Zhuang',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1641',
  'location' => '/?q=zu/admin/build/translate/refresh',
  'textgroup' => 'default',
  'source' => 'Use the refresh option when you are missing strings to translate for a given text group. All the strings will be re-created keeping existing translations.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1642',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Chinese, Simplified',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1643',
  'location' => '/?q=zu/admin/build/translate/refresh',
  'textgroup' => 'default',
  'source' => 'Use the update option when some of the strings had been previously translated with the localization system, but the translations are not showing up for the configurable strings.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1644',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Chinese, Traditional',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1645',
  'location' => '/?q=zu/admin/build/translate/refresh',
  'textgroup' => 'default',
  'source' => 'To search and translate strings, use the <a href="@translate-interface">translation interface</a> pages.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1646',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Import translation',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1647',
  'location' => '/?q=zu/admin/build/translate/refresh',
  'textgroup' => 'default',
  'source' => '<strong>Important:</strong> To configure which Input formats are safe for translation, visit the <a href="@configure-strings">configure strings</a> page before refreshing your strings.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1648',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Language file',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1649',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'A Gettext Portable Object (<em>.po</em>) file.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1650',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Import into',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1651',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Choose the language you want to add strings into. If you choose a language which is not yet set up, it will be added.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1652',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Text group',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1653',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Imported translations will be added to this text group.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1654',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Mode',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1655',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Strings in the uploaded file replace existing ones, new ones are added',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1656',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Existing strings are kept, only new strings are added',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1657',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'This page imports the translated strings contained in an individual Gettext Portable Object (<em>.po</em>) file. Normally distributed as part of a translation package (each translation package may contain several <em>.po</em> files), a <em>.po</em> file may need to be imported after off-line editing in a Gettext translation editor. Importing an individual <em>.po</em> file may be a lengthy process.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1658',
  'location' => '/?q=zu/admin/build/translate/import',
  'textgroup' => 'default',
  'source' => 'Note that the <em>.po</em> files within a translation package are imported automatically (if available) when new modules or themes are enabled, or as new languages are added. Since this page only allows the import of one <em>.po</em> file at a time, it may be simpler to download and extract a translation package into your Drupal installation directory and <a href="@language-add">add the language</a> (which automatically imports all <em>.po</em> files within the package). Translation packages are available for download on the <a href="@translations">Drupal translation page</a>.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1659',
  'location' => '/?q=zu/admin/settings/language/i18n/variables',
  'textgroup' => 'default',
  'source' => 'Variable name',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1660',
  'location' => '/?q=zu/admin/settings/language/i18n/variables',
  'textgroup' => 'default',
  'source' => 'Is multilingual',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1661',
  'location' => '/?q=zu/admin/settings/language/i18n/variables',
  'textgroup' => 'default',
  'source' => 'Has translations',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1662',
  'location' => '/?q=zu/admin/settings/language/i18n/variables',
  'textgroup' => 'default',
  'source' => 'Delete all existing translations for variables.',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1663',
  'location' => '/?q=zu/admin/settings/language/i18n/variables',
  'textgroup' => 'default',
  'source' => 'Delete all translations',
  'version' => '6.38-dev',
))
->values(array(
  'lid' => '1664',
  'location' => 'type:forum:name',
  'textgroup' => 'nodetype',
  'source' => 'Forum topic',
  'version' => '1',
))
->values(array(
  'lid' => '1665',
  'location' => 'type:forum:title',
  'textgroup' => 'nodetype',
  'source' => 'Subject',
  'version' => '1',
))
->values(array(
  'lid' => '1666',
  'location' => 'type:forum:body',
  'textgroup' => 'nodetype',
  'source' => 'Body',
  'version' => '1',
))
->values(array(
  'lid' => '1667',
  'location' => 'type:forum:description',
  'textgroup' => 'nodetype',
  'source' => 'A <em>forum topic</em> is the initial post to a new discussion thread within a forum.',
  'version' => '1',
))
->values(array(
  'lid' => '1668',
  'location' => 'modules/block/block.js',
  'textgroup' => 'default',
  'source' => 'The changes to these blocks will not be saved until the <em>Save blocks</em> button is clicked.',
  'version' => 'none',
))
->values(array(
  'lid' => '1669',
  'location' => 'modules/nodereference/nodereference.module:117',
  'textgroup' => 'default',
  'source' => "Choose the \"Views module\" view that selects the nodes that can be referenced.<br />Note:<ul><li>Only views that have fields will work for this purpose.</li><li>This will discard the \"Content types\" settings above. Use the view's \"filters\" section instead.</li><li>Use the view's \"fields\" section to display additional informations about candidate nodes on node creation/edition form.</li><li>Use the view's \"sort criteria\" section to determine the order in which candidate nodes will be displayed.</li></ul>",
  'version' => 'none',
))
->values(array(
  'lid' => '1670',
  'location' => 'modules/nodereference/nodereference.module:175',
  'textgroup' => 'default',
  'source' => "%name: This post can't be referenced.",
  'version' => 'none',
))
->values(array(
  'lid' => '1671',
  'location' => 'modules/nodereference/nodereference.module:518',
  'textgroup' => 'default',
  'source' => '%name: Title mismatch. Please check your selection.',
  'version' => 'none',
))
->values(array(
  'lid' => '1672',
  'location' => 'vocabulary:6:name',
  'textgroup' => 'taxonomy',
  'source' => 'Type',
  'version' => '1',
))
->values(array(
  'lid' => '1673',
  'location' => 'vocabulary:7:name',
  'textgroup' => 'taxonomy',
  'source' => 'Forums',
  'version' => '1',
))
->values(array(
  'lid' => '1674',
  'location' => 'item:463:title',
  'textgroup' => 'menu',
  'source' => 'fr - Test 1',
  'version' => '1',
))
->values(array(
  'lid' => '1675',
  'location' => 'item:463:description',
  'textgroup' => 'menu',
  'source' => 'fr - Test menu link 1',
  'version' => '1',
))
->values(array(
  'lid' => '1676',
  'location' => 'item:138:title',
  'textgroup' => 'menu',
  'source' => 'Test 1',
  'version' => '1',
))
->values(array(
  'lid' => '1677',
  'location' => 'item:138:description',
  'textgroup' => 'menu',
  'source' => 'Test menu link 1',
  'version' => '1',
))
->values(array(
  'lid' => '1678',
  'location' => 'field:profile_really_really_love_migrating:title',
  'textgroup' => 'profile',
  'source' => 'I really, really, really love migrating',
  'version' => '1',
))
->values(array(
  'lid' => '1679',
  'location' => 'menu:menu-translation-test:title',
  'textgroup' => 'menu',
  'source' => 'Translation test',
  'version' => '1',
))
->values(array(
  'lid' => '1680',
  'location' => 'field:employee-field_company:widget_label',
  'textgroup' => 'cck',
  'source' => 'Company',
  'version' => '1',
))
->values(array(
  'lid' => '1681',
  'location' => 'field:employee-field_commander:widget_label',
  'textgroup' => 'cck',
  'source' => 'Commanding Officer',
  'version' => '1',
))
->values(array(
  'lid' => '1682',
  'location' => 'field:employee-field_company_2:widget_label',
  'textgroup' => 'cck',
  'source' => 'Company 2',
  'version' => '1',
))
->values(array(
  'lid' => '1683',
  'location' => 'field:employee-field_company_3:widget_label',
  'textgroup' => 'cck',
  'source' => 'Company 3',
  'version' => '1',
))
->values(array(
  'lid' => '1684',
  'location' => 'field:page-field_reference:widget_label',
  'textgroup' => 'cck',
  'source' => 'Reference',
  'version' => '1',
))
->values(array(
  'lid' => '1685',
  'location' => 'field:page-field_reference_2:widget_label',
  'textgroup' => 'cck',
  'source' => 'Reference',
  'version' => '1',
))
->values(array(
  'lid' => '1686',
  'location' => 'field:story-field_test_string_selectlist:widget_label',
  'textgroup' => 'cck',
  'source' => 'String Select List Field',
  'version' => '1',
))
->values(array(
  'lid' => '1689',
  'location' => 'field:test_planet-field_test_text_single_checkbox:widget_label',
  'textgroup' => 'cck',
  'source' => 'Text Single Checkbox Field',
  'version' => '1',
))
->values(array(
  'lid' => '1690',
  'location' => 'field:field_test_string_selectlist:option_A',
  'textgroup' => 'cck',
  'source' => 'Black',
  'version' => '1',
))
->values(array(
  'lid' => '1691',
  'location' => 'field:field_test_string_selectlist:option_B',
  'textgroup' => 'cck',
  'source' => 'White',
  'version' => '1',
))
->values(array(
  'lid' => '1692',
  'location' => 'term:14:name',
  'textgroup' => 'taxonomy',
  'source' => 'Talos IV',
  'version' => '1',
))
->values(array(
  'lid' => '1693',
  'location' => 'term:15:name',
  'textgroup' => 'taxonomy',
  'source' => 'Vulcan',
  'version' => '1',
))
->values(array(
  'lid' => '1694',
  'location' => 'term:14:description',
  'textgroup' => 'taxonomy',
  'source' => 'The home of Captain Christopher Pike.',
  'version' => '1',
))
->values(array(
  'lid' => '1695',
  'location' => 'field:profile_:title',
  'textgroup' => 'profile',
  'source' => 'Number of trees',
  'version' => '1',
))
->values(array(
  'lid' => '1696',
  'location' => 'field:profile_:options',
  'textgroup' => 'profile',
  'source' => "10\r\n20\r\n50\r\n100\r\n1000",
  'version' => '1',
))
->execute();
$connection->schema()->createTable('locales_target', array(
  'fields' => array(
    'lid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'translation' => array(
      'type' => 'blob',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'language' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
      'default' => '',
    ),
    'plid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'plural' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'i18n_status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'language',
    'lid',
    'plural',
  ),
  'indexes' => array(
    'lid' => array(
      'lid',
    ),
    'plid' => array(
      'plid',
    ),
    'plural' => array(
      'plural',
    ),
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('locales_target')
->fields(array(
  'lid',
  'translation',
  'language',
  'plid',
  'plural',
  'i18n_status',
))
->values(array(
  'lid' => '5',
  'translation' => "Le module Content, composant obligatoire du kit CCK (Content Construction Kit) permet aux administrateurs d'associer des champs personnalisés à des types de contenus. Au sein de Drupal, les types de contenus servent à définir les caractéristiques d'une publication, y compris le titre et la description des champs affichés sur ses pages \"ajouter\" et \"éditer\". Le module Content (et les modules auxiliaires inclus dans CCK) permet d'ajouter des champs personnalisés en plus des champs par défaut \"Titre\" et \"Corps\". Les fonctionnalités de CCK sont accessible via différents onglets sur la <a href=\"@content-types\">page d'administration des types de contenus</a>. (Voir la <a href=\"@node-help\">page d'aide du module Node</a> pour plus d'informations sur les types de contenus).",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '6',
  'translation' => "Lorsque vous ajoutez un champ personnalisé à un type de contenu, vous déterminez son type (c'est-à-dire s'il doit contenir du texte, des nombres ou des références à d'autres objets) et la façon dont il doit être affiché (en tant que champ ou zone de texte, liste de sélection, case à cocher, bouton radio, ou champ à auto-complètement). Un champ peut présenter plusieurs valeurs (par exemple, une \"personne\" peut disposer de plusieurs adresses courriel) ou une seule (par exemple, un \"employé\" possède un numéro d'identification unique). À mesure que vous ajoutez et modifiez des champs, CCK ajuste automatiquement la structure de la base de données en fonction. CCK propose également un certain nombre d'autres fonctionnalités, par exemple un cache intelligent pour vos données personnalisées, des fonctionnalités d'import et d'export pour les définitions de types de contenus, ainsi qu'une intégration à d'autres modules provenant des contributions.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '7',
  'translation' => "Des types de champs personnalisés sont proposés par plusieurs modules optionnels inclus dans CCK (chaque module fournissant un type différent). La <a href=\"@modules\">page des modules</a> vous permet d'activer ou de désactiver des composants CCK. Une installation par défaut de CCK inclut :",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '8',
  'translation' => "<em>Number</em>, qui ajoute des types de champs numériques (formats entier, décimal ou réel à virgule flottante). Vous pouvez définir un jeu ou un intervalle de valeurs autorisées. Divers formats sont disponibles pour l'affichage des données numériques.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '9',
  'translation' => "<em>Text</em>, qui ajoute des types de champs de texte. Un champ texte peut contenir du texte brut uniquement ou, optionnellement, utiliser les filtres des formats d'entrée que propose Drupal pour gérer en toute sécurité des textes enrichis. Les champs de saisie de texte peuvent être constitués d'une seule ligne (champ texte), de plusieurs lignes (zone de texte) ou, pour un meilleur contrôle des valeurs saisies, une liste de sélection, des cases à cocher ou des boutons radio. Si besoin, CCK peut valider les saisies sur la base d'un ensemble de valeurs autorisées.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '10',
  'translation' => '<em>Node Reference</em>, qui crée des références personnalisées entre nœuds de Drupal. En ajoutant, par exemple, un champ <em>nodereference</em> et deux types de contenus différents, vous pouvez facilement créer des relations complexes de type parent/enfant entre données (par exemple plusieurs nœuds "employé" peuvent présenter un champ <em>nodereference</em> pointant vers un même nœud "employeur").',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '11',
  'translation' => "<em>User reference</em>, qui crée des références personnalisées vers les comptes des utilisateurs de votre site. En ajoutant un champ <em>userreference</em>, vous pouvez créer des relations complexes entre les utilisateurs de votre site et des publications. Ainsi, pour tracer l'implication d'un utilisateur dans une publication (au delà du champ Drupal standard <em>Écrit par</em>), vous pouvez ajouter à un type de contenu un champ <em>userreference</em> intitulé \"Édité par\" pour enregistrer un lien vers la page du compte utilisateur ayant édité la publication.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '12',
  'translation' => "<em>Fieldgroup</em>, qui crée des groupes de champs liés. Les groupe de champ peuvent être repliés, et vous pouvez choisir qu'ils soient dépliés ou repliés par défaut. L'ordre des groupes de champs, ainsi que l'ordre des champs au sein d'un groupe, est géré grâce à l'interface par glisser-déposer fournie par le module Content.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '13',
  'translation' => "Pour plus d'informations, reportez-vous à l'entrée de manuel en ligne relative à <a href=\"@handbook-cck\">CCK</a> ou à la <a href=\"@project-cck\">page du projet CCK</a>.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '14',
  'translation' => 'Configurez ici la manière dont les champs et étiquettes de champs de ce type de contenu doivent être affichées, lorsque le contenu est vu en mode résumé ou en pleine page.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '15',
  'translation' => "Configurez ici la façon dont les champs de ce type de contenu doivent être affichés lorsqu'il est rendu dans les contextes suivants.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '16',
  'translation' => "Contrôlez ici l'ordre des champs dans le formulaire de saisie.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '17',
  'translation' => 'Ce champ est obligatoire.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '18',
  'translation' => '!title : !required',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '19',
  'translation' => 'Ordre',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '20',
  'translation' => 'Élément de flux RSS',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '21',
  'translation' => 'Index de recherche',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '22',
  'translation' => 'Résultat de recherche',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '23',
  'translation' => 'Langue',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '24',
  'translation' => 'Taxonomie',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '25',
  'translation' => 'Fichiers attachés',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '26',
  'translation' => 'Mise à jour du type de champ %type avec le module %module.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '27',
  'translation' => 'Mise à jour du type de widget %widget avec le module %module.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '28',
  'translation' => "Utiliser du code PHP pour le paramétrage des champs (dangereux - à n'autoriser qu'avec précautions)",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '29',
  'translation' => 'Gérer les champs',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '30',
  'translation' => 'Afficher les champs',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '31',
  'translation' => 'Général',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '32',
  'translation' => 'Avancé',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '33',
  'translation' => 'Supprimer un champ',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '34',
  'translation' => 'Content',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '35',
  'translation' => 'Permet aux administrateurs de définir des nouveaux types de contenu.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '36',
  'translation' => 'CCK',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '37',
  'translation' => 'Texte',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '38',
  'translation' => "Les valeurs possibles pour ce champ. Saisissez une valeur par ligne, sous la forme <em>clé|libellé</em>. La clé est la valeur enregistrée dans la base de données, et elle doit correspondre au type de stockage du champ, %type. Le libellé est optionnel et, s'il n'est pas spécifié, la clé sera utilisée comme libellé.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '39',
  'translation' => 'Zone de texte',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '40',
  'translation' => 'Ôter',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '41',
  'translation' => 'Basique',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '42',
  'translation' => 'Résumé',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '43',
  'translation' => 'Nœud complet',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '44',
  'translation' => 'RSS',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '45',
  'translation' => 'Recherche',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '46',
  'translation' => 'Formulaire du module node.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '47',
  'translation' => 'Formulaire du module locale.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '48',
  'translation' => 'Paramètres du menu',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '49',
  'translation' => 'Formulaire du module menu.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '50',
  'translation' => 'Formulaire du module taxonomy.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '51',
  'translation' => 'Livre',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '52',
  'translation' => 'Formulaire du module livre (book).',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '53',
  'translation' => 'Titre du sondage',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '54',
  'translation' => 'Titre du module sondage (Poll)',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '55',
  'translation' => 'Choix du sondage',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '56',
  'translation' => 'Choix du module sondage (poll).',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '57',
  'translation' => 'Paramètrage du sondage',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '58',
  'translation' => 'Paramètres du module sondage (poll).',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '59',
  'translation' => 'Formulaire du module upload.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '60',
  'translation' => 'contenu',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '61',
  'translation' => 'Champs',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '62',
  'translation' => "Les mises à jour des modules liés à CCK ne sont pas exécutées tant que les modules ne sont pas activés sur la  <a href=\"@admin-modules-path\">page d'administration des modules</a>. Lorsque vous les activerez, vous devrez retourner sur la page <a href=\"@update-php\">update.php</a> et exécuter les mises à jour restantes.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '63',
  'translation' => "!module.module possède des mises à jour mais ne peut pas être mis à jour car content.module n'est pas activé.<br /> Le cas échéant, lors de l'activation de content.module, vous devrez exécuter à nouveau le script de mise à jour. Vous continuerez à voir ce message jusqu'à ce que le module soit activé et les mises à jour exécutées.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '64',
  'translation' => "!module.module possède des mises à jour et est disponible dans le répertoire des modules, mais n'est pas activé.<br /> Le cas échéant, lorsque vous l'aurez activé, vous devrez ré-exécuter le script de mise à jour. Vous continuerez à voir ce message jusqu'à l'activation du module et l'exécution des mises à jour. ",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '65',
  'translation' => 'Des mises à jour sont toujours en attente. Veuillez retourner sur <a href="@update-php">update.php</a> et exécuter les mises à jour restarntes.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '66',
  'translation' => 'CCK - Aucune Intégration aux Vues',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '67',
  'translation' => 'L"intégration de CCK avec le module Views requiert Views 6.x-2.0-rc2 ou une version supérieure.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '68',
  'translation' => 'Nom',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '69',
  'translation' => 'Type',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '70',
  'translation' => 'Description',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '71',
  'translation' => 'Opérations',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '72',
  'translation' => 'éditer',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '73',
  'translation' => 'gérer les champs',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '74',
  'translation' => 'supprimer',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '75',
  'translation' => 'Aucun type de contenu disponible.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '76',
  'translation' => '» Ajouter un nouveau type de contenu',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '77',
  'translation' => 'Nom du champ',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '78',
  'translation' => 'Type de champ',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '79',
  'translation' => 'Utilisé dans',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '80',
  'translation' => '@field_name (Verrouillé)',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '81',
  'translation' => "Aucun champ n'est pour l'instant défini sur l'ensemble des types de contenu.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '82',
  'translation' => "Ce type de contenu possède des champs inactifs. Les champs inactifs ne sont pas inclus dans la liste de champs disponibles, jusqu'à l'activation des modules correspondants.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '83',
  'translation' => '!field (!field_name) est un champ inactif de type !field_type, qui utilise un widget de type !widget_type.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '84',
  'translation' => 'Configurer',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '85',
  'translation' => 'Verrouillé',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '86',
  'translation' => '- Sélectionnez un type de champ -',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '87',
  'translation' => '- Sélectionnez un widget -',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '88',
  'translation' => 'Étiquette',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '89',
  'translation' => 'Nom du champ (a-z, 0-9, _)',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '90',
  'translation' => 'Type de données à stocker.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '91',
  'translation' => "Elément du formulaire pour l'édition des données.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '92',
  'translation' => '- Sélectionnez un champ existant -',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '93',
  'translation' => 'Champ à partager',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '94',
  'translation' => 'Nom du groupe (a-z, 0-9, _)',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '95',
  'translation' => 'Enregistrer',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '96',
  'translation' => 'Ajouter un nouveau champ : vous devez fournir une étiquette.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '97',
  'translation' => 'Ajouter un nouveau champ : vous devez fournir un nom de champ.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '98',
  'translation' => "Ajouter un nouveau champ : le nom de champ %field_name n'est pas valide. Le nom doit seulement contenir des lettre minuscules non accentuées, des nombres, et des underscores. ",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '99',
  'translation' => "Ajouter un nouveau champ : le nom de champ %field_name est trop long. Le nom est limité à 32 caractères, en comptant le préfixe 'field_'.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '100',
  'translation' => "Ajouter un nouveau champ : le nom 'field_instance' est un nom réservé.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '101',
  'translation' => 'Ajouter un nouveau champ : le nom du champ %field_name existe déjà.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '102',
  'translation' => 'Ajouter un nouveau champ : vous devez sélectionner un type de champ.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '103',
  'translation' => 'Ajouter un nouveau champ : vous devez sélectionner un widget.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '104',
  'translation' => 'Ajouter un nouveau champ : widget non valide.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '105',
  'translation' => 'Ajouter un champ existant : vous devez fournir une étiquette.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '106',
  'translation' => 'Ajouter un champ existant : vous devez sélectionner un champ.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '107',
  'translation' => 'Ajouter un champ existant: vous devez sélectionner un widget.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '108',
  'translation' => 'Ajouter un champ existant : widget non valide.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '109',
  'translation' => "Un problème est survenu à la création du champ '%label'.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '110',
  'translation' => "Le champ %label n'a pas pu être ajouté au type de contenu car il est verrouillé.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '111',
  'translation' => "Un problème est survenu lors de l'ajout du champ '%label'.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '112',
  'translation' => "Il n'y a aucun champ configuré pour ce type de contenu. Vous pouvez ajouter de nouveaux champs sur la page <a href=\"@link\">Gérer les champs</a>.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '113',
  'translation' => 'Au dessus',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '114',
  'translation' => 'Sur la même ligne',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '115',
  'translation' => 'Inclure',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '116',
  'translation' => 'Exclure',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '117',
  'translation' => 'aucune mise en forme',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '118',
  'translation' => 'simple',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '119',
  'translation' => 'groupe de champs',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '120',
  'translation' => 'groupe de champs - repliable',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '121',
  'translation' => 'groupe de champs - replié',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '122',
  'translation' => 'Vos paramètres ont été enregistrés.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '123',
  'translation' => '@type : @field (@label)',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '124',
  'translation' => 'Éditer les informations de base',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '125',
  'translation' => 'Le nom lisible par une machine du champ. Ce nom ne peut être changé.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '126',
  'translation' => "Nom lisible par une personne, destiné à servir d'étiquette pour ce champ au sein du type de contenu '%type'.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '127',
  'translation' => 'Type de données que vous souhaitez enregistrer, par le biais de ce champ, dans la base de données. Cette option ne peut être modifiée.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '128',
  'translation' => 'Type de widget',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '129',
  'translation' => "Type d'élément de formulaire que vous souhaitez présenter à l'utilisateur lorsqu'il renseigne ce champ dans le type de contenu '%type'.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '130',
  'translation' => 'Continuer',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '131',
  'translation' => 'Les paramètres basiques du champ %label ont été mis à jour.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '132',
  'translation' => 'Un problème a été rencontré lors de la mise à jour des paramètres basiques du champ %label.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '133',
  'translation' => "Êtes-vous certain de vouloir enlever le champ '%field' ?",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '134',
  'translation' => 'Si vous avez encore du contenu dans ce champ, il sera perdu. Cette action est irréversible.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '135',
  'translation' => 'Annuler',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '136',
  'translation' => 'Ce champ est <strong>verrouillé</strong> et ne peut être supprimé.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '137',
  'translation' => "Le champ '%field' de '%type' a été enlevé.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '138',
  'translation' => "Un problème est survenu à la suppression du champ '%field' du type '%type'.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '139',
  'translation' => 'Le champ %field est verouillé et ne peut être édité.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '140',
  'translation' => "Informations de base pour '%type'",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '141',
  'translation' => 'Modifier les informations de base',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '142',
  'translation' => "Paramètres de '%type'",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '143',
  'translation' => "Ces paramètres ne s'applique qu'au champ '%field' tel qu'il apparaît dans le type contenu '%type'.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '144',
  'translation' => "Texte d'aide",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '145',
  'translation' => "Instructions à présenter à l'utilisateur sous ce champ, dans le formulaire d'édition.<br />Balises HTML autorisées : @tags",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '146',
  'translation' => 'Valeur par défaut',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '147',
  'translation' => 'Code PHP',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '148',
  'translation' => "'@column' => valeur de @column",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '149',
  'translation' => "return array(\n  0 => array(@columns),\n  // Vous voudrez vous arrêter là dans la plupart des cas. Fournir plus de valeurs\n  // si vous souhaitez que votre 'valeur par défaut' ait des valeurs multiples :\n  1 => array(@columns),\n  2 => ...\n);",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '150',
  'translation' => 'Code',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '151',
  'translation' => "Usage avancé seulement : code PHP retournant une valeur par défaut. Ne doit pas contenir les délimiteurs &lt;?php ?&gt;. Si ce champ est rempli, la valeur retournée par ce code écrasera toute valeur spécifiée ci-dessus. Format attendu : <pre>!sample</pre>. Pour vous faire une idée du format attendu, vous pouvez utiliser l'onglet <em>devel load</em> fourni par <a href=\"@link_devel\">le module devel</a> sur une page de contenu de type  %type.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '152',
  'translation' => '&lt;aucun&gt;',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '153',
  'translation' => "Vous n'êtes pas autorisé à saisir du code PHP.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '154',
  'translation' => 'Ce code PHP a été inséré par un administrateur et supplantera toute valeur spécifiée ci-dessus.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '155',
  'translation' => 'Paramètres globaux',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '156',
  'translation' => "Ces paramètres s'appliquent au champ '%field' dans tous les types de contenu où il apparaît.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '157',
  'translation' => 'Obligatoire',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '158',
  'translation' => "Le nombre maximum de valeurs qu'un utilisateur peut entrer pour ce champ.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '159',
  'translation' => "'Illimité' fournira un bouton 'Ajouter plus' pour que les utilisateurs puissent ajouter autant de valeurs qu'ils le souhaitent.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '160',
  'translation' => 'Attention ! Changer ce paramètre alors que des données ont déjà été créées peut conduire à perdre des données !',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '161',
  'translation' => 'Nombre de valeurs',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '162',
  'translation' => 'Illimité',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '163',
  'translation' => 'Enregistrer les paramètres du champ',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '164',
  'translation' => "Le code PHP pour la 'valeur par défaut' a retourné @value, qui n'est pas valide.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '165',
  'translation' => 'La valeur par défaut est invalide.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '166',
  'translation' => "Le champ '%label' a été ajouté.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '167',
  'translation' => "Champ '%label' enregistré.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '168',
  'translation' => 'Exécution',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '169',
  'translation' => 'La mise à jour a échoué.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '170',
  'translation' => 'La base de données a été modifiée et des données ont été déplacées ou supprimées.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '171',
  'translation' => 'Une erreur est survenue et a interrompu la modification de la base de données.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '172',
  'translation' => "'%title' en cours de traitement",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '173',
  'translation' => '%name doit être un entier.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '174',
  'translation' => '%name doit être un entier positif.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '175',
  'translation' => '%name doit être un nombre.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '176',
  'translation' => '1 élément traité avec succès&nbsp:',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '177',
  'translation' => '@count éléments traités avec succès&nbsp:',
  'language' => 'fr',
  'plid' => '176',
  'plural' => '1',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '178',
  'translation' => "La table de champs a été renommée de '%old_name' à '%new_name' et les instances des champs ont été mises à jour.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '179',
  'translation' => "La table de champs '%name' a été supprimée.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '180',
  'translation' => 'Ajouter un autre élément',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '181',
  'translation' => 'Contenu du champ',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '182',
  'translation' => 'Un champ de contenu du node référencé.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '183',
  'translation' => 'Noeud',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '184',
  'translation' => 'Contexte du noeud',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '185',
  'translation' => 'Titre du bloc',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '186',
  'translation' => 'Caché',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '187',
  'translation' => "Configurer la manière dont l'étiquette est affichée.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '188',
  'translation' => 'Champ / Formateur',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '189',
  'translation' => 'Sélectionner un champ et un formateur.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '190',
  'translation' => '"@s" champ @name',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '191',
  'translation' => 'Remplir un champ',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '192',
  'translation' => 'Vous devez vous assurer que le champ existe pour le type de contenu donné.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '193',
  'translation' => 'Champ',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '194',
  'translation' => 'Sélectionnez le nom-machine du champ.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '195',
  'translation' => 'Avancé : Préciser les valeurs des champs avec du code PHP',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '196',
  'translation' => "Usage avancé seulement : code PHP retournant la valeur à définir. Ne doit pas contenir les délimiteurs &lt;?php ?&gt;. Si ce champ est rempli, la valeur retournée par ce code écrasera toute valeur spécifiée ci-dessus. Format attendu : <pre>!sample</pre>. Pour vous faire une idée du format attendu, vous pouvez utiliser l'onglet <em>devel load</em> fourni par <a href=\"@link_devel\">le module devel</a> sur une page de contenu de type  %type.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '197',
  'translation' => 'Vous devez retourner la valeur par défaut dans le format attendu.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '198',
  'translation' => "Remplir le champ '@field' de @node",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '199',
  'translation' => 'Le champ possède une valeur',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '200',
  'translation' => 'Vous devez vous assurer que le champ utilisé existe dans le type de contenu donné. La condition retourne TRUE, si le champ sélectionné possède la valeur donnée.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '201',
  'translation' => 'Le champ a été modifié',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '202',
  'translation' => 'Contenu contenant des modifications',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '203',
  'translation' => 'Contenu ne contenant pas de modification',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '204',
  'translation' => "Le champ '@field' de @node possède une valeur",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '205',
  'translation' => 'Sélectionnez le nom-machine du champ à voir.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '206',
  'translation' => "Le champ '@field' de @node a été modifié",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '207',
  'translation' => 'Jeton (Token)',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '208',
  'translation' => 'Identifiant du nœud référencé',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '209',
  'translation' => 'Titre du nœud référencé',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '210',
  'translation' => 'Titre non filtré du noeud référencé. ATTENTION - saisie brute utilisateur.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '211',
  'translation' => 'Lien html formaté vers le noeud référencé.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '212',
  'translation' => 'Alias de chemin relatif vers le noeud référencé.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '213',
  'translation' => 'Alias de chemin absolu vers le noeud référencé.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '214',
  'translation' => 'Valeur numérique brute',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '215',
  'translation' => 'Valeur numérique mise en forme',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '216',
  'translation' => 'Texte brut, non filtré',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '217',
  'translation' => 'Texte filtré et mis en forme',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '218',
  'translation' => "Identifiant de l'utilisateur référencé",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '219',
  'translation' => "Nom de l'utilisateur référencé",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '220',
  'translation' => "Lien HTML mis en forme vers l'utilisateur référencé",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '221',
  'translation' => "Alias de chemin relatif vers l'utilisateur référencé.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '222',
  'translation' => "Alias de chemin absolu vers l'utilisateur référencé.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '223',
  'translation' => '@label (!name)',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '224',
  'translation' => '@label (!name) - !column',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '225',
  'translation' => '@label-truncated - !column',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '226',
  'translation' => 'Apparaît dans : @types',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '227',
  'translation' => 'Aucun',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '228',
  'translation' => 'Étiquette du widget (@label)',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '229',
  'translation' => 'Personnalisé',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '230',
  'translation' => 'Étiquette personnalisée',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '231',
  'translation' => 'Format',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '232',
  'translation' => 'Grouper plusieurs valeurs',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '233',
  'translation' => "Si non coché, chaque élément du champ créera une nouvelle ligne, ce qui pourrait apparemment entraîner des doublons. Ce paramètre n'est pas compatible avec le tri par clic dans l'affichage du tableau. ",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '234',
  'translation' => 'Afficher @count valeur(s)',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '235',
  'translation' => 'en commençant à @count',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '236',
  'translation' => 'Inversé (commencer à partir des dernières valeurs)',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '237',
  'translation' => 'Tous / Toutes',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '238',
  'translation' => 'Delta',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '239',
  'translation' => "Le delta vous permet de sélectionner quel élément d'un champ à valeur multiple sera la clé de la relation. Sélectionnez \"1\" pour utiliser le premier élément, \"2\" pour le second et ainsi de suite. Si vous sélectionnez \"Tous\", chaque élément du champ créera une nouvelle ligne, ce qui pourrait causer des doublons.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '240',
  'translation' => "Le delta vous permet de sélectionner quel élément d'un champ à valeur multiple sera utilisé pour les tris. Sélectionnez \"1\" pour utiliser le premier élément, \"2\" pour le second et ainsi de suite. Si vous sélectionnez \"Tous\", chaque élément du champ créera une nouvelle ligne, ce qui pourrait causer des doublons.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '241',
  'translation' => 'Exporter',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '242',
  'translation' => "Ce formulaire traitera un type de contenu et un ou plusieurs champs de ce type, pour en exporter les paramètres. Le code d'export ainsi généré peut être copié et collé dans la page d'import, vers la base de données courante ou vers une autre base de données. L'opération d'import ajoutera les champs à un type de contenu existant ou créera un nouveau type de contenu intégrant les champs sélectionnés.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '243',
  'translation' => 'Types',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '244',
  'translation' => 'Sélectionner le type de contenu à exporter.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '245',
  'translation' => 'Données exportée',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '246',
  'translation' => "Copiez le texte exporté et collez-le dans le type de contenu de votre choix, à l'aide de la fonction d'import.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '247',
  'translation' => 'Types de contenu',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '248',
  'translation' => 'Type de contenu',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '249',
  'translation' => 'Séléctionnez le type de contenu dans lequel importer ces champs.<br />Sélectionnez &lt;Créer&gt; pour créer un nouveau type de contenu qui contiendra ces champs.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '250',
  'translation' => 'Données à importer',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '251',
  'translation' => 'Collez dans ce champ le texte créé par un export de contenu.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '252',
  'translation' => 'Importer',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '253',
  'translation' => "Un fichier a été préchargé pour l'import.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '254',
  'translation' => "Les données d'import ne sont valides.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '255',
  'translation' => "Les modules suivants doivent être activés pour que l'import fonctionne : '%modules'.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '256',
  'translation' => "Le type de contenu '%type' existe déjà dans cette base de données.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '257',
  'translation' => "Abandon. L'import n'a pas été réalisé.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '258',
  'translation' => "Une erreur s'est produite lors de l'ajout du nouveau type de contenu %type.<br> Veuillez vérifier les erreurs affichées pour plus de détails.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '259',
  'translation' => "Le champ importé '%field_label' (%field_name) n'a pas été ajouté à '%type' car ce champ existe déjà.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '260',
  'translation' => "Le champ importé '%field_label' (%field_name) a été ajouté au type de contenu '%type'.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '261',
  'translation' => 'content_copy',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '262',
  'translation' => 'Content Copy',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '263',
  'translation' => "Permet d'importer et d'exporter des définitions de champs.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '264',
  'translation' => "Les champs d'un groupe Standard sont indépendants les uns des autres, et chacun peut soit avoir une valeur unique, soit des valeurs multiples. Les champs d'un Multigroupe sont traités comme une ensemble répétable de champs à valeurs uniques.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '265',
  'translation' => 'Multigroupe',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '266',
  'translation' => 'Standard',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '267',
  'translation' => 'Type de groupe.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '268',
  'translation' => "Le champ %field a été mis à jour pour l'utilisation de valeurs %multiple, afin de correspondre au paramètre de valeur multipe du Multigroup %group.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '269',
  'translation' => "Cette modification n'est pas autorisée. Le champ %field possède déjà des valeurs multiples dans la base de données, mais le groupe %group en autorise seulement %group_max. Effectuer cette modification pourrait entraîner la perte de données. ",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '270',
  'translation' => "Cette modification n'est pas autorisée. Le champ %field manipule les valeurs multiples différemment du module Content. Effectuer cette modification pourrait entraîner la perte de données. ",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '271',
  'translation' => "Vous êtes en train d'inclure le champ %field dans un Multigroupe",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '272',
  'translation' => "Cette modification n'est pas autorisée. Le champ %field possède déjà des données créées, et utilise un widget qui stocke les données différemment dans un groupe Standard que dans un Multigroupe. Effectuer ce changement pourrait entraîner la perte de données.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '273',
  'translation' => "Vous êtes en train de retirer le champ %field d'un Multigroupe",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '274',
  'translation' => 'Simple',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '275',
  'translation' => 'Groupe de champs',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '276',
  'translation' => 'Ligne horizontale',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '277',
  'translation' => 'Tableau - Colonne unique',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '278',
  'translation' => 'Tableau - Colonnes multiples',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '279',
  'translation' => '[Format du sous-groupe]',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '280',
  'translation' => 'Paramètres multigroupe',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '281',
  'translation' => 'Colonnes multiples',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '282',
  'translation' => "Activez cette option pour rendre chaque champs dans une colonne disctincte sur le formulaire d'édition de noeud.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '283',
  'translation' => "Activez cette option pour rendre obligatoire un minimum d'une collection de champs dans ce Multigroupe.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '284',
  'translation' => "Nombre de fois où répéter l'ensemble Multigroupe de champs.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '285',
  'translation' => "'Illimité' fournira un bouton 'Ajouter plus' pour que les utilisateurs puissent ajouter des éléments autant de fois qu'ils le souhaitent.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '286',
  'translation' => 'Tous les champs de ce groupe seront automatiquement paramétrés pour autoriser ce nombre de valeurs.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '287',
  'translation' => 'Nombre de répétitions',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '288',
  'translation' => 'Etiquettes',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '289',
  'translation' => "Etiquettes pour chaque sous-groupe de champs. Les étiquettes peuvent être cachées ou affichées dans des contextes divers en utilisant l'écran 'Afficher les champs'.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '290',
  'translation' => 'Etiquette du sous-groupe %number',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '291',
  'translation' => 'Le champ %field dans ce groupe possède déjà %multiple valeurs dans la base de données. Pour éviter la perte de données, vous ne pouvez définir le nombre de valeurs du Multigroupe à une valeur inférieure.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '292',
  'translation' => 'Le champ !name est obligatoire dans le groupe @group.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '293',
  'translation' => 'Le groupe @name requiert au minimum un groupe de champs.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '294',
  'translation' => 'Ajouter plus de valeurs',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '295',
  'translation' => 'content_multigroup',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '296',
  'translation' => 'Contenu Multigroupe',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '297',
  'translation' => "Combinez de multiples champs CCK au sein de collections de champs qui fonctionnent à l'unisson.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '298',
  'translation' => 'éditer',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '299',
  'translation' => 'field_name',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '300',
  'translation' => 'voir',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '301',
  'translation' => 'content_permissions',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '302',
  'translation' => 'Veuillez <a href="!url">configurer vos permissions sur les champs</a> immédiatement. Tous les champs sont inaccessibles par défaut.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '303',
  'translation' => 'Permissions sur les Contenus',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '304',
  'translation' => 'Définit un niveau de permission par champ pour les champs CCK.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '305',
  'translation' => 'Contenu du groupe de champ',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '306',
  'translation' => "Tous les champs d'un groupe de champs sur le node référencé.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '307',
  'translation' => '@group_label (@group_type_name)',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '308',
  'translation' => 'Fieldgroup',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '309',
  'translation' => "Texte à afficher si un groupe n'a pas de données. Notez que le titre ne s'affichera pas sauf s'il est surclassé.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '310',
  'translation' => '"@s" groupe de champs @name',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '311',
  'translation' => 'Paramètres du formulaire',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '312',
  'translation' => "Ces paramètres s'appliquent au groupe dans le formulaire d'édition de nœud.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '313',
  'translation' => 'Style',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '314',
  'translation' => 'toujours déplié',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '315',
  'translation' => 'repliable',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '316',
  'translation' => 'replié',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '317',
  'translation' => "Instructions à présenter à l'utilisateur dans le formulaire d'édition.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '318',
  'translation' => "Paramètres d'affichage",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '319',
  'translation' => "Ces paramètres s'appliquent au groupe à l'affichage du nœud.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '320',
  'translation' => 'Description du groupe.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '321',
  'translation' => "Êtes-vous sûr(e) de vouloir supprimer le groupe '%label' ?",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '322',
  'translation' => 'Cette action est irréversible.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '323',
  'translation' => "Le groupe '%group_name' a été supprimé.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '324',
  'translation' => 'aucun',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '325',
  'translation' => 'Vous devez fournir une étiquette.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '326',
  'translation' => 'Vous devez fournir un nom de groupe',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '327',
  'translation' => "Le nom de groupe %group_name n'est pas valide. Le nom ne doit contenir que des lettres sans accents, des nombres, et des underscores.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '328',
  'translation' => "Le nom de groupe %group_name est trop long. Le nom est limité à 32 caractères, le préfixe 'group_' compris.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '329',
  'translation' => 'Le nom de groupe %group_name existe déjà.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '330',
  'translation' => 'Ajouter un nouveau groupe :',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '331',
  'translation' => 'Ajouter un nouveau groupe : vous devez fournir une étiquette.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '332',
  'translation' => 'Ajouter un nouveau groupe : vous devez fournir un nom de groupe.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '333',
  'translation' => 'Groupe standard',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '334',
  'translation' => 'Éditer le groupe',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '335',
  'translation' => 'fieldgroup',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '336',
  'translation' => "Créée des groupes d'affichage pour les champs CCK.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '337',
  'translation' => 'Charge un noeud référencé',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '338',
  'translation' => 'Contenu contenant le champ node reference',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '339',
  'translation' => 'Contenu référencé',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '340',
  'translation' => 'Notez que si le champs possède des valeurs multiples, seul le premier contenu sera chargé.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '341',
  'translation' => "Il n'y a aucun champ  nodereference défini.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '342',
  'translation' => 'Node référence',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '343',
  'translation' => "Stocker l'ID du noeud lié en tant que valeur entière.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '344',
  'translation' => 'Types de contenu pouvant être référencés',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '345',
  'translation' => 'Vues par défaut',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '346',
  'translation' => 'Vues éxistantes',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '347',
  'translation' => 'Avancé - Nœuds pouvant être référencés (Vue)',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '348',
  'translation' => 'Vue utilisée pour sélectionner les noeuds',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '349',
  'translation' => '<p>Choisissez la vue du "module Views" qui sélectionne les noeuds pouvant être référencés.<br />Note :</p>',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '350',
  'translation' => "<ul><li>Seules les vues qui possèdent des champs fonctionneront à cet effet.</li><li>Ceci annulera les paramètres \"Types de contenu\" ci-dessus. Utilisez la section \"filtres\" de la vue à la place.</li><li>Utilisez la section \"champs\" de la vue pour afficher des informations supplémentaires à propos des noeuds candidats sur le formulaire de création/édition.</li><li>Utilisez la section \"critère de tri\" de la vue pour déterminer l'ordre dans lequel les noeuds candidats seront affichés.</li></ul>",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '351',
  'translation' => 'Arguments de la vue',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '352',
  'translation' => "Fournit une liste d'arguments, séparés par des virgules, à transmettre à la vue.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '353',
  'translation' => "<p>La liste des noeuds pouvant être référencés peut s'appuyer sur une vue du \"module Views\" mais aucune vue appropriée n'a été trouvée. <br />Note :</p>",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '354',
  'translation' => '%name : saisie non valide.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '355',
  'translation' => '%name : ce contenu ne peut être référencé.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '356',
  'translation' => 'Titre (avec lien)',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '357',
  'translation' => 'Titre (sans lien)',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '358',
  'translation' => 'Liste de sélection',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '359',
  'translation' => 'Cases à cocher/boutons radio',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '360',
  'translation' => 'Champ texte à auto-complètement',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '361',
  'translation' => "Correspondance de l'autocomplétion",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '362',
  'translation' => 'Commence par',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '363',
  'translation' => 'Contient',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '364',
  'translation' => "Séléctionnez la méthode utilisée pour collecter les suggestions de l'autocomplétion. Notez que <em>Contient</em> peut engendrer des problèmes de performances sur des sites avec des milliers de noeuds",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '365',
  'translation' => '%name : différence de titre. Veuillez vérifier votre sélection.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '366',
  'translation' => "%name : aucun contenu valide n'a été trouvé pour ce titre.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '367',
  'translation' => 'Autocomplétion de nodereference',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '368',
  'translation' => 'nodereference',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '369',
  'translation' => 'Node Reference',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '370',
  'translation' => 'Définit un type de champ pour référencer un noeud depuis un autre noeud.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '371',
  'translation' => 'Entier',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '372',
  'translation' => 'Stocke un nombre dans la base de données en format entier.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '373',
  'translation' => 'Décimal',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '374',
  'translation' => 'Stocke un nombre dans la base de données en format décimal fixe.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '375',
  'translation' => 'Réel (Float)',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '376',
  'translation' => 'Stocke un nombre dans la base de données en format réel.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '377',
  'translation' => 'Minimum',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '378',
  'translation' => 'Maximum',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '379',
  'translation' => 'Précision',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '380',
  'translation' => 'Le nombre total de chiffres à stocker dans la base de données, en incluant ceux à droite de la virgule.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '381',
  'translation' => 'Echelle',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '382',
  'translation' => 'Le nombre de chiffres à droite de la virgule',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '383',
  'translation' => 'Séparateur de décimales',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '384',
  'translation' => 'Le caractère que les utilisateurs saisiront pour séparer les décimales dans les formulaires.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '385',
  'translation' => 'Préfixe',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '386',
  'translation' => 'Définissez une chaîne de caractères à utiliser pour préfixer la valeur, par exemple $ ou €. Laissez vide pour ne rien afficher de plus. Séparez les valeurs singulier et pluriel par une barre verticale (euro|euros).',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '387',
  'translation' => 'Suffixe',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '388',
  'translation' => 'Définissez une chaîne qui sera ajoutée en suffixe à la valeur, comme m², m/s², kb/s. Laisser vide pour aucun suffixe. Séparez les singulier et pluriel avec un pipe (mètre|mètres).',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '389',
  'translation' => 'Valeurs autorisées',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '390',
  'translation' => 'Liste des valeurs autorisées',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '391',
  'translation' => "Les valeurs possibles que ce champ peut contenir. Entrez une valeur par ligne, sous la forme clé|étiquette. La clé est une valeur qui sera stocker dans la base de données, elle doit correspondre au type de champ défini (%type). L'étiquette est optionnelle, si elle n'est pas précisée, la clé sera utilisée également comme étiquette.<br />Balises HTML autorisées : @tags",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '392',
  'translation' => 'Pour usage avancé seulement : code PHP fournissant un tableau par clé des valeurs autorisées. Ne doit pas inclure les délimiteurs &lt;?php ?&gt;. Si ce champ est rempli, le tableau renvoyé par le code prendra le pas sur la liste des valeurs autorisées apparaissant ci-dessus.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '393',
  'translation' => 'Ce code PHP a été saisi par un administrateur et supplantera la liste des valeurs permises ci-dessus.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '394',
  'translation' => '@label (!name) - Valeurs autorisées',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '395',
  'translation' => '"Minimum" doit être un nombre.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '396',
  'translation' => '"Maximum" doit être un nombre.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '397',
  'translation' => '%name : la valeur ne peut être inférieure à %min.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '398',
  'translation' => '%name : la valeur ne peut être supérieure à %max.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '399',
  'translation' => '%name : valeur illégale.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '400',
  'translation' => 'non mis en forme',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '401',
  'translation' => 'Champ texte',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '402',
  'translation' => 'Seuls les nombres et les décimaux sont autorisés dans %field.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '403',
  'translation' => 'Seuls les nombres sont autorisés dans %field.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '404',
  'translation' => 'Seuls les nombres et le caractère décimal (%decimal) sont autorisés dans %field.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '405',
  'translation' => 'nombre',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '406',
  'translation' => 'Nombre',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '407',
  'translation' => 'Définit des types de champs numériques.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '408',
  'translation' => "Créez une liste d'options en tant que liste dans la <strong>Liste des valeurs autorisées</strong>, ou en tant que tableau en code PHP. Ces valeurs seront les mêmes pour le champ %field au sein de tous les types de contenu.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '409',
  'translation' => "Pour un widget 'case à cocher oui/non', définissez la valeur 'non' en premier, puis la valeur 'oui', dans la section <strong>Valeurs autorisées</strong>. Notez que la case à cocher sera étiquetée avec l'étiquette de la valeur du 'oui'.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '410',
  'translation' => "Le widget 'cases à cocher/boutons radio' affichera des cases à cocher si l'option valeurs multiples est sélectionnées pour ce champ, autrement, des boutons radio seront affichés.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '411',
  'translation' => "Vous devez préciser les 'valeurs autorisées' pour ce champ.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '412',
  'translation' => 'Case à cocher on/off unique',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '413',
  'translation' => '%name : ce champ ne peut contenir plus de @count valeurs.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '414',
  'translation' => 'N/A',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '415',
  'translation' => '- Aucun -',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '416',
  'translation' => 'optionwidgets',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '417',
  'translation' => 'Option Widgets',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '418',
  'translation' => 'Définit des widgets de liste déroulante, case à cocher et bouton radio pour des champs texte et numériques.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '419',
  'translation' => 'Enregistre le texte dans la base de données.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '420',
  'translation' => 'Texte simple',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '421',
  'translation' => "Texte filtré (l'utilisateur choisit le format d'entrée)",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '422',
  'translation' => 'Traitement du texte',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '423',
  'translation' => 'Taille maximale',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '424',
  'translation' => 'La taille maximale des champs, en caractères. Laisser vide pour ne pas limiter la taille.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '425',
  'translation' => '%name : la valeur ne doit pas dépasser %max caractères.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '426',
  'translation' => 'Par défaut',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '427',
  'translation' => 'Coupé',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '428',
  'translation' => 'Zone de texte (plusieurs lignes)',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '429',
  'translation' => 'Taille du champ texte',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '430',
  'translation' => 'Rangées',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '431',
  'translation' => 'texte',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '432',
  'translation' => 'Définit les types de champs en texte simple.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '433',
  'translation' => 'Charge un utilisateur référencé',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '434',
  'translation' => 'Contenu contenant le champ userrefernece',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '435',
  'translation' => 'Utilisateur référencé',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '436',
  'translation' => 'Noter que si le champ possède des valeurs multiples, seul le premier utilisateur sera chargé',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '437',
  'translation' => "Il n'y a aucun champ userreference défini",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '438',
  'translation' => 'User reference',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '439',
  'translation' => "Stocke l'ID d'un utilisateur lié sous forme d'entier",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '440',
  'translation' => 'Rôles utilisateur pouvant être référencés',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '441',
  'translation' => 'Statuts utilisateur pouvant être référencés',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '442',
  'translation' => 'Actif',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '443',
  'translation' => 'Bloqué',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '444',
  'translation' => 'Avancé - Utilisateurs pouvant être référencés (Vue)',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '445',
  'translation' => 'Vue utilisée pour sélectionner les utilisateurs',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '446',
  'translation' => '<p>Choisissez la vue du "module Views" qui sélectionne les utilisateurs pouvant être référencés.<br />Note :</p>',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '447',
  'translation' => "<ul><li>Seules les vues qui possèdent des champs fonctionneront à cet effet.</li><li>Ceci annulera les paramètres \"Rôles Référençables\" et \"Statut Référençable\" ci-dessus. Utilisez la section \"filtres\" de la vue à la place.</li><li>Utilisez la section \"champs\" de la vue pour afficher des informations supplémentaires à propos des utilisateurs candidats sur le formulaire de création/édition.</li><li>Utilisez la section \"critère de tri\" de la vue pour déterminer l'ordre dans lequel les utilisateurs candidats seront affichés.</li></ul>",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '448',
  'translation' => "<p>La liste d'utilisateurs pouvant être référencés peut s'appueyr sur une vue du \"module Views\", mais aucune vue appropriée n'a été trouvée. <br />Note :</p>",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '449',
  'translation' => '%name : utilisateur invalide.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '450',
  'translation' => "Séléctionnez la méthode utilisée pour collecter les suggestions de l'autocomplétion. Notez que <em>Contient</em> peut engendrer des problèmes de performances sur des sites avec des milliers d'utilisateurs.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '451',
  'translation' => 'Lien retour',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '452',
  'translation' => "Si cette option est sélectionnée, un lien réciproque vers le nœud référençant sera affiché dans l'enregistrement utilisateur référencé.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '453',
  'translation' => "%name : nous n'avons pas trouvé d'utilisateur valide pour ce nom.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '454',
  'translation' => 'Contenu lié',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '455',
  'translation' => 'Autocomplétion Userreference',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '456',
  'translation' => 'userreference',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '457',
  'translation' => 'User Reference',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '458',
  'translation' => 'Définit un type de champ pour référencer un utilisateur depuis un noeud.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '459',
  'translation' => 'Poids',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '460',
  'translation' => 'Ajouter',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '461',
  'translation' => 'Nouveau champ',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '462',
  'translation' => 'Champ existant',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '463',
  'translation' => 'Nouveau groupe',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '464',
  'translation' => "Ajouter des champs et des groupes au type de contenu, et les paramétrer pour l'affichage du contenu et les formulaires de saisie.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '465',
  'translation' => 'Vous pouvez ajouter un champ à un groupe en le faisant glisser ci-dessous et à la droite du groupe.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '466',
  'translation' => "Note : l'installation du module <a href=\"!adv_help\">Aide avancée (Advanced help)</a> vous permettra d'accéder à plus d'aide, et de meilleure qualité.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '467',
  'translation' => "Utiliser la case à cocher 'Exclure' pour exclure un élément de la valeur de !content transmis au gabarit du node.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '468',
  'translation' => 'Supprimer cet élément',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '469',
  'translation' => 'Ajouter un champ',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '470',
  'translation' => "Valeur illégale pour le champ '%name'.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '471',
  'translation' => "La longueur de '%label' dépasse %max caractères.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '472',
  'translation' => "Le champ 'Rangées' doit être un entier positif.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '473',
  'translation' => "Les valeurs que ce champ peut contenir. Saisissez une valeur par ligne, au format clé|libellé. La clé est la valeur qui sera enregistrée dans la base de données et elle doit correspondre au type définit pour le champ dans la base, '%type'. Le libellé est optionnel et, si aucune valeur n'est spécifiée, la clé sera utilisée comme libellé.<br />Balises HTML autorisées : @tags",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '474',
  'translation' => 'ajouter un champ',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '475',
  'translation' => "Il n'y a aucun champ configuré pour ce type de contenu. Vous pouvez néanmoins dès maintenant !link.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '476',
  'translation' => 'ajouter un nouveau champ',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '477',
  'translation' => "Pour changer l'ordre d'un champ, utilisez la poignée qui figure sous la colonne Étiquette et faites glisser le champ jusqu'à l'emplacement désiré. Pour manipuler la poignée (l'icône en forme de croix), cliquez sur l'icône et maintenez enfoncé le bouton de la souris. N'oubliez pas que vos modifications ne seront prises en compte que lorsque vous aurez cliqué sur le bouton <em>Enregistrer</em> qui figure en base de page.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '478',
  'translation' => "Aucun module de champs n'est activé. Vous devez en <a href=\"!modules_url\">activer un</a>, par exemple le module Text, avant de pouvoir ajouter des champs.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '479',
  'translation' => 'Ajouter un champ existant',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '480',
  'translation' => 'Créer un nouveau champ',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '481',
  'translation' => 'Nom du champ, lisible par une machine.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '482',
  'translation' => ' Ce nom ne peut être modifié.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '483',
  'translation' => " Ce nom ne pourra pas être modifié par la suite ! Le nom sera préfixé par 'field_' et peut inclure des lettres minuscules non accentués, des nombres et des caractères \"espace souligné\". La longueur du nom, y compris le préfixe, est limitée à un total de 32 caractères.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '484',
  'translation' => 'Type de données que vous souhaitez enregistrer, par le biais de ce champ, dans la base de données.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '485',
  'translation' => "Le nom de champ '%field_name' est invalide. Le nom ne doit comporter que des lettres minuscules non accentuées, des nombres ou des espaces soulignés.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '486',
  'translation' => "Le nom de champ '%field_name' est trop long. La longueur du nom est limitée à 32 caractères, y compris le préfixe 'field_'.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '487',
  'translation' => "Le nom de champ '%field_name' existe déjà.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '488',
  'translation' => "Le nom 'field_instance' est un nom réservé.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '489',
  'translation' => "Le champ '%label' a été créé.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '490',
  'translation' => "Mettre à jour le champ '%label'.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '491',
  'translation' => "Un problème est survenu à la mise à jour du champ '%label'.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '492',
  'translation' => "Réservé à une utilisation avancée : code PHP renvoyant la valeur par défaut du champ. Ne doit pas inclure les délimiteurs &lt;?php ?&gt;. Si ce champ est renseigné, la valeur renvoyée par le code supplante toute valeur indiquée ci-desus. Format attendu : <pre>!sample</pre> Vous pouvez utiliser l'onglet 'devel load' du module !link_devel sur un nœud de type '%type' pour mieux comprendre le format attendu.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '493',
  'translation' => "Choisissez un nombre de valeurs pour ce champ, ou 'Illimité' pour proposer un bouton 'Ajouter' aux utilisateurs, de sorte qu'ils peuvent insérer autant de valeurs qu'ils le souhaitent.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '494',
  'translation' => 'Le code PHP de valeur par défaut a créé @value, qui est invalide.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '495',
  'translation' => 'Lien HTML mis en forme vers le nœud',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '496',
  'translation' => "La valeur de '%name 'ne peut être plus petite que %min.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '497',
  'translation' => "La valeur de '%name' ne peut pas être plus grande que %max.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '498',
  'translation' => "Seuls des nombres et des décimaux sont autorisés dans '%field'. La valeur saisie, '%start', a été modifié en '%value'.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '499',
  'translation' => "Seuls des nombres sont autorisés dans '%field'. La valeur saisie, '%start', a été modifié en '%value'.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '500',
  'translation' => "Seuls des nombres et le marqueur décimal (%decimal) sont autorisés dans '%field'. La valeur saisie, '%start', a été modifié en '%value'.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '501',
  'translation' => "Créez une liste d'options en tant que liste dans les <strong>Valeurs permises</strong> ou en tant que tableau dans le code PHP. Ces valeurs seront identiques pour '%field' dans tous les types de contenus.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '504',
  'translation' => 'fr - Favorite color',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '505',
  'translation' => 'Inscrivez votre couleur préférée',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '506',
  'translation' => 'fr - Personal information',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '507',
  'translation' => 'fr - Biography',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '508',
  'translation' => 'fr - Tell people a little bit about yourself',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '509',
  'translation' => 'fr - Sell your email address?',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '510',
  'translation' => "fr - If you check this box, we'll sell your address to spammers to help line the pockets of our shareholders. Thanks!",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '511',
  'translation' => 'fr - Communication preferences',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '512',
  'translation' => 'fr - Sales Category',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '513',
  'translation' => "fr - Select the sales categories to which this user's address was sold.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '514',
  'translation' => 'fr - Pill spammers Fitness spammers Back\slash Forward/slash Dot.in.the.middle',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '515',
  'translation' => 'fr - Administrative data',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '516',
  'translation' => 'Mes groupes préférés',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '517',
  'translation' => "fr - Enter your favorite bands. When you've saved your profile, you'll be able to find other people with the same favorites.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '518',
  'translation' => 'fr - Birthdate',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '519',
  'translation' => "fr - Enter your birth date and we'll send you a coupon.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '520',
  'translation' => "J'aime les migrations",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '1',
))
->values(array(
  'lid' => '521',
  'translation' => 'Si vous cochez cette case, vous aimez les migrations.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '522',
  'translation' => 'fr - Blog',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '523',
  'translation' => 'fr - Paste the full URL, including http://, of your personal blog.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '524',
  'translation' => 'fr - Static Block',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '525',
  'translation' => '<h3>fr - My first custom block body</h3>',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '526',
  'translation' => 'Encore un bloc statique',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '527',
  'translation' => 'Nom de vocabulaire beaucoup plus long que trente-deux caractères',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '528',
  'translation' => 'fr - Tags',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '529',
  'translation' => 'fr - vocabulary 1 (i=0)',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '530',
  'translation' => 'fr - vocabulary 2 (i=1)',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '531',
  'translation' => 'fr - vocabulary 3 (i=2)',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '532',
  'translation' => 'Nom de vocabulaire beaucoup plus long que trente-deux caractères',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '533',
  'translation' => 'fr - Article',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '534',
  'translation' => 'fr - Title',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '535',
  'translation' => 'fr - Body',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '536',
  'translation' => 'fr - An <em>article</em>, content type.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '537',
  'translation' => 'fr - Company',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '538',
  'translation' => 'fr - Name',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '539',
  'translation' => 'fr - Description',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '540',
  'translation' => 'fr - Company node type',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '541',
  'translation' => 'fr - Employee',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '542',
  'translation' => 'fr - Name',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '543',
  'translation' => 'fr - Bio',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '544',
  'translation' => 'fr - Employee node type',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '545',
  'translation' => 'fr - Sponsor',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '546',
  'translation' => 'fr - Name',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '547',
  'translation' => 'fr - Body',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '548',
  'translation' => 'fr - Sponsor node type',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '549',
  'translation' => 'fr - Story',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '550',
  'translation' => 'fr - Title',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '551',
  'translation' => 'fr - Body',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '552',
  'translation' => "fr - A <em>story</em>, similar in form to a <em>page</em>, is ideal for creating and displaying content that informs or engages website visitors. Press releases, site announcements, and informal blog-like entries may all be created with a <em>story</em> entry. By default, a <em>story</em> entry is automatically featured on the site's initial home page, and provides the ability to post comments.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '553',
  'translation' => 'fr - Migrate test event',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '554',
  'translation' => 'fr - Event Name',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '555',
  'translation' => 'fr - Body',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '556',
  'translation' => 'fr - test event description here',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '558',
  'translation' => 'fr - Migrate test page',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '559',
  'translation' => 'fr - Title',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '560',
  'translation' => 'fr - This is the body field label',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '561',
  'translation' => "fr - A <em>page</em>, similar in form to a <em>story</em>, is a simple method for creating and displaying information that rarely changes, such as an \"About us\" section of a website. By default, a <em>page</em> entry does not allow visitor comments and is not featured on the site's initial home page.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '562',
  'translation' => 'fr - Migrate test planet',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '563',
  'translation' => 'fr - Title',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '564',
  'translation' => 'fr - Body',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '565',
  'translation' => "fr - A <em>story</em>, similar in form to a <em>page</em>, is ideal for creating and displaying content that informs or engages website visitors. Press releases, site announcements, and informal blog-like entries may all be created with a <em>story</em> entry. By default, a <em>story</em> entry is automatically featured on the site's initial home page, and provides the ability to post comments.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '566',
  'translation' => 'Migrer histoire de test',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '567',
  'translation' => 'Titre',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '568',
  'translation' => 'Le corps',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '569',
  'translation' => "A histoire, de forme semblable à un page, est idéal pour la création et l'affichage du contenu qui informe et pousse les visiteurs du site. Communiqués de presse, des annonces du site, et les entrées de blog comme informels peuvent être créés avec un histoire entrée. Par défaut, un histoire entrée est automatiquement présenté sur la page d'accueil initiale du site, et offre la possibilité de poster des commentaires.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '570',
  'translation' => 'fr - Text Field',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '571',
  'translation' => 'fr - An example text field without exclude.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '572',
  'translation' => 'fr - Integer Field',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '573',
  'translation' => 'fr - An example integer field.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '574',
  'translation' => 'fr - Text Field',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '575',
  'translation' => 'fr - An example text field.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '576',
  'translation' => 'fr - Decimal Field',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '577',
  'translation' => 'fr - An example decimal field.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '578',
  'translation' => 'fr - Float Field',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '579',
  'translation' => 'fr - An example float field.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '580',
  'translation' => 'fr - Integer Field',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '581',
  'translation' => 'fr - An example integer field.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '582',
  'translation' => 'fr - Integer Field',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '583',
  'translation' => 'fr - An example integer field.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '584',
  'translation' => 'fr - Email Field',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '585',
  'translation' => 'fr - An example email field.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '586',
  'translation' => 'fr - Link Field',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '587',
  'translation' => 'fr - An example link field.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '588',
  'translation' => 'fr - File Field',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '589',
  'translation' => 'fr - An example file field.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '590',
  'translation' => 'fr - Image Field',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '591',
  'translation' => 'fr - An example image field.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '592',
  'translation' => 'fr - Date Field',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '593',
  'translation' => 'fr - An example date field.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '594',
  'translation' => 'fr - Date Stamp Field',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '595',
  'translation' => 'fr - An example date stamp field.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '596',
  'translation' => 'fr - Datetime Field',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '597',
  'translation' => 'fr - An example datetime field.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '598',
  'translation' => 'fr - Phone Field',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '599',
  'translation' => 'fr - An example phone field.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '600',
  'translation' => 'fr - Decimal Radio Buttons Field',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '601',
  'translation' => 'fr - An example decimal field using radio buttons.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '604',
  'translation' => 'fr - Float Single Checkbox Field',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '605',
  'translation' => 'fr - An example float field using a single on/off checkbox.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '607',
  'translation' => 'fr - 1.234',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '608',
  'translation' => 'fr - Integer Select List Field',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '609',
  'translation' => 'fr - An example integer field using a select list.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '611',
  'translation' => 'fr - 2341',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '613',
  'translation' => 'fr - 4123',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '614',
  'translation' => 'fr - Text Single Checkbox Field',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '615',
  'translation' => 'fr - An example text field using a single on/off checkbox.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '616',
  'translation' => 'fr - Hello',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '617',
  'translation' => 'fr - Goodbye',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '618',
  'translation' => 'fr - Text Single Checkbox Field 2',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '619',
  'translation' => 'fr - Checkbox that uses keys only and no label.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '620',
  'translation' => 'fr - Off',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '621',
  'translation' => 'fr - Hello',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '622',
  'translation' => 'Champ de texte',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '623',
  'translation' => 'fr - An example text field.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '624',
  'translation' => 'fr - Decimal Field',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '625',
  'translation' => 'Un exemple plusieurs valeurs champ décimal.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '627',
  'translation' => 'fr - An example text field using a single on/off checkbox.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '633',
  'translation' => 'fr - Drupal.org',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '634',
  'translation' => 'fr - Test 2',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '635',
  'translation' => 'fr - Test menu link 2',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '663',
  'translation' => 'fr - Content management',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '1254',
  'translation' => 'fr - Modules',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '1264',
  'translation' => 'fr - By task',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '1265',
  'translation' => 'fr - By module',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '1669',
  'translation' => "Choisissez la vue du module Views qui sélectionne les nœuds pouvant être référencés.<br />Notez que :<ul><li>seules les vues présentant des champs fonctionneront dans ce cadre </li><li>ceci effacera les paramètres de \"Types de contenus\" figurant ci-dessus. Utilisez à la place la section \"filtres\" de la vue ;</li><li>utilisez la section \"champs\" de la vue pour afficher des informations supplémentaires sur les nœuds candidats dans le formulaire de création/édition de nœud ;</li><li>utilisez la section \"critère de tri\" de la vue pour déterminer l'ordre d'affichage des nœuds candidats.</li></ul>",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '1670',
  'translation' => "Champ '%name' : cette publication ne peut être référencée.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '1671',
  'translation' => "Champ '%name' : incohérence au niveau du titre. Merci de vérifier votre sélection.",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '1672',
  'translation' => 'fr - Type',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '1678',
  'translation' => 'fr - I really, really, really love migrating ',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '1690',
  'translation' => 'Noir',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '1692',
  'translation' => 'fr - Talos IV',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '1694',
  'translation' => 'fr - The home of Captain Christopher Pike.',
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '1696',
  'translation' => "fr - 10\r\nfr - 20\r\nfr - 50\r\nfr - 100\r\nfr - 1000",
  'language' => 'fr',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '66',
  'translation' => 'zu - CCK - Aucune Intégration aux Vues',
  'language' => 'zu',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '506',
  'translation' => 'zu - Personal information',
  'language' => 'zu',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '512',
  'translation' => 'zu - Sales Category',
  'language' => 'zu',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '513',
  'translation' => "zu - Select the sales categories to which this user's address was sold.",
  'language' => 'zu',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '514',
  'translation' => 'zu - Pill spammers Fitness spammers Back\slash Forward/slash Dot.in.the.middle',
  'language' => 'zu',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '525',
  'translation' => '<h3>zu - My first custom block body</h3>',
  'language' => 'zu',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '529',
  'translation' => 'zu - vocabulary 1 (i=0)',
  'language' => 'zu',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '535',
  'translation' => 'zu - Body',
  'language' => 'zu',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '590',
  'translation' => 'zu - Image Field',
  'language' => 'zu',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '591',
  'translation' => 'zu - An example image field.',
  'language' => 'zu',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '607',
  'translation' => 'zu - 1.234',
  'language' => 'zu',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '611',
  'translation' => 'zu - 2341',
  'language' => 'zu',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '621',
  'translation' => 'zu - Hello',
  'language' => 'zu',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '635',
  'translation' => 'zu - Test menu link 2',
  'language' => 'zu',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '1672',
  'translation' => 'zu - Type',
  'language' => 'zu',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '1690',
  'translation' => 'Okumnyama',
  'language' => 'zu',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '1691',
  'translation' => 'Mhlophe',
  'language' => 'zu',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '1693',
  'translation' => 'zu - Vulcan',
  'language' => 'zu',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->values(array(
  'lid' => '1694',
  'translation' => 'zu - The home of Captain Christopher Pike.',
  'language' => 'zu',
  'plid' => '0',
  'plural' => '0',
  'i18n_status' => '0',
))
->execute();
$connection->schema()->createTable('menu_custom', array(
  'fields' => array(
    'menu_name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'title' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'description' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'menu_name',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('menu_custom')
->fields(array(
  'menu_name',
  'title',
  'description',
))
->values(array(
  'menu_name' => 'navigation',
  'title' => 'Navigation',
  'description' => 'The navigation menu is provided by Drupal and is the main interactive menu for any site. It is usually the only menu that contains personalized links for authenticated users, and is often not even visible to anonymous users.',
))
->values(array(
  'menu_name' => 'primary-links',
  'title' => 'Primary links',
  'description' => 'Primary links are often used at the theme layer to show the major sections of a site. A typical representation for primary links would be tabs along the top.',
))
->values(array(
  'menu_name' => 'secondary-links',
  'title' => 'Secondary links',
  'description' => 'Secondary links are often used for pages like legal notices, contact details, and other secondary navigation items that play a lesser role than primary links',
))
->execute();
$connection->schema()->createTable('menu_links', array(
  'fields' => array(
    'menu_name' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ),
    'mlid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'plid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'link_path' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'router_path' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'link_title' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'options' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'module' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => 'system',
    ),
    'hidden' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'external' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'has_children' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'expanded' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'depth' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'customized' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'p1' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p2' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p3' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p4' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p5' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p6' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p7' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p8' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'p9' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'updated' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
  ),
  'primary key' => array(
    'mlid',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('menu_links')
->fields(array(
  'menu_name',
  'mlid',
  'plid',
  'link_path',
  'router_path',
  'link_title',
  'options',
  'module',
  'hidden',
  'external',
  'has_children',
  'expanded',
  'weight',
  'depth',
  'customized',
  'p1',
  'p2',
  'p3',
  'p4',
  'p5',
  'p6',
  'p7',
  'p8',
  'p9',
  'updated',
))
->values(array(
  'menu_name' => 'book-toc-1',
  'mlid' => '1',
  'plid' => '0',
  'link_path' => 'node/4',
  'router_path' => 'node/%',
  'link_title' => 'Test top book title',
  'options' => 'a:0:{}',
  'module' => 'book',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '1',
  'customized' => '0',
  'p1' => '1',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'book-toc-1',
  'mlid' => '2',
  'plid' => '1',
  'link_path' => 'node/5',
  'router_path' => 'node/%',
  'link_title' => 'Test book title child 1',
  'options' => 'a:0:{}',
  'module' => 'book',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '1',
  'p2' => '2',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'book-toc-1',
  'mlid' => '3',
  'plid' => '2',
  'link_path' => 'node/6',
  'router_path' => 'node/%',
  'link_title' => 'Test book title child 1.1',
  'options' => 'a:0:{}',
  'module' => 'book',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '2',
  'p3' => '3',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'book-toc-1',
  'mlid' => '4',
  'plid' => '2',
  'link_path' => 'node/7',
  'router_path' => 'node/%',
  'link_title' => 'Test book title child 1.2',
  'options' => 'a:0:{}',
  'module' => 'book',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '1',
  'p2' => '2',
  'p3' => '4',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'book-toc-2',
  'mlid' => '5',
  'plid' => '0',
  'link_path' => 'node/8',
  'router_path' => 'node/%',
  'link_title' => 'Test top book 2 title',
  'options' => 'a:0:{}',
  'module' => 'book',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '1',
  'customized' => '0',
  'p1' => '5',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'secondary-links',
  'mlid' => '138',
  'plid' => '139',
  'link_path' => 'user/login',
  'router_path' => 'user/login',
  'link_title' => 'Test 1',
  'options' => 'a:2:{s:10:"attributes";a:1:{s:5:"title";s:16:"Test menu link 1";}s:8:"langcode";s:2:"en";}',
  'module' => 'menu',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-50',
  'depth' => '2',
  'customized' => '1',
  'p1' => '139',
  'p2' => '138',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'secondary-links',
  'mlid' => '139',
  'plid' => '0',
  'link_path' => 'admin',
  'router_path' => 'admin',
  'link_title' => 'Test 2',
  'options' => 'a:2:{s:5:"query";s:7:"foo=bar";s:10:"attributes";a:1:{s:5:"title";s:16:"Test menu link 2";}}',
  'module' => 'menu',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '1',
  'weight' => '-49',
  'depth' => '1',
  'customized' => '1',
  'p1' => '139',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'secondary-links',
  'mlid' => '140',
  'plid' => '0',
  'link_path' => 'https://www.drupal.org',
  'router_path' => '',
  'link_title' => 'Drupal.org',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:0:"";}}',
  'module' => 'menu',
  'hidden' => '0',
  'external' => '1',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-50',
  'depth' => '1',
  'customized' => '1',
  'p1' => '140',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '141',
  'plid' => '0',
  'link_path' => 'node',
  'router_path' => 'node',
  'link_title' => 'Content',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '141',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '142',
  'plid' => '0',
  'link_path' => 'rss.xml',
  'router_path' => 'rss.xml',
  'link_title' => 'RSS feed',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '142',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '143',
  'plid' => '0',
  'link_path' => 'batch',
  'router_path' => 'batch',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '143',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '144',
  'plid' => '0',
  'link_path' => 'admin',
  'router_path' => 'admin',
  'link_title' => 'Administer',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '9',
  'depth' => '1',
  'customized' => '0',
  'p1' => '144',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '145',
  'plid' => '0',
  'link_path' => 'contact',
  'router_path' => 'contact',
  'link_title' => 'Contact',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '145',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '147',
  'plid' => '0',
  'link_path' => 'logout',
  'router_path' => 'logout',
  'link_title' => 'Log out',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '1',
  'customized' => '0',
  'p1' => '147',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '148',
  'plid' => '0',
  'link_path' => 'user',
  'router_path' => 'user',
  'link_title' => 'User account',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '148',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '149',
  'plid' => '0',
  'link_path' => 'profile',
  'router_path' => 'profile',
  'link_title' => 'User list',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '149',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '150',
  'plid' => '0',
  'link_path' => 'node/%',
  'router_path' => 'node/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '150',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '151',
  'plid' => '0',
  'link_path' => 'content/js_add_more',
  'router_path' => 'content/js_add_more',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '151',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '152',
  'plid' => '0',
  'link_path' => 'upload/js',
  'router_path' => 'upload/js',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '152',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '153',
  'plid' => '0',
  'link_path' => 'taxonomy/autocomplete',
  'router_path' => 'taxonomy/autocomplete',
  'link_title' => 'Autocomplete taxonomy',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '153',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '155',
  'plid' => '144',
  'link_path' => 'admin/compact',
  'router_path' => 'admin/compact',
  'link_title' => 'Compact mode',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '144',
  'p2' => '155',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '156',
  'plid' => '0',
  'link_path' => 'filter/tips',
  'router_path' => 'filter/tips',
  'link_title' => 'Compose tips',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '156',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '157',
  'plid' => '144',
  'link_path' => 'admin/content',
  'router_path' => 'admin/content',
  'link_title' => 'Content management',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:27:\"Manage your site's content.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '2',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '158',
  'plid' => '0',
  'link_path' => 'node/add',
  'router_path' => 'node/add',
  'link_title' => 'Create content',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '1',
  'customized' => '0',
  'p1' => '158',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '159',
  'plid' => '0',
  'link_path' => 'comment/delete',
  'router_path' => 'comment/delete',
  'link_title' => 'Delete comment',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '159',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '160',
  'plid' => '0',
  'link_path' => 'comment/edit',
  'router_path' => 'comment/edit',
  'link_title' => 'Edit comment',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '160',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '161',
  'plid' => '0',
  'link_path' => 'system/files',
  'router_path' => 'system/files',
  'link_title' => 'File download',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '161',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '163',
  'plid' => '149',
  'link_path' => 'profile/autocomplete',
  'router_path' => 'profile/autocomplete',
  'link_title' => 'Profile autocomplete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '149',
  'p2' => '163',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '165',
  'plid' => '144',
  'link_path' => 'admin/reports',
  'router_path' => 'admin/reports',
  'link_title' => 'Reports',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:59:"View reports from system logs and other status information.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '5',
  'depth' => '2',
  'customized' => '0',
  'p1' => '144',
  'p2' => '165',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '166',
  'plid' => '144',
  'link_path' => 'admin/build',
  'router_path' => 'admin/build',
  'link_title' => 'Site building',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:38:"Control how your site looks and feels.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-10',
  'depth' => '2',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '167',
  'plid' => '144',
  'link_path' => 'admin/settings',
  'router_path' => 'admin/settings',
  'link_title' => 'Site configuration',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:40:"Adjust basic site configuration options.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-5',
  'depth' => '2',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '169',
  'plid' => '0',
  'link_path' => 'user/autocomplete',
  'router_path' => 'user/autocomplete',
  'link_title' => 'User autocomplete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '169',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '170',
  'plid' => '144',
  'link_path' => 'admin/user',
  'router_path' => 'admin/user',
  'link_title' => 'User management',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:61:\"Manage your site's users, groups and access to site features.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '144',
  'p2' => '170',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '171',
  'plid' => '0',
  'link_path' => 'user/timezone',
  'router_path' => 'user/timezone',
  'link_title' => 'User timezone',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '171',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '172',
  'plid' => '0',
  'link_path' => 'user/%',
  'router_path' => 'user/%',
  'link_title' => 'My account',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '172',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '175',
  'plid' => '170',
  'link_path' => 'admin/user/rules',
  'router_path' => 'admin/user/rules',
  'link_title' => 'Access rules',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:80:"List and create rules to disallow usernames, e-mail addresses, and IP addresses.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '170',
  'p3' => '175',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '176',
  'plid' => '167',
  'link_path' => 'admin/settings/actions',
  'router_path' => 'admin/settings/actions',
  'link_title' => 'Actions',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:41:"Manage the actions defined for your site.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '176',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '177',
  'plid' => '167',
  'link_path' => 'admin/settings/admin',
  'router_path' => 'admin/settings/admin',
  'link_title' => 'Administration theme',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:55:"Settings for how your administrative pages should look.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '177',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '178',
  'plid' => '158',
  'link_path' => 'node/add/article',
  'router_path' => 'node/add/article',
  'link_title' => 'Article',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:34:"An <em>article</em>, content type.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '158',
  'p2' => '178',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '179',
  'plid' => '166',
  'link_path' => 'admin/build/block',
  'router_path' => 'admin/build/block',
  'link_title' => 'Blocks',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:79:\"Configure what block content appears in your site's sidebars and other regions.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '179',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '180',
  'plid' => '167',
  'link_path' => 'admin/settings/clean-urls',
  'router_path' => 'admin/settings/clean-urls',
  'link_title' => 'Clean URLs',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:43:"Enable or disable clean URLs for your site.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '180',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '181',
  'plid' => '157',
  'link_path' => 'admin/content/comment',
  'router_path' => 'admin/content/comment',
  'link_title' => 'Comments',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:61:"List and edit site comments and the comment moderation queue.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '181',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '182',
  'plid' => '158',
  'link_path' => 'node/add/company',
  'router_path' => 'node/add/company',
  'link_title' => 'Company',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:17:"Company node type";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '158',
  'p2' => '182',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '183',
  'plid' => '166',
  'link_path' => 'admin/build/contact',
  'router_path' => 'admin/build/contact',
  'link_title' => 'Contact form',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:71:"Create a system contact form and set up categories for the form to use.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '183',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '184',
  'plid' => '157',
  'link_path' => 'admin/content/node',
  'router_path' => 'admin/content/node',
  'link_title' => 'Content',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:43:\"View, edit, and delete your site's content.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '184',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '185',
  'plid' => '157',
  'link_path' => 'admin/content/types',
  'router_path' => 'admin/content/types',
  'link_title' => 'Content types',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:82:"Manage posts by content type, including default status, front page promotion, etc.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '185',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '186',
  'plid' => '167',
  'link_path' => 'admin/settings/date-time',
  'router_path' => 'admin/settings/date-time',
  'link_title' => 'Date and time',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:89:\"Settings for how Drupal displays date and time, as well as the system's default timezone.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '186',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '187',
  'plid' => '0',
  'link_path' => 'node/%/delete',
  'router_path' => 'node/%/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '1',
  'customized' => '0',
  'p1' => '187',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '188',
  'plid' => '172',
  'link_path' => 'user/%/delete',
  'router_path' => 'user/%/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '172',
  'p2' => '188',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '189',
  'plid' => '158',
  'link_path' => 'node/add/employee',
  'router_path' => 'node/add/employee',
  'link_title' => 'Employee',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:18:"Employee node type";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '158',
  'p2' => '189',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '190',
  'plid' => '167',
  'link_path' => 'admin/settings/error-reporting',
  'router_path' => 'admin/settings/error-reporting',
  'link_title' => 'Error reporting',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:93:"Control how Drupal deals with errors including 403/404 errors as well as PHP error reporting.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '190',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '192',
  'plid' => '167',
  'link_path' => 'admin/settings/file-system',
  'router_path' => 'admin/settings/file-system',
  'link_title' => 'File system',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:68:"Tell Drupal where to store uploaded files and how they are accessed.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '192',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '193',
  'plid' => '167',
  'link_path' => 'admin/settings/uploads',
  'router_path' => 'admin/settings/uploads',
  'link_title' => 'File uploads',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:45:"Control how files may be attached to content.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '193',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '194',
  'plid' => '167',
  'link_path' => 'admin/settings/image-toolkit',
  'router_path' => 'admin/settings/image-toolkit',
  'link_title' => 'Image toolkit',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:74:"Choose which image toolkit to use if you have installed optional toolkits.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '194',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '195',
  'plid' => '167',
  'link_path' => 'admin/settings/filters',
  'router_path' => 'admin/settings/filters',
  'link_title' => 'Input formats',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:127:"Configure how content input by users is filtered, including allowed HTML tags. Also allows enabling of module-provided filters.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '195',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '196',
  'plid' => '167',
  'link_path' => 'admin/settings/logging',
  'router_path' => 'admin/settings/logging',
  'link_title' => 'Logging and alerts',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:156:\"Settings for logging and alerts modules. Various modules can route Drupal's system events to different destination, such as syslog, database, email, ...etc.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '196',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '197',
  'plid' => '166',
  'link_path' => 'admin/build/menu',
  'router_path' => 'admin/build/menu',
  'link_title' => 'Menus',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:116:\"Control your site's navigation menu, primary links and secondary links, as well as rename and reorganize menu items.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '197',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '198',
  'plid' => '158',
  'link_path' => 'node/add/test-event',
  'router_path' => 'node/add/test-event',
  'link_title' => 'Migrate test event',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:27:"test event description here";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '158',
  'p2' => '198',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '199',
  'plid' => '158',
  'link_path' => 'node/add/test-page',
  'router_path' => 'node/add/test-page',
  'link_title' => 'Migrate test page',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:296:\"A <em>page</em>, similar in form to a <em>story</em>, is a simple method for creating and displaying information that rarely changes, such as an \"About us\" section of a website. By default, a <em>page</em> entry does not allow visitor comments and is not featured on the site's initial home page.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '158',
  'p2' => '199',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '200',
  'plid' => '158',
  'link_path' => 'node/add/test-planet',
  'router_path' => 'node/add/test-planet',
  'link_title' => 'Migrate test planet',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:392:\"A <em>story</em>, similar in form to a <em>page</em>, is ideal for creating and displaying content that informs or engages website visitors. Press releases, site announcements, and informal blog-like entries may all be created with a <em>story</em> entry. By default, a <em>story</em> entry is automatically featured on the site's initial home page, and provides the ability to post comments.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '158',
  'p2' => '200',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '201',
  'plid' => '158',
  'link_path' => 'node/add/test-story',
  'router_path' => 'node/add/test-story',
  'link_title' => 'Migrate test story',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:392:\"A <em>story</em>, similar in form to a <em>page</em>, is ideal for creating and displaying content that informs or engages website visitors. Press releases, site announcements, and informal blog-like entries may all be created with a <em>story</em> entry. By default, a <em>story</em> entry is automatically featured on the site's initial home page, and provides the ability to post comments.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '158',
  'p2' => '201',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '202',
  'plid' => '166',
  'link_path' => 'admin/build/modules',
  'router_path' => 'admin/build/modules',
  'link_title' => 'Modules',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:47:"Enable or disable add-on modules for your site.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '202',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '203',
  'plid' => '167',
  'link_path' => 'admin/settings/performance',
  'router_path' => 'admin/settings/performance',
  'link_title' => 'Performance',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:101:"Enable or disable page caching for anonymous users and set CSS and JS bandwidth optimization options.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '203',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '204',
  'plid' => '170',
  'link_path' => 'admin/user/permissions',
  'router_path' => 'admin/user/permissions',
  'link_title' => 'Permissions',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:64:"Determine access to features by selecting permissions for roles.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '170',
  'p3' => '204',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '205',
  'plid' => '157',
  'link_path' => 'admin/content/node-settings',
  'router_path' => 'admin/content/node-settings',
  'link_title' => 'Post settings',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:126:"Control posting behavior, such as teaser length, requiring previews before posting, and the number of posts on the front page.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '205',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '206',
  'plid' => '170',
  'link_path' => 'admin/user/profile',
  'router_path' => 'admin/user/profile',
  'link_title' => 'Profiles',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:42:"Create customizable fields for your users.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '170',
  'p3' => '206',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '207',
  'plid' => '157',
  'link_path' => 'admin/content/rss-publishing',
  'router_path' => 'admin/content/rss-publishing',
  'link_title' => 'RSS publishing',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:92:"Configure the number of items per feed and whether feeds should be titles/teasers/full-text.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '207',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '208',
  'plid' => '0',
  'link_path' => 'comment/reply/%',
  'router_path' => 'comment/reply/%',
  'link_title' => 'Reply to comment',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '208',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '209',
  'plid' => '170',
  'link_path' => 'admin/user/roles',
  'router_path' => 'admin/user/roles',
  'link_title' => 'Roles',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:30:"List, edit, or add user roles.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '170',
  'p3' => '209',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '210',
  'plid' => '167',
  'link_path' => 'admin/settings/site-information',
  'router_path' => 'admin/settings/site-information',
  'link_title' => 'Site information',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:107:"Change basic site information, such as the site name, slogan, e-mail address, mission, front page and more.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '210',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '211',
  'plid' => '167',
  'link_path' => 'admin/settings/site-maintenance',
  'router_path' => 'admin/settings/site-maintenance',
  'link_title' => 'Site maintenance',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:63:"Take the site off-line for maintenance or bring it back online.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '211',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '212',
  'plid' => '158',
  'link_path' => 'node/add/sponsor',
  'router_path' => 'node/add/sponsor',
  'link_title' => 'Sponsor',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:17:"Sponsor node type";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '158',
  'p2' => '212',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '213',
  'plid' => '165',
  'link_path' => 'admin/reports/status',
  'router_path' => 'admin/reports/status',
  'link_title' => 'Status report',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:74:\"Get a status report about your site's operation and any detected problems.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '10',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '165',
  'p3' => '213',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '214',
  'plid' => '157',
  'link_path' => 'admin/content/taxonomy',
  'router_path' => 'admin/content/taxonomy',
  'link_title' => 'Taxonomy',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:67:"Manage tagging, categorization, and classification of your content.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '214',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '215',
  'plid' => '0',
  'link_path' => 'taxonomy/term/%',
  'router_path' => 'taxonomy/term/%',
  'link_title' => 'Taxonomy term',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '215',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '216',
  'plid' => '166',
  'link_path' => 'admin/build/themes',
  'router_path' => 'admin/build/themes',
  'link_title' => 'Themes',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:57:"Change which theme your site uses or allows users to set.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '216',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '217',
  'plid' => '170',
  'link_path' => 'admin/user/settings',
  'router_path' => 'admin/user/settings',
  'link_title' => 'User settings',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:101:"Configure default behavior of users, including registration requirements, e-mails, and user pictures.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '170',
  'p3' => '217',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '218',
  'plid' => '170',
  'link_path' => 'admin/user/user',
  'router_path' => 'admin/user/user',
  'link_title' => 'Users',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:26:"List, add, and edit users.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '170',
  'p3' => '218',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '219',
  'plid' => '195',
  'link_path' => 'admin/settings/filters/%',
  'router_path' => 'admin/settings/filters/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '195',
  'p4' => '219',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '220',
  'plid' => '206',
  'link_path' => 'admin/user/profile/add',
  'router_path' => 'admin/user/profile/add',
  'link_title' => 'Add field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '170',
  'p3' => '206',
  'p4' => '220',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '221',
  'plid' => '157',
  'link_path' => 'admin/content/node-type/article',
  'router_path' => 'admin/content/node-type/article',
  'link_title' => 'Article',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '221',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '222',
  'plid' => '180',
  'link_path' => 'admin/settings/clean-urls/check',
  'router_path' => 'admin/settings/clean-urls/check',
  'link_title' => 'Clean URL check',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '180',
  'p4' => '222',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '223',
  'plid' => '157',
  'link_path' => 'admin/content/node-type/company',
  'router_path' => 'admin/content/node-type/company',
  'link_title' => 'Company',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '223',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '224',
  'plid' => '176',
  'link_path' => 'admin/settings/actions/configure',
  'router_path' => 'admin/settings/actions/configure',
  'link_title' => 'Configure an advanced action',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '176',
  'p4' => '224',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '225',
  'plid' => '179',
  'link_path' => 'admin/build/block/configure',
  'router_path' => 'admin/build/block/configure',
  'link_title' => 'Configure block',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '179',
  'p4' => '225',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '226',
  'plid' => '166',
  'link_path' => 'admin/build/menu-customize/%',
  'router_path' => 'admin/build/menu-customize/%',
  'link_title' => 'Customize menu',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '226',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '227',
  'plid' => '186',
  'link_path' => 'admin/settings/date-time/lookup',
  'router_path' => 'admin/settings/date-time/lookup',
  'link_title' => 'Date and time lookup',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '186',
  'p4' => '227',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '228',
  'plid' => '179',
  'link_path' => 'admin/build/block/delete',
  'router_path' => 'admin/build/block/delete',
  'link_title' => 'Delete block',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '179',
  'p4' => '228',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '229',
  'plid' => '206',
  'link_path' => 'admin/user/profile/delete',
  'router_path' => 'admin/user/profile/delete',
  'link_title' => 'Delete field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '170',
  'p3' => '206',
  'p4' => '229',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '230',
  'plid' => '195',
  'link_path' => 'admin/settings/filters/delete',
  'router_path' => 'admin/settings/filters/delete',
  'link_title' => 'Delete input format',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '195',
  'p4' => '230',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '231',
  'plid' => '175',
  'link_path' => 'admin/user/rules/delete',
  'router_path' => 'admin/user/rules/delete',
  'link_title' => 'Delete rule',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '170',
  'p3' => '175',
  'p4' => '231',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '232',
  'plid' => '206',
  'link_path' => 'admin/user/profile/edit',
  'router_path' => 'admin/user/profile/edit',
  'link_title' => 'Edit field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '170',
  'p3' => '206',
  'p4' => '232',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '233',
  'plid' => '209',
  'link_path' => 'admin/user/roles/edit',
  'router_path' => 'admin/user/roles/edit',
  'link_title' => 'Edit role',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '170',
  'p3' => '209',
  'p4' => '233',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '234',
  'plid' => '175',
  'link_path' => 'admin/user/rules/edit',
  'router_path' => 'admin/user/rules/edit',
  'link_title' => 'Edit rule',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '170',
  'p3' => '175',
  'p4' => '234',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '235',
  'plid' => '157',
  'link_path' => 'admin/content/node-type/employee',
  'router_path' => 'admin/content/node-type/employee',
  'link_title' => 'Employee',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '235',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '236',
  'plid' => '214',
  'link_path' => 'admin/content/taxonomy/%',
  'router_path' => 'admin/content/taxonomy/%',
  'link_title' => 'List terms',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '214',
  'p4' => '236',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '237',
  'plid' => '157',
  'link_path' => 'admin/content/node-type/test-event',
  'router_path' => 'admin/content/node-type/test-event',
  'link_title' => 'Migrate test event',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '237',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '238',
  'plid' => '157',
  'link_path' => 'admin/content/node-type/test-page',
  'router_path' => 'admin/content/node-type/test-page',
  'link_title' => 'Migrate test page',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '238',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '239',
  'plid' => '157',
  'link_path' => 'admin/content/node-type/test-planet',
  'router_path' => 'admin/content/node-type/test-planet',
  'link_title' => 'Migrate test planet',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '239',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '240',
  'plid' => '157',
  'link_path' => 'admin/content/node-type/test-story',
  'router_path' => 'admin/content/node-type/test-story',
  'link_title' => 'Migrate test story',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '240',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '241',
  'plid' => '213',
  'link_path' => 'admin/reports/status/php',
  'router_path' => 'admin/reports/status/php',
  'link_title' => 'PHP',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '165',
  'p3' => '213',
  'p4' => '241',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '242',
  'plid' => '206',
  'link_path' => 'admin/user/profile/autocomplete',
  'router_path' => 'admin/user/profile/autocomplete',
  'link_title' => 'Profile category autocomplete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '170',
  'p3' => '206',
  'p4' => '242',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '243',
  'plid' => '205',
  'link_path' => 'admin/content/node-settings/rebuild',
  'router_path' => 'admin/content/node-settings/rebuild',
  'link_title' => 'Rebuild permissions',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '205',
  'p4' => '243',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '244',
  'plid' => '176',
  'link_path' => 'admin/settings/actions/orphan',
  'router_path' => 'admin/settings/actions/orphan',
  'link_title' => 'Remove orphans',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '176',
  'p4' => '244',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '245',
  'plid' => '213',
  'link_path' => 'admin/reports/status/run-cron',
  'router_path' => 'admin/reports/status/run-cron',
  'link_title' => 'Run cron',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '165',
  'p3' => '213',
  'p4' => '245',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '246',
  'plid' => '213',
  'link_path' => 'admin/reports/status/sql',
  'router_path' => 'admin/reports/status/sql',
  'link_title' => 'SQL',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '165',
  'p3' => '213',
  'p4' => '246',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '247',
  'plid' => '157',
  'link_path' => 'admin/content/node-type/sponsor',
  'router_path' => 'admin/content/node-type/sponsor',
  'link_title' => 'Sponsor',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '247',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '248',
  'plid' => '186',
  'link_path' => 'admin/settings/date-time/formats/lookup',
  'router_path' => 'admin/settings/date-time/formats/lookup',
  'link_title' => 'Date and time lookup',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '186',
  'p4' => '248',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '249',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/article/delete',
  'router_path' => 'admin/content/node-type/article/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '249',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '250',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/company/delete',
  'router_path' => 'admin/content/node-type/company/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '250',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '251',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/employee/delete',
  'router_path' => 'admin/content/node-type/employee/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '251',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '252',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/sponsor/delete',
  'router_path' => 'admin/content/node-type/sponsor/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '252',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '253',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/test-event/delete',
  'router_path' => 'admin/content/node-type/test-event/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '253',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '254',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/test-page/delete',
  'router_path' => 'admin/content/node-type/test-page/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '254',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '255',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/test-planet/delete',
  'router_path' => 'admin/content/node-type/test-planet/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '255',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '256',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/test-story/delete',
  'router_path' => 'admin/content/node-type/test-story/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '256',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '257',
  'plid' => '176',
  'link_path' => 'admin/settings/actions/delete/%',
  'router_path' => 'admin/settings/actions/delete/%',
  'link_title' => 'Delete action',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:17:"Delete an action.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '176',
  'p4' => '257',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '258',
  'plid' => '183',
  'link_path' => 'admin/build/contact/delete/%',
  'router_path' => 'admin/build/contact/delete/%',
  'link_title' => 'Delete contact',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '183',
  'p4' => '258',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '259',
  'plid' => '186',
  'link_path' => 'admin/settings/date-time/delete/%',
  'router_path' => 'admin/settings/date-time/delete/%',
  'link_title' => 'Delete date format type',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:52:"Allow users to delete a configured date format type.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '186',
  'p4' => '259',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '260',
  'plid' => '0',
  'link_path' => 'admin/build/menu-customize/%/delete',
  'router_path' => 'admin/build/menu-customize/%/delete',
  'link_title' => 'Delete menu',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '260',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '261',
  'plid' => '183',
  'link_path' => 'admin/build/contact/edit/%',
  'router_path' => 'admin/build/contact/edit/%',
  'link_title' => 'Edit contact category',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '183',
  'p4' => '261',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '262',
  'plid' => '214',
  'link_path' => 'admin/content/taxonomy/edit/term',
  'router_path' => 'admin/content/taxonomy/edit/term',
  'link_title' => 'Edit term',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '214',
  'p4' => '262',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '263',
  'plid' => '179',
  'link_path' => 'admin/build/block/list/js',
  'router_path' => 'admin/build/block/list/js',
  'link_title' => 'JavaScript List Form',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '179',
  'p4' => '263',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '264',
  'plid' => '202',
  'link_path' => 'admin/build/modules/list/confirm',
  'router_path' => 'admin/build/modules/list/confirm',
  'link_title' => 'List',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '202',
  'p4' => '264',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '266',
  'plid' => '0',
  'link_path' => 'user/reset/%/%/%',
  'router_path' => 'user/reset/%/%/%',
  'link_title' => 'Reset password',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '266',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '267',
  'plid' => '202',
  'link_path' => 'admin/build/modules/uninstall/confirm',
  'router_path' => 'admin/build/modules/uninstall/confirm',
  'link_title' => 'Uninstall',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '202',
  'p4' => '267',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '269',
  'plid' => '0',
  'link_path' => 'node/%/revisions/%/delete',
  'router_path' => 'node/%/revisions/%/delete',
  'link_title' => 'Delete earlier revision',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '269',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '270',
  'plid' => '0',
  'link_path' => 'node/%/revisions/%/revert',
  'router_path' => 'node/%/revisions/%/revert',
  'link_title' => 'Revert to earlier revision',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '270',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '271',
  'plid' => '0',
  'link_path' => 'node/%/revisions/%/view',
  'router_path' => 'node/%/revisions/%/view',
  'link_title' => 'Revisions',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '271',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '272',
  'plid' => '186',
  'link_path' => 'admin/settings/date-time/formats/delete/%',
  'router_path' => 'admin/settings/date-time/formats/delete/%',
  'link_title' => 'Delete date format',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:47:"Allow users to delete a configured date format.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '186',
  'p4' => '272',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '273',
  'plid' => '197',
  'link_path' => 'admin/build/menu/item/%/delete',
  'router_path' => 'admin/build/menu/item/%/delete',
  'link_title' => 'Delete menu item',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '197',
  'p4' => '273',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '276',
  'plid' => '197',
  'link_path' => 'admin/build/menu/item/%/edit',
  'router_path' => 'admin/build/menu/item/%/edit',
  'link_title' => 'Edit menu item',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '197',
  'p4' => '276',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '277',
  'plid' => '214',
  'link_path' => 'admin/content/taxonomy/edit/vocabulary/%',
  'router_path' => 'admin/content/taxonomy/edit/vocabulary/%',
  'link_title' => 'Edit vocabulary',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '214',
  'p4' => '277',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '278',
  'plid' => '197',
  'link_path' => 'admin/build/menu/item/%/reset',
  'router_path' => 'admin/build/menu/item/%/reset',
  'link_title' => 'Reset menu item',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '197',
  'p4' => '278',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '299',
  'plid' => '0',
  'link_path' => 'event',
  'router_path' => 'event',
  'link_title' => 'Events',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '299',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '300',
  'plid' => '299',
  'link_path' => 'event/dst',
  'router_path' => 'event/dst',
  'link_title' => 'Event dst view',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '299',
  'p2' => '300',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '301',
  'plid' => '299',
  'link_path' => 'event/ical',
  'router_path' => 'event/ical',
  'link_title' => 'Event ical feed',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '299',
  'p2' => '301',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '302',
  'plid' => '299',
  'link_path' => 'event/feed',
  'router_path' => 'event/feed',
  'link_title' => 'Event rss feed',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '299',
  'p2' => '302',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '303',
  'plid' => '299',
  'link_path' => 'event/type',
  'router_path' => 'event/type',
  'link_title' => 'Filter by content type',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '299',
  'p2' => '303',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '304',
  'plid' => '299',
  'link_path' => 'event/term',
  'router_path' => 'event/term',
  'link_title' => 'Filter by taxonomy',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '299',
  'p2' => '304',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '305',
  'plid' => '0',
  'link_path' => 'node/%/ical',
  'router_path' => 'node/%/ical',
  'link_title' => 'Event ical',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '305',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '306',
  'plid' => '167',
  'link_path' => 'admin/settings/event',
  'router_path' => 'admin/settings/event',
  'link_title' => 'Events',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:36:"Set up how your site handles events.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '306',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '307',
  'plid' => '306',
  'link_path' => 'admin/settings/event/overview',
  'router_path' => 'admin/settings/event/overview',
  'link_title' => 'Event overview',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:50:"Change how event summary information is displayed.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '306',
  'p4' => '307',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '308',
  'plid' => '306',
  'link_path' => 'admin/settings/event/timezone',
  'router_path' => 'admin/settings/event/timezone',
  'link_title' => 'Timezone handling',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:55:"Change how timezone information is saved and displayed.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '306',
  'p4' => '308',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '309',
  'plid' => '158',
  'link_path' => 'node/add/story',
  'router_path' => 'node/add/story',
  'link_title' => 'Story',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:392:\"A <em>story</em>, similar in form to a <em>page</em>, is ideal for creating and displaying content that informs or engages website visitors. Press releases, site announcements, and informal blog-like entries may all be created with a <em>story</em> entry. By default, a <em>story</em> entry is automatically featured on the site's initial home page, and provides the ability to post comments.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '158',
  'p2' => '309',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '310',
  'plid' => '157',
  'link_path' => 'admin/content/node-type/story',
  'router_path' => 'admin/content/node-type/story',
  'link_title' => 'Story',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '310',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '311',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/delete',
  'router_path' => 'admin/content/node-type/story/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '311',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '328',
  'plid' => '0',
  'link_path' => 'filefield/progress',
  'router_path' => 'filefield/progress',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '328',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '329',
  'plid' => '0',
  'link_path' => 'filefield/ahah/%/%/%',
  'router_path' => 'filefield/ahah/%/%/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '329',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '333',
  'plid' => '167',
  'link_path' => 'admin/settings/email',
  'router_path' => 'admin/settings/email',
  'link_title' => 'CCK Email Contact Form Settings',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:57:"Administer flood control settings for email contact forms";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '333',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '334',
  'plid' => '0',
  'link_path' => 'email/%/%',
  'router_path' => 'email/%/%',
  'link_title' => 'Email Contact Form',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '334',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '350',
  'plid' => '0',
  'link_path' => 'aggregator',
  'router_path' => 'aggregator',
  'link_title' => 'Feed aggregator',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '5',
  'depth' => '1',
  'customized' => '0',
  'p1' => '350',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '351',
  'plid' => '350',
  'link_path' => 'aggregator/categories',
  'router_path' => 'aggregator/categories',
  'link_title' => 'Categories',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '350',
  'p2' => '351',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '352',
  'plid' => '350',
  'link_path' => 'aggregator/opml',
  'router_path' => 'aggregator/opml',
  'link_title' => 'OPML feed',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '350',
  'p2' => '352',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '353',
  'plid' => '350',
  'link_path' => 'aggregator/rss',
  'router_path' => 'aggregator/rss',
  'link_title' => 'RSS feed',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '350',
  'p2' => '353',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '354',
  'plid' => '350',
  'link_path' => 'aggregator/sources',
  'router_path' => 'aggregator/sources',
  'link_title' => 'Sources',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '350',
  'p2' => '354',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '355',
  'plid' => '351',
  'link_path' => 'aggregator/categories/%',
  'router_path' => 'aggregator/categories/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '350',
  'p2' => '351',
  'p3' => '355',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '356',
  'plid' => '354',
  'link_path' => 'aggregator/sources/%',
  'router_path' => 'aggregator/sources/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '350',
  'p2' => '354',
  'p3' => '356',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '357',
  'plid' => '157',
  'link_path' => 'admin/content/aggregator',
  'router_path' => 'admin/content/aggregator',
  'link_title' => 'Feed aggregator',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:116:\"Configure which content your site aggregates from other sites, how often it polls them, and how they're categorized.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '357',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '358',
  'plid' => '357',
  'link_path' => 'admin/content/aggregator/remove/%',
  'router_path' => 'admin/content/aggregator/remove/%',
  'link_title' => 'Remove items',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '357',
  'p4' => '358',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '359',
  'plid' => '357',
  'link_path' => 'admin/content/aggregator/update/%',
  'router_path' => 'admin/content/aggregator/update/%',
  'link_title' => 'Update items',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '357',
  'p4' => '359',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '360',
  'plid' => '357',
  'link_path' => 'admin/content/aggregator/edit/category/%',
  'router_path' => 'admin/content/aggregator/edit/category/%',
  'link_title' => 'Edit category',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '357',
  'p4' => '360',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '361',
  'plid' => '357',
  'link_path' => 'admin/content/aggregator/edit/feed/%',
  'router_path' => 'admin/content/aggregator/edit/feed/%',
  'link_title' => 'Edit feed',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '357',
  'p4' => '361',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '363',
  'plid' => '0',
  'link_path' => 'book',
  'router_path' => 'book',
  'link_title' => 'Books',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '363',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '364',
  'plid' => '363',
  'link_path' => 'book/js/form',
  'router_path' => 'book/js/form',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '363',
  'p2' => '364',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '366',
  'plid' => '157',
  'link_path' => 'admin/content/book',
  'router_path' => 'admin/content/book',
  'link_title' => 'Books',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:33:\"Manage your site's book outlines.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '366',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '367',
  'plid' => '363',
  'link_path' => 'book/export/%/%',
  'router_path' => 'book/export/%/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '363',
  'p2' => '367',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '369',
  'plid' => '366',
  'link_path' => 'admin/content/book/%',
  'router_path' => 'admin/content/book/%',
  'link_title' => 'Re-order book pages and change titles',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '366',
  'p4' => '369',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '370',
  'plid' => '0',
  'link_path' => 'node/%/outline/remove',
  'router_path' => 'node/%/outline/remove',
  'link_title' => 'Remove from outline',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '370',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'secondary-links',
  'mlid' => '393',
  'plid' => '0',
  'link_path' => 'user/login',
  'router_path' => 'user/login',
  'link_title' => 'Test 3',
  'options' => 'a:0:{}',
  'module' => 'menu',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '-47',
  'depth' => '1',
  'customized' => '1',
  'p1' => '393',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '394',
  'plid' => '166',
  'link_path' => 'admin/build/path',
  'router_path' => 'admin/build/path',
  'link_title' => 'URL aliases',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:46:\"Change your site's URL paths by aliasing them.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '394',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '395',
  'plid' => '394',
  'link_path' => 'admin/build/path/delete',
  'router_path' => 'admin/build/path/delete',
  'link_title' => 'Delete alias',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '394',
  'p4' => '395',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '396',
  'plid' => '394',
  'link_path' => 'admin/build/path/edit',
  'router_path' => 'admin/build/path/edit',
  'link_title' => 'Edit alias',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '394',
  'p4' => '396',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '397',
  'plid' => '0',
  'link_path' => 'system/files/imagecache',
  'router_path' => 'system/files/imagecache',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '397',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '398',
  'plid' => '167',
  'link_path' => 'admin/settings/imageapi',
  'router_path' => 'admin/settings/imageapi',
  'link_title' => 'ImageAPI',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:19:"Configure ImageAPI.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '398',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '399',
  'plid' => '167',
  'link_path' => 'admin/settings/language',
  'router_path' => 'admin/settings/language',
  'link_title' => 'Languages',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:55:"Configure languages for content and the user interface.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '399',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '400',
  'plid' => '166',
  'link_path' => 'admin/build/translate',
  'router_path' => 'admin/build/translate',
  'link_title' => 'Translate interface',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:59:"Translate the built in interface and optionally other text.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '400',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '401',
  'plid' => '399',
  'link_path' => 'admin/settings/language/delete/%',
  'router_path' => 'admin/settings/language/delete/%',
  'link_title' => 'Confirm',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '399',
  'p4' => '401',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '403',
  'plid' => '400',
  'link_path' => 'admin/build/translate/delete/%',
  'router_path' => 'admin/build/translate/delete/%',
  'link_title' => 'Delete string',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '400',
  'p4' => '403',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '404',
  'plid' => '399',
  'link_path' => 'admin/settings/language/edit/%',
  'router_path' => 'admin/settings/language/edit/%',
  'link_title' => 'Edit language',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '399',
  'p4' => '404',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '405',
  'plid' => '400',
  'link_path' => 'admin/build/translate/edit/%',
  'router_path' => 'admin/build/translate/edit/%',
  'link_title' => 'Edit string',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '166',
  'p3' => '400',
  'p4' => '405',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '407',
  'plid' => '0',
  'link_path' => 'i18nstrings/save',
  'router_path' => 'i18nstrings/save',
  'link_title' => 'Save string',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '407',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '408',
  'plid' => '0',
  'link_path' => 'i18n/node/autocomplete',
  'router_path' => 'i18n/node/autocomplete',
  'link_title' => 'Node title autocomplete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '408',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '411',
  'plid' => '0',
  'link_path' => 'core/tests/fixtures/files/imagecache',
  'router_path' => 'core/tests/fixtures/files/imagecache',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '411',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '412',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/fields/field_test/remove',
  'router_path' => 'admin/content/node-type/story/fields/field_test/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '412',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '413',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/fields/field_test_date/remove',
  'router_path' => 'admin/content/node-type/story/fields/field_test_date/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '413',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '414',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/fields/field_test_datestamp/remove',
  'router_path' => 'admin/content/node-type/story/fields/field_test_datestamp/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '414',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '415',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/fields/field_test_datetime/remove',
  'router_path' => 'admin/content/node-type/story/fields/field_test_datetime/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '415',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '416',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/fields/field_test_decimal_radio_buttons/remove',
  'router_path' => 'admin/content/node-type/story/fields/field_test_decimal_radio_buttons/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '416',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '417',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/fields/field_test_email/remove',
  'router_path' => 'admin/content/node-type/story/fields/field_test_email/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '417',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '418',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/fields/field_test_exclude_unset/remove',
  'router_path' => 'admin/content/node-type/story/fields/field_test_exclude_unset/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '418',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '419',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/fields/field_test_filefield/remove',
  'router_path' => 'admin/content/node-type/story/fields/field_test_filefield/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '419',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '420',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/fields/field_test_float_single_checkbox/remove',
  'router_path' => 'admin/content/node-type/story/fields/field_test_float_single_checkbox/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '420',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '421',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/fields/field_test_four/remove',
  'router_path' => 'admin/content/node-type/story/fields/field_test_four/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '421',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '422',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/fields/field_test_identical1/remove',
  'router_path' => 'admin/content/node-type/story/fields/field_test_identical1/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '422',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '423',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/fields/field_test_identical2/remove',
  'router_path' => 'admin/content/node-type/story/fields/field_test_identical2/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '423',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '424',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/fields/field_test_imagefield/remove',
  'router_path' => 'admin/content/node-type/story/fields/field_test_imagefield/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '424',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '425',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/fields/field_test_integer_selectlist/remove',
  'router_path' => 'admin/content/node-type/story/fields/field_test_integer_selectlist/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '425',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '426',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/fields/field_test_link/remove',
  'router_path' => 'admin/content/node-type/story/fields/field_test_link/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '426',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '427',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/fields/field_test_phone/remove',
  'router_path' => 'admin/content/node-type/story/fields/field_test_phone/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '427',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '428',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/fields/field_test_text_single_checkbox/remove',
  'router_path' => 'admin/content/node-type/story/fields/field_test_text_single_checkbox/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '428',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '429',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/fields/field_test_text_single_checkbox2/remove',
  'router_path' => 'admin/content/node-type/story/fields/field_test_text_single_checkbox2/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '429',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '430',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/fields/field_test_three/remove',
  'router_path' => 'admin/content/node-type/story/fields/field_test_three/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '430',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '431',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/fields/field_test_two/remove',
  'router_path' => 'admin/content/node-type/story/fields/field_test_two/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '431',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '432',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/test-page/fields/field_test/remove',
  'router_path' => 'admin/content/node-type/test-page/fields/field_test/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '432',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '433',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/test-planet/fields/field_multivalue/remove',
  'router_path' => 'admin/content/node-type/test-planet/fields/field_multivalue/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '433',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '434',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/test-planet/fields/field_test_text_single_checkbox/remove',
  'router_path' => 'admin/content/node-type/test-planet/fields/field_test_text_single_checkbox/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '434',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '438',
  'plid' => '167',
  'link_path' => 'admin/settings/variable',
  'router_path' => 'admin/settings/variable',
  'link_title' => 'Variables',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:31:"Edit and delete site variables.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '1',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '438',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '439',
  'plid' => '438',
  'link_path' => 'admin/settings/variable/edit/%',
  'router_path' => 'admin/settings/variable/edit/%',
  'link_title' => 'Edit variable',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '438',
  'p4' => '439',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '440',
  'plid' => '438',
  'link_path' => 'admin/settings/variable/group/%',
  'router_path' => 'admin/settings/variable/group/%',
  'link_title' => 'Variables group',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:32:"Edit and delete group variables.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '167',
  'p3' => '438',
  'p4' => '440',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '441',
  'plid' => '0',
  'link_path' => 'forum',
  'router_path' => 'forum',
  'link_title' => 'Forums',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '441',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '442',
  'plid' => '165',
  'link_path' => 'admin/reports/settings',
  'router_path' => 'admin/reports/settings',
  'link_title' => 'Access log settings',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:50:"Control details about what and how your site logs.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '3',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '165',
  'p3' => '442',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '443',
  'plid' => '158',
  'link_path' => 'node/add/forum',
  'router_path' => 'node/add/forum',
  'link_title' => 'Forum topic',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:85:"A <em>forum topic</em> is the initial post to a new discussion thread within a forum.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '158',
  'p2' => '443',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '444',
  'plid' => '157',
  'link_path' => 'admin/content/forum',
  'router_path' => 'admin/content/forum',
  'link_title' => 'Forums',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:61:"Control forums and their hierarchy and change forum settings.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '444',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '445',
  'plid' => '165',
  'link_path' => 'admin/reports/hits',
  'router_path' => 'admin/reports/hits',
  'link_title' => 'Recent hits',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:43:"View pages that have recently been visited.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '165',
  'p3' => '445',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '446',
  'plid' => '165',
  'link_path' => 'admin/reports/pages',
  'router_path' => 'admin/reports/pages',
  'link_title' => 'Top pages',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:41:"View pages that have been hit frequently.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '1',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '165',
  'p3' => '446',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '447',
  'plid' => '165',
  'link_path' => 'admin/reports/referrers',
  'router_path' => 'admin/reports/referrers',
  'link_title' => 'Top referrers',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:19:"View top referrers.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '165',
  'p3' => '447',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '448',
  'plid' => '165',
  'link_path' => 'admin/reports/visitors',
  'router_path' => 'admin/reports/visitors',
  'link_title' => 'Top visitors',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:34:"View visitors that hit many pages.";}}',
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '2',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '165',
  'p3' => '448',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '449',
  'plid' => '165',
  'link_path' => 'admin/reports/access/%',
  'router_path' => 'admin/reports/access/%',
  'link_title' => 'Details',
  'options' => 'a:1:{s:10:"attributes";a:1:{s:5:"title";s:16:"View access log.";}}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '165',
  'p3' => '449',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '450',
  'plid' => '157',
  'link_path' => 'admin/content/node-type/forum',
  'router_path' => 'admin/content/node-type/forum',
  'link_title' => 'Forum topic',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '450',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '451',
  'plid' => '444',
  'link_path' => 'admin/content/forum/edit/%',
  'router_path' => 'admin/content/forum/edit/%',
  'link_title' => '',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '444',
  'p4' => '451',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '452',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/forum/delete',
  'router_path' => 'admin/content/node-type/forum/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '452',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '453',
  'plid' => '444',
  'link_path' => 'admin/content/forum/edit/container/%',
  'router_path' => 'admin/content/forum/edit/container/%',
  'link_title' => 'Edit container',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '444',
  'p4' => '453',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '454',
  'plid' => '444',
  'link_path' => 'admin/content/forum/edit/forum/%',
  'router_path' => 'admin/content/forum/edit/forum/%',
  'link_title' => 'Edit forum',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '4',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '444',
  'p4' => '454',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '455',
  'plid' => '0',
  'link_path' => 'nodereference/autocomplete',
  'router_path' => 'nodereference/autocomplete',
  'link_title' => 'Nodereference autocomplete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '455',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '456',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/employee/fields/field_company/remove',
  'router_path' => 'admin/content/node-type/employee/fields/field_company/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '456',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '457',
  'plid' => '0',
  'link_path' => 'userreference/autocomplete',
  'router_path' => 'userreference/autocomplete',
  'link_title' => 'Userreference autocomplete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '457',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '458',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/employee/fields/field_commander/remove',
  'router_path' => 'admin/content/node-type/employee/fields/field_commander/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '458',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'primary-links',
  'mlid' => '459',
  'plid' => '0',
  'link_path' => 'node/10',
  'router_path' => 'node/%',
  'link_title' => 'The Real McCoy',
  'options' => 'a:2:{s:10:"attributes";a:1:{s:5:"title";s:0:"";}s:5:"alter";b:1;}',
  'module' => 'menu',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '1',
  'p1' => '459',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'primary-links',
  'mlid' => '460',
  'plid' => '0',
  'link_path' => 'node/11',
  'router_path' => 'node/%',
  'link_title' => 'Le Vrai McCoy',
  'options' => 'a:2:{s:10:"attributes";a:1:{s:5:"title";s:0:"";}s:5:"alter";b:1;}',
  'module' => 'menu',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '1',
  'p1' => '460',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'primary-links',
  'mlid' => '461',
  'plid' => '0',
  'link_path' => 'node/12',
  'router_path' => 'node/%',
  'link_title' => 'Abantu zulu',
  'options' => 'a:2:{s:10:"attributes";a:1:{s:5:"title";s:0:"";}s:5:"alter";b:1;}',
  'module' => 'menu',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '1',
  'p1' => '461',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'primary-links',
  'mlid' => '462',
  'plid' => '0',
  'link_path' => 'node/13',
  'router_path' => 'node/%',
  'link_title' => 'The Zulu People',
  'options' => 'a:2:{s:10:"attributes";a:1:{s:5:"title";s:0:"";}s:5:"alter";b:1;}',
  'module' => 'menu',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '1',
  'p1' => '462',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'secondary-links',
  'mlid' => '463',
  'plid' => '139',
  'link_path' => 'user/login',
  'router_path' => 'user/login',
  'link_title' => 'fr - Test 1',
  'options' => 'a:3:{s:10:"attributes";a:1:{s:5:"title";s:21:"fr - Test menu link 1";}s:8:"langcode";s:2:"fr";s:5:"alter";b:1;}',
  'module' => 'menu',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '-49',
  'depth' => '2',
  'customized' => '1',
  'p1' => '139',
  'p2' => '459',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '464',
  'plid' => '158',
  'link_path' => 'node/add/page',
  'router_path' => 'node/add/page',
  'link_title' => 'Page',
  'options' => "a:1:{s:10:\"attributes\";a:1:{s:5:\"title\";s:296:\"A <em>page</em>, similar in form to a <em>story</em>, is a simple method for creating and displaying information that rarely changes, such as an \"About us\" section of a website. By default, a <em>page</em> entry does not allow visitor comments and is not featured on the site's initial home page.\";}}",
  'module' => 'system',
  'hidden' => '0',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '2',
  'customized' => '0',
  'p1' => '158',
  'p2' => '464',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '465',
  'plid' => '157',
  'link_path' => 'admin/content/node-type/page',
  'router_path' => 'admin/content/node-type/page',
  'link_title' => 'Page',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '3',
  'customized' => '0',
  'p1' => '144',
  'p2' => '157',
  'p3' => '465',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '466',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/page/delete',
  'router_path' => 'admin/content/node-type/page/delete',
  'link_title' => 'Delete',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '466',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '467',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/employee/fields/field_company_2/remove',
  'router_path' => 'admin/content/node-type/employee/fields/field_company_2/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '467',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '468',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/employee/fields/field_company_3/remove',
  'router_path' => 'admin/content/node-type/employee/fields/field_company_3/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '468',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '469',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/page/fields/field_reference/remove',
  'router_path' => 'admin/content/node-type/page/fields/field_reference/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '469',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '470',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/page/fields/field_reference_2/remove',
  'router_path' => 'admin/content/node-type/page/fields/field_reference_2/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '470',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->values(array(
  'menu_name' => 'navigation',
  'mlid' => '471',
  'plid' => '0',
  'link_path' => 'admin/content/node-type/story/fields/field_test_string_selectlist/remove',
  'router_path' => 'admin/content/node-type/story/fields/field_test_string_selectlist/remove',
  'link_title' => 'Remove field',
  'options' => 'a:0:{}',
  'module' => 'system',
  'hidden' => '-1',
  'external' => '0',
  'has_children' => '0',
  'expanded' => '0',
  'weight' => '0',
  'depth' => '1',
  'customized' => '0',
  'p1' => '471',
  'p2' => '0',
  'p3' => '0',
  'p4' => '0',
  'p5' => '0',
  'p6' => '0',
  'p7' => '0',
  'p8' => '0',
  'p9' => '0',
  'updated' => '0',
))
->execute();
$connection->schema()->createTable('menu_router', array(
  'fields' => array(
    'path' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'load_functions' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'to_arg_functions' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'access_callback' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'access_arguments' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'page_callback' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'page_arguments' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
    'fit' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'number_parts' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'tab_parent' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'tab_root' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'title' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'title_callback' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'title_arguments' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'type' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'block_callback' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'description' => array(
      'type' => 'text',
      'not null' => TRUE,
      'size' => 'normal',
    ),
    'position' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'weight' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ),
    'file' => array(
      'type' => 'text',
      'not null' => FALSE,
      'size' => 'normal',
    ),
  ),
  'primary key' => array(
    'path',
  ),
  'mysql_character_set' => 'utf8',
));

$connection->insert('menu_router')
->fields(array(
  'path',
  'load_functions',
  'to_arg_functions',
  'access_callback',
  'access_arguments',
  'page_callback',
  'page_arguments',
  'fit',
  'number_parts',
  'tab_parent',
  'tab_root',
  'title',
  'title_callback',
  'title_arguments',
  'type',
  'block_callback',
  'description',
  'position',
  'weight',
  'file',
))
->values(array(
  'path' => 'admin',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_main_admin_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '1',
  'number_parts' => '1',
  'tab_parent' => '',
  'tab_root' => 'admin',
  'title' => 'Administer',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '9',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'admin/build',
  'title' => 'Site building',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Control how your site looks and feels.',
  'position' => 'right',
  'weight' => '-10',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build/block',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:0:{}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/build/block',
  'title' => 'Blocks',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => "Configure what block content appears in your site's sidebars and other regions.",
  'position' => '',
  'weight' => '0',
  'file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/build/block/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:20:"block_add_block_form";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/block',
  'tab_root' => 'admin/build/block',
  'title' => 'Add block',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/build/block/configure',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:21:"block_admin_configure";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/build/block/configure',
  'title' => 'Configure block',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/build/block/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:16:"block_box_delete";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/build/block/delete',
  'title' => 'Delete block',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/build/block/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/block',
  'tab_root' => 'admin/build/block',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/build/block/list/bluemarine',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:33:"themes/bluemarine/bluemarine.info";s:4:"name";s:10:"bluemarine";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"0";s:8:"throttle";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:13:{s:4:"name";s:10:"Bluemarine";s:11:"description";s:66:"Table-based multi-column theme with a marine and ash color scheme.";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:6:"engine";s:11:"phptemplate";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1456343372";s:7:"regions";a:5:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";}s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:27:"themes/bluemarine/style.css";}}s:7:"scripts";a:1:{s:9:"script.js";s:27:"themes/bluemarine/script.js";}s:10:"screenshot";s:32:"themes/bluemarine/screenshot.png";s:3:"php";s:5:"4.3.5";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:27:"themes/bluemarine/style.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:1:{i:0;s:10:"bluemarine";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/block/list',
  'tab_root' => 'admin/build/block',
  'title' => 'Bluemarine',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/build/block/list/chameleon',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":11:{s:8:"filename";s:31:"themes/chameleon/chameleon.info";s:4:"name";s:9:"chameleon";s:4:"type";s:5:"theme";s:5:"owner";s:32:"themes/chameleon/chameleon.theme";s:6:"status";s:1:"0";s:8:"throttle";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:12:{s:4:"name";s:9:"Chameleon";s:11:"description";s:42:"Minimalist tabled theme with light colors.";s:7:"regions";a:2:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";}s:8:"features";a:4:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";}s:11:"stylesheets";a:1:{s:3:"all";a:2:{s:9:"style.css";s:26:"themes/chameleon/style.css";s:10:"common.css";s:27:"themes/chameleon/common.css";}}s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1456343372";s:7:"scripts";a:1:{s:9:"script.js";s:26:"themes/chameleon/script.js";}s:10:"screenshot";s:31:"themes/chameleon/screenshot.png";s:3:"php";s:5:"4.3.5";}s:11:"stylesheets";a:1:{s:3:"all";a:2:{s:9:"style.css";s:26:"themes/chameleon/style.css";s:10:"common.css";s:27:"themes/chameleon/common.css";}}}}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:1:{i:0;s:9:"chameleon";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/block/list',
  'tab_root' => 'admin/build/block',
  'title' => 'Chameleon',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/build/block/list/garland',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:27:"themes/garland/garland.info";s:4:"name";s:7:"garland";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"1";s:8:"throttle";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:13:{s:4:"name";s:7:"Garland";s:11:"description";s:66:"Tableless, recolorable, multi-column, fluid width theme (default).";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:6:"engine";s:11:"phptemplate";s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1456343372";s:7:"regions";a:5:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";}s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:7:"scripts";a:1:{s:9:"script.js";s:24:"themes/garland/script.js";}s:10:"screenshot";s:29:"themes/garland/screenshot.png";s:3:"php";s:5:"4.3.5";}s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:1:{i:0;s:7:"garland";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/block/list',
  'tab_root' => 'admin/build/block',
  'title' => 'Garland',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/build/block/list/js',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer blocks";}',
  'page_callback' => 'block_admin_display_js',
  'page_arguments' => 'a:0:{}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/build/block/list/js',
  'title' => 'JavaScript List Form',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/build/block/list/marvin',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:35:"themes/chameleon/marvin/marvin.info";s:4:"name";s:6:"marvin";s:4:"type";s:5:"theme";s:5:"owner";s:0:"";s:6:"status";s:1:"0";s:8:"throttle";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:13:{s:4:"name";s:6:"Marvin";s:11:"description";s:31:"Boxy tabled theme in all grays.";s:7:"regions";a:2:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";}s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:10:"base theme";s:9:"chameleon";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1456343372";s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:33:"themes/chameleon/marvin/style.css";}}s:7:"scripts";a:1:{s:9:"script.js";s:33:"themes/chameleon/marvin/script.js";}s:10:"screenshot";s:38:"themes/chameleon/marvin/screenshot.png";s:3:"php";s:5:"4.3.5";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:33:"themes/chameleon/marvin/style.css";}}s:10:"base_theme";s:9:"chameleon";}}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:1:{i:0;s:6:"marvin";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/block/list',
  'tab_root' => 'admin/build/block',
  'title' => 'Marvin',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/build/block/list/minnelli',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":13:{s:8:"filename";s:37:"themes/garland/minnelli/minnelli.info";s:4:"name";s:8:"minnelli";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"0";s:8:"throttle";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:14:{s:4:"name";s:8:"Minnelli";s:11:"description";s:56:"Tableless, recolorable, multi-column, fixed width theme.";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:10:"base theme";s:7:"garland";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:12:"minnelli.css";s:36:"themes/garland/minnelli/minnelli.css";}}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1456343372";s:7:"regions";a:5:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";}s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:7:"scripts";a:1:{s:9:"script.js";s:33:"themes/garland/minnelli/script.js";}s:10:"screenshot";s:38:"themes/garland/minnelli/screenshot.png";s:3:"php";s:5:"4.3.5";s:6:"engine";s:11:"phptemplate";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:12:"minnelli.css";s:36:"themes/garland/minnelli/minnelli.css";}}s:6:"engine";s:11:"phptemplate";s:10:"base_theme";s:7:"garland";}}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:1:{i:0;s:8:"minnelli";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/block/list',
  'tab_root' => 'admin/build/block',
  'title' => 'Minnelli',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/build/block/list/pushbutton',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_block_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:33:"themes/pushbutton/pushbutton.info";s:4:"name";s:10:"pushbutton";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"0";s:8:"throttle";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:13:{s:4:"name";s:10:"Pushbutton";s:11:"description";s:52:"Tabled, multi-column theme in blue and orange tones.";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:6:"engine";s:11:"phptemplate";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1456343372";s:7:"regions";a:5:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";}s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:27:"themes/pushbutton/style.css";}}s:7:"scripts";a:1:{s:9:"script.js";s:27:"themes/pushbutton/script.js";}s:10:"screenshot";s:32:"themes/pushbutton/screenshot.png";s:3:"php";s:5:"4.3.5";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:27:"themes/pushbutton/style.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'block_admin_display',
  'page_arguments' => 'a:1:{i:0;s:10:"pushbutton";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/block/list',
  'tab_root' => 'admin/build/block',
  'title' => 'Pushbutton',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/block/block.admin.inc',
))
->values(array(
  'path' => 'admin/build/contact',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:33:"administer site-wide contact form";}',
  'page_callback' => 'contact_admin_categories',
  'page_arguments' => 'a:0:{}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/build/contact',
  'title' => 'Contact form',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Create a system contact form and set up categories for the form to use.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/contact/contact.admin.inc',
))
->values(array(
  'path' => 'admin/build/contact/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:33:"administer site-wide contact form";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:18:"contact_admin_edit";i:1;i:3;}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/contact',
  'tab_root' => 'admin/build/contact',
  'title' => 'Add category',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'modules/contact/contact.admin.inc',
))
->values(array(
  'path' => 'admin/build/contact/delete/%',
  'load_functions' => 'a:1:{i:4;s:12:"contact_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:33:"administer site-wide contact form";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:20:"contact_admin_delete";i:1;i:4;}',
  'fit' => '30',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/build/contact/delete/%',
  'title' => 'Delete contact',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/contact/contact.admin.inc',
))
->values(array(
  'path' => 'admin/build/contact/edit/%',
  'load_functions' => 'a:1:{i:4;s:12:"contact_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:33:"administer site-wide contact form";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:18:"contact_admin_edit";i:1;i:3;i:2;i:4;}',
  'fit' => '30',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/build/contact/edit/%',
  'title' => 'Edit contact category',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/contact/contact.admin.inc',
))
->values(array(
  'path' => 'admin/build/contact/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:33:"administer site-wide contact form";}',
  'page_callback' => 'contact_admin_categories',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/contact',
  'tab_root' => 'admin/build/contact',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/contact/contact.admin.inc',
))
->values(array(
  'path' => 'admin/build/contact/settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:33:"administer site-wide contact form";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:22:"contact_admin_settings";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/contact',
  'tab_root' => 'admin/build/contact',
  'title' => 'Settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'file' => 'modules/contact/contact.admin.inc',
))
->values(array(
  'path' => 'admin/build/menu',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'menu_overview_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/build/menu',
  'title' => 'Menus',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => "Control your site's navigation menu, primary links and secondary links, as well as rename and reorganize menu items.",
  'position' => '',
  'weight' => '0',
  'file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/build/menu-customize/%',
  'load_functions' => 'a:1:{i:3;s:9:"menu_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:18:"menu_overview_form";i:1;i:3;}',
  'fit' => '14',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/build/menu-customize/%',
  'title' => 'Customize menu',
  'title_callback' => 'menu_overview_title',
  'title_arguments' => 'a:1:{i:0;i:3;}',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/build/menu-customize/%/add',
  'load_functions' => 'a:1:{i:3;s:9:"menu_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:14:"menu_edit_item";i:1;s:3:"add";i:2;N;i:3;i:3;}',
  'fit' => '29',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/menu-customize/%',
  'tab_root' => 'admin/build/menu-customize/%',
  'title' => 'Add item',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/build/menu-customize/%/delete',
  'load_functions' => 'a:1:{i:3;s:9:"menu_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'menu_delete_menu_page',
  'page_arguments' => 'a:1:{i:0;i:3;}',
  'fit' => '29',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/build/menu-customize/%/delete',
  'title' => 'Delete menu',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/build/menu-customize/%/edit',
  'load_functions' => 'a:1:{i:3;s:9:"menu_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:14:"menu_edit_menu";i:1;s:4:"edit";i:2;i:3;}',
  'fit' => '29',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/menu-customize/%',
  'tab_root' => 'admin/build/menu-customize/%',
  'title' => 'Edit menu',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/build/menu-customize/%/list',
  'load_functions' => 'a:1:{i:3;s:9:"menu_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:18:"menu_overview_form";i:1;i:3;}',
  'fit' => '29',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/menu-customize/%',
  'tab_root' => 'admin/build/menu-customize/%',
  'title' => 'List items',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/build/menu/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:14:"menu_edit_menu";i:1;s:3:"add";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/menu',
  'tab_root' => 'admin/build/menu',
  'title' => 'Add menu',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/build/menu/item/%/delete',
  'load_functions' => 'a:1:{i:4;s:14:"menu_link_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'menu_item_delete_page',
  'page_arguments' => 'a:1:{i:0;i:4;}',
  'fit' => '61',
  'number_parts' => '6',
  'tab_parent' => '',
  'tab_root' => 'admin/build/menu/item/%/delete',
  'title' => 'Delete menu item',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/build/menu/item/%/edit',
  'load_functions' => 'a:1:{i:4;s:14:"menu_link_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:4:{i:0;s:14:"menu_edit_item";i:1;s:4:"edit";i:2;i:4;i:3;N;}',
  'fit' => '61',
  'number_parts' => '6',
  'tab_parent' => '',
  'tab_root' => 'admin/build/menu/item/%/edit',
  'title' => 'Edit menu item',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/build/menu/item/%/reset',
  'load_functions' => 'a:1:{i:4;s:14:"menu_link_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:23:"menu_reset_item_confirm";i:1;i:4;}',
  'fit' => '61',
  'number_parts' => '6',
  'tab_parent' => '',
  'tab_root' => 'admin/build/menu/item/%/reset',
  'title' => 'Reset menu item',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/build/menu/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'menu_overview_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/menu',
  'tab_root' => 'admin/build/menu',
  'title' => 'List menus',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/build/menu/settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:15:"administer menu";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"menu_configure";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/menu',
  'tab_root' => 'admin/build/menu',
  'title' => 'Settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '5',
  'file' => 'modules/menu/menu.admin.inc',
))
->values(array(
  'path' => 'admin/build/modules',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"system_modules";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/build/modules',
  'title' => 'Modules',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Enable or disable add-on modules for your site.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build/modules/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"system_modules";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/modules',
  'tab_root' => 'admin/build/modules',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build/modules/list/confirm',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"system_modules";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/build/modules/list/confirm',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build/modules/uninstall',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:24:"system_modules_uninstall";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/modules',
  'tab_root' => 'admin/build/modules',
  'title' => 'Uninstall',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build/modules/uninstall/confirm',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:24:"system_modules_uninstall";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/build/modules/uninstall/confirm',
  'title' => 'Uninstall',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build/path',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer url aliases";}',
  'page_callback' => 'path_admin_overview',
  'page_arguments' => 'a:0:{}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/build/path',
  'title' => 'URL aliases',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => "Change your site's URL paths by aliasing them.",
  'position' => '',
  'weight' => '0',
  'file' => 'modules/path/path.admin.inc',
))
->values(array(
  'path' => 'admin/build/path/add',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer url aliases";}',
  'page_callback' => 'path_admin_edit',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/path',
  'tab_root' => 'admin/build/path',
  'title' => 'Add alias',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/path/path.admin.inc',
))
->values(array(
  'path' => 'admin/build/path/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer url aliases";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:25:"path_admin_delete_confirm";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/build/path/delete',
  'title' => 'Delete alias',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/path/path.admin.inc',
))
->values(array(
  'path' => 'admin/build/path/edit',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer url aliases";}',
  'page_callback' => 'path_admin_edit',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/build/path/edit',
  'title' => 'Edit alias',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/path/path.admin.inc',
))
->values(array(
  'path' => 'admin/build/path/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:22:"administer url aliases";}',
  'page_callback' => 'path_admin_overview',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/path',
  'tab_root' => 'admin/build/path',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/path/path.admin.inc',
))
->values(array(
  'path' => 'admin/build/themes',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:18:"system_themes_form";i:1;N;}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/build/themes',
  'title' => 'Themes',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Change which theme your site uses or allows users to set.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build/themes/select',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:18:"system_themes_form";i:1;N;}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/themes',
  'tab_root' => 'admin/build/themes',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => 'Select the default theme.',
  'position' => '',
  'weight' => '-1',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build/themes/settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:21:"system_theme_settings";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/themes',
  'tab_root' => 'admin/build/themes',
  'title' => 'Configure',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build/themes/settings/bluemarine',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_system_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:33:"themes/bluemarine/bluemarine.info";s:4:"name";s:10:"bluemarine";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"0";s:8:"throttle";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:13:{s:4:"name";s:10:"Bluemarine";s:11:"description";s:66:"Table-based multi-column theme with a marine and ash color scheme.";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:6:"engine";s:11:"phptemplate";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1456343372";s:7:"regions";a:5:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";}s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:27:"themes/bluemarine/style.css";}}s:7:"scripts";a:1:{s:9:"script.js";s:27:"themes/bluemarine/script.js";}s:10:"screenshot";s:32:"themes/bluemarine/screenshot.png";s:3:"php";s:5:"4.3.5";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:27:"themes/bluemarine/style.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:21:"system_theme_settings";i:1;s:10:"bluemarine";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/themes/settings',
  'tab_root' => 'admin/build/themes',
  'title' => 'Bluemarine',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build/themes/settings/chameleon',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_system_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":11:{s:8:"filename";s:31:"themes/chameleon/chameleon.info";s:4:"name";s:9:"chameleon";s:4:"type";s:5:"theme";s:5:"owner";s:32:"themes/chameleon/chameleon.theme";s:6:"status";s:1:"0";s:8:"throttle";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:12:{s:4:"name";s:9:"Chameleon";s:11:"description";s:42:"Minimalist tabled theme with light colors.";s:7:"regions";a:2:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";}s:8:"features";a:4:{i:0;s:4:"logo";i:1;s:7:"favicon";i:2;s:4:"name";i:3;s:6:"slogan";}s:11:"stylesheets";a:1:{s:3:"all";a:2:{s:9:"style.css";s:26:"themes/chameleon/style.css";s:10:"common.css";s:27:"themes/chameleon/common.css";}}s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1456343372";s:7:"scripts";a:1:{s:9:"script.js";s:26:"themes/chameleon/script.js";}s:10:"screenshot";s:31:"themes/chameleon/screenshot.png";s:3:"php";s:5:"4.3.5";}s:11:"stylesheets";a:1:{s:3:"all";a:2:{s:9:"style.css";s:26:"themes/chameleon/style.css";s:10:"common.css";s:27:"themes/chameleon/common.css";}}}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:21:"system_theme_settings";i:1;s:9:"chameleon";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/themes/settings',
  'tab_root' => 'admin/build/themes',
  'title' => 'Chameleon',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build/themes/settings/garland',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_system_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:27:"themes/garland/garland.info";s:4:"name";s:7:"garland";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"1";s:8:"throttle";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:13:{s:4:"name";s:7:"Garland";s:11:"description";s:66:"Tableless, recolorable, multi-column, fluid width theme (default).";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:6:"engine";s:11:"phptemplate";s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1456343372";s:7:"regions";a:5:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";}s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:7:"scripts";a:1:{s:9:"script.js";s:24:"themes/garland/script.js";}s:10:"screenshot";s:29:"themes/garland/screenshot.png";s:3:"php";s:5:"4.3.5";}s:11:"stylesheets";a:2:{s:3:"all";a:1:{s:9:"style.css";s:24:"themes/garland/style.css";}s:5:"print";a:1:{s:9:"print.css";s:24:"themes/garland/print.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:21:"system_theme_settings";i:1;s:7:"garland";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/themes/settings',
  'tab_root' => 'admin/build/themes',
  'title' => 'Garland',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build/themes/settings/global',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:21:"system_theme_settings";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/themes/settings',
  'tab_root' => 'admin/build/themes',
  'title' => 'Global settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-1',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build/themes/settings/marvin',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_system_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:35:"themes/chameleon/marvin/marvin.info";s:4:"name";s:6:"marvin";s:4:"type";s:5:"theme";s:5:"owner";s:0:"";s:6:"status";s:1:"0";s:8:"throttle";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:13:{s:4:"name";s:6:"Marvin";s:11:"description";s:31:"Boxy tabled theme in all grays.";s:7:"regions";a:2:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";}s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:10:"base theme";s:9:"chameleon";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1456343372";s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:33:"themes/chameleon/marvin/style.css";}}s:7:"scripts";a:1:{s:9:"script.js";s:33:"themes/chameleon/marvin/script.js";}s:10:"screenshot";s:38:"themes/chameleon/marvin/screenshot.png";s:3:"php";s:5:"4.3.5";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:33:"themes/chameleon/marvin/style.css";}}s:10:"base_theme";s:9:"chameleon";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:21:"system_theme_settings";i:1;s:6:"marvin";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/themes/settings',
  'tab_root' => 'admin/build/themes',
  'title' => 'Marvin',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build/themes/settings/minnelli',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_system_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":13:{s:8:"filename";s:37:"themes/garland/minnelli/minnelli.info";s:4:"name";s:8:"minnelli";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"0";s:8:"throttle";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:14:{s:4:"name";s:8:"Minnelli";s:11:"description";s:56:"Tableless, recolorable, multi-column, fixed width theme.";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:10:"base theme";s:7:"garland";s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:12:"minnelli.css";s:36:"themes/garland/minnelli/minnelli.css";}}s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1456343372";s:7:"regions";a:5:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";}s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:7:"scripts";a:1:{s:9:"script.js";s:33:"themes/garland/minnelli/script.js";}s:10:"screenshot";s:38:"themes/garland/minnelli/screenshot.png";s:3:"php";s:5:"4.3.5";s:6:"engine";s:11:"phptemplate";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:12:"minnelli.css";s:36:"themes/garland/minnelli/minnelli.css";}}s:6:"engine";s:11:"phptemplate";s:10:"base_theme";s:7:"garland";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:21:"system_theme_settings";i:1;s:8:"minnelli";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/themes/settings',
  'tab_root' => 'admin/build/themes',
  'title' => 'Minnelli',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build/themes/settings/pushbutton',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => '_system_themes_access',
  'access_arguments' => 'a:1:{i:0;O:8:"stdClass":12:{s:8:"filename";s:33:"themes/pushbutton/pushbutton.info";s:4:"name";s:10:"pushbutton";s:4:"type";s:5:"theme";s:5:"owner";s:45:"themes/engines/phptemplate/phptemplate.engine";s:6:"status";s:1:"0";s:8:"throttle";s:1:"0";s:9:"bootstrap";s:1:"0";s:14:"schema_version";s:2:"-1";s:6:"weight";s:1:"0";s:4:"info";a:13:{s:4:"name";s:10:"Pushbutton";s:11:"description";s:52:"Tabled, multi-column theme in blue and orange tones.";s:7:"version";s:4:"6.38";s:4:"core";s:3:"6.x";s:6:"engine";s:11:"phptemplate";s:7:"project";s:6:"drupal";s:9:"datestamp";s:10:"1456343372";s:7:"regions";a:5:{s:4:"left";s:12:"Left sidebar";s:5:"right";s:13:"Right sidebar";s:7:"content";s:7:"Content";s:6:"header";s:6:"Header";s:6:"footer";s:6:"Footer";}s:8:"features";a:10:{i:0;s:20:"comment_user_picture";i:1;s:7:"favicon";i:2;s:7:"mission";i:3;s:4:"logo";i:4;s:4:"name";i:5;s:17:"node_user_picture";i:6;s:6:"search";i:7;s:6:"slogan";i:8;s:13:"primary_links";i:9;s:15:"secondary_links";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:27:"themes/pushbutton/style.css";}}s:7:"scripts";a:1:{s:9:"script.js";s:27:"themes/pushbutton/script.js";}s:10:"screenshot";s:32:"themes/pushbutton/screenshot.png";s:3:"php";s:5:"4.3.5";}s:11:"stylesheets";a:1:{s:3:"all";a:1:{s:9:"style.css";s:27:"themes/pushbutton/style.css";}}s:6:"engine";s:11:"phptemplate";}}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:21:"system_theme_settings";i:1;s:10:"pushbutton";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/build/themes/settings',
  'tab_root' => 'admin/build/themes',
  'title' => 'Pushbutton',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/build/translate',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"translate interface";}',
  'page_callback' => 'locale_inc_callback',
  'page_arguments' => 'a:1:{i:0;s:32:"locale_translate_overview_screen";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/build/translate',
  'title' => 'Translate interface',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Translate the built in interface and optionally other text.',
  'position' => '',
  'weight' => '0',
  'file' => '',
))
->values(array(
  'path' => 'admin/build/translate/delete/%',
  'load_functions' => 'a:1:{i:4;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"translate interface";}',
  'page_callback' => 'locale_inc_callback',
  'page_arguments' => 'a:2:{i:0;s:28:"locale_translate_delete_page";i:1;i:4;}',
  'fit' => '30',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/build/translate/delete/%',
  'title' => 'Delete string',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
))
->values(array(
  'path' => 'admin/build/translate/edit/%',
  'load_functions' => 'a:1:{i:4;N;}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"translate interface";}',
  'page_callback' => 'locale_inc_callback',
  'page_arguments' => 'a:3:{i:0;s:15:"drupal_get_form";i:1;s:26:"locale_translate_edit_form";i:2;i:4;}',
  'fit' => '30',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/build/translate/edit/%',
  'title' => 'Edit string',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
))
->values(array(
  'path' => 'admin/build/translate/export',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"translate interface";}',
  'page_callback' => 'locale_inc_callback',
  'page_arguments' => 'a:1:{i:0;s:30:"locale_translate_export_screen";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/translate',
  'tab_root' => 'admin/build/translate',
  'title' => 'Export',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '30',
  'file' => '',
))
->values(array(
  'path' => 'admin/build/translate/import',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"translate interface";}',
  'page_callback' => 'locale_inc_callback',
  'page_arguments' => 'a:2:{i:0;s:15:"drupal_get_form";i:1;s:28:"locale_translate_import_form";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/translate',
  'tab_root' => 'admin/build/translate',
  'title' => 'Import',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '20',
  'file' => '',
))
->values(array(
  'path' => 'admin/build/translate/overview',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"translate interface";}',
  'page_callback' => 'locale_inc_callback',
  'page_arguments' => 'a:1:{i:0;s:32:"locale_translate_overview_screen";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/translate',
  'tab_root' => 'admin/build/translate',
  'title' => 'Overview',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => '',
))
->values(array(
  'path' => 'admin/build/translate/refresh',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"translate interface";}',
  'page_callback' => 'i18nstrings_admin_refresh_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/translate',
  'tab_root' => 'admin/build/translate',
  'title' => 'Refresh',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '20',
  'file' => 'sites/all/modules/i18n/i18nstrings/i18nstrings.admin.inc',
))
->values(array(
  'path' => 'admin/build/translate/search',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"translate interface";}',
  'page_callback' => 'locale_inc_callback',
  'page_arguments' => 'a:1:{i:0;s:28:"locale_translate_seek_screen";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/build/translate',
  'tab_root' => 'admin/build/translate',
  'title' => 'Search',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'file' => '',
))
->values(array(
  'path' => 'admin/by-module',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_by_module',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => 'admin',
  'tab_root' => 'admin',
  'title' => 'By module',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/by-task',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_main_admin_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => 'admin',
  'tab_root' => 'admin',
  'title' => 'By task',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/compact',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_compact_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'admin/compact',
  'title' => 'Compact mode',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/content',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'system_admin_menu_block_page',
  'page_arguments' => 'a:0:{}',
  'fit' => '3',
  'number_parts' => '2',
  'tab_parent' => '',
  'tab_root' => 'admin/content',
  'title' => 'Content management',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => "Manage your site's content.",
  'position' => 'left',
  'weight' => '-10',
  'file' => 'modules/system/system.admin.inc',
))
->values(array(
  'path' => 'admin/content/aggregator',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:21:"administer news feeds";}',
  'page_callback' => 'aggregator_admin_overview',
  'page_arguments' => 'a:0:{}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/content/aggregator',
  'title' => 'Feed aggregator',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => "Configure which content your site aggregates from other sites, how often it polls them, and how they're categorized.",
  'position' => '',
  'weight' => '0',
  'file' => 'modules/aggregator/aggregator.admin.inc',
))
->values(array(
  'path' => 'admin/content/aggregator/add/category',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:21:"administer news feeds";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:24:"aggregator_form_category";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/aggregator',
  'tab_root' => 'admin/content/aggregator',
  'title' => 'Add category',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/aggregator/aggregator.admin.inc',
))
->values(array(
  'path' => 'admin/content/aggregator/add/feed',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:21:"administer news feeds";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:20:"aggregator_form_feed";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/aggregator',
  'tab_root' => 'admin/content/aggregator',
  'title' => 'Add feed',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/aggregator/aggregator.admin.inc',
))
->values(array(
  'path' => 'admin/content/aggregator/edit/category/%',
  'load_functions' => 'a:1:{i:5;s:24:"aggregator_category_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:21:"administer news feeds";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"aggregator_form_category";i:1;i:5;}',
  'fit' => '62',
  'number_parts' => '6',
  'tab_parent' => '',
  'tab_root' => 'admin/content/aggregator/edit/category/%',
  'title' => 'Edit category',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/aggregator/aggregator.admin.inc',
))
->values(array(
  'path' => 'admin/content/aggregator/edit/feed/%',
  'load_functions' => 'a:1:{i:5;s:20:"aggregator_feed_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:21:"administer news feeds";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:20:"aggregator_form_feed";i:1;i:5;}',
  'fit' => '62',
  'number_parts' => '6',
  'tab_parent' => '',
  'tab_root' => 'admin/content/aggregator/edit/feed/%',
  'title' => 'Edit feed',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/aggregator/aggregator.admin.inc',
))
->values(array(
  'path' => 'admin/content/aggregator/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:21:"administer news feeds";}',
  'page_callback' => 'aggregator_admin_overview',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/content/aggregator',
  'tab_root' => 'admin/content/aggregator',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/aggregator/aggregator.admin.inc',
))
->values(array(
  'path' => 'admin/content/aggregator/remove/%',
  'load_functions' => 'a:1:{i:4;s:20:"aggregator_feed_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:21:"administer news feeds";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:28:"aggregator_admin_remove_feed";i:1;i:4;}',
  'fit' => '30',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/content/aggregator/remove/%',
  'title' => 'Remove items',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/aggregator/aggregator.admin.inc',
))
->values(array(
  'path' => 'admin/content/aggregator/settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:21:"administer news feeds";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:25:"aggregator_admin_settings";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/content/aggregator',
  'tab_root' => 'admin/content/aggregator',
  'title' => 'Settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '10',
  'file' => 'modules/aggregator/aggregator.admin.inc',
))
->values(array(
  'path' => 'admin/content/aggregator/update/%',
  'load_functions' => 'a:1:{i:4;s:20:"aggregator_feed_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:21:"administer news feeds";}',
  'page_callback' => 'aggregator_admin_refresh_feed',
  'page_arguments' => 'a:1:{i:0;i:4;}',
  'fit' => '30',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/content/aggregator/update/%',
  'title' => 'Update items',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/aggregator/aggregator.admin.inc',
))
->values(array(
  'path' => 'admin/content/book',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer book outlines";}',
  'page_callback' => 'book_admin_overview',
  'page_arguments' => 'a:0:{}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/content/book',
  'title' => 'Books',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => "Manage your site's book outlines.",
  'position' => '',
  'weight' => '0',
  'file' => 'modules/book/book.admin.inc',
))
->values(array(
  'path' => 'admin/content/book/%',
  'load_functions' => 'a:1:{i:3;s:9:"node_load";}',
  'to_arg_functions' => '',
  'access_callback' => '_book_outline_access',
  'access_arguments' => 'a:1:{i:0;i:3;}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:15:"book_admin_edit";i:1;i:3;}',
  'fit' => '14',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/content/book/%',
  'title' => 'Re-order book pages and change titles',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/book/book.admin.inc',
))
->values(array(
  'path' => 'admin/content/book/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer book outlines";}',
  'page_callback' => 'book_admin_overview',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/content/book',
  'tab_root' => 'admin/content/book',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/book/book.admin.inc',
))
->values(array(
  'path' => 'admin/content/book/settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:29:"administer site configuration";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:19:"book_admin_settings";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/content/book',
  'tab_root' => 'admin/content/book',
  'title' => 'Settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '8',
  'file' => 'modules/book/book.admin.inc',
))
->values(array(
  'path' => 'admin/content/comment',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer comments";}',
  'page_callback' => 'comment_admin',
  'page_arguments' => 'a:0:{}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/content/comment',
  'title' => 'Comments',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'List and edit site comments and the comment moderation queue.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/comment/comment.admin.inc',
))
->values(array(
  'path' => 'admin/content/comment/approval',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer comments";}',
  'page_callback' => 'comment_admin',
  'page_arguments' => 'a:1:{i:0;s:8:"approval";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/content/comment',
  'tab_root' => 'admin/content/comment',
  'title' => 'Approval queue',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/comment/comment.admin.inc',
))
->values(array(
  'path' => 'admin/content/comment/new',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:19:"administer comments";}',
  'page_callback' => 'comment_admin',
  'page_arguments' => 'a:0:{}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/content/comment',
  'tab_root' => 'admin/content/comment',
  'title' => 'Published comments',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/comment/comment.admin.inc',
))
->values(array(
  'path' => 'admin/content/forum',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer forums";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"forum_overview";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/content/forum',
  'title' => 'Forums',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Control forums and their hierarchy and change forum settings.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/forum/forum.admin.inc',
))
->values(array(
  'path' => 'admin/content/forum/add/container',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer forums";}',
  'page_callback' => 'forum_form_main',
  'page_arguments' => 'a:1:{i:0;s:9:"container";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/forum',
  'tab_root' => 'admin/content/forum',
  'title' => 'Add container',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/forum/forum.admin.inc',
))
->values(array(
  'path' => 'admin/content/forum/add/forum',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer forums";}',
  'page_callback' => 'forum_form_main',
  'page_arguments' => 'a:1:{i:0;s:5:"forum";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/forum',
  'tab_root' => 'admin/content/forum',
  'title' => 'Add forum',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/forum/forum.admin.inc',
))
->values(array(
  'path' => 'admin/content/forum/edit/%',
  'load_functions' => 'a:1:{i:4;s:15:"forum_term_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer forums";}',
  'page_callback' => 'forum_form_main',
  'page_arguments' => 'a:0:{}',
  'fit' => '30',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/content/forum/edit/%',
  'title' => '',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/forum/forum.admin.inc',
))
->values(array(
  'path' => 'admin/content/forum/edit/container/%',
  'load_functions' => 'a:1:{i:5;s:15:"forum_term_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer forums";}',
  'page_callback' => 'forum_form_main',
  'page_arguments' => 'a:2:{i:0;s:9:"container";i:1;i:5;}',
  'fit' => '62',
  'number_parts' => '6',
  'tab_parent' => '',
  'tab_root' => 'admin/content/forum/edit/container/%',
  'title' => 'Edit container',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/forum/forum.admin.inc',
))
->values(array(
  'path' => 'admin/content/forum/edit/forum/%',
  'load_functions' => 'a:1:{i:5;s:15:"forum_term_load";}',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer forums";}',
  'page_callback' => 'forum_form_main',
  'page_arguments' => 'a:2:{i:0;s:5:"forum";i:1;i:5;}',
  'fit' => '62',
  'number_parts' => '6',
  'tab_parent' => '',
  'tab_root' => 'admin/content/forum/edit/forum/%',
  'title' => 'Edit forum',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/forum/forum.admin.inc',
))
->values(array(
  'path' => 'admin/content/forum/list',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer forums";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"forum_overview";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/content/forum',
  'tab_root' => 'admin/content/forum',
  'title' => 'List',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '-10',
  'file' => 'modules/forum/forum.admin.inc',
))
->values(array(
  'path' => 'admin/content/forum/settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:17:"administer forums";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:20:"forum_admin_settings";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => 'admin/content/forum',
  'tab_root' => 'admin/content/forum',
  'title' => 'Settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '5',
  'file' => 'modules/forum/forum.admin.inc',
))
->values(array(
  'path' => 'admin/content/node',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer nodes";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:18:"node_admin_content";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node',
  'title' => 'Content',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => "View, edit, and delete your site's content.",
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/node.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-settings',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:16:"administer nodes";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:14:"node_configure";}',
  'fit' => '7',
  'number_parts' => '3',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-settings',
  'title' => 'Post settings',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '6',
  'block_callback' => '',
  'description' => 'Control posting behavior, such as teaser length, requiring previews before posting, and the number of posts on the front page.',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/node.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-settings/rebuild',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:27:"access administration pages";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:1:{i:0;s:30:"node_configure_rebuild_confirm";}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-settings/rebuild',
  'title' => 'Rebuild permissions',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/node.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/article',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:14:"node_type_form";i:1;O:8:"stdClass":14:{s:4:"type";s:7:"article";s:4:"name";s:7:"Article";s:6:"module";s:4:"node";s:11:"description";s:34:"An <em>article</em>, content type.";s:4:"help";s:0:"";s:9:"has_title";s:1:"1";s:11:"title_label";s:5:"Title";s:8:"has_body";s:1:"1";s:10:"body_label";s:4:"Body";s:14:"min_word_count";s:1:"0";s:6:"custom";s:1:"1";s:8:"modified";s:1:"1";s:6:"locked";s:1:"0";s:9:"orig_type";s:5:"story";}}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/article',
  'title' => 'Article',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/article/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"node_type_delete_confirm";i:1;O:8:"stdClass":14:{s:4:"type";s:7:"article";s:4:"name";s:7:"Article";s:6:"module";s:4:"node";s:11:"description";s:34:"An <em>article</em>, content type.";s:4:"help";s:0:"";s:9:"has_title";s:1:"1";s:11:"title_label";s:5:"Title";s:8:"has_body";s:1:"1";s:10:"body_label";s:4:"Body";s:14:"min_word_count";s:1:"0";s:6:"custom";s:1:"1";s:8:"modified";s:1:"1";s:6:"locked";s:1:"0";s:9:"orig_type";s:5:"story";}}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/article/delete',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/article/display',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:29:"content_display_overview_form";i:1;s:7:"article";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/article',
  'tab_root' => 'admin/content/node-type/article',
  'title' => 'Display fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/article/display/basic',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:7:"article";i:2;s:5:"basic";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/article/display',
  'tab_root' => 'admin/content/node-type/article',
  'title' => 'Basic',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/article/display/print',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:7:"article";i:2;s:5:"print";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/article/display',
  'tab_root' => 'admin/content/node-type/article',
  'title' => 'Print',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/article/display/rss',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:7:"article";i:2;s:3:"rss";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/article/display',
  'tab_root' => 'admin/content/node-type/article',
  'title' => 'RSS',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/article/edit',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:14:"node_type_form";i:1;O:8:"stdClass":14:{s:4:"type";s:7:"article";s:4:"name";s:7:"Article";s:6:"module";s:4:"node";s:11:"description";s:34:"An <em>article</em>, content type.";s:4:"help";s:0:"";s:9:"has_title";s:1:"1";s:11:"title_label";s:5:"Title";s:8:"has_body";s:1:"1";s:10:"body_label";s:4:"Body";s:14:"min_word_count";s:1:"0";s:6:"custom";s:1:"1";s:8:"modified";s:1:"1";s:6:"locked";s:1:"0";s:9:"orig_type";s:5:"story";}}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/article',
  'tab_root' => 'admin/content/node-type/article',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/article/fields',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:27:"content_field_overview_form";i:1;s:7:"article";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/article',
  'tab_root' => 'admin/content/node-type/article',
  'title' => 'Manage fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/company',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:14:"node_type_form";i:1;O:8:"stdClass":14:{s:4:"type";s:7:"company";s:4:"name";s:7:"Company";s:6:"module";s:4:"node";s:11:"description";s:17:"Company node type";s:4:"help";s:0:"";s:9:"has_title";s:1:"1";s:11:"title_label";s:4:"Name";s:8:"has_body";s:1:"1";s:10:"body_label";s:11:"Description";s:14:"min_word_count";s:1:"0";s:6:"custom";s:1:"0";s:8:"modified";s:1:"1";s:6:"locked";s:1:"0";s:9:"orig_type";s:7:"company";}}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/company',
  'title' => 'Company',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/company/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"node_type_delete_confirm";i:1;O:8:"stdClass":14:{s:4:"type";s:7:"company";s:4:"name";s:7:"Company";s:6:"module";s:4:"node";s:11:"description";s:17:"Company node type";s:4:"help";s:0:"";s:9:"has_title";s:1:"1";s:11:"title_label";s:4:"Name";s:8:"has_body";s:1:"1";s:10:"body_label";s:11:"Description";s:14:"min_word_count";s:1:"0";s:6:"custom";s:1:"0";s:8:"modified";s:1:"1";s:6:"locked";s:1:"0";s:9:"orig_type";s:7:"company";}}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/company/delete',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/company/display',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:29:"content_display_overview_form";i:1;s:7:"company";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/company',
  'tab_root' => 'admin/content/node-type/company',
  'title' => 'Display fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '2',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/company/display/basic',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:7:"company";i:2;s:5:"basic";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/company/display',
  'tab_root' => 'admin/content/node-type/company',
  'title' => 'Basic',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/company/display/print',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:7:"company";i:2;s:5:"print";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/company/display',
  'tab_root' => 'admin/content/node-type/company',
  'title' => 'Print',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/company/display/rss',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:3:{i:0;s:29:"content_display_overview_form";i:1;s:7:"company";i:2;s:3:"rss";}',
  'fit' => '63',
  'number_parts' => '6',
  'tab_parent' => 'admin/content/node-type/company/display',
  'tab_root' => 'admin/content/node-type/company',
  'title' => 'RSS',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/company/edit',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:14:"node_type_form";i:1;O:8:"stdClass":14:{s:4:"type";s:7:"company";s:4:"name";s:7:"Company";s:6:"module";s:4:"node";s:11:"description";s:17:"Company node type";s:4:"help";s:0:"";s:9:"has_title";s:1:"1";s:11:"title_label";s:4:"Name";s:8:"has_body";s:1:"1";s:10:"body_label";s:11:"Description";s:14:"min_word_count";s:1:"0";s:6:"custom";s:1:"0";s:8:"modified";s:1:"1";s:6:"locked";s:1:"0";s:9:"orig_type";s:7:"company";}}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/company',
  'tab_root' => 'admin/content/node-type/company',
  'title' => 'Edit',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '136',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/company/fields',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:27:"content_field_overview_form";i:1;s:7:"company";}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => 'admin/content/node-type/company',
  'tab_root' => 'admin/content/node-type/company',
  'title' => 'Manage fields',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '128',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '1',
  'file' => 'sites/all/modules/cck/includes/content.admin.inc',
))
->values(array(
  'path' => 'admin/content/node-type/employee',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:14:"node_type_form";i:1;O:8:"stdClass":14:{s:4:"type";s:8:"employee";s:4:"name";s:8:"Employee";s:6:"module";s:4:"node";s:11:"description";s:18:"Employee node type";s:4:"help";s:0:"";s:9:"has_title";s:1:"1";s:11:"title_label";s:4:"Name";s:8:"has_body";s:1:"1";s:10:"body_label";s:3:"Bio";s:14:"min_word_count";s:2:"20";s:6:"custom";s:1:"0";s:8:"modified";s:1:"0";s:6:"locked";s:1:"0";s:9:"orig_type";s:8:"employee";}}',
  'fit' => '15',
  'number_parts' => '4',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/employee',
  'title' => 'Employee',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/employee/delete',
  'load_functions' => '',
  'to_arg_functions' => '',
  'access_callback' => 'user_access',
  'access_arguments' => 'a:1:{i:0;s:24:"administer content types";}',
  'page_callback' => 'drupal_get_form',
  'page_arguments' => 'a:2:{i:0;s:24:"node_type_delete_confirm";i:1;O:8:"stdClass":14:{s:4:"type";s:8:"employee";s:4:"name";s:8:"Employee";s:6:"module";s:4:"node";s:11:"description";s:18:"Employee node type";s:4:"help";s:0:"";s:9:"has_title";s:1:"1";s:11:"title_label";s:4:"Name";s:8:"has_body";s:1:"1";s:10:"body_label";s:3:"Bio";s:14:"min_word_count";s:2:"20";s:6:"custom";s:1:"0";s:8:"modified";s:1:"0";s:6:"locked";s:1:"0";s:9:"orig_type";s:8:"employee";}}',
  'fit' => '31',
  'number_parts' => '5',
  'tab_parent' => '',
  'tab_root' => 'admin/content/node-type/employee/delete',
  'title' => 'Delete',
  'title_callback' => 't',
  'title_arguments' => '',
  'type' => '4',
  'block_callback' => '',
  'description' => '',
  'position' => '',
  'weight' => '0',
  'file' => 'modules/node/content_types.inc',
))
->values(array(
  'path' => 'admin/content/node-type/employee/display',
  'load_functions' =>