/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.statistics.plugin.dynamic;

import java.awt.Component;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import org.gephi.graph.api.GraphController;
import org.jdesktop.swingx.JXHeader;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class DynamicDegreePanel
extends JPanel {
    private JCheckBox averageOnlyCheckbox;
    private ButtonGroup directedButtonGroup;
    protected JRadioButton directedRadioButton;
    private JXHeader header;
    protected JRadioButton undirectedRadioButton;

    public DynamicDegreePanel() {
        this.initComponents();
        GraphController graphController = (GraphController)Lookup.getDefault().lookup(GraphController.class);
        if (graphController.getGraphModel().isUndirected()) {
            this.directedRadioButton.setEnabled(false);
        }
    }

    public boolean isDirected() {
        return this.directedRadioButton.isSelected();
    }

    public void setDirected(boolean directed) {
        this.directedButtonGroup.setSelected(directed ? this.directedRadioButton.getModel() : this.undirectedRadioButton.getModel(), true);
        if (!directed) {
            this.directedRadioButton.setEnabled(false);
        }
    }

    public boolean isAverageOnly() {
        return this.averageOnlyCheckbox.isSelected();
    }

    public void setAverageOnly(boolean averageOnly) {
        this.averageOnlyCheckbox.setSelected(averageOnly);
    }

    private void initComponents() {
        this.directedButtonGroup = new ButtonGroup();
        this.header = new JXHeader();
        this.directedRadioButton = new JRadioButton();
        this.undirectedRadioButton = new JRadioButton();
        this.averageOnlyCheckbox = new JCheckBox();
        this.header.setDescription(NbBundle.getMessage(DynamicDegreePanel.class, (String)"DynamicDegreePanel.header.description"));
        this.header.setTitle(NbBundle.getMessage(DynamicDegreePanel.class, (String)"DynamicDegreePanel.header.title"));
        this.directedButtonGroup.add(this.directedRadioButton);
        this.directedRadioButton.setText(NbBundle.getMessage(DynamicDegreePanel.class, (String)"DynamicDegreePanel.directedRadioButton.text"));
        this.directedButtonGroup.add(this.undirectedRadioButton);
        this.undirectedRadioButton.setText(NbBundle.getMessage(DynamicDegreePanel.class, (String)"DynamicDegreePanel.undirectedRadioButton.text"));
        this.averageOnlyCheckbox.setText(NbBundle.getMessage(DynamicDegreePanel.class, (String)"DynamicDegreePanel.averageOnlyCheckbox.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.header, -1, 503, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.undirectedRadioButton).addComponent(this.directedRadioButton).addComponent(this.averageOnlyCheckbox)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent((Component)this.header, -2, 77, -2).addGap(18, 18, 18).addComponent(this.directedRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.undirectedRadioButton).addGap(18, 18, 18).addComponent(this.averageOnlyCheckbox).addContainerGap(34, Short.MAX_VALUE)));
    }
}

