/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.ChangeNodesCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.DefaultNameFormatter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.conflict.tags.CombinePrimitiveResolverDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.UserCancelException;

public class MergeNodesAction
extends JosmAction {
    public MergeNodesAction() {
        super(I18n.tr("Merge Nodes", new Object[0]), "mergenodes", I18n.tr("Merge nodes into the oldest one.", new Object[0]), Shortcut.registerShortcut("tools:mergenodes", I18n.tr("Tool: {0}", I18n.tr("Merge Nodes", new Object[0])), 77, 5003), true);
        this.setHelpId(HelpUtil.ht("/Action/MergeNodes"));
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Node targetLocationNode;
        Command cmd;
        Node targetNode;
        if (!this.isEnabled()) {
            return;
        }
        List<Node> selectedNodes = this.getLayerManager().getEditDataSet().getSelectedNodes().stream().filter(n -> !n.isDeleted() && !n.isIncomplete()).collect(Collectors.toList());
        if (selectedNodes.size() == 1) {
            MapView mapView = MainApplication.getMap().mapView;
            List<Node> nearestNodes = mapView.getNearestNodes(mapView.getPoint(selectedNodes.get(0)), selectedNodes, AbstractPrimitive::isUsable);
            if (nearestNodes.isEmpty()) {
                new Notification(I18n.tr("Please select at least two nodes to merge or one node that is close to another node.", new Object[0])).setIcon(2).show();
                return;
            }
            selectedNodes.addAll(nearestNodes);
        }
        if ((targetNode = MergeNodesAction.selectTargetNode(selectedNodes)) != null && (cmd = MergeNodesAction.mergeNodes(selectedNodes, targetNode, targetLocationNode = MergeNodesAction.selectTargetLocationNode(selectedNodes))) != null) {
            UndoRedoHandler.getInstance().add(cmd);
            this.getLayerManager().getEditLayer().data.setSelected(targetNode);
        }
    }

    public static Node selectTargetLocationNode(List<Node> candidates) {
        int size = candidates.size();
        if (size == 0) {
            throw new IllegalArgumentException("empty list");
        }
        if (size == 1) {
            return candidates.get(0);
        }
        switch (Config.getPref().getInt("merge-nodes.mode", 0)) {
            case 0: {
                return candidates.get(size - 1);
            }
            case 1: {
                double east1 = 0.0;
                double north1 = 0.0;
                for (Node n : candidates) {
                    EastNorth en = n.getEastNorth();
                    east1 += en.east();
                    north1 += en.north();
                }
                return new Node(new EastNorth(east1 / (double)size, north1 / (double)size));
            }
            case 2: {
                double[] weights = new double[size];
                for (int i = 0; i < size; ++i) {
                    LatLon c1 = candidates.get(i).getCoor();
                    int j = i + 1;
                    while (j < size) {
                        LatLon c2 = candidates.get(j).getCoor();
                        double d = c1.distance(c2);
                        int n = i;
                        weights[n] = weights[n] + d;
                        int n2 = j++;
                        weights[n2] = weights[n2] + d;
                    }
                }
                double east2 = 0.0;
                double north2 = 0.0;
                double weight = 0.0;
                for (int i = 0; i < size; ++i) {
                    EastNorth en = candidates.get(i).getEastNorth();
                    double w = weights[i];
                    east2 += en.east() * w;
                    north2 += en.north() * w;
                    weight += w;
                }
                if (weight == 0.0) {
                    return candidates.get(0);
                }
                return new Node(new EastNorth(east2 / weight, north2 / weight));
            }
        }
        throw new IllegalStateException("unacceptable merge-nodes.mode");
    }

    public static Node selectTargetNode(Collection<Node> candidates) {
        Node oldestNode = null;
        Node targetNode = null;
        Node lastNode = null;
        for (Node n : candidates) {
            if (!n.isNew()) {
                if (!n.getReferrers().isEmpty()) {
                    if (targetNode == null || n.getId() < targetNode.getId()) {
                        targetNode = n;
                    }
                } else if (oldestNode == null || n.getId() < oldestNode.getId()) {
                    oldestNode = n;
                }
            }
            lastNode = n;
        }
        return Optional.ofNullable(targetNode).orElse((oldestNode != null ? oldestNode : lastNode));
    }

    protected static List<Command> fixParentWays(Collection<Node> nodesToDelete, Node targetNode) {
        ArrayList<Command> cmds = new ArrayList<Command>();
        HashSet<Way> waysToDelete = new HashSet<Way>();
        for (Way w : nodesToDelete.stream().flatMap(p -> p.referrers(Way.class))::iterator) {
            ArrayList<Node> newNodes = new ArrayList<Node>(w.getNodesCount());
            for (Node n : w.getNodes()) {
                if (!nodesToDelete.contains(n) && !n.equals(targetNode)) {
                    newNodes.add(n);
                    continue;
                }
                if (!newNodes.isEmpty() && ((Node)newNodes.get(newNodes.size() - 1)).equals(targetNode)) continue;
                newNodes.add(targetNode);
            }
            if (newNodes.size() < 2) {
                if (w.getReferrers().isEmpty()) {
                    waysToDelete.add(w);
                    continue;
                }
                HelpAwareOptionPane.ButtonSpec[] options = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Abort Merging", new Object[0]), new ImageProvider("cancel"), I18n.tr("Click to abort merging nodes", new Object[0]), null)};
                HelpAwareOptionPane.showOptionDialog(MainApplication.getMainFrame(), I18n.tr("Cannot merge nodes: Would have to delete way {0} which is still used by {1}", DefaultNameFormatter.getInstance().formatAsHtmlUnorderedList(w), DefaultNameFormatter.getInstance().formatAsHtmlUnorderedList(w.getReferrers(), 20)), I18n.tr("Warning", new Object[0]), 2, null, options, options[0], HelpUtil.ht("/Action/MergeNodes#WaysToDeleteStillInUse"));
                return null;
            }
            if (newNodes.size() < 2 && w.getReferrers().isEmpty()) {
                waysToDelete.add(w);
                continue;
            }
            cmds.add(new ChangeNodesCommand(w, (List<Node>)newNodes));
        }
        if (!waysToDelete.isEmpty()) {
            cmds.add(new DeleteCommand(waysToDelete));
        }
        return cmds;
    }

    public static void doMergeNodes(OsmDataLayer layer, Collection<Node> nodes, Node targetLocationNode) {
        Command cmd;
        if (nodes == null) {
            return;
        }
        HashSet<Node> allNodes = new HashSet<Node>(nodes);
        allNodes.add(targetLocationNode);
        Node target = nodes.contains(targetLocationNode) && !targetLocationNode.isNew() ? targetLocationNode : MergeNodesAction.selectTargetNode(allNodes);
        if (target != null && (cmd = MergeNodesAction.mergeNodes(nodes, target, targetLocationNode)) != null) {
            UndoRedoHandler.getInstance().add(cmd);
            layer.data.setSelected(target);
        }
    }

    public static Command mergeNodes(Collection<Node> nodes, Node targetLocationNode) {
        if (nodes == null) {
            return null;
        }
        HashSet<Node> allNodes = new HashSet<Node>(nodes);
        allNodes.add(targetLocationNode);
        Node targetNode = MergeNodesAction.selectTargetNode(allNodes);
        if (targetNode == null) {
            return null;
        }
        return MergeNodesAction.mergeNodes(nodes, targetNode, targetLocationNode);
    }

    public static Command mergeNodes(Collection<Node> nodes, Node targetNode, Node targetLocationNode) {
        CheckParameterUtil.ensureParameterNotNull(targetNode, "targetNode");
        if (nodes == null) {
            return null;
        }
        try {
            TagCollection nodeTags = TagCollection.unionOfAllPrimitives(nodes);
            HashSet<Node> nodesToDelete = new HashSet<Node>(nodes);
            nodesToDelete.remove(targetNode);
            List<Command> wayFixCommands = MergeNodesAction.fixParentWays(nodesToDelete, targetNode);
            if (wayFixCommands == null) {
                return null;
            }
            LinkedList<Command> cmds = new LinkedList<Command>(wayFixCommands);
            if (!targetNode.equals(targetLocationNode)) {
                LatLon targetLocationCoor = targetLocationNode.getCoor();
                if (!Objects.equals(targetNode.getCoor(), targetLocationCoor)) {
                    Node newTargetNode = new Node(targetNode);
                    newTargetNode.setCoor(targetLocationCoor);
                    cmds.add(new ChangeCommand(targetNode, newTargetNode));
                }
            }
            cmds.addAll(CombinePrimitiveResolverDialog.launchIfNecessary(nodeTags, nodes, Collections.singleton(targetNode)));
            if (!nodesToDelete.isEmpty()) {
                cmds.add(new DeleteCommand(nodesToDelete));
            }
            return cmds.isEmpty() ? null : new SequenceCommand(I18n.trn("Merge {0} node", "Merge {0} nodes", nodes.size(), nodes.size()), cmds);
        }
        catch (UserCancelException ex) {
            Logging.trace(ex);
            return null;
        }
    }

    @Override
    protected void updateEnabledState() {
        this.updateEnabledStateOnCurrentSelection();
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        boolean ok = OsmUtils.isOsmCollectionEditable(selection);
        if (ok) {
            for (OsmPrimitive osmPrimitive : selection) {
                if (osmPrimitive instanceof Node) continue;
                ok = false;
                break;
            }
        }
        this.setEnabled(ok);
    }
}

