/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation.sort;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.dialogs.relation.sort.RelationNodeMap;
import org.openstreetmap.josm.gui.dialogs.relation.sort.RelationSortUtils;
import org.openstreetmap.josm.gui.dialogs.relation.sort.WayConnectionType;
import org.openstreetmap.josm.tools.bugreport.BugReport;

public class WayConnectionTypeCalculator {
    private static final int UNCONNECTED = Integer.MIN_VALUE;
    private List<RelationMember> members;
    private int firstGroupIdx;
    private int lastForwardWay;
    private int lastBackwardWay;
    private boolean onewayBeginning;

    public List<WayConnectionType> updateLinks(List<RelationMember> members) {
        this.members = members;
        ArrayList<WayConnectionType> con = new ArrayList<WayConnectionType>();
        for (int i = 0; i < members.size(); ++i) {
            con.add(null);
        }
        this.firstGroupIdx = 0;
        this.lastForwardWay = Integer.MIN_VALUE;
        this.lastBackwardWay = Integer.MIN_VALUE;
        this.onewayBeginning = false;
        WayConnectionType lastWct = null;
        for (int i = 0; i < members.size(); ++i) {
            try {
                lastWct = this.updateLinksFor(con, lastWct, i);
                continue;
            }
            catch (RuntimeException e) {
                int index = i;
                throw BugReport.intercept(e).put("i", i).put("member", () -> (RelationMember)members.get(index)).put("con", con).put("members", members).put("lastWct", lastWct).put("firstGroupIdx", this.firstGroupIdx);
            }
        }
        this.makeLoopIfNeeded(con, members.size() - 1);
        return con;
    }

    private WayConnectionType updateLinksFor(List<WayConnectionType> con, WayConnectionType lastWct, int i) {
        RelationMember m = this.members.get(i);
        if (WayConnectionTypeCalculator.isNoHandleableWay(m)) {
            if (i > 0) {
                this.makeLoopIfNeeded(con, i - 1);
            }
        } else {
            WayConnectionType wct = this.computeNextWayConnection(con, lastWct, i, m);
            if (!wct.linkPrev) {
                if (i > 0) {
                    this.makeLoopIfNeeded(con, i - 1);
                }
                this.firstGroupIdx = i;
            }
            return wct;
        }
        con.set(i, new WayConnectionType());
        this.firstGroupIdx = i;
        return lastWct;
    }

    private static boolean isNoHandleableWay(RelationMember m) {
        return !m.isWay() || m.getWay() == null || m.getWay().isIncomplete();
    }

    private WayConnectionType computeNextWayConnection(List<WayConnectionType> con, WayConnectionType lastWct, int i, RelationMember m) {
        WayConnectionType wct = new WayConnectionType(false);
        wct.linkPrev = i > 0 && con.get(i - 1) != null && con.get(i - 1).isValid();
        wct.direction = WayConnectionType.Direction.NONE;
        if (RelationSortUtils.isOneway(m)) {
            this.handleOneway(lastWct, i, wct);
        }
        if (wct.linkPrev) {
            if (this.lastBackwardWay != Integer.MIN_VALUE && this.lastForwardWay != Integer.MIN_VALUE) {
                this.determineOnewayConnectionType(con, m, i, wct);
                if (!wct.linkPrev) {
                    this.firstGroupIdx = i;
                }
            }
            if (lastWct != null && !RelationSortUtils.isOneway(m)) {
                wct.direction = this.determineDirection(i - 1, lastWct.direction, i);
                boolean bl = wct.linkPrev = wct.direction != WayConnectionType.Direction.NONE;
            }
        }
        if (!wct.linkPrev) {
            wct.direction = this.determineDirectionOfFirst(i, m);
            if (RelationSortUtils.isOneway(m)) {
                wct.isOnewayLoopForwardPart = true;
                this.lastForwardWay = i;
            }
        }
        wct.linkNext = false;
        if (lastWct != null) {
            lastWct.linkNext = wct.linkPrev;
        }
        if (lastWct != null && i > 0 && m.getMember() instanceof Way && this.members.get(i - 1).getMember() instanceof Way && (m.getWay().isOneway() != 0 || this.members.get(i - 1).getWay().isOneway() != 0)) {
            Way way = m.getWay();
            Way previousWay = this.members.get(i - 1).getWay();
            if (way.isOneway() != 0 && previousWay.isOneway() != 0 && way.firstNode(true) != previousWay.lastNode(true) && way.lastNode(true) != previousWay.firstNode(true)) {
                wct.onewayFollowsPrevious = false;
                lastWct.onewayFollowsNext = false;
            } else if (way.isOneway() != 0 && previousWay.isOneway() == 0 && previousWay.isFirstLastNode(way.lastNode(true))) {
                wct.onewayFollowsPrevious = false;
            }
        }
        con.set(i, wct);
        return wct;
    }

    private void handleOneway(WayConnectionType lastWct, int i, WayConnectionType wct) {
        if (lastWct != null && lastWct.isOnewayTail) {
            wct.isOnewayHead = true;
        }
        if (this.lastBackwardWay == Integer.MIN_VALUE && this.lastForwardWay == Integer.MIN_VALUE) {
            wct.isOnewayHead = true;
            this.lastForwardWay = i - 1;
            this.lastBackwardWay = i - 1;
            this.onewayBeginning = true;
        }
    }

    private void makeLoopIfNeeded(List<WayConnectionType> con, int i) {
        boolean loop = false;
        if (i == this.firstGroupIdx) {
            loop = this.determineDirection(i, WayConnectionType.Direction.FORWARD, i) == WayConnectionType.Direction.FORWARD;
        } else if (i >= 0) {
            boolean bl = loop = this.determineDirection(i, con.get((int)i).direction, this.firstGroupIdx) == con.get((int)this.firstGroupIdx).direction;
        }
        if (loop) {
            for (int j = this.firstGroupIdx; j <= i; ++j) {
                con.get((int)j).isLoop = true;
            }
        }
    }

    private WayConnectionType.Direction determineDirectionOfFirst(int i, RelationMember m) {
        WayConnectionType.Direction result = RelationSortUtils.roundaboutType(m);
        if (result != WayConnectionType.Direction.NONE) {
            return result;
        }
        if (RelationSortUtils.isOneway(m)) {
            if (RelationSortUtils.isBackward(m)) {
                return WayConnectionType.Direction.BACKWARD;
            }
            return WayConnectionType.Direction.FORWARD;
        }
        if (this.determineDirection(i, WayConnectionType.Direction.FORWARD, i + 1) != WayConnectionType.Direction.NONE) {
            return WayConnectionType.Direction.FORWARD;
        }
        if (this.determineDirection(i, WayConnectionType.Direction.BACKWARD, i + 1) != WayConnectionType.Direction.NONE) {
            return WayConnectionType.Direction.BACKWARD;
        }
        return WayConnectionType.Direction.NONE;
    }

    private void determineOnewayConnectionType(List<WayConnectionType> con, RelationMember m, int i, WayConnectionType wct) {
        WayConnectionType.Direction dirBW;
        WayConnectionType.Direction dirFW = this.determineDirection(this.lastForwardWay, con.get((int)this.lastForwardWay).direction, i);
        if (this.onewayBeginning) {
            dirBW = this.lastBackwardWay < 0 ? this.determineDirection(this.firstGroupIdx, WayConnectionTypeCalculator.reverse(con.get((int)this.firstGroupIdx).direction), i, true) : this.determineDirection(this.lastBackwardWay, con.get((int)this.lastBackwardWay).direction, i, true);
            if (dirBW != WayConnectionType.Direction.NONE) {
                this.onewayBeginning = false;
            }
        } else {
            dirBW = this.determineDirection(this.lastBackwardWay, con.get((int)this.lastBackwardWay).direction, i, true);
        }
        if (RelationSortUtils.isOneway(m)) {
            if (dirBW != WayConnectionType.Direction.NONE) {
                wct.direction = dirBW;
                this.lastBackwardWay = i;
                wct.isOnewayLoopBackwardPart = true;
            }
            if (dirFW != WayConnectionType.Direction.NONE) {
                wct.direction = dirFW;
                this.lastForwardWay = i;
                wct.isOnewayLoopForwardPart = true;
            }
            if (dirFW == WayConnectionType.Direction.NONE && dirBW == WayConnectionType.Direction.NONE) {
                wct.linkPrev = false;
                if (RelationSortUtils.isOneway(m)) {
                    wct.isOnewayHead = true;
                    this.lastForwardWay = i - 1;
                    this.lastBackwardWay = i - 1;
                } else {
                    this.lastForwardWay = Integer.MIN_VALUE;
                    this.lastBackwardWay = Integer.MIN_VALUE;
                }
                this.onewayBeginning = true;
            }
            if (dirFW != WayConnectionType.Direction.NONE && dirBW != WayConnectionType.Direction.NONE) {
                if (i + 1 < this.members.size() && this.determineDirection(i, dirFW, i + 1) != WayConnectionType.Direction.NONE) {
                    wct.isOnewayLoopBackwardPart = false;
                    wct.direction = dirFW;
                } else {
                    wct.isOnewayLoopForwardPart = false;
                    wct.direction = dirBW;
                }
                wct.isOnewayTail = true;
            }
        } else {
            this.lastForwardWay = Integer.MIN_VALUE;
            this.lastBackwardWay = Integer.MIN_VALUE;
            if (dirFW == WayConnectionType.Direction.NONE || dirBW == WayConnectionType.Direction.NONE) {
                wct.linkPrev = false;
            }
        }
    }

    private static WayConnectionType.Direction reverse(WayConnectionType.Direction dir) {
        if (dir == WayConnectionType.Direction.FORWARD) {
            return WayConnectionType.Direction.BACKWARD;
        }
        if (dir == WayConnectionType.Direction.BACKWARD) {
            return WayConnectionType.Direction.FORWARD;
        }
        return dir;
    }

    private WayConnectionType.Direction determineDirection(int refI, WayConnectionType.Direction refDirection, int k) {
        return this.determineDirection(refI, refDirection, k, false);
    }

    private WayConnectionType.Direction determineDirection(int refI, WayConnectionType.Direction refDirection, int k, boolean reversed) {
        if (this.members == null || refI < 0 || k < 0 || refI >= this.members.size() || k >= this.members.size() || refDirection == WayConnectionType.Direction.NONE) {
            return WayConnectionType.Direction.NONE;
        }
        RelationMember mRef = this.members.get(refI);
        RelationMember m = this.members.get(k);
        Way wayRef = null;
        Way way = null;
        if (mRef.isWay()) {
            wayRef = mRef.getWay();
        }
        if (m.isWay()) {
            way = m.getWay();
        }
        if (wayRef == null || way == null) {
            return WayConnectionType.Direction.NONE;
        }
        List<Node> refNodes = new ArrayList<Node>();
        switch (refDirection) {
            case FORWARD: {
                refNodes.add(wayRef.lastNode());
                break;
            }
            case BACKWARD: {
                refNodes.add(wayRef.firstNode());
                break;
            }
            case ROUNDABOUT_LEFT: 
            case ROUNDABOUT_RIGHT: {
                refNodes = wayRef.getNodes();
                break;
            }
        }
        for (Node n : refNodes) {
            if (n == null) continue;
            if (RelationSortUtils.roundaboutType(this.members.get(k)) != WayConnectionType.Direction.NONE) {
                for (Node nn : way.getNodes()) {
                    if (n != nn) continue;
                    return RelationSortUtils.roundaboutType(this.members.get(k));
                }
                continue;
            }
            if (RelationSortUtils.isOneway(m)) {
                if (n == RelationNodeMap.firstOnewayNode(m) && !reversed) {
                    if (RelationSortUtils.isBackward(m)) {
                        return WayConnectionType.Direction.BACKWARD;
                    }
                    return WayConnectionType.Direction.FORWARD;
                }
                if (!reversed || n != RelationNodeMap.lastOnewayNode(m)) continue;
                if (RelationSortUtils.isBackward(m)) {
                    return WayConnectionType.Direction.FORWARD;
                }
                return WayConnectionType.Direction.BACKWARD;
            }
            if (n == way.firstNode()) {
                return WayConnectionType.Direction.FORWARD;
            }
            if (n != way.lastNode()) continue;
            return WayConnectionType.Direction.BACKWARD;
        }
        return WayConnectionType.Direction.NONE;
    }

    public void clear() {
        this.members = null;
    }
}

